//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

// Defaut values
hmin = 200.e3;
hmax = 800.e3;
logscale = 0;

desc_param = list(..
   CL_defParam("Altitude - min", hmin, units=['m', 'km'], id='$hmin', valid='$hmin>=0' ),..
   CL_defParam("Altitude - max", hmax, units=['m', 'km'], id='$hmax', valid='$hmax>$hmin' ),..
   CL_defParam("Logarithmic scale (0=No, 1=Yes)", logscale, accv=0:1)..
);

[hmin,hmax,logscale] = CL_inputParam(desc_param);

nbpts = 200;
alt = linspace(hmin,hmax,nbpts);

tab_percentile = [ 1, 5, 33, 67, 95, 99, 100 ];
Nc = length(tab_percentile);

tab_ro = [];
for percentile = tab_percentile
  [ro] = CL_mod_expDensity(alt,percentile);
  tab_ro = [tab_ro ; ro];
end

// -----------------------------------------------------------
// plot
// -----------------------------------------------------------

f=scf();
f.visible="off";
f.immediate_drawing="off";

f.color_map = jetcolormap(Nc);

Coul1 = 3;
Coul2 = 11;
Coul3 = 2;
Noir = addcolor([1,1,1]*0);
Gris = addcolor([1,1,1]*0.8);
GrisF = addcolor([1,1,1]*0.3);

a=gca();


for k = 1 : Nc
   plot2d(alt/1000,tab_ro(k,:),style=k);
end

a.axes_bounds = [0.05, -0.03, 0.95, 1.05];
tab_logflags = [ "nnn", "nln"]; 
a.log_flags = tab_logflags(logscale+1);  

CL_g_legend(a, string(tab_percentile), header="Percentile level");

// general setting
titre = "Density (kg/m^3)" ;
CL_g_stdaxes(a, colg=GrisF);
a.data_bounds = [hmin/1000,min(tab_ro);hmax/1000,max(tab_ro)];
a.tight_limits="on";
a.title.text = titre;
a.x_label.text = 'Altitude (km)';
a.y_label.text = 'Density (kg/m^3)';

// adjustments
h = CL_g_select(a, "Polyline");
h.thickness=2;


f.immediate_drawing="on";
f.visible="on";




