.\" t
.\" Copyright © 2005-2010  Roger Leigh <rleigh@debian.org>
.\" Copyright © 2006       Andreas Bombe <aeb@debian.org>
.\"
.\" schroot is free software: you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" schroot is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <http://www.gnu.org/licenses/>.
.\"
.so config.man
.TH SCHROOT 1 "\*[RELEASE_DATE]" "Version \*[VERSION]" "Debian sbuild"
.SH NAME
schroot \- securely enter a chroot environment
.SH SYNOPSIS
.B schroot
.RB [ \-h \[or] \-\-help " \[or] " \-V \[or] \-\-version
.RB " \[or] " \-l \[or] \-\-list " \[or] " \-i \[or] \-\-info
.RB " \[or] " \-\-config " \[or] " \-\-location
.RB " \[or] " \-\-automatic\-session
.RB " \[or] " \-b \[or] \-\-begin\-session " \[or] " \-\-recover\-session
.RB " \[or] " \-r \[or] \-\-run\-session " \[or] " \-e \[or] \-\-end\-session ]
.RB [ \-f \[or] "\-\-force" ]
.RB [ "\-n \fIsession-name\fP" \[or] "\-\-session\-name=\fIsession-name\fP" ]
.RB [ "\-d \fIdirectory\fP" \[or] "\-\-directory=\fIdirectory\fP" ]
.RB [ "\-u \fIuser\fP" \[or] "\-\-user=\fIuser\fP" ]
.RB [ \-p \[or] \-\-preserve\-environment ]
.RB [ \-q \[or] \-\-quiet " \[or] " \-v \[or] \-\-verbose ]
.RB [ "\-c \fIchroot\fP" \[or] "\-\-chroot=\fIchroot\fP"
.RB " \[or] " \-\-all " \[or] " \-\-all\-chroots " \[or] " \-\-all\-source\-chroots " \[or] " \-\-all\-sessions ]
.RB [ \-\- ]
.RB [ COMMAND " [ " ARG1 " [ " ARG2 " [ " ARGn ]]]]
.SH DESCRIPTION
\fBschroot\fP allows the user to run a command or a login shell in a chroot
environment.  If no command is specified, a login shell will be started in the
user's current working directory inside the chroot.
.PP
The command is a program, plus as many optional arguments as required.  Each
argument may be separately quoted.
.PP
The directory the command or login shell is run in depends upon the context.
See \fI\-\-directory\fP option below for a complete description.
.PP
All chroot usage will be logged in the system logs.  Under some circumstances,
the user may be required to authenticate themselves; see the section
\[lq]\fIAuthentication\fP\[rq], below.
.PP
If no chroot is specified, the chroot name or alias \[oq]default\[cq] will be
used as a fallback.  This is equivalent to \[lq]\-\-chroot=default\[rq].
.SH OVERVIEW
There is often a need to run programs in a virtualised environment rather than
on the host system directly.  Unlike other virtualisation systems such as
\fBkvm\fP or \fPXen\fP, schroot does not virtualise the entire system; it only
virtualises the filesystem, and some parts of the filesystem may still be
shared with the host.  It is therefore fast, lightweight and flexible.
However, it does not virtualise other aspects of the system, such as shared
memory, networking, devices etc., and so may be less secure than other systems,
depending upon its intended use.  Some examples of existing uses for schroot
include:
.IP \[bu]
Running an untrusted program in a sandbox, so that it can't interfere with
files on the host system; this may also be used to limit the damage a
compromised service can inflict upon the host
.IP \[bu]
Using a \fIdefined\fP or \fIclean\fP environment, to guarantee the
reproducibility and integrity of a given task
.IP \[bu]
Using different versions of an operating system, or even different operating
systems altogether, e.g. different GNU/Linux distributions
.IP \[bu]
Running 32-bit programs using a 32-bit chroot on a 64-bit host system
.IP \[bu]
Automatic building of Debian packages using
.BR sbuild (1),
which builds each package in a pristine chroot snapshot when using LVM
snapshots or unions
.IP \[bu]
Supporting multiple system images in a cluster setup, where modifying the base
image is time-consuming and/or supporting all the required configurations
needed by users is difficult: different chroots can support all the different
configurations required, and cluster users may be given access to the chroots
they need (which can include root access for trusted users to maintain their
own images)
.PP
A chroot may be used directly as root by running
.BR chroot (8),
but normal users are not able to use this command.  \fBschroot\fP allows access
to chroots for normal users using the same mechanism, but with permissions
checking and allowing additional automated setup of the chroot environment,
such as mounting additional filesystems and other configuration tasks.  This
automated setup is done through the action of \fIsetup scripts\fP which may be
customised and extended to perform any actions required.
.SH OPTIONS
\fBschroot\fP accepts the following options:
.SS Actions
.TP
.BR \-h ", " \-\-help
Show help summary.
.TP
.BR \-V ", " \-\-version
Print version information.
.TP
.BR \-l ", " \-\-list
List all available chroots.
.TP
.BR \-i ", " \-\-info
Print detailed information about the specified chroots.
.TP
.BR \-\-config
Print configuration of the specified chroots.  This is useful for testing that
the configuration in use is the same as the configuration file.  Any comments
in the original file will be missing.
.TP
.BR \-\-location
Print location (path) of the specified chroots.  Note that chroot types which
can only be used within a session will not have a location until they are
active.
.SS General options
.TP
.BR \-q ", " \-\-quiet
Print only essential messages.
.TP
.BR \-v ", " \-\-verbose
Print all messages.
.SS Chroot selection
.TP
.BR \-c ", " \-\-chroot=\fIchroot\fP
Specify a chroot or active session to use.  This option may be used multiple
times to specify more than one chroot, in which case its effect is similar to
\fI\-\-all\fP.  The chroot name may be prefixed with a \fInamespace\fP; see the
section \[lq]\fIChroot Namespaces\fP\[rq], below.
.TP
.BR \-a ", " \-\-all
Select all chroots, source chroots and active sessions.  When a command has
been specified, the command will be run in all chroots, source chroots and
active sessions.  If \fI\-\-info\fP has been used, display information about
all chroots.  This option does not make sense to use with a login shell (when
no command has been specified).  This option is equivalent to
\[lq]\-\-all\-chroots \-\-all\-source\-chroots \-\-all\-sessions\[rq].
.TP
.BR \-\-all\-chroots
Select all chroots.  Identical to \fI\-\-all\fP, except that source chroots and
active sessions are not considered.
.TP
.BR \-\-all\-sessions
Select all active sessions.  Identical to \fI\-\-all\fP, except that chroots
and source chroots are not considered.
.TP
.BR \-\-all\-source\-chroots
Select all source chroots.  Identical to \fI\-\-all\fP, except that chroots
and sessions are not considered.
.SS Chroot environment
.TP
.BR \-d ", " \-\-directory=\fIdirectory\fP
Change to \fIdirectory\fP inside the chroot before running the command or login
shell.  If \fIdirectory\fP is not available, schroot will exit with an error
status.
.IP
The default behaviour is as follows (all directory paths are inside the
chroot).  A login shell is run in the current working directory.  If this is
not available, it will try $HOME (when \fI\-\-preserve\-environment\fP is
used), then the user's home directory, and \fI/\fP inside the chroot in turn.
A command is always run in the current working directory inside the chroot.  If
none of the directories are available, schroot will exit with an error status.
.TP
.BR \-u ", " \-\-user=\fIuser\fP
Run as a different user.  The default is to run as the current user.  If
required, the user may be required to authenticate themselves with a password.
For further information, see the section \[lq]\fIAuthentication\fP\[rq], below.
.TP
.BR \-p ", " \-\-preserve\-environment
Preserve the user's environment inside the chroot environment.  The default is
to use a clean environment; this option copies the entire user environment and
sets it in the session.  The environment variables allowed are subject to
certain restrictions; see the section \[lq]\fIEnvironment\fP\[rq], below.
.SS Session actions
.TP
.BR \-\-automatic\-session
Begin, run and end a session automatically.  This is the default action, so
does not require specifying in normal operation.
.TP
.BR \-b ", " \-\-begin\-session
Begin a session.  A unique session identifier (session ID) is returned on
standard output.  The session ID is required to use the other session options.
Note that the session identifier may be specified with the
\fI\-\-session\-name\fP option.
.TP
.BR \-\-recover\-session
Recover an existing session.  If an existing session has become unavailable,
for example becoming unmounted due to a reboot, this option will make the
session available for use again, for example by remounting it.  The session ID
is specified with the \fI\-\-chroot\fP option.
.TP
.BR \-r ", " \-\-run\-session
Run an existing session.  The session ID is specified with the \fI\-\-chroot\fP
option.
.TP
.BR \-e ", " \-\-end\-session
End an existing session.  The session ID is specified with the \fI\-\-chroot\fP
option.
.SS Session options
.TP
.BR \-n ", " \-\-session\-name=\fIsession-name\fP
Name a session.  The specified \fIsession-name\fP replaces the default session
name containing an automatically-generated session ID.  The session name must
not contain a namespace qualifier, since sessions are always created within the
\[oq]session:\[cq] namespace.  The session name is also subject to the chroot
naming restrictions documented in
.BR schroot.conf (5).
.TP
.BR \-f ", " \-\-force
Force a session operation, even if it would otherwise fail.  This may be used
to forcibly end a session, even if it has active users.  This does not
guarantee that the session will be ended cleanly; filesystems may not be
unmounted, for example.
.SS Separator
.TP
.BR \-\-
End of options.  Used to indicate the end of the schroot options; any following
options will be passed to the command being run, rather than to schroot.
.SH AUTHENTICATION
If the user is not an allowed user, or a member of the allowed groups (or if
changing to root, the allowed root users or allowed root groups) for the
specified chroot(s), permission will be immediately denied.  If switching
users, and the user running the command has access, the user will be required
to authenticate themselves using the credentials of the user being switched to.
.PP
On systems supporting Pluggable Authentication Modules (PAM), schroot will use
PAM for authentication and authorisation of users.  If and when required,
schroot will prompt for a password.  If PAM is not available, all
authentication will automatically fail (user switching is \fInot\fP supported
without PAM).
.PP
Note that when PAM is in use, the root user is not granted any special
privileges by default in the program.  However, the default PAM configuration
permits root to log in without a password (\fIpam_rootok.so\fP), but this may
be disabled to prevent root from accessing any chroots except if specifically
permitted.  In such a situation, root must be added to the allowed users or
groups as for any other user or group.  If PAM is not available, the root user
will be permitted to access all chroots, even when not explicitly granted
access.
.SH CHROOT NAMESPACES
.SS Namespace basics
There are three different types of chroot: regular chroots, source chroots and
session chroots.  These different types of chroot are separated into different
\fInamespaces\fP.  A namespace is a prefix to a chroot name.  Currently there
are three namespaces: \[oq]chroot:\[cq], \[oq]source:\[cq] and
\[oq]session:\[cq].  Use \fI\-\-list \-\-all\fP to list all available chroots
in all namespaces.  Because \[oq]:\[cq] is used as the separator between
namespace and chroot names, it is not permitted to use this character in chroot
names.
.PP
Depending upon the action you request schroot to take, it may look for the
chroot in one of the three namespaces, or a particular namespace may be
specified.  For example, a chroot named \[lq]sid\[rq] is actually named
\[lq]chroot:sid\[rq] if the namespace is included, but the namespace may be
omitted for most actions.
.SS Source chroots
Some chroot types, for example LVM snapshots and Btrfs snapshots, provide
session-managed copy-on-write snapshots of the chroot.  These also provide a
\fIsource chroot\fP to allow easy access to the filesystem used as a source for
snapshotting.  These are regular chroots as well, just with the snapshotting
disabled.  For a chroot named \[lq]sid\-snapshot\[rq] (i.e. with a fully
qualified name of \[lq]chroot:sid\-snapshot\[rq]), there will also be a
corresponding source chroot named \[lq]source:sid\-snapshot\[rq].  Earlier
versions of schroot provided source chroots with a \[oq]\-source\[cq] suffix.
These are also provided for compatibility.  In this example, this would be
called \[lq]chroot:sid\-snapshot\-source\[rq].  These compatibility names will
be dropped in a future version, so programs and scripts should switch to using
the namespace-qualified names rather than the old suffix.
.SS Session chroots
All sessions created with \fI\-\-begin\-session\fP are placed within the
\[oq]session:\[cq] namespace.  A session named with \fI\-\-session\-name\fP may
have any name, even the same name as the chroot it was created from, providing
that it is unique within this namespace.  This was not permitted in previous
versions of schroot which did not have namespaces.
.SS Actions and default namespaces
All actions use \[oq]chroot:\[cq] as the default namespace, with some session
actions being the exception.  \fI\-\-run\-session\fP,
\fI\-\-recover\-session\fP and \fI\-\-end\-session\fP use \[oq]session:\[cq] as
the default namespace instead, since these actions work on session chroots.
The upshot is that the namespace is usually never required except when you need
to work with a chroot in a namespace other than the default, such as when using
a source chroot.  To make chroot selection unambiguous, it is always possible
to use the full name including the namespace, even when not strictly required.
.SH PERFORMANCE
.PP
Performance on some filesystems, for example Btrfs, is bad when running dpkg
due to the amount of fsync operations performed.  This may be mitigated by
installing the eatmydata package and then adding eatmydata to the
\f[CI]command\-prefix\fP configuration key, which disables all fsync
operations.  Note that this should only be done in snapshot chroots where data
loss is not an issue.  This is useful when using a chroot for package building,
for example.
.SH DIRECTORY FALLBACKS
.PP
schroot will select an appropriate directory to use within the chroot based
upon whether an interactive login shell will be used, or a command invoked, and
additionally if the \fI\-\-directory\fP option is used.  In the case of running
commands directly, or explicitly specifying a directory, only one directory
will be used for safety and consistency, while for a login shell several
possibilities may be tried.  The following subsections list the fallback
sequence for each case.  CWD is the current working directory, DIR is the
directory specified with \fI\-\-directory\fP.
.SS Login shell
.TS
box;
l|lw(4i).
Transition
(Host \[->] Chroot)	Comment
_
CWD \[->] CWD	T{
Normal behaviour (if \fI\-\-directory\fP is not used)
T}
CWD \[->] $HOME	T{
If CWD is nonexistent and \-\-preserve\-environment is used
T}
CWD \[->] passwd pw_dir	T{
If CWD is nonexistent (or \-\-preserve\-environment is used and no $HOME exists)
T}
CWD \[->] /	T{
None of the above exist
T}
\fBFAIL\fP	T{
If / is nonexistent
T}
.TE
.SS Command
.TS
box;
l|lw(4i).
Transition
(Host \[->] Chroot)	Comment
_
CWD \[->] CWD	T{
Normal behaviour (if \fI\-\-directory\fP is not used)
T}
\fBFAIL\fP	T{
If CWD is nonexistent
T}
.TE
.PP
No fallbacks should exist under any circumstances.
.SS \-\-directory used
.TS
box;
l|lw(4i).
Transition
(Host \[->] Chroot)	Comment
_
CWD \[->] DIR	Normal behaviour
\fBFAIL\fP	If DIR is nonexistent
.TE
.PP
No fallbacks should exist under any circumstances.
.SS Debugging
.PP
Note that \fI\-\-debug=notice\fP will show the internal fallback list computed
for the session.
.SH EXAMPLES
.SS List available chroots
.EX
% \f[CB]schroot \-l\fP\[CR]
chroot:default
chroot:etch
chroot:sid
chroot:testing
chroot:unstable
.EE
.SS Get information about a chroot
.EX
% \f[CB]schroot \-i \-c sid\fP\[CR]
  \[em]\[em]\[em] Chroot \[em]\[em]\[em]
  Name                   sid
  Description            Debian sid (unstable)
  Type                   plain
  Priority               3
  Users                  rleigh
  Groups                 sbuild
  Root Users
  Root Groups            sbuild
  Aliases                unstable unstable\-sbuild unstable\-p
owerpc\-sbuild
  Environment Filter     ^(BASH_ENV|CDPATH|ENV|HOSTALIASES|I\\
FS|KRB5_CONFIG|KRBCONFDIR|KRBTKFILE|KRB_CONF|LD_.*|LOCALDOMA\\
IN|NLSPATH|PATH_LOCALE|RES_OPTIONS|TERMINFO|TERMINFO_DIRS|TE\\
RMPATH)$
  Run Setup Scripts      true
  Script Configuration   script\-defaults
  Session Managed        true
  Personality            linux32
  Location               /srv/chroot/sid
.EE
.LP
Use \fI\-\-all\fP or \fI\-c\fP multiple times to use all or multiple chroots,
respectively.
.SS Running commands in a chroot
.EX
% \f[CB]schroot \-c sid /bin/ls\fP\[CR]
[sid chroot] Running command: \[lq]/bin/ls\[rq]
CVS          sbuild\-chroot.c   sbuild\-session.h  schroot.conf.5
Makefile     sbuild\-chroot.h   schroot.1         schroot.conf.5.in
Makefile.am  sbuild\-config.c   schroot.1.in
Makefile.in  sbuild\-config.h   schroot.c
pam          sbuild\-session.c  schroot.conf
% \f[CB]schroot \-c sid \-\- ls \-1 | head \-n 5\fP\[CR]
[sid chroot] Running command: \[lq]ls \-1\[rq]
ABOUT\-NLS
AUTHORS
COPYING
ChangeLog
INSTALL
.EE
.LP
Use \fI\-\-\fP to allow options beginning with \[oq]\-\[cq] or \[oq]\-\-\[cq]
in the command to run in the chroot.  This prevents them being interpreted as
options for schroot itself.  Note that the top line was echoed to standard
error, and the remaining lines to standard output.  This is intentional, so
that program output from commands run in the chroot may be piped and redirected
as required; the data will be the same as if the command was run directly on
the host system.
.SS Switching users
.EX
% \f[CB]schroot \-c sid \-u root\fP\[CR]
Password:
[sid chroot] (rleigh\[->]root) Running login shell: \[lq]/bin/bash\[rq]
# 
.EE
.LP
If the user \[oq]rleigh\[cq] was in \f[CI]root\-users\fP in
\fI\*[SCHROOT_CONF]\fP, or one of the groups he belonged to was in
\f[CI]root\-groups\fP, they would be granted root access without
authentication, but the PAM authorisation step is still applied.
.SS Sessions
A chroot may be needed to run more than one command.  In particular, where the
chroot is created on the fly from an LVM LV or a file on disc, there is a need
to make the chroot persistent while a given task (or set of tasks) is
performed.  Sessions exist for this purpose.  For simple chroot types such as
\[oq]plain\[cq] and \[oq]directory\[cq], sessions may be created but are not
strictly necessary.
.PP
Let's start by looking at a session-capable chroot:
.PP
.EX
% \f[CB]schroot \-i \-c sid\-snap\fP\[CR]
  \[em]\[em]\[em] Chroot \[em]\[em]\[em]
  Name                   sid\-snap
  Description            Debian sid snapshot
  Type                   lvm\-snapshot
  Priority               3
  Users                  maks rleigh
  Groups                 sbuild
  Root Users
  Root Groups            root sbuild
  Aliases
  Environment Filter     ^(BASH_ENV|CDPATH|ENV|HOSTALIASES|I\\
FS|KRB5_CONFIG|KRBCONFDIR|KRBTKFILE|KRB_CONF|LD_.*|LOCALDOMA\\
IN|NLSPATH|PATH_LOCALE|RES_OPTIONS|TERMINFO|TERMINFO_DIRS|TE\\
RMPATH)$
  Run Setup Scripts      true
  Script Configuration   script\-defaults
  Session Managed        true
  Personality            linux
  Device                 /dev/hda_vg/sid_chroot
  Mount Options          \-o atime,async,user_xattr
  Source Users
  Source Groups          root rleigh
  Source Root Users
  Source Root Groups     root rleigh
  LVM Snapshot Options   \-\-size 2G \-c 128
.EE
.PP
Note that the \fISession Managed\fP option is set to \[oq]true\[cq].  This is a
requirement in order to use session management, and is supported by most chroot
types.  Next, we will create a new session:
.PP
.EX
% \f[CB]schroot \-b \-c sid\-snap\fP\[CR]
sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f
.EE
.PP
The session ID of the newly-created session is returned on standard output.  It
is common to store it like this:
.PP
.EX
% \f[CB]SESSION=$(schroot \-b \-c sid\-snap)\fP\[CR]
% \f[CB]echo $SESSION\fP\[CR]
sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f
.EE
.PP
The session may be used just like any normal chroot.  This is what the session
looks like:
.PP
.EX
% \f[CB]schroot \-i \-c sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f\fP\[CR]
  \[em]\[em]\[em] Session \[em]\[em]\[em]
  Name                   sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d\\
4ccc899f0f
  Description            Debian sid snapshot
  Type                   lvm\-snapshot
  Priority               3
  Users                  maks rleigh
  Groups                 sbuild
  Root Users
  Root Groups            root sbuild
  Aliases
  Environment Filter     ^(BASH_ENV|CDPATH|ENV|HOSTALIASES|I\\
FS|KRB5_CONFIG|KRBCONFDIR|KRBTKFILE|KRB_CONF|LD_.*|LOCALDOMA\\
IN|NLSPATH|PATH_LOCALE|RES_OPTIONS|TERMINFO|TERMINFO_DIRS|TE\\
RMPATH)$
  Run Setup Scripts      true
  Script Configuration   script\-defaults
  Session Managed        true
  Personality            linux
  Mount Location         /var/lib/schroot/mount/sid\-snap\-461\\
95b04\-0893\-49bf\-beb8\-0d4ccc899f0f
  Path                   /var/lib/schroot/mount/sid\-snap\-461\\
95b04\-0893\-49bf\-beb8\-0d4ccc899f0f
  Mount Device           /dev/hda_vg/sid\-snap\-46195b04\-0893\-\\
49bf\-beb8\-0d4ccc899f0f
  Device                 /dev/hda_vg/sid_chroot
  Mount Options          \-o atime,async,user_xattr
  Source Users
  Source Groups          root rleigh
  Source Root Users
  Source Root Groups     root rleigh
  LVM Snapshot Device    /dev/hda_vg/sid\-snap\-46195b04\-0893\-\\
49bf\-beb8\-0d4ccc899f0f
  LVM Snapshot Options   \-\-size 2G \-c 128
.EE
.PP
Now the session has been created, commands may be run in it:
.PP
.EX
% \f[CB]schroot \-r \-c sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f \-\- \\
  uname \-sr\fP\[CR]
I: [sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f chroot] Running \\
command: \[lq]uname \-sr\[rq]
Linux 2.6.18\-3\-powerpc
% \f[CB]schroot \-r \-c $SESSION \-\- uname \-sr\fP\[CR]
I: [sid\-snap\-fe170af9\-d9be\-4800\-b1bd\-de275858b938 chroot] Running \\
command: \[lq]uname \-sr\[rq]
Linux 2.6.18\-3\-powerpc
.EE
.PP
When all the commands to run in the session have been performed, the session
may be ended:
.PP
.EX
\f[CR]% \f[CB]schroot \-e \-c sid\-snap\-46195b04\-0893\-49bf\-beb8\-0d4ccc899f0f\fP\fP\[CR]
\f[CR]% \f[CB]schroot \-e \-c $SESSION\fP\fP\[CR]
.EE
.PP
Finally, the session names can be long and unwieldy.  A name may be specified
instead of using the automatically generated session ID:
.PP
.EX
\f[CR]% \f[CB]schroot \-b \-c sid\-snap \-n my\-session\-name\fP\fP\[CR]
\f[CR]my\-session\-name\fP
.EE
.SH TROUBLESHOOTING
If something is not working, and it's not clear from the error messages what is
wrong, try using the \fB\-\-debug=\fP\fIlevel\fP option to turn on debugging
messages.  This gives a great deal more information.  Valid debug levels are
\[oq]none\[cq], and \[oq]notice\[cq], \[oq]info\[cq], \[oq]warning\[cq] and
\[oq]critical\[cq] in order of increasing severity.  The lower the severity
level, the more output.
.PP
If you are still having trouble, the developers may be contacted on the mailing
list:
.br
\f[CR]Debian\ buildd-tools\ Developers
.br
<buildd-tools-devel@lists.alioth.debian.org>\fP
.SH BUGS
On the \fBmips\fP and \fBmipsel\fP architectures, Linux kernels up to and
including at least version 2.6.17 have broken
.BR personality (2)
support, which results in a failure to set the personality.  This will be seen
as an \[lq]Operation not permitted\[rq] (EPERM) error.  To work around this
problem, set \f[CI]personality\fP to \[oq]undefined\[cq], or upgrade to a more
recent kernel.
.SH ENVIRONMENT
By default, the environment is not preserved, and the following environment
variables are defined: HOME, LOGNAME, PATH, SHELL, TERM (preserved if already
defined), and USER.  The environment variables SCHROOT_COMMAND, SCHROOT_USER,
SCHROOT_GROUP, SCHROOT_UID and SCHROOT_GID are set inside the chroot specifying
the command being run, the user name, group name, user ID and group ID,
respectively.  Additionally, the environment variables SCHROOT_SESSION_ID,
SCHROOT_CHROOT_NAME and SCHROOT_ALIAS_NAME specify the session ID, the original
chroot name prior to session creation, and the alias used to originally
identify the selected chroot, respectively.
.PP
The following, potentially dangerous, environment variables are removed for
safety by default: BASH_ENV, CDPATH, ENV, HOSTALIASES, IFS, KRB5_CONFIG,
KRBCONFDIR, KRBTKFILE, KRB_CONF, LD_.*, LOCALDOMAIN, NLSPATH, PATH_LOCALE,
RES_OPTIONS, TERMINFO, TERMINFO_DIRS, and TERMPATH.  If desired, the
\f[CI]environment\-filter\fP configuration key will allow the exclusion list to
the modified; see
.BR schroot.conf (5)
for further details.
.SH FILES
.SS Configuration files
.TP
\f[BI]\*[SCHROOT_CONF]\fP
The system-wide chroot definition file.  This file must be owned by the root
user, and not be writable by other.
.TP
\f[BI]\*[SCHROOT_CONF_CHROOT_D]\fP
Additional chroot definitions may be placed in files under this directory.
They are treated in exactly that same manner as \fI\*[SCHROOT_CONF]\fP.  Each
file may contain one or more chroot definitions.  Note that the files in this
directory follow the same naming rules as
.BR run\-parts (8)
when run with the \fI\-\-lsbsysinit\fP option.
.TP
\f[BI]\*[SCHROOT_CONF_SETUP_D]\fP
The system-wide chroot setup script directories.  See
.BR schroot-setup (5).
.TP
\f[BI]/etc/pam.d/schroot\fP
PAM configuration.
.SS System directories
.TP
\f[BI]\*[SCHROOT_LIBEXEC_DIR]\fP
Directory containing helper programs used by setup scripts.
.SS Session directories
Each directory contains a directory or file with the name of each session.  Not
all chroot types make use of all the following directories.
.TP
\f[BI]\*[SCHROOT_SESSION_DIR]\fP
Directory containing the session configuration for each active session.
.TP
\f[BI]\*[SCHROOT_MOUNT_DIR]\fP
Directory used to mount the filesystems used by each active session.
.TP
\f[BI]\*[SCHROOT_UNDERLAY_DIR]\fP
Directory used for filesystem union source (underlay).
.TP
\f[BI]\*[SCHROOT_OVERLAY_DIR]\fP
Directory used for filesystem union writeable overlay.
.TP
\f[BI]\*[SCHROOT_FILE_UNPACK_DIR]\fP
Directory used for unpacking file chroots.
.so authors.man
.so copyright.man
.SH SEE ALSO
.BR dchroot (1),
.BR sbuild (1),
.BR chroot (2),
.BR run\-parts (8),
.BR schroot\-setup (5),
.BR schroot\-faq (7),
.BR schroot.conf (5).
.\"#
.\"# The following sets edit modes for GNU EMACS
.\"# Local Variables:
.\"# mode:nroff
.\"# fill-column:79
.\"# End:
