/*
 * scamper_target.h
 *
 * $Id: scamper_target.h,v 1.3 2005/03/01 08:07:29 mjl Exp $
 *
 * Copyright (C) 2005 The University of Waikato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __SCAMPER_TARGET_H
#define __SCAMPER_TARGET_H

struct scamper_addr;
struct scamper_task;

typedef struct scamper_target
{
  struct scamper_addr *addr; /* the target address being probed */
  struct scamper_task *task; /* the task currently assigned */
} scamper_target_t;

/*
 * simple routines to allocate and free targets
 * when a target is allocated, it goes into the tree of targets.  if
 * there is already a target with the same address in the tree, then
 * it refuses to allocate another.
 * when the target is freed, it frees any tasks associated with the
 * target.
 */
scamper_target_t *scamper_target_alloc(struct scamper_addr *addr);
void scamper_target_free(scamper_target_t *target);

/* given a target address, find a target structure */
scamper_target_t *scamper_target_find(struct scamper_addr *addr);

/* return the number of targets in the tree */
int scamper_target_count(void);

int scamper_targets_init(void);
void scamper_targets_cleanup(void);

#endif /* __SCAMPER_TARGET_H */
