/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.ksecurity.Certificate;
import com.sun.ksecurity.KeyStore;
import com.sun.kssl.SSLStreamConnection;
import com.sun.kssl.X509Certificate;
import com.sun.midp.publickeystore.PublicKeyInfo;
import com.sun.midp.publickeystore.PublicKeyStore;
import com.sun.midp.publickeystore.WebAliasEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class WebPublicKeyStore
extends PublicKeyStore
implements KeyStore {
    private static WebPublicKeyStore trustedKeyStore;
    private PublicKeyStore extension;

    public static void setTrustedKeyStore(WebPublicKeyStore keyStore) {
        if (trustedKeyStore != null) {
            return;
        }
        trustedKeyStore = keyStore;
        SSLStreamConnection.setTrustedKeyStore(keyStore);
        SSLStreamConnection.lockTrustedKeyStore();
    }

    public static WebPublicKeyStore getTrustedKeyStore() {
        return trustedKeyStore;
    }

    public WebPublicKeyStore(InputStream in) throws IOException {
        super(in);
    }

    public void ExtendKeyStore(PublicKeyStore theExtension) {
        if (this.extension != null) {
            return;
        }
        this.extension = theExtension;
    }

    public Enumeration aliases() {
        Enumeration extAliases = null;
        if (this.extension != null) {
            extAliases = this.extension.getOwners();
        }
        return new WebAliasEnum(this.getOwners(), extAliases);
    }

    public Certificate getCertificate(String alias) {
        return WebPublicKeyStore.createCertificate(this.findKey(alias));
    }

    public boolean containsAlias(String alias) {
        return this.findKey(alias) != null;
    }

    public int size() {
        int size = super.numberOfKeys();
        if (this.extension == null) {
            return size;
        }
        return size + this.extension.numberOfKeys();
    }

    public String getType() {
        return "KSSLKS";
    }

    public synchronized PublicKeyInfo findKey(String alias) {
        PublicKeyInfo keyInfo = super.findKey(alias);
        if (keyInfo != null) {
            return keyInfo;
        }
        if (this.extension == null) {
            return null;
        }
        return this.extension.findKey(alias);
    }

    /*
     * WARNING - void declaration
     */
    static X509Certificate createCertificate(PublicKeyInfo keyInfo) {
        if (keyInfo == null) {
            return null;
        }
        try {
            void e;
            X509Certificate cert = new X509Certificate(1, keyInfo.getOwner(), keyInfo.getOwner(), keyInfo.getNotBefore(), keyInfo.getNotAfter(), keyInfo.getModulus(), keyInfo.getExponent(), null, 0);
            return e;
        }
        catch (Exception e) {
            return null;
        }
    }
}

