#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc GroupCreate {} {
    global current
    global group

    if {$current(frame) != {}} {
	set name [$current(frame) get marker tag default name]
	if [EntryDialog {New Group} {Enter Group Name} 30 name] {
	    $current(frame) marker tag "\{$name\}"
	    UpdateGroupDialog
	}
    }
}

proc GroupCreateSilent {} {
    global current
    global group

    if {$current(frame) != {}} {
	set name [$current(frame) get marker tag default name]
	$current(frame) marker tag "\{$name\}"
	UpdateGroupDialog
    }
}

proc GroupDialog {} {
    global ds9
    global group
    global menu

    # see if we already have a window visible
    if [winfo exist $group(top)] {
	raise $group(top)
	return
    }

    set w $group(top)
    set title "Region Groups"

    # create the window
    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW GroupDestroyDialog

    $w configure -menu $group(mb)

    menu $group(mb) -tearoff 0
    $group(mb) add cascade -label File -menu $group(mb).file

    menu $group(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $group(mb).file add command -label "Update Group" \
	-command GroupUpdateDialog
    $group(mb).file add separator
    $group(mb).file add command -label "New Group" \
	-command GroupCreate
    $group(mb).file add command -label "Edit Group Name" \
	-command GroupEditDialog
    $group(mb).file add separator
    $group(mb).file add command -label "Delete Group" \
	-command GroupDeleteDialog
    $group(mb).file add command -label "Delete All Groups" \
	-command GroupDeleteAllDialog
    $group(mb).file add separator
    $group(mb).file add command -label "Close" \
	-command GroupDestroyDialog

    frame $w.frame -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.frame $w.buttons -side top -fill both -expand 1 -ipadx 4 -ipady 4

    scrollbar $w.frame.scroll -command "$w.frame.list yview"
    listbox $w.frame.list -yscroll "$w.frame.scroll set" \
	-width 25 -height 15 -setgrid 1 -selectmode single
    pack $w.frame.list -side left -fill both -expand 1
    pack $w.frame.scroll -side left -fill y -expand 1

    button $w.buttons.update -text "Update" -command GroupUpdateDialog
    button $w.buttons.close -text "Close" -command GroupDestroyDialog
    pack $w.buttons.update $w.buttons.close -side left -expand true -padx 10

    bind $w.frame.list <ButtonRelease-1> GroupButtonDialog

    UpdateGroupDialog
}

proc GroupButtonDialog {} {
    global group
    global current

    set w $group(top)

    if {$current(frame) != {}} {
	set i [$w.frame.list curselection]
	if {[string length $i] != 0} {
#	    $current(frame) marker tag select "\{[$w.frame.list get $i]\}"
	    $current(frame) marker "\{[$w.frame.list get $i]\}" select only
	}
    }
}

proc GroupDestroyDialog {} {
    global group

    if {[winfo exist $group(top)]} {
	destroy $group(top)
	destroy $group(mb)
    }
}

proc GroupUpdateDialog {} {
    global group
    global current

    set w $group(top)

    if {$current(frame) != {}} {
	set i [$w.frame.list curselection]
	if {[string length $i] != 0} {
	    $current(frame) marker tag update "\{[$w.frame.list get $i]\}"
	}
    }
}

proc GroupEditDialog {} {
    global group
    global current
    
    set w $group(top)

    if {$current(frame) != {}} {
	set i [$w.frame.list curselection]
	if {[string length $i] != 0} {
	    set which [$w.frame.list get $i]
	    if [EntryDialog {Group Name} {Enter Group Name:} 40 which] {
		$current(frame) marker tag edit \
		    "\{[$w.frame.list get $i]\}" "\{$which\}"
		UpdateGroupDialog
	    }
	}
    }
}

proc GroupDeleteDialog {} {
    global group
    global current

    set w $group(top)

    if {$current(frame) != {}} {
	set i [$w.frame.list curselection]
	if {[string length $i] != 0} {
	    set which [$w.frame.list get $i]
	    if {[tk_messageBox -type okcancel -default cancel \
		     -message "Delete Group $which?" \
		     -icon question] == "ok"} {
		$current(frame) marker tag delete "\{$which\}"
		UpdateGroupDialog
	    }
	}
    }
}

proc GroupDeleteAllDialog {} {
    global current

    if {$current(frame) != {}} {
	if {[tk_messageBox -type okcancel -default cancel \
		 -message "Delete All Groups?" \
		 -icon question] == "ok"} {
	    $current(frame) marker tag delete all
	    UpdateGroupDialog
	}
    }
}

proc UpdateGroupDialog {} {
    global current
    global group

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateGroupDialog"
    }

    if {[winfo exist $group(top)]} {
	set w $group(top)

	# clear the list
	$w.frame.list delete 0 end

	if {$current(frame) != {}} {
	    set grps [lsort [$current(frame) get marker tag all]]
	    foreach f $grps {
		$w.frame.list insert end $f
	    }
	}
    }
}
