#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc PandaDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base panda dialog
    MarkerBasePandaDialog $frame $id 275 150

    # Radius
    label $w.ref.left.bottom.f.innerTitle -text "Inner"
    label $w.ref.left.bottom.f.outerTitle -text "Outer"
    label $w.ref.left.bottom.f.radiusTitle -text "Radius"
    entry $w.ref.left.bottom.f.inner -textvariable marker($frame,$id,inner) \
	-width 13
    entry $w.ref.left.bottom.f.outer -textvariable marker($frame,$id,outer) \
	-width 13
    label $w.ref.left.bottom.f.radiusformat \
	-textvariable marker($frame,$id,dlabel) \
	-relief groove -width 9 -padx 4
    label $w.ref.left.bottom.f.annuliTitle -text "Annuli"
    entry $w.ref.left.bottom.f.annuli -textvariable marker($frame,$id,annuli) \
	-width 13

    grid x $w.ref.left.bottom.f.innerTitle $w.ref.left.bottom.f.outerTitle  \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.radiusTitle $w.ref.left.bottom.f.inner \
	$w.ref.left.bottom.f.outer $w.ref.left.bottom.f.radiusformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.annuliTitle $w.ref.left.bottom.f.annuli \
	-padx 4 -sticky w

    # init - do this last
    PandaDistCB $frame $id
}

# actions

proc PandaClose {frame id} {
    MarkerBasePandaClose $frame $id
}

proc PandaApply {frame id} {
    MarkerBasePandaApply $frame $id
}

proc PandaGenerate {frame id} {
    MarkerBaseAnnulusGenerateCircle $frame $id
    MarkerBasePandaGenerateAngles $frame $id
}

# callbacks

proc PandaCoordCB {frame id} {
    MarkerBasePandaCoordCB $frame $id
}

proc PandaEditCB {frame id} {
    global marker

    set t \
	[$frame get marker $id panda radius \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set last [expr [llength $t]-1]
    set marker($frame,$id,inner) [lindex $t 0]
    set marker($frame,$id,outer) [lindex $t $last]
    set marker($frame,$id,annuli) $last

    $marker($frame,$id,annulitxt) delete 1.0 end
    $marker($frame,$id,annulitxt) insert end "$t"

    set a [$frame get marker $id panda angle \
	       $marker($frame,$id,system) $marker($frame,$id,sky)]

    set last [expr [llength $a]-1]
    set marker($frame,$id,ang1) [lindex $a 0]
    set marker($frame,$id,ang2) [lindex $a $last]
    set marker($frame,$id,angnum) $last

    $marker($frame,$id,angtxt) delete 1.0 end
    $marker($frame,$id,angtxt) insert end "$a"
}

proc PandaDistCB {frame id} {
    MarkerBasePandaDistCB $frame $id
}

proc PandaDefaultDialog {} {
    global marker
    global ed

    set w ".panda"

    set ed(ok) 0
    set ed(inner) $marker(panda,inner)
    set ed(outer) $marker(panda,outer)
    set ed(annuli) $marker(panda,annuli)
    set ed(ang1) $marker(panda,ang1)
    set ed(ang2) $marker(panda,ang2)
    set ed(angnum) $marker(panda,angnum)

    DialogCreate $w "Default Panda" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.innerTitle -text "Inner"
    label $w.ed.outerTitle -text "Outer"
    label $w.ed.radiusTitle -text "Radius"
    entry $w.ed.inner -textvariable ed(inner) -width 10
    entry $w.ed.outer -textvariable ed(outer) -width 10
    label $w.ed.unit -text "image" -relief groove -width 8
    label $w.ed.annuliTitle -text "Annuli"
    entry $w.ed.annuli -textvariable ed(annuli) -width 10
    
    grid x $w.ed.innerTitle $w.ed.outerTitle -padx 4 -sticky w
    grid $w.ed.radiusTitle $w.ed.inner $w.ed.outer $w.ed.unit -padx 4 -sticky w
    grid $w.ed.annuliTitle $w.ed.annuli -padx 4 -sticky w

    label $w.ed.ang1Title -text "Start"
    label $w.ed.ang2Title -text "Stop"
    label $w.ed.angTitle -text "Angles"
    entry $w.ed.ang1 -textvariable ed(ang1) -width 10
    entry $w.ed.ang2 -textvariable ed(ang2) -width 10
    label $w.ed.angunit -text "degrees" -relief groove -width 8
    label $w.ed.angnumTitle -text "Number"
    entry $w.ed.angnum -textvariable ed(angnum) -width 10
    
    grid x $w.ed.ang1Title $w.ed.ang2Title -padx 4 -sticky w
    grid $w.ed.angTitle $w.ed.ang1 $w.ed.ang2 $w.ed.angunit -padx 4 -sticky w
    grid $w.ed.angnumTitle $w.ed.angnum -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.inner select range 0 end
    DialogWait $w ed(ok) $w.ed.inner
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(panda,inner) $ed(inner)
	set marker(panda,outer) $ed(outer)
	set marker(panda,annuli) $ed(annuli)
	set marker(panda,ang1) $ed(ang1)
	set marker(panda,ang2) $ed(ang2)
	set marker(panda,angnum) $ed(angnum)
    }

    unset ed
}
