/*
*+
*  Name:
*     fspecframe.c

*  Purpose:
*     Define a FORTRAN 77 interface to the AST SpecFrame class.

*  Type of Module:
*     C source file.

*  Description:
*     This file defines FORTRAN 77-callable C functions which provide
*     a public FORTRAN 77 interface to the SpecFrame class.

*  Routines Defined:
*     AST_ISASPECFRAME
*     AST_SPECFRAME
*     AST_SETREFPOS
*     AST_GETREFPOS

*  Copyright:
*     Copyright (C) 2004 Central Laboratory of the Research Councils

*  Authors:
*     DSB: David S. Berry (Starlink)

*  History:
*     20-NOV-2002 (DSB):
*        Original version.
*/

/* Define the astFORTRAN77 macro which prevents error messages from
   AST C functions from reporting the file and line number where the
   error occurred (since these would refer to this file, they would
   not be useful). */
#define astFORTRAN77

/* Header files. */
/* ============= */
#include "f77.h"                 /* FORTRAN <-> C interface macros (SUN/209) */
#include "c2f77.h"               /* F77 <-> C support functions/macros */
#include "error.h"               /* Error reporting facilities */
#include "memory.h"              /* Memory handling facilities */
#include "specframe.h"           /* C interface to the SpecFrame class */

F77_LOGICAL_FUNCTION(ast_isaspecframe)( INTEGER(THIS),
                                       INTEGER(STATUS) ) {
   GENPTR_INTEGER(THIS)
   F77_LOGICAL_TYPE(RESULT);

   astAt( "AST_ISASPECFRAME", NULL, 0 );
   astWatchSTATUS(
      RESULT = astIsASpecFrame( astI2P( *THIS ) ) ? F77_TRUE : F77_FALSE;
   )
   return RESULT;
}

F77_INTEGER_FUNCTION(ast_specframe)( CHARACTER(OPTIONS),
                                    INTEGER(STATUS)
                                    TRAIL(OPTIONS) ) {
   GENPTR_CHARACTER(OPTIONS)
   F77_INTEGER_TYPE(RESULT);
   int i;
   char *options;

   astAt( "AST_SPECFRAME", NULL, 0 );
   astWatchSTATUS(
      options = astString( OPTIONS, OPTIONS_length );

/* Change ',' to '\n' (see AST_SET in fobject.c for why). */
      if ( astOK ) {
         for ( i = 0; options[ i ]; i++ ) {
            if ( options[ i ] == ',' ) options[ i ] = '\n';
         }
      }
      RESULT = astP2I( astSpecFrame( "%s", options ) );
      astFree( options );
   )
   return RESULT;
}

F77_SUBROUTINE(ast_getrefpos)( INTEGER(THIS),
                               INTEGER(FRM),
                               DOUBLE(LON),
                               DOUBLE(LAT),
                               INTEGER(STATUS) ) {
   GENPTR_INTEGER(THIS)
   GENPTR_INTEGER(FRM)
   GENPTR_DOUBLE(LON)
   GENPTR_DOUBLE(LAT)

   astAt( "AST_GETREFPOS", NULL, 0 );
   astWatchSTATUS(
      astGetRefPos( astI2P( *THIS ), astI2P( *FRM ), LON, LAT );
   )
}

F77_SUBROUTINE(ast_setrefpos)( INTEGER(THIS),
                               INTEGER(FRM),
                               DOUBLE(LON),
                               DOUBLE(LAT),
                               INTEGER(STATUS) ) {
   GENPTR_INTEGER(THIS)
   GENPTR_INTEGER(FRM)
   GENPTR_DOUBLE(LON)
   GENPTR_DOUBLE(LAT)

   astAt( "AST_SETREFPOS", NULL, 0 );
   astWatchSTATUS(
      astSetRefPos( astI2P( *THIS ), astI2P( *FRM ), *LON, *LAT );
   )
}

