/* 
 *  Unix SMB/CIFS implementation.
 *  DOS error routines
 *  Copyright (C) Tim Potter 2002.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* DOS error codes.  please read doserr.h */

#include "includes.h"

struct werror_code_struct {
	const char *dos_errstr;
	WERROR werror;
};

static const struct werror_code_struct dos_errs[] =
{
	{ "WERR_OK", WERR_OK },
	{ "WERR_BADFILE", WERR_BADFILE },
	{ "WERR_ACCESS_DENIED", WERR_ACCESS_DENIED },
	{ "WERR_BADFID", WERR_BADFID },
	{ "WERR_BADFUNC", WERR_BADFUNC },
	{ "WERR_BAD_NETPATH", WERR_BAD_NETPATH },
	{ "WERR_BAD_NET_RESP",  WERR_BAD_NET_RESP },
	{ "WERR_UNEXP_NET_ERR", WERR_UNEXP_NET_ERR },
	{ "WERR_INSUFFICIENT_BUFFER", WERR_INSUFFICIENT_BUFFER },
	{ "WERR_SEM_TIMEOUT", WERR_SEM_TIMEOUT },
	{ "WERR_NO_SUCH_SHARE", WERR_NO_SUCH_SHARE },
	{ "WERR_FILE_EXISTS", WERR_FILE_EXISTS },
	{ "WERR_INVALID_PARAM", WERR_INVALID_PARAM },
	{ "WERR_NOT_SUPPORTED", WERR_NOT_SUPPORTED },
	{ "WERR_DUP_NAME", WERR_DUP_NAME },
	{ "WERR_BAD_PASSWORD", WERR_BAD_PASSWORD },
	{ "WERR_NOMEM", WERR_NOMEM },
	{ "WERR_INVALID_NAME", WERR_INVALID_NAME },
	{ "WERR_UNKNOWN_LEVEL", WERR_UNKNOWN_LEVEL },
	{ "WERR_OBJECT_PATH_INVALID", WERR_OBJECT_PATH_INVALID },
	{ "WERR_ALREADY_EXISTS", WERR_ALREADY_EXISTS },
	{ "WERR_NO_MORE_ITEMS", WERR_NO_MORE_ITEMS },
	{ "WERR_MORE_DATA", WERR_MORE_DATA },
	{ "WERR_UNKNOWN_PRINTER_DRIVER", WERR_UNKNOWN_PRINTER_DRIVER },
	{ "WERR_UNKNOWN_PRINTPROCESSOR", WERR_UNKNOWN_PRINTPROCESSOR },
	{ "WERR_INVALID_SEPARATOR_FILE", WERR_INVALID_SEPARATOR_FILE },
	{ "WERR_INVALID_PRIORITY", WERR_INVALID_PRIORITY },
	{ "WERR_UNKNOWN_PORT", WERR_UNKNOWN_PORT },
	{ "WERR_INVALID_PRINTER_NAME", WERR_INVALID_PRINTER_NAME },
	{ "WERR_PRINTER_ALREADY_EXISTS", WERR_PRINTER_ALREADY_EXISTS },
	{ "WERR_INVALID_DATATYPE", WERR_INVALID_DATATYPE },
	{ "WERR_INVALID_ENVIRONMENT", WERR_INVALID_ENVIRONMENT },
	{ "WERR_INVALID_FORM_NAME", WERR_INVALID_FORM_NAME },
	{ "WERR_INVALID_FORM_SIZE", WERR_INVALID_FORM_SIZE },
	{ "WERR_ALREADY_SHARED", WERR_ALREADY_SHARED },
	{ "WERR_BUF_TOO_SMALL", WERR_BUF_TOO_SMALL },
	{ "WERR_JOB_NOT_FOUND", WERR_JOB_NOT_FOUND },
	{ "WERR_DEST_NOT_FOUND", WERR_DEST_NOT_FOUND },
	{ "WERR_GROUPNOTFOUND", WERR_GROUPNOTFOUND },
	{ "WERR_USER_NOT_FOUND", WERR_USER_NOT_FOUND },
	{ "WERR_NOT_LOCAL_DOMAIN", WERR_NOT_LOCAL_DOMAIN },
	{ "WERR_DOMAIN_CONTROLLER_NOT_FOUND", WERR_DOMAIN_CONTROLLER_NOT_FOUND },
	{ "WERR_TIME_DIFF_AT_DC", WERR_TIME_DIFF_AT_DC },
	{ "WERR_SETUP_NOT_JOINED", WERR_SETUP_NOT_JOINED },
	{ "WERR_SETUP_ALREADY_JOINED", WERR_SETUP_ALREADY_JOINED },
	{ "WERR_SETUP_DOMAIN_CONTROLLER", WERR_SETUP_DOMAIN_CONTROLLER },
	{ "WERR_DEVICE_NOT_AVAILABLE", WERR_DEVICE_NOT_AVAILABLE },
	{ "WERR_DEFAULT_JOIN_REQUIRED", WERR_DEFAULT_JOIN_REQUIRED },
	{ "WERR_USEREXISTS", WERR_USEREXISTS },
	{ "WERR_REVISION_MISMATCH", WERR_REVISION_MISMATCH },
	{ "WERR_NO_LOGON_SERVERS", WERR_NO_LOGON_SERVERS },
	{ "WERR_NO_SUCH_LOGON_SESSION", WERR_NO_SUCH_LOGON_SESSION },
	{ "WERR_USER_ALREADY_EXISTS", WERR_USER_ALREADY_EXISTS },
	{ "WERR_NO_SUCH_USER", WERR_NO_SUCH_USER },
	{ "WERR_GROUP_EXISTS", WERR_GROUP_EXISTS },
	{ "WERR_NO_SUCH_GROUP", WERR_NO_SUCH_GROUP },
	{ "WERR_MEMBER_IN_GROUP", WERR_MEMBER_IN_GROUP },
	{ "WERR_USER_NOT_IN_GROUP", WERR_USER_NOT_IN_GROUP },
	{ "WERR_PRINTER_DRIVER_IN_USE", WERR_PRINTER_DRIVER_IN_USE },
	{ "WERR_STATUS_MORE_ENTRIES", WERR_STATUS_MORE_ENTRIES },
	{ "WERR_NET_NAME_NOT_FOUND", WERR_NET_NAME_NOT_FOUND },
	{ "WERR_DEVICE_NOT_SHARED", WERR_DEVICE_NOT_SHARED },
	{ "WERR_DFS_NO_SUCH_VOL", WERR_DFS_NO_SUCH_VOL },
	{ "WERR_DFS_NO_SUCH_SHARE", WERR_DFS_NO_SUCH_SHARE },
	{ "WERR_DFS_NO_SUCH_SERVER", WERR_DFS_NO_SUCH_SERVER },
	{ "WERR_DFS_INTERNAL_ERROR", WERR_DFS_INTERNAL_ERROR },
	{ "WERR_DFS_CANT_CREATE_JUNCT", WERR_DFS_CANT_CREATE_JUNCT },
	{ "WERR_LOGON_FAILURE", WERR_LOGON_FAILURE },
	{ "WERR_INVALID_SECURITY_DESCRIPTOR", WERR_INVALID_SECURITY_DESCRIPTOR },
	{ "WERR_INVALID_DOMAIN_ROLE", WERR_INVALID_DOMAIN_ROLE },
	{ "WERR_UNKNOWN_REVISION", WERR_UNKNOWN_REVISION },
	{ "WERR_REVISION_MISMATCH", WERR_REVISION_MISMATCH },
	{ "WERR_INVALID_OWNER", WERR_INVALID_OWNER },
	{ "WERR_INVALID_PRIMARY_GROUP", WERR_INVALID_PRIMARY_GROUP },
	{ "WERR_INVALID_COMPUTERNAME", WERR_INVALID_COMPUTERNAME },
	{ "WERR_INVALID_DOMAINNAME", WERR_INVALID_DOMAINNAME },
	{ "WERR_MACHINE_LOCKED", WERR_MACHINE_LOCKED },
	{ "WERR_DCNOTFOUND", WERR_DCNOTFOUND },
	{ "WERR_NO_LOGON_SERVERS", WERR_NO_LOGON_SERVERS },
	{ "WERR_NO_SUCH_LOGON_SESSION", WERR_NO_SUCH_LOGON_SESSION },
	{ "WERR_NO_SUCH_PRIVILEGE", WERR_NO_SUCH_PRIVILEGE },
	{ "WERR_PRIVILEGE_NOT_HELD", WERR_PRIVILEGE_NOT_HELD },
	{ "WERR_NO_SUCH_USER", WERR_NO_SUCH_USER },
	{ "WERR_NO_SUCH_DOMAIN", WERR_NO_SUCH_DOMAIN },
	{ "WERR_NO_SYSTEM_RESOURCES", WERR_NO_SYSTEM_RESOURCES },
	{ "WERR_DS_NO_ATTRIBUTE_OR_VALUE", WERR_DS_NO_ATTRIBUTE_OR_VALUE },
	{ "WERR_DS_INVALID_ATTRIBUTE_SYNTAX", WERR_DS_INVALID_ATTRIBUTE_SYNTAX },
	{ "WERR_DS_ATTRIBUTE_TYPE_UNDEFINED", WERR_DS_ATTRIBUTE_TYPE_UNDEFINED },
	{ "WERR_DS_ATTRIBUTE_OR_VALUE_EXISTS", WERR_DS_ATTRIBUTE_OR_VALUE_EXISTS },
	{ "WERR_DS_BUSY", WERR_DS_BUSY },
	{ "WERR_DS_UNAVAILABLE", WERR_DS_UNAVAILABLE },
	{ "WERR_DS_OBJ_CLASS_VIOLATION", WERR_DS_OBJ_CLASS_VIOLATION },
	{ "WERR_DS_CANT_ON_NON_LEAF", WERR_DS_CANT_ON_NON_LEAF },
	{ "WERR_DS_CANT_ON_RDN", WERR_DS_CANT_ON_RDN },
	{ "WERR_DS_CANT_MOD_OBJ_CLASS", WERR_DS_CANT_MOD_OBJ_CLASS },
	{ "WERR_DS_OPERATIONS_ERROR", WERR_DS_OPERATIONS_ERROR },
	{ "WERR_DS_PROTOCOL_ERROR", WERR_DS_PROTOCOL_ERROR },
	{ "WERR_DS_TIMELIMIT_EXCEEEDED", WERR_DS_TIMELIMIT_EXCEEDED },
	{ "WERR_DS_SIZE_LIMIT_EXCEEDED", WERR_DS_SIZE_LIMIT_EXCEEDED },
	{ "WERR_DS_ADMIN_LIMIT_EXCEEEDED", WERR_DS_ADMIN_LIMIT_EXCEEDED },
	{ "WERR_DS_COMPARE_FALSE", WERR_DS_COMPARE_FALSE },
	{ "WERR_DS_COMPARE_TRUE", WERR_DS_COMPARE_TRUE },
	{ "WERR_DS_AUTH_METHOD_NOT_SUPPORTED", WERR_DS_AUTH_METHOD_NOT_SUPPORTED },
	{ "WERR_DS_STRONG_AUTH_REQUIRED", WERR_DS_STRONG_AUTH_REQUIRED },
	{ "WERR_DS_INAPPROPRIATE_AUTH", WERR_DS_INAPPROPRIATE_AUTH },
	{ "WERR_DS_REFERRAL", WERR_DS_REFERRAL },
	{ "WERR_DS_UNAVAILABLE_CRIT_EXTENSION", WERR_DS_UNAVAILABLE_CRIT_EXTENSION },
	{ "WERR_DS_CONFIDENTIALITY_REQUIRED", WERR_DS_CONFIDENTIALITY_REQUIRED },
	{ "WERR_DS_INAPPROPRIATE_MATCHING", WERR_DS_INAPPROPRIATE_MATCHING },
	{ "WERR_DS_CONSTRAINT_VIOLATION", WERR_DS_CONSTRAINT_VIOLATION },
	{ "WERR_DS_NO_SUCH_OBJECT", WERR_DS_NO_SUCH_OBJECT },
	{ "WERR_DS_ALIAS_PROBLEM", WERR_DS_ALIAS_PROBLEM },
	{ "WERR_DS_INVALID_DN_SYNTAX", WERR_DS_INVALID_DN_SYNTAX },
	{ "WERR_DS_ALIAS_DEREF_PROBLEM", WERR_DS_ALIAS_DEREF_PROBLEM },
	{ "WERR_DS_UNWILLING_TO_PERFORM", WERR_DS_UNWILLING_TO_PERFORM },
	{ "WERR_DS_LOOP_DETECT", WERR_DS_LOOP_DETECT },
	{ "WERR_DS_NAMING_VIOLATION", WERR_DS_NAMING_VIOLATION },
	{ "WERR_DS_AFFECTS_MULTIPLE_DSAS", WERR_DS_AFFECTS_MULTIPLE_DSAS },
	{ "WERR_DS_OBJ_STRING_NAME_EXISTS", WERR_DS_OBJ_STRING_NAME_EXISTS },
	{ "WERR_DS_OBJ_NOT_FOUND", WERR_DS_OBJ_NOT_FOUND },
	{ "WERR_DS_GENERIC_ERROR", WERR_DS_GENERIC_ERROR },
	{ "WERR_DS_INSUFF_ACCESS_RIGHTS", WERR_DS_INSUFF_ACCESS_RIGHTS },
	{ "WERR_DS_SCHEMA_NOT_LOADED", WERR_DS_SCHEMA_NOT_LOADED },
	{ "WERR_DS_SCHEMA_ALLOC_FAILED", WERR_DS_SCHEMA_ALLOC_FAILED },
	{ "WERR_DS_ATT_SCHEMA_REQ_SYNTAX", WERR_DS_ATT_SCHEMA_REQ_SYNTAX },
	{ "WERR_DS_DRA_SCHEMA_MISMATCH", WERR_DS_DRA_SCHEMA_MISMATCH },
	{ "WERR_DS_DRA_INVALID_PARAMETER", WERR_DS_DRA_INVALID_PARAMETER },
	{ "WERR_DS_DRA_BAD_DN", WERR_DS_DRA_BAD_DN },
	{ "WERR_DS_DRA_BAD_NC", WERR_DS_DRA_BAD_NC },
	{ "WERR_DS_DRA_INTERNAL_ERROR", WERR_DS_DRA_INTERNAL_ERROR },
	{ "WERR_DS_DRA_OUT_OF_MEM", WERR_DS_DRA_OUT_OF_MEM },
	{ "WERR_DS_SINGLE_VALUE_CONSTRAINT", WERR_DS_SINGLE_VALUE_CONSTRAINT },
	{ "WERR_DS_DRA_DB_ERROR", WERR_DS_DRA_DB_ERROR },
	{ "WERR_DS_DRA_NO_REPLICA", WERR_DS_DRA_NO_REPLICA },
	{ "WERR_DS_DRA_ACCESS_DENIED", WERR_DS_DRA_ACCESS_DENIED },
	{ "WERR_DS_DRA_SOURCE_DISABLED", WERR_DS_DRA_SOURCE_DISABLED },
	{ "WERR_DS_DNS_LOOKUP_FAILURE", WERR_DS_DNS_LOOKUP_FAILURE },
	{ "WERR_DS_WRONG_LINKED_ATTRIBUTE_SYNTAX", WERR_DS_WRONG_LINKED_ATTRIBUTE_SYNTAX },
	{ "WERR_DS_NO_MSDS_INTID", WERR_DS_NO_MSDS_INTID },
	{ "WERR_DS_DUP_MSDS_INTID", WERR_DS_DUP_MSDS_INTID },
	{ "WERR_GENERAL_FAILURE", WERR_GENERAL_FAILURE },
	{ "WERR_PRINTQ_FULL", WERR_PRINTQ_FULL },
	{ "WERR_NO_SPOOL_SPACE", WERR_NO_SPOOL_SPACE },
	{ "WERR_CAN_NOT_COMPLETE", WERR_CAN_NOT_COMPLETE },
	{ "WERR_INVALID_FLAGS", WERR_INVALID_FLAGS },
	{ "WERR_DEVICE_NOT_CONNECTED", WERR_DEVICE_NOT_CONNECTED },
	{ "WERR_NOT_FOUND", WERR_NOT_FOUND },
	{ "WERR_SERVER_UNAVAILABLE", WERR_SERVER_UNAVAILABLE },
	{ "WERR_INVALID_USER_BUFFER", WERR_INVALID_USER_BUFFER },
	{ "WERR_NO_TRUST_SAM_ACCOUNT", WERR_NO_TRUST_SAM_ACCOUNT },
	{ "WERR_INVALID_PRINTER_COMMAND", WERR_INVALID_PRINTER_COMMAND },
	{ "WERR_NO_SHUTDOWN_IN_PROGRESS", WERR_NO_SHUTDOWN_IN_PROGRESS },
	{ "WERR_SHUTDOWN_ALREADY_IN_PROGRESS", WERR_SHUTDOWN_ALREADY_IN_PROGRESS },
	{ "WERR_SEC_E_ENCRYPT_FAILURE",	WERR_SEC_E_ENCRYPT_FAILURE },
	{ "WERR_SEC_E_DECRYPT_FAILURE",	WERR_SEC_E_DECRYPT_FAILURE },
	{ "WERR_SEC_E_ALGORITHM_MISMATCH", WERR_SEC_E_ALGORITHM_MISMATCH },
	{ "WERR_NOT_AUTHENTICATED", WERR_NOT_AUTHENTICATED },
	{ "WERR_CALL_NOT_IMPLEMENTED", WERR_CALL_NOT_IMPLEMENTED },
	{ "WERR_FRS_INVALID_SERVICE_PARAMETER", WERR_FRS_INVALID_SERVICE_PARAMETER },
	{ "WERR_FRS_SYSVOL_IS_BUSY", WERR_FRS_SYSVOL_IS_BUSY },
	{ "WERR_FRS_INSUFFICIENT_PRIV", WERR_FRS_INSUFFICIENT_PRIV },
	{ "WERR_RPC_E_REMOTE_DISABLED", WERR_RPC_E_REMOTE_DISABLED },
	{ "WERR_NOT_CONNECTED", WERR_NOT_CONNECTED },
	{ "WERR_NAME_NOT_FOUND", WERR_NAME_NOT_FOUND},
	{ "WERR_NONE_MAPPED", WERR_NONE_MAPPED },
	{ "WERR_INVALID_DOMAIN_STATE", WERR_INVALID_DOMAIN_STATE },
	{ "WERR_SPECIAL_ACCOUNT", WERR_SPECIAL_ACCOUNT },
	{ "WERR_ALIAS_EXISTS", WERR_ALIAS_EXISTS },
	{ "WERR_NO_SUCH_ALIAS", WERR_NO_SUCH_ALIAS },
	{ "WERR_MEMBER_IN_ALIAS", WERR_MEMBER_IN_ALIAS },
	{ "WERR_TIME_SKEW", WERR_TIME_SKEW },
	{ "WERR_IO_PENDING", WERR_IO_PENDING },
	{ "WERR_INVALID_SERVICE_CONTROL", WERR_INVALID_SERVICE_CONTROL },
	{ "WERR_SERVICE_ALREADY_RUNNING", WERR_SERVICE_ALREADY_RUNNING },
	{ "WERR_REG_CORRUPT", WERR_REG_CORRUPT },
	{ "WERR_REG_IO_FAILURE", WERR_REG_IO_FAILURE },
	{ "WERR_REG_FILE_INVALID", WERR_REG_FILE_INVALID },
	{ "WERR_NO_SUCH_SERVICE", WERR_NO_SUCH_SERVICE },
	{ "WERR_SERVICE_DISABLED", WERR_SERVICE_DISABLED },
	{ "WERR_SERVICE_MARKED_FOR_DELETE", WERR_SERVICE_MARKED_FOR_DELETE },
	{ "WERR_SERVICE_EXISTS", WERR_SERVICE_EXISTS },
	{ "WERR_SERVICE_NEVER_STARTED", WERR_SERVICE_NEVER_STARTED },
	{ "WERR_DUPLICATE_SERVICE_NAME", WERR_DUPLICATE_SERVICE_NAME },
	{ "WERR_PASSWORD_MUST_CHANGE", WERR_PASSWORD_MUST_CHANGE },
	{ "WERR_ACCOUNT_LOCKED_OUT", WERR_ACCOUNT_LOCKED_OUT },
	{ "WERR_UNKNOWN_PRINT_MONITOR", WERR_UNKNOWN_PRINT_MONITOR },
	{ "WERR_PASSWORD_RESTRICTION", WERR_PASSWORD_RESTRICTION },
	{ "WERR_WRONG_PASSWORD", WERR_WRONG_PASSWORD },
	{ "WERR_CLASS_NOT_REGISTERED", WERR_CLASS_NOT_REGISTERED },
	/*****************************************************************************
	 Auto-generated Win32 error from:
	 http://msdn.microsoft.com/en-us/library/cc231199%28PROT.10%29.aspx
	 *****************************************************************************/
	/* BEGIN GENERATED-WIN32-ERROR-CODES */
	{ "WERR_NERR_SUCCESS", WERR_NERR_SUCCESS },
	{ "WERR_INVALID_FUNCTION", WERR_INVALID_FUNCTION },
	{ "WERR_FILE_NOT_FOUND", WERR_FILE_NOT_FOUND },
	{ "WERR_PATH_NOT_FOUND", WERR_PATH_NOT_FOUND },
	{ "WERR_TOO_MANY_OPEN_FILES", WERR_TOO_MANY_OPEN_FILES },
	{ "WERR_INVALID_HANDLE", WERR_INVALID_HANDLE },
	{ "WERR_ARENA_TRASHED", WERR_ARENA_TRASHED },
	{ "WERR_NOT_ENOUGH_MEMORY", WERR_NOT_ENOUGH_MEMORY },
	{ "WERR_INVALID_BLOCK", WERR_INVALID_BLOCK },
	{ "WERR_BAD_ENVIRONMENT", WERR_BAD_ENVIRONMENT },
	{ "WERR_BAD_FORMAT", WERR_BAD_FORMAT },
	{ "WERR_INVALID_ACCESS", WERR_INVALID_ACCESS },
	{ "WERR_INVALID_DATA", WERR_INVALID_DATA },
	{ "WERR_OUTOFMEMORY", WERR_OUTOFMEMORY },
	{ "WERR_INVALID_DRIVE", WERR_INVALID_DRIVE },
	{ "WERR_CURRENT_DIRECTORY", WERR_CURRENT_DIRECTORY },
	{ "WERR_NOT_SAME_DEVICE", WERR_NOT_SAME_DEVICE },
	{ "WERR_NO_MORE_FILES", WERR_NO_MORE_FILES },
	{ "WERR_WRITE_PROTECT", WERR_WRITE_PROTECT },
	{ "WERR_BAD_UNIT", WERR_BAD_UNIT },
	{ "WERR_NOT_READY", WERR_NOT_READY },
	{ "WERR_BAD_COMMAND", WERR_BAD_COMMAND },
	{ "WERR_CRC", WERR_CRC },
	{ "WERR_BAD_LENGTH", WERR_BAD_LENGTH },
	{ "WERR_SEEK", WERR_SEEK },
	{ "WERR_NOT_DOS_DISK", WERR_NOT_DOS_DISK },
	{ "WERR_SECTOR_NOT_FOUND", WERR_SECTOR_NOT_FOUND },
	{ "WERR_OUT_OF_PAPER", WERR_OUT_OF_PAPER },
	{ "WERR_WRITE_FAULT", WERR_WRITE_FAULT },
	{ "WERR_READ_FAULT", WERR_READ_FAULT },
	{ "WERR_GEN_FAILURE", WERR_GEN_FAILURE },
	{ "WERR_SHARING_VIOLATION", WERR_SHARING_VIOLATION },
	{ "WERR_LOCK_VIOLATION", WERR_LOCK_VIOLATION },
	{ "WERR_WRONG_DISK", WERR_WRONG_DISK },
	{ "WERR_SHARING_BUFFER_EXCEEDED", WERR_SHARING_BUFFER_EXCEEDED },
	{ "WERR_HANDLE_EOF", WERR_HANDLE_EOF },
	{ "WERR_HANDLE_DISK_FULL", WERR_HANDLE_DISK_FULL },
	{ "WERR_REM_NOT_LIST", WERR_REM_NOT_LIST },
	{ "WERR_NETWORK_BUSY", WERR_NETWORK_BUSY },
	{ "WERR_DEV_NOT_EXIST", WERR_DEV_NOT_EXIST },
	{ "WERR_TOO_MANY_CMDS", WERR_TOO_MANY_CMDS },
	{ "WERR_ADAP_HDW_ERR", WERR_ADAP_HDW_ERR },
	{ "WERR_BAD_REM_ADAP", WERR_BAD_REM_ADAP },
	{ "WERR_PRINT_CANCELLED", WERR_PRINT_CANCELLED },
	{ "WERR_NETNAME_DELETED", WERR_NETNAME_DELETED },
	{ "WERR_NETWORK_ACCESS_DENIED", WERR_NETWORK_ACCESS_DENIED },
	{ "WERR_BAD_DEV_TYPE", WERR_BAD_DEV_TYPE },
	{ "WERR_BAD_NET_NAME", WERR_BAD_NET_NAME },
	{ "WERR_TOO_MANY_NAMES", WERR_TOO_MANY_NAMES },
	{ "WERR_TOO_MANY_SESS", WERR_TOO_MANY_SESS },
	{ "WERR_SHARING_PAUSED", WERR_SHARING_PAUSED },
	{ "WERR_REQ_NOT_ACCEP", WERR_REQ_NOT_ACCEP },
	{ "WERR_REDIR_PAUSED", WERR_REDIR_PAUSED },
	{ "WERR_CANNOT_MAKE", WERR_CANNOT_MAKE },
	{ "WERR_FAIL_I24", WERR_FAIL_I24 },
	{ "WERR_OUT_OF_STRUCTURES", WERR_OUT_OF_STRUCTURES },
	{ "WERR_ALREADY_ASSIGNED", WERR_ALREADY_ASSIGNED },
	{ "WERR_INVALID_PASSWORD", WERR_INVALID_PASSWORD },
	{ "WERR_INVALID_PARAMETER", WERR_INVALID_PARAMETER },
	{ "WERR_NET_WRITE_FAULT", WERR_NET_WRITE_FAULT },
	{ "WERR_NO_PROC_SLOTS", WERR_NO_PROC_SLOTS },
	{ "WERR_TOO_MANY_SEMAPHORES", WERR_TOO_MANY_SEMAPHORES },
	{ "WERR_EXCL_SEM_ALREADY_OWNED", WERR_EXCL_SEM_ALREADY_OWNED },
	{ "WERR_SEM_IS_SET", WERR_SEM_IS_SET },
	{ "WERR_TOO_MANY_SEM_REQUESTS", WERR_TOO_MANY_SEM_REQUESTS },
	{ "WERR_INVALID_AT_INTERRUPT_TIME", WERR_INVALID_AT_INTERRUPT_TIME },
	{ "WERR_SEM_OWNER_DIED", WERR_SEM_OWNER_DIED },
	{ "WERR_SEM_USER_LIMIT", WERR_SEM_USER_LIMIT },
	{ "WERR_DISK_CHANGE", WERR_DISK_CHANGE },
	{ "WERR_DRIVE_LOCKED", WERR_DRIVE_LOCKED },
	{ "WERR_BROKEN_PIPE", WERR_BROKEN_PIPE },
	{ "WERR_OPEN_FAILED", WERR_OPEN_FAILED },
	{ "WERR_BUFFER_OVERFLOW", WERR_BUFFER_OVERFLOW },
	{ "WERR_DISK_FULL", WERR_DISK_FULL },
	{ "WERR_NO_MORE_SEARCH_HANDLES", WERR_NO_MORE_SEARCH_HANDLES },
	{ "WERR_INVALID_TARGET_HANDLE", WERR_INVALID_TARGET_HANDLE },
	{ "WERR_INVALID_CATEGORY", WERR_INVALID_CATEGORY },
	{ "WERR_INVALID_VERIFY_SWITCH", WERR_INVALID_VERIFY_SWITCH },
	{ "WERR_BAD_DRIVER_LEVEL", WERR_BAD_DRIVER_LEVEL },
	{ "WERR_INVALID_LEVEL", WERR_INVALID_LEVEL },
	{ "WERR_NO_VOLUME_LABEL", WERR_NO_VOLUME_LABEL },
	{ "WERR_MOD_NOT_FOUND", WERR_MOD_NOT_FOUND },
	{ "WERR_PROC_NOT_FOUND", WERR_PROC_NOT_FOUND },
	{ "WERR_WAIT_NO_CHILDREN", WERR_WAIT_NO_CHILDREN },
	{ "WERR_CHILD_NOT_COMPLETE", WERR_CHILD_NOT_COMPLETE },
	{ "WERR_DIRECT_ACCESS_HANDLE", WERR_DIRECT_ACCESS_HANDLE },
	{ "WERR_NEGATIVE_SEEK", WERR_NEGATIVE_SEEK },
	{ "WERR_SEEK_ON_DEVICE", WERR_SEEK_ON_DEVICE },
	{ "WERR_NOT_SUBSTED", WERR_NOT_SUBSTED },
	{ "WERR_JOIN_TO_JOIN", WERR_JOIN_TO_JOIN },
	{ "WERR_SUBST_TO_SUBST", WERR_SUBST_TO_SUBST },
	{ "WERR_JOIN_TO_SUBST", WERR_JOIN_TO_SUBST },
	{ "WERR_SAME_DRIVE", WERR_SAME_DRIVE },
	{ "WERR_DIR_NOT_ROOT", WERR_DIR_NOT_ROOT },
	{ "WERR_DIR_NOT_EMPTY", WERR_DIR_NOT_EMPTY },
	{ "WERR_IS_SUBST_PATH", WERR_IS_SUBST_PATH },
	{ "WERR_IS_JOIN_PATH", WERR_IS_JOIN_PATH },
	{ "WERR_PATH_BUSY", WERR_PATH_BUSY },
	{ "WERR_IS_SUBST_TARGET", WERR_IS_SUBST_TARGET },
	{ "WERR_SYSTEM_TRACE", WERR_SYSTEM_TRACE },
	{ "WERR_INVALID_EVENT_COUNT", WERR_INVALID_EVENT_COUNT },
	{ "WERR_TOO_MANY_MUXWAITERS", WERR_TOO_MANY_MUXWAITERS },
	{ "WERR_INVALID_LIST_FORMAT", WERR_INVALID_LIST_FORMAT },
	{ "WERR_LABEL_TOO_LONG", WERR_LABEL_TOO_LONG },
	{ "WERR_TOO_MANY_TCBS", WERR_TOO_MANY_TCBS },
	{ "WERR_SIGNAL_REFUSED", WERR_SIGNAL_REFUSED },
	{ "WERR_DISCARDED", WERR_DISCARDED },
	{ "WERR_NOT_LOCKED", WERR_NOT_LOCKED },
	{ "WERR_BAD_THREADID_ADDR", WERR_BAD_THREADID_ADDR },
	{ "WERR_BAD_ARGUMENTS", WERR_BAD_ARGUMENTS },
	{ "WERR_BAD_PATHNAME", WERR_BAD_PATHNAME },
	{ "WERR_SIGNAL_PENDING", WERR_SIGNAL_PENDING },
	{ "WERR_MAX_THRDS_REACHED", WERR_MAX_THRDS_REACHED },
	{ "WERR_LOCK_FAILED", WERR_LOCK_FAILED },
	{ "WERR_BUSY", WERR_BUSY },
	{ "WERR_CANCEL_VIOLATION", WERR_CANCEL_VIOLATION },
	{ "WERR_ATOMIC_LOCKS_NOT_SUPPORTED", WERR_ATOMIC_LOCKS_NOT_SUPPORTED },
	{ "WERR_INVALID_SEGMENT_NUMBER", WERR_INVALID_SEGMENT_NUMBER },
	{ "WERR_INVALID_ORDINAL", WERR_INVALID_ORDINAL },
	{ "WERR_INVALID_FLAG_NUMBER", WERR_INVALID_FLAG_NUMBER },
	{ "WERR_SEM_NOT_FOUND", WERR_SEM_NOT_FOUND },
	{ "WERR_INVALID_STARTING_CODESEG", WERR_INVALID_STARTING_CODESEG },
	{ "WERR_INVALID_STACKSEG", WERR_INVALID_STACKSEG },
	{ "WERR_INVALID_MODULETYPE", WERR_INVALID_MODULETYPE },
	{ "WERR_INVALID_EXE_SIGNATURE", WERR_INVALID_EXE_SIGNATURE },
	{ "WERR_EXE_MARKED_INVALID", WERR_EXE_MARKED_INVALID },
	{ "WERR_BAD_EXE_FORMAT", WERR_BAD_EXE_FORMAT },
	{ "WERR_ITERATED_DATA_EXCEEDS_64K", WERR_ITERATED_DATA_EXCEEDS_64K },
	{ "WERR_INVALID_MINALLOCSIZE", WERR_INVALID_MINALLOCSIZE },
	{ "WERR_DYNLINK_FROM_INVALID_RING", WERR_DYNLINK_FROM_INVALID_RING },
	{ "WERR_IOPL_NOT_ENABLED", WERR_IOPL_NOT_ENABLED },
	{ "WERR_INVALID_SEGDPL", WERR_INVALID_SEGDPL },
	{ "WERR_AUTODATASEG_EXCEEDS_64K", WERR_AUTODATASEG_EXCEEDS_64K },
	{ "WERR_RING2SEG_MUST_BE_MOVABLE", WERR_RING2SEG_MUST_BE_MOVABLE },
	{ "WERR_RELOC_CHAIN_XEEDS_SEGLIM", WERR_RELOC_CHAIN_XEEDS_SEGLIM },
	{ "WERR_INFLOOP_IN_RELOC_CHAIN", WERR_INFLOOP_IN_RELOC_CHAIN },
	{ "WERR_ENVVAR_NOT_FOUND", WERR_ENVVAR_NOT_FOUND },
	{ "WERR_NO_SIGNAL_SENT", WERR_NO_SIGNAL_SENT },
	{ "WERR_FILENAME_EXCED_RANGE", WERR_FILENAME_EXCED_RANGE },
	{ "WERR_RING2_STACK_IN_USE", WERR_RING2_STACK_IN_USE },
	{ "WERR_META_EXPANSION_TOO_LONG", WERR_META_EXPANSION_TOO_LONG },
	{ "WERR_INVALID_SIGNAL_NUMBER", WERR_INVALID_SIGNAL_NUMBER },
	{ "WERR_THREAD_1_INACTIVE", WERR_THREAD_1_INACTIVE },
	{ "WERR_LOCKED", WERR_LOCKED },
	{ "WERR_TOO_MANY_MODULES", WERR_TOO_MANY_MODULES },
	{ "WERR_NESTING_NOT_ALLOWED", WERR_NESTING_NOT_ALLOWED },
	{ "WERR_EXE_MACHINE_TYPE_MISMATCH", WERR_EXE_MACHINE_TYPE_MISMATCH },
	{ "WERR_EXE_CANNOT_MODIFY_SIGNED_BINARY", WERR_EXE_CANNOT_MODIFY_SIGNED_BINARY },
	{ "WERR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY", WERR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY },
	{ "WERR_FILE_CHECKED_OUT", WERR_FILE_CHECKED_OUT },
	{ "WERR_CHECKOUT_REQUIRED", WERR_CHECKOUT_REQUIRED },
	{ "WERR_BAD_FILE_TYPE", WERR_BAD_FILE_TYPE },
	{ "WERR_FILE_TOO_LARGE", WERR_FILE_TOO_LARGE },
	{ "WERR_FORMS_AUTH_REQUIRED", WERR_FORMS_AUTH_REQUIRED },
	{ "WERR_VIRUS_INFECTED", WERR_VIRUS_INFECTED },
	{ "WERR_VIRUS_DELETED", WERR_VIRUS_DELETED },
	{ "WERR_PIPE_LOCAL", WERR_PIPE_LOCAL },
	{ "WERR_BAD_PIPE", WERR_BAD_PIPE },
	{ "WERR_PIPE_BUSY", WERR_PIPE_BUSY },
	{ "WERR_NO_DATA", WERR_NO_DATA },
	{ "WERR_PIPE_NOT_CONNECTED", WERR_PIPE_NOT_CONNECTED },
	{ "WERR_VC_DISCONNECTED", WERR_VC_DISCONNECTED },
	{ "WERR_INVALID_EA_NAME", WERR_INVALID_EA_NAME },
	{ "WERR_EA_LIST_INCONSISTENT", WERR_EA_LIST_INCONSISTENT },
	{ "WERR_WAIT_TIMEOUT", WERR_WAIT_TIMEOUT },
	{ "WERR_CANNOT_COPY", WERR_CANNOT_COPY },
	{ "WERR_DIRECTORY", WERR_DIRECTORY },
	{ "WERR_EAS_DIDNT_FIT", WERR_EAS_DIDNT_FIT },
	{ "WERR_EA_FILE_CORRUPT", WERR_EA_FILE_CORRUPT },
	{ "WERR_EA_TABLE_FULL", WERR_EA_TABLE_FULL },
	{ "WERR_INVALID_EA_HANDLE", WERR_INVALID_EA_HANDLE },
	{ "WERR_EAS_NOT_SUPPORTED", WERR_EAS_NOT_SUPPORTED },
	{ "WERR_NOT_OWNER", WERR_NOT_OWNER },
	{ "WERR_TOO_MANY_POSTS", WERR_TOO_MANY_POSTS },
	{ "WERR_PARTIAL_COPY", WERR_PARTIAL_COPY },
	{ "WERR_OPLOCK_NOT_GRANTED", WERR_OPLOCK_NOT_GRANTED },
	{ "WERR_INVALID_OPLOCK_PROTOCOL", WERR_INVALID_OPLOCK_PROTOCOL },
	{ "WERR_DISK_TOO_FRAGMENTED", WERR_DISK_TOO_FRAGMENTED },
	{ "WERR_DELETE_PENDING", WERR_DELETE_PENDING },
	{ "WERR_MR_MID_NOT_FOUND", WERR_MR_MID_NOT_FOUND },
	{ "WERR_SCOPE_NOT_FOUND", WERR_SCOPE_NOT_FOUND },
	{ "WERR_FAIL_NOACTION_REBOOT", WERR_FAIL_NOACTION_REBOOT },
	{ "WERR_FAIL_SHUTDOWN", WERR_FAIL_SHUTDOWN },
	{ "WERR_FAIL_RESTART", WERR_FAIL_RESTART },
	{ "WERR_MAX_SESSIONS_REACHED", WERR_MAX_SESSIONS_REACHED },
	{ "WERR_THREAD_MODE_ALREADY_BACKGROUND", WERR_THREAD_MODE_ALREADY_BACKGROUND },
	{ "WERR_THREAD_MODE_NOT_BACKGROUND", WERR_THREAD_MODE_NOT_BACKGROUND },
	{ "WERR_PROCESS_MODE_ALREADY_BACKGROUND", WERR_PROCESS_MODE_ALREADY_BACKGROUND },
	{ "WERR_PROCESS_MODE_NOT_BACKGROUND", WERR_PROCESS_MODE_NOT_BACKGROUND },
	{ "WERR_INVALID_ADDRESS", WERR_INVALID_ADDRESS },
	{ "WERR_USER_PROFILE_LOAD", WERR_USER_PROFILE_LOAD },
	{ "WERR_ARITHMETIC_OVERFLOW", WERR_ARITHMETIC_OVERFLOW },
	{ "WERR_PIPE_CONNECTED", WERR_PIPE_CONNECTED },
	{ "WERR_PIPE_LISTENING", WERR_PIPE_LISTENING },
	{ "WERR_VERIFIER_STOP", WERR_VERIFIER_STOP },
	{ "WERR_ABIOS_ERROR", WERR_ABIOS_ERROR },
	{ "WERR_WX86_WARNING", WERR_WX86_WARNING },
	{ "WERR_WX86_ERROR", WERR_WX86_ERROR },
	{ "WERR_TIMER_NOT_CANCELED", WERR_TIMER_NOT_CANCELED },
	{ "WERR_UNWIND", WERR_UNWIND },
	{ "WERR_BAD_STACK", WERR_BAD_STACK },
	{ "WERR_INVALID_UNWIND_TARGET", WERR_INVALID_UNWIND_TARGET },
	{ "WERR_INVALID_PORT_ATTRIBUTES", WERR_INVALID_PORT_ATTRIBUTES },
	{ "WERR_PORT_MESSAGE_TOO_LONG", WERR_PORT_MESSAGE_TOO_LONG },
	{ "WERR_INVALID_QUOTA_LOWER", WERR_INVALID_QUOTA_LOWER },
	{ "WERR_DEVICE_ALREADY_ATTACHED", WERR_DEVICE_ALREADY_ATTACHED },
	{ "WERR_INSTRUCTION_MISALIGNMENT", WERR_INSTRUCTION_MISALIGNMENT },
	{ "WERR_PROFILING_NOT_STARTED", WERR_PROFILING_NOT_STARTED },
	{ "WERR_PROFILING_NOT_STOPPED", WERR_PROFILING_NOT_STOPPED },
	{ "WERR_COULD_NOT_INTERPRET", WERR_COULD_NOT_INTERPRET },
	{ "WERR_PROFILING_AT_LIMIT", WERR_PROFILING_AT_LIMIT },
	{ "WERR_CANT_WAIT", WERR_CANT_WAIT },
	{ "WERR_CANT_TERMINATE_SELF", WERR_CANT_TERMINATE_SELF },
	{ "WERR_UNEXPECTED_MM_CREATE_ERR", WERR_UNEXPECTED_MM_CREATE_ERR },
	{ "WERR_UNEXPECTED_MM_MAP_ERROR", WERR_UNEXPECTED_MM_MAP_ERROR },
	{ "WERR_UNEXPECTED_MM_EXTEND_ERR", WERR_UNEXPECTED_MM_EXTEND_ERR },
	{ "WERR_BAD_FUNCTION_TABLE", WERR_BAD_FUNCTION_TABLE },
	{ "WERR_NO_GUID_TRANSLATION", WERR_NO_GUID_TRANSLATION },
	{ "WERR_INVALID_LDT_SIZE", WERR_INVALID_LDT_SIZE },
	{ "WERR_INVALID_LDT_OFFSET", WERR_INVALID_LDT_OFFSET },
	{ "WERR_INVALID_LDT_DESCRIPTOR", WERR_INVALID_LDT_DESCRIPTOR },
	{ "WERR_TOO_MANY_THREADS", WERR_TOO_MANY_THREADS },
	{ "WERR_THREAD_NOT_IN_PROCESS", WERR_THREAD_NOT_IN_PROCESS },
	{ "WERR_PAGEFILE_QUOTA_EXCEEDED", WERR_PAGEFILE_QUOTA_EXCEEDED },
	{ "WERR_LOGON_SERVER_CONFLICT", WERR_LOGON_SERVER_CONFLICT },
	{ "WERR_SYNCHRONIZATION_REQUIRED", WERR_SYNCHRONIZATION_REQUIRED },
	{ "WERR_NET_OPEN_FAILED", WERR_NET_OPEN_FAILED },
	{ "WERR_IO_PRIVILEGE_FAILED", WERR_IO_PRIVILEGE_FAILED },
	{ "WERR_CONTROL_C_EXIT", WERR_CONTROL_C_EXIT },
	{ "WERR_MISSING_SYSTEMFILE", WERR_MISSING_SYSTEMFILE },
	{ "WERR_UNHANDLED_EXCEPTION", WERR_UNHANDLED_EXCEPTION },
	{ "WERR_APP_INIT_FAILURE", WERR_APP_INIT_FAILURE },
	{ "WERR_PAGEFILE_CREATE_FAILED", WERR_PAGEFILE_CREATE_FAILED },
	{ "WERR_INVALID_IMAGE_HASH", WERR_INVALID_IMAGE_HASH },
	{ "WERR_NO_PAGEFILE", WERR_NO_PAGEFILE },
	{ "WERR_ILLEGAL_FLOAT_CONTEXT", WERR_ILLEGAL_FLOAT_CONTEXT },
	{ "WERR_NO_EVENT_PAIR", WERR_NO_EVENT_PAIR },
	{ "WERR_DOMAIN_CTRLR_CONFIG_ERROR", WERR_DOMAIN_CTRLR_CONFIG_ERROR },
	{ "WERR_ILLEGAL_CHARACTER", WERR_ILLEGAL_CHARACTER },
	{ "WERR_UNDEFINED_CHARACTER", WERR_UNDEFINED_CHARACTER },
	{ "WERR_FLOPPY_VOLUME", WERR_FLOPPY_VOLUME },
	{ "WERR_BIOS_FAILED_TO_CONNECT_INTERRUPT", WERR_BIOS_FAILED_TO_CONNECT_INTERRUPT },
	{ "WERR_BACKUP_CONTROLLER", WERR_BACKUP_CONTROLLER },
	{ "WERR_MUTANT_LIMIT_EXCEEDED", WERR_MUTANT_LIMIT_EXCEEDED },
	{ "WERR_FS_DRIVER_REQUIRED", WERR_FS_DRIVER_REQUIRED },
	{ "WERR_CANNOT_LOAD_REGISTRY_FILE", WERR_CANNOT_LOAD_REGISTRY_FILE },
	{ "WERR_DEBUG_ATTACH_FAILED", WERR_DEBUG_ATTACH_FAILED },
	{ "WERR_SYSTEM_PROCESS_TERMINATED", WERR_SYSTEM_PROCESS_TERMINATED },
	{ "WERR_DATA_NOT_ACCEPTED", WERR_DATA_NOT_ACCEPTED },
	{ "WERR_VDM_HARD_ERROR", WERR_VDM_HARD_ERROR },
	{ "WERR_DRIVER_CANCEL_TIMEOUT", WERR_DRIVER_CANCEL_TIMEOUT },
	{ "WERR_REPLY_MESSAGE_MISMATCH", WERR_REPLY_MESSAGE_MISMATCH },
	{ "WERR_LOST_WRITEBEHIND_DATA", WERR_LOST_WRITEBEHIND_DATA },
	{ "WERR_CLIENT_SERVER_PARAMETERS_INVALID", WERR_CLIENT_SERVER_PARAMETERS_INVALID },
	{ "WERR_NOT_TINY_STREAM", WERR_NOT_TINY_STREAM },
	{ "WERR_STACK_OVERFLOW_READ", WERR_STACK_OVERFLOW_READ },
	{ "WERR_CONVERT_TO_LARGE", WERR_CONVERT_TO_LARGE },
	{ "WERR_FOUND_OUT_OF_SCOPE", WERR_FOUND_OUT_OF_SCOPE },
	{ "WERR_ALLOCATE_BUCKET", WERR_ALLOCATE_BUCKET },
	{ "WERR_MARSHALL_OVERFLOW", WERR_MARSHALL_OVERFLOW },
	{ "WERR_INVALID_VARIANT", WERR_INVALID_VARIANT },
	{ "WERR_BAD_COMPRESSION_BUFFER", WERR_BAD_COMPRESSION_BUFFER },
	{ "WERR_AUDIT_FAILED", WERR_AUDIT_FAILED },
	{ "WERR_TIMER_RESOLUTION_NOT_SET", WERR_TIMER_RESOLUTION_NOT_SET },
	{ "WERR_INSUFFICIENT_LOGON_INFO", WERR_INSUFFICIENT_LOGON_INFO },
	{ "WERR_BAD_DLL_ENTRYPOINT", WERR_BAD_DLL_ENTRYPOINT },
	{ "WERR_BAD_SERVICE_ENTRYPOINT", WERR_BAD_SERVICE_ENTRYPOINT },
	{ "WERR_IP_ADDRESS_CONFLICT1", WERR_IP_ADDRESS_CONFLICT1 },
	{ "WERR_IP_ADDRESS_CONFLICT2", WERR_IP_ADDRESS_CONFLICT2 },
	{ "WERR_REGISTRY_QUOTA_LIMIT", WERR_REGISTRY_QUOTA_LIMIT },
	{ "WERR_NO_CALLBACK_ACTIVE", WERR_NO_CALLBACK_ACTIVE },
	{ "WERR_PWD_TOO_SHORT", WERR_PWD_TOO_SHORT },
	{ "WERR_PWD_TOO_RECENT", WERR_PWD_TOO_RECENT },
	{ "WERR_PWD_HISTORY_CONFLICT", WERR_PWD_HISTORY_CONFLICT },
	{ "WERR_UNSUPPORTED_COMPRESSION", WERR_UNSUPPORTED_COMPRESSION },
	{ "WERR_INVALID_HW_PROFILE", WERR_INVALID_HW_PROFILE },
	{ "WERR_INVALID_PLUGPLAY_DEVICE_PATH", WERR_INVALID_PLUGPLAY_DEVICE_PATH },
	{ "WERR_QUOTA_LIST_INCONSISTENT", WERR_QUOTA_LIST_INCONSISTENT },
	{ "WERR_EVALUATION_EXPIRATION", WERR_EVALUATION_EXPIRATION },
	{ "WERR_ILLEGAL_DLL_RELOCATION", WERR_ILLEGAL_DLL_RELOCATION },
	{ "WERR_DLL_INIT_FAILED_LOGOFF", WERR_DLL_INIT_FAILED_LOGOFF },
	{ "WERR_VALIDATE_CONTINUE", WERR_VALIDATE_CONTINUE },
	{ "WERR_NO_MORE_MATCHES", WERR_NO_MORE_MATCHES },
	{ "WERR_RANGE_LIST_CONFLICT", WERR_RANGE_LIST_CONFLICT },
	{ "WERR_SERVER_SID_MISMATCH", WERR_SERVER_SID_MISMATCH },
	{ "WERR_CANT_ENABLE_DENY_ONLY", WERR_CANT_ENABLE_DENY_ONLY },
	{ "WERR_FLOAT_MULTIPLE_FAULTS", WERR_FLOAT_MULTIPLE_FAULTS },
	{ "WERR_FLOAT_MULTIPLE_TRAPS", WERR_FLOAT_MULTIPLE_TRAPS },
	{ "WERR_NOINTERFACE", WERR_NOINTERFACE },
	{ "WERR_DRIVER_FAILED_SLEEP", WERR_DRIVER_FAILED_SLEEP },
	{ "WERR_CORRUPT_SYSTEM_FILE", WERR_CORRUPT_SYSTEM_FILE },
	{ "WERR_COMMITMENT_MINIMUM", WERR_COMMITMENT_MINIMUM },
	{ "WERR_PNP_RESTART_ENUMERATION", WERR_PNP_RESTART_ENUMERATION },
	{ "WERR_SYSTEM_IMAGE_BAD_SIGNATURE", WERR_SYSTEM_IMAGE_BAD_SIGNATURE },
	{ "WERR_PNP_REBOOT_REQUIRED", WERR_PNP_REBOOT_REQUIRED },
	{ "WERR_INSUFFICIENT_POWER", WERR_INSUFFICIENT_POWER },
	{ "WERR_MULTIPLE_FAULT_VIOLATION", WERR_MULTIPLE_FAULT_VIOLATION },
	{ "WERR_SYSTEM_SHUTDOWN", WERR_SYSTEM_SHUTDOWN },
	{ "WERR_PORT_NOT_SET", WERR_PORT_NOT_SET },
	{ "WERR_DS_VERSION_CHECK_FAILURE", WERR_DS_VERSION_CHECK_FAILURE },
	{ "WERR_RANGE_NOT_FOUND", WERR_RANGE_NOT_FOUND },
	{ "WERR_NOT_SAFE_MODE_DRIVER", WERR_NOT_SAFE_MODE_DRIVER },
	{ "WERR_FAILED_DRIVER_ENTRY", WERR_FAILED_DRIVER_ENTRY },
	{ "WERR_DEVICE_ENUMERATION_ERROR", WERR_DEVICE_ENUMERATION_ERROR },
	{ "WERR_MOUNT_POINT_NOT_RESOLVED", WERR_MOUNT_POINT_NOT_RESOLVED },
	{ "WERR_INVALID_DEVICE_OBJECT_PARAMETER", WERR_INVALID_DEVICE_OBJECT_PARAMETER },
	{ "WERR_MCA_OCCURED", WERR_MCA_OCCURED },
	{ "WERR_DRIVER_DATABASE_ERROR", WERR_DRIVER_DATABASE_ERROR },
	{ "WERR_SYSTEM_HIVE_TOO_LARGE", WERR_SYSTEM_HIVE_TOO_LARGE },
	{ "WERR_DRIVER_FAILED_PRIOR_UNLOAD", WERR_DRIVER_FAILED_PRIOR_UNLOAD },
	{ "WERR_VOLSNAP_PREPARE_HIBERNATE", WERR_VOLSNAP_PREPARE_HIBERNATE },
	{ "WERR_HIBERNATION_FAILURE", WERR_HIBERNATION_FAILURE },
	{ "WERR_FILE_SYSTEM_LIMITATION", WERR_FILE_SYSTEM_LIMITATION },
	{ "WERR_ASSERTION_FAILURE", WERR_ASSERTION_FAILURE },
	{ "WERR_ACPI_ERROR", WERR_ACPI_ERROR },
	{ "WERR_WOW_ASSERTION", WERR_WOW_ASSERTION },
	{ "WERR_PNP_BAD_MPS_TABLE", WERR_PNP_BAD_MPS_TABLE },
	{ "WERR_PNP_TRANSLATION_FAILED", WERR_PNP_TRANSLATION_FAILED },
	{ "WERR_PNP_IRQ_TRANSLATION_FAILED", WERR_PNP_IRQ_TRANSLATION_FAILED },
	{ "WERR_PNP_INVALID_ID", WERR_PNP_INVALID_ID },
	{ "WERR_WAKE_SYSTEM_DEBUGGER", WERR_WAKE_SYSTEM_DEBUGGER },
	{ "WERR_HANDLES_CLOSED", WERR_HANDLES_CLOSED },
	{ "WERR_EXTRANEOUS_INFORMATION", WERR_EXTRANEOUS_INFORMATION },
	{ "WERR_RXACT_COMMIT_NECESSARY", WERR_RXACT_COMMIT_NECESSARY },
	{ "WERR_MEDIA_CHECK", WERR_MEDIA_CHECK },
	{ "WERR_GUID_SUBSTITUTION_MADE", WERR_GUID_SUBSTITUTION_MADE },
	{ "WERR_STOPPED_ON_SYMLINK", WERR_STOPPED_ON_SYMLINK },
	{ "WERR_LONGJUMP", WERR_LONGJUMP },
	{ "WERR_PLUGPLAY_QUERY_VETOED", WERR_PLUGPLAY_QUERY_VETOED },
	{ "WERR_UNWIND_CONSOLIDATE", WERR_UNWIND_CONSOLIDATE },
	{ "WERR_REGISTRY_HIVE_RECOVERED", WERR_REGISTRY_HIVE_RECOVERED },
	{ "WERR_DLL_MIGHT_BE_INSECURE", WERR_DLL_MIGHT_BE_INSECURE },
	{ "WERR_DLL_MIGHT_BE_INCOMPATIBLE", WERR_DLL_MIGHT_BE_INCOMPATIBLE },
	{ "WERR_DBG_EXCEPTION_NOT_HANDLED", WERR_DBG_EXCEPTION_NOT_HANDLED },
	{ "WERR_DBG_REPLY_LATER", WERR_DBG_REPLY_LATER },
	{ "WERR_DBG_UNABLE_TO_PROVIDE_HANDLE", WERR_DBG_UNABLE_TO_PROVIDE_HANDLE },
	{ "WERR_DBG_TERMINATE_THREAD", WERR_DBG_TERMINATE_THREAD },
	{ "WERR_DBG_TERMINATE_PROCESS", WERR_DBG_TERMINATE_PROCESS },
	{ "WERR_DBG_CONTROL_C", WERR_DBG_CONTROL_C },
	{ "WERR_DBG_PRINTEXCEPTION_C", WERR_DBG_PRINTEXCEPTION_C },
	{ "WERR_DBG_RIPEXCEPTION", WERR_DBG_RIPEXCEPTION },
	{ "WERR_DBG_CONTROL_BREAK", WERR_DBG_CONTROL_BREAK },
	{ "WERR_DBG_COMMAND_EXCEPTION", WERR_DBG_COMMAND_EXCEPTION },
	{ "WERR_OBJECT_NAME_EXISTS", WERR_OBJECT_NAME_EXISTS },
	{ "WERR_THREAD_WAS_SUSPENDED", WERR_THREAD_WAS_SUSPENDED },
	{ "WERR_IMAGE_NOT_AT_BASE", WERR_IMAGE_NOT_AT_BASE },
	{ "WERR_RXACT_STATE_CREATED", WERR_RXACT_STATE_CREATED },
	{ "WERR_SEGMENT_NOTIFICATION", WERR_SEGMENT_NOTIFICATION },
	{ "WERR_BAD_CURRENT_DIRECTORY", WERR_BAD_CURRENT_DIRECTORY },
	{ "WERR_FT_READ_RECOVERY_FROM_BACKUP", WERR_FT_READ_RECOVERY_FROM_BACKUP },
	{ "WERR_FT_WRITE_RECOVERY", WERR_FT_WRITE_RECOVERY },
	{ "WERR_IMAGE_MACHINE_TYPE_MISMATCH", WERR_IMAGE_MACHINE_TYPE_MISMATCH },
	{ "WERR_RECEIVE_PARTIAL", WERR_RECEIVE_PARTIAL },
	{ "WERR_RECEIVE_EXPEDITED", WERR_RECEIVE_EXPEDITED },
	{ "WERR_RECEIVE_PARTIAL_EXPEDITED", WERR_RECEIVE_PARTIAL_EXPEDITED },
	{ "WERR_EVENT_DONE", WERR_EVENT_DONE },
	{ "WERR_EVENT_PENDING", WERR_EVENT_PENDING },
	{ "WERR_CHECKING_FILE_SYSTEM", WERR_CHECKING_FILE_SYSTEM },
	{ "WERR_FATAL_APP_EXIT", WERR_FATAL_APP_EXIT },
	{ "WERR_PREDEFINED_HANDLE", WERR_PREDEFINED_HANDLE },
	{ "WERR_WAS_UNLOCKED", WERR_WAS_UNLOCKED },
	{ "WERR_SERVICE_NOTIFICATION", WERR_SERVICE_NOTIFICATION },
	{ "WERR_WAS_LOCKED", WERR_WAS_LOCKED },
	{ "WERR_LOG_HARD_ERROR", WERR_LOG_HARD_ERROR },
	{ "WERR_ALREADY_WIN32", WERR_ALREADY_WIN32 },
	{ "WERR_IMAGE_MACHINE_TYPE_MISMATCH_EXE", WERR_IMAGE_MACHINE_TYPE_MISMATCH_EXE },
	{ "WERR_NO_YIELD_PERFORMED", WERR_NO_YIELD_PERFORMED },
	{ "WERR_TIMER_RESUME_IGNORED", WERR_TIMER_RESUME_IGNORED },
	{ "WERR_ARBITRATION_UNHANDLED", WERR_ARBITRATION_UNHANDLED },
	{ "WERR_CARDBUS_NOT_SUPPORTED", WERR_CARDBUS_NOT_SUPPORTED },
	{ "WERR_MP_PROCESSOR_MISMATCH", WERR_MP_PROCESSOR_MISMATCH },
	{ "WERR_HIBERNATED", WERR_HIBERNATED },
	{ "WERR_RESUME_HIBERNATION", WERR_RESUME_HIBERNATION },
	{ "WERR_FIRMWARE_UPDATED", WERR_FIRMWARE_UPDATED },
	{ "WERR_DRIVERS_LEAKING_LOCKED_PAGES", WERR_DRIVERS_LEAKING_LOCKED_PAGES },
	{ "WERR_WAKE_SYSTEM", WERR_WAKE_SYSTEM },
	{ "WERR_WAIT_1", WERR_WAIT_1 },
	{ "WERR_WAIT_2", WERR_WAIT_2 },
	{ "WERR_WAIT_3", WERR_WAIT_3 },
	{ "WERR_WAIT_63", WERR_WAIT_63 },
	{ "WERR_ABANDONED_WAIT_0", WERR_ABANDONED_WAIT_0 },
	{ "WERR_ABANDONED_WAIT_63", WERR_ABANDONED_WAIT_63 },
	{ "WERR_USER_APC", WERR_USER_APC },
	{ "WERR_KERNEL_APC", WERR_KERNEL_APC },
	{ "WERR_ALERTED", WERR_ALERTED },
	{ "WERR_ELEVATION_REQUIRED", WERR_ELEVATION_REQUIRED },
	{ "WERR_REPARSE", WERR_REPARSE },
	{ "WERR_OPLOCK_BREAK_IN_PROGRESS", WERR_OPLOCK_BREAK_IN_PROGRESS },
	{ "WERR_VOLUME_MOUNTED", WERR_VOLUME_MOUNTED },
	{ "WERR_RXACT_COMMITTED", WERR_RXACT_COMMITTED },
	{ "WERR_NOTIFY_CLEANUP", WERR_NOTIFY_CLEANUP },
	{ "WERR_PRIMARY_TRANSPORT_CONNECT_FAILED", WERR_PRIMARY_TRANSPORT_CONNECT_FAILED },
	{ "WERR_PAGE_FAULT_TRANSITION", WERR_PAGE_FAULT_TRANSITION },
	{ "WERR_PAGE_FAULT_DEMAND_ZERO", WERR_PAGE_FAULT_DEMAND_ZERO },
	{ "WERR_PAGE_FAULT_COPY_ON_WRITE", WERR_PAGE_FAULT_COPY_ON_WRITE },
	{ "WERR_PAGE_FAULT_GUARD_PAGE", WERR_PAGE_FAULT_GUARD_PAGE },
	{ "WERR_PAGE_FAULT_PAGING_FILE", WERR_PAGE_FAULT_PAGING_FILE },
	{ "WERR_CACHE_PAGE_LOCKED", WERR_CACHE_PAGE_LOCKED },
	{ "WERR_CRASH_DUMP", WERR_CRASH_DUMP },
	{ "WERR_BUFFER_ALL_ZEROS", WERR_BUFFER_ALL_ZEROS },
	{ "WERR_REPARSE_OBJECT", WERR_REPARSE_OBJECT },
	{ "WERR_RESOURCE_REQUIREMENTS_CHANGED", WERR_RESOURCE_REQUIREMENTS_CHANGED },
	{ "WERR_TRANSLATION_COMPLETE", WERR_TRANSLATION_COMPLETE },
	{ "WERR_NOTHING_TO_TERMINATE", WERR_NOTHING_TO_TERMINATE },
	{ "WERR_PROCESS_NOT_IN_JOB", WERR_PROCESS_NOT_IN_JOB },
	{ "WERR_PROCESS_IN_JOB", WERR_PROCESS_IN_JOB },
	{ "WERR_VOLSNAP_HIBERNATE_READY", WERR_VOLSNAP_HIBERNATE_READY },
	{ "WERR_FSFILTER_OP_COMPLETED_SUCCESSFULLY", WERR_FSFILTER_OP_COMPLETED_SUCCESSFULLY },
	{ "WERR_INTERRUPT_VECTOR_ALREADY_CONNECTED", WERR_INTERRUPT_VECTOR_ALREADY_CONNECTED },
	{ "WERR_INTERRUPT_STILL_CONNECTED", WERR_INTERRUPT_STILL_CONNECTED },
	{ "WERR_WAIT_FOR_OPLOCK", WERR_WAIT_FOR_OPLOCK },
	{ "WERR_DBG_EXCEPTION_HANDLED", WERR_DBG_EXCEPTION_HANDLED },
	{ "WERR_DBG_CONTINUE", WERR_DBG_CONTINUE },
	{ "WERR_CALLBACK_POP_STACK", WERR_CALLBACK_POP_STACK },
	{ "WERR_COMPRESSION_DISABLED", WERR_COMPRESSION_DISABLED },
	{ "WERR_CANTFETCHBACKWARDS", WERR_CANTFETCHBACKWARDS },
	{ "WERR_CANTSCROLLBACKWARDS", WERR_CANTSCROLLBACKWARDS },
	{ "WERR_ROWSNOTRELEASED", WERR_ROWSNOTRELEASED },
	{ "WERR_BAD_ACCESSOR_FLAGS", WERR_BAD_ACCESSOR_FLAGS },
	{ "WERR_ERRORS_ENCOUNTERED", WERR_ERRORS_ENCOUNTERED },
	{ "WERR_NOT_CAPABLE", WERR_NOT_CAPABLE },
	{ "WERR_REQUEST_OUT_OF_SEQUENCE", WERR_REQUEST_OUT_OF_SEQUENCE },
	{ "WERR_VERSION_PARSE_ERROR", WERR_VERSION_PARSE_ERROR },
	{ "WERR_BADSTARTPOSITION", WERR_BADSTARTPOSITION },
	{ "WERR_MEMORY_HARDWARE", WERR_MEMORY_HARDWARE },
	{ "WERR_DISK_REPAIR_DISABLED", WERR_DISK_REPAIR_DISABLED },
	{ "WERR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE", WERR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE },
	{ "WERR_SYSTEM_POWERSTATE_TRANSITION", WERR_SYSTEM_POWERSTATE_TRANSITION },
	{ "WERR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION", WERR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION },
	{ "WERR_MCA_EXCEPTION", WERR_MCA_EXCEPTION },
	{ "WERR_ACCESS_AUDIT_BY_POLICY", WERR_ACCESS_AUDIT_BY_POLICY },
	{ "WERR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY", WERR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY },
	{ "WERR_ABANDON_HIBERFILE", WERR_ABANDON_HIBERFILE },
	{ "WERR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED", WERR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED },
	{ "WERR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR", WERR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR },
	{ "WERR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR", WERR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR },
	{ "WERR_EA_ACCESS_DENIED", WERR_EA_ACCESS_DENIED },
	{ "WERR_OPERATION_ABORTED", WERR_OPERATION_ABORTED },
	{ "WERR_IO_INCOMPLETE", WERR_IO_INCOMPLETE },
	{ "WERR_NOACCESS", WERR_NOACCESS },
	{ "WERR_SWAPERROR", WERR_SWAPERROR },
	{ "WERR_STACK_OVERFLOW", WERR_STACK_OVERFLOW },
	{ "WERR_INVALID_MESSAGE", WERR_INVALID_MESSAGE },
	{ "WERR_UNRECOGNIZED_VOLUME", WERR_UNRECOGNIZED_VOLUME },
	{ "WERR_FILE_INVALID", WERR_FILE_INVALID },
	{ "WERR_FULLSCREEN_MODE", WERR_FULLSCREEN_MODE },
	{ "WERR_NO_TOKEN", WERR_NO_TOKEN },
	{ "WERR_BADDB", WERR_BADDB },
	{ "WERR_BADKEY", WERR_BADKEY },
	{ "WERR_CANTOPEN", WERR_CANTOPEN },
	{ "WERR_CANTREAD", WERR_CANTREAD },
	{ "WERR_CANTWRITE", WERR_CANTWRITE },
	{ "WERR_REGISTRY_RECOVERED", WERR_REGISTRY_RECOVERED },
	{ "WERR_REGISTRY_CORRUPT", WERR_REGISTRY_CORRUPT },
	{ "WERR_REGISTRY_IO_FAILED", WERR_REGISTRY_IO_FAILED },
	{ "WERR_NOT_REGISTRY_FILE", WERR_NOT_REGISTRY_FILE },
	{ "WERR_KEY_DELETED", WERR_KEY_DELETED },
	{ "WERR_NO_LOG_SPACE", WERR_NO_LOG_SPACE },
	{ "WERR_KEY_HAS_CHILDREN", WERR_KEY_HAS_CHILDREN },
	{ "WERR_CHILD_MUST_BE_VOLATILE", WERR_CHILD_MUST_BE_VOLATILE },
	{ "WERR_NOTIFY_ENUM_DIR", WERR_NOTIFY_ENUM_DIR },
	{ "WERR_DEPENDENT_SERVICES_RUNNING", WERR_DEPENDENT_SERVICES_RUNNING },
	{ "WERR_SERVICE_REQUEST_TIMEOUT", WERR_SERVICE_REQUEST_TIMEOUT },
	{ "WERR_SERVICE_NO_THREAD", WERR_SERVICE_NO_THREAD },
	{ "WERR_SERVICE_DATABASE_LOCKED", WERR_SERVICE_DATABASE_LOCKED },
	{ "WERR_INVALID_SERVICE_ACCOUNT", WERR_INVALID_SERVICE_ACCOUNT },
	{ "WERR_CIRCULAR_DEPENDENCY", WERR_CIRCULAR_DEPENDENCY },
	{ "WERR_SERVICE_DOES_NOT_EXIST", WERR_SERVICE_DOES_NOT_EXIST },
	{ "WERR_SERVICE_CANNOT_ACCEPT_CTRL", WERR_SERVICE_CANNOT_ACCEPT_CTRL },
	{ "WERR_SERVICE_NOT_ACTIVE", WERR_SERVICE_NOT_ACTIVE },
	{ "WERR_FAILED_SERVICE_CONTROLLER_CONNECT", WERR_FAILED_SERVICE_CONTROLLER_CONNECT },
	{ "WERR_EXCEPTION_IN_SERVICE", WERR_EXCEPTION_IN_SERVICE },
	{ "WERR_DATABASE_DOES_NOT_EXIST", WERR_DATABASE_DOES_NOT_EXIST },
	{ "WERR_SERVICE_SPECIFIC_ERROR", WERR_SERVICE_SPECIFIC_ERROR },
	{ "WERR_PROCESS_ABORTED", WERR_PROCESS_ABORTED },
	{ "WERR_SERVICE_DEPENDENCY_FAIL", WERR_SERVICE_DEPENDENCY_FAIL },
	{ "WERR_SERVICE_LOGON_FAILED", WERR_SERVICE_LOGON_FAILED },
	{ "WERR_SERVICE_START_HANG", WERR_SERVICE_START_HANG },
	{ "WERR_INVALID_SERVICE_LOCK", WERR_INVALID_SERVICE_LOCK },
	{ "WERR_ALREADY_RUNNING_LKG", WERR_ALREADY_RUNNING_LKG },
	{ "WERR_SERVICE_DEPENDENCY_DELETED", WERR_SERVICE_DEPENDENCY_DELETED },
	{ "WERR_BOOT_ALREADY_ACCEPTED", WERR_BOOT_ALREADY_ACCEPTED },
	{ "WERR_DIFFERENT_SERVICE_ACCOUNT", WERR_DIFFERENT_SERVICE_ACCOUNT },
	{ "WERR_CANNOT_DETECT_DRIVER_FAILURE", WERR_CANNOT_DETECT_DRIVER_FAILURE },
	{ "WERR_CANNOT_DETECT_PROCESS_ABORT", WERR_CANNOT_DETECT_PROCESS_ABORT },
	{ "WERR_NO_RECOVERY_PROGRAM", WERR_NO_RECOVERY_PROGRAM },
	{ "WERR_SERVICE_NOT_IN_EXE", WERR_SERVICE_NOT_IN_EXE },
	{ "WERR_NOT_SAFEBOOT_SERVICE", WERR_NOT_SAFEBOOT_SERVICE },
	{ "WERR_END_OF_MEDIA", WERR_END_OF_MEDIA },
	{ "WERR_FILEMARK_DETECTED", WERR_FILEMARK_DETECTED },
	{ "WERR_BEGINNING_OF_MEDIA", WERR_BEGINNING_OF_MEDIA },
	{ "WERR_SETMARK_DETECTED", WERR_SETMARK_DETECTED },
	{ "WERR_NO_DATA_DETECTED", WERR_NO_DATA_DETECTED },
	{ "WERR_PARTITION_FAILURE", WERR_PARTITION_FAILURE },
	{ "WERR_INVALID_BLOCK_LENGTH", WERR_INVALID_BLOCK_LENGTH },
	{ "WERR_DEVICE_NOT_PARTITIONED", WERR_DEVICE_NOT_PARTITIONED },
	{ "WERR_UNABLE_TO_LOCK_MEDIA", WERR_UNABLE_TO_LOCK_MEDIA },
	{ "WERR_UNABLE_TO_UNLOAD_MEDIA", WERR_UNABLE_TO_UNLOAD_MEDIA },
	{ "WERR_MEDIA_CHANGED", WERR_MEDIA_CHANGED },
	{ "WERR_BUS_RESET", WERR_BUS_RESET },
	{ "WERR_NO_MEDIA_IN_DRIVE", WERR_NO_MEDIA_IN_DRIVE },
	{ "WERR_NO_UNICODE_TRANSLATION", WERR_NO_UNICODE_TRANSLATION },
	{ "WERR_DLL_INIT_FAILED", WERR_DLL_INIT_FAILED },
	{ "WERR_SHUTDOWN_IN_PROGRESS", WERR_SHUTDOWN_IN_PROGRESS },
	{ "WERR_IO_DEVICE", WERR_IO_DEVICE },
	{ "WERR_SERIAL_NO_DEVICE", WERR_SERIAL_NO_DEVICE },
	{ "WERR_IRQ_BUSY", WERR_IRQ_BUSY },
	{ "WERR_MORE_WRITES", WERR_MORE_WRITES },
	{ "WERR_COUNTER_TIMEOUT", WERR_COUNTER_TIMEOUT },
	{ "WERR_FLOPPY_ID_MARK_NOT_FOUND", WERR_FLOPPY_ID_MARK_NOT_FOUND },
	{ "WERR_FLOPPY_WRONG_CYLINDER", WERR_FLOPPY_WRONG_CYLINDER },
	{ "WERR_FLOPPY_UNKNOWN_ERROR", WERR_FLOPPY_UNKNOWN_ERROR },
	{ "WERR_FLOPPY_BAD_REGISTERS", WERR_FLOPPY_BAD_REGISTERS },
	{ "WERR_DISK_RECALIBRATE_FAILED", WERR_DISK_RECALIBRATE_FAILED },
	{ "WERR_DISK_OPERATION_FAILED", WERR_DISK_OPERATION_FAILED },
	{ "WERR_DISK_RESET_FAILED", WERR_DISK_RESET_FAILED },
	{ "WERR_EOM_OVERFLOW", WERR_EOM_OVERFLOW },
	{ "WERR_NOT_ENOUGH_SERVER_MEMORY", WERR_NOT_ENOUGH_SERVER_MEMORY },
	{ "WERR_POSSIBLE_DEADLOCK", WERR_POSSIBLE_DEADLOCK },
	{ "WERR_MAPPED_ALIGNMENT", WERR_MAPPED_ALIGNMENT },
	{ "WERR_SET_POWER_STATE_VETOED", WERR_SET_POWER_STATE_VETOED },
	{ "WERR_SET_POWER_STATE_FAILED", WERR_SET_POWER_STATE_FAILED },
	{ "WERR_TOO_MANY_LINKS", WERR_TOO_MANY_LINKS },
	{ "WERR_OLD_WIN_VERSION", WERR_OLD_WIN_VERSION },
	{ "WERR_APP_WRONG_OS", WERR_APP_WRONG_OS },
	{ "WERR_SINGLE_INSTANCE_APP", WERR_SINGLE_INSTANCE_APP },
	{ "WERR_RMODE_APP", WERR_RMODE_APP },
	{ "WERR_INVALID_DLL", WERR_INVALID_DLL },
	{ "WERR_NO_ASSOCIATION", WERR_NO_ASSOCIATION },
	{ "WERR_DDE_FAIL", WERR_DDE_FAIL },
	{ "WERR_DLL_NOT_FOUND", WERR_DLL_NOT_FOUND },
	{ "WERR_NO_MORE_USER_HANDLES", WERR_NO_MORE_USER_HANDLES },
	{ "WERR_MESSAGE_SYNC_ONLY", WERR_MESSAGE_SYNC_ONLY },
	{ "WERR_SOURCE_ELEMENT_EMPTY", WERR_SOURCE_ELEMENT_EMPTY },
	{ "WERR_DESTINATION_ELEMENT_FULL", WERR_DESTINATION_ELEMENT_FULL },
	{ "WERR_ILLEGAL_ELEMENT_ADDRESS", WERR_ILLEGAL_ELEMENT_ADDRESS },
	{ "WERR_MAGAZINE_NOT_PRESENT", WERR_MAGAZINE_NOT_PRESENT },
	{ "WERR_DEVICE_REINITIALIZATION_NEEDED", WERR_DEVICE_REINITIALIZATION_NEEDED },
	{ "WERR_DEVICE_REQUIRES_CLEANING", WERR_DEVICE_REQUIRES_CLEANING },
	{ "WERR_DEVICE_DOOR_OPEN", WERR_DEVICE_DOOR_OPEN },
	{ "WERR_NO_MATCH", WERR_NO_MATCH },
	{ "WERR_SET_NOT_FOUND", WERR_SET_NOT_FOUND },
	{ "WERR_POINT_NOT_FOUND", WERR_POINT_NOT_FOUND },
	{ "WERR_NO_TRACKING_SERVICE", WERR_NO_TRACKING_SERVICE },
	{ "WERR_NO_VOLUME_ID", WERR_NO_VOLUME_ID },
	{ "WERR_UNABLE_TO_REMOVE_REPLACED", WERR_UNABLE_TO_REMOVE_REPLACED },
	{ "WERR_UNABLE_TO_MOVE_REPLACEMENT", WERR_UNABLE_TO_MOVE_REPLACEMENT },
	{ "WERR_UNABLE_TO_MOVE_REPLACEMENT_2", WERR_UNABLE_TO_MOVE_REPLACEMENT_2 },
	{ "WERR_JOURNAL_DELETE_IN_PROGRESS", WERR_JOURNAL_DELETE_IN_PROGRESS },
	{ "WERR_JOURNAL_NOT_ACTIVE", WERR_JOURNAL_NOT_ACTIVE },
	{ "WERR_POTENTIAL_FILE_FOUND", WERR_POTENTIAL_FILE_FOUND },
	{ "WERR_JOURNAL_ENTRY_DELETED", WERR_JOURNAL_ENTRY_DELETED },
	{ "WERR_SHUTDOWN_IS_SCHEDULED", WERR_SHUTDOWN_IS_SCHEDULED },
	{ "WERR_SHUTDOWN_USERS_LOGGED_ON", WERR_SHUTDOWN_USERS_LOGGED_ON },
	{ "WERR_BAD_DEVICE", WERR_BAD_DEVICE },
	{ "WERR_CONNECTION_UNAVAIL", WERR_CONNECTION_UNAVAIL },
	{ "WERR_DEVICE_ALREADY_REMEMBERED", WERR_DEVICE_ALREADY_REMEMBERED },
	{ "WERR_NO_NET_OR_BAD_PATH", WERR_NO_NET_OR_BAD_PATH },
	{ "WERR_BAD_PROVIDER", WERR_BAD_PROVIDER },
	{ "WERR_CANNOT_OPEN_PROFILE", WERR_CANNOT_OPEN_PROFILE },
	{ "WERR_BAD_PROFILE", WERR_BAD_PROFILE },
	{ "WERR_NOT_CONTAINER", WERR_NOT_CONTAINER },
	{ "WERR_EXTENDED_ERROR", WERR_EXTENDED_ERROR },
	{ "WERR_INVALID_GROUPNAME", WERR_INVALID_GROUPNAME },
	{ "WERR_INVALID_EVENTNAME", WERR_INVALID_EVENTNAME },
	{ "WERR_INVALID_SERVICENAME", WERR_INVALID_SERVICENAME },
	{ "WERR_INVALID_NETNAME", WERR_INVALID_NETNAME },
	{ "WERR_INVALID_SHARENAME", WERR_INVALID_SHARENAME },
	{ "WERR_INVALID_PASSWORDNAME", WERR_INVALID_PASSWORDNAME },
	{ "WERR_INVALID_MESSAGENAME", WERR_INVALID_MESSAGENAME },
	{ "WERR_INVALID_MESSAGEDEST", WERR_INVALID_MESSAGEDEST },
	{ "WERR_SESSION_CREDENTIAL_CONFLICT", WERR_SESSION_CREDENTIAL_CONFLICT },
	{ "WERR_REMOTE_SESSION_LIMIT_EXCEEDED", WERR_REMOTE_SESSION_LIMIT_EXCEEDED },
	{ "WERR_DUP_DOMAINNAME", WERR_DUP_DOMAINNAME },
	{ "WERR_NO_NETWORK", WERR_NO_NETWORK },
	{ "WERR_CANCELLED", WERR_CANCELLED },
	{ "WERR_USER_MAPPED_FILE", WERR_USER_MAPPED_FILE },
	{ "WERR_CONNECTION_REFUSED", WERR_CONNECTION_REFUSED },
	{ "WERR_GRACEFUL_DISCONNECT", WERR_GRACEFUL_DISCONNECT },
	{ "WERR_ADDRESS_ALREADY_ASSOCIATED", WERR_ADDRESS_ALREADY_ASSOCIATED },
	{ "WERR_ADDRESS_NOT_ASSOCIATED", WERR_ADDRESS_NOT_ASSOCIATED },
	{ "WERR_CONNECTION_INVALID", WERR_CONNECTION_INVALID },
	{ "WERR_CONNECTION_ACTIVE", WERR_CONNECTION_ACTIVE },
	{ "WERR_NETWORK_UNREACHABLE", WERR_NETWORK_UNREACHABLE },
	{ "WERR_HOST_UNREACHABLE", WERR_HOST_UNREACHABLE },
	{ "WERR_PROTOCOL_UNREACHABLE", WERR_PROTOCOL_UNREACHABLE },
	{ "WERR_PORT_UNREACHABLE", WERR_PORT_UNREACHABLE },
	{ "WERR_REQUEST_ABORTED", WERR_REQUEST_ABORTED },
	{ "WERR_CONNECTION_ABORTED", WERR_CONNECTION_ABORTED },
	{ "WERR_RETRY", WERR_RETRY },
	{ "WERR_CONNECTION_COUNT_LIMIT", WERR_CONNECTION_COUNT_LIMIT },
	{ "WERR_LOGIN_TIME_RESTRICTION", WERR_LOGIN_TIME_RESTRICTION },
	{ "WERR_LOGIN_WKSTA_RESTRICTION", WERR_LOGIN_WKSTA_RESTRICTION },
	{ "WERR_INCORRECT_ADDRESS", WERR_INCORRECT_ADDRESS },
	{ "WERR_ALREADY_REGISTERED", WERR_ALREADY_REGISTERED },
	{ "WERR_SERVICE_NOT_FOUND", WERR_SERVICE_NOT_FOUND },
	{ "WERR_NOT_LOGGED_ON", WERR_NOT_LOGGED_ON },
	{ "WERR_CONTINUE", WERR_CONTINUE },
	{ "WERR_ALREADY_INITIALIZED", WERR_ALREADY_INITIALIZED },
	{ "WERR_NO_MORE_DEVICES", WERR_NO_MORE_DEVICES },
	{ "WERR_NO_SUCH_SITE", WERR_NO_SUCH_SITE },
	{ "WERR_DOMAIN_CONTROLLER_EXISTS", WERR_DOMAIN_CONTROLLER_EXISTS },
	{ "WERR_ONLY_IF_CONNECTED", WERR_ONLY_IF_CONNECTED },
	{ "WERR_OVERRIDE_NOCHANGES", WERR_OVERRIDE_NOCHANGES },
	{ "WERR_BAD_USER_PROFILE", WERR_BAD_USER_PROFILE },
	{ "WERR_NOT_SUPPORTED_ON_SBS", WERR_NOT_SUPPORTED_ON_SBS },
	{ "WERR_SERVER_SHUTDOWN_IN_PROGRESS", WERR_SERVER_SHUTDOWN_IN_PROGRESS },
	{ "WERR_HOST_DOWN", WERR_HOST_DOWN },
	{ "WERR_NON_ACCOUNT_SID", WERR_NON_ACCOUNT_SID },
	{ "WERR_NON_DOMAIN_SID", WERR_NON_DOMAIN_SID },
	{ "WERR_APPHELP_BLOCK", WERR_APPHELP_BLOCK },
	{ "WERR_ACCESS_DISABLED_BY_POLICY", WERR_ACCESS_DISABLED_BY_POLICY },
	{ "WERR_REG_NAT_CONSUMPTION", WERR_REG_NAT_CONSUMPTION },
	{ "WERR_CSCSHARE_OFFLINE", WERR_CSCSHARE_OFFLINE },
	{ "WERR_PKINIT_FAILURE", WERR_PKINIT_FAILURE },
	{ "WERR_SMARTCARD_SUBSYSTEM_FAILURE", WERR_SMARTCARD_SUBSYSTEM_FAILURE },
	{ "WERR_DOWNGRADE_DETECTED", WERR_DOWNGRADE_DETECTED },
	{ "WERR_CALLBACK_SUPPLIED_INVALID_DATA", WERR_CALLBACK_SUPPLIED_INVALID_DATA },
	{ "WERR_SYNC_FOREGROUND_REFRESH_REQUIRED", WERR_SYNC_FOREGROUND_REFRESH_REQUIRED },
	{ "WERR_DRIVER_BLOCKED", WERR_DRIVER_BLOCKED },
	{ "WERR_INVALID_IMPORT_OF_NON_DLL", WERR_INVALID_IMPORT_OF_NON_DLL },
	{ "WERR_ACCESS_DISABLED_WEBBLADE", WERR_ACCESS_DISABLED_WEBBLADE },
	{ "WERR_ACCESS_DISABLED_WEBBLADE_TAMPER", WERR_ACCESS_DISABLED_WEBBLADE_TAMPER },
	{ "WERR_RECOVERY_FAILURE", WERR_RECOVERY_FAILURE },
	{ "WERR_ALREADY_FIBER", WERR_ALREADY_FIBER },
	{ "WERR_ALREADY_THREAD", WERR_ALREADY_THREAD },
	{ "WERR_STACK_BUFFER_OVERRUN", WERR_STACK_BUFFER_OVERRUN },
	{ "WERR_PARAMETER_QUOTA_EXCEEDED", WERR_PARAMETER_QUOTA_EXCEEDED },
	{ "WERR_DEBUGGER_INACTIVE", WERR_DEBUGGER_INACTIVE },
	{ "WERR_DELAY_LOAD_FAILED", WERR_DELAY_LOAD_FAILED },
	{ "WERR_VDM_DISALLOWED", WERR_VDM_DISALLOWED },
	{ "WERR_UNIDENTIFIED_ERROR", WERR_UNIDENTIFIED_ERROR },
	{ "WERR_BEYOND_VDL", WERR_BEYOND_VDL },
	{ "WERR_INCOMPATIBLE_SERVICE_SID_TYPE", WERR_INCOMPATIBLE_SERVICE_SID_TYPE },
	{ "WERR_DRIVER_PROCESS_TERMINATED", WERR_DRIVER_PROCESS_TERMINATED },
	{ "WERR_IMPLEMENTATION_LIMIT", WERR_IMPLEMENTATION_LIMIT },
	{ "WERR_PROCESS_IS_PROTECTED", WERR_PROCESS_IS_PROTECTED },
	{ "WERR_SERVICE_NOTIFY_CLIENT_LAGGING", WERR_SERVICE_NOTIFY_CLIENT_LAGGING },
	{ "WERR_DISK_QUOTA_EXCEEDED", WERR_DISK_QUOTA_EXCEEDED },
	{ "WERR_CONTENT_BLOCKED", WERR_CONTENT_BLOCKED },
	{ "WERR_INCOMPATIBLE_SERVICE_PRIVILEGE", WERR_INCOMPATIBLE_SERVICE_PRIVILEGE },
	{ "WERR_INVALID_LABEL", WERR_INVALID_LABEL },
	{ "WERR_NOT_ALL_ASSIGNED", WERR_NOT_ALL_ASSIGNED },
	{ "WERR_SOME_NOT_MAPPED", WERR_SOME_NOT_MAPPED },
	{ "WERR_NO_QUOTAS_FOR_ACCOUNT", WERR_NO_QUOTAS_FOR_ACCOUNT },
	{ "WERR_LOCAL_USER_SESSION_KEY", WERR_LOCAL_USER_SESSION_KEY },
	{ "WERR_NULL_LM_PASSWORD", WERR_NULL_LM_PASSWORD },
	{ "WERR_NO_IMPERSONATION_TOKEN", WERR_NO_IMPERSONATION_TOKEN },
	{ "WERR_CANT_DISABLE_MANDATORY", WERR_CANT_DISABLE_MANDATORY },
	{ "WERR_INVALID_ACCOUNT_NAME", WERR_INVALID_ACCOUNT_NAME },
	{ "WERR_USER_EXISTS", WERR_USER_EXISTS },
	{ "WERR_MEMBER_NOT_IN_GROUP", WERR_MEMBER_NOT_IN_GROUP },
	{ "WERR_LAST_ADMIN", WERR_LAST_ADMIN },
	{ "WERR_ILL_FORMED_PASSWORD", WERR_ILL_FORMED_PASSWORD },
	{ "WERR_ACCOUNT_RESTRICTION", WERR_ACCOUNT_RESTRICTION },
	{ "WERR_INVALID_LOGON_HOURS", WERR_INVALID_LOGON_HOURS },
	{ "WERR_INVALID_WORKSTATION", WERR_INVALID_WORKSTATION },
	{ "WERR_PASSWORD_EXPIRED", WERR_PASSWORD_EXPIRED },
	{ "WERR_ACCOUNT_DISABLED", WERR_ACCOUNT_DISABLED },
	{ "WERR_TOO_MANY_LUIDS_REQUESTED", WERR_TOO_MANY_LUIDS_REQUESTED },
	{ "WERR_LUIDS_EXHAUSTED", WERR_LUIDS_EXHAUSTED },
	{ "WERR_INVALID_SUB_AUTHORITY", WERR_INVALID_SUB_AUTHORITY },
	{ "WERR_INVALID_ACL", WERR_INVALID_ACL },
	{ "WERR_INVALID_SID", WERR_INVALID_SID },
	{ "WERR_INVALID_SECURITY_DESCR", WERR_INVALID_SECURITY_DESCR },
	{ "WERR_BAD_INHERITANCE_ACL", WERR_BAD_INHERITANCE_ACL },
	{ "WERR_SERVER_DISABLED", WERR_SERVER_DISABLED },
	{ "WERR_SERVER_NOT_DISABLED", WERR_SERVER_NOT_DISABLED },
	{ "WERR_INVALID_ID_AUTHORITY", WERR_INVALID_ID_AUTHORITY },
	{ "WERR_ALLOTTED_SPACE_EXCEEDED", WERR_ALLOTTED_SPACE_EXCEEDED },
	{ "WERR_INVALID_GROUP_ATTRIBUTES", WERR_INVALID_GROUP_ATTRIBUTES },
	{ "WERR_BAD_IMPERSONATION_LEVEL", WERR_BAD_IMPERSONATION_LEVEL },
	{ "WERR_CANT_OPEN_ANONYMOUS", WERR_CANT_OPEN_ANONYMOUS },
	{ "WERR_BAD_VALIDATION_CLASS", WERR_BAD_VALIDATION_CLASS },
	{ "WERR_BAD_TOKEN_TYPE", WERR_BAD_TOKEN_TYPE },
	{ "WERR_NO_SECURITY_ON_OBJECT", WERR_NO_SECURITY_ON_OBJECT },
	{ "WERR_CANT_ACCESS_DOMAIN_INFO", WERR_CANT_ACCESS_DOMAIN_INFO },
	{ "WERR_INVALID_SERVER_STATE", WERR_INVALID_SERVER_STATE },
	{ "WERR_DOMAIN_EXISTS", WERR_DOMAIN_EXISTS },
	{ "WERR_DOMAIN_LIMIT_EXCEEDED", WERR_DOMAIN_LIMIT_EXCEEDED },
	{ "WERR_INTERNAL_DB_CORRUPTION", WERR_INTERNAL_DB_CORRUPTION },
	{ "WERR_INTERNAL_ERROR", WERR_INTERNAL_ERROR },
	{ "WERR_GENERIC_NOT_MAPPED", WERR_GENERIC_NOT_MAPPED },
	{ "WERR_BAD_DESCRIPTOR_FORMAT", WERR_BAD_DESCRIPTOR_FORMAT },
	{ "WERR_NOT_LOGON_PROCESS", WERR_NOT_LOGON_PROCESS },
	{ "WERR_LOGON_SESSION_EXISTS", WERR_LOGON_SESSION_EXISTS },
	{ "WERR_NO_SUCH_PACKAGE", WERR_NO_SUCH_PACKAGE },
	{ "WERR_BAD_LOGON_SESSION_STATE", WERR_BAD_LOGON_SESSION_STATE },
	{ "WERR_LOGON_SESSION_COLLISION", WERR_LOGON_SESSION_COLLISION },
	{ "WERR_INVALID_LOGON_TYPE", WERR_INVALID_LOGON_TYPE },
	{ "WERR_CANNOT_IMPERSONATE", WERR_CANNOT_IMPERSONATE },
	{ "WERR_RXACT_INVALID_STATE", WERR_RXACT_INVALID_STATE },
	{ "WERR_RXACT_COMMIT_FAILURE", WERR_RXACT_COMMIT_FAILURE },
	{ "WERR_SPECIAL_GROUP", WERR_SPECIAL_GROUP },
	{ "WERR_SPECIAL_USER", WERR_SPECIAL_USER },
	{ "WERR_MEMBERS_PRIMARY_GROUP", WERR_MEMBERS_PRIMARY_GROUP },
	{ "WERR_TOKEN_ALREADY_IN_USE", WERR_TOKEN_ALREADY_IN_USE },
	{ "WERR_MEMBER_NOT_IN_ALIAS", WERR_MEMBER_NOT_IN_ALIAS },
	{ "WERR_LOGON_NOT_GRANTED", WERR_LOGON_NOT_GRANTED },
	{ "WERR_TOO_MANY_SECRETS", WERR_TOO_MANY_SECRETS },
	{ "WERR_SECRET_TOO_LONG", WERR_SECRET_TOO_LONG },
	{ "WERR_INTERNAL_DB_ERROR", WERR_INTERNAL_DB_ERROR },
	{ "WERR_TOO_MANY_CONTEXT_IDS", WERR_TOO_MANY_CONTEXT_IDS },
	{ "WERR_LOGON_TYPE_NOT_GRANTED", WERR_LOGON_TYPE_NOT_GRANTED },
	{ "WERR_NT_CROSS_ENCRYPTION_REQUIRED", WERR_NT_CROSS_ENCRYPTION_REQUIRED },
	{ "WERR_NO_SUCH_MEMBER", WERR_NO_SUCH_MEMBER },
	{ "WERR_INVALID_MEMBER", WERR_INVALID_MEMBER },
	{ "WERR_TOO_MANY_SIDS", WERR_TOO_MANY_SIDS },
	{ "WERR_LM_CROSS_ENCRYPTION_REQUIRED", WERR_LM_CROSS_ENCRYPTION_REQUIRED },
	{ "WERR_NO_INHERITANCE", WERR_NO_INHERITANCE },
	{ "WERR_FILE_CORRUPT", WERR_FILE_CORRUPT },
	{ "WERR_DISK_CORRUPT", WERR_DISK_CORRUPT },
	{ "WERR_NO_USER_SESSION_KEY", WERR_NO_USER_SESSION_KEY },
	{ "WERR_LICENSE_QUOTA_EXCEEDED", WERR_LICENSE_QUOTA_EXCEEDED },
	{ "WERR_WRONG_TARGET_NAME", WERR_WRONG_TARGET_NAME },
	{ "WERR_MUTUAL_AUTH_FAILED", WERR_MUTUAL_AUTH_FAILED },
	{ "WERR_CURRENT_DOMAIN_NOT_ALLOWED", WERR_CURRENT_DOMAIN_NOT_ALLOWED },
	{ "WERR_INVALID_WINDOW_HANDLE", WERR_INVALID_WINDOW_HANDLE },
	{ "WERR_INVALID_MENU_HANDLE", WERR_INVALID_MENU_HANDLE },
	{ "WERR_INVALID_CURSOR_HANDLE", WERR_INVALID_CURSOR_HANDLE },
	{ "WERR_INVALID_ACCEL_HANDLE", WERR_INVALID_ACCEL_HANDLE },
	{ "WERR_INVALID_HOOK_HANDLE", WERR_INVALID_HOOK_HANDLE },
	{ "WERR_INVALID_DWP_HANDLE", WERR_INVALID_DWP_HANDLE },
	{ "WERR_TLW_WITH_WSCHILD", WERR_TLW_WITH_WSCHILD },
	{ "WERR_CANNOT_FIND_WND_CLASS", WERR_CANNOT_FIND_WND_CLASS },
	{ "WERR_WINDOW_OF_OTHER_THREAD", WERR_WINDOW_OF_OTHER_THREAD },
	{ "WERR_HOTKEY_ALREADY_REGISTERED", WERR_HOTKEY_ALREADY_REGISTERED },
	{ "WERR_CLASS_ALREADY_EXISTS", WERR_CLASS_ALREADY_EXISTS },
	{ "WERR_CLASS_DOES_NOT_EXIST", WERR_CLASS_DOES_NOT_EXIST },
	{ "WERR_CLASS_HAS_WINDOWS", WERR_CLASS_HAS_WINDOWS },
	{ "WERR_INVALID_INDEX", WERR_INVALID_INDEX },
	{ "WERR_INVALID_ICON_HANDLE", WERR_INVALID_ICON_HANDLE },
	{ "WERR_PRIVATE_DIALOG_INDEX", WERR_PRIVATE_DIALOG_INDEX },
	{ "WERR_LISTBOX_ID_NOT_FOUND", WERR_LISTBOX_ID_NOT_FOUND },
	{ "WERR_NO_WILDCARD_CHARACTERS", WERR_NO_WILDCARD_CHARACTERS },
	{ "WERR_CLIPBOARD_NOT_OPEN", WERR_CLIPBOARD_NOT_OPEN },
	{ "WERR_HOTKEY_NOT_REGISTERED", WERR_HOTKEY_NOT_REGISTERED },
	{ "WERR_WINDOW_NOT_DIALOG", WERR_WINDOW_NOT_DIALOG },
	{ "WERR_CONTROL_ID_NOT_FOUND", WERR_CONTROL_ID_NOT_FOUND },
	{ "WERR_INVALID_COMBOBOX_MESSAGE", WERR_INVALID_COMBOBOX_MESSAGE },
	{ "WERR_WINDOW_NOT_COMBOBOX", WERR_WINDOW_NOT_COMBOBOX },
	{ "WERR_INVALID_EDIT_HEIGHT", WERR_INVALID_EDIT_HEIGHT },
	{ "WERR_DC_NOT_FOUND", WERR_DC_NOT_FOUND },
	{ "WERR_INVALID_HOOK_FILTER", WERR_INVALID_HOOK_FILTER },
	{ "WERR_INVALID_FILTER_PROC", WERR_INVALID_FILTER_PROC },
	{ "WERR_HOOK_NEEDS_HMOD", WERR_HOOK_NEEDS_HMOD },
	{ "WERR_GLOBAL_ONLY_HOOK", WERR_GLOBAL_ONLY_HOOK },
	{ "WERR_JOURNAL_HOOK_SET", WERR_JOURNAL_HOOK_SET },
	{ "WERR_HOOK_NOT_INSTALLED", WERR_HOOK_NOT_INSTALLED },
	{ "WERR_INVALID_LB_MESSAGE", WERR_INVALID_LB_MESSAGE },
	{ "WERR_SETCOUNT_ON_BAD_LB", WERR_SETCOUNT_ON_BAD_LB },
	{ "WERR_LB_WITHOUT_TABSTOPS", WERR_LB_WITHOUT_TABSTOPS },
	{ "WERR_DESTROY_OBJECT_OF_OTHER_THREAD", WERR_DESTROY_OBJECT_OF_OTHER_THREAD },
	{ "WERR_CHILD_WINDOW_MENU", WERR_CHILD_WINDOW_MENU },
	{ "WERR_NO_SYSTEM_MENU", WERR_NO_SYSTEM_MENU },
	{ "WERR_INVALID_MSGBOX_STYLE", WERR_INVALID_MSGBOX_STYLE },
	{ "WERR_INVALID_SPI_VALUE", WERR_INVALID_SPI_VALUE },
	{ "WERR_SCREEN_ALREADY_LOCKED", WERR_SCREEN_ALREADY_LOCKED },
	{ "WERR_HWNDS_HAVE_DIFF_PARENT", WERR_HWNDS_HAVE_DIFF_PARENT },
	{ "WERR_NOT_CHILD_WINDOW", WERR_NOT_CHILD_WINDOW },
	{ "WERR_INVALID_GW_COMMAND", WERR_INVALID_GW_COMMAND },
	{ "WERR_INVALID_THREAD_ID", WERR_INVALID_THREAD_ID },
	{ "WERR_NON_MDICHILD_WINDOW", WERR_NON_MDICHILD_WINDOW },
	{ "WERR_POPUP_ALREADY_ACTIVE", WERR_POPUP_ALREADY_ACTIVE },
	{ "WERR_NO_SCROLLBARS", WERR_NO_SCROLLBARS },
	{ "WERR_INVALID_SCROLLBAR_RANGE", WERR_INVALID_SCROLLBAR_RANGE },
	{ "WERR_INVALID_SHOWWIN_COMMAND", WERR_INVALID_SHOWWIN_COMMAND },
	{ "WERR_NONPAGED_SYSTEM_RESOURCES", WERR_NONPAGED_SYSTEM_RESOURCES },
	{ "WERR_PAGED_SYSTEM_RESOURCES", WERR_PAGED_SYSTEM_RESOURCES },
	{ "WERR_WORKING_SET_QUOTA", WERR_WORKING_SET_QUOTA },
	{ "WERR_PAGEFILE_QUOTA", WERR_PAGEFILE_QUOTA },
	{ "WERR_COMMITMENT_LIMIT", WERR_COMMITMENT_LIMIT },
	{ "WERR_MENU_ITEM_NOT_FOUND", WERR_MENU_ITEM_NOT_FOUND },
	{ "WERR_INVALID_KEYBOARD_HANDLE", WERR_INVALID_KEYBOARD_HANDLE },
	{ "WERR_HOOK_TYPE_NOT_ALLOWED", WERR_HOOK_TYPE_NOT_ALLOWED },
	{ "WERR_REQUIRES_INTERACTIVE_WINDOWSTATION", WERR_REQUIRES_INTERACTIVE_WINDOWSTATION },
	{ "WERR_TIMEOUT", WERR_TIMEOUT },
	{ "WERR_INVALID_MONITOR_HANDLE", WERR_INVALID_MONITOR_HANDLE },
	{ "WERR_INCORRECT_SIZE", WERR_INCORRECT_SIZE },
	{ "WERR_SYMLINK_CLASS_DISABLED", WERR_SYMLINK_CLASS_DISABLED },
	{ "WERR_SYMLINK_NOT_SUPPORTED", WERR_SYMLINK_NOT_SUPPORTED },
	{ "WERR_EVENTLOG_CANT_START", WERR_EVENTLOG_CANT_START },
	{ "WERR_LOG_FILE_FULL", WERR_LOG_FILE_FULL },
	{ "WERR_EVENTLOG_FILE_CHANGED", WERR_EVENTLOG_FILE_CHANGED },
	{ "WERR_INVALID_TASK_NAME", WERR_INVALID_TASK_NAME },
	{ "WERR_INVALID_TASK_INDEX", WERR_INVALID_TASK_INDEX },
	{ "WERR_THREAD_ALREADY_IN_TASK", WERR_THREAD_ALREADY_IN_TASK },
	{ "WERR_INSTALL_SERVICE_FAILURE", WERR_INSTALL_SERVICE_FAILURE },
	{ "WERR_INSTALL_USEREXIT", WERR_INSTALL_USEREXIT },
	{ "WERR_INSTALL_FAILURE", WERR_INSTALL_FAILURE },
	{ "WERR_INSTALL_SUSPEND", WERR_INSTALL_SUSPEND },
	{ "WERR_UNKNOWN_PRODUCT", WERR_UNKNOWN_PRODUCT },
	{ "WERR_UNKNOWN_FEATURE", WERR_UNKNOWN_FEATURE },
	{ "WERR_UNKNOWN_COMPONENT", WERR_UNKNOWN_COMPONENT },
	{ "WERR_UNKNOWN_PROPERTY", WERR_UNKNOWN_PROPERTY },
	{ "WERR_INVALID_HANDLE_STATE", WERR_INVALID_HANDLE_STATE },
	{ "WERR_BAD_CONFIGURATION", WERR_BAD_CONFIGURATION },
	{ "WERR_INDEX_ABSENT", WERR_INDEX_ABSENT },
	{ "WERR_INSTALL_SOURCE_ABSENT", WERR_INSTALL_SOURCE_ABSENT },
	{ "WERR_INSTALL_PACKAGE_VERSION", WERR_INSTALL_PACKAGE_VERSION },
	{ "WERR_PRODUCT_UNINSTALLED", WERR_PRODUCT_UNINSTALLED },
	{ "WERR_BAD_QUERY_SYNTAX", WERR_BAD_QUERY_SYNTAX },
	{ "WERR_INVALID_FIELD", WERR_INVALID_FIELD },
	{ "WERR_DEVICE_REMOVED", WERR_DEVICE_REMOVED },
	{ "WERR_INSTALL_ALREADY_RUNNING", WERR_INSTALL_ALREADY_RUNNING },
	{ "WERR_INSTALL_PACKAGE_OPEN_FAILED", WERR_INSTALL_PACKAGE_OPEN_FAILED },
	{ "WERR_INSTALL_PACKAGE_INVALID", WERR_INSTALL_PACKAGE_INVALID },
	{ "WERR_INSTALL_UI_FAILURE", WERR_INSTALL_UI_FAILURE },
	{ "WERR_INSTALL_LOG_FAILURE", WERR_INSTALL_LOG_FAILURE },
	{ "WERR_INSTALL_LANGUAGE_UNSUPPORTED", WERR_INSTALL_LANGUAGE_UNSUPPORTED },
	{ "WERR_INSTALL_TRANSFORM_FAILURE", WERR_INSTALL_TRANSFORM_FAILURE },
	{ "WERR_INSTALL_PACKAGE_REJECTED", WERR_INSTALL_PACKAGE_REJECTED },
	{ "WERR_FUNCTION_NOT_CALLED", WERR_FUNCTION_NOT_CALLED },
	{ "WERR_FUNCTION_FAILED", WERR_FUNCTION_FAILED },
	{ "WERR_INVALID_TABLE", WERR_INVALID_TABLE },
	{ "WERR_DATATYPE_MISMATCH", WERR_DATATYPE_MISMATCH },
	{ "WERR_UNSUPPORTED_TYPE", WERR_UNSUPPORTED_TYPE },
	{ "WERR_CREATE_FAILED", WERR_CREATE_FAILED },
	{ "WERR_INSTALL_TEMP_UNWRITABLE", WERR_INSTALL_TEMP_UNWRITABLE },
	{ "WERR_INSTALL_PLATFORM_UNSUPPORTED", WERR_INSTALL_PLATFORM_UNSUPPORTED },
	{ "WERR_INSTALL_NOTUSED", WERR_INSTALL_NOTUSED },
	{ "WERR_PATCH_PACKAGE_OPEN_FAILED", WERR_PATCH_PACKAGE_OPEN_FAILED },
	{ "WERR_PATCH_PACKAGE_INVALID", WERR_PATCH_PACKAGE_INVALID },
	{ "WERR_PATCH_PACKAGE_UNSUPPORTED", WERR_PATCH_PACKAGE_UNSUPPORTED },
	{ "WERR_PRODUCT_VERSION", WERR_PRODUCT_VERSION },
	{ "WERR_INVALID_COMMAND_LINE", WERR_INVALID_COMMAND_LINE },
	{ "WERR_INSTALL_REMOTE_DISALLOWED", WERR_INSTALL_REMOTE_DISALLOWED },
	{ "WERR_SUCCESS_REBOOT_INITIATED", WERR_SUCCESS_REBOOT_INITIATED },
	{ "WERR_PATCH_TARGET_NOT_FOUND", WERR_PATCH_TARGET_NOT_FOUND },
	{ "WERR_PATCH_PACKAGE_REJECTED", WERR_PATCH_PACKAGE_REJECTED },
	{ "WERR_INSTALL_TRANSFORM_REJECTED", WERR_INSTALL_TRANSFORM_REJECTED },
	{ "WERR_INSTALL_REMOTE_PROHIBITED", WERR_INSTALL_REMOTE_PROHIBITED },
	{ "WERR_PATCH_REMOVAL_UNSUPPORTED", WERR_PATCH_REMOVAL_UNSUPPORTED },
	{ "WERR_UNKNOWN_PATCH", WERR_UNKNOWN_PATCH },
	{ "WERR_PATCH_NO_SEQUENCE", WERR_PATCH_NO_SEQUENCE },
	{ "WERR_PATCH_REMOVAL_DISALLOWED", WERR_PATCH_REMOVAL_DISALLOWED },
	{ "WERR_INVALID_PATCH_XML", WERR_INVALID_PATCH_XML },
	{ "WERR_PATCH_MANAGED_ADVERTISED_PRODUCT", WERR_PATCH_MANAGED_ADVERTISED_PRODUCT },
	{ "WERR_INSTALL_SERVICE_SAFEBOOT", WERR_INSTALL_SERVICE_SAFEBOOT },
	{ "WERR_RPC_S_INVALID_STRING_BINDING", WERR_RPC_S_INVALID_STRING_BINDING },
	{ "WERR_RPC_S_WRONG_KIND_OF_BINDING", WERR_RPC_S_WRONG_KIND_OF_BINDING },
	{ "WERR_RPC_S_INVALID_BINDING", WERR_RPC_S_INVALID_BINDING },
	{ "WERR_RPC_S_PROTSEQ_NOT_SUPPORTED", WERR_RPC_S_PROTSEQ_NOT_SUPPORTED },
	{ "WERR_RPC_S_INVALID_RPC_PROTSEQ", WERR_RPC_S_INVALID_RPC_PROTSEQ },
	{ "WERR_RPC_S_INVALID_STRING_UUID", WERR_RPC_S_INVALID_STRING_UUID },
	{ "WERR_RPC_S_INVALID_ENDPOINT_FORMAT", WERR_RPC_S_INVALID_ENDPOINT_FORMAT },
	{ "WERR_RPC_S_INVALID_NET_ADDR", WERR_RPC_S_INVALID_NET_ADDR },
	{ "WERR_RPC_S_NO_ENDPOINT_FOUND", WERR_RPC_S_NO_ENDPOINT_FOUND },
	{ "WERR_RPC_S_INVALID_TIMEOUT", WERR_RPC_S_INVALID_TIMEOUT },
	{ "WERR_RPC_S_OBJECT_NOT_FOUND", WERR_RPC_S_OBJECT_NOT_FOUND },
	{ "WERR_RPC_S_ALREADY_REGISTERED", WERR_RPC_S_ALREADY_REGISTERED },
	{ "WERR_RPC_S_TYPE_ALREADY_REGISTERED", WERR_RPC_S_TYPE_ALREADY_REGISTERED },
	{ "WERR_RPC_S_ALREADY_LISTENING", WERR_RPC_S_ALREADY_LISTENING },
	{ "WERR_RPC_S_NO_PROTSEQS_REGISTERED", WERR_RPC_S_NO_PROTSEQS_REGISTERED },
	{ "WERR_RPC_S_NOT_LISTENING", WERR_RPC_S_NOT_LISTENING },
	{ "WERR_RPC_S_UNKNOWN_MGR_TYPE", WERR_RPC_S_UNKNOWN_MGR_TYPE },
	{ "WERR_RPC_S_UNKNOWN_IF", WERR_RPC_S_UNKNOWN_IF },
	{ "WERR_RPC_S_NO_BINDINGS", WERR_RPC_S_NO_BINDINGS },
	{ "WERR_RPC_S_NO_PROTSEQS", WERR_RPC_S_NO_PROTSEQS },
	{ "WERR_RPC_S_CANT_CREATE_ENDPOINT", WERR_RPC_S_CANT_CREATE_ENDPOINT },
	{ "WERR_RPC_S_OUT_OF_RESOURCES", WERR_RPC_S_OUT_OF_RESOURCES },
	{ "WERR_RPC_S_SERVER_UNAVAILABLE", WERR_RPC_S_SERVER_UNAVAILABLE },
	{ "WERR_RPC_S_SERVER_TOO_BUSY", WERR_RPC_S_SERVER_TOO_BUSY },
	{ "WERR_RPC_S_INVALID_NETWORK_OPTIONS", WERR_RPC_S_INVALID_NETWORK_OPTIONS },
	{ "WERR_RPC_S_NO_CALL_ACTIVE", WERR_RPC_S_NO_CALL_ACTIVE },
	{ "WERR_RPC_S_CALL_FAILED", WERR_RPC_S_CALL_FAILED },
	{ "WERR_RPC_S_CALL_FAILED_DNE", WERR_RPC_S_CALL_FAILED_DNE },
	{ "WERR_RPC_S_PROTOCOL_ERROR", WERR_RPC_S_PROTOCOL_ERROR },
	{ "WERR_RPC_S_PROXY_ACCESS_DENIED", WERR_RPC_S_PROXY_ACCESS_DENIED },
	{ "WERR_RPC_S_UNSUPPORTED_TRANS_SYN", WERR_RPC_S_UNSUPPORTED_TRANS_SYN },
	{ "WERR_RPC_S_UNSUPPORTED_TYPE", WERR_RPC_S_UNSUPPORTED_TYPE },
	{ "WERR_RPC_S_INVALID_TAG", WERR_RPC_S_INVALID_TAG },
	{ "WERR_RPC_S_INVALID_BOUND", WERR_RPC_S_INVALID_BOUND },
	{ "WERR_RPC_S_NO_ENTRY_NAME", WERR_RPC_S_NO_ENTRY_NAME },
	{ "WERR_RPC_S_INVALID_NAME_SYNTAX", WERR_RPC_S_INVALID_NAME_SYNTAX },
	{ "WERR_RPC_S_UNSUPPORTED_NAME_SYNTAX", WERR_RPC_S_UNSUPPORTED_NAME_SYNTAX },
	{ "WERR_RPC_S_UUID_NO_ADDRESS", WERR_RPC_S_UUID_NO_ADDRESS },
	{ "WERR_RPC_S_DUPLICATE_ENDPOINT", WERR_RPC_S_DUPLICATE_ENDPOINT },
	{ "WERR_RPC_S_UNKNOWN_AUTHN_TYPE", WERR_RPC_S_UNKNOWN_AUTHN_TYPE },
	{ "WERR_RPC_S_MAX_CALLS_TOO_SMALL", WERR_RPC_S_MAX_CALLS_TOO_SMALL },
	{ "WERR_RPC_S_STRING_TOO_LONG", WERR_RPC_S_STRING_TOO_LONG },
	{ "WERR_RPC_S_PROTSEQ_NOT_FOUND", WERR_RPC_S_PROTSEQ_NOT_FOUND },
	{ "WERR_RPC_S_PROCNUM_OUT_OF_RANGE", WERR_RPC_S_PROCNUM_OUT_OF_RANGE },
	{ "WERR_RPC_S_BINDING_HAS_NO_AUTH", WERR_RPC_S_BINDING_HAS_NO_AUTH },
	{ "WERR_RPC_S_UNKNOWN_AUTHN_SERVICE", WERR_RPC_S_UNKNOWN_AUTHN_SERVICE },
	{ "WERR_RPC_S_UNKNOWN_AUTHN_LEVEL", WERR_RPC_S_UNKNOWN_AUTHN_LEVEL },
	{ "WERR_RPC_S_INVALID_AUTH_IDENTITY", WERR_RPC_S_INVALID_AUTH_IDENTITY },
	{ "WERR_RPC_S_UNKNOWN_AUTHZ_SERVICE", WERR_RPC_S_UNKNOWN_AUTHZ_SERVICE },
	{ "WERR_EPT_S_INVALID_ENTRY", WERR_EPT_S_INVALID_ENTRY },
	{ "WERR_EPT_S_CANT_PERFORM_OP", WERR_EPT_S_CANT_PERFORM_OP },
	{ "WERR_EPT_S_NOT_REGISTERED", WERR_EPT_S_NOT_REGISTERED },
	{ "WERR_RPC_S_NOTHING_TO_EXPORT", WERR_RPC_S_NOTHING_TO_EXPORT },
	{ "WERR_RPC_S_INCOMPLETE_NAME", WERR_RPC_S_INCOMPLETE_NAME },
	{ "WERR_RPC_S_INVALID_VERS_OPTION", WERR_RPC_S_INVALID_VERS_OPTION },
	{ "WERR_RPC_S_NO_MORE_MEMBERS", WERR_RPC_S_NO_MORE_MEMBERS },
	{ "WERR_RPC_S_NOT_ALL_OBJS_UNEXPORTED", WERR_RPC_S_NOT_ALL_OBJS_UNEXPORTED },
	{ "WERR_RPC_S_INTERFACE_NOT_FOUND", WERR_RPC_S_INTERFACE_NOT_FOUND },
	{ "WERR_RPC_S_ENTRY_ALREADY_EXISTS", WERR_RPC_S_ENTRY_ALREADY_EXISTS },
	{ "WERR_RPC_S_ENTRY_NOT_FOUND", WERR_RPC_S_ENTRY_NOT_FOUND },
	{ "WERR_RPC_S_NAME_SERVICE_UNAVAILABLE", WERR_RPC_S_NAME_SERVICE_UNAVAILABLE },
	{ "WERR_RPC_S_INVALID_NAF_ID", WERR_RPC_S_INVALID_NAF_ID },
	{ "WERR_RPC_S_CANNOT_SUPPORT", WERR_RPC_S_CANNOT_SUPPORT },
	{ "WERR_RPC_S_NO_CONTEXT_AVAILABLE", WERR_RPC_S_NO_CONTEXT_AVAILABLE },
	{ "WERR_RPC_S_INTERNAL_ERROR", WERR_RPC_S_INTERNAL_ERROR },
	{ "WERR_RPC_S_ZERO_DIVIDE", WERR_RPC_S_ZERO_DIVIDE },
	{ "WERR_RPC_S_ADDRESS_ERROR", WERR_RPC_S_ADDRESS_ERROR },
	{ "WERR_RPC_S_FP_DIV_ZERO", WERR_RPC_S_FP_DIV_ZERO },
	{ "WERR_RPC_S_FP_UNDERFLOW", WERR_RPC_S_FP_UNDERFLOW },
	{ "WERR_RPC_S_FP_OVERFLOW", WERR_RPC_S_FP_OVERFLOW },
	{ "WERR_RPC_X_NO_MORE_ENTRIES", WERR_RPC_X_NO_MORE_ENTRIES },
	{ "WERR_RPC_X_SS_CHAR_TRANS_OPEN_FAIL", WERR_RPC_X_SS_CHAR_TRANS_OPEN_FAIL },
	{ "WERR_RPC_X_SS_CHAR_TRANS_SHORT_FILE", WERR_RPC_X_SS_CHAR_TRANS_SHORT_FILE },
	{ "WERR_RPC_X_SS_IN_NULL_CONTEXT", WERR_RPC_X_SS_IN_NULL_CONTEXT },
	{ "WERR_RPC_X_SS_CONTEXT_DAMAGED", WERR_RPC_X_SS_CONTEXT_DAMAGED },
	{ "WERR_RPC_X_SS_HANDLES_MISMATCH", WERR_RPC_X_SS_HANDLES_MISMATCH },
	{ "WERR_RPC_X_SS_CANNOT_GET_CALL_HANDLE", WERR_RPC_X_SS_CANNOT_GET_CALL_HANDLE },
	{ "WERR_RPC_X_NULL_REF_POINTER", WERR_RPC_X_NULL_REF_POINTER },
	{ "WERR_RPC_X_ENUM_VALUE_OUT_OF_RANGE", WERR_RPC_X_ENUM_VALUE_OUT_OF_RANGE },
	{ "WERR_RPC_X_BYTE_COUNT_TOO_SMALL", WERR_RPC_X_BYTE_COUNT_TOO_SMALL },
	{ "WERR_RPC_X_BAD_STUB_DATA", WERR_RPC_X_BAD_STUB_DATA },
	{ "WERR_UNRECOGNIZED_MEDIA", WERR_UNRECOGNIZED_MEDIA },
	{ "WERR_NO_TRUST_LSA_SECRET", WERR_NO_TRUST_LSA_SECRET },
	{ "WERR_TRUSTED_DOMAIN_FAILURE", WERR_TRUSTED_DOMAIN_FAILURE },
	{ "WERR_TRUSTED_RELATIONSHIP_FAILURE", WERR_TRUSTED_RELATIONSHIP_FAILURE },
	{ "WERR_TRUST_FAILURE", WERR_TRUST_FAILURE },
	{ "WERR_RPC_S_CALL_IN_PROGRESS", WERR_RPC_S_CALL_IN_PROGRESS },
	{ "WERR_NETLOGON_NOT_STARTED", WERR_NETLOGON_NOT_STARTED },
	{ "WERR_ACCOUNT_EXPIRED", WERR_ACCOUNT_EXPIRED },
	{ "WERR_REDIRECTOR_HAS_OPEN_HANDLES", WERR_REDIRECTOR_HAS_OPEN_HANDLES },
	{ "WERR_RPC_S_NO_MORE_BINDINGS", WERR_RPC_S_NO_MORE_BINDINGS },
	{ "WERR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT", WERR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT },
	{ "WERR_NOLOGON_WORKSTATION_TRUST_ACCOUNT", WERR_NOLOGON_WORKSTATION_TRUST_ACCOUNT },
	{ "WERR_NOLOGON_SERVER_TRUST_ACCOUNT", WERR_NOLOGON_SERVER_TRUST_ACCOUNT },
	{ "WERR_DOMAIN_TRUST_INCONSISTENT", WERR_DOMAIN_TRUST_INCONSISTENT },
	{ "WERR_SERVER_HAS_OPEN_HANDLES", WERR_SERVER_HAS_OPEN_HANDLES },
	{ "WERR_RESOURCE_DATA_NOT_FOUND", WERR_RESOURCE_DATA_NOT_FOUND },
	{ "WERR_RESOURCE_TYPE_NOT_FOUND", WERR_RESOURCE_TYPE_NOT_FOUND },
	{ "WERR_RESOURCE_NAME_NOT_FOUND", WERR_RESOURCE_NAME_NOT_FOUND },
	{ "WERR_RESOURCE_LANG_NOT_FOUND", WERR_RESOURCE_LANG_NOT_FOUND },
	{ "WERR_NOT_ENOUGH_QUOTA", WERR_NOT_ENOUGH_QUOTA },
	{ "WERR_RPC_S_NO_INTERFACES", WERR_RPC_S_NO_INTERFACES },
	{ "WERR_RPC_S_CALL_CANCELLED", WERR_RPC_S_CALL_CANCELLED },
	{ "WERR_RPC_S_BINDING_INCOMPLETE", WERR_RPC_S_BINDING_INCOMPLETE },
	{ "WERR_RPC_S_COMM_FAILURE", WERR_RPC_S_COMM_FAILURE },
	{ "WERR_RPC_S_UNSUPPORTED_AUTHN_LEVEL", WERR_RPC_S_UNSUPPORTED_AUTHN_LEVEL },
	{ "WERR_RPC_S_NO_PRINC_NAME", WERR_RPC_S_NO_PRINC_NAME },
	{ "WERR_RPC_S_NOT_RPC_ERROR", WERR_RPC_S_NOT_RPC_ERROR },
	{ "WERR_RPC_S_UUID_LOCAL_ONLY", WERR_RPC_S_UUID_LOCAL_ONLY },
	{ "WERR_RPC_S_SEC_PKG_ERROR", WERR_RPC_S_SEC_PKG_ERROR },
	{ "WERR_RPC_S_NOT_CANCELLED", WERR_RPC_S_NOT_CANCELLED },
	{ "WERR_RPC_X_INVALID_ES_ACTION", WERR_RPC_X_INVALID_ES_ACTION },
	{ "WERR_RPC_X_WRONG_ES_VERSION", WERR_RPC_X_WRONG_ES_VERSION },
	{ "WERR_RPC_X_WRONG_STUB_VERSION", WERR_RPC_X_WRONG_STUB_VERSION },
	{ "WERR_RPC_X_INVALID_PIPE_OBJECT", WERR_RPC_X_INVALID_PIPE_OBJECT },
	{ "WERR_RPC_X_WRONG_PIPE_ORDER", WERR_RPC_X_WRONG_PIPE_ORDER },
	{ "WERR_RPC_X_WRONG_PIPE_VERSION", WERR_RPC_X_WRONG_PIPE_VERSION },
	{ "WERR_RPC_S_GROUP_MEMBER_NOT_FOUND", WERR_RPC_S_GROUP_MEMBER_NOT_FOUND },
	{ "WERR_EPT_S_CANT_CREATE", WERR_EPT_S_CANT_CREATE },
	{ "WERR_RPC_S_INVALID_OBJECT", WERR_RPC_S_INVALID_OBJECT },
	{ "WERR_INVALID_TIME", WERR_INVALID_TIME },
	{ "WERR_ALREADY_WAITING", WERR_ALREADY_WAITING },
	{ "WERR_PRINTER_DELETED", WERR_PRINTER_DELETED },
	{ "WERR_INVALID_PRINTER_STATE", WERR_INVALID_PRINTER_STATE },
	{ "WERR_OR_INVALID_OXID", WERR_OR_INVALID_OXID },
	{ "WERR_OR_INVALID_OID", WERR_OR_INVALID_OID },
	{ "WERR_OR_INVALID_SET", WERR_OR_INVALID_SET },
	{ "WERR_RPC_S_SEND_INCOMPLETE", WERR_RPC_S_SEND_INCOMPLETE },
	{ "WERR_RPC_S_INVALID_ASYNC_HANDLE", WERR_RPC_S_INVALID_ASYNC_HANDLE },
	{ "WERR_RPC_S_INVALID_ASYNC_CALL", WERR_RPC_S_INVALID_ASYNC_CALL },
	{ "WERR_RPC_X_PIPE_CLOSED", WERR_RPC_X_PIPE_CLOSED },
	{ "WERR_RPC_X_PIPE_DISCIPLINE_ERROR", WERR_RPC_X_PIPE_DISCIPLINE_ERROR },
	{ "WERR_RPC_X_PIPE_EMPTY", WERR_RPC_X_PIPE_EMPTY },
	{ "WERR_NO_SITENAME", WERR_NO_SITENAME },
	{ "WERR_CANT_ACCESS_FILE", WERR_CANT_ACCESS_FILE },
	{ "WERR_CANT_RESOLVE_FILENAME", WERR_CANT_RESOLVE_FILENAME },
	{ "WERR_RPC_S_ENTRY_TYPE_MISMATCH", WERR_RPC_S_ENTRY_TYPE_MISMATCH },
	{ "WERR_RPC_S_NOT_ALL_OBJS_EXPORTED", WERR_RPC_S_NOT_ALL_OBJS_EXPORTED },
	{ "WERR_RPC_S_INTERFACE_NOT_EXPORTED", WERR_RPC_S_INTERFACE_NOT_EXPORTED },
	{ "WERR_RPC_S_PROFILE_NOT_ADDED", WERR_RPC_S_PROFILE_NOT_ADDED },
	{ "WERR_RPC_S_PRF_ELT_NOT_ADDED", WERR_RPC_S_PRF_ELT_NOT_ADDED },
	{ "WERR_RPC_S_PRF_ELT_NOT_REMOVED", WERR_RPC_S_PRF_ELT_NOT_REMOVED },
	{ "WERR_RPC_S_GRP_ELT_NOT_ADDED", WERR_RPC_S_GRP_ELT_NOT_ADDED },
	{ "WERR_RPC_S_GRP_ELT_NOT_REMOVED", WERR_RPC_S_GRP_ELT_NOT_REMOVED },
	{ "WERR_KM_DRIVER_BLOCKED", WERR_KM_DRIVER_BLOCKED },
	{ "WERR_CONTEXT_EXPIRED", WERR_CONTEXT_EXPIRED },
	{ "WERR_PER_USER_TRUST_QUOTA_EXCEEDED", WERR_PER_USER_TRUST_QUOTA_EXCEEDED },
	{ "WERR_ALL_USER_TRUST_QUOTA_EXCEEDED", WERR_ALL_USER_TRUST_QUOTA_EXCEEDED },
	{ "WERR_USER_DELETE_TRUST_QUOTA_EXCEEDED", WERR_USER_DELETE_TRUST_QUOTA_EXCEEDED },
	{ "WERR_AUTHENTICATION_FIREWALL_FAILED", WERR_AUTHENTICATION_FIREWALL_FAILED },
	{ "WERR_REMOTE_PRINT_CONNECTIONS_BLOCKED", WERR_REMOTE_PRINT_CONNECTIONS_BLOCKED },
	{ "WERR_INVALID_PIXEL_FORMAT", WERR_INVALID_PIXEL_FORMAT },
	{ "WERR_BAD_DRIVER", WERR_BAD_DRIVER },
	{ "WERR_INVALID_WINDOW_STYLE", WERR_INVALID_WINDOW_STYLE },
	{ "WERR_METAFILE_NOT_SUPPORTED", WERR_METAFILE_NOT_SUPPORTED },
	{ "WERR_TRANSFORM_NOT_SUPPORTED", WERR_TRANSFORM_NOT_SUPPORTED },
	{ "WERR_CLIPPING_NOT_SUPPORTED", WERR_CLIPPING_NOT_SUPPORTED },
	{ "WERR_INVALID_CMM", WERR_INVALID_CMM },
	{ "WERR_INVALID_PROFILE", WERR_INVALID_PROFILE },
	{ "WERR_TAG_NOT_FOUND", WERR_TAG_NOT_FOUND },
	{ "WERR_TAG_NOT_PRESENT", WERR_TAG_NOT_PRESENT },
	{ "WERR_DUPLICATE_TAG", WERR_DUPLICATE_TAG },
	{ "WERR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE", WERR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE },
	{ "WERR_PROFILE_NOT_FOUND", WERR_PROFILE_NOT_FOUND },
	{ "WERR_INVALID_COLORSPACE", WERR_INVALID_COLORSPACE },
	{ "WERR_ICM_NOT_ENABLED", WERR_ICM_NOT_ENABLED },
	{ "WERR_DELETING_ICM_XFORM", WERR_DELETING_ICM_XFORM },
	{ "WERR_INVALID_TRANSFORM", WERR_INVALID_TRANSFORM },
	{ "WERR_COLORSPACE_MISMATCH", WERR_COLORSPACE_MISMATCH },
	{ "WERR_INVALID_COLORINDEX", WERR_INVALID_COLORINDEX },
	{ "WERR_PROFILE_DOES_NOT_MATCH_DEVICE", WERR_PROFILE_DOES_NOT_MATCH_DEVICE },
	{ "WERR_NERR_NETNOTSTARTED", WERR_NERR_NETNOTSTARTED },
	{ "WERR_NERR_UNKNOWNSERVER", WERR_NERR_UNKNOWNSERVER },
	{ "WERR_NERR_SHAREMEM", WERR_NERR_SHAREMEM },
	{ "WERR_NERR_NONETWORKRESOURCE", WERR_NERR_NONETWORKRESOURCE },
	{ "WERR_NERR_REMOTEONLY", WERR_NERR_REMOTEONLY },
	{ "WERR_NERR_DEVNOTREDIRECTED", WERR_NERR_DEVNOTREDIRECTED },
	{ "WERR_CONNECTED_OTHER_PASSWORD", WERR_CONNECTED_OTHER_PASSWORD },
	{ "WERR_CONNECTED_OTHER_PASSWORD_DEFAULT", WERR_CONNECTED_OTHER_PASSWORD_DEFAULT },
	{ "WERR_NERR_SERVERNOTSTARTED", WERR_NERR_SERVERNOTSTARTED },
	{ "WERR_NERR_ITEMNOTFOUND", WERR_NERR_ITEMNOTFOUND },
	{ "WERR_NERR_UNKNOWNDEVDIR", WERR_NERR_UNKNOWNDEVDIR },
	{ "WERR_NERR_REDIRECTEDPATH", WERR_NERR_REDIRECTEDPATH },
	{ "WERR_NERR_DUPLICATESHARE", WERR_NERR_DUPLICATESHARE },
	{ "WERR_NERR_NOROOM", WERR_NERR_NOROOM },
	{ "WERR_NERR_TOOMANYITEMS", WERR_NERR_TOOMANYITEMS },
	{ "WERR_NERR_INVALIDMAXUSERS", WERR_NERR_INVALIDMAXUSERS },
	{ "WERR_NERR_BUFTOOSMALL", WERR_NERR_BUFTOOSMALL },
	{ "WERR_NERR_REMOTEERR", WERR_NERR_REMOTEERR },
	{ "WERR_NERR_LANMANINIERROR", WERR_NERR_LANMANINIERROR },
	{ "WERR_NERR_NETWORKERROR", WERR_NERR_NETWORKERROR },
	{ "WERR_NERR_WKSTAINCONSISTENTSTATE", WERR_NERR_WKSTAINCONSISTENTSTATE },
	{ "WERR_NERR_WKSTANOTSTARTED", WERR_NERR_WKSTANOTSTARTED },
	{ "WERR_NERR_BROWSERNOTSTARTED", WERR_NERR_BROWSERNOTSTARTED },
	{ "WERR_NERR_INTERNALERROR", WERR_NERR_INTERNALERROR },
	{ "WERR_NERR_BADTRANSACTCONFIG", WERR_NERR_BADTRANSACTCONFIG },
	{ "WERR_NERR_INVALIDAPI", WERR_NERR_INVALIDAPI },
	{ "WERR_NERR_BADEVENTNAME", WERR_NERR_BADEVENTNAME },
	{ "WERR_NERR_DUPNAMEREBOOT", WERR_NERR_DUPNAMEREBOOT },
	{ "WERR_NERR_CFGCOMPNOTFOUND", WERR_NERR_CFGCOMPNOTFOUND },
	{ "WERR_NERR_CFGPARAMNOTFOUND", WERR_NERR_CFGPARAMNOTFOUND },
	{ "WERR_NERR_LINETOOLONG", WERR_NERR_LINETOOLONG },
	{ "WERR_NERR_QNOTFOUND", WERR_NERR_QNOTFOUND },
	{ "WERR_NERR_JOBNOTFOUND", WERR_NERR_JOBNOTFOUND },
	{ "WERR_NERR_DESTNOTFOUND", WERR_NERR_DESTNOTFOUND },
	{ "WERR_NERR_DESTEXISTS", WERR_NERR_DESTEXISTS },
	{ "WERR_NERR_QEXISTS", WERR_NERR_QEXISTS },
	{ "WERR_NERR_QNOROOM", WERR_NERR_QNOROOM },
	{ "WERR_NERR_JOBNOROOM", WERR_NERR_JOBNOROOM },
	{ "WERR_NERR_DESTNOROOM", WERR_NERR_DESTNOROOM },
	{ "WERR_NERR_DESTIDLE", WERR_NERR_DESTIDLE },
	{ "WERR_NERR_DESTINVALIDOP", WERR_NERR_DESTINVALIDOP },
	{ "WERR_NERR_PROCNORESPOND", WERR_NERR_PROCNORESPOND },
	{ "WERR_NERR_SPOOLERNOTLOADED", WERR_NERR_SPOOLERNOTLOADED },
	{ "WERR_NERR_DESTINVALIDSTATE", WERR_NERR_DESTINVALIDSTATE },
	{ "WERR_NERR_QINVALIDSTATE", WERR_NERR_QINVALIDSTATE },
	{ "WERR_NERR_JOBINVALIDSTATE", WERR_NERR_JOBINVALIDSTATE },
	{ "WERR_NERR_SPOOLNOMEMORY", WERR_NERR_SPOOLNOMEMORY },
	{ "WERR_NERR_DRIVERNOTFOUND", WERR_NERR_DRIVERNOTFOUND },
	{ "WERR_NERR_DATATYPEINVALID", WERR_NERR_DATATYPEINVALID },
	{ "WERR_NERR_PROCNOTFOUND", WERR_NERR_PROCNOTFOUND },
	{ "WERR_NERR_SERVICETABLELOCKED", WERR_NERR_SERVICETABLELOCKED },
	{ "WERR_NERR_SERVICETABLEFULL", WERR_NERR_SERVICETABLEFULL },
	{ "WERR_NERR_SERVICEINSTALLED", WERR_NERR_SERVICEINSTALLED },
	{ "WERR_NERR_SERVICEENTRYLOCKED", WERR_NERR_SERVICEENTRYLOCKED },
	{ "WERR_NERR_SERVICENOTINSTALLED", WERR_NERR_SERVICENOTINSTALLED },
	{ "WERR_NERR_BADSERVICENAME", WERR_NERR_BADSERVICENAME },
	{ "WERR_NERR_SERVICECTLTIMEOUT", WERR_NERR_SERVICECTLTIMEOUT },
	{ "WERR_NERR_SERVICECTLBUSY", WERR_NERR_SERVICECTLBUSY },
	{ "WERR_NERR_BADSERVICEPROGNAME", WERR_NERR_BADSERVICEPROGNAME },
	{ "WERR_NERR_SERVICENOTCTRL", WERR_NERR_SERVICENOTCTRL },
	{ "WERR_NERR_SERVICEKILLPROC", WERR_NERR_SERVICEKILLPROC },
	{ "WERR_NERR_SERVICECTLNOTVALID", WERR_NERR_SERVICECTLNOTVALID },
	{ "WERR_NERR_NOTINDISPATCHTBL", WERR_NERR_NOTINDISPATCHTBL },
	{ "WERR_NERR_BADCONTROLRECV", WERR_NERR_BADCONTROLRECV },
	{ "WERR_NERR_SERVICENOTSTARTING", WERR_NERR_SERVICENOTSTARTING },
	{ "WERR_NERR_ALREADYLOGGEDON", WERR_NERR_ALREADYLOGGEDON },
	{ "WERR_NERR_NOTLOGGEDON", WERR_NERR_NOTLOGGEDON },
	{ "WERR_NERR_BADUSERNAME", WERR_NERR_BADUSERNAME },
	{ "WERR_NERR_BADPASSWORD", WERR_NERR_BADPASSWORD },
	{ "WERR_NERR_UNABLETOADDNAME_W", WERR_NERR_UNABLETOADDNAME_W },
	{ "WERR_NERR_UNABLETOADDNAME_F", WERR_NERR_UNABLETOADDNAME_F },
	{ "WERR_NERR_UNABLETODELNAME_W", WERR_NERR_UNABLETODELNAME_W },
	{ "WERR_NERR_UNABLETODELNAME_F", WERR_NERR_UNABLETODELNAME_F },
	{ "WERR_NERR_LOGONSPAUSED", WERR_NERR_LOGONSPAUSED },
	{ "WERR_NERR_LOGONSERVERCONFLICT", WERR_NERR_LOGONSERVERCONFLICT },
	{ "WERR_NERR_LOGONNOUSERPATH", WERR_NERR_LOGONNOUSERPATH },
	{ "WERR_NERR_LOGONSCRIPTERROR", WERR_NERR_LOGONSCRIPTERROR },
	{ "WERR_NERR_STANDALONELOGON", WERR_NERR_STANDALONELOGON },
	{ "WERR_NERR_LOGONSERVERNOTFOUND", WERR_NERR_LOGONSERVERNOTFOUND },
	{ "WERR_NERR_LOGONDOMAINEXISTS", WERR_NERR_LOGONDOMAINEXISTS },
	{ "WERR_NERR_NONVALIDATEDLOGON", WERR_NERR_NONVALIDATEDLOGON },
	{ "WERR_NERR_ACFNOTFOUND", WERR_NERR_ACFNOTFOUND },
	{ "WERR_NERR_GROUPNOTFOUND", WERR_NERR_GROUPNOTFOUND },
	{ "WERR_NERR_USERNOTFOUND", WERR_NERR_USERNOTFOUND },
	{ "WERR_NERR_RESOURCENOTFOUND", WERR_NERR_RESOURCENOTFOUND },
	{ "WERR_NERR_GROUPEXISTS", WERR_NERR_GROUPEXISTS },
	{ "WERR_NERR_USEREXISTS", WERR_NERR_USEREXISTS },
	{ "WERR_NERR_RESOURCEEXISTS", WERR_NERR_RESOURCEEXISTS },
	{ "WERR_NERR_NOTPRIMARY", WERR_NERR_NOTPRIMARY },
	{ "WERR_NERR_ACFNOTLOADED", WERR_NERR_ACFNOTLOADED },
	{ "WERR_NERR_ACFNOROOM", WERR_NERR_ACFNOROOM },
	{ "WERR_NERR_ACFFILEIOFAIL", WERR_NERR_ACFFILEIOFAIL },
	{ "WERR_NERR_ACFTOOMANYLISTS", WERR_NERR_ACFTOOMANYLISTS },
	{ "WERR_NERR_USERLOGON", WERR_NERR_USERLOGON },
	{ "WERR_NERR_ACFNOPARENT", WERR_NERR_ACFNOPARENT },
	{ "WERR_NERR_CANNOTGROWSEGMENT", WERR_NERR_CANNOTGROWSEGMENT },
	{ "WERR_NERR_SPEGROUPOP", WERR_NERR_SPEGROUPOP },
	{ "WERR_NERR_NOTINCACHE", WERR_NERR_NOTINCACHE },
	{ "WERR_NERR_USERINGROUP", WERR_NERR_USERINGROUP },
	{ "WERR_NERR_USERNOTINGROUP", WERR_NERR_USERNOTINGROUP },
	{ "WERR_NERR_ACCOUNTUNDEFINED", WERR_NERR_ACCOUNTUNDEFINED },
	{ "WERR_NERR_ACCOUNTEXPIRED", WERR_NERR_ACCOUNTEXPIRED },
	{ "WERR_NERR_INVALIDWORKSTATION", WERR_NERR_INVALIDWORKSTATION },
	{ "WERR_NERR_INVALIDLOGONHOURS", WERR_NERR_INVALIDLOGONHOURS },
	{ "WERR_NERR_PASSWORDEXPIRED", WERR_NERR_PASSWORDEXPIRED },
	{ "WERR_NERR_PASSWORDCANTCHANGE", WERR_NERR_PASSWORDCANTCHANGE },
	{ "WERR_NERR_PASSWORDHISTCONFLICT", WERR_NERR_PASSWORDHISTCONFLICT },
	{ "WERR_NERR_PASSWORDTOOSHORT", WERR_NERR_PASSWORDTOOSHORT },
	{ "WERR_NERR_PASSWORDTOORECENT", WERR_NERR_PASSWORDTOORECENT },
	{ "WERR_NERR_INVALIDDATABASE", WERR_NERR_INVALIDDATABASE },
	{ "WERR_NERR_DATABASEUPTODATE", WERR_NERR_DATABASEUPTODATE },
	{ "WERR_NERR_SYNCREQUIRED", WERR_NERR_SYNCREQUIRED },
	{ "WERR_NERR_USENOTFOUND", WERR_NERR_USENOTFOUND },
	{ "WERR_NERR_BADASGTYPE", WERR_NERR_BADASGTYPE },
	{ "WERR_NERR_DEVICEISSHARED", WERR_NERR_DEVICEISSHARED },
	{ "WERR_NERR_NOCOMPUTERNAME", WERR_NERR_NOCOMPUTERNAME },
	{ "WERR_NERR_MSGALREADYSTARTED", WERR_NERR_MSGALREADYSTARTED },
	{ "WERR_NERR_MSGINITFAILED", WERR_NERR_MSGINITFAILED },
	{ "WERR_NERR_NAMENOTFOUND", WERR_NERR_NAMENOTFOUND },
	{ "WERR_NERR_ALREADYFORWARDED", WERR_NERR_ALREADYFORWARDED },
	{ "WERR_NERR_ADDFORWARDED", WERR_NERR_ADDFORWARDED },
	{ "WERR_NERR_ALREADYEXISTS", WERR_NERR_ALREADYEXISTS },
	{ "WERR_NERR_TOOMANYNAMES", WERR_NERR_TOOMANYNAMES },
	{ "WERR_NERR_DELCOMPUTERNAME", WERR_NERR_DELCOMPUTERNAME },
	{ "WERR_NERR_LOCALFORWARD", WERR_NERR_LOCALFORWARD },
	{ "WERR_NERR_GRPMSGPROCESSOR", WERR_NERR_GRPMSGPROCESSOR },
	{ "WERR_NERR_PAUSEDREMOTE", WERR_NERR_PAUSEDREMOTE },
	{ "WERR_NERR_BADRECEIVE", WERR_NERR_BADRECEIVE },
	{ "WERR_NERR_NAMEINUSE", WERR_NERR_NAMEINUSE },
	{ "WERR_NERR_MSGNOTSTARTED", WERR_NERR_MSGNOTSTARTED },
	{ "WERR_NERR_NOTLOCALNAME", WERR_NERR_NOTLOCALNAME },
	{ "WERR_NERR_NOFORWARDNAME", WERR_NERR_NOFORWARDNAME },
	{ "WERR_NERR_REMOTEFULL", WERR_NERR_REMOTEFULL },
	{ "WERR_NERR_NAMENOTFORWARDED", WERR_NERR_NAMENOTFORWARDED },
	{ "WERR_NERR_TRUNCATEDBROADCAST", WERR_NERR_TRUNCATEDBROADCAST },
	{ "WERR_NERR_INVALIDDEVICE", WERR_NERR_INVALIDDEVICE },
	{ "WERR_NERR_WRITEFAULT", WERR_NERR_WRITEFAULT },
	{ "WERR_NERR_DUPLICATENAME", WERR_NERR_DUPLICATENAME },
	{ "WERR_NERR_DELETELATER", WERR_NERR_DELETELATER },
	{ "WERR_NERR_INCOMPLETEDEL", WERR_NERR_INCOMPLETEDEL },
	{ "WERR_NERR_MULTIPLENETS", WERR_NERR_MULTIPLENETS },
	{ "WERR_NERR_NETNAMENOTFOUND", WERR_NERR_NETNAMENOTFOUND },
	{ "WERR_NERR_DEVICENOTSHARED", WERR_NERR_DEVICENOTSHARED },
	{ "WERR_NERR_CLIENTNAMENOTFOUND", WERR_NERR_CLIENTNAMENOTFOUND },
	{ "WERR_NERR_FILEIDNOTFOUND", WERR_NERR_FILEIDNOTFOUND },
	{ "WERR_NERR_EXECFAILURE", WERR_NERR_EXECFAILURE },
	{ "WERR_NERR_TMPFILE", WERR_NERR_TMPFILE },
	{ "WERR_NERR_TOOMUCHDATA", WERR_NERR_TOOMUCHDATA },
	{ "WERR_NERR_DEVICESHARECONFLICT", WERR_NERR_DEVICESHARECONFLICT },
	{ "WERR_NERR_BROWSERTABLEINCOMPLETE", WERR_NERR_BROWSERTABLEINCOMPLETE },
	{ "WERR_NERR_NOTLOCALDOMAIN", WERR_NERR_NOTLOCALDOMAIN },
	{ "WERR_NERR_ISDFSSHARE", WERR_NERR_ISDFSSHARE },
	{ "WERR_NERR_DEVINVALIDOPCODE", WERR_NERR_DEVINVALIDOPCODE },
	{ "WERR_NERR_DEVNOTFOUND", WERR_NERR_DEVNOTFOUND },
	{ "WERR_NERR_DEVNOTOPEN", WERR_NERR_DEVNOTOPEN },
	{ "WERR_NERR_BADQUEUEDEVSTRING", WERR_NERR_BADQUEUEDEVSTRING },
	{ "WERR_NERR_BADQUEUEPRIORITY", WERR_NERR_BADQUEUEPRIORITY },
	{ "WERR_NERR_NOCOMMDEVS", WERR_NERR_NOCOMMDEVS },
	{ "WERR_NERR_QUEUENOTFOUND", WERR_NERR_QUEUENOTFOUND },
	{ "WERR_NERR_BADDEVSTRING", WERR_NERR_BADDEVSTRING },
	{ "WERR_NERR_BADDEV", WERR_NERR_BADDEV },
	{ "WERR_NERR_INUSEBYSPOOLER", WERR_NERR_INUSEBYSPOOLER },
	{ "WERR_NERR_COMMDEVINUSE", WERR_NERR_COMMDEVINUSE },
	{ "WERR_NERR_INVALIDCOMPUTER", WERR_NERR_INVALIDCOMPUTER },
	{ "WERR_NERR_MAXLENEXCEEDED", WERR_NERR_MAXLENEXCEEDED },
	{ "WERR_NERR_BADCOMPONENT", WERR_NERR_BADCOMPONENT },
	{ "WERR_NERR_CANTTYPE", WERR_NERR_CANTTYPE },
	{ "WERR_NERR_TOOMANYENTRIES", WERR_NERR_TOOMANYENTRIES },
	{ "WERR_NERR_PROFILEFILETOOBIG", WERR_NERR_PROFILEFILETOOBIG },
	{ "WERR_NERR_PROFILEOFFSET", WERR_NERR_PROFILEOFFSET },
	{ "WERR_NERR_PROFILECLEANUP", WERR_NERR_PROFILECLEANUP },
	{ "WERR_NERR_PROFILEUNKNOWNCMD", WERR_NERR_PROFILEUNKNOWNCMD },
	{ "WERR_NERR_PROFILELOADERR", WERR_NERR_PROFILELOADERR },
	{ "WERR_NERR_PROFILESAVEERR", WERR_NERR_PROFILESAVEERR },
	{ "WERR_NERR_LOGOVERFLOW", WERR_NERR_LOGOVERFLOW },
	{ "WERR_NERR_LOGFILECHANGED", WERR_NERR_LOGFILECHANGED },
	{ "WERR_NERR_LOGFILECORRUPT", WERR_NERR_LOGFILECORRUPT },
	{ "WERR_NERR_SOURCEISDIR", WERR_NERR_SOURCEISDIR },
	{ "WERR_NERR_BADSOURCE", WERR_NERR_BADSOURCE },
	{ "WERR_NERR_BADDEST", WERR_NERR_BADDEST },
	{ "WERR_NERR_DIFFERENTSERVERS", WERR_NERR_DIFFERENTSERVERS },
	{ "WERR_NERR_RUNSRVPAUSED", WERR_NERR_RUNSRVPAUSED },
	{ "WERR_NERR_ERRCOMMRUNSRV", WERR_NERR_ERRCOMMRUNSRV },
	{ "WERR_NERR_ERROREXECINGGHOST", WERR_NERR_ERROREXECINGGHOST },
	{ "WERR_NERR_SHARENOTFOUND", WERR_NERR_SHARENOTFOUND },
	{ "WERR_NERR_INVALIDLANA", WERR_NERR_INVALIDLANA },
	{ "WERR_NERR_OPENFILES", WERR_NERR_OPENFILES },
	{ "WERR_NERR_ACTIVECONNS", WERR_NERR_ACTIVECONNS },
	{ "WERR_NERR_BADPASSWORDCORE", WERR_NERR_BADPASSWORDCORE },
	{ "WERR_NERR_DEVINUSE", WERR_NERR_DEVINUSE },
	{ "WERR_NERR_LOCALDRIVE", WERR_NERR_LOCALDRIVE },
	{ "WERR_NERR_ALERTEXISTS", WERR_NERR_ALERTEXISTS },
	{ "WERR_NERR_TOOMANYALERTS", WERR_NERR_TOOMANYALERTS },
	{ "WERR_NERR_NOSUCHALERT", WERR_NERR_NOSUCHALERT },
	{ "WERR_NERR_BADRECIPIENT", WERR_NERR_BADRECIPIENT },
	{ "WERR_NERR_ACCTLIMITEXCEEDED", WERR_NERR_ACCTLIMITEXCEEDED },
	{ "WERR_NERR_INVALIDLOGSEEK", WERR_NERR_INVALIDLOGSEEK },
	{ "WERR_NERR_BADUASCONFIG", WERR_NERR_BADUASCONFIG },
	{ "WERR_NERR_INVALIDUASOP", WERR_NERR_INVALIDUASOP },
	{ "WERR_NERR_LASTADMIN", WERR_NERR_LASTADMIN },
	{ "WERR_NERR_DCNOTFOUND", WERR_NERR_DCNOTFOUND },
	{ "WERR_NERR_LOGONTRACKINGERROR", WERR_NERR_LOGONTRACKINGERROR },
	{ "WERR_NERR_NETLOGONNOTSTARTED", WERR_NERR_NETLOGONNOTSTARTED },
	{ "WERR_NERR_CANNOTGROWUASFILE", WERR_NERR_CANNOTGROWUASFILE },
	{ "WERR_NERR_TIMEDIFFATDC", WERR_NERR_TIMEDIFFATDC },
	{ "WERR_NERR_PASSWORDMISMATCH", WERR_NERR_PASSWORDMISMATCH },
	{ "WERR_NERR_NOSUCHSERVER", WERR_NERR_NOSUCHSERVER },
	{ "WERR_NERR_NOSUCHSESSION", WERR_NERR_NOSUCHSESSION },
	{ "WERR_NERR_NOSUCHCONNECTION", WERR_NERR_NOSUCHCONNECTION },
	{ "WERR_NERR_TOOMANYSERVERS", WERR_NERR_TOOMANYSERVERS },
	{ "WERR_NERR_TOOMANYSESSIONS", WERR_NERR_TOOMANYSESSIONS },
	{ "WERR_NERR_TOOMANYCONNECTIONS", WERR_NERR_TOOMANYCONNECTIONS },
	{ "WERR_NERR_TOOMANYFILES", WERR_NERR_TOOMANYFILES },
	{ "WERR_NERR_NOALTERNATESERVERS", WERR_NERR_NOALTERNATESERVERS },
	{ "WERR_NERR_TRYDOWNLEVEL", WERR_NERR_TRYDOWNLEVEL },
	{ "WERR_NERR_UPSDRIVERNOTSTARTED", WERR_NERR_UPSDRIVERNOTSTARTED },
	{ "WERR_NERR_UPSINVALIDCONFIG", WERR_NERR_UPSINVALIDCONFIG },
	{ "WERR_NERR_UPSINVALIDCOMMPORT", WERR_NERR_UPSINVALIDCOMMPORT },
	{ "WERR_NERR_UPSSIGNALASSERTED", WERR_NERR_UPSSIGNALASSERTED },
	{ "WERR_NERR_UPSSHUTDOWNFAILED", WERR_NERR_UPSSHUTDOWNFAILED },
	{ "WERR_NERR_BADDOSRETCODE", WERR_NERR_BADDOSRETCODE },
	{ "WERR_NERR_PROGNEEDSEXTRAMEM", WERR_NERR_PROGNEEDSEXTRAMEM },
	{ "WERR_NERR_BADDOSFUNCTION", WERR_NERR_BADDOSFUNCTION },
	{ "WERR_NERR_REMOTEBOOTFAILED", WERR_NERR_REMOTEBOOTFAILED },
	{ "WERR_NERR_BADFILECHECKSUM", WERR_NERR_BADFILECHECKSUM },
	{ "WERR_NERR_NORPLBOOTSYSTEM", WERR_NERR_NORPLBOOTSYSTEM },
	{ "WERR_NERR_RPLLOADRNETBIOSERR", WERR_NERR_RPLLOADRNETBIOSERR },
	{ "WERR_NERR_RPLLOADRDISKERR", WERR_NERR_RPLLOADRDISKERR },
	{ "WERR_NERR_IMAGEPARAMERR", WERR_NERR_IMAGEPARAMERR },
	{ "WERR_NERR_TOOMANYIMAGEPARAMS", WERR_NERR_TOOMANYIMAGEPARAMS },
	{ "WERR_NERR_NONDOSFLOPPYUSED", WERR_NERR_NONDOSFLOPPYUSED },
	{ "WERR_NERR_RPLBOOTRESTART", WERR_NERR_RPLBOOTRESTART },
	{ "WERR_NERR_RPLSRVRCALLFAILED", WERR_NERR_RPLSRVRCALLFAILED },
	{ "WERR_NERR_CANTCONNECTRPLSRVR", WERR_NERR_CANTCONNECTRPLSRVR },
	{ "WERR_NERR_CANTOPENIMAGEFILE", WERR_NERR_CANTOPENIMAGEFILE },
	{ "WERR_NERR_CALLINGRPLSRVR", WERR_NERR_CALLINGRPLSRVR },
	{ "WERR_NERR_STARTINGRPLBOOT", WERR_NERR_STARTINGRPLBOOT },
	{ "WERR_NERR_RPLBOOTSERVICETERM", WERR_NERR_RPLBOOTSERVICETERM },
	{ "WERR_NERR_RPLBOOTSTARTFAILED", WERR_NERR_RPLBOOTSTARTFAILED },
	{ "WERR_NERR_RPL_CONNECTED", WERR_NERR_RPL_CONNECTED },
	{ "WERR_NERR_BROWSERCONFIGUREDTONOTRUN", WERR_NERR_BROWSERCONFIGUREDTONOTRUN },
	{ "WERR_NERR_RPLNOADAPTERSSTARTED", WERR_NERR_RPLNOADAPTERSSTARTED },
	{ "WERR_NERR_RPLBADREGISTRY", WERR_NERR_RPLBADREGISTRY },
	{ "WERR_NERR_RPLBADDATABASE", WERR_NERR_RPLBADDATABASE },
	{ "WERR_NERR_RPLRPLFILESSHARE", WERR_NERR_RPLRPLFILESSHARE },
	{ "WERR_NERR_RPLNOTRPLSERVER", WERR_NERR_RPLNOTRPLSERVER },
	{ "WERR_NERR_RPLCANNOTENUM", WERR_NERR_RPLCANNOTENUM },
	{ "WERR_NERR_RPLWKSTAINFOCORRUPTED", WERR_NERR_RPLWKSTAINFOCORRUPTED },
	{ "WERR_NERR_RPLWKSTANOTFOUND", WERR_NERR_RPLWKSTANOTFOUND },
	{ "WERR_NERR_RPLWKSTANAMEUNAVAILABLE", WERR_NERR_RPLWKSTANAMEUNAVAILABLE },
	{ "WERR_NERR_RPLPROFILEINFOCORRUPTED", WERR_NERR_RPLPROFILEINFOCORRUPTED },
	{ "WERR_NERR_RPLPROFILENOTFOUND", WERR_NERR_RPLPROFILENOTFOUND },
	{ "WERR_NERR_RPLPROFILENAMEUNAVAILABLE", WERR_NERR_RPLPROFILENAMEUNAVAILABLE },
	{ "WERR_NERR_RPLPROFILENOTEMPTY", WERR_NERR_RPLPROFILENOTEMPTY },
	{ "WERR_NERR_RPLCONFIGINFOCORRUPTED", WERR_NERR_RPLCONFIGINFOCORRUPTED },
	{ "WERR_NERR_RPLCONFIGNOTFOUND", WERR_NERR_RPLCONFIGNOTFOUND },
	{ "WERR_NERR_RPLADAPTERINFOCORRUPTED", WERR_NERR_RPLADAPTERINFOCORRUPTED },
	{ "WERR_NERR_RPLINTERNAL", WERR_NERR_RPLINTERNAL },
	{ "WERR_NERR_RPLVENDORINFOCORRUPTED", WERR_NERR_RPLVENDORINFOCORRUPTED },
	{ "WERR_NERR_RPLBOOTINFOCORRUPTED", WERR_NERR_RPLBOOTINFOCORRUPTED },
	{ "WERR_NERR_RPLWKSTANEEDSUSERACCT", WERR_NERR_RPLWKSTANEEDSUSERACCT },
	{ "WERR_NERR_RPLNEEDSRPLUSERACCT", WERR_NERR_RPLNEEDSRPLUSERACCT },
	{ "WERR_NERR_RPLBOOTNOTFOUND", WERR_NERR_RPLBOOTNOTFOUND },
	{ "WERR_NERR_RPLINCOMPATIBLEPROFILE", WERR_NERR_RPLINCOMPATIBLEPROFILE },
	{ "WERR_NERR_RPLADAPTERNAMEUNAVAILABLE", WERR_NERR_RPLADAPTERNAMEUNAVAILABLE },
	{ "WERR_NERR_RPLCONFIGNOTEMPTY", WERR_NERR_RPLCONFIGNOTEMPTY },
	{ "WERR_NERR_RPLBOOTINUSE", WERR_NERR_RPLBOOTINUSE },
	{ "WERR_NERR_RPLBACKUPDATABASE", WERR_NERR_RPLBACKUPDATABASE },
	{ "WERR_NERR_RPLADAPTERNOTFOUND", WERR_NERR_RPLADAPTERNOTFOUND },
	{ "WERR_NERR_RPLVENDORNOTFOUND", WERR_NERR_RPLVENDORNOTFOUND },
	{ "WERR_NERR_RPLVENDORNAMEUNAVAILABLE", WERR_NERR_RPLVENDORNAMEUNAVAILABLE },
	{ "WERR_NERR_RPLBOOTNAMEUNAVAILABLE", WERR_NERR_RPLBOOTNAMEUNAVAILABLE },
	{ "WERR_NERR_RPLCONFIGNAMEUNAVAILABLE", WERR_NERR_RPLCONFIGNAMEUNAVAILABLE },
	{ "WERR_NERR_DFSINTERNALCORRUPTION", WERR_NERR_DFSINTERNALCORRUPTION },
	{ "WERR_NERR_DFSVOLUMEDATACORRUPT", WERR_NERR_DFSVOLUMEDATACORRUPT },
	{ "WERR_NERR_DFSNOSUCHVOLUME", WERR_NERR_DFSNOSUCHVOLUME },
	{ "WERR_NERR_DFSVOLUMEALREADYEXISTS", WERR_NERR_DFSVOLUMEALREADYEXISTS },
	{ "WERR_NERR_DFSALREADYSHARED", WERR_NERR_DFSALREADYSHARED },
	{ "WERR_NERR_DFSNOSUCHSHARE", WERR_NERR_DFSNOSUCHSHARE },
	{ "WERR_NERR_DFSNOTALEAFVOLUME", WERR_NERR_DFSNOTALEAFVOLUME },
	{ "WERR_NERR_DFSLEAFVOLUME", WERR_NERR_DFSLEAFVOLUME },
	{ "WERR_NERR_DFSVOLUMEHASMULTIPLESERVERS", WERR_NERR_DFSVOLUMEHASMULTIPLESERVERS },
	{ "WERR_NERR_DFSCANTCREATEJUNCTIONPOINT", WERR_NERR_DFSCANTCREATEJUNCTIONPOINT },
	{ "WERR_NERR_DFSSERVERNOTDFSAWARE", WERR_NERR_DFSSERVERNOTDFSAWARE },
	{ "WERR_NERR_DFSBADRENAMEPATH", WERR_NERR_DFSBADRENAMEPATH },
	{ "WERR_NERR_DFSVOLUMEISOFFLINE", WERR_NERR_DFSVOLUMEISOFFLINE },
	{ "WERR_NERR_DFSNOSUCHSERVER", WERR_NERR_DFSNOSUCHSERVER },
	{ "WERR_NERR_DFSCYCLICALNAME", WERR_NERR_DFSCYCLICALNAME },
	{ "WERR_NERR_DFSNOTSUPPORTEDINSERVERDFS", WERR_NERR_DFSNOTSUPPORTEDINSERVERDFS },
	{ "WERR_NERR_DFSDUPLICATESERVICE", WERR_NERR_DFSDUPLICATESERVICE },
	{ "WERR_NERR_DFSCANTREMOVELASTSERVERSHARE", WERR_NERR_DFSCANTREMOVELASTSERVERSHARE },
	{ "WERR_NERR_DFSVOLUMEISINTERDFS", WERR_NERR_DFSVOLUMEISINTERDFS },
	{ "WERR_NERR_DFSINCONSISTENT", WERR_NERR_DFSINCONSISTENT },
	{ "WERR_NERR_DFSSERVERUPGRADED", WERR_NERR_DFSSERVERUPGRADED },
	{ "WERR_NERR_DFSDATAISIDENTICAL", WERR_NERR_DFSDATAISIDENTICAL },
	{ "WERR_NERR_DFSCANTREMOVEDFSROOT", WERR_NERR_DFSCANTREMOVEDFSROOT },
	{ "WERR_NERR_DFSCHILDORPARENTINDFS", WERR_NERR_DFSCHILDORPARENTINDFS },
	{ "WERR_NERR_DFSINTERNALERROR", WERR_NERR_DFSINTERNALERROR },
	{ "WERR_NERR_SETUPALREADYJOINED", WERR_NERR_SETUPALREADYJOINED },
	{ "WERR_NERR_SETUPNOTJOINED", WERR_NERR_SETUPNOTJOINED },
	{ "WERR_NERR_SETUPDOMAINCONTROLLER", WERR_NERR_SETUPDOMAINCONTROLLER },
	{ "WERR_NERR_DEFAULTJOINREQUIRED", WERR_NERR_DEFAULTJOINREQUIRED },
	{ "WERR_NERR_INVALIDWORKGROUPNAME", WERR_NERR_INVALIDWORKGROUPNAME },
	{ "WERR_NERR_NAMEUSESINCOMPATIBLECODEPAGE", WERR_NERR_NAMEUSESINCOMPATIBLECODEPAGE },
	{ "WERR_NERR_COMPUTERACCOUNTNOTFOUND", WERR_NERR_COMPUTERACCOUNTNOTFOUND },
	{ "WERR_NERR_PERSONALSKU", WERR_NERR_PERSONALSKU },
	{ "WERR_NERR_PASSWORDMUSTCHANGE", WERR_NERR_PASSWORDMUSTCHANGE },
	{ "WERR_NERR_ACCOUNTLOCKEDOUT", WERR_NERR_ACCOUNTLOCKEDOUT },
	{ "WERR_NERR_PASSWORDTOOLONG", WERR_NERR_PASSWORDTOOLONG },
	{ "WERR_NERR_PASSWORDNOTCOMPLEXENOUGH", WERR_NERR_PASSWORDNOTCOMPLEXENOUGH },
	{ "WERR_NERR_PASSWORDFILTERERROR", WERR_NERR_PASSWORDFILTERERROR },
	{ "WERR_SUCCESS_REBOOT_REQUIRED", WERR_SUCCESS_REBOOT_REQUIRED },
	{ "WERR_SUCCESS_RESTART_REQUIRED", WERR_SUCCESS_RESTART_REQUIRED },
	{ "WERR_PRINTER_NOT_FOUND", WERR_PRINTER_NOT_FOUND },
	{ "WERR_PRINTER_DRIVER_WARNED", WERR_PRINTER_DRIVER_WARNED },
	{ "WERR_PRINTER_DRIVER_BLOCKED", WERR_PRINTER_DRIVER_BLOCKED },
	{ "WERR_PRINTER_DRIVER_PACKAGE_IN_USE", WERR_PRINTER_DRIVER_PACKAGE_IN_USE },
	{ "WERR_CORE_DRIVER_PACKAGE_NOT_FOUND", WERR_CORE_DRIVER_PACKAGE_NOT_FOUND },
	{ "WERR_FAIL_REBOOT_REQUIRED", WERR_FAIL_REBOOT_REQUIRED },
	{ "WERR_FAIL_REBOOT_INITIATED", WERR_FAIL_REBOOT_INITIATED },
	{ "WERR_IO_REISSUE_AS_CACHED", WERR_IO_REISSUE_AS_CACHED },
	{ "WERR_WINS_INTERNAL", WERR_WINS_INTERNAL },
	{ "WERR_CAN_NOT_DEL_LOCAL_WINS", WERR_CAN_NOT_DEL_LOCAL_WINS },
	{ "WERR_STATIC_INIT", WERR_STATIC_INIT },
	{ "WERR_INC_BACKUP", WERR_INC_BACKUP },
	{ "WERR_FULL_BACKUP", WERR_FULL_BACKUP },
	{ "WERR_REC_NON_EXISTENT", WERR_REC_NON_EXISTENT },
	{ "WERR_RPL_NOT_ALLOWED", WERR_RPL_NOT_ALLOWED },
	{ "WERR_DHCP_ADDRESS_CONFLICT", WERR_DHCP_ADDRESS_CONFLICT },
	{ "WERR_WMI_GUID_NOT_FOUND", WERR_WMI_GUID_NOT_FOUND },
	{ "WERR_WMI_INSTANCE_NOT_FOUND", WERR_WMI_INSTANCE_NOT_FOUND },
	{ "WERR_WMI_ITEMID_NOT_FOUND", WERR_WMI_ITEMID_NOT_FOUND },
	{ "WERR_WMI_TRY_AGAIN", WERR_WMI_TRY_AGAIN },
	{ "WERR_WMI_DP_NOT_FOUND", WERR_WMI_DP_NOT_FOUND },
	{ "WERR_WMI_UNRESOLVED_INSTANCE_REF", WERR_WMI_UNRESOLVED_INSTANCE_REF },
	{ "WERR_WMI_ALREADY_ENABLED", WERR_WMI_ALREADY_ENABLED },
	{ "WERR_WMI_GUID_DISCONNECTED", WERR_WMI_GUID_DISCONNECTED },
	{ "WERR_WMI_SERVER_UNAVAILABLE", WERR_WMI_SERVER_UNAVAILABLE },
	{ "WERR_WMI_DP_FAILED", WERR_WMI_DP_FAILED },
	{ "WERR_WMI_INVALID_MOF", WERR_WMI_INVALID_MOF },
	{ "WERR_WMI_INVALID_REGINFO", WERR_WMI_INVALID_REGINFO },
	{ "WERR_WMI_ALREADY_DISABLED", WERR_WMI_ALREADY_DISABLED },
	{ "WERR_WMI_READ_ONLY", WERR_WMI_READ_ONLY },
	{ "WERR_WMI_SET_FAILURE", WERR_WMI_SET_FAILURE },
	{ "WERR_INVALID_MEDIA", WERR_INVALID_MEDIA },
	{ "WERR_INVALID_LIBRARY", WERR_INVALID_LIBRARY },
	{ "WERR_INVALID_MEDIA_POOL", WERR_INVALID_MEDIA_POOL },
	{ "WERR_DRIVE_MEDIA_MISMATCH", WERR_DRIVE_MEDIA_MISMATCH },
	{ "WERR_MEDIA_OFFLINE", WERR_MEDIA_OFFLINE },
	{ "WERR_LIBRARY_OFFLINE", WERR_LIBRARY_OFFLINE },
	{ "WERR_EMPTY", WERR_EMPTY },
	{ "WERR_NOT_EMPTY", WERR_NOT_EMPTY },
	{ "WERR_MEDIA_UNAVAILABLE", WERR_MEDIA_UNAVAILABLE },
	{ "WERR_RESOURCE_DISABLED", WERR_RESOURCE_DISABLED },
	{ "WERR_INVALID_CLEANER", WERR_INVALID_CLEANER },
	{ "WERR_UNABLE_TO_CLEAN", WERR_UNABLE_TO_CLEAN },
	{ "WERR_OBJECT_NOT_FOUND", WERR_OBJECT_NOT_FOUND },
	{ "WERR_DATABASE_FAILURE", WERR_DATABASE_FAILURE },
	{ "WERR_DATABASE_FULL", WERR_DATABASE_FULL },
	{ "WERR_MEDIA_INCOMPATIBLE", WERR_MEDIA_INCOMPATIBLE },
	{ "WERR_RESOURCE_NOT_PRESENT", WERR_RESOURCE_NOT_PRESENT },
	{ "WERR_INVALID_OPERATION", WERR_INVALID_OPERATION },
	{ "WERR_MEDIA_NOT_AVAILABLE", WERR_MEDIA_NOT_AVAILABLE },
	{ "WERR_REQUEST_REFUSED", WERR_REQUEST_REFUSED },
	{ "WERR_INVALID_DRIVE_OBJECT", WERR_INVALID_DRIVE_OBJECT },
	{ "WERR_LIBRARY_FULL", WERR_LIBRARY_FULL },
	{ "WERR_MEDIUM_NOT_ACCESSIBLE", WERR_MEDIUM_NOT_ACCESSIBLE },
	{ "WERR_UNABLE_TO_LOAD_MEDIUM", WERR_UNABLE_TO_LOAD_MEDIUM },
	{ "WERR_UNABLE_TO_INVENTORY_DRIVE", WERR_UNABLE_TO_INVENTORY_DRIVE },
	{ "WERR_UNABLE_TO_INVENTORY_SLOT", WERR_UNABLE_TO_INVENTORY_SLOT },
	{ "WERR_UNABLE_TO_INVENTORY_TRANSPORT", WERR_UNABLE_TO_INVENTORY_TRANSPORT },
	{ "WERR_TRANSPORT_FULL", WERR_TRANSPORT_FULL },
	{ "WERR_CONTROLLING_IEPORT", WERR_CONTROLLING_IEPORT },
	{ "WERR_UNABLE_TO_EJECT_MOUNTED_MEDIA", WERR_UNABLE_TO_EJECT_MOUNTED_MEDIA },
	{ "WERR_CLEANER_SLOT_SET", WERR_CLEANER_SLOT_SET },
	{ "WERR_CLEANER_SLOT_NOT_SET", WERR_CLEANER_SLOT_NOT_SET },
	{ "WERR_CLEANER_CARTRIDGE_SPENT", WERR_CLEANER_CARTRIDGE_SPENT },
	{ "WERR_UNEXPECTED_OMID", WERR_UNEXPECTED_OMID },
	{ "WERR_CANT_DELETE_LAST_ITEM", WERR_CANT_DELETE_LAST_ITEM },
	{ "WERR_MESSAGE_EXCEEDS_MAX_SIZE", WERR_MESSAGE_EXCEEDS_MAX_SIZE },
	{ "WERR_VOLUME_CONTAINS_SYS_FILES", WERR_VOLUME_CONTAINS_SYS_FILES },
	{ "WERR_INDIGENOUS_TYPE", WERR_INDIGENOUS_TYPE },
	{ "WERR_NO_SUPPORTING_DRIVES", WERR_NO_SUPPORTING_DRIVES },
	{ "WERR_CLEANER_CARTRIDGE_INSTALLED", WERR_CLEANER_CARTRIDGE_INSTALLED },
	{ "WERR_IEPORT_FULL", WERR_IEPORT_FULL },
	{ "WERR_FILE_OFFLINE", WERR_FILE_OFFLINE },
	{ "WERR_REMOTE_STORAGE_NOT_ACTIVE", WERR_REMOTE_STORAGE_NOT_ACTIVE },
	{ "WERR_REMOTE_STORAGE_MEDIA_ERROR", WERR_REMOTE_STORAGE_MEDIA_ERROR },
	{ "WERR_NOT_A_REPARSE_POINT", WERR_NOT_A_REPARSE_POINT },
	{ "WERR_REPARSE_ATTRIBUTE_CONFLICT", WERR_REPARSE_ATTRIBUTE_CONFLICT },
	{ "WERR_INVALID_REPARSE_DATA", WERR_INVALID_REPARSE_DATA },
	{ "WERR_REPARSE_TAG_INVALID", WERR_REPARSE_TAG_INVALID },
	{ "WERR_REPARSE_TAG_MISMATCH", WERR_REPARSE_TAG_MISMATCH },
	{ "WERR_VOLUME_NOT_SIS_ENABLED", WERR_VOLUME_NOT_SIS_ENABLED },
	{ "WERR_DEPENDENT_RESOURCE_EXISTS", WERR_DEPENDENT_RESOURCE_EXISTS },
	{ "WERR_DEPENDENCY_NOT_FOUND", WERR_DEPENDENCY_NOT_FOUND },
	{ "WERR_DEPENDENCY_ALREADY_EXISTS", WERR_DEPENDENCY_ALREADY_EXISTS },
	{ "WERR_RESOURCE_NOT_ONLINE", WERR_RESOURCE_NOT_ONLINE },
	{ "WERR_HOST_NODE_NOT_AVAILABLE", WERR_HOST_NODE_NOT_AVAILABLE },
	{ "WERR_RESOURCE_NOT_AVAILABLE", WERR_RESOURCE_NOT_AVAILABLE },
	{ "WERR_RESOURCE_NOT_FOUND", WERR_RESOURCE_NOT_FOUND },
	{ "WERR_SHUTDOWN_CLUSTER", WERR_SHUTDOWN_CLUSTER },
	{ "WERR_CANT_EVICT_ACTIVE_NODE", WERR_CANT_EVICT_ACTIVE_NODE },
	{ "WERR_OBJECT_ALREADY_EXISTS", WERR_OBJECT_ALREADY_EXISTS },
	{ "WERR_OBJECT_IN_LIST", WERR_OBJECT_IN_LIST },
	{ "WERR_GROUP_NOT_AVAILABLE", WERR_GROUP_NOT_AVAILABLE },
	{ "WERR_GROUP_NOT_FOUND", WERR_GROUP_NOT_FOUND },
	{ "WERR_GROUP_NOT_ONLINE", WERR_GROUP_NOT_ONLINE },
	{ "WERR_HOST_NODE_NOT_RESOURCE_OWNER", WERR_HOST_NODE_NOT_RESOURCE_OWNER },
	{ "WERR_HOST_NODE_NOT_GROUP_OWNER", WERR_HOST_NODE_NOT_GROUP_OWNER },
	{ "WERR_RESMON_CREATE_FAILED", WERR_RESMON_CREATE_FAILED },
	{ "WERR_RESMON_ONLINE_FAILED", WERR_RESMON_ONLINE_FAILED },
	{ "WERR_RESOURCE_ONLINE", WERR_RESOURCE_ONLINE },
	{ "WERR_QUORUM_RESOURCE", WERR_QUORUM_RESOURCE },
	{ "WERR_NOT_QUORUM_CAPABLE", WERR_NOT_QUORUM_CAPABLE },
	{ "WERR_CLUSTER_SHUTTING_DOWN", WERR_CLUSTER_SHUTTING_DOWN },
	{ "WERR_INVALID_STATE", WERR_INVALID_STATE },
	{ "WERR_RESOURCE_PROPERTIES_STORED", WERR_RESOURCE_PROPERTIES_STORED },
	{ "WERR_NOT_QUORUM_CLASS", WERR_NOT_QUORUM_CLASS },
	{ "WERR_CORE_RESOURCE", WERR_CORE_RESOURCE },
	{ "WERR_QUORUM_RESOURCE_ONLINE_FAILED", WERR_QUORUM_RESOURCE_ONLINE_FAILED },
	{ "WERR_QUORUMLOG_OPEN_FAILED", WERR_QUORUMLOG_OPEN_FAILED },
	{ "WERR_CLUSTERLOG_CORRUPT", WERR_CLUSTERLOG_CORRUPT },
	{ "WERR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE", WERR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE },
	{ "WERR_CLUSTERLOG_EXCEEDS_MAXSIZE", WERR_CLUSTERLOG_EXCEEDS_MAXSIZE },
	{ "WERR_CLUSTERLOG_CHKPOINT_NOT_FOUND", WERR_CLUSTERLOG_CHKPOINT_NOT_FOUND },
	{ "WERR_CLUSTERLOG_NOT_ENOUGH_SPACE", WERR_CLUSTERLOG_NOT_ENOUGH_SPACE },
	{ "WERR_QUORUM_OWNER_ALIVE", WERR_QUORUM_OWNER_ALIVE },
	{ "WERR_NETWORK_NOT_AVAILABLE", WERR_NETWORK_NOT_AVAILABLE },
	{ "WERR_NODE_NOT_AVAILABLE", WERR_NODE_NOT_AVAILABLE },
	{ "WERR_ALL_NODES_NOT_AVAILABLE", WERR_ALL_NODES_NOT_AVAILABLE },
	{ "WERR_RESOURCE_FAILED", WERR_RESOURCE_FAILED },
	{ "WERR_CLUSTER_INVALID_NODE", WERR_CLUSTER_INVALID_NODE },
	{ "WERR_CLUSTER_NODE_EXISTS", WERR_CLUSTER_NODE_EXISTS },
	{ "WERR_CLUSTER_JOIN_IN_PROGRESS", WERR_CLUSTER_JOIN_IN_PROGRESS },
	{ "WERR_CLUSTER_NODE_NOT_FOUND", WERR_CLUSTER_NODE_NOT_FOUND },
	{ "WERR_CLUSTER_LOCAL_NODE_NOT_FOUND", WERR_CLUSTER_LOCAL_NODE_NOT_FOUND },
	{ "WERR_CLUSTER_NETWORK_EXISTS", WERR_CLUSTER_NETWORK_EXISTS },
	{ "WERR_CLUSTER_NETWORK_NOT_FOUND", WERR_CLUSTER_NETWORK_NOT_FOUND },
	{ "WERR_CLUSTER_NETINTERFACE_EXISTS", WERR_CLUSTER_NETINTERFACE_EXISTS },
	{ "WERR_CLUSTER_NETINTERFACE_NOT_FOUND", WERR_CLUSTER_NETINTERFACE_NOT_FOUND },
	{ "WERR_CLUSTER_INVALID_REQUEST", WERR_CLUSTER_INVALID_REQUEST },
	{ "WERR_CLUSTER_INVALID_NETWORK_PROVIDER", WERR_CLUSTER_INVALID_NETWORK_PROVIDER },
	{ "WERR_CLUSTER_NODE_DOWN", WERR_CLUSTER_NODE_DOWN },
	{ "WERR_CLUSTER_NODE_UNREACHABLE", WERR_CLUSTER_NODE_UNREACHABLE },
	{ "WERR_CLUSTER_NODE_NOT_MEMBER", WERR_CLUSTER_NODE_NOT_MEMBER },
	{ "WERR_CLUSTER_JOIN_NOT_IN_PROGRESS", WERR_CLUSTER_JOIN_NOT_IN_PROGRESS },
	{ "WERR_CLUSTER_INVALID_NETWORK", WERR_CLUSTER_INVALID_NETWORK },
	{ "WERR_CLUSTER_NODE_UP", WERR_CLUSTER_NODE_UP },
	{ "WERR_CLUSTER_IPADDR_IN_USE", WERR_CLUSTER_IPADDR_IN_USE },
	{ "WERR_CLUSTER_NODE_NOT_PAUSED", WERR_CLUSTER_NODE_NOT_PAUSED },
	{ "WERR_CLUSTER_NO_SECURITY_CONTEXT", WERR_CLUSTER_NO_SECURITY_CONTEXT },
	{ "WERR_CLUSTER_NETWORK_NOT_INTERNAL", WERR_CLUSTER_NETWORK_NOT_INTERNAL },
	{ "WERR_CLUSTER_NODE_ALREADY_UP", WERR_CLUSTER_NODE_ALREADY_UP },
	{ "WERR_CLUSTER_NODE_ALREADY_DOWN", WERR_CLUSTER_NODE_ALREADY_DOWN },
	{ "WERR_CLUSTER_NETWORK_ALREADY_ONLINE", WERR_CLUSTER_NETWORK_ALREADY_ONLINE },
	{ "WERR_CLUSTER_NETWORK_ALREADY_OFFLINE", WERR_CLUSTER_NETWORK_ALREADY_OFFLINE },
	{ "WERR_CLUSTER_NODE_ALREADY_MEMBER", WERR_CLUSTER_NODE_ALREADY_MEMBER },
	{ "WERR_CLUSTER_LAST_INTERNAL_NETWORK", WERR_CLUSTER_LAST_INTERNAL_NETWORK },
	{ "WERR_CLUSTER_NETWORK_HAS_DEPENDENTS", WERR_CLUSTER_NETWORK_HAS_DEPENDENTS },
	{ "WERR_INVALID_OPERATION_ON_QUORUM", WERR_INVALID_OPERATION_ON_QUORUM },
	{ "WERR_DEPENDENCY_NOT_ALLOWED", WERR_DEPENDENCY_NOT_ALLOWED },
	{ "WERR_CLUSTER_NODE_PAUSED", WERR_CLUSTER_NODE_PAUSED },
	{ "WERR_NODE_CANT_HOST_RESOURCE", WERR_NODE_CANT_HOST_RESOURCE },
	{ "WERR_CLUSTER_NODE_NOT_READY", WERR_CLUSTER_NODE_NOT_READY },
	{ "WERR_CLUSTER_NODE_SHUTTING_DOWN", WERR_CLUSTER_NODE_SHUTTING_DOWN },
	{ "WERR_CLUSTER_JOIN_ABORTED", WERR_CLUSTER_JOIN_ABORTED },
	{ "WERR_CLUSTER_INCOMPATIBLE_VERSIONS", WERR_CLUSTER_INCOMPATIBLE_VERSIONS },
	{ "WERR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED", WERR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED },
	{ "WERR_CLUSTER_SYSTEM_CONFIG_CHANGED", WERR_CLUSTER_SYSTEM_CONFIG_CHANGED },
	{ "WERR_CLUSTER_RESOURCE_TYPE_NOT_FOUND", WERR_CLUSTER_RESOURCE_TYPE_NOT_FOUND },
	{ "WERR_CLUSTER_RESTYPE_NOT_SUPPORTED", WERR_CLUSTER_RESTYPE_NOT_SUPPORTED },
	{ "WERR_CLUSTER_RESNAME_NOT_FOUND", WERR_CLUSTER_RESNAME_NOT_FOUND },
	{ "WERR_CLUSTER_NO_RPC_PACKAGES_REGISTERED", WERR_CLUSTER_NO_RPC_PACKAGES_REGISTERED },
	{ "WERR_CLUSTER_OWNER_NOT_IN_PREFLIST", WERR_CLUSTER_OWNER_NOT_IN_PREFLIST },
	{ "WERR_CLUSTER_DATABASE_SEQMISMATCH", WERR_CLUSTER_DATABASE_SEQMISMATCH },
	{ "WERR_RESMON_INVALID_STATE", WERR_RESMON_INVALID_STATE },
	{ "WERR_CLUSTER_GUM_NOT_LOCKER", WERR_CLUSTER_GUM_NOT_LOCKER },
	{ "WERR_QUORUM_DISK_NOT_FOUND", WERR_QUORUM_DISK_NOT_FOUND },
	{ "WERR_DATABASE_BACKUP_CORRUPT", WERR_DATABASE_BACKUP_CORRUPT },
	{ "WERR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT", WERR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT },
	{ "WERR_RESOURCE_PROPERTY_UNCHANGEABLE", WERR_RESOURCE_PROPERTY_UNCHANGEABLE },
	{ "WERR_CLUSTER_MEMBERSHIP_INVALID_STATE", WERR_CLUSTER_MEMBERSHIP_INVALID_STATE },
	{ "WERR_CLUSTER_QUORUMLOG_NOT_FOUND", WERR_CLUSTER_QUORUMLOG_NOT_FOUND },
	{ "WERR_CLUSTER_MEMBERSHIP_HALT", WERR_CLUSTER_MEMBERSHIP_HALT },
	{ "WERR_CLUSTER_INSTANCE_ID_MISMATCH", WERR_CLUSTER_INSTANCE_ID_MISMATCH },
	{ "WERR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP", WERR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP },
	{ "WERR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH", WERR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH },
	{ "WERR_CLUSTER_EVICT_WITHOUT_CLEANUP", WERR_CLUSTER_EVICT_WITHOUT_CLEANUP },
	{ "WERR_CLUSTER_PARAMETER_MISMATCH", WERR_CLUSTER_PARAMETER_MISMATCH },
	{ "WERR_NODE_CANNOT_BE_CLUSTERED", WERR_NODE_CANNOT_BE_CLUSTERED },
	{ "WERR_CLUSTER_WRONG_OS_VERSION", WERR_CLUSTER_WRONG_OS_VERSION },
	{ "WERR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME", WERR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME },
	{ "WERR_CLUSCFG_ALREADY_COMMITTED", WERR_CLUSCFG_ALREADY_COMMITTED },
	{ "WERR_CLUSCFG_ROLLBACK_FAILED", WERR_CLUSCFG_ROLLBACK_FAILED },
	{ "WERR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT", WERR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT },
	{ "WERR_CLUSTER_OLD_VERSION", WERR_CLUSTER_OLD_VERSION },
	{ "WERR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME", WERR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME },
	{ "WERR_CLUSTER_NO_NET_ADAPTERS", WERR_CLUSTER_NO_NET_ADAPTERS },
	{ "WERR_CLUSTER_POISONED", WERR_CLUSTER_POISONED },
	{ "WERR_CLUSTER_GROUP_MOVING", WERR_CLUSTER_GROUP_MOVING },
	{ "WERR_CLUSTER_RESOURCE_TYPE_BUSY", WERR_CLUSTER_RESOURCE_TYPE_BUSY },
	{ "WERR_RESOURCE_CALL_TIMED_OUT", WERR_RESOURCE_CALL_TIMED_OUT },
	{ "WERR_INVALID_CLUSTER_IPV6_ADDRESS", WERR_INVALID_CLUSTER_IPV6_ADDRESS },
	{ "WERR_CLUSTER_INTERNAL_INVALID_FUNCTION", WERR_CLUSTER_INTERNAL_INVALID_FUNCTION },
	{ "WERR_CLUSTER_PARAMETER_OUT_OF_BOUNDS", WERR_CLUSTER_PARAMETER_OUT_OF_BOUNDS },
	{ "WERR_CLUSTER_PARTIAL_SEND", WERR_CLUSTER_PARTIAL_SEND },
	{ "WERR_CLUSTER_REGISTRY_INVALID_FUNCTION", WERR_CLUSTER_REGISTRY_INVALID_FUNCTION },
	{ "WERR_CLUSTER_INVALID_STRING_TERMINATION", WERR_CLUSTER_INVALID_STRING_TERMINATION },
	{ "WERR_CLUSTER_INVALID_STRING_FORMAT", WERR_CLUSTER_INVALID_STRING_FORMAT },
	{ "WERR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS", WERR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS },
	{ "WERR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS", WERR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS },
	{ "WERR_CLUSTER_NULL_DATA", WERR_CLUSTER_NULL_DATA },
	{ "WERR_CLUSTER_PARTIAL_READ", WERR_CLUSTER_PARTIAL_READ },
	{ "WERR_CLUSTER_PARTIAL_WRITE", WERR_CLUSTER_PARTIAL_WRITE },
	{ "WERR_CLUSTER_CANT_DESERIALIZE_DATA", WERR_CLUSTER_CANT_DESERIALIZE_DATA },
	{ "WERR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT", WERR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT },
	{ "WERR_CLUSTER_NO_QUORUM", WERR_CLUSTER_NO_QUORUM },
	{ "WERR_CLUSTER_INVALID_IPV6_NETWORK", WERR_CLUSTER_INVALID_IPV6_NETWORK },
	{ "WERR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK", WERR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK },
	{ "WERR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP", WERR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP },
	{ "WERR_ENCRYPTION_FAILED", WERR_ENCRYPTION_FAILED },
	{ "WERR_DECRYPTION_FAILED", WERR_DECRYPTION_FAILED },
	{ "WERR_FILE_ENCRYPTED", WERR_FILE_ENCRYPTED },
	{ "WERR_NO_RECOVERY_POLICY", WERR_NO_RECOVERY_POLICY },
	{ "WERR_NO_EFS", WERR_NO_EFS },
	{ "WERR_WRONG_EFS", WERR_WRONG_EFS },
	{ "WERR_NO_USER_KEYS", WERR_NO_USER_KEYS },
	{ "WERR_FILE_NOT_ENCRYPTED", WERR_FILE_NOT_ENCRYPTED },
	{ "WERR_NOT_EXPORT_FORMAT", WERR_NOT_EXPORT_FORMAT },
	{ "WERR_FILE_READ_ONLY", WERR_FILE_READ_ONLY },
	{ "WERR_DIR_EFS_DISALLOWED", WERR_DIR_EFS_DISALLOWED },
	{ "WERR_EFS_SERVER_NOT_TRUSTED", WERR_EFS_SERVER_NOT_TRUSTED },
	{ "WERR_BAD_RECOVERY_POLICY", WERR_BAD_RECOVERY_POLICY },
	{ "WERR_EFS_ALG_BLOB_TOO_BIG", WERR_EFS_ALG_BLOB_TOO_BIG },
	{ "WERR_VOLUME_NOT_SUPPORT_EFS", WERR_VOLUME_NOT_SUPPORT_EFS },
	{ "WERR_EFS_DISABLED", WERR_EFS_DISABLED },
	{ "WERR_EFS_VERSION_NOT_SUPPORT", WERR_EFS_VERSION_NOT_SUPPORT },
	{ "WERR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE", WERR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE },
	{ "WERR_CS_ENCRYPTION_UNSUPPORTED_SERVER", WERR_CS_ENCRYPTION_UNSUPPORTED_SERVER },
	{ "WERR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE", WERR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE },
	{ "WERR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE", WERR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE },
	{ "WERR_CS_ENCRYPTION_FILE_NOT_CSE", WERR_CS_ENCRYPTION_FILE_NOT_CSE },
	{ "WERR_NO_BROWSER_SERVERS_FOUND", WERR_NO_BROWSER_SERVERS_FOUND },
	{ "WERR_LOG_SECTOR_INVALID", WERR_LOG_SECTOR_INVALID },
	{ "WERR_LOG_SECTOR_PARITY_INVALID", WERR_LOG_SECTOR_PARITY_INVALID },
	{ "WERR_LOG_SECTOR_REMAPPED", WERR_LOG_SECTOR_REMAPPED },
	{ "WERR_LOG_BLOCK_INCOMPLETE", WERR_LOG_BLOCK_INCOMPLETE },
	{ "WERR_LOG_INVALID_RANGE", WERR_LOG_INVALID_RANGE },
	{ "WERR_LOG_BLOCKS_EXHAUSTED", WERR_LOG_BLOCKS_EXHAUSTED },
	{ "WERR_LOG_READ_CONTEXT_INVALID", WERR_LOG_READ_CONTEXT_INVALID },
	{ "WERR_LOG_RESTART_INVALID", WERR_LOG_RESTART_INVALID },
	{ "WERR_LOG_BLOCK_VERSION", WERR_LOG_BLOCK_VERSION },
	{ "WERR_LOG_BLOCK_INVALID", WERR_LOG_BLOCK_INVALID },
	{ "WERR_LOG_READ_MODE_INVALID", WERR_LOG_READ_MODE_INVALID },
	{ "WERR_LOG_NO_RESTART", WERR_LOG_NO_RESTART },
	{ "WERR_LOG_METADATA_CORRUPT", WERR_LOG_METADATA_CORRUPT },
	{ "WERR_LOG_METADATA_INVALID", WERR_LOG_METADATA_INVALID },
	{ "WERR_LOG_METADATA_INCONSISTENT", WERR_LOG_METADATA_INCONSISTENT },
	{ "WERR_LOG_RESERVATION_INVALID", WERR_LOG_RESERVATION_INVALID },
	{ "WERR_LOG_CANT_DELETE", WERR_LOG_CANT_DELETE },
	{ "WERR_LOG_CONTAINER_LIMIT_EXCEEDED", WERR_LOG_CONTAINER_LIMIT_EXCEEDED },
	{ "WERR_LOG_START_OF_LOG", WERR_LOG_START_OF_LOG },
	{ "WERR_LOG_POLICY_ALREADY_INSTALLED", WERR_LOG_POLICY_ALREADY_INSTALLED },
	{ "WERR_LOG_POLICY_NOT_INSTALLED", WERR_LOG_POLICY_NOT_INSTALLED },
	{ "WERR_LOG_POLICY_INVALID", WERR_LOG_POLICY_INVALID },
	{ "WERR_LOG_POLICY_CONFLICT", WERR_LOG_POLICY_CONFLICT },
	{ "WERR_LOG_PINNED_ARCHIVE_TAIL", WERR_LOG_PINNED_ARCHIVE_TAIL },
	{ "WERR_LOG_RECORD_NONEXISTENT", WERR_LOG_RECORD_NONEXISTENT },
	{ "WERR_LOG_RECORDS_RESERVED_INVALID", WERR_LOG_RECORDS_RESERVED_INVALID },
	{ "WERR_LOG_SPACE_RESERVED_INVALID", WERR_LOG_SPACE_RESERVED_INVALID },
	{ "WERR_LOG_TAIL_INVALID", WERR_LOG_TAIL_INVALID },
	{ "WERR_LOG_FULL", WERR_LOG_FULL },
	{ "WERR_COULD_NOT_RESIZE_LOG", WERR_COULD_NOT_RESIZE_LOG },
	{ "WERR_LOG_MULTIPLEXED", WERR_LOG_MULTIPLEXED },
	{ "WERR_LOG_DEDICATED", WERR_LOG_DEDICATED },
	{ "WERR_LOG_ARCHIVE_NOT_IN_PROGRESS", WERR_LOG_ARCHIVE_NOT_IN_PROGRESS },
	{ "WERR_LOG_ARCHIVE_IN_PROGRESS", WERR_LOG_ARCHIVE_IN_PROGRESS },
	{ "WERR_LOG_EPHEMERAL", WERR_LOG_EPHEMERAL },
	{ "WERR_LOG_NOT_ENOUGH_CONTAINERS", WERR_LOG_NOT_ENOUGH_CONTAINERS },
	{ "WERR_LOG_CLIENT_ALREADY_REGISTERED", WERR_LOG_CLIENT_ALREADY_REGISTERED },
	{ "WERR_LOG_CLIENT_NOT_REGISTERED", WERR_LOG_CLIENT_NOT_REGISTERED },
	{ "WERR_LOG_FULL_HANDLER_IN_PROGRESS", WERR_LOG_FULL_HANDLER_IN_PROGRESS },
	{ "WERR_LOG_CONTAINER_READ_FAILED", WERR_LOG_CONTAINER_READ_FAILED },
	{ "WERR_LOG_CONTAINER_WRITE_FAILED", WERR_LOG_CONTAINER_WRITE_FAILED },
	{ "WERR_LOG_CONTAINER_OPEN_FAILED", WERR_LOG_CONTAINER_OPEN_FAILED },
	{ "WERR_LOG_CONTAINER_STATE_INVALID", WERR_LOG_CONTAINER_STATE_INVALID },
	{ "WERR_LOG_STATE_INVALID", WERR_LOG_STATE_INVALID },
	{ "WERR_LOG_PINNED", WERR_LOG_PINNED },
	{ "WERR_LOG_METADATA_FLUSH_FAILED", WERR_LOG_METADATA_FLUSH_FAILED },
	{ "WERR_LOG_INCONSISTENT_SECURITY", WERR_LOG_INCONSISTENT_SECURITY },
	{ "WERR_LOG_APPENDED_FLUSH_FAILED", WERR_LOG_APPENDED_FLUSH_FAILED },
	{ "WERR_LOG_PINNED_RESERVATION", WERR_LOG_PINNED_RESERVATION },
	{ "WERR_INVALID_TRANSACTION", WERR_INVALID_TRANSACTION },
	{ "WERR_TRANSACTION_NOT_ACTIVE", WERR_TRANSACTION_NOT_ACTIVE },
	{ "WERR_TRANSACTION_REQUEST_NOT_VALID", WERR_TRANSACTION_REQUEST_NOT_VALID },
	{ "WERR_TRANSACTION_NOT_REQUESTED", WERR_TRANSACTION_NOT_REQUESTED },
	{ "WERR_TRANSACTION_ALREADY_ABORTED", WERR_TRANSACTION_ALREADY_ABORTED },
	{ "WERR_TRANSACTION_ALREADY_COMMITTED", WERR_TRANSACTION_ALREADY_COMMITTED },
	{ "WERR_TM_INITIALIZATION_FAILED", WERR_TM_INITIALIZATION_FAILED },
	{ "WERR_RESOURCEMANAGER_READ_ONLY", WERR_RESOURCEMANAGER_READ_ONLY },
	{ "WERR_TRANSACTION_NOT_JOINED", WERR_TRANSACTION_NOT_JOINED },
	{ "WERR_TRANSACTION_SUPERIOR_EXISTS", WERR_TRANSACTION_SUPERIOR_EXISTS },
	{ "WERR_CRM_PROTOCOL_ALREADY_EXISTS", WERR_CRM_PROTOCOL_ALREADY_EXISTS },
	{ "WERR_TRANSACTION_PROPAGATION_FAILED", WERR_TRANSACTION_PROPAGATION_FAILED },
	{ "WERR_CRM_PROTOCOL_NOT_FOUND", WERR_CRM_PROTOCOL_NOT_FOUND },
	{ "WERR_TRANSACTION_INVALID_MARSHALL_BUFFER", WERR_TRANSACTION_INVALID_MARSHALL_BUFFER },
	{ "WERR_CURRENT_TRANSACTION_NOT_VALID", WERR_CURRENT_TRANSACTION_NOT_VALID },
	{ "WERR_TRANSACTION_NOT_FOUND", WERR_TRANSACTION_NOT_FOUND },
	{ "WERR_RESOURCEMANAGER_NOT_FOUND", WERR_RESOURCEMANAGER_NOT_FOUND },
	{ "WERR_ENLISTMENT_NOT_FOUND", WERR_ENLISTMENT_NOT_FOUND },
	{ "WERR_TRANSACTIONMANAGER_NOT_FOUND", WERR_TRANSACTIONMANAGER_NOT_FOUND },
	{ "WERR_TRANSACTIONMANAGER_NOT_ONLINE", WERR_TRANSACTIONMANAGER_NOT_ONLINE },
	{ "WERR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION", WERR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION },
	{ "WERR_TRANSACTIONAL_CONFLICT", WERR_TRANSACTIONAL_CONFLICT },
	{ "WERR_RM_NOT_ACTIVE", WERR_RM_NOT_ACTIVE },
	{ "WERR_RM_METADATA_CORRUPT", WERR_RM_METADATA_CORRUPT },
	{ "WERR_DIRECTORY_NOT_RM", WERR_DIRECTORY_NOT_RM },
	{ "WERR_TRANSACTIONS_UNSUPPORTED_REMOTE", WERR_TRANSACTIONS_UNSUPPORTED_REMOTE },
	{ "WERR_LOG_RESIZE_INVALID_SIZE", WERR_LOG_RESIZE_INVALID_SIZE },
	{ "WERR_OBJECT_NO_LONGER_EXISTS", WERR_OBJECT_NO_LONGER_EXISTS },
	{ "WERR_STREAM_MINIVERSION_NOT_FOUND", WERR_STREAM_MINIVERSION_NOT_FOUND },
	{ "WERR_STREAM_MINIVERSION_NOT_VALID", WERR_STREAM_MINIVERSION_NOT_VALID },
	{ "WERR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION", WERR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION },
	{ "WERR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT", WERR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT },
	{ "WERR_CANT_CREATE_MORE_STREAM_MINIVERSIONS", WERR_CANT_CREATE_MORE_STREAM_MINIVERSIONS },
	{ "WERR_REMOTE_FILE_VERSION_MISMATCH", WERR_REMOTE_FILE_VERSION_MISMATCH },
	{ "WERR_HANDLE_NO_LONGER_VALID", WERR_HANDLE_NO_LONGER_VALID },
	{ "WERR_NO_TXF_METADATA", WERR_NO_TXF_METADATA },
	{ "WERR_LOG_CORRUPTION_DETECTED", WERR_LOG_CORRUPTION_DETECTED },
	{ "WERR_CANT_RECOVER_WITH_HANDLE_OPEN", WERR_CANT_RECOVER_WITH_HANDLE_OPEN },
	{ "WERR_RM_DISCONNECTED", WERR_RM_DISCONNECTED },
	{ "WERR_ENLISTMENT_NOT_SUPERIOR", WERR_ENLISTMENT_NOT_SUPERIOR },
	{ "WERR_RECOVERY_NOT_NEEDED", WERR_RECOVERY_NOT_NEEDED },
	{ "WERR_RM_ALREADY_STARTED", WERR_RM_ALREADY_STARTED },
	{ "WERR_FILE_IDENTITY_NOT_PERSISTENT", WERR_FILE_IDENTITY_NOT_PERSISTENT },
	{ "WERR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY", WERR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY },
	{ "WERR_CANT_CROSS_RM_BOUNDARY", WERR_CANT_CROSS_RM_BOUNDARY },
	{ "WERR_TXF_DIR_NOT_EMPTY", WERR_TXF_DIR_NOT_EMPTY },
	{ "WERR_INDOUBT_TRANSACTIONS_EXIST", WERR_INDOUBT_TRANSACTIONS_EXIST },
	{ "WERR_TM_VOLATILE", WERR_TM_VOLATILE },
	{ "WERR_ROLLBACK_TIMER_EXPIRED", WERR_ROLLBACK_TIMER_EXPIRED },
	{ "WERR_TXF_ATTRIBUTE_CORRUPT", WERR_TXF_ATTRIBUTE_CORRUPT },
	{ "WERR_EFS_NOT_ALLOWED_IN_TRANSACTION", WERR_EFS_NOT_ALLOWED_IN_TRANSACTION },
	{ "WERR_TRANSACTIONAL_OPEN_NOT_ALLOWED", WERR_TRANSACTIONAL_OPEN_NOT_ALLOWED },
	{ "WERR_LOG_GROWTH_FAILED", WERR_LOG_GROWTH_FAILED },
	{ "WERR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE", WERR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE },
	{ "WERR_TXF_METADATA_ALREADY_PRESENT", WERR_TXF_METADATA_ALREADY_PRESENT },
	{ "WERR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET", WERR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET },
	{ "WERR_TRANSACTION_REQUIRED_PROMOTION", WERR_TRANSACTION_REQUIRED_PROMOTION },
	{ "WERR_CANNOT_EXECUTE_FILE_IN_TRANSACTION", WERR_CANNOT_EXECUTE_FILE_IN_TRANSACTION },
	{ "WERR_TRANSACTIONS_NOT_FROZEN", WERR_TRANSACTIONS_NOT_FROZEN },
	{ "WERR_TRANSACTION_FREEZE_IN_PROGRESS", WERR_TRANSACTION_FREEZE_IN_PROGRESS },
	{ "WERR_NOT_SNAPSHOT_VOLUME", WERR_NOT_SNAPSHOT_VOLUME },
	{ "WERR_NO_SAVEPOINT_WITH_OPEN_FILES", WERR_NO_SAVEPOINT_WITH_OPEN_FILES },
	{ "WERR_DATA_LOST_REPAIR", WERR_DATA_LOST_REPAIR },
	{ "WERR_SPARSE_NOT_ALLOWED_IN_TRANSACTION", WERR_SPARSE_NOT_ALLOWED_IN_TRANSACTION },
	{ "WERR_TM_IDENTITY_MISMATCH", WERR_TM_IDENTITY_MISMATCH },
	{ "WERR_FLOATED_SECTION", WERR_FLOATED_SECTION },
	{ "WERR_CANNOT_ACCEPT_TRANSACTED_WORK", WERR_CANNOT_ACCEPT_TRANSACTED_WORK },
	{ "WERR_CANNOT_ABORT_TRANSACTIONS", WERR_CANNOT_ABORT_TRANSACTIONS },
	{ "WERR_CTX_WINSTATION_NAME_INVALID", WERR_CTX_WINSTATION_NAME_INVALID },
	{ "WERR_CTX_INVALID_PD", WERR_CTX_INVALID_PD },
	{ "WERR_CTX_PD_NOT_FOUND", WERR_CTX_PD_NOT_FOUND },
	{ "WERR_CTX_WD_NOT_FOUND", WERR_CTX_WD_NOT_FOUND },
	{ "WERR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY", WERR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY },
	{ "WERR_CTX_SERVICE_NAME_COLLISION", WERR_CTX_SERVICE_NAME_COLLISION },
	{ "WERR_CTX_CLOSE_PENDING", WERR_CTX_CLOSE_PENDING },
	{ "WERR_CTX_NO_OUTBUF", WERR_CTX_NO_OUTBUF },
	{ "WERR_CTX_MODEM_INF_NOT_FOUND", WERR_CTX_MODEM_INF_NOT_FOUND },
	{ "WERR_CTX_INVALID_MODEMNAME", WERR_CTX_INVALID_MODEMNAME },
	{ "WERR_CTX_MODEM_RESPONSE_ERROR", WERR_CTX_MODEM_RESPONSE_ERROR },
	{ "WERR_CTX_MODEM_RESPONSE_TIMEOUT", WERR_CTX_MODEM_RESPONSE_TIMEOUT },
	{ "WERR_CTX_MODEM_RESPONSE_NO_CARRIER", WERR_CTX_MODEM_RESPONSE_NO_CARRIER },
	{ "WERR_CTX_MODEM_RESPONSE_NO_DIALTONE", WERR_CTX_MODEM_RESPONSE_NO_DIALTONE },
	{ "WERR_CTX_MODEM_RESPONSE_BUSY", WERR_CTX_MODEM_RESPONSE_BUSY },
	{ "WERR_CTX_MODEM_RESPONSE_VOICE", WERR_CTX_MODEM_RESPONSE_VOICE },
	{ "WERR_CTX_TD_ERROR", WERR_CTX_TD_ERROR },
	{ "WERR_CTX_WINSTATION_NOT_FOUND", WERR_CTX_WINSTATION_NOT_FOUND },
	{ "WERR_CTX_WINSTATION_ALREADY_EXISTS", WERR_CTX_WINSTATION_ALREADY_EXISTS },
	{ "WERR_CTX_WINSTATION_BUSY", WERR_CTX_WINSTATION_BUSY },
	{ "WERR_CTX_BAD_VIDEO_MODE", WERR_CTX_BAD_VIDEO_MODE },
	{ "WERR_CTX_GRAPHICS_INVALID", WERR_CTX_GRAPHICS_INVALID },
	{ "WERR_CTX_LOGON_DISABLED", WERR_CTX_LOGON_DISABLED },
	{ "WERR_CTX_NOT_CONSOLE", WERR_CTX_NOT_CONSOLE },
	{ "WERR_CTX_CLIENT_QUERY_TIMEOUT", WERR_CTX_CLIENT_QUERY_TIMEOUT },
	{ "WERR_CTX_CONSOLE_DISCONNECT", WERR_CTX_CONSOLE_DISCONNECT },
	{ "WERR_CTX_CONSOLE_CONNECT", WERR_CTX_CONSOLE_CONNECT },
	{ "WERR_CTX_SHADOW_DENIED", WERR_CTX_SHADOW_DENIED },
	{ "WERR_CTX_WINSTATION_ACCESS_DENIED", WERR_CTX_WINSTATION_ACCESS_DENIED },
	{ "WERR_CTX_INVALID_WD", WERR_CTX_INVALID_WD },
	{ "WERR_CTX_SHADOW_INVALID", WERR_CTX_SHADOW_INVALID },
	{ "WERR_CTX_SHADOW_DISABLED", WERR_CTX_SHADOW_DISABLED },
	{ "WERR_CTX_CLIENT_LICENSE_IN_USE", WERR_CTX_CLIENT_LICENSE_IN_USE },
	{ "WERR_CTX_CLIENT_LICENSE_NOT_SET", WERR_CTX_CLIENT_LICENSE_NOT_SET },
	{ "WERR_CTX_LICENSE_NOT_AVAILABLE", WERR_CTX_LICENSE_NOT_AVAILABLE },
	{ "WERR_CTX_LICENSE_CLIENT_INVALID", WERR_CTX_LICENSE_CLIENT_INVALID },
	{ "WERR_CTX_LICENSE_EXPIRED", WERR_CTX_LICENSE_EXPIRED },
	{ "WERR_CTX_SHADOW_NOT_RUNNING", WERR_CTX_SHADOW_NOT_RUNNING },
	{ "WERR_CTX_SHADOW_ENDED_BY_MODE_CHANGE", WERR_CTX_SHADOW_ENDED_BY_MODE_CHANGE },
	{ "WERR_ACTIVATION_COUNT_EXCEEDED", WERR_ACTIVATION_COUNT_EXCEEDED },
	{ "WERR_CTX_WINSTATIONS_DISABLED", WERR_CTX_WINSTATIONS_DISABLED },
	{ "WERR_CTX_ENCRYPTION_LEVEL_REQUIRED", WERR_CTX_ENCRYPTION_LEVEL_REQUIRED },
	{ "WERR_CTX_SESSION_IN_USE", WERR_CTX_SESSION_IN_USE },
	{ "WERR_CTX_NO_FORCE_LOGOFF", WERR_CTX_NO_FORCE_LOGOFF },
	{ "WERR_CTX_ACCOUNT_RESTRICTION", WERR_CTX_ACCOUNT_RESTRICTION },
	{ "WERR_RDP_PROTOCOL_ERROR", WERR_RDP_PROTOCOL_ERROR },
	{ "WERR_CTX_CDM_CONNECT", WERR_CTX_CDM_CONNECT },
	{ "WERR_CTX_CDM_DISCONNECT", WERR_CTX_CDM_DISCONNECT },
	{ "WERR_CTX_SECURITY_LAYER_ERROR", WERR_CTX_SECURITY_LAYER_ERROR },
	{ "WERR_TS_INCOMPATIBLE_SESSIONS", WERR_TS_INCOMPATIBLE_SESSIONS },
	{ "WERR_FRS_ERR_INVALID_API_SEQUENCE", WERR_FRS_ERR_INVALID_API_SEQUENCE },
	{ "WERR_FRS_ERR_STARTING_SERVICE", WERR_FRS_ERR_STARTING_SERVICE },
	{ "WERR_FRS_ERR_STOPPING_SERVICE", WERR_FRS_ERR_STOPPING_SERVICE },
	{ "WERR_FRS_ERR_INTERNAL_API", WERR_FRS_ERR_INTERNAL_API },
	{ "WERR_FRS_ERR_INTERNAL", WERR_FRS_ERR_INTERNAL },
	{ "WERR_FRS_ERR_SERVICE_COMM", WERR_FRS_ERR_SERVICE_COMM },
	{ "WERR_FRS_ERR_INSUFFICIENT_PRIV", WERR_FRS_ERR_INSUFFICIENT_PRIV },
	{ "WERR_FRS_ERR_AUTHENTICATION", WERR_FRS_ERR_AUTHENTICATION },
	{ "WERR_FRS_ERR_PARENT_INSUFFICIENT_PRIV", WERR_FRS_ERR_PARENT_INSUFFICIENT_PRIV },
	{ "WERR_FRS_ERR_PARENT_AUTHENTICATION", WERR_FRS_ERR_PARENT_AUTHENTICATION },
	{ "WERR_FRS_ERR_CHILD_TO_PARENT_COMM", WERR_FRS_ERR_CHILD_TO_PARENT_COMM },
	{ "WERR_FRS_ERR_PARENT_TO_CHILD_COMM", WERR_FRS_ERR_PARENT_TO_CHILD_COMM },
	{ "WERR_FRS_ERR_SYSVOL_POPULATE", WERR_FRS_ERR_SYSVOL_POPULATE },
	{ "WERR_FRS_ERR_SYSVOL_POPULATE_TIMEOUT", WERR_FRS_ERR_SYSVOL_POPULATE_TIMEOUT },
	{ "WERR_FRS_ERR_SYSVOL_IS_BUSY", WERR_FRS_ERR_SYSVOL_IS_BUSY },
	{ "WERR_FRS_ERR_SYSVOL_DEMOTE", WERR_FRS_ERR_SYSVOL_DEMOTE },
	{ "WERR_FRS_ERR_INVALID_SERVICE_PARAMETER", WERR_FRS_ERR_INVALID_SERVICE_PARAMETER },
	{ "WERR_DS_NOT_INSTALLED", WERR_DS_NOT_INSTALLED },
	{ "WERR_DS_MEMBERSHIP_EVALUATED_LOCALLY", WERR_DS_MEMBERSHIP_EVALUATED_LOCALLY },
	{ "WERR_DS_INVALID_ATTRIBUTE_YNTAX", WERR_DS_INVALID_ATTRIBUTE_YNTAX },
	{ "WERR_DS_NO_RIDS_ALLOCATED", WERR_DS_NO_RIDS_ALLOCATED },
	{ "WERR_DS_NO_MORE_RIDS", WERR_DS_NO_MORE_RIDS },
	{ "WERR_DS_INCORRECT_ROLE_OWNER", WERR_DS_INCORRECT_ROLE_OWNER },
	{ "WERR_DS_RIDMGR_INIT_ERROR", WERR_DS_RIDMGR_INIT_ERROR },
	{ "WERR_DS_CROSS_DOM_MOVE_ERROR", WERR_DS_CROSS_DOM_MOVE_ERROR },
	{ "WERR_DS_GC_NOT_AVAILABLE", WERR_DS_GC_NOT_AVAILABLE },
	{ "WERR_SHARED_POLICY", WERR_SHARED_POLICY },
	{ "WERR_POLICY_OBJECT_NOT_FOUND", WERR_POLICY_OBJECT_NOT_FOUND },
	{ "WERR_POLICY_ONLY_IN_DS", WERR_POLICY_ONLY_IN_DS },
	{ "WERR_PROMOTION_ACTIVE", WERR_PROMOTION_ACTIVE },
	{ "WERR_NO_PROMOTION_ACTIVE", WERR_NO_PROMOTION_ACTIVE },
	{ "WERR_DS_SIZELIMIT_EXCEEDED", WERR_DS_SIZELIMIT_EXCEEDED },
	{ "WERR_DS_AUTH_UNKNOWN", WERR_DS_AUTH_UNKNOWN },
	{ "WERR_DS_IS_LEAF", WERR_DS_IS_LEAF },
	{ "WERR_DS_OBJECT_RESULTS_TOO_LARGE", WERR_DS_OBJECT_RESULTS_TOO_LARGE },
	{ "WERR_DS_SERVER_DOWN", WERR_DS_SERVER_DOWN },
	{ "WERR_DS_LOCAL_ERROR", WERR_DS_LOCAL_ERROR },
	{ "WERR_DS_ENCODING_ERROR", WERR_DS_ENCODING_ERROR },
	{ "WERR_DS_DECODING_ERROR", WERR_DS_DECODING_ERROR },
	{ "WERR_DS_FILTER_UNKNOWN", WERR_DS_FILTER_UNKNOWN },
	{ "WERR_DS_PARAM_ERROR", WERR_DS_PARAM_ERROR },
	{ "WERR_DS_NOT_SUPPORTED", WERR_DS_NOT_SUPPORTED },
	{ "WERR_DS_NO_RESULTS_RETURNED", WERR_DS_NO_RESULTS_RETURNED },
	{ "WERR_DS_CONTROL_NOT_FOUND", WERR_DS_CONTROL_NOT_FOUND },
	{ "WERR_DS_CLIENT_LOOP", WERR_DS_CLIENT_LOOP },
	{ "WERR_DS_REFERRAL_LIMIT_EXCEEDED", WERR_DS_REFERRAL_LIMIT_EXCEEDED },
	{ "WERR_DS_SORT_CONTROL_MISSING", WERR_DS_SORT_CONTROL_MISSING },
	{ "WERR_DS_OFFSET_RANGE_ERROR", WERR_DS_OFFSET_RANGE_ERROR },
	{ "WERR_DS_ROOT_MUST_BE_NC", WERR_DS_ROOT_MUST_BE_NC },
	{ "WERR_DS_ADD_REPLICA_INHIBITED", WERR_DS_ADD_REPLICA_INHIBITED },
	{ "WERR_DS_ATT_NOT_DEF_IN_SCHEMA", WERR_DS_ATT_NOT_DEF_IN_SCHEMA },
	{ "WERR_DS_MAX_OBJ_SIZE_EXCEEDED", WERR_DS_MAX_OBJ_SIZE_EXCEEDED },
	{ "WERR_DS_NO_RDN_DEFINED_IN_SCHEMA", WERR_DS_NO_RDN_DEFINED_IN_SCHEMA },
	{ "WERR_DS_RDN_DOESNT_MATCH_SCHEMA", WERR_DS_RDN_DOESNT_MATCH_SCHEMA },
	{ "WERR_DS_NO_REQUESTED_ATTS_FOUND", WERR_DS_NO_REQUESTED_ATTS_FOUND },
	{ "WERR_DS_USER_BUFFER_TO_SMALL", WERR_DS_USER_BUFFER_TO_SMALL },
	{ "WERR_DS_ATT_IS_NOT_ON_OBJ", WERR_DS_ATT_IS_NOT_ON_OBJ },
	{ "WERR_DS_ILLEGAL_MOD_OPERATION", WERR_DS_ILLEGAL_MOD_OPERATION },
	{ "WERR_DS_OBJ_TOO_LARGE", WERR_DS_OBJ_TOO_LARGE },
	{ "WERR_DS_BAD_INSTANCE_TYPE", WERR_DS_BAD_INSTANCE_TYPE },
	{ "WERR_DS_MASTERDSA_REQUIRED", WERR_DS_MASTERDSA_REQUIRED },
	{ "WERR_DS_OBJECT_CLASS_REQUIRED", WERR_DS_OBJECT_CLASS_REQUIRED },
	{ "WERR_DS_MISSING_REQUIRED_ATT", WERR_DS_MISSING_REQUIRED_ATT },
	{ "WERR_DS_ATT_NOT_DEF_FOR_CLASS", WERR_DS_ATT_NOT_DEF_FOR_CLASS },
	{ "WERR_DS_ATT_ALREADY_EXISTS", WERR_DS_ATT_ALREADY_EXISTS },
	{ "WERR_DS_CANT_ADD_ATT_VALUES", WERR_DS_CANT_ADD_ATT_VALUES },
	{ "WERR_DS_RANGE_CONSTRAINT", WERR_DS_RANGE_CONSTRAINT },
	{ "WERR_DS_ATT_VAL_ALREADY_EXISTS", WERR_DS_ATT_VAL_ALREADY_EXISTS },
	{ "WERR_DS_CANT_REM_MISSING_ATT", WERR_DS_CANT_REM_MISSING_ATT },
	{ "WERR_DS_CANT_REM_MISSING_ATT_VAL", WERR_DS_CANT_REM_MISSING_ATT_VAL },
	{ "WERR_DS_ROOT_CANT_BE_SUBREF", WERR_DS_ROOT_CANT_BE_SUBREF },
	{ "WERR_DS_NO_CHAINING", WERR_DS_NO_CHAINING },
	{ "WERR_DS_NO_CHAINED_EVAL", WERR_DS_NO_CHAINED_EVAL },
	{ "WERR_DS_NO_PARENT_OBJECT", WERR_DS_NO_PARENT_OBJECT },
	{ "WERR_DS_PARENT_IS_AN_ALIAS", WERR_DS_PARENT_IS_AN_ALIAS },
	{ "WERR_DS_CANT_MIX_MASTER_AND_REPS", WERR_DS_CANT_MIX_MASTER_AND_REPS },
	{ "WERR_DS_CHILDREN_EXIST", WERR_DS_CHILDREN_EXIST },
	{ "WERR_DS_ALIASED_OBJ_MISSING", WERR_DS_ALIASED_OBJ_MISSING },
	{ "WERR_DS_BAD_NAME_SYNTAX", WERR_DS_BAD_NAME_SYNTAX },
	{ "WERR_DS_ALIAS_POINTS_TO_ALIAS", WERR_DS_ALIAS_POINTS_TO_ALIAS },
	{ "WERR_DS_CANT_DEREF_ALIAS", WERR_DS_CANT_DEREF_ALIAS },
	{ "WERR_DS_OUT_OF_SCOPE", WERR_DS_OUT_OF_SCOPE },
	{ "WERR_DS_OBJECT_BEING_REMOVED", WERR_DS_OBJECT_BEING_REMOVED },
	{ "WERR_DS_CANT_DELETE_DSA_OBJ", WERR_DS_CANT_DELETE_DSA_OBJ },
	{ "WERR_DS_DSA_MUST_BE_INT_MASTER", WERR_DS_DSA_MUST_BE_INT_MASTER },
	{ "WERR_DS_CLASS_NOT_DSA", WERR_DS_CLASS_NOT_DSA },
	{ "WERR_DS_ILLEGAL_SUPERIOR", WERR_DS_ILLEGAL_SUPERIOR },
	{ "WERR_DS_ATTRIBUTE_OWNED_BY_SAM", WERR_DS_ATTRIBUTE_OWNED_BY_SAM },
	{ "WERR_DS_NAME_TOO_MANY_PARTS", WERR_DS_NAME_TOO_MANY_PARTS },
	{ "WERR_DS_NAME_TOO_LONG", WERR_DS_NAME_TOO_LONG },
	{ "WERR_DS_NAME_VALUE_TOO_LONG", WERR_DS_NAME_VALUE_TOO_LONG },
	{ "WERR_DS_NAME_UNPARSEABLE", WERR_DS_NAME_UNPARSEABLE },
	{ "WERR_DS_NAME_TYPE_UNKNOWN", WERR_DS_NAME_TYPE_UNKNOWN },
	{ "WERR_DS_NOT_AN_OBJECT", WERR_DS_NOT_AN_OBJECT },
	{ "WERR_DS_SEC_DESC_TOO_SHORT", WERR_DS_SEC_DESC_TOO_SHORT },
	{ "WERR_DS_SEC_DESC_INVALID", WERR_DS_SEC_DESC_INVALID },
	{ "WERR_DS_NO_DELETED_NAME", WERR_DS_NO_DELETED_NAME },
	{ "WERR_DS_SUBREF_MUST_HAVE_PARENT", WERR_DS_SUBREF_MUST_HAVE_PARENT },
	{ "WERR_DS_NCNAME_MUST_BE_NC", WERR_DS_NCNAME_MUST_BE_NC },
	{ "WERR_DS_CANT_ADD_SYSTEM_ONLY", WERR_DS_CANT_ADD_SYSTEM_ONLY },
	{ "WERR_DS_CLASS_MUST_BE_CONCRETE", WERR_DS_CLASS_MUST_BE_CONCRETE },
	{ "WERR_DS_INVALID_DMD", WERR_DS_INVALID_DMD },
	{ "WERR_DS_OBJ_GUID_EXISTS", WERR_DS_OBJ_GUID_EXISTS },
	{ "WERR_DS_NOT_ON_BACKLINK", WERR_DS_NOT_ON_BACKLINK },
	{ "WERR_DS_NO_CROSSREF_FOR_NC", WERR_DS_NO_CROSSREF_FOR_NC },
	{ "WERR_DS_SHUTTING_DOWN", WERR_DS_SHUTTING_DOWN },
	{ "WERR_DS_UNKNOWN_OPERATION", WERR_DS_UNKNOWN_OPERATION },
	{ "WERR_DS_INVALID_ROLE_OWNER", WERR_DS_INVALID_ROLE_OWNER },
	{ "WERR_DS_COULDNT_CONTACT_FSMO", WERR_DS_COULDNT_CONTACT_FSMO },
	{ "WERR_DS_CROSS_NC_DN_RENAME", WERR_DS_CROSS_NC_DN_RENAME },
	{ "WERR_DS_CANT_MOD_SYSTEM_ONLY", WERR_DS_CANT_MOD_SYSTEM_ONLY },
	{ "WERR_DS_REPLICATOR_ONLY", WERR_DS_REPLICATOR_ONLY },
	{ "WERR_DS_OBJ_CLASS_NOT_DEFINED", WERR_DS_OBJ_CLASS_NOT_DEFINED },
	{ "WERR_DS_OBJ_CLASS_NOT_SUBCLASS", WERR_DS_OBJ_CLASS_NOT_SUBCLASS },
	{ "WERR_DS_NAME_REFERENCE_INVALID", WERR_DS_NAME_REFERENCE_INVALID },
	{ "WERR_DS_CROSS_REF_EXISTS", WERR_DS_CROSS_REF_EXISTS },
	{ "WERR_DS_CANT_DEL_MASTER_CROSSREF", WERR_DS_CANT_DEL_MASTER_CROSSREF },
	{ "WERR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD", WERR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD },
	{ "WERR_DS_NOTIFY_FILTER_TOO_COMPLEX", WERR_DS_NOTIFY_FILTER_TOO_COMPLEX },
	{ "WERR_DS_DUP_RDN", WERR_DS_DUP_RDN },
	{ "WERR_DS_DUP_OID", WERR_DS_DUP_OID },
	{ "WERR_DS_DUP_MAPI_ID", WERR_DS_DUP_MAPI_ID },
	{ "WERR_DS_DUP_SCHEMA_ID_GUID", WERR_DS_DUP_SCHEMA_ID_GUID },
	{ "WERR_DS_DUP_LDAP_DISPLAY_NAME", WERR_DS_DUP_LDAP_DISPLAY_NAME },
	{ "WERR_DS_SEMANTIC_ATT_TEST", WERR_DS_SEMANTIC_ATT_TEST },
	{ "WERR_DS_SYNTAX_MISMATCH", WERR_DS_SYNTAX_MISMATCH },
	{ "WERR_DS_EXISTS_IN_MUST_HAVE", WERR_DS_EXISTS_IN_MUST_HAVE },
	{ "WERR_DS_EXISTS_IN_MAY_HAVE", WERR_DS_EXISTS_IN_MAY_HAVE },
	{ "WERR_DS_NONEXISTENT_MAY_HAVE", WERR_DS_NONEXISTENT_MAY_HAVE },
	{ "WERR_DS_NONEXISTENT_MUST_HAVE", WERR_DS_NONEXISTENT_MUST_HAVE },
	{ "WERR_DS_AUX_CLS_TEST_FAIL", WERR_DS_AUX_CLS_TEST_FAIL },
	{ "WERR_DS_NONEXISTENT_POSS_SUP", WERR_DS_NONEXISTENT_POSS_SUP },
	{ "WERR_DS_SUB_CLS_TEST_FAIL", WERR_DS_SUB_CLS_TEST_FAIL },
	{ "WERR_DS_BAD_RDN_ATT_ID_SYNTAX", WERR_DS_BAD_RDN_ATT_ID_SYNTAX },
	{ "WERR_DS_EXISTS_IN_AUX_CLS", WERR_DS_EXISTS_IN_AUX_CLS },
	{ "WERR_DS_EXISTS_IN_SUB_CLS", WERR_DS_EXISTS_IN_SUB_CLS },
	{ "WERR_DS_EXISTS_IN_POSS_SUP", WERR_DS_EXISTS_IN_POSS_SUP },
	{ "WERR_DS_RECALCSCHEMA_FAILED", WERR_DS_RECALCSCHEMA_FAILED },
	{ "WERR_DS_TREE_DELETE_NOT_FINISHED", WERR_DS_TREE_DELETE_NOT_FINISHED },
	{ "WERR_DS_CANT_DELETE", WERR_DS_CANT_DELETE },
	{ "WERR_DS_ATT_SCHEMA_REQ_ID", WERR_DS_ATT_SCHEMA_REQ_ID },
	{ "WERR_DS_BAD_ATT_SCHEMA_SYNTAX", WERR_DS_BAD_ATT_SCHEMA_SYNTAX },
	{ "WERR_DS_CANT_CACHE_ATT", WERR_DS_CANT_CACHE_ATT },
	{ "WERR_DS_CANT_CACHE_CLASS", WERR_DS_CANT_CACHE_CLASS },
	{ "WERR_DS_CANT_REMOVE_ATT_CACHE", WERR_DS_CANT_REMOVE_ATT_CACHE },
	{ "WERR_DS_CANT_REMOVE_CLASS_CACHE", WERR_DS_CANT_REMOVE_CLASS_CACHE },
	{ "WERR_DS_CANT_RETRIEVE_DN", WERR_DS_CANT_RETRIEVE_DN },
	{ "WERR_DS_MISSING_SUPREF", WERR_DS_MISSING_SUPREF },
	{ "WERR_DS_CANT_RETRIEVE_INSTANCE", WERR_DS_CANT_RETRIEVE_INSTANCE },
	{ "WERR_DS_CODE_INCONSISTENCY", WERR_DS_CODE_INCONSISTENCY },
	{ "WERR_DS_DATABASE_ERROR", WERR_DS_DATABASE_ERROR },
	{ "WERR_DS_MISSING_EXPECTED_ATT", WERR_DS_MISSING_EXPECTED_ATT },
	{ "WERR_DS_NCNAME_MISSING_CR_REF", WERR_DS_NCNAME_MISSING_CR_REF },
	{ "WERR_DS_SECURITY_CHECKING_ERROR", WERR_DS_SECURITY_CHECKING_ERROR },
	{ "WERR_DS_GCVERIFY_ERROR", WERR_DS_GCVERIFY_ERROR },
	{ "WERR_DS_CANT_FIND_DSA_OBJ", WERR_DS_CANT_FIND_DSA_OBJ },
	{ "WERR_DS_CANT_FIND_EXPECTED_NC", WERR_DS_CANT_FIND_EXPECTED_NC },
	{ "WERR_DS_CANT_FIND_NC_IN_CACHE", WERR_DS_CANT_FIND_NC_IN_CACHE },
	{ "WERR_DS_CANT_RETRIEVE_CHILD", WERR_DS_CANT_RETRIEVE_CHILD },
	{ "WERR_DS_SECURITY_ILLEGAL_MODIFY", WERR_DS_SECURITY_ILLEGAL_MODIFY },
	{ "WERR_DS_CANT_REPLACE_HIDDEN_REC", WERR_DS_CANT_REPLACE_HIDDEN_REC },
	{ "WERR_DS_BAD_HIERARCHY_FILE", WERR_DS_BAD_HIERARCHY_FILE },
	{ "WERR_DS_BUILD_HIERARCHY_TABLE_FAILED", WERR_DS_BUILD_HIERARCHY_TABLE_FAILED },
	{ "WERR_DS_CONFIG_PARAM_MISSING", WERR_DS_CONFIG_PARAM_MISSING },
	{ "WERR_DS_COUNTING_AB_INDICES_FAILED", WERR_DS_COUNTING_AB_INDICES_FAILED },
	{ "WERR_DS_HIERARCHY_TABLE_MALLOC_FAILED", WERR_DS_HIERARCHY_TABLE_MALLOC_FAILED },
	{ "WERR_DS_INTERNAL_FAILURE", WERR_DS_INTERNAL_FAILURE },
	{ "WERR_DS_UNKNOWN_ERROR", WERR_DS_UNKNOWN_ERROR },
	{ "WERR_DS_ROOT_REQUIRES_CLASS_TOP", WERR_DS_ROOT_REQUIRES_CLASS_TOP },
	{ "WERR_DS_REFUSING_FSMO_ROLES", WERR_DS_REFUSING_FSMO_ROLES },
	{ "WERR_DS_MISSING_FSMO_SETTINGS", WERR_DS_MISSING_FSMO_SETTINGS },
	{ "WERR_DS_UNABLE_TO_SURRENDER_ROLES", WERR_DS_UNABLE_TO_SURRENDER_ROLES },
	{ "WERR_DS_DRA_GENERIC", WERR_DS_DRA_GENERIC },
	{ "WERR_DS_DRA_BUSY", WERR_DS_DRA_BUSY },
	{ "WERR_DS_DRA_DN_EXISTS", WERR_DS_DRA_DN_EXISTS },
	{ "WERR_DS_DRA_INCONSISTENT_DIT", WERR_DS_DRA_INCONSISTENT_DIT },
	{ "WERR_DS_DRA_CONNECTION_FAILED", WERR_DS_DRA_CONNECTION_FAILED },
	{ "WERR_DS_DRA_BAD_INSTANCE_TYPE", WERR_DS_DRA_BAD_INSTANCE_TYPE },
	{ "WERR_DS_DRA_MAIL_PROBLEM", WERR_DS_DRA_MAIL_PROBLEM },
	{ "WERR_DS_DRA_REF_ALREADY_EXISTS", WERR_DS_DRA_REF_ALREADY_EXISTS },
	{ "WERR_DS_DRA_REF_NOT_FOUND", WERR_DS_DRA_REF_NOT_FOUND },
	{ "WERR_DS_DRA_OBJ_IS_REP_SOURCE", WERR_DS_DRA_OBJ_IS_REP_SOURCE },
	{ "WERR_DS_DRA_NOT_SUPPORTED", WERR_DS_DRA_NOT_SUPPORTED },
	{ "WERR_DS_DRA_RPC_CANCELLED", WERR_DS_DRA_RPC_CANCELLED },
	{ "WERR_DS_DRA_SINK_DISABLED", WERR_DS_DRA_SINK_DISABLED },
	{ "WERR_DS_DRA_NAME_COLLISION", WERR_DS_DRA_NAME_COLLISION },
	{ "WERR_DS_DRA_SOURCE_REINSTALLED", WERR_DS_DRA_SOURCE_REINSTALLED },
	{ "WERR_DS_DRA_MISSING_PARENT", WERR_DS_DRA_MISSING_PARENT },
	{ "WERR_DS_DRA_PREEMPTED", WERR_DS_DRA_PREEMPTED },
	{ "WERR_DS_DRA_ABANDON_SYNC", WERR_DS_DRA_ABANDON_SYNC },
	{ "WERR_DS_DRA_SHUTDOWN", WERR_DS_DRA_SHUTDOWN },
	{ "WERR_DS_DRA_INCOMPATIBLE_PARTIAL_SET", WERR_DS_DRA_INCOMPATIBLE_PARTIAL_SET },
	{ "WERR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA", WERR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA },
	{ "WERR_DS_DRA_EXTN_CONNECTION_FAILED", WERR_DS_DRA_EXTN_CONNECTION_FAILED },
	{ "WERR_DS_INSTALL_SCHEMA_MISMATCH", WERR_DS_INSTALL_SCHEMA_MISMATCH },
	{ "WERR_DS_DUP_LINK_ID", WERR_DS_DUP_LINK_ID },
	{ "WERR_DS_NAME_ERROR_RESOLVING", WERR_DS_NAME_ERROR_RESOLVING },
	{ "WERR_DS_NAME_ERROR_NOT_FOUND", WERR_DS_NAME_ERROR_NOT_FOUND },
	{ "WERR_DS_NAME_ERROR_NOT_UNIQUE", WERR_DS_NAME_ERROR_NOT_UNIQUE },
	{ "WERR_DS_NAME_ERROR_NO_MAPPING", WERR_DS_NAME_ERROR_NO_MAPPING },
	{ "WERR_DS_NAME_ERROR_DOMAIN_ONLY", WERR_DS_NAME_ERROR_DOMAIN_ONLY },
	{ "WERR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING", WERR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING },
	{ "WERR_DS_CONSTRUCTED_ATT_MOD", WERR_DS_CONSTRUCTED_ATT_MOD },
	{ "WERR_DS_WRONG_OM_OBJ_CLASS", WERR_DS_WRONG_OM_OBJ_CLASS },
	{ "WERR_DS_DRA_REPL_PENDING", WERR_DS_DRA_REPL_PENDING },
	{ "WERR_DS_DS_REQUIRED", WERR_DS_DS_REQUIRED },
	{ "WERR_DS_INVALID_LDAP_DISPLAY_NAME", WERR_DS_INVALID_LDAP_DISPLAY_NAME },
	{ "WERR_DS_NON_BASE_SEARCH", WERR_DS_NON_BASE_SEARCH },
	{ "WERR_DS_CANT_RETRIEVE_ATTS", WERR_DS_CANT_RETRIEVE_ATTS },
	{ "WERR_DS_BACKLINK_WITHOUT_LINK", WERR_DS_BACKLINK_WITHOUT_LINK },
	{ "WERR_DS_EPOCH_MISMATCH", WERR_DS_EPOCH_MISMATCH },
	{ "WERR_DS_SRC_NAME_MISMATCH", WERR_DS_SRC_NAME_MISMATCH },
	{ "WERR_DS_SRC_AND_DST_NC_IDENTICAL", WERR_DS_SRC_AND_DST_NC_IDENTICAL },
	{ "WERR_DS_DST_NC_MISMATCH", WERR_DS_DST_NC_MISMATCH },
	{ "WERR_DS_NOT_AUTHORITIVE_FOR_DST_NC", WERR_DS_NOT_AUTHORITIVE_FOR_DST_NC },
	{ "WERR_DS_SRC_GUID_MISMATCH", WERR_DS_SRC_GUID_MISMATCH },
	{ "WERR_DS_CANT_MOVE_DELETED_OBJECT", WERR_DS_CANT_MOVE_DELETED_OBJECT },
	{ "WERR_DS_PDC_OPERATION_IN_PROGRESS", WERR_DS_PDC_OPERATION_IN_PROGRESS },
	{ "WERR_DS_CROSS_DOMAIN_CLEANUP_REQD", WERR_DS_CROSS_DOMAIN_CLEANUP_REQD },
	{ "WERR_DS_ILLEGAL_XDOM_MOVE_OPERATION", WERR_DS_ILLEGAL_XDOM_MOVE_OPERATION },
	{ "WERR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS", WERR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS },
	{ "WERR_DS_NC_MUST_HAVE_NC_PARENT", WERR_DS_NC_MUST_HAVE_NC_PARENT },
	{ "WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE", WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE },
	{ "WERR_DS_DST_DOMAIN_NOT_NATIVE", WERR_DS_DST_DOMAIN_NOT_NATIVE },
	{ "WERR_DS_MISSING_INFRASTRUCTURE_CONTAINER", WERR_DS_MISSING_INFRASTRUCTURE_CONTAINER },
	{ "WERR_DS_CANT_MOVE_ACCOUNT_GROUP", WERR_DS_CANT_MOVE_ACCOUNT_GROUP },
	{ "WERR_DS_CANT_MOVE_RESOURCE_GROUP", WERR_DS_CANT_MOVE_RESOURCE_GROUP },
	{ "WERR_DS_INVALID_SEARCH_FLAG", WERR_DS_INVALID_SEARCH_FLAG },
	{ "WERR_DS_NO_TREE_DELETE_ABOVE_NC", WERR_DS_NO_TREE_DELETE_ABOVE_NC },
	{ "WERR_DS_COULDNT_LOCK_TREE_FOR_DELETE", WERR_DS_COULDNT_LOCK_TREE_FOR_DELETE },
	{ "WERR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE", WERR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE },
	{ "WERR_DS_SAM_INIT_FAILURE", WERR_DS_SAM_INIT_FAILURE },
	{ "WERR_DS_SENSITIVE_GROUP_VIOLATION", WERR_DS_SENSITIVE_GROUP_VIOLATION },
	{ "WERR_DS_CANT_MOD_PRIMARYGROUPID", WERR_DS_CANT_MOD_PRIMARYGROUPID },
	{ "WERR_DS_ILLEGAL_BASE_SCHEMA_MOD", WERR_DS_ILLEGAL_BASE_SCHEMA_MOD },
	{ "WERR_DS_NONSAFE_SCHEMA_CHANGE", WERR_DS_NONSAFE_SCHEMA_CHANGE },
	{ "WERR_DS_SCHEMA_UPDATE_DISALLOWED", WERR_DS_SCHEMA_UPDATE_DISALLOWED },
	{ "WERR_DS_CANT_CREATE_UNDER_SCHEMA", WERR_DS_CANT_CREATE_UNDER_SCHEMA },
	{ "WERR_DS_INVALID_GROUP_TYPE", WERR_DS_INVALID_GROUP_TYPE },
	{ "WERR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN", WERR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN },
	{ "WERR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN", WERR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN },
	{ "WERR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER", WERR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER },
	{ "WERR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER", WERR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER },
	{ "WERR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER", WERR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER },
	{ "WERR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER", WERR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER },
	{ "WERR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER", WERR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER },
	{ "WERR_DS_HAVE_PRIMARY_MEMBERS", WERR_DS_HAVE_PRIMARY_MEMBERS },
	{ "WERR_DS_STRING_SD_CONVERSION_FAILED", WERR_DS_STRING_SD_CONVERSION_FAILED },
	{ "WERR_DS_NAMING_MASTER_GC", WERR_DS_NAMING_MASTER_GC },
	{ "WERR_DS_COULDNT_UPDATE_SPNS", WERR_DS_COULDNT_UPDATE_SPNS },
	{ "WERR_DS_CANT_RETRIEVE_SD", WERR_DS_CANT_RETRIEVE_SD },
	{ "WERR_DS_KEY_NOT_UNIQUE", WERR_DS_KEY_NOT_UNIQUE },
	{ "WERR_DS_WRONG_LINKED_ATT_SYNTAX", WERR_DS_WRONG_LINKED_ATT_SYNTAX },
	{ "WERR_DS_SAM_NEED_BOOTKEY_PASSWORD", WERR_DS_SAM_NEED_BOOTKEY_PASSWORD },
	{ "WERR_DS_SAM_NEED_BOOTKEY_FLOPPY", WERR_DS_SAM_NEED_BOOTKEY_FLOPPY },
	{ "WERR_DS_CANT_START", WERR_DS_CANT_START },
	{ "WERR_DS_INIT_FAILURE", WERR_DS_INIT_FAILURE },
	{ "WERR_DS_NO_PKT_PRIVACY_ON_CONNECTION", WERR_DS_NO_PKT_PRIVACY_ON_CONNECTION },
	{ "WERR_DS_SOURCE_DOMAIN_IN_FOREST", WERR_DS_SOURCE_DOMAIN_IN_FOREST },
	{ "WERR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST", WERR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST },
	{ "WERR_DS_DESTINATION_AUDITING_NOT_ENABLED", WERR_DS_DESTINATION_AUDITING_NOT_ENABLED },
	{ "WERR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN", WERR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN },
	{ "WERR_DS_SRC_OBJ_NOT_GROUP_OR_USER", WERR_DS_SRC_OBJ_NOT_GROUP_OR_USER },
	{ "WERR_DS_SRC_SID_EXISTS_IN_FOREST", WERR_DS_SRC_SID_EXISTS_IN_FOREST },
	{ "WERR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH", WERR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH },
	{ "WERR_SAM_INIT_FAILURE", WERR_SAM_INIT_FAILURE },
	{ "WERR_DS_DRA_SCHEMA_INFO_SHIP", WERR_DS_DRA_SCHEMA_INFO_SHIP },
	{ "WERR_DS_DRA_SCHEMA_CONFLICT", WERR_DS_DRA_SCHEMA_CONFLICT },
	{ "WERR_DS_DRA_EARLIER_SCHEMA_CONFLICT", WERR_DS_DRA_EARLIER_SCHEMA_CONFLICT },
	{ "WERR_DS_DRA_OBJ_NC_MISMATCH", WERR_DS_DRA_OBJ_NC_MISMATCH },
	{ "WERR_DS_NC_STILL_HAS_DSAS", WERR_DS_NC_STILL_HAS_DSAS },
	{ "WERR_DS_GC_REQUIRED", WERR_DS_GC_REQUIRED },
	{ "WERR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY", WERR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY },
	{ "WERR_DS_NO_FPO_IN_UNIVERSAL_GROUPS", WERR_DS_NO_FPO_IN_UNIVERSAL_GROUPS },
	{ "WERR_DS_CANT_ADD_TO_GC", WERR_DS_CANT_ADD_TO_GC },
	{ "WERR_DS_NO_CHECKPOINT_WITH_PDC", WERR_DS_NO_CHECKPOINT_WITH_PDC },
	{ "WERR_DS_SOURCE_AUDITING_NOT_ENABLED", WERR_DS_SOURCE_AUDITING_NOT_ENABLED },
	{ "WERR_DS_CANT_CREATE_IN_NONDOMAIN_NC", WERR_DS_CANT_CREATE_IN_NONDOMAIN_NC },
	{ "WERR_DS_INVALID_NAME_FOR_SPN", WERR_DS_INVALID_NAME_FOR_SPN },
	{ "WERR_DS_FILTER_USES_CONTRUCTED_ATTRS", WERR_DS_FILTER_USES_CONTRUCTED_ATTRS },
	{ "WERR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED", WERR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED },
	{ "WERR_DS_MUST_BE_RUN_ON_DST_DC", WERR_DS_MUST_BE_RUN_ON_DST_DC },
	{ "WERR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER", WERR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER },
	{ "WERR_DS_CANT_TREE_DELETE_CRITICAL_OBJ", WERR_DS_CANT_TREE_DELETE_CRITICAL_OBJ },
	{ "WERR_DS_INIT_FAILURE_CONSOLE", WERR_DS_INIT_FAILURE_CONSOLE },
	{ "WERR_DS_SAM_INIT_FAILURE_CONSOLE", WERR_DS_SAM_INIT_FAILURE_CONSOLE },
	{ "WERR_DS_FOREST_VERSION_TOO_HIGH", WERR_DS_FOREST_VERSION_TOO_HIGH },
	{ "WERR_DS_DOMAIN_VERSION_TOO_HIGH", WERR_DS_DOMAIN_VERSION_TOO_HIGH },
	{ "WERR_DS_FOREST_VERSION_TOO_LOW", WERR_DS_FOREST_VERSION_TOO_LOW },
	{ "WERR_DS_DOMAIN_VERSION_TOO_LOW", WERR_DS_DOMAIN_VERSION_TOO_LOW },
	{ "WERR_DS_INCOMPATIBLE_VERSION", WERR_DS_INCOMPATIBLE_VERSION },
	{ "WERR_DS_LOW_DSA_VERSION", WERR_DS_LOW_DSA_VERSION },
	{ "WERR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN", WERR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN },
	{ "WERR_DS_NOT_SUPPORTED_SORT_ORDER", WERR_DS_NOT_SUPPORTED_SORT_ORDER },
	{ "WERR_DS_NAME_NOT_UNIQUE", WERR_DS_NAME_NOT_UNIQUE },
	{ "WERR_DS_MACHINE_ACCOUNT_CREATED_PRENT4", WERR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 },
	{ "WERR_DS_OUT_OF_VERSION_STORE", WERR_DS_OUT_OF_VERSION_STORE },
	{ "WERR_DS_INCOMPATIBLE_CONTROLS_USED", WERR_DS_INCOMPATIBLE_CONTROLS_USED },
	{ "WERR_DS_NO_REF_DOMAIN", WERR_DS_NO_REF_DOMAIN },
	{ "WERR_DS_RESERVED_LINK_ID", WERR_DS_RESERVED_LINK_ID },
	{ "WERR_DS_LINK_ID_NOT_AVAILABLE", WERR_DS_LINK_ID_NOT_AVAILABLE },
	{ "WERR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER", WERR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER },
	{ "WERR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE", WERR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE },
	{ "WERR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC", WERR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC },
	{ "WERR_DS_MODIFYDN_DISALLOWED_BY_FLAG", WERR_DS_MODIFYDN_DISALLOWED_BY_FLAG },
	{ "WERR_DS_MODIFYDN_WRONG_GRANDPARENT", WERR_DS_MODIFYDN_WRONG_GRANDPARENT },
	{ "WERR_DS_NAME_ERROR_TRUST_REFERRAL", WERR_DS_NAME_ERROR_TRUST_REFERRAL },
	{ "WERR_NOT_SUPPORTED_ON_STANDARD_SERVER", WERR_NOT_SUPPORTED_ON_STANDARD_SERVER },
	{ "WERR_DS_CANT_ACCESS_REMOTE_PART_OF_AD", WERR_DS_CANT_ACCESS_REMOTE_PART_OF_AD },
	{ "WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2", WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 },
	{ "WERR_DS_THREAD_LIMIT_EXCEEDED", WERR_DS_THREAD_LIMIT_EXCEEDED },
	{ "WERR_DS_NOT_CLOSEST", WERR_DS_NOT_CLOSEST },
	{ "WERR_DS_SINGLE_USER_MODE_FAILED", WERR_DS_SINGLE_USER_MODE_FAILED },
	{ "WERR_DS_NTDSCRIPT_SYNTAX_ERROR", WERR_DS_NTDSCRIPT_SYNTAX_ERROR },
	{ "WERR_DS_NTDSCRIPT_PROCESS_ERROR", WERR_DS_NTDSCRIPT_PROCESS_ERROR },
	{ "WERR_DS_DIFFERENT_REPL_EPOCHS", WERR_DS_DIFFERENT_REPL_EPOCHS },
	{ "WERR_DS_DRS_EXTENSIONS_CHANGED", WERR_DS_DRS_EXTENSIONS_CHANGED },
	{ "WERR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR", WERR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR },
	{ "WERR_DS_EXISTS_IN_RDNATTID", WERR_DS_EXISTS_IN_RDNATTID },
	{ "WERR_DS_AUTHORIZATION_FAILED", WERR_DS_AUTHORIZATION_FAILED },
	{ "WERR_DS_INVALID_SCRIPT", WERR_DS_INVALID_SCRIPT },
	{ "WERR_DS_REMOTE_CROSSREF_OP_FAILED", WERR_DS_REMOTE_CROSSREF_OP_FAILED },
	{ "WERR_DS_CROSS_REF_BUSY", WERR_DS_CROSS_REF_BUSY },
	{ "WERR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN", WERR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN },
	{ "WERR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC", WERR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC },
	{ "WERR_DS_DUPLICATE_ID_FOUND", WERR_DS_DUPLICATE_ID_FOUND },
	{ "WERR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT", WERR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT },
	{ "WERR_DS_GROUP_CONVERSION_ERROR", WERR_DS_GROUP_CONVERSION_ERROR },
	{ "WERR_DS_CANT_MOVE_APP_BASIC_GROUP", WERR_DS_CANT_MOVE_APP_BASIC_GROUP },
	{ "WERR_DS_CANT_MOVE_APP_QUERY_GROUP", WERR_DS_CANT_MOVE_APP_QUERY_GROUP },
	{ "WERR_DS_ROLE_NOT_VERIFIED", WERR_DS_ROLE_NOT_VERIFIED },
	{ "WERR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL", WERR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL },
	{ "WERR_DS_DOMAIN_RENAME_IN_PROGRESS", WERR_DS_DOMAIN_RENAME_IN_PROGRESS },
	{ "WERR_DS_EXISTING_AD_CHILD_NC", WERR_DS_EXISTING_AD_CHILD_NC },
	{ "WERR_DS_REPL_LIFETIME_EXCEEDED", WERR_DS_REPL_LIFETIME_EXCEEDED },
	{ "WERR_DS_DISALLOWED_IN_SYSTEM_CONTAINER", WERR_DS_DISALLOWED_IN_SYSTEM_CONTAINER },
	{ "WERR_DS_LDAP_SEND_QUEUE_FULL", WERR_DS_LDAP_SEND_QUEUE_FULL },
	{ "WERR_DS_DRA_OUT_SCHEDULE_WINDOW", WERR_DS_DRA_OUT_SCHEDULE_WINDOW },
	{ "WERR_DS_POLICY_NOT_KNOWN", WERR_DS_POLICY_NOT_KNOWN },
	{ "WERR_NO_SITE_SETTINGS_OBJECT", WERR_NO_SITE_SETTINGS_OBJECT },
	{ "WERR_NO_SECRETS", WERR_NO_SECRETS },
	{ "WERR_NO_WRITABLE_DC_FOUND", WERR_NO_WRITABLE_DC_FOUND },
	{ "WERR_DS_NO_SERVER_OBJECT", WERR_DS_NO_SERVER_OBJECT },
	{ "WERR_DS_NO_NTDSA_OBJECT", WERR_DS_NO_NTDSA_OBJECT },
	{ "WERR_DS_NON_ASQ_SEARCH", WERR_DS_NON_ASQ_SEARCH },
	{ "WERR_DS_AUDIT_FAILURE", WERR_DS_AUDIT_FAILURE },
	{ "WERR_DS_INVALID_SEARCH_FLAG_SUBTREE", WERR_DS_INVALID_SEARCH_FLAG_SUBTREE },
	{ "WERR_DS_INVALID_SEARCH_FLAG_TUPLE", WERR_DS_INVALID_SEARCH_FLAG_TUPLE },
	{ "WERR_IPSEC_QM_POLICY_EXISTS", WERR_IPSEC_QM_POLICY_EXISTS },
	{ "WERR_IPSEC_QM_POLICY_NOT_FOUND", WERR_IPSEC_QM_POLICY_NOT_FOUND },
	{ "WERR_IPSEC_QM_POLICY_IN_USE", WERR_IPSEC_QM_POLICY_IN_USE },
	{ "WERR_IPSEC_MM_POLICY_EXISTS", WERR_IPSEC_MM_POLICY_EXISTS },
	{ "WERR_IPSEC_MM_POLICY_NOT_FOUND", WERR_IPSEC_MM_POLICY_NOT_FOUND },
	{ "WERR_IPSEC_MM_POLICY_IN_USE", WERR_IPSEC_MM_POLICY_IN_USE },
	{ "WERR_IPSEC_MM_FILTER_EXISTS", WERR_IPSEC_MM_FILTER_EXISTS },
	{ "WERR_IPSEC_MM_FILTER_NOT_FOUND", WERR_IPSEC_MM_FILTER_NOT_FOUND },
	{ "WERR_IPSEC_TRANSPORT_FILTER_EXISTS", WERR_IPSEC_TRANSPORT_FILTER_EXISTS },
	{ "WERR_IPSEC_TRANSPORT_FILTER_NOT_FOUND", WERR_IPSEC_TRANSPORT_FILTER_NOT_FOUND },
	{ "WERR_IPSEC_MM_AUTH_EXISTS", WERR_IPSEC_MM_AUTH_EXISTS },
	{ "WERR_IPSEC_MM_AUTH_NOT_FOUND", WERR_IPSEC_MM_AUTH_NOT_FOUND },
	{ "WERR_IPSEC_MM_AUTH_IN_USE", WERR_IPSEC_MM_AUTH_IN_USE },
	{ "WERR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND", WERR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND },
	{ "WERR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND", WERR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND },
	{ "WERR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND", WERR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND },
	{ "WERR_IPSEC_TUNNEL_FILTER_EXISTS", WERR_IPSEC_TUNNEL_FILTER_EXISTS },
	{ "WERR_IPSEC_TUNNEL_FILTER_NOT_FOUND", WERR_IPSEC_TUNNEL_FILTER_NOT_FOUND },
	{ "WERR_IPSEC_MM_FILTER_PENDING_DELETION", WERR_IPSEC_MM_FILTER_PENDING_DELETION },
	{ "WERR_IPSEC_TRANSPORT_FILTER_ENDING_DELETION", WERR_IPSEC_TRANSPORT_FILTER_ENDING_DELETION },
	{ "WERR_IPSEC_TUNNEL_FILTER_PENDING_DELETION", WERR_IPSEC_TUNNEL_FILTER_PENDING_DELETION },
	{ "WERR_IPSEC_MM_POLICY_PENDING_ELETION", WERR_IPSEC_MM_POLICY_PENDING_ELETION },
	{ "WERR_IPSEC_MM_AUTH_PENDING_DELETION", WERR_IPSEC_MM_AUTH_PENDING_DELETION },
	{ "WERR_IPSEC_QM_POLICY_PENDING_DELETION", WERR_IPSEC_QM_POLICY_PENDING_DELETION },
	{ "WERR_IPSEC_IKE_NEG_STATUS_BEGIN", WERR_IPSEC_IKE_NEG_STATUS_BEGIN },
	{ "WERR_IPSEC_IKE_AUTH_FAIL", WERR_IPSEC_IKE_AUTH_FAIL },
	{ "WERR_IPSEC_IKE_ATTRIB_FAIL", WERR_IPSEC_IKE_ATTRIB_FAIL },
	{ "WERR_IPSEC_IKE_NEGOTIATION_PENDING", WERR_IPSEC_IKE_NEGOTIATION_PENDING },
	{ "WERR_IPSEC_IKE_GENERAL_PROCESSING_ERROR", WERR_IPSEC_IKE_GENERAL_PROCESSING_ERROR },
	{ "WERR_IPSEC_IKE_TIMED_OUT", WERR_IPSEC_IKE_TIMED_OUT },
	{ "WERR_IPSEC_IKE_NO_CERT", WERR_IPSEC_IKE_NO_CERT },
	{ "WERR_IPSEC_IKE_SA_DELETED", WERR_IPSEC_IKE_SA_DELETED },
	{ "WERR_IPSEC_IKE_SA_REAPED", WERR_IPSEC_IKE_SA_REAPED },
	{ "WERR_IPSEC_IKE_MM_ACQUIRE_DROP", WERR_IPSEC_IKE_MM_ACQUIRE_DROP },
	{ "WERR_IPSEC_IKE_QM_ACQUIRE_DROP", WERR_IPSEC_IKE_QM_ACQUIRE_DROP },
	{ "WERR_IPSEC_IKE_QUEUE_DROP_MM", WERR_IPSEC_IKE_QUEUE_DROP_MM },
	{ "WERR_IPSEC_IKE_QUEUE_DROP_NO_MM", WERR_IPSEC_IKE_QUEUE_DROP_NO_MM },
	{ "WERR_IPSEC_IKE_DROP_NO_RESPONSE", WERR_IPSEC_IKE_DROP_NO_RESPONSE },
	{ "WERR_IPSEC_IKE_MM_DELAY_DROP", WERR_IPSEC_IKE_MM_DELAY_DROP },
	{ "WERR_IPSEC_IKE_QM_DELAY_DROP", WERR_IPSEC_IKE_QM_DELAY_DROP },
	{ "WERR_IPSEC_IKE_ERROR", WERR_IPSEC_IKE_ERROR },
	{ "WERR_IPSEC_IKE_CRL_FAILED", WERR_IPSEC_IKE_CRL_FAILED },
	{ "WERR_IPSEC_IKE_INVALID_KEY_USAGE", WERR_IPSEC_IKE_INVALID_KEY_USAGE },
	{ "WERR_IPSEC_IKE_INVALID_CERT_TYPE", WERR_IPSEC_IKE_INVALID_CERT_TYPE },
	{ "WERR_IPSEC_IKE_NO_PRIVATE_KEY", WERR_IPSEC_IKE_NO_PRIVATE_KEY },
	{ "WERR_IPSEC_IKE_DH_FAIL", WERR_IPSEC_IKE_DH_FAIL },
	{ "WERR_IPSEC_IKE_INVALID_HEADER", WERR_IPSEC_IKE_INVALID_HEADER },
	{ "WERR_IPSEC_IKE_NO_POLICY", WERR_IPSEC_IKE_NO_POLICY },
	{ "WERR_IPSEC_IKE_INVALID_SIGNATURE", WERR_IPSEC_IKE_INVALID_SIGNATURE },
	{ "WERR_IPSEC_IKE_KERBEROS_ERROR", WERR_IPSEC_IKE_KERBEROS_ERROR },
	{ "WERR_IPSEC_IKE_NO_PUBLIC_KEY", WERR_IPSEC_IKE_NO_PUBLIC_KEY },
	{ "WERR_IPSEC_IKE_PROCESS_ERR", WERR_IPSEC_IKE_PROCESS_ERR },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_SA", WERR_IPSEC_IKE_PROCESS_ERR_SA },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_PROP", WERR_IPSEC_IKE_PROCESS_ERR_PROP },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_TRANS", WERR_IPSEC_IKE_PROCESS_ERR_TRANS },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_KE", WERR_IPSEC_IKE_PROCESS_ERR_KE },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_ID", WERR_IPSEC_IKE_PROCESS_ERR_ID },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_CERT", WERR_IPSEC_IKE_PROCESS_ERR_CERT },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_CERT_REQ", WERR_IPSEC_IKE_PROCESS_ERR_CERT_REQ },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_HASH", WERR_IPSEC_IKE_PROCESS_ERR_HASH },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_SIG", WERR_IPSEC_IKE_PROCESS_ERR_SIG },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_NONCE", WERR_IPSEC_IKE_PROCESS_ERR_NONCE },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_NOTIFY", WERR_IPSEC_IKE_PROCESS_ERR_NOTIFY },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_DELETE", WERR_IPSEC_IKE_PROCESS_ERR_DELETE },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_VENDOR", WERR_IPSEC_IKE_PROCESS_ERR_VENDOR },
	{ "WERR_IPSEC_IKE_INVALID_PAYLOAD", WERR_IPSEC_IKE_INVALID_PAYLOAD },
	{ "WERR_IPSEC_IKE_LOAD_SOFT_SA", WERR_IPSEC_IKE_LOAD_SOFT_SA },
	{ "WERR_IPSEC_IKE_SOFT_SA_TORN_DOWN", WERR_IPSEC_IKE_SOFT_SA_TORN_DOWN },
	{ "WERR_IPSEC_IKE_INVALID_COOKIE", WERR_IPSEC_IKE_INVALID_COOKIE },
	{ "WERR_IPSEC_IKE_NO_PEER_CERT", WERR_IPSEC_IKE_NO_PEER_CERT },
	{ "WERR_IPSEC_IKE_PEER_CRL_FAILED", WERR_IPSEC_IKE_PEER_CRL_FAILED },
	{ "WERR_IPSEC_IKE_POLICY_CHANGE", WERR_IPSEC_IKE_POLICY_CHANGE },
	{ "WERR_IPSEC_IKE_NO_MM_POLICY", WERR_IPSEC_IKE_NO_MM_POLICY },
	{ "WERR_IPSEC_IKE_NOTCBPRIV", WERR_IPSEC_IKE_NOTCBPRIV },
	{ "WERR_IPSEC_IKE_SECLOADFAIL", WERR_IPSEC_IKE_SECLOADFAIL },
	{ "WERR_IPSEC_IKE_FAILSSPINIT", WERR_IPSEC_IKE_FAILSSPINIT },
	{ "WERR_IPSEC_IKE_FAILQUERYSSP", WERR_IPSEC_IKE_FAILQUERYSSP },
	{ "WERR_IPSEC_IKE_SRVACQFAIL", WERR_IPSEC_IKE_SRVACQFAIL },
	{ "WERR_IPSEC_IKE_SRVQUERYCRED", WERR_IPSEC_IKE_SRVQUERYCRED },
	{ "WERR_IPSEC_IKE_GETSPIFAIL", WERR_IPSEC_IKE_GETSPIFAIL },
	{ "WERR_IPSEC_IKE_INVALID_FILTER", WERR_IPSEC_IKE_INVALID_FILTER },
	{ "WERR_IPSEC_IKE_OUT_OF_MEMORY", WERR_IPSEC_IKE_OUT_OF_MEMORY },
	{ "WERR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED", WERR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED },
	{ "WERR_IPSEC_IKE_INVALID_POLICY", WERR_IPSEC_IKE_INVALID_POLICY },
	{ "WERR_IPSEC_IKE_UNKNOWN_DOI", WERR_IPSEC_IKE_UNKNOWN_DOI },
	{ "WERR_IPSEC_IKE_INVALID_SITUATION", WERR_IPSEC_IKE_INVALID_SITUATION },
	{ "WERR_IPSEC_IKE_DH_FAILURE", WERR_IPSEC_IKE_DH_FAILURE },
	{ "WERR_IPSEC_IKE_INVALID_GROUP", WERR_IPSEC_IKE_INVALID_GROUP },
	{ "WERR_IPSEC_IKE_ENCRYPT", WERR_IPSEC_IKE_ENCRYPT },
	{ "WERR_IPSEC_IKE_DECRYPT", WERR_IPSEC_IKE_DECRYPT },
	{ "WERR_IPSEC_IKE_POLICY_MATCH", WERR_IPSEC_IKE_POLICY_MATCH },
	{ "WERR_IPSEC_IKE_UNSUPPORTED_ID", WERR_IPSEC_IKE_UNSUPPORTED_ID },
	{ "WERR_IPSEC_IKE_INVALID_HASH", WERR_IPSEC_IKE_INVALID_HASH },
	{ "WERR_IPSEC_IKE_INVALID_HASH_ALG", WERR_IPSEC_IKE_INVALID_HASH_ALG },
	{ "WERR_IPSEC_IKE_INVALID_HASH_SIZE", WERR_IPSEC_IKE_INVALID_HASH_SIZE },
	{ "WERR_IPSEC_IKE_INVALID_ENCRYPT_ALG", WERR_IPSEC_IKE_INVALID_ENCRYPT_ALG },
	{ "WERR_IPSEC_IKE_INVALID_AUTH_ALG", WERR_IPSEC_IKE_INVALID_AUTH_ALG },
	{ "WERR_IPSEC_IKE_INVALID_SIG", WERR_IPSEC_IKE_INVALID_SIG },
	{ "WERR_IPSEC_IKE_LOAD_FAILED", WERR_IPSEC_IKE_LOAD_FAILED },
	{ "WERR_IPSEC_IKE_RPC_DELETE", WERR_IPSEC_IKE_RPC_DELETE },
	{ "WERR_IPSEC_IKE_BENIGN_REINIT", WERR_IPSEC_IKE_BENIGN_REINIT },
	{ "WERR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY", WERR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY },
	{ "WERR_IPSEC_IKE_INVALID_CERT_KEYLEN", WERR_IPSEC_IKE_INVALID_CERT_KEYLEN },
	{ "WERR_IPSEC_IKE_MM_LIMIT", WERR_IPSEC_IKE_MM_LIMIT },
	{ "WERR_IPSEC_IKE_NEGOTIATION_DISABLED", WERR_IPSEC_IKE_NEGOTIATION_DISABLED },
	{ "WERR_IPSEC_IKE_QM_LIMIT", WERR_IPSEC_IKE_QM_LIMIT },
	{ "WERR_IPSEC_IKE_MM_EXPIRED", WERR_IPSEC_IKE_MM_EXPIRED },
	{ "WERR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID", WERR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID },
	{ "WERR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH", WERR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH },
	{ "WERR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID", WERR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID },
	{ "WERR_IPSEC_IKE_INVALID_UMATTS", WERR_IPSEC_IKE_INVALID_UMATTS },
	{ "WERR_IPSEC_IKE_DOS_COOKIE_SENT", WERR_IPSEC_IKE_DOS_COOKIE_SENT },
	{ "WERR_IPSEC_IKE_SHUTTING_DOWN", WERR_IPSEC_IKE_SHUTTING_DOWN },
	{ "WERR_IPSEC_IKE_CGA_AUTH_FAILED", WERR_IPSEC_IKE_CGA_AUTH_FAILED },
	{ "WERR_IPSEC_IKE_PROCESS_ERR_NATOA", WERR_IPSEC_IKE_PROCESS_ERR_NATOA },
	{ "WERR_IPSEC_IKE_INVALID_MM_FOR_QM", WERR_IPSEC_IKE_INVALID_MM_FOR_QM },
	{ "WERR_IPSEC_IKE_QM_EXPIRED", WERR_IPSEC_IKE_QM_EXPIRED },
	{ "WERR_IPSEC_IKE_TOO_MANY_FILTERS", WERR_IPSEC_IKE_TOO_MANY_FILTERS },
	{ "WERR_IPSEC_IKE_NEG_STATUS_END", WERR_IPSEC_IKE_NEG_STATUS_END },
	{ "WERR_SXS_SECTION_NOT_FOUND", WERR_SXS_SECTION_NOT_FOUND },
	{ "WERR_SXS_CANT_GEN_ACTCTX", WERR_SXS_CANT_GEN_ACTCTX },
	{ "WERR_SXS_INVALID_ACTCTXDATA_FORMAT", WERR_SXS_INVALID_ACTCTXDATA_FORMAT },
	{ "WERR_SXS_ASSEMBLY_NOT_FOUND", WERR_SXS_ASSEMBLY_NOT_FOUND },
	{ "WERR_SXS_MANIFEST_FORMAT_ERROR", WERR_SXS_MANIFEST_FORMAT_ERROR },
	{ "WERR_SXS_MANIFEST_PARSE_ERROR", WERR_SXS_MANIFEST_PARSE_ERROR },
	{ "WERR_SXS_ACTIVATION_CONTEXT_DISABLED", WERR_SXS_ACTIVATION_CONTEXT_DISABLED },
	{ "WERR_SXS_KEY_NOT_FOUND", WERR_SXS_KEY_NOT_FOUND },
	{ "WERR_SXS_VERSION_CONFLICT", WERR_SXS_VERSION_CONFLICT },
	{ "WERR_SXS_WRONG_SECTION_TYPE", WERR_SXS_WRONG_SECTION_TYPE },
	{ "WERR_SXS_THREAD_QUERIES_DISABLED", WERR_SXS_THREAD_QUERIES_DISABLED },
	{ "WERR_SXS_PROCESS_DEFAULT_ALREADY_SET", WERR_SXS_PROCESS_DEFAULT_ALREADY_SET },
	{ "WERR_SXS_UNKNOWN_ENCODING_GROUP", WERR_SXS_UNKNOWN_ENCODING_GROUP },
	{ "WERR_SXS_UNKNOWN_ENCODING", WERR_SXS_UNKNOWN_ENCODING },
	{ "WERR_SXS_INVALID_XML_NAMESPACE_URI", WERR_SXS_INVALID_XML_NAMESPACE_URI },
	{ "WERR_SXS_ROOT_MANIFEST_DEPENDENCY_OT_INSTALLED", WERR_SXS_ROOT_MANIFEST_DEPENDENCY_OT_INSTALLED },
	{ "WERR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED", WERR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED },
	{ "WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE", WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE },
	{ "WERR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE", WERR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE },
	{ "WERR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE", WERR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE },
	{ "WERR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT", WERR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT },
	{ "WERR_SXS_DUPLICATE_DLL_NAME", WERR_SXS_DUPLICATE_DLL_NAME },
	{ "WERR_SXS_DUPLICATE_WINDOWCLASS_NAME", WERR_SXS_DUPLICATE_WINDOWCLASS_NAME },
	{ "WERR_SXS_DUPLICATE_CLSID", WERR_SXS_DUPLICATE_CLSID },
	{ "WERR_SXS_DUPLICATE_IID", WERR_SXS_DUPLICATE_IID },
	{ "WERR_SXS_DUPLICATE_TLBID", WERR_SXS_DUPLICATE_TLBID },
	{ "WERR_SXS_DUPLICATE_PROGID", WERR_SXS_DUPLICATE_PROGID },
	{ "WERR_SXS_DUPLICATE_ASSEMBLY_NAME", WERR_SXS_DUPLICATE_ASSEMBLY_NAME },
	{ "WERR_SXS_FILE_HASH_MISMATCH", WERR_SXS_FILE_HASH_MISMATCH },
	{ "WERR_SXS_POLICY_PARSE_ERROR", WERR_SXS_POLICY_PARSE_ERROR },
	{ "WERR_SXS_XML_E_MISSINGQUOTE", WERR_SXS_XML_E_MISSINGQUOTE },
	{ "WERR_SXS_XML_E_COMMENTSYNTAX", WERR_SXS_XML_E_COMMENTSYNTAX },
	{ "WERR_SXS_XML_E_BADSTARTNAMECHAR", WERR_SXS_XML_E_BADSTARTNAMECHAR },
	{ "WERR_SXS_XML_E_BADNAMECHAR", WERR_SXS_XML_E_BADNAMECHAR },
	{ "WERR_SXS_XML_E_BADCHARINSTRING", WERR_SXS_XML_E_BADCHARINSTRING },
	{ "WERR_SXS_XML_E_XMLDECLSYNTAX", WERR_SXS_XML_E_XMLDECLSYNTAX },
	{ "WERR_SXS_XML_E_BADCHARDATA", WERR_SXS_XML_E_BADCHARDATA },
	{ "WERR_SXS_XML_E_MISSINGWHITESPACE", WERR_SXS_XML_E_MISSINGWHITESPACE },
	{ "WERR_SXS_XML_E_EXPECTINGTAGEND", WERR_SXS_XML_E_EXPECTINGTAGEND },
	{ "WERR_SXS_XML_E_MISSINGSEMICOLON", WERR_SXS_XML_E_MISSINGSEMICOLON },
	{ "WERR_SXS_XML_E_UNBALANCEDPAREN", WERR_SXS_XML_E_UNBALANCEDPAREN },
	{ "WERR_SXS_XML_E_INTERNALERROR", WERR_SXS_XML_E_INTERNALERROR },
	{ "WERR_SXS_XML_E_UNEXPECTED_WHITESPACE", WERR_SXS_XML_E_UNEXPECTED_WHITESPACE },
	{ "WERR_SXS_XML_E_INCOMPLETE_ENCODING", WERR_SXS_XML_E_INCOMPLETE_ENCODING },
	{ "WERR_SXS_XML_E_MISSING_PAREN", WERR_SXS_XML_E_MISSING_PAREN },
	{ "WERR_SXS_XML_E_EXPECTINGCLOSEQUOTE", WERR_SXS_XML_E_EXPECTINGCLOSEQUOTE },
	{ "WERR_SXS_XML_E_MULTIPLE_COLONS", WERR_SXS_XML_E_MULTIPLE_COLONS },
	{ "WERR_SXS_XML_E_INVALID_DECIMAL", WERR_SXS_XML_E_INVALID_DECIMAL },
	{ "WERR_SXS_XML_E_INVALID_HEXIDECIMAL", WERR_SXS_XML_E_INVALID_HEXIDECIMAL },
	{ "WERR_SXS_XML_E_INVALID_UNICODE", WERR_SXS_XML_E_INVALID_UNICODE },
	{ "WERR_SXS_XML_E_WHITESPACEORQUESTIONMARK", WERR_SXS_XML_E_WHITESPACEORQUESTIONMARK },
	{ "WERR_SXS_XML_E_UNEXPECTEDENDTAG", WERR_SXS_XML_E_UNEXPECTEDENDTAG },
	{ "WERR_SXS_XML_E_UNCLOSEDTAG", WERR_SXS_XML_E_UNCLOSEDTAG },
	{ "WERR_SXS_XML_E_DUPLICATEATTRIBUTE", WERR_SXS_XML_E_DUPLICATEATTRIBUTE },
	{ "WERR_SXS_XML_E_MULTIPLEROOTS", WERR_SXS_XML_E_MULTIPLEROOTS },
	{ "WERR_SXS_XML_E_INVALIDATROOTLEVEL", WERR_SXS_XML_E_INVALIDATROOTLEVEL },
	{ "WERR_SXS_XML_E_BADXMLDECL", WERR_SXS_XML_E_BADXMLDECL },
	{ "WERR_SXS_XML_E_MISSINGROOT", WERR_SXS_XML_E_MISSINGROOT },
	{ "WERR_SXS_XML_E_UNEXPECTEDEOF", WERR_SXS_XML_E_UNEXPECTEDEOF },
	{ "WERR_SXS_XML_E_BADPEREFINSUBSET", WERR_SXS_XML_E_BADPEREFINSUBSET },
	{ "WERR_SXS_XML_E_UNCLOSEDSTARTTAG", WERR_SXS_XML_E_UNCLOSEDSTARTTAG },
	{ "WERR_SXS_XML_E_UNCLOSEDENDTAG", WERR_SXS_XML_E_UNCLOSEDENDTAG },
	{ "WERR_SXS_XML_E_UNCLOSEDSTRING", WERR_SXS_XML_E_UNCLOSEDSTRING },
	{ "WERR_SXS_XML_E_UNCLOSEDCOMMENT", WERR_SXS_XML_E_UNCLOSEDCOMMENT },
	{ "WERR_SXS_XML_E_UNCLOSEDDECL", WERR_SXS_XML_E_UNCLOSEDDECL },
	{ "WERR_SXS_XML_E_UNCLOSEDCDATA", WERR_SXS_XML_E_UNCLOSEDCDATA },
	{ "WERR_SXS_XML_E_RESERVEDNAMESPACE", WERR_SXS_XML_E_RESERVEDNAMESPACE },
	{ "WERR_SXS_XML_E_INVALIDENCODING", WERR_SXS_XML_E_INVALIDENCODING },
	{ "WERR_SXS_XML_E_INVALIDSWITCH", WERR_SXS_XML_E_INVALIDSWITCH },
	{ "WERR_SXS_XML_E_BADXMLCASE", WERR_SXS_XML_E_BADXMLCASE },
	{ "WERR_SXS_XML_E_INVALID_STANDALONE", WERR_SXS_XML_E_INVALID_STANDALONE },
	{ "WERR_SXS_XML_E_UNEXPECTED_STANDALONE", WERR_SXS_XML_E_UNEXPECTED_STANDALONE },
	{ "WERR_SXS_XML_E_INVALID_VERSION", WERR_SXS_XML_E_INVALID_VERSION },
	{ "WERR_SXS_XML_E_MISSINGEQUALS", WERR_SXS_XML_E_MISSINGEQUALS },
	{ "WERR_SXS_PROTECTION_RECOVERY_FAILED", WERR_SXS_PROTECTION_RECOVERY_FAILED },
	{ "WERR_SXS_PROTECTION_PUBLIC_KEY_OO_SHORT", WERR_SXS_PROTECTION_PUBLIC_KEY_OO_SHORT },
	{ "WERR_SXS_PROTECTION_CATALOG_NOT_VALID", WERR_SXS_PROTECTION_CATALOG_NOT_VALID },
	{ "WERR_SXS_UNTRANSLATABLE_HRESULT", WERR_SXS_UNTRANSLATABLE_HRESULT },
	{ "WERR_SXS_PROTECTION_CATALOG_FILE_MISSING", WERR_SXS_PROTECTION_CATALOG_FILE_MISSING },
	{ "WERR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE", WERR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE },
	{ "WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME", WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME },
	{ "WERR_SXS_ASSEMBLY_MISSING", WERR_SXS_ASSEMBLY_MISSING },
	{ "WERR_SXS_CORRUPT_ACTIVATION_STACK", WERR_SXS_CORRUPT_ACTIVATION_STACK },
	{ "WERR_SXS_CORRUPTION", WERR_SXS_CORRUPTION },
	{ "WERR_SXS_EARLY_DEACTIVATION", WERR_SXS_EARLY_DEACTIVATION },
	{ "WERR_SXS_INVALID_DEACTIVATION", WERR_SXS_INVALID_DEACTIVATION },
	{ "WERR_SXS_MULTIPLE_DEACTIVATION", WERR_SXS_MULTIPLE_DEACTIVATION },
	{ "WERR_SXS_PROCESS_TERMINATION_REQUESTED", WERR_SXS_PROCESS_TERMINATION_REQUESTED },
	{ "WERR_SXS_RELEASE_ACTIVATION_ONTEXT", WERR_SXS_RELEASE_ACTIVATION_ONTEXT },
	{ "WERR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY", WERR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY },
	{ "WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE", WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE },
	{ "WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME", WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME },
	{ "WERR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE", WERR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE },
	{ "WERR_SXS_IDENTITY_PARSE_ERROR", WERR_SXS_IDENTITY_PARSE_ERROR },
	{ "WERR_MALFORMED_SUBSTITUTION_STRING", WERR_MALFORMED_SUBSTITUTION_STRING },
	{ "WERR_SXS_INCORRECT_PUBLIC_KEY_OKEN", WERR_SXS_INCORRECT_PUBLIC_KEY_OKEN },
	{ "WERR_UNMAPPED_SUBSTITUTION_STRING", WERR_UNMAPPED_SUBSTITUTION_STRING },
	{ "WERR_SXS_ASSEMBLY_NOT_LOCKED", WERR_SXS_ASSEMBLY_NOT_LOCKED },
	{ "WERR_SXS_COMPONENT_STORE_CORRUPT", WERR_SXS_COMPONENT_STORE_CORRUPT },
	{ "WERR_ADVANCED_INSTALLER_FAILED", WERR_ADVANCED_INSTALLER_FAILED },
	{ "WERR_XML_ENCODING_MISMATCH", WERR_XML_ENCODING_MISMATCH },
	{ "WERR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT", WERR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT },
	{ "WERR_SXS_IDENTITIES_DIFFERENT", WERR_SXS_IDENTITIES_DIFFERENT },
	{ "WERR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT", WERR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT },
	{ "WERR_SXS_FILE_NOT_PART_OF_ASSEMBLY", WERR_SXS_FILE_NOT_PART_OF_ASSEMBLY },
	{ "WERR_SXS_MANIFEST_TOO_BIG", WERR_SXS_MANIFEST_TOO_BIG },
	{ "WERR_SXS_SETTING_NOT_REGISTERED", WERR_SXS_SETTING_NOT_REGISTERED },
	{ "WERR_SXS_TRANSACTION_CLOSURE_INCOMPLETE", WERR_SXS_TRANSACTION_CLOSURE_INCOMPLETE },
	{ "WERR_EVT_INVALID_CHANNEL_PATH", WERR_EVT_INVALID_CHANNEL_PATH },
	{ "WERR_EVT_INVALID_QUERY", WERR_EVT_INVALID_QUERY },
	{ "WERR_EVT_PUBLISHER_METADATA_NOT_FOUND", WERR_EVT_PUBLISHER_METADATA_NOT_FOUND },
	{ "WERR_EVT_EVENT_TEMPLATE_NOT_FOUND", WERR_EVT_EVENT_TEMPLATE_NOT_FOUND },
	{ "WERR_EVT_INVALID_PUBLISHER_NAME", WERR_EVT_INVALID_PUBLISHER_NAME },
	{ "WERR_EVT_INVALID_EVENT_DATA", WERR_EVT_INVALID_EVENT_DATA },
	{ "WERR_EVT_CHANNEL_NOT_FOUND", WERR_EVT_CHANNEL_NOT_FOUND },
	{ "WERR_EVT_MALFORMED_XML_TEXT", WERR_EVT_MALFORMED_XML_TEXT },
	{ "WERR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL", WERR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL },
	{ "WERR_EVT_CONFIGURATION_ERROR", WERR_EVT_CONFIGURATION_ERROR },
	{ "WERR_EVT_QUERY_RESULT_STALE", WERR_EVT_QUERY_RESULT_STALE },
	{ "WERR_EVT_QUERY_RESULT_INVALID_POSITION", WERR_EVT_QUERY_RESULT_INVALID_POSITION },
	{ "WERR_EVT_NON_VALIDATING_MSXML", WERR_EVT_NON_VALIDATING_MSXML },
	{ "WERR_EVT_FILTER_ALREADYSCOPED", WERR_EVT_FILTER_ALREADYSCOPED },
	{ "WERR_EVT_FILTER_NOTELTSET", WERR_EVT_FILTER_NOTELTSET },
	{ "WERR_EVT_FILTER_INVARG", WERR_EVT_FILTER_INVARG },
	{ "WERR_EVT_FILTER_INVTEST", WERR_EVT_FILTER_INVTEST },
	{ "WERR_EVT_FILTER_INVTYPE", WERR_EVT_FILTER_INVTYPE },
	{ "WERR_EVT_FILTER_PARSEERR", WERR_EVT_FILTER_PARSEERR },
	{ "WERR_EVT_FILTER_UNSUPPORTEDOP", WERR_EVT_FILTER_UNSUPPORTEDOP },
	{ "WERR_EVT_FILTER_UNEXPECTEDTOKEN", WERR_EVT_FILTER_UNEXPECTEDTOKEN },
	{ "WERR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL", WERR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL },
	{ "WERR_EVT_INVALID_CHANNEL_PROPERTY_VALUE", WERR_EVT_INVALID_CHANNEL_PROPERTY_VALUE },
	{ "WERR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE", WERR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE },
	{ "WERR_EVT_CHANNEL_CANNOT_ACTIVATE", WERR_EVT_CHANNEL_CANNOT_ACTIVATE },
	{ "WERR_EVT_FILTER_TOO_COMPLEX", WERR_EVT_FILTER_TOO_COMPLEX },
	{ "WERR_EVT_MESSAGE_NOT_FOUND", WERR_EVT_MESSAGE_NOT_FOUND },
	{ "WERR_EVT_MESSAGE_ID_NOT_FOUND", WERR_EVT_MESSAGE_ID_NOT_FOUND },
	{ "WERR_EVT_UNRESOLVED_VALUE_INSERT", WERR_EVT_UNRESOLVED_VALUE_INSERT },
	{ "WERR_EVT_UNRESOLVED_PARAMETER_INSERT", WERR_EVT_UNRESOLVED_PARAMETER_INSERT },
	{ "WERR_EVT_MAX_INSERTS_REACHED", WERR_EVT_MAX_INSERTS_REACHED },
	{ "WERR_EVT_EVENT_DEFINITION_NOT_OUND", WERR_EVT_EVENT_DEFINITION_NOT_OUND },
	{ "WERR_EVT_MESSAGE_LOCALE_NOT_FOUND", WERR_EVT_MESSAGE_LOCALE_NOT_FOUND },
	{ "WERR_EVT_VERSION_TOO_OLD", WERR_EVT_VERSION_TOO_OLD },
	{ "WERR_EVT_VERSION_TOO_NEW", WERR_EVT_VERSION_TOO_NEW },
	{ "WERR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY", WERR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY },
	{ "WERR_EVT_PUBLISHER_DISABLED", WERR_EVT_PUBLISHER_DISABLED },
	{ "WERR_EC_SUBSCRIPTION_CANNOT_ACTIVATE", WERR_EC_SUBSCRIPTION_CANNOT_ACTIVATE },
	{ "WERR_EC_LOG_DISABLED", WERR_EC_LOG_DISABLED },
	{ "WERR_MUI_FILE_NOT_FOUND", WERR_MUI_FILE_NOT_FOUND },
	{ "WERR_MUI_INVALID_FILE", WERR_MUI_INVALID_FILE },
	{ "WERR_MUI_INVALID_RC_CONFIG", WERR_MUI_INVALID_RC_CONFIG },
	{ "WERR_MUI_INVALID_LOCALE_NAME", WERR_MUI_INVALID_LOCALE_NAME },
	{ "WERR_MUI_INVALID_ULTIMATEFALLBACK_NAME", WERR_MUI_INVALID_ULTIMATEFALLBACK_NAME },
	{ "WERR_MUI_FILE_NOT_LOADED", WERR_MUI_FILE_NOT_LOADED },
	{ "WERR_RESOURCE_ENUM_USER_STOP", WERR_RESOURCE_ENUM_USER_STOP },
	{ "WERR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED", WERR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED },
	{ "WERR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME", WERR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME },
	{ "WERR_MCA_INVALID_CAPABILITIES_STRING", WERR_MCA_INVALID_CAPABILITIES_STRING },
	{ "WERR_MCA_INVALID_VCP_VERSION", WERR_MCA_INVALID_VCP_VERSION },
	{ "WERR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION", WERR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION },
	{ "WERR_MCA_MCCS_VERSION_MISMATCH", WERR_MCA_MCCS_VERSION_MISMATCH },
	{ "WERR_MCA_UNSUPPORTED_MCCS_VERSION", WERR_MCA_UNSUPPORTED_MCCS_VERSION },
	{ "WERR_MCA_INTERNAL_ERROR", WERR_MCA_INTERNAL_ERROR },
	{ "WERR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED", WERR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED },
	{ "WERR_MCA_UNSUPPORTED_COLOR_TEMPERATURE", WERR_MCA_UNSUPPORTED_COLOR_TEMPERATURE },
	{ "WERR_AMBIGUOUS_SYSTEM_DEVICE", WERR_AMBIGUOUS_SYSTEM_DEVICE },
	{ "WERR_SYSTEM_DEVICE_NOT_FOUND", WERR_SYSTEM_DEVICE_NOT_FOUND },
	/* END GENERATED-WIN32-ERROR-CODES */
	{ NULL, W_ERROR(0) }
};




/* DFS errors */

/*****************************************************************************
 returns a windows error message.  not amazingly helpful, but better than a number.
 *****************************************************************************/
const char *win_errstr(WERROR werror)
{
        static char msg[40];
        int idx = 0;

	while (dos_errs[idx].dos_errstr != NULL) {
		if (W_ERROR_V(dos_errs[idx].werror) == 
                    W_ERROR_V(werror))
                        return dos_errs[idx].dos_errstr;
		idx++;
	}

	slprintf(msg, sizeof(msg), "DOS code 0x%08x", W_ERROR_V(werror));

        return msg;
}

struct werror_str_struct {
	WERROR werror;
	const char *friendly_errstr;
};

const struct werror_str_struct dos_err_strs[] = {
	{ WERR_OK, "Success" },
	{ WERR_ACCESS_DENIED, "Access is denied" },
	{ WERR_INVALID_PARAM, "Invalid parameter" },
	{ WERR_NOT_SUPPORTED, "Not supported" },
	{ WERR_BAD_PASSWORD, "A bad password was supplied" },
	{ WERR_NOMEM, "Out of memory" },
	{ WERR_NO_LOGON_SERVERS, "No logon servers found" },
	{ WERR_NO_SUCH_LOGON_SESSION, "No such logon session" },
	{ WERR_DOMAIN_CONTROLLER_NOT_FOUND, "A domain controller could not be found" },
	{ WERR_DCNOTFOUND, "A domain controller could not be found" },
	{ WERR_SETUP_NOT_JOINED, "Join failed" },
	{ WERR_SETUP_ALREADY_JOINED, "Machine is already joined" },
	{ WERR_SETUP_DOMAIN_CONTROLLER, "Machine is a Domain Controller" },
	{ WERR_LOGON_FAILURE, "Invalid logon credentials" },
	{ WERR_USEREXISTS, "The user account already exists." },
	{ WERR_PASSWORD_MUST_CHANGE, "The password must be changed" },
	{ WERR_ACCOUNT_LOCKED_OUT, "Account locked out" },
	{ WERR_TIME_SKEW, "Time difference between client and server" },
	{ WERR_USER_ALREADY_EXISTS, "User already exists" },
	{ WERR_PASSWORD_RESTRICTION, "Password does not meet restrictions" },
	{ WERR_NONE_MAPPED, "Could not map names to SIDs" },
	{ WERR_NO_SUCH_USER, "No such User" },
	{ WERR_GROUP_EXISTS, "Group already exists" },
	{ WERR_NO_SUCH_GROUP, "No such Group" },
	{ WERR_INVALID_PRIMARY_GROUP, "The account's primary group is invalid" },
	{ WERR_DS_DRA_BAD_DN, "An invalid distinguished name was specified for this replication" },
	{ WERR_DS_DRA_BAD_NC, "An invalid naming context was specified for this replication operation" },
	{ WERR_WRONG_PASSWORD, "The current password is incorrect" },
	/*****************************************************************************
	 Auto-generated Win32 error from:
	 http://msdn.microsoft.com/en-us/library/cc231199%28PROT.10%29.aspx
	 *****************************************************************************/
	/* BEGIN GENERATED-WIN32-ERROR-CODES-DESC */
	{ WERR_NERR_SUCCESS, "The operation completed successfully." },
	{ WERR_INVALID_FUNCTION, "Incorrect function." },
	{ WERR_FILE_NOT_FOUND, "The system cannot find the file specified." },
	{ WERR_PATH_NOT_FOUND, "The system cannot find the path specified." },
	{ WERR_TOO_MANY_OPEN_FILES, "The system cannot open the file." },
	{ WERR_ACCESS_DENIED, "Access is denied." },
	{ WERR_INVALID_HANDLE, "The handle is invalid." },
	{ WERR_ARENA_TRASHED, "The storage control blocks were destroyed." },
	{ WERR_NOT_ENOUGH_MEMORY, "Not enough storage is available to process this command." },
	{ WERR_INVALID_BLOCK, "The storage control block address is invalid." },
	{ WERR_BAD_ENVIRONMENT, "The environment is incorrect." },
	{ WERR_BAD_FORMAT, "An attempt was made to load a program with an incorrect format." },
	{ WERR_INVALID_ACCESS, "The access code is invalid." },
	{ WERR_INVALID_DATA, "The data is invalid." },
	{ WERR_OUTOFMEMORY, "Not enough storage is available to complete this operation." },
	{ WERR_INVALID_DRIVE, "The system cannot find the drive specified." },
	{ WERR_CURRENT_DIRECTORY, "The directory cannot be removed." },
	{ WERR_NOT_SAME_DEVICE, "The system cannot move the file to a different disk drive." },
	{ WERR_NO_MORE_FILES, "There are no more files." },
	{ WERR_WRITE_PROTECT, "The media is write-protected." },
	{ WERR_BAD_UNIT, "The system cannot find the device specified." },
	{ WERR_NOT_READY, "The device is not ready." },
	{ WERR_BAD_COMMAND, "The device does not recognize the command." },
	{ WERR_CRC, "Data error (cyclic redundancy check)." },
	{ WERR_BAD_LENGTH, "The program issued a command but the command length is incorrect." },
	{ WERR_SEEK, "The drive cannot locate a specific area or track on the disk." },
	{ WERR_NOT_DOS_DISK, "The specified disk cannot be accessed." },
	{ WERR_SECTOR_NOT_FOUND, "The drive cannot find the sector requested." },
	{ WERR_OUT_OF_PAPER, "The printer is out of paper." },
	{ WERR_WRITE_FAULT, "The system cannot write to the specified device." },
	{ WERR_READ_FAULT, "The system cannot read from the specified device." },
	{ WERR_GEN_FAILURE, "A device attached to the system is not functioning." },
	{ WERR_SHARING_VIOLATION, "The process cannot access the file because it is being used by another process." },
	{ WERR_LOCK_VIOLATION, "The process cannot access the file because another process has locked a portion of the file." },
	{ WERR_WRONG_DISK, "The wrong disk is in the drive. Insert %2 (Volume Serial Number: %3) into drive %1." },
	{ WERR_SHARING_BUFFER_EXCEEDED, "Too many files opened for sharing." },
	{ WERR_HANDLE_EOF, "Reached the end of the file." },
	{ WERR_HANDLE_DISK_FULL, "The disk is full." },
	{ WERR_NOT_SUPPORTED, "The request is not supported." },
	{ WERR_REM_NOT_LIST, "Windows cannot find the network path. Verify that the network path is correct and the destination computer is not busy or turned off. If Windows still cannot find the network path, contact your network administrator." },
	{ WERR_DUP_NAME, "You were not connected because a duplicate name exists on the network. Go to System in Control Panel to change the computer name, and then try again." },
	{ WERR_BAD_NETPATH, "The network path was not found." },
	{ WERR_NETWORK_BUSY, "The network is busy." },
	{ WERR_DEV_NOT_EXIST, "The specified network resource or device is no longer available." },
	{ WERR_TOO_MANY_CMDS, "The network BIOS command limit has been reached." },
	{ WERR_ADAP_HDW_ERR, "A network adapter hardware error occurred." },
	{ WERR_BAD_NET_RESP, "The specified server cannot perform the requested operation." },
	{ WERR_UNEXP_NET_ERR, "An unexpected network error occurred." },
	{ WERR_BAD_REM_ADAP, "The remote adapter is not compatible." },
	{ WERR_PRINTQ_FULL, "The print queue is full." },
	{ WERR_NO_SPOOL_SPACE, "Space to store the file waiting to be printed is not available on the server." },
	{ WERR_PRINT_CANCELLED, "Your file waiting to be printed was deleted." },
	{ WERR_NETNAME_DELETED, "The specified network name is no longer available." },
	{ WERR_NETWORK_ACCESS_DENIED, "Network access is denied." },
	{ WERR_BAD_DEV_TYPE, "The network resource type is not correct." },
	{ WERR_BAD_NET_NAME, "The network name cannot be found." },
	{ WERR_TOO_MANY_NAMES, "The name limit for the local computer network adapter card was exceeded." },
	{ WERR_TOO_MANY_SESS, "The network BIOS session limit was exceeded." },
	{ WERR_SHARING_PAUSED, "The remote server has been paused or is in the process of being started." },
	{ WERR_REQ_NOT_ACCEP, "No more connections can be made to this remote computer at this time because the computer has accepted the maximum number of connections." },
	{ WERR_REDIR_PAUSED, "The specified printer or disk device has been paused." },
	{ WERR_FILE_EXISTS, "The file exists." },
	{ WERR_CANNOT_MAKE, "The directory or file cannot be created." },
	{ WERR_FAIL_I24, "Fail on INT 24." },
	{ WERR_OUT_OF_STRUCTURES, "Storage to process this request is not available." },
	{ WERR_ALREADY_ASSIGNED, "The local device name is already in use." },
	{ WERR_INVALID_PASSWORD, "The specified network password is not correct." },
	{ WERR_INVALID_PARAMETER, "The parameter is incorrect." },
	{ WERR_NET_WRITE_FAULT, "A write fault occurred on the network." },
	{ WERR_NO_PROC_SLOTS, "The system cannot start another process at this time." },
	{ WERR_TOO_MANY_SEMAPHORES, "Cannot create another system semaphore." },
	{ WERR_EXCL_SEM_ALREADY_OWNED, "The exclusive semaphore is owned by another process." },
	{ WERR_SEM_IS_SET, "The semaphore is set and cannot be closed." },
	{ WERR_TOO_MANY_SEM_REQUESTS, "The semaphore cannot be set again." },
	{ WERR_INVALID_AT_INTERRUPT_TIME, "Cannot request exclusive semaphores at interrupt time." },
	{ WERR_SEM_OWNER_DIED, "The previous ownership of this semaphore has ended." },
	{ WERR_SEM_USER_LIMIT, "Insert the disk for drive %1." },
	{ WERR_DISK_CHANGE, "The program stopped because an alternate disk was not inserted." },
	{ WERR_DRIVE_LOCKED, "The disk is in use or locked by another process." },
	{ WERR_BROKEN_PIPE, "The pipe has been ended." },
	{ WERR_OPEN_FAILED, "The system cannot open the device or file specified." },
	{ WERR_BUFFER_OVERFLOW, "The file name is too long." },
	{ WERR_DISK_FULL, "There is not enough space on the disk." },
	{ WERR_NO_MORE_SEARCH_HANDLES, "No more internal file identifiers are available." },
	{ WERR_INVALID_TARGET_HANDLE, "The target internal file identifier is incorrect." },
	{ WERR_INVALID_CATEGORY, "The Input Output Control (IOCTL) call made by the application program is not correct." },
	{ WERR_INVALID_VERIFY_SWITCH, "The verify-on-write switch parameter value is not correct." },
	{ WERR_BAD_DRIVER_LEVEL, "The system does not support the command requested." },
	{ WERR_CALL_NOT_IMPLEMENTED, "This function is not supported on this system." },
	{ WERR_SEM_TIMEOUT, "The semaphore time-out period has expired." },
	{ WERR_INSUFFICIENT_BUFFER, "The data area passed to a system call is too small." },
	{ WERR_INVALID_NAME, "The file name, directory name, or volume label syntax is incorrect." },
	{ WERR_INVALID_LEVEL, "The system call level is not correct." },
	{ WERR_NO_VOLUME_LABEL, "The disk has no volume label." },
	{ WERR_MOD_NOT_FOUND, "The specified module could not be found." },
	{ WERR_PROC_NOT_FOUND, "The specified procedure could not be found." },
	{ WERR_WAIT_NO_CHILDREN, "There are no child processes to wait for." },
	{ WERR_CHILD_NOT_COMPLETE, "The %1 application cannot be run in Win32 mode." },
	{ WERR_DIRECT_ACCESS_HANDLE, "Attempt to use a file handle to an open disk partition for an operation other than raw disk I/O." },
	{ WERR_NEGATIVE_SEEK, "An attempt was made to move the file pointer before the beginning of the file." },
	{ WERR_SEEK_ON_DEVICE, "The file pointer cannot be set on the specified device or file." },
	{ WERR_NOT_SUBSTED, "The system tried to delete the substitution of a drive that is not substituted." },
	{ WERR_JOIN_TO_JOIN, "The system tried to join a drive to a directory on a joined drive." },
	{ WERR_SUBST_TO_SUBST, "The system tried to substitute a drive to a directory on a substituted drive." },
	{ WERR_JOIN_TO_SUBST, "The system tried to join a drive to a directory on a substituted drive." },
	{ WERR_SAME_DRIVE, "The system cannot join or substitute a drive to or for a directory on the same drive." },
	{ WERR_DIR_NOT_ROOT, "The directory is not a subdirectory of the root directory." },
	{ WERR_DIR_NOT_EMPTY, "The directory is not empty." },
	{ WERR_IS_SUBST_PATH, "The path specified is being used in a substitute." },
	{ WERR_IS_JOIN_PATH, "Not enough resources are available to process this command." },
	{ WERR_PATH_BUSY, "The path specified cannot be used at this time." },
	{ WERR_IS_SUBST_TARGET, "An attempt was made to join or substitute a drive for which a directory on the drive is the target of a previous substitute." },
	{ WERR_SYSTEM_TRACE, "System trace information was not specified in your CONFIG.SYS file, or tracing is disallowed." },
	{ WERR_INVALID_EVENT_COUNT, "The number of specified semaphore events for DosMuxSemWait is not correct." },
	{ WERR_TOO_MANY_MUXWAITERS, "DosMuxSemWait did not execute; too many semaphores are already set." },
	{ WERR_INVALID_LIST_FORMAT, "The DosMuxSemWait list is not correct." },
	{ WERR_LABEL_TOO_LONG, "The volume label you entered exceeds the label character limit of the destination file system." },
	{ WERR_TOO_MANY_TCBS, "Cannot create another thread." },
	{ WERR_SIGNAL_REFUSED, "The recipient process has refused the signal." },
	{ WERR_DISCARDED, "The segment is already discarded and cannot be locked." },
	{ WERR_NOT_LOCKED, "The segment is already unlocked." },
	{ WERR_BAD_THREADID_ADDR, "The address for the thread ID is not correct." },
	{ WERR_BAD_ARGUMENTS, "One or more arguments are not correct." },
	{ WERR_BAD_PATHNAME, "The specified path is invalid." },
	{ WERR_SIGNAL_PENDING, "A signal is already pending." },
	{ WERR_MAX_THRDS_REACHED, "No more threads can be created in the system." },
	{ WERR_LOCK_FAILED, "Unable to lock a region of a file." },
	{ WERR_BUSY, "The requested resource is in use." },
	{ WERR_CANCEL_VIOLATION, "A lock request was not outstanding for the supplied cancel region." },
	{ WERR_ATOMIC_LOCKS_NOT_SUPPORTED, "The file system does not support atomic changes to the lock type." },
	{ WERR_INVALID_SEGMENT_NUMBER, "The system detected a segment number that was not correct." },
	{ WERR_INVALID_ORDINAL, "The operating system cannot run %1." },
	{ WERR_ALREADY_EXISTS, "Cannot create a file when that file already exists." },
	{ WERR_INVALID_FLAG_NUMBER, "The flag passed is not correct." },
	{ WERR_SEM_NOT_FOUND, "The specified system semaphore name was not found." },
	{ WERR_INVALID_STARTING_CODESEG, "The operating system cannot run %1." },
	{ WERR_INVALID_STACKSEG, "The operating system cannot run %1." },
	{ WERR_INVALID_MODULETYPE, "The operating system cannot run %1." },
	{ WERR_INVALID_EXE_SIGNATURE, "Cannot run %1 in Win32 mode." },
	{ WERR_EXE_MARKED_INVALID, "The operating system cannot run %1." },
	{ WERR_BAD_EXE_FORMAT, "%1 is not a valid Win32 application." },
	{ WERR_ITERATED_DATA_EXCEEDS_64K, "The operating system cannot run %1." },
	{ WERR_INVALID_MINALLOCSIZE, "The operating system cannot run %1." },
	{ WERR_DYNLINK_FROM_INVALID_RING, "The operating system cannot run this application program." },
	{ WERR_IOPL_NOT_ENABLED, "The operating system is not presently configured to run this application." },
	{ WERR_INVALID_SEGDPL, "The operating system cannot run %1." },
	{ WERR_AUTODATASEG_EXCEEDS_64K, "The operating system cannot run this application program." },
	{ WERR_RING2SEG_MUST_BE_MOVABLE, "The code segment cannot be greater than or equal to 64 KB." },
	{ WERR_RELOC_CHAIN_XEEDS_SEGLIM, "The operating system cannot run %1." },
	{ WERR_INFLOOP_IN_RELOC_CHAIN, "The operating system cannot run %1." },
	{ WERR_ENVVAR_NOT_FOUND, "The system could not find the environment option that was entered." },
	{ WERR_NO_SIGNAL_SENT, "No process in the command subtree has a signal handler." },
	{ WERR_FILENAME_EXCED_RANGE, "The file name or extension is too long." },
	{ WERR_RING2_STACK_IN_USE, "The ring 2 stack is in use." },
	{ WERR_META_EXPANSION_TOO_LONG, "The asterisk (*) or question mark (?) global file name characters are entered incorrectly, or too many global file name characters are specified." },
	{ WERR_INVALID_SIGNAL_NUMBER, "The signal being posted is not correct." },
	{ WERR_THREAD_1_INACTIVE, "The signal handler cannot be set." },
	{ WERR_LOCKED, "The segment is locked and cannot be reallocated." },
	{ WERR_TOO_MANY_MODULES, "Too many dynamic-link modules are attached to this program or dynamic-link module." },
	{ WERR_NESTING_NOT_ALLOWED, "Cannot nest calls to LoadModule." },
	{ WERR_EXE_MACHINE_TYPE_MISMATCH, "This version of %1 is not compatible with the version of Windows you\'re running. Check your computer\'s system information to see whether you need an x86 (32-bit) or x64 (64-bit) version of the program, and then contact the software publisher." },
	{ WERR_EXE_CANNOT_MODIFY_SIGNED_BINARY, "The image file %1 is signed, unable to modify." },
	{ WERR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY, "The image file %1 is strong signed, unable to modify." },
	{ WERR_FILE_CHECKED_OUT, "This file is checked out or locked for editing by another user." },
	{ WERR_CHECKOUT_REQUIRED, "The file must be checked out before saving changes." },
	{ WERR_BAD_FILE_TYPE, "The file type being saved or retrieved has been blocked." },
	{ WERR_FILE_TOO_LARGE, "The file size exceeds the limit allowed and cannot be saved." },
	{ WERR_FORMS_AUTH_REQUIRED, "Access denied. Before opening files in this location, you must first browse to the Web site and select the option to sign in automatically." },
	{ WERR_VIRUS_INFECTED, "Operation did not complete successfully because the file contains a virus." },
	{ WERR_VIRUS_DELETED, "This file contains a virus and cannot be opened. Due to the nature of this virus, the file has been removed from this location." },
	{ WERR_PIPE_LOCAL, "The pipe is local." },
	{ WERR_BAD_PIPE, "The pipe state is invalid." },
	{ WERR_PIPE_BUSY, "All pipe instances are busy." },
	{ WERR_NO_DATA, "The pipe is being closed." },
	{ WERR_PIPE_NOT_CONNECTED, "No process is on the other end of the pipe." },
	{ WERR_MORE_DATA, "More data is available." },
	{ WERR_VC_DISCONNECTED, "The session was canceled." },
	{ WERR_INVALID_EA_NAME, "The specified extended attribute name was invalid." },
	{ WERR_EA_LIST_INCONSISTENT, "The extended attributes are inconsistent." },
	{ WERR_WAIT_TIMEOUT, "The wait operation timed out." },
	{ WERR_NO_MORE_ITEMS, "No more data is available." },
	{ WERR_CANNOT_COPY, "The copy functions cannot be used." },
	{ WERR_DIRECTORY, "The directory name is invalid." },
	{ WERR_EAS_DIDNT_FIT, "The extended attributes did not fit in the buffer." },
	{ WERR_EA_FILE_CORRUPT, "The extended attribute file on the mounted file system is corrupt." },
	{ WERR_EA_TABLE_FULL, "The extended attribute table file is full." },
	{ WERR_INVALID_EA_HANDLE, "The specified extended attribute handle is invalid." },
	{ WERR_EAS_NOT_SUPPORTED, "The mounted file system does not support extended attributes." },
	{ WERR_NOT_OWNER, "Attempt to release mutex not owned by caller." },
	{ WERR_TOO_MANY_POSTS, "Too many posts were made to a semaphore." },
	{ WERR_PARTIAL_COPY, "Only part of a ReadProcessMemory or WriteProcessMemory request was completed." },
	{ WERR_OPLOCK_NOT_GRANTED, "The oplock request is denied." },
	{ WERR_INVALID_OPLOCK_PROTOCOL, "An invalid oplock acknowledgment was received by the system." },
	{ WERR_DISK_TOO_FRAGMENTED, "The volume is too fragmented to complete this operation." },
	{ WERR_DELETE_PENDING, "The file cannot be opened because it is in the process of being deleted." },
	{ WERR_MR_MID_NOT_FOUND, "The system cannot find message text for message number 0x%1 in the message file for %2." },
	{ WERR_SCOPE_NOT_FOUND, "The scope specified was not found." },
	{ WERR_FAIL_NOACTION_REBOOT, "No action was taken because a system reboot is required." },
	{ WERR_FAIL_SHUTDOWN, "The shutdown operation failed." },
	{ WERR_FAIL_RESTART, "The restart operation failed." },
	{ WERR_MAX_SESSIONS_REACHED, "The maximum number of sessions has been reached." },
	{ WERR_THREAD_MODE_ALREADY_BACKGROUND, "The thread is already in background processing mode." },
	{ WERR_THREAD_MODE_NOT_BACKGROUND, "The thread is not in background processing mode." },
	{ WERR_PROCESS_MODE_ALREADY_BACKGROUND, "The process is already in background processing mode." },
	{ WERR_PROCESS_MODE_NOT_BACKGROUND, "The process is not in background processing mode." },
	{ WERR_INVALID_ADDRESS, "Attempt to access invalid address." },
	{ WERR_USER_PROFILE_LOAD, "User profile cannot be loaded." },
	{ WERR_ARITHMETIC_OVERFLOW, "Arithmetic result exceeded 32 bits." },
	{ WERR_PIPE_CONNECTED, "There is a process on the other end of the pipe." },
	{ WERR_PIPE_LISTENING, "Waiting for a process to open the other end of the pipe." },
	{ WERR_VERIFIER_STOP, "Application verifier has found an error in the current process." },
	{ WERR_ABIOS_ERROR, "An error occurred in the ABIOS subsystem." },
	{ WERR_WX86_WARNING, "A warning occurred in the WX86 subsystem." },
	{ WERR_WX86_ERROR, "An error occurred in the WX86 subsystem." },
	{ WERR_TIMER_NOT_CANCELED, "An attempt was made to cancel or set a timer that has an associated asynchronous procedure call (APC) and the subject thread is not the thread that originally set the timer with an associated APC routine." },
	{ WERR_UNWIND, "Unwind exception code." },
	{ WERR_BAD_STACK, "An invalid or unaligned stack was encountered during an unwind operation." },
	{ WERR_INVALID_UNWIND_TARGET, "An invalid unwind target was encountered during an unwind operation." },
	{ WERR_INVALID_PORT_ATTRIBUTES, "Invalid object attributes specified to NtCreatePort or invalid port attributes specified to NtConnectPort." },
	{ WERR_PORT_MESSAGE_TOO_LONG, "Length of message passed to NtRequestPort or NtRequestWaitReplyPort was longer than the maximum message allowed by the port." },
	{ WERR_INVALID_QUOTA_LOWER, "An attempt was made to lower a quota limit below the current usage." },
	{ WERR_DEVICE_ALREADY_ATTACHED, "An attempt was made to attach to a device that was already attached to another device." },
	{ WERR_INSTRUCTION_MISALIGNMENT, "An attempt was made to execute an instruction at an unaligned address, and the host system does not support unaligned instruction references." },
	{ WERR_PROFILING_NOT_STARTED, "Profiling not started." },
	{ WERR_PROFILING_NOT_STOPPED, "Profiling not stopped." },
	{ WERR_COULD_NOT_INTERPRET, "The passed ACL did not contain the minimum required information." },
	{ WERR_PROFILING_AT_LIMIT, "The number of active profiling objects is at the maximum and no more may be started." },
	{ WERR_CANT_WAIT, "Used to indicate that an operation cannot continue without blocking for I/O." },
	{ WERR_CANT_TERMINATE_SELF, "Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process." },
	{ WERR_UNEXPECTED_MM_CREATE_ERR, "If an MM error is returned that is not defined in the standard FsRtl filter, it is converted to one of the following errors that is guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception." },
	{ WERR_UNEXPECTED_MM_MAP_ERROR, "If an MM error is returned that is not defined in the standard FsRtl filter, it is converted to one of the following errors that is guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception." },
	{ WERR_UNEXPECTED_MM_EXTEND_ERR, "If an MM error is returned that is not defined in the standard FsRtl filter, it is converted to one of the following errors that is guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception." },
	{ WERR_BAD_FUNCTION_TABLE, "A malformed function table was encountered during an unwind operation." },
	{ WERR_NO_GUID_TRANSLATION, "Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail." },
	{ WERR_INVALID_LDT_SIZE, "Indicates that an attempt was made to grow a local domain table (LDT) by setting its size, or that the size was not an even number of selectors." },
	{ WERR_INVALID_LDT_OFFSET, "Indicates that the starting value for the LDT information was not an integral multiple of the selector size." },
	{ WERR_INVALID_LDT_DESCRIPTOR, "Indicates that the user supplied an invalid descriptor when trying to set up LDT descriptors." },
	{ WERR_TOO_MANY_THREADS, "Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads." },
	{ WERR_THREAD_NOT_IN_PROCESS, "An attempt was made to operate on a thread within a specific process, but the thread specified is not in the process specified." },
	{ WERR_PAGEFILE_QUOTA_EXCEEDED, "Page file quota was exceeded." },
	{ WERR_LOGON_SERVER_CONFLICT, "The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role." },
	{ WERR_SYNCHRONIZATION_REQUIRED, "The Security Accounts Manager (SAM) database on a Windows Server is significantly out of synchronization with the copy on the domain controller. A complete synchronization is required." },
	{ WERR_NET_OPEN_FAILED, "The NtCreateFile API failed. This error should never be returned to an application, it is a place holder for the Windows LAN Manager Redirector to use in its internal error mapping routines." },
	{ WERR_IO_PRIVILEGE_FAILED, "{Privilege Failed} The I/O permissions for the process could not be changed." },
	{ WERR_CONTROL_C_EXIT, "{Application Exit by CTRL+C} The application terminated as a result of a CTRL+C." },
	{ WERR_MISSING_SYSTEMFILE, "{Missing System File} The required system file %hs is bad or missing." },
	{ WERR_UNHANDLED_EXCEPTION, "{Application Error} The exception %s (0x%08lx) occurred in the application at location 0x%08lx." },
	{ WERR_APP_INIT_FAILURE, "{Application Error} The application failed to initialize properly (0x%lx). Click OK to terminate the application." },
	{ WERR_PAGEFILE_CREATE_FAILED, "{Unable to Create Paging File} The creation of the paging file %hs failed (%lx). The requested size was %ld." },
	{ WERR_INVALID_IMAGE_HASH, "The hash for the image cannot be found in the system catalogs. The image is likely corrupt or the victim of tampering." },
	{ WERR_NO_PAGEFILE, "{No Paging File Specified} No paging file was specified in the system configuration." },
	{ WERR_ILLEGAL_FLOAT_CONTEXT, "{EXCEPTION} A real-mode application issued a floating-point instruction, and floating-point hardware is not present." },
	{ WERR_NO_EVENT_PAIR, "An event pair synchronization operation was performed using the thread-specific client/server event pair object, but no event pair object was associated with the thread." },
	{ WERR_DOMAIN_CTRLR_CONFIG_ERROR, "A Windows Server has an incorrect configuration." },
	{ WERR_ILLEGAL_CHARACTER, "An illegal character was encountered. For a multibyte character set, this includes a lead byte without a succeeding trail byte. For the Unicode character set, this includes the characters 0xFFFF and 0xFFFE." },
	{ WERR_UNDEFINED_CHARACTER, "The Unicode character is not defined in the Unicode character set installed on the system." },
	{ WERR_FLOPPY_VOLUME, "The paging file cannot be created on a floppy disk." },
	{ WERR_BIOS_FAILED_TO_CONNECT_INTERRUPT, "The system bios failed to connect a system interrupt to the device or bus for which the device is connected." },
	{ WERR_BACKUP_CONTROLLER, "This operation is only allowed for the primary domain controller (PDC) of the domain." },
	{ WERR_MUTANT_LIMIT_EXCEEDED, "An attempt was made to acquire a mutant such that its maximum count would have been exceeded." },
	{ WERR_FS_DRIVER_REQUIRED, "A volume has been accessed for which a file system driver is required that has not yet been loaded." },
	{ WERR_CANNOT_LOAD_REGISTRY_FILE, "{Registry File Failure} The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable." },
	{ WERR_DEBUG_ATTACH_FAILED, "{Unexpected Failure in DebugActiveProcess} An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error." },
	{ WERR_SYSTEM_PROCESS_TERMINATED, "{Fatal System Error} The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down." },
	{ WERR_DATA_NOT_ACCEPTED, "{Data Not Accepted} The transport driver interface (TDI) client could not handle the data received during an indication." },
	{ WERR_VDM_HARD_ERROR, "The NT Virtual DOS Machine (NTVDM) encountered a hard error." },
	{ WERR_DRIVER_CANCEL_TIMEOUT, "{Cancel Timeout} The driver %hs failed to complete a canceled I/O request in the allotted time." },
	{ WERR_REPLY_MESSAGE_MISMATCH, "{Reply Message Mismatch} An attempt was made to reply to a local procedure call (LPC) message, but the thread specified by the client ID in the message was not waiting on that message." },
	{ WERR_LOST_WRITEBEHIND_DATA, "{Delayed Write Failed} Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Try to save this file elsewhere." },
	{ WERR_CLIENT_SERVER_PARAMETERS_INVALID, "The parameters passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window." },
	{ WERR_NOT_TINY_STREAM, "The stream is not a tiny stream." },
	{ WERR_STACK_OVERFLOW_READ, "The request must be handled by the stack overflow code." },
	{ WERR_CONVERT_TO_LARGE, "Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing onode is moved or the extent stream is converted to a large stream." },
	{ WERR_FOUND_OUT_OF_SCOPE, "The attempt to find the object found an object matching by ID on the volume but it is out of the scope of the handle used for the operation." },
	{ WERR_ALLOCATE_BUCKET, "The bucket array must be grown. Retry transaction after doing so." },
	{ WERR_MARSHALL_OVERFLOW, "The user/kernel marshaling buffer has overflowed." },
	{ WERR_INVALID_VARIANT, "The supplied variant structure contains invalid data." },
	{ WERR_BAD_COMPRESSION_BUFFER, "The specified buffer contains ill-formed data." },
	{ WERR_AUDIT_FAILED, "{Audit Failed} An attempt to generate a security audit failed." },
	{ WERR_TIMER_RESOLUTION_NOT_SET, "The timer resolution was not previously set by the current process." },
	{ WERR_INSUFFICIENT_LOGON_INFO, "There is insufficient account information to log you on." },
	{ WERR_BAD_DLL_ENTRYPOINT, "{Invalid DLL Entrypoint} The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entry point should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly." },
	{ WERR_BAD_SERVICE_ENTRYPOINT, "{Invalid Service Callback Entrypoint} The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entry point should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly." },
	{ WERR_IP_ADDRESS_CONFLICT1, "There is an IP address conflict with another system on the network." },
	{ WERR_IP_ADDRESS_CONFLICT2, "There is an IP address conflict with another system on the network." },
	{ WERR_REGISTRY_QUOTA_LIMIT, "{Low On Registry Space} The system has reached the maximum size allowed for the system part of the registry. Additional storage requests will be ignored." },
	{ WERR_NO_CALLBACK_ACTIVE, "A callback return system service cannot be executed when no callback is active." },
	{ WERR_PWD_TOO_SHORT, "The password provided is too short to meet the policy of your user account. Choose a longer password." },
	{ WERR_PWD_TOO_RECENT, "The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised, contact your administrator immediately to have a new one assigned." },
	{ WERR_PWD_HISTORY_CONFLICT, "You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Select a password that you have not previously used." },
	{ WERR_UNSUPPORTED_COMPRESSION, "The specified compression format is unsupported." },
	{ WERR_INVALID_HW_PROFILE, "The specified hardware profile configuration is invalid." },
	{ WERR_INVALID_PLUGPLAY_DEVICE_PATH, "The specified Plug and Play registry device path is invalid." },
	{ WERR_QUOTA_LIST_INCONSISTENT, "The specified quota list is internally inconsistent with its descriptor." },
	{ WERR_EVALUATION_EXPIRATION, "{Windows Evaluation Notification} The evaluation period for this installation of Windows has expired. This system will shut down in 1 hour. To restore access to this installation of Windows, upgrade this installation using a licensed distribution of this product." },
	{ WERR_ILLEGAL_DLL_RELOCATION, "{Illegal System DLL Relocation} The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL." },
	{ WERR_DLL_INIT_FAILED_LOGOFF, "{DLL Initialization Failed} The application failed to initialize because the window station is shutting down." },
	{ WERR_VALIDATE_CONTINUE, "The validation process needs to continue on to the next step." },
	{ WERR_NO_MORE_MATCHES, "There are no more matches for the current index enumeration." },
	{ WERR_RANGE_LIST_CONFLICT, "The range could not be added to the range list because of a conflict." },
	{ WERR_SERVER_SID_MISMATCH, "The server process is running under a SID different than that required by the client." },
	{ WERR_CANT_ENABLE_DENY_ONLY, "A group marked use for deny only cannot be enabled." },
	{ WERR_FLOAT_MULTIPLE_FAULTS, "{EXCEPTION} Multiple floating point faults." },
	{ WERR_FLOAT_MULTIPLE_TRAPS, "{EXCEPTION} Multiple floating point traps." },
	{ WERR_NOINTERFACE, "The requested interface is not supported." },
	{ WERR_DRIVER_FAILED_SLEEP, "{System Standby Failed} The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode." },
	{ WERR_CORRUPT_SYSTEM_FILE, "The system file %1 has become corrupt and has been replaced." },
	{ WERR_COMMITMENT_MINIMUM, "{Virtual Memory Minimum Too Low} Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help." },
	{ WERR_PNP_RESTART_ENUMERATION, "A device was removed so enumeration must be restarted." },
	{ WERR_SYSTEM_IMAGE_BAD_SIGNATURE, "{Fatal System Error} The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down." },
	{ WERR_PNP_REBOOT_REQUIRED, "Device will not start without a reboot." },
	{ WERR_INSUFFICIENT_POWER, "There is not enough power to complete the requested operation." },
	{ WERR_MULTIPLE_FAULT_VIOLATION, "ERROR_MULTIPLE_FAULT_VIOLATION" },
	{ WERR_SYSTEM_SHUTDOWN, "The system is in the process of shutting down." },
	{ WERR_PORT_NOT_SET, "An attempt to remove a process DebugPort was made, but a port was not already associated with the process." },
	{ WERR_DS_VERSION_CHECK_FAILURE, "This version of Windows is not compatible with the behavior version of directory forest, domain, or domain controller." },
	{ WERR_RANGE_NOT_FOUND, "The specified range could not be found in the range list." },
	{ WERR_NOT_SAFE_MODE_DRIVER, "The driver was not loaded because the system is booting into safe mode." },
	{ WERR_FAILED_DRIVER_ENTRY, "The driver was not loaded because it failed its initialization call." },
	{ WERR_DEVICE_ENUMERATION_ERROR, "The device encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection." },
	{ WERR_MOUNT_POINT_NOT_RESOLVED, "The create operation failed because the name contained at least one mount point that resolves to a volume to which the specified device object is not attached." },
	{ WERR_INVALID_DEVICE_OBJECT_PARAMETER, "The device object parameter is either not a valid device object or is not attached to the volume specified by the file name." },
	{ WERR_MCA_OCCURED, "A machine check error has occurred. Check the system event log for additional information." },
	{ WERR_DRIVER_DATABASE_ERROR, "There was an error [%2] processing the driver database." },
	{ WERR_SYSTEM_HIVE_TOO_LARGE, "The system hive size has exceeded its limit." },
	{ WERR_DRIVER_FAILED_PRIOR_UNLOAD, "The driver could not be loaded because a previous version of the driver is still in memory." },
	{ WERR_VOLSNAP_PREPARE_HIBERNATE, "{Volume Shadow Copy Service} Wait while the Volume Shadow Copy Service prepares volume %hs for hibernation." },
	{ WERR_HIBERNATION_FAILURE, "The system has failed to hibernate (the error code is %hs). Hibernation will be disabled until the system is restarted." },
	{ WERR_FILE_SYSTEM_LIMITATION, "The requested operation could not be completed due to a file system limitation." },
	{ WERR_ASSERTION_FAILURE, "An assertion failure has occurred." },
	{ WERR_ACPI_ERROR, "An error occurred in the Advanced Configuration and Power Interface (ACPI) subsystem." },
	{ WERR_WOW_ASSERTION, "WOW assertion error." },
	{ WERR_PNP_BAD_MPS_TABLE, "A device is missing in the system BIOS MultiProcessor Specification (MPS) table. This device will not be used. Contact your system vendor for system BIOS update." },
	{ WERR_PNP_TRANSLATION_FAILED, "A translator failed to translate resources." },
	{ WERR_PNP_IRQ_TRANSLATION_FAILED, "An interrupt request (IRQ) translator failed to translate resources." },
	{ WERR_PNP_INVALID_ID, "Driver %2 returned invalid ID for a child device (%3)." },
	{ WERR_WAKE_SYSTEM_DEBUGGER, "{Kernel Debugger Awakened} the system debugger was awakened by an interrupt." },
	{ WERR_HANDLES_CLOSED, "{Handles Closed} Handles to objects have been automatically closed because of the requested operation." },
	{ WERR_EXTRANEOUS_INFORMATION, "{Too Much Information} The specified ACL contained more information than was expected." },
	{ WERR_RXACT_COMMIT_NECESSARY, "This warning level status indicates that the transaction state already exists for the registry subtree, but that a transaction commit was previously aborted. The commit has NOT been completed, but it has not been rolled back either (so it may still be committed if desired)." },
	{ WERR_MEDIA_CHECK, "{Media Changed} The media may have changed." },
	{ WERR_GUID_SUBSTITUTION_MADE, "{GUID Substitution} During the translation of a GUID to a Windows SID, no administratively defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide more restrictive access than intended." },
	{ WERR_STOPPED_ON_SYMLINK, "The create operation stopped after reaching a symbolic link." },
	{ WERR_LONGJUMP, "A long jump has been executed." },
	{ WERR_PLUGPLAY_QUERY_VETOED, "The Plug and Play query operation was not successful." },
	{ WERR_UNWIND_CONSOLIDATE, "A frame consolidation has been executed." },
	{ WERR_REGISTRY_HIVE_RECOVERED, "{Registry Hive Recovered} Registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost." },
	{ WERR_DLL_MIGHT_BE_INSECURE, "The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?" },
	{ WERR_DLL_MIGHT_BE_INCOMPATIBLE, "The application is loading executable code from the module %hs. This is secure, but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?" },
	{ WERR_DBG_EXCEPTION_NOT_HANDLED, "Debugger did not handle the exception." },
	{ WERR_DBG_REPLY_LATER, "Debugger will reply later." },
	{ WERR_DBG_UNABLE_TO_PROVIDE_HANDLE, "Debugger cannot provide handle." },
	{ WERR_DBG_TERMINATE_THREAD, "Debugger terminated thread." },
	{ WERR_DBG_TERMINATE_PROCESS, "Debugger terminated process." },
	{ WERR_DBG_CONTROL_C, "Debugger got control C." },
	{ WERR_DBG_PRINTEXCEPTION_C, "Debugger printed exception on control C." },
	{ WERR_DBG_RIPEXCEPTION, "Debugger received Routing Information Protocol (RIP) exception." },
	{ WERR_DBG_CONTROL_BREAK, "Debugger received control break." },
	{ WERR_DBG_COMMAND_EXCEPTION, "Debugger command communication exception." },
	{ WERR_OBJECT_NAME_EXISTS, "{Object Exists} An attempt was made to create an object and the object name already existed." },
	{ WERR_THREAD_WAS_SUSPENDED, "{Thread Suspended} A thread termination occurred while the thread was suspended. The thread was resumed and termination proceeded." },
	{ WERR_IMAGE_NOT_AT_BASE, "{Image Relocated} An image file could not be mapped at the address specified in the image file. Local fixes must be performed on this image." },
	{ WERR_RXACT_STATE_CREATED, "This informational level status indicates that a specified registry subtree transaction state did not yet exist and had to be created." },
	{ WERR_SEGMENT_NOTIFICATION, "{Segment Load} A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so a debugger can load, unload, or track symbols and breakpoints within these 16-bit segments." },
	{ WERR_BAD_CURRENT_DIRECTORY, "{Invalid Current Directory} The process cannot switch to the startup current directory %hs. Select OK to set current directory to %hs, or select CANCEL to exit." },
	{ WERR_FT_READ_RECOVERY_FROM_BACKUP, "{Redundant Read} To satisfy a read request, the NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but it was unable to reassign the failing area of the device." },
	{ WERR_FT_WRITE_RECOVERY, "{Redundant Write} To satisfy a write request, the Windows NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume, but it was not able to reassign the failing area of the device." },
	{ WERR_IMAGE_MACHINE_TYPE_MISMATCH, "{Machine Type Mismatch} The image file %hs is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load." },
	{ WERR_RECEIVE_PARTIAL, "{Partial Data Received} The network transport returned partial data to its client. The remaining data will be sent later." },
	{ WERR_RECEIVE_EXPEDITED, "{Expedited Data Received} The network transport returned data to its client that was marked as expedited by the remote system." },
	{ WERR_RECEIVE_PARTIAL_EXPEDITED, "{Partial Expedited Data Received} The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later." },
	{ WERR_EVENT_DONE, "{TDI Event Done} The TDI indication has completed successfully." },
	{ WERR_EVENT_PENDING, "{TDI Event Pending} The TDI indication has entered the pending state." },
	{ WERR_CHECKING_FILE_SYSTEM, "Checking file system on %wZ." },
	{ WERR_FATAL_APP_EXIT, "{Fatal Application Exit} %hs." },
	{ WERR_PREDEFINED_HANDLE, "The specified registry key is referenced by a predefined handle." },
	{ WERR_WAS_UNLOCKED, "{Page Unlocked} The page protection of a locked page was changed to \'No Access\' and the page was unlocked from memory and from the process." },
	{ WERR_SERVICE_NOTIFICATION, "%hs" },
	{ WERR_WAS_LOCKED, "{Page Locked} One of the pages to lock was already locked." },
	{ WERR_LOG_HARD_ERROR, "Application popup: %1 : %2" },
	{ WERR_ALREADY_WIN32, "The value already corresponds with a Win 32 error code." },
	{ WERR_IMAGE_MACHINE_TYPE_MISMATCH_EXE, "{Machine Type Mismatch} The image file %hs is valid, but is for a machine type other than the current machine." },
	{ WERR_NO_YIELD_PERFORMED, "A yield execution was performed and no thread was available to run." },
	{ WERR_TIMER_RESUME_IGNORED, "The resume flag to a timer API was ignored." },
	{ WERR_ARBITRATION_UNHANDLED, "The arbiter has deferred arbitration of these resources to its parent" },
	{ WERR_CARDBUS_NOT_SUPPORTED, "The inserted CardBus device cannot be started because of a configuration error on %hs\".\"" },
	{ WERR_MP_PROCESSOR_MISMATCH, "The CPUs in this multiprocessor system are not all the same revision level. To use all processors the operating system restricts itself to the features of the least capable processor in the system. If problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported." },
	{ WERR_HIBERNATED, "The system was put into hibernation." },
	{ WERR_RESUME_HIBERNATION, "The system was resumed from hibernation." },
	{ WERR_FIRMWARE_UPDATED, "Windows has detected that the system firmware (BIOS) was updated (previous firmware date = %2, current firmware date %3)." },
	{ WERR_DRIVERS_LEAKING_LOCKED_PAGES, "A device driver is leaking locked I/O pages, causing system degradation. The system has automatically enabled a tracking code to try and catch the culprit." },
	{ WERR_WAKE_SYSTEM, "The system has awoken." },
	{ WERR_WAIT_1, "ERROR_WAIT_1" },
	{ WERR_WAIT_2, "ERROR_WAIT_2" },
	{ WERR_WAIT_3, "ERROR_WAIT_3" },
	{ WERR_WAIT_63, "ERROR_WAIT_63" },
	{ WERR_ABANDONED_WAIT_0, "ERROR_ABANDONED_WAIT_0" },
	{ WERR_ABANDONED_WAIT_63, "ERROR_ABANDONED_WAIT_63" },
	{ WERR_USER_APC, "ERROR_USER_APC" },
	{ WERR_KERNEL_APC, "ERROR_KERNEL_APC" },
	{ WERR_ALERTED, "ERROR_ALERTED" },
	{ WERR_ELEVATION_REQUIRED, "The requested operation requires elevation." },
	{ WERR_REPARSE, "A reparse should be performed by the object manager because the name of the file resulted in a symbolic link." },
	{ WERR_OPLOCK_BREAK_IN_PROGRESS, "An open/create operation completed while an oplock break is underway." },
	{ WERR_VOLUME_MOUNTED, "A new volume has been mounted by a file system." },
	{ WERR_RXACT_COMMITTED, "This success level status indicates that the transaction state already exists for the registry subtree, but that a transaction commit was previously aborted. The commit has now been completed." },
	{ WERR_NOTIFY_CLEANUP, "This indicates that a notify change request has been completed due to closing the handle which made the notify change request." },
	{ WERR_PRIMARY_TRANSPORT_CONNECT_FAILED, "{Connect Failure on Primary Transport} An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer was able to connect on a secondary transport." },
	{ WERR_PAGE_FAULT_TRANSITION, "Page fault was a transition fault." },
	{ WERR_PAGE_FAULT_DEMAND_ZERO, "Page fault was a demand zero fault." },
	{ WERR_PAGE_FAULT_COPY_ON_WRITE, "Page fault was a demand zero fault." },
	{ WERR_PAGE_FAULT_GUARD_PAGE, "Page fault was a demand zero fault." },
	{ WERR_PAGE_FAULT_PAGING_FILE, "Page fault was satisfied by reading from a secondary storage device." },
	{ WERR_CACHE_PAGE_LOCKED, "Cached page was locked during operation." },
	{ WERR_CRASH_DUMP, "Crash dump exists in paging file." },
	{ WERR_BUFFER_ALL_ZEROS, "Specified buffer contains all zeros." },
	{ WERR_REPARSE_OBJECT, "A reparse should be performed by the object manager because the name of the file resulted in a symbolic link." },
	{ WERR_RESOURCE_REQUIREMENTS_CHANGED, "The device has succeeded a query-stop and its resource requirements have changed." },
	{ WERR_TRANSLATION_COMPLETE, "The translator has translated these resources into the global space and no further translations should be performed." },
	{ WERR_NOTHING_TO_TERMINATE, "A process being terminated has no threads to terminate." },
	{ WERR_PROCESS_NOT_IN_JOB, "The specified process is not part of a job." },
	{ WERR_PROCESS_IN_JOB, "The specified process is part of a job." },
	{ WERR_VOLSNAP_HIBERNATE_READY, "{Volume Shadow Copy Service} The system is now ready for hibernation." },
	{ WERR_FSFILTER_OP_COMPLETED_SUCCESSFULLY, "A file system or file system filter driver has successfully completed an FsFilter operation." },
	{ WERR_INTERRUPT_VECTOR_ALREADY_CONNECTED, "The specified interrupt vector was already connected." },
	{ WERR_INTERRUPT_STILL_CONNECTED, "The specified interrupt vector is still connected." },
	{ WERR_WAIT_FOR_OPLOCK, "An operation is blocked waiting for an oplock." },
	{ WERR_DBG_EXCEPTION_HANDLED, "Debugger handled exception." },
	{ WERR_DBG_CONTINUE, "Debugger continued." },
	{ WERR_CALLBACK_POP_STACK, "An exception occurred in a user mode callback and the kernel callback frame should be removed." },
	{ WERR_COMPRESSION_DISABLED, "Compression is disabled for this volume." },
	{ WERR_CANTFETCHBACKWARDS, "The data provider cannot fetch backward through a result set." },
	{ WERR_CANTSCROLLBACKWARDS, "The data provider cannot scroll backward through a result set." },
	{ WERR_ROWSNOTRELEASED, "The data provider requires that previously fetched data is released before asking for more data." },
	{ WERR_BAD_ACCESSOR_FLAGS, "The data provider was not able to interpret the flags set for a column binding in an accessor." },
	{ WERR_ERRORS_ENCOUNTERED, "One or more errors occurred while processing the request." },
	{ WERR_NOT_CAPABLE, "The implementation is not capable of performing the request." },
	{ WERR_REQUEST_OUT_OF_SEQUENCE, "The client of a component requested an operation that is not valid given the state of the component instance." },
	{ WERR_VERSION_PARSE_ERROR, "A version number could not be parsed." },
	{ WERR_BADSTARTPOSITION, "The iterator\'s start position is invalid." },
	{ WERR_MEMORY_HARDWARE, "The hardware has reported an uncorrectable memory error." },
	{ WERR_DISK_REPAIR_DISABLED, "The attempted operation required self-healing to be enabled." },
	{ WERR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE, "The Desktop heap encountered an error while allocating session memory. There is more information in the system event log." },
	{ WERR_SYSTEM_POWERSTATE_TRANSITION, "The system power state is transitioning from %2 to %3." },
	{ WERR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION, "The system power state is transitioning from %2 to %3 but could enter %4." },
	{ WERR_MCA_EXCEPTION, "A thread is getting dispatched with MCA EXCEPTION because of MCA." },
	{ WERR_ACCESS_AUDIT_BY_POLICY, "Access to %1 is monitored by policy rule %2." },
	{ WERR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY, "Access to %1 has been restricted by your administrator by policy rule %2." },
	{ WERR_ABANDON_HIBERFILE, "A valid hibernation file has been invalidated and should be abandoned." },
	{ WERR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED, "{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused by network connectivity issues. Try to save this file elsewhere." },
	{ WERR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR, "{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error was returned by the server on which the file exists. Try to save this file elsewhere." },
	{ WERR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR, "{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused if the device has been removed or the media is write-protected." },
	{ WERR_EA_ACCESS_DENIED, "Access to the extended attribute was denied." },
	{ WERR_OPERATION_ABORTED, "The I/O operation has been aborted because of either a thread exit or an application request." },
	{ WERR_IO_INCOMPLETE, "Overlapped I/O event is not in a signaled state." },
	{ WERR_IO_PENDING, "Overlapped I/O operation is in progress." },
	{ WERR_NOACCESS, "Invalid access to memory location." },
	{ WERR_SWAPERROR, "Error performing in-page operation." },
	{ WERR_STACK_OVERFLOW, "Recursion too deep; the stack overflowed." },
	{ WERR_INVALID_MESSAGE, "The window cannot act on the sent message." },
	{ WERR_CAN_NOT_COMPLETE, "Cannot complete this function." },
	{ WERR_INVALID_FLAGS, "Invalid flags." },
	{ WERR_UNRECOGNIZED_VOLUME, "The volume does not contain a recognized file system. Be sure that all required file system drivers are loaded and that the volume is not corrupted." },
	{ WERR_FILE_INVALID, "The volume for a file has been externally altered so that the opened file is no longer valid." },
	{ WERR_FULLSCREEN_MODE, "The requested operation cannot be performed in full-screen mode." },
	{ WERR_NO_TOKEN, "An attempt was made to reference a token that does not exist." },
	{ WERR_BADDB, "The configuration registry database is corrupt." },
	{ WERR_BADKEY, "The configuration registry key is invalid." },
	{ WERR_CANTOPEN, "The configuration registry key could not be opened." },
	{ WERR_CANTREAD, "The configuration registry key could not be read." },
	{ WERR_CANTWRITE, "The configuration registry key could not be written." },
	{ WERR_REGISTRY_RECOVERED, "One of the files in the registry database had to be recovered by use of a log or alternate copy. The recovery was successful." },
	{ WERR_REGISTRY_CORRUPT, "The registry is corrupted. The structure of one of the files containing registry data is corrupted, or the system\'s memory image of the file is corrupted, or the file could not be recovered because the alternate copy or log was absent or corrupted." },
	{ WERR_REGISTRY_IO_FAILED, "An I/O operation initiated by the registry failed and cannot be recovered. The registry could not read in, write out, or flush one of the files that contain the system\'s image of the registry." },
	{ WERR_NOT_REGISTRY_FILE, "The system attempted to load or restore a file into the registry, but the specified file is not in a registry file format." },
	{ WERR_KEY_DELETED, "Illegal operation attempted on a registry key that has been marked for deletion." },
	{ WERR_NO_LOG_SPACE, "System could not allocate the required space in a registry log." },
	{ WERR_KEY_HAS_CHILDREN, "Cannot create a symbolic link in a registry key that already has subkeys or values." },
	{ WERR_CHILD_MUST_BE_VOLATILE, "Cannot create a stable subkey under a volatile parent key." },
	{ WERR_NOTIFY_ENUM_DIR, "A notify change request is being completed and the information is not being returned in the caller\'s buffer. The caller now needs to enumerate the files to find the changes." },
	{ WERR_DEPENDENT_SERVICES_RUNNING, "A stop control has been sent to a service that other running services are dependent on." },
	{ WERR_INVALID_SERVICE_CONTROL, "The requested control is not valid for this service." },
	{ WERR_SERVICE_REQUEST_TIMEOUT, "The service did not respond to the start or control request in a timely fashion." },
	{ WERR_SERVICE_NO_THREAD, "A thread could not be created for the service." },
	{ WERR_SERVICE_DATABASE_LOCKED, "The service database is locked." },
	{ WERR_SERVICE_ALREADY_RUNNING, "An instance of the service is already running." },
	{ WERR_INVALID_SERVICE_ACCOUNT, "The account name is invalid or does not exist, or the password is invalid for the account name specified." },
	{ WERR_SERVICE_DISABLED, "The service cannot be started, either because it is disabled or because it has no enabled devices associated with it." },
	{ WERR_CIRCULAR_DEPENDENCY, "Circular service dependency was specified." },
	{ WERR_SERVICE_DOES_NOT_EXIST, "The specified service does not exist as an installed service." },
	{ WERR_SERVICE_CANNOT_ACCEPT_CTRL, "The service cannot accept control messages at this time." },
	{ WERR_SERVICE_NOT_ACTIVE, "The service has not been started." },
	{ WERR_FAILED_SERVICE_CONTROLLER_CONNECT, "The service process could not connect to the service controller." },
	{ WERR_EXCEPTION_IN_SERVICE, "An exception occurred in the service when handling the control request." },
	{ WERR_DATABASE_DOES_NOT_EXIST, "The database specified does not exist." },
	{ WERR_SERVICE_SPECIFIC_ERROR, "The service has returned a service-specific error code." },
	{ WERR_PROCESS_ABORTED, "The process terminated unexpectedly." },
	{ WERR_SERVICE_DEPENDENCY_FAIL, "The dependency service or group failed to start." },
	{ WERR_SERVICE_LOGON_FAILED, "The service did not start due to a logon failure." },
	{ WERR_SERVICE_START_HANG, "After starting, the service hung in a start-pending state." },
	{ WERR_INVALID_SERVICE_LOCK, "The specified service database lock is invalid." },
	{ WERR_SERVICE_MARKED_FOR_DELETE, "The specified service has been marked for deletion." },
	{ WERR_SERVICE_EXISTS, "The specified service already exists." },
	{ WERR_ALREADY_RUNNING_LKG, "The system is currently running with the last-known-good configuration." },
	{ WERR_SERVICE_DEPENDENCY_DELETED, "The dependency service does not exist or has been marked for deletion." },
	{ WERR_BOOT_ALREADY_ACCEPTED, "The current boot has already been accepted for use as the last-known-good control set." },
	{ WERR_SERVICE_NEVER_STARTED, "No attempts to start the service have been made since the last boot." },
	{ WERR_DUPLICATE_SERVICE_NAME, "The name is already in use as either a service name or a service display name." },
	{ WERR_DIFFERENT_SERVICE_ACCOUNT, "The account specified for this service is different from the account specified for other services running in the same process." },
	{ WERR_CANNOT_DETECT_DRIVER_FAILURE, "Failure actions can only be set for Win32 services, not for drivers." },
	{ WERR_CANNOT_DETECT_PROCESS_ABORT, "This service runs in the same process as the service control manager. Therefore, the service control manager cannot take action if this service\'s process terminates unexpectedly." },
	{ WERR_NO_RECOVERY_PROGRAM, "No recovery program has been configured for this service." },
	{ WERR_SERVICE_NOT_IN_EXE, "The executable program that this service is configured to run in does not implement the service." },
	{ WERR_NOT_SAFEBOOT_SERVICE, "This service cannot be started in Safe Mode." },
	{ WERR_END_OF_MEDIA, "The physical end of the tape has been reached." },
	{ WERR_FILEMARK_DETECTED, "A tape access reached a filemark." },
	{ WERR_BEGINNING_OF_MEDIA, "The beginning of the tape or a partition was encountered." },
	{ WERR_SETMARK_DETECTED, "A tape access reached the end of a set of files." },
	{ WERR_NO_DATA_DETECTED, "No more data is on the tape." },
	{ WERR_PARTITION_FAILURE, "Tape could not be partitioned." },
	{ WERR_INVALID_BLOCK_LENGTH, "When accessing a new tape of a multivolume partition, the current block size is incorrect." },
	{ WERR_DEVICE_NOT_PARTITIONED, "Tape partition information could not be found when loading a tape." },
	{ WERR_UNABLE_TO_LOCK_MEDIA, "Unable to lock the media eject mechanism." },
	{ WERR_UNABLE_TO_UNLOAD_MEDIA, "Unable to unload the media." },
	{ WERR_MEDIA_CHANGED, "The media in the drive may have changed." },
	{ WERR_BUS_RESET, "The I/O bus was reset." },
	{ WERR_NO_MEDIA_IN_DRIVE, "No media in drive." },
	{ WERR_NO_UNICODE_TRANSLATION, "No mapping for the Unicode character exists in the target multibyte code page." },
	{ WERR_DLL_INIT_FAILED, "A DLL initialization routine failed." },
	{ WERR_SHUTDOWN_IN_PROGRESS, "A system shutdown is in progress." },
	{ WERR_NO_SHUTDOWN_IN_PROGRESS, "Unable to abort the system shutdown because no shutdown was in progress." },
	{ WERR_IO_DEVICE, "The request could not be performed because of an I/O device error." },
	{ WERR_SERIAL_NO_DEVICE, "No serial device was successfully initialized. The serial driver will unload." },
	{ WERR_IRQ_BUSY, "Unable to open a device that was sharing an IRQ with other devices. At least one other device that uses that IRQ was already opened." },
	{ WERR_MORE_WRITES, "A serial I/O operation was completed by another write to the serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)" },
	{ WERR_COUNTER_TIMEOUT, "A serial I/O operation completed because the time-out period expired. (The IOCTL_SERIAL_XOFF_COUNTER did not reach zero.)" },
	{ WERR_FLOPPY_ID_MARK_NOT_FOUND, "No ID address mark was found on the floppy disk." },
	{ WERR_FLOPPY_WRONG_CYLINDER, "Mismatch between the floppy disk sector ID field and the floppy disk controller track address." },
	{ WERR_FLOPPY_UNKNOWN_ERROR, "The floppy disk controller reported an error that is not recognized by the floppy disk driver." },
	{ WERR_FLOPPY_BAD_REGISTERS, "The floppy disk controller returned inconsistent results in its registers." },
	{ WERR_DISK_RECALIBRATE_FAILED, "While accessing the hard disk, a recalibrate operation failed, even after retries." },
	{ WERR_DISK_OPERATION_FAILED, "While accessing the hard disk, a disk operation failed even after retries." },
	{ WERR_DISK_RESET_FAILED, "While accessing the hard disk, a disk controller reset was needed, but that also failed." },
	{ WERR_EOM_OVERFLOW, "Physical end of tape encountered." },
	{ WERR_NOT_ENOUGH_SERVER_MEMORY, "Not enough server storage is available to process this command." },
	{ WERR_POSSIBLE_DEADLOCK, "A potential deadlock condition has been detected." },
	{ WERR_MAPPED_ALIGNMENT, "The base address or the file offset specified does not have the proper alignment." },
	{ WERR_SET_POWER_STATE_VETOED, "An attempt to change the system power state was vetoed by another application or driver." },
	{ WERR_SET_POWER_STATE_FAILED, "The system BIOS failed an attempt to change the system power state." },
	{ WERR_TOO_MANY_LINKS, "An attempt was made to create more links on a file than the file system supports." },
	{ WERR_OLD_WIN_VERSION, "The specified program requires a newer version of Windows." },
	{ WERR_APP_WRONG_OS, "The specified program is not a Windows or MS-DOS program." },
	{ WERR_SINGLE_INSTANCE_APP, "Cannot start more than one instance of the specified program." },
	{ WERR_RMODE_APP, "The specified program was written for an earlier version of Windows." },
	{ WERR_INVALID_DLL, "One of the library files needed to run this application is damaged." },
	{ WERR_NO_ASSOCIATION, "No application is associated with the specified file for this operation." },
	{ WERR_DDE_FAIL, "An error occurred in sending the command to the application." },
	{ WERR_DLL_NOT_FOUND, "One of the library files needed to run this application cannot be found." },
	{ WERR_NO_MORE_USER_HANDLES, "The current process has used all of its system allowance of handles for Windows manager objects." },
	{ WERR_MESSAGE_SYNC_ONLY, "The message can be used only with synchronous operations." },
	{ WERR_SOURCE_ELEMENT_EMPTY, "The indicated source element has no media." },
	{ WERR_DESTINATION_ELEMENT_FULL, "The indicated destination element already contains media." },
	{ WERR_ILLEGAL_ELEMENT_ADDRESS, "The indicated element does not exist." },
	{ WERR_MAGAZINE_NOT_PRESENT, "The indicated element is part of a magazine that is not present." },
	{ WERR_DEVICE_REINITIALIZATION_NEEDED, "The indicated device requires re-initialization due to hardware errors." },
	{ WERR_DEVICE_REQUIRES_CLEANING, "The device has indicated that cleaning is required before further operations are attempted." },
	{ WERR_DEVICE_DOOR_OPEN, "The device has indicated that its door is open." },
	{ WERR_DEVICE_NOT_CONNECTED, "The device is not connected." },
	{ WERR_NOT_FOUND, "Element not found." },
	{ WERR_NO_MATCH, "There was no match for the specified key in the index." },
	{ WERR_SET_NOT_FOUND, "The property set specified does not exist on the object." },
	{ WERR_POINT_NOT_FOUND, "The point passed to GetMouseMovePoints is not in the buffer." },
	{ WERR_NO_TRACKING_SERVICE, "The tracking (workstation) service is not running." },
	{ WERR_NO_VOLUME_ID, "The volume ID could not be found." },
	{ WERR_UNABLE_TO_REMOVE_REPLACED, "Unable to remove the file to be replaced." },
	{ WERR_UNABLE_TO_MOVE_REPLACEMENT, "Unable to move the replacement file to the file to be replaced. The file to be replaced has retained its original name." },
	{ WERR_UNABLE_TO_MOVE_REPLACEMENT_2, "Unable to move the replacement file to the file to be replaced. The file to be replaced has been renamed using the backup name." },
	{ WERR_JOURNAL_DELETE_IN_PROGRESS, "The volume change journal is being deleted." },
	{ WERR_JOURNAL_NOT_ACTIVE, "The volume change journal is not active." },
	{ WERR_POTENTIAL_FILE_FOUND, "A file was found, but it may not be the correct file." },
	{ WERR_JOURNAL_ENTRY_DELETED, "The journal entry has been deleted from the journal." },
	{ WERR_SHUTDOWN_IS_SCHEDULED, "A system shutdown has already been scheduled." },
	{ WERR_SHUTDOWN_USERS_LOGGED_ON, "The system shutdown cannot be initiated because there are other users logged on to the computer." },
	{ WERR_BAD_DEVICE, "The specified device name is invalid." },
	{ WERR_CONNECTION_UNAVAIL, "The device is not currently connected but it is a remembered connection." },
	{ WERR_DEVICE_ALREADY_REMEMBERED, "The local device name has a remembered connection to another network resource." },
	{ WERR_NO_NET_OR_BAD_PATH, "The network path was either typed incorrectly, does not exist, or the network provider is not currently available. Try retyping the path or contact your network administrator." },
	{ WERR_BAD_PROVIDER, "The specified network provider name is invalid." },
	{ WERR_CANNOT_OPEN_PROFILE, "Unable to open the network connection profile." },
	{ WERR_BAD_PROFILE, "The network connection profile is corrupted." },
	{ WERR_NOT_CONTAINER, "Cannot enumerate a noncontainer." },
	{ WERR_EXTENDED_ERROR, "An extended error has occurred." },
	{ WERR_INVALID_GROUPNAME, "The format of the specified group name is invalid." },
	{ WERR_INVALID_COMPUTERNAME, "The format of the specified computer name is invalid." },
	{ WERR_INVALID_EVENTNAME, "The format of the specified event name is invalid." },
	{ WERR_INVALID_DOMAINNAME, "The format of the specified domain name is invalid." },
	{ WERR_INVALID_SERVICENAME, "The format of the specified service name is invalid." },
	{ WERR_INVALID_NETNAME, "The format of the specified network name is invalid." },
	{ WERR_INVALID_SHARENAME, "The format of the specified share name is invalid." },
	{ WERR_INVALID_PASSWORDNAME, "The format of the specified password is invalid." },
	{ WERR_INVALID_MESSAGENAME, "The format of the specified message name is invalid." },
	{ WERR_INVALID_MESSAGEDEST, "The format of the specified message destination is invalid." },
	{ WERR_SESSION_CREDENTIAL_CONFLICT, "Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again." },
	{ WERR_REMOTE_SESSION_LIMIT_EXCEEDED, "An attempt was made to establish a session to a network server, but there are already too many sessions established to that server." },
	{ WERR_DUP_DOMAINNAME, "The workgroup or domain name is already in use by another computer on the network." },
	{ WERR_NO_NETWORK, "The network is not present or not started." },
	{ WERR_CANCELLED, "The operation was canceled by the user." },
	{ WERR_USER_MAPPED_FILE, "The requested operation cannot be performed on a file with a user-mapped section open." },
	{ WERR_CONNECTION_REFUSED, "The remote system refused the network connection." },
	{ WERR_GRACEFUL_DISCONNECT, "The network connection was gracefully closed." },
	{ WERR_ADDRESS_ALREADY_ASSOCIATED, "The network transport endpoint already has an address associated with it." },
	{ WERR_ADDRESS_NOT_ASSOCIATED, "An address has not yet been associated with the network endpoint." },
	{ WERR_CONNECTION_INVALID, "An operation was attempted on a nonexistent network connection." },
	{ WERR_CONNECTION_ACTIVE, "An invalid operation was attempted on an active network connection." },
	{ WERR_NETWORK_UNREACHABLE, "The network location cannot be reached. For information about network troubleshooting, see Windows Help." },
	{ WERR_HOST_UNREACHABLE, "The network location cannot be reached. For information about network troubleshooting, see Windows Help." },
	{ WERR_PROTOCOL_UNREACHABLE, "The network location cannot be reached. For information about network troubleshooting, see Windows Help." },
	{ WERR_PORT_UNREACHABLE, "No service is operating at the destination network endpoint on the remote system." },
	{ WERR_REQUEST_ABORTED, "The request was aborted." },
	{ WERR_CONNECTION_ABORTED, "The network connection was aborted by the local system." },
	{ WERR_RETRY, "The operation could not be completed. A retry should be performed." },
	{ WERR_CONNECTION_COUNT_LIMIT, "A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached." },
	{ WERR_LOGIN_TIME_RESTRICTION, "Attempting to log on during an unauthorized time of day for this account." },
	{ WERR_LOGIN_WKSTA_RESTRICTION, "The account is not authorized to log on from this station." },
	{ WERR_INCORRECT_ADDRESS, "The network address could not be used for the operation requested." },
	{ WERR_ALREADY_REGISTERED, "The service is already registered." },
	{ WERR_SERVICE_NOT_FOUND, "The specified service does not exist." },
	{ WERR_NOT_AUTHENTICATED, "The operation being requested was not performed because the user has not been authenticated." },
	{ WERR_NOT_LOGGED_ON, "The operation being requested was not performed because the user has not logged on to the network. The specified service does not exist." },
	{ WERR_CONTINUE, "Continue with work in progress." },
	{ WERR_ALREADY_INITIALIZED, "An attempt was made to perform an initialization operation when initialization has already been completed." },
	{ WERR_NO_MORE_DEVICES, "No more local devices." },
	{ WERR_NO_SUCH_SITE, "The specified site does not exist." },
	{ WERR_DOMAIN_CONTROLLER_EXISTS, "A domain controller with the specified name already exists." },
	{ WERR_ONLY_IF_CONNECTED, "This operation is supported only when you are connected to the server." },
	{ WERR_OVERRIDE_NOCHANGES, "The group policy framework should call the extension even if there are no changes." },
	{ WERR_BAD_USER_PROFILE, "The specified user does not have a valid profile." },
	{ WERR_NOT_SUPPORTED_ON_SBS, "This operation is not supported on a computer running Windows Server 2003 for Small Business Server." },
	{ WERR_SERVER_SHUTDOWN_IN_PROGRESS, "The server machine is shutting down." },
	{ WERR_HOST_DOWN, "The remote system is not available. For information about network troubleshooting, see Windows Help." },
	{ WERR_NON_ACCOUNT_SID, "The security identifier provided is not from an account domain." },
	{ WERR_NON_DOMAIN_SID, "The security identifier provided does not have a domain component." },
	{ WERR_APPHELP_BLOCK, "AppHelp dialog canceled, thus preventing the application from starting." },
	{ WERR_ACCESS_DISABLED_BY_POLICY, "This program is blocked by Group Policy. For more information, contact your system administrator." },
	{ WERR_REG_NAT_CONSUMPTION, "A program attempt to use an invalid register value. Normally caused by an uninitialized register. This error is Itanium specific." },
	{ WERR_CSCSHARE_OFFLINE, "The share is currently offline or does not exist." },
	{ WERR_PKINIT_FAILURE, "The Kerberos protocol encountered an error while validating the KDC certificate during smartcard logon. There is more information in the system event log." },
	{ WERR_SMARTCARD_SUBSYSTEM_FAILURE, "The Kerberos protocol encountered an error while attempting to utilize the smartcard subsystem." },
	{ WERR_DOWNGRADE_DETECTED, "The system detected a possible attempt to compromise security. Ensure that you can contact the server that authenticated you." },
	{ WERR_MACHINE_LOCKED, "The machine is locked and cannot be shut down without the force option." },
	{ WERR_CALLBACK_SUPPLIED_INVALID_DATA, "An application-defined callback gave invalid data when called." },
	{ WERR_SYNC_FOREGROUND_REFRESH_REQUIRED, "The Group Policy framework should call the extension in the synchronous foreground policy refresh." },
	{ WERR_DRIVER_BLOCKED, "This driver has been blocked from loading." },
	{ WERR_INVALID_IMPORT_OF_NON_DLL, "A DLL referenced a module that was neither a DLL nor the process\'s executable image." },
	{ WERR_ACCESS_DISABLED_WEBBLADE, "Windows cannot open this program because it has been disabled." },
	{ WERR_ACCESS_DISABLED_WEBBLADE_TAMPER, "Windows cannot open this program because the license enforcement system has been tampered with or become corrupted." },
	{ WERR_RECOVERY_FAILURE, "A transaction recover failed." },
	{ WERR_ALREADY_FIBER, "The current thread has already been converted to a fiber." },
	{ WERR_ALREADY_THREAD, "The current thread has already been converted from a fiber." },
	{ WERR_STACK_BUFFER_OVERRUN, "The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application." },
	{ WERR_PARAMETER_QUOTA_EXCEEDED, "Data present in one of the parameters is more than the function can operate on." },
	{ WERR_DEBUGGER_INACTIVE, "An attempt to perform an operation on a debug object failed because the object is in the process of being deleted." },
	{ WERR_DELAY_LOAD_FAILED, "An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed." },
	{ WERR_VDM_DISALLOWED, "%1 is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator." },
	{ WERR_UNIDENTIFIED_ERROR, "Insufficient information exists to identify the cause of failure." },
	{ WERR_BEYOND_VDL, "The operation occurred beyond the valid data length of the file." },
	{ WERR_INCOMPATIBLE_SERVICE_SID_TYPE, "The service start failed because one or more services in the same process have an incompatible service SID type setting. A service with a restricted service SID type can only coexist in the same process with other services with a restricted SID type." },
	{ WERR_DRIVER_PROCESS_TERMINATED, "The process hosting the driver for this device has been terminated." },
	{ WERR_IMPLEMENTATION_LIMIT, "An operation attempted to exceed an implementation-defined limit." },
	{ WERR_PROCESS_IS_PROTECTED, "Either the target process, or the target thread\'s containing process, is a protected process." },
	{ WERR_SERVICE_NOTIFY_CLIENT_LAGGING, "The service notification client is lagging too far behind the current state of services in the machine." },
	{ WERR_DISK_QUOTA_EXCEEDED, "An operation failed because the storage quota was exceeded." },
	{ WERR_CONTENT_BLOCKED, "An operation failed because the content was blocked." },
	{ WERR_INCOMPATIBLE_SERVICE_PRIVILEGE, "A privilege that the service requires to function properly does not exist in the service account configuration. You may use the Services Microsoft Management Console (MMC) snap-in (Services.msc) and the Local Security Settings MMC snap-in (Secpol.msc) to view the service configuration and the account configuration." },
	{ WERR_INVALID_LABEL, "Indicates a particular SID may not be assigned as the label of an object." },
	{ WERR_NOT_ALL_ASSIGNED, "Not all privileges or groups referenced are assigned to the caller." },
	{ WERR_SOME_NOT_MAPPED, "Some mapping between account names and SIDs was not done." },
	{ WERR_NO_QUOTAS_FOR_ACCOUNT, "No system quota limits are specifically set for this account." },
	{ WERR_LOCAL_USER_SESSION_KEY, "No encryption key is available. A well-known encryption key was returned." },
	{ WERR_NULL_LM_PASSWORD, "The password is too complex to be converted to a LAN Manager password. The LAN Manager password returned is a null string." },
	{ WERR_UNKNOWN_REVISION, "The revision level is unknown." },
	{ WERR_REVISION_MISMATCH, "Indicates two revision levels are incompatible." },
	{ WERR_INVALID_OWNER, "This SID may not be assigned as the owner of this object." },
	{ WERR_INVALID_PRIMARY_GROUP, "This SID may not be assigned as the primary group of an object." },
	{ WERR_NO_IMPERSONATION_TOKEN, "An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client." },
	{ WERR_CANT_DISABLE_MANDATORY, "The group may not be disabled." },
	{ WERR_NO_LOGON_SERVERS, "There are currently no logon servers available to service the logon request." },
	{ WERR_NO_SUCH_LOGON_SESSION, "A specified logon session does not exist. It may already have been terminated." },
	{ WERR_NO_SUCH_PRIVILEGE, "A specified privilege does not exist." },
	{ WERR_PRIVILEGE_NOT_HELD, "A required privilege is not held by the client." },
	{ WERR_INVALID_ACCOUNT_NAME, "The name provided is not a properly formed account name." },
	{ WERR_USER_EXISTS, "The specified account already exists." },
	{ WERR_NO_SUCH_USER, "The specified account does not exist." },
	{ WERR_GROUP_EXISTS, "The specified group already exists." },
	{ WERR_NO_SUCH_GROUP, "The specified group does not exist." },
	{ WERR_MEMBER_IN_GROUP, "Either the specified user account is already a member of the specified group, or the specified group cannot be deleted because it contains a member." },
	{ WERR_MEMBER_NOT_IN_GROUP, "The specified user account is not a member of the specified group account." },
	{ WERR_LAST_ADMIN, "The last remaining administration account cannot be disabled or deleted." },
	{ WERR_WRONG_PASSWORD, "Unable to update the password. The value provided as the current password is incorrect." },
	{ WERR_ILL_FORMED_PASSWORD, "Unable to update the password. The value provided for the new password contains values that are not allowed in passwords." },
	{ WERR_PASSWORD_RESTRICTION, "Unable to update the password. The value provided for the new password does not meet the length, complexity, or history requirements of the domain." },
	{ WERR_LOGON_FAILURE, "Logon failure: Unknown user name or bad password." },
	{ WERR_ACCOUNT_RESTRICTION, "Logon failure: User account restriction. Possible reasons are blank passwords not allowed, logon hour restrictions, or a policy restriction has been enforced." },
	{ WERR_INVALID_LOGON_HOURS, "Logon failure: Account logon time restriction violation." },
	{ WERR_INVALID_WORKSTATION, "Logon failure: User not allowed to log on to this computer." },
	{ WERR_PASSWORD_EXPIRED, "Logon failure: The specified account password has expired." },
	{ WERR_ACCOUNT_DISABLED, "Logon failure: Account currently disabled." },
	{ WERR_NONE_MAPPED, "No mapping between account names and SIDs was done." },
	{ WERR_TOO_MANY_LUIDS_REQUESTED, "Too many local user identifiers (LUIDs) were requested at one time." },
	{ WERR_LUIDS_EXHAUSTED, "No more LUIDs are available." },
	{ WERR_INVALID_SUB_AUTHORITY, "The sub-authority part of an SID is invalid for this particular use." },
	{ WERR_INVALID_ACL, "The ACL structure is invalid." },
	{ WERR_INVALID_SID, "The SID structure is invalid." },
	{ WERR_INVALID_SECURITY_DESCR, "The security descriptor structure is invalid." },
	{ WERR_BAD_INHERITANCE_ACL, "The inherited ACL or ACE could not be built." },
	{ WERR_SERVER_DISABLED, "The server is currently disabled." },
	{ WERR_SERVER_NOT_DISABLED, "The server is currently enabled." },
	{ WERR_INVALID_ID_AUTHORITY, "The value provided was an invalid value for an identifier authority." },
	{ WERR_ALLOTTED_SPACE_EXCEEDED, "No more memory is available for security information updates." },
	{ WERR_INVALID_GROUP_ATTRIBUTES, "The specified attributes are invalid, or incompatible with the attributes for the group as a whole." },
	{ WERR_BAD_IMPERSONATION_LEVEL, "Either a required impersonation level was not provided, or the provided impersonation level is invalid." },
	{ WERR_CANT_OPEN_ANONYMOUS, "Cannot open an anonymous level security token." },
	{ WERR_BAD_VALIDATION_CLASS, "The validation information class requested was invalid." },
	{ WERR_BAD_TOKEN_TYPE, "The type of the token is inappropriate for its attempted use." },
	{ WERR_NO_SECURITY_ON_OBJECT, "Unable to perform a security operation on an object that has no associated security." },
	{ WERR_CANT_ACCESS_DOMAIN_INFO, "Configuration information could not be read from the domain controller, either because the machine is unavailable, or access has been denied." },
	{ WERR_INVALID_SERVER_STATE, "The SAM or local security authority (LSA) server was in the wrong state to perform the security operation." },
	{ WERR_INVALID_DOMAIN_STATE, "The domain was in the wrong state to perform the security operation." },
	{ WERR_INVALID_DOMAIN_ROLE, "This operation is only allowed for the PDC of the domain." },
	{ WERR_NO_SUCH_DOMAIN, "The specified domain either does not exist or could not be contacted." },
	{ WERR_DOMAIN_EXISTS, "The specified domain already exists." },
	{ WERR_DOMAIN_LIMIT_EXCEEDED, "An attempt was made to exceed the limit on the number of domains per server." },
	{ WERR_INTERNAL_DB_CORRUPTION, "Unable to complete the requested operation because of either a catastrophic media failure or a data structure corruption on the disk." },
	{ WERR_INTERNAL_ERROR, "An internal error occurred." },
	{ WERR_GENERIC_NOT_MAPPED, "Generic access types were contained in an access mask that should already be mapped to nongeneric types." },
	{ WERR_BAD_DESCRIPTOR_FORMAT, "A security descriptor is not in the right format (absolute or self-relative)." },
	{ WERR_NOT_LOGON_PROCESS, "The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process." },
	{ WERR_LOGON_SESSION_EXISTS, "Cannot start a new logon session with an ID that is already in use." },
	{ WERR_NO_SUCH_PACKAGE, "A specified authentication package is unknown." },
	{ WERR_BAD_LOGON_SESSION_STATE, "The logon session is not in a state that is consistent with the requested operation." },
	{ WERR_LOGON_SESSION_COLLISION, "The logon session ID is already in use." },
	{ WERR_INVALID_LOGON_TYPE, "A logon request contained an invalid logon type value." },
	{ WERR_CANNOT_IMPERSONATE, "Unable to impersonate using a named pipe until data has been read from that pipe." },
	{ WERR_RXACT_INVALID_STATE, "The transaction state of a registry subtree is incompatible with the requested operation." },
	{ WERR_RXACT_COMMIT_FAILURE, "An internal security database corruption has been encountered." },
	{ WERR_SPECIAL_ACCOUNT, "Cannot perform this operation on built-in accounts." },
	{ WERR_SPECIAL_GROUP, "Cannot perform this operation on this built-in special group." },
	{ WERR_SPECIAL_USER, "Cannot perform this operation on this built-in special user." },
	{ WERR_MEMBERS_PRIMARY_GROUP, "The user cannot be removed from a group because the group is currently the user\'s primary group." },
	{ WERR_TOKEN_ALREADY_IN_USE, "The token is already in use as a primary token." },
	{ WERR_NO_SUCH_ALIAS, "The specified local group does not exist." },
	{ WERR_MEMBER_NOT_IN_ALIAS, "The specified account name is not a member of the group." },
	{ WERR_MEMBER_IN_ALIAS, "The specified account name is already a member of the group." },
	{ WERR_ALIAS_EXISTS, "The specified local group already exists." },
	{ WERR_LOGON_NOT_GRANTED, "Logon failure: The user has not been granted the requested logon type at this computer." },
	{ WERR_TOO_MANY_SECRETS, "The maximum number of secrets that may be stored in a single system has been exceeded." },
	{ WERR_SECRET_TOO_LONG, "The length of a secret exceeds the maximum length allowed." },
	{ WERR_INTERNAL_DB_ERROR, "The local security authority database contains an internal inconsistency." },
	{ WERR_TOO_MANY_CONTEXT_IDS, "During a logon attempt, the user\'s security context accumulated too many SIDs." },
	{ WERR_LOGON_TYPE_NOT_GRANTED, "Logon failure: The user has not been granted the requested logon type at this computer." },
	{ WERR_NT_CROSS_ENCRYPTION_REQUIRED, "A cross-encrypted password is necessary to change a user password." },
	{ WERR_NO_SUCH_MEMBER, "A member could not be added to or removed from the local group because the member does not exist." },
	{ WERR_INVALID_MEMBER, "A new member could not be added to a local group because the member has the wrong account type." },
	{ WERR_TOO_MANY_SIDS, "Too many SIDs have been specified." },
	{ WERR_LM_CROSS_ENCRYPTION_REQUIRED, "A cross-encrypted password is necessary to change this user password." },
	{ WERR_NO_INHERITANCE, "Indicates an ACL contains no inheritable components." },
	{ WERR_FILE_CORRUPT, "The file or directory is corrupted and unreadable." },
	{ WERR_DISK_CORRUPT, "The disk structure is corrupted and unreadable." },
	{ WERR_NO_USER_SESSION_KEY, "There is no user session key for the specified logon session." },
	{ WERR_LICENSE_QUOTA_EXCEEDED, "The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because the service has accepted the maximum number of connections." },
	{ WERR_WRONG_TARGET_NAME, "Logon failure: The target account name is incorrect." },
	{ WERR_MUTUAL_AUTH_FAILED, "Mutual authentication failed. The server\'s password is out of date at the domain controller." },
	{ WERR_TIME_SKEW, "There is a time and/or date difference between the client and server." },
	{ WERR_CURRENT_DOMAIN_NOT_ALLOWED, "This operation cannot be performed on the current domain." },
	{ WERR_INVALID_WINDOW_HANDLE, "Invalid window handle." },
	{ WERR_INVALID_MENU_HANDLE, "Invalid menu handle." },
	{ WERR_INVALID_CURSOR_HANDLE, "Invalid cursor handle." },
	{ WERR_INVALID_ACCEL_HANDLE, "Invalid accelerator table handle." },
	{ WERR_INVALID_HOOK_HANDLE, "Invalid hook handle." },
	{ WERR_INVALID_DWP_HANDLE, "Invalid handle to a multiple-window position structure." },
	{ WERR_TLW_WITH_WSCHILD, "Cannot create a top-level child window." },
	{ WERR_CANNOT_FIND_WND_CLASS, "Cannot find window class." },
	{ WERR_WINDOW_OF_OTHER_THREAD, "Invalid window; it belongs to other thread." },
	{ WERR_HOTKEY_ALREADY_REGISTERED, "Hot key is already registered." },
	{ WERR_CLASS_ALREADY_EXISTS, "Class already exists." },
	{ WERR_CLASS_DOES_NOT_EXIST, "Class does not exist." },
	{ WERR_CLASS_HAS_WINDOWS, "Class still has open windows." },
	{ WERR_INVALID_INDEX, "Invalid index." },
	{ WERR_INVALID_ICON_HANDLE, "Invalid icon handle." },
	{ WERR_PRIVATE_DIALOG_INDEX, "Using private DIALOG window words." },
	{ WERR_LISTBOX_ID_NOT_FOUND, "The list box identifier was not found." },
	{ WERR_NO_WILDCARD_CHARACTERS, "No wildcards were found." },
	{ WERR_CLIPBOARD_NOT_OPEN, "Thread does not have a clipboard open." },
	{ WERR_HOTKEY_NOT_REGISTERED, "Hot key is not registered." },
	{ WERR_WINDOW_NOT_DIALOG, "The window is not a valid dialog window." },
	{ WERR_CONTROL_ID_NOT_FOUND, "Control ID not found." },
	{ WERR_INVALID_COMBOBOX_MESSAGE, "Invalid message for a combo box because it does not have an edit control." },
	{ WERR_WINDOW_NOT_COMBOBOX, "The window is not a combo box." },
	{ WERR_INVALID_EDIT_HEIGHT, "Height must be less than 256." },
	{ WERR_DC_NOT_FOUND, "Invalid device context (DC) handle." },
	{ WERR_INVALID_HOOK_FILTER, "Invalid hook procedure type." },
	{ WERR_INVALID_FILTER_PROC, "Invalid hook procedure." },
	{ WERR_HOOK_NEEDS_HMOD, "Cannot set nonlocal hook without a module handle." },
	{ WERR_GLOBAL_ONLY_HOOK, "This hook procedure can only be set globally." },
	{ WERR_JOURNAL_HOOK_SET, "The journal hook procedure is already installed." },
	{ WERR_HOOK_NOT_INSTALLED, "The hook procedure is not installed." },
	{ WERR_INVALID_LB_MESSAGE, "Invalid message for single-selection list box." },
	{ WERR_SETCOUNT_ON_BAD_LB, "LB_SETCOUNT sent to non-lazy list box." },
	{ WERR_LB_WITHOUT_TABSTOPS, "This list box does not support tab stops." },
	{ WERR_DESTROY_OBJECT_OF_OTHER_THREAD, "Cannot destroy object created by another thread." },
	{ WERR_CHILD_WINDOW_MENU, "Child windows cannot have menus." },
	{ WERR_NO_SYSTEM_MENU, "The window does not have a system menu." },
	{ WERR_INVALID_MSGBOX_STYLE, "Invalid message box style." },
	{ WERR_INVALID_SPI_VALUE, "Invalid system-wide (SPI_*) parameter." },
	{ WERR_SCREEN_ALREADY_LOCKED, "Screen already locked." },
	{ WERR_HWNDS_HAVE_DIFF_PARENT, "All handles to windows in a multiple-window position structure must have the same parent." },
	{ WERR_NOT_CHILD_WINDOW, "The window is not a child window." },
	{ WERR_INVALID_GW_COMMAND, "Invalid GW_* command." },
	{ WERR_INVALID_THREAD_ID, "Invalid thread identifier." },
	{ WERR_NON_MDICHILD_WINDOW, "Cannot process a message from a window that is not a multiple document interface (MDI) window." },
	{ WERR_POPUP_ALREADY_ACTIVE, "Pop-up menu already active." },
	{ WERR_NO_SCROLLBARS, "The window does not have scroll bars." },
	{ WERR_INVALID_SCROLLBAR_RANGE, "Scroll bar range cannot be greater than MAXLONG." },
	{ WERR_INVALID_SHOWWIN_COMMAND, "Cannot show or remove the window in the way specified." },
	{ WERR_NO_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service." },
	{ WERR_NONPAGED_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service." },
	{ WERR_PAGED_SYSTEM_RESOURCES, "Insufficient system resources exist to complete the requested service." },
	{ WERR_WORKING_SET_QUOTA, "Insufficient quota to complete the requested service." },
	{ WERR_PAGEFILE_QUOTA, "Insufficient quota to complete the requested service." },
	{ WERR_COMMITMENT_LIMIT, "The paging file is too small for this operation to complete." },
	{ WERR_MENU_ITEM_NOT_FOUND, "A menu item was not found." },
	{ WERR_INVALID_KEYBOARD_HANDLE, "Invalid keyboard layout handle." },
	{ WERR_HOOK_TYPE_NOT_ALLOWED, "Hook type not allowed." },
	{ WERR_REQUIRES_INTERACTIVE_WINDOWSTATION, "This operation requires an interactive window station." },
	{ WERR_TIMEOUT, "This operation returned because the time-out period expired." },
	{ WERR_INVALID_MONITOR_HANDLE, "Invalid monitor handle." },
	{ WERR_INCORRECT_SIZE, "Incorrect size argument." },
	{ WERR_SYMLINK_CLASS_DISABLED, "The symbolic link cannot be followed because its type is disabled." },
	{ WERR_SYMLINK_NOT_SUPPORTED, "This application does not support the current operation on symbolic links." },
	{ WERR_EVENTLOG_FILE_CORRUPT, "The event log file is corrupted." },
	{ WERR_EVENTLOG_CANT_START, "No event log file could be opened, so the event logging service did not start." },
	{ WERR_LOG_FILE_FULL, "The event log file is full." },
	{ WERR_EVENTLOG_FILE_CHANGED, "The event log file has changed between read operations." },
	{ WERR_INVALID_TASK_NAME, "The specified task name is invalid." },
	{ WERR_INVALID_TASK_INDEX, "The specified task index is invalid." },
	{ WERR_THREAD_ALREADY_IN_TASK, "The specified thread is already joining a task." },
	{ WERR_INSTALL_SERVICE_FAILURE, "The Windows Installer service could not be accessed. This can occur if the Windows Installer is not correctly installed. Contact your support personnel for assistance." },
	{ WERR_INSTALL_USEREXIT, "User canceled installation." },
	{ WERR_INSTALL_FAILURE, "Fatal error during installation." },
	{ WERR_INSTALL_SUSPEND, "Installation suspended, incomplete." },
	{ WERR_UNKNOWN_PRODUCT, "This action is valid only for products that are currently installed." },
	{ WERR_UNKNOWN_FEATURE, "Feature ID not registered." },
	{ WERR_UNKNOWN_COMPONENT, "Component ID not registered." },
	{ WERR_UNKNOWN_PROPERTY, "Unknown property." },
	{ WERR_INVALID_HANDLE_STATE, "Handle is in an invalid state." },
	{ WERR_BAD_CONFIGURATION, "The configuration data for this product is corrupt. Contact your support personnel." },
	{ WERR_INDEX_ABSENT, "Component qualifier not present." },
	{ WERR_INSTALL_SOURCE_ABSENT, "The installation source for this product is not available. Verify that the source exists and that you can access it." },
	{ WERR_INSTALL_PACKAGE_VERSION, "This installation package cannot be installed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service." },
	{ WERR_PRODUCT_UNINSTALLED, "Product is uninstalled." },
	{ WERR_BAD_QUERY_SYNTAX, "SQL query syntax invalid or unsupported." },
	{ WERR_INVALID_FIELD, "Record field does not exist." },
	{ WERR_DEVICE_REMOVED, "The device has been removed." },
	{ WERR_INSTALL_ALREADY_RUNNING, "Another installation is already in progress. Complete that installation before proceeding with this install." },
	{ WERR_INSTALL_PACKAGE_OPEN_FAILED, "This installation package could not be opened. Verify that the package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer package." },
	{ WERR_INSTALL_PACKAGE_INVALID, "This installation package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer package." },
	{ WERR_INSTALL_UI_FAILURE, "There was an error starting the Windows Installer service user interface. Contact your support personnel." },
	{ WERR_INSTALL_LOG_FAILURE, "Error opening installation log file. Verify that the specified log file location exists and that you can write to it." },
	{ WERR_INSTALL_LANGUAGE_UNSUPPORTED, "The language of this installation package is not supported by your system." },
	{ WERR_INSTALL_TRANSFORM_FAILURE, "Error applying transforms. Verify that the specified transform paths are valid." },
	{ WERR_INSTALL_PACKAGE_REJECTED, "This installation is forbidden by system policy. Contact your system administrator." },
	{ WERR_FUNCTION_NOT_CALLED, "Function could not be executed." },
	{ WERR_FUNCTION_FAILED, "Function failed during execution." },
	{ WERR_INVALID_TABLE, "Invalid or unknown table specified." },
	{ WERR_DATATYPE_MISMATCH, "Data supplied is of wrong type." },
	{ WERR_UNSUPPORTED_TYPE, "Data of this type is not supported." },
	{ WERR_CREATE_FAILED, "The Windows Installer service failed to start. Contact your support personnel." },
	{ WERR_INSTALL_TEMP_UNWRITABLE, "The Temp folder is on a drive that is full or is inaccessible. Free up space on the drive or verify that you have write permission on the Temp folder." },
	{ WERR_INSTALL_PLATFORM_UNSUPPORTED, "This installation package is not supported by this processor type. Contact your product vendor." },
	{ WERR_INSTALL_NOTUSED, "Component not used on this computer." },
	{ WERR_PATCH_PACKAGE_OPEN_FAILED, "This update package could not be opened. Verify that the update package exists and that you can access it, or contact the application vendor to verify that this is a valid Windows Installer update package." },
	{ WERR_PATCH_PACKAGE_INVALID, "This update package could not be opened. Contact the application vendor to verify that this is a valid Windows Installer update package." },
	{ WERR_PATCH_PACKAGE_UNSUPPORTED, "This update package cannot be processed by the Windows Installer service. You must install a Windows service pack that contains a newer version of the Windows Installer service." },
	{ WERR_PRODUCT_VERSION, "Another version of this product is already installed. Installation of this version cannot continue. To configure or remove the existing version of this product, use Add/Remove Programs in Control Panel." },
	{ WERR_INVALID_COMMAND_LINE, "Invalid command-line argument. Consult the Windows Installer SDK for detailed command line help." },
	{ WERR_INSTALL_REMOTE_DISALLOWED, "Only administrators have permission to add, remove, or configure server software during a Terminal Services remote session. If you want to install or configure software on the server, contact your network administrator." },
	{ WERR_SUCCESS_REBOOT_INITIATED, "The requested operation completed successfully. The system will be restarted so the changes can take effect." },
	{ WERR_PATCH_TARGET_NOT_FOUND, "The upgrade cannot be installed by the Windows Installer service because the program to be upgraded may be missing, or the upgrade may update a different version of the program. Verify that the program to be upgraded exists on your computer and that you have the correct upgrade." },
	{ WERR_PATCH_PACKAGE_REJECTED, "The update package is not permitted by a software restriction policy." },
	{ WERR_INSTALL_TRANSFORM_REJECTED, "One or more customizations are not permitted by a software restriction policy." },
	{ WERR_INSTALL_REMOTE_PROHIBITED, "The Windows Installer does not permit installation from a Remote Desktop Connection." },
	{ WERR_PATCH_REMOVAL_UNSUPPORTED, "Uninstallation of the update package is not supported." },
	{ WERR_UNKNOWN_PATCH, "The update is not applied to this product." },
	{ WERR_PATCH_NO_SEQUENCE, "No valid sequence could be found for the set of updates." },
	{ WERR_PATCH_REMOVAL_DISALLOWED, "Update removal was disallowed by policy." },
	{ WERR_INVALID_PATCH_XML, "The XML update data is invalid." },
	{ WERR_PATCH_MANAGED_ADVERTISED_PRODUCT, "Windows Installer does not permit updating of managed advertised products. At least one feature of the product must be installed before applying the update." },
	{ WERR_INSTALL_SERVICE_SAFEBOOT, "The Windows Installer service is not accessible in Safe Mode. Try again when your computer is not in Safe Mode or you can use System Restore to return your machine to a previous good state." },
	{ WERR_RPC_S_INVALID_STRING_BINDING, "The string binding is invalid." },
	{ WERR_RPC_S_WRONG_KIND_OF_BINDING, "The binding handle is not the correct type." },
	{ WERR_RPC_S_INVALID_BINDING, "The binding handle is invalid." },
	{ WERR_RPC_S_PROTSEQ_NOT_SUPPORTED, "The RPC protocol sequence is not supported." },
	{ WERR_RPC_S_INVALID_RPC_PROTSEQ, "The RPC protocol sequence is invalid." },
	{ WERR_RPC_S_INVALID_STRING_UUID, "The string UUID is invalid." },
	{ WERR_RPC_S_INVALID_ENDPOINT_FORMAT, "The endpoint format is invalid." },
	{ WERR_RPC_S_INVALID_NET_ADDR, "The network address is invalid." },
	{ WERR_RPC_S_NO_ENDPOINT_FOUND, "No endpoint was found." },
	{ WERR_RPC_S_INVALID_TIMEOUT, "The time-out value is invalid." },
	{ WERR_RPC_S_OBJECT_NOT_FOUND, "The object UUID) was not found." },
	{ WERR_RPC_S_ALREADY_REGISTERED, "The object UUID) has already been registered." },
	{ WERR_RPC_S_TYPE_ALREADY_REGISTERED, "The type UUID has already been registered." },
	{ WERR_RPC_S_ALREADY_LISTENING, "The RPC server is already listening." },
	{ WERR_RPC_S_NO_PROTSEQS_REGISTERED, "No protocol sequences have been registered." },
	{ WERR_RPC_S_NOT_LISTENING, "The RPC server is not listening." },
	{ WERR_RPC_S_UNKNOWN_MGR_TYPE, "The manager type is unknown." },
	{ WERR_RPC_S_UNKNOWN_IF, "The interface is unknown." },
	{ WERR_RPC_S_NO_BINDINGS, "There are no bindings." },
	{ WERR_RPC_S_NO_PROTSEQS, "There are no protocol sequences." },
	{ WERR_RPC_S_CANT_CREATE_ENDPOINT, "The endpoint cannot be created." },
	{ WERR_RPC_S_OUT_OF_RESOURCES, "Not enough resources are available to complete this operation." },
	{ WERR_RPC_S_SERVER_UNAVAILABLE, "The RPC server is unavailable." },
	{ WERR_RPC_S_SERVER_TOO_BUSY, "The RPC server is too busy to complete this operation." },
	{ WERR_RPC_S_INVALID_NETWORK_OPTIONS, "The network options are invalid." },
	{ WERR_RPC_S_NO_CALL_ACTIVE, "There are no RPCs active on this thread." },
	{ WERR_RPC_S_CALL_FAILED, "The RPC failed." },
	{ WERR_RPC_S_CALL_FAILED_DNE, "The RPC failed and did not execute." },
	{ WERR_RPC_S_PROTOCOL_ERROR, "An RPC protocol error occurred." },
	{ WERR_RPC_S_PROXY_ACCESS_DENIED, "Access to the HTTP proxy is denied." },
	{ WERR_RPC_S_UNSUPPORTED_TRANS_SYN, "The transfer syntax is not supported by the RPC server." },
	{ WERR_RPC_S_UNSUPPORTED_TYPE, "The UUID type is not supported." },
	{ WERR_RPC_S_INVALID_TAG, "The tag is invalid." },
	{ WERR_RPC_S_INVALID_BOUND, "The array bounds are invalid." },
	{ WERR_RPC_S_NO_ENTRY_NAME, "The binding does not contain an entry name." },
	{ WERR_RPC_S_INVALID_NAME_SYNTAX, "The name syntax is invalid." },
	{ WERR_RPC_S_UNSUPPORTED_NAME_SYNTAX, "The name syntax is not supported." },
	{ WERR_RPC_S_UUID_NO_ADDRESS, "No network address is available to use to construct a UUID." },
	{ WERR_RPC_S_DUPLICATE_ENDPOINT, "The endpoint is a duplicate." },
	{ WERR_RPC_S_UNKNOWN_AUTHN_TYPE, "The authentication type is unknown." },
	{ WERR_RPC_S_MAX_CALLS_TOO_SMALL, "The maximum number of calls is too small." },
	{ WERR_RPC_S_STRING_TOO_LONG, "The string is too long." },
	{ WERR_RPC_S_PROTSEQ_NOT_FOUND, "The RPC protocol sequence was not found." },
	{ WERR_RPC_S_PROCNUM_OUT_OF_RANGE, "The procedure number is out of range." },
	{ WERR_RPC_S_BINDING_HAS_NO_AUTH, "The binding does not contain any authentication information." },
	{ WERR_RPC_S_UNKNOWN_AUTHN_SERVICE, "The authentication service is unknown." },
	{ WERR_RPC_S_UNKNOWN_AUTHN_LEVEL, "The authentication level is unknown." },
	{ WERR_RPC_S_INVALID_AUTH_IDENTITY, "The security context is invalid." },
	{ WERR_RPC_S_UNKNOWN_AUTHZ_SERVICE, "The authorization service is unknown." },
	{ WERR_EPT_S_INVALID_ENTRY, "The entry is invalid." },
	{ WERR_EPT_S_CANT_PERFORM_OP, "The server endpoint cannot perform the operation." },
	{ WERR_EPT_S_NOT_REGISTERED, "There are no more endpoints available from the endpoint mapper." },
	{ WERR_RPC_S_NOTHING_TO_EXPORT, "No interfaces have been exported." },
	{ WERR_RPC_S_INCOMPLETE_NAME, "The entry name is incomplete." },
	{ WERR_RPC_S_INVALID_VERS_OPTION, "The version option is invalid." },
	{ WERR_RPC_S_NO_MORE_MEMBERS, "There are no more members." },
	{ WERR_RPC_S_NOT_ALL_OBJS_UNEXPORTED, "There is nothing to unexport." },
	{ WERR_RPC_S_INTERFACE_NOT_FOUND, "The interface was not found." },
	{ WERR_RPC_S_ENTRY_ALREADY_EXISTS, "The entry already exists." },
	{ WERR_RPC_S_ENTRY_NOT_FOUND, "The entry is not found." },
	{ WERR_RPC_S_NAME_SERVICE_UNAVAILABLE, "The name service is unavailable." },
	{ WERR_RPC_S_INVALID_NAF_ID, "The network address family is invalid." },
	{ WERR_RPC_S_CANNOT_SUPPORT, "The requested operation is not supported." },
	{ WERR_RPC_S_NO_CONTEXT_AVAILABLE, "No security context is available to allow impersonation." },
	{ WERR_RPC_S_INTERNAL_ERROR, "An internal error occurred in an RPC." },
	{ WERR_RPC_S_ZERO_DIVIDE, "The RPC server attempted an integer division by zero." },
	{ WERR_RPC_S_ADDRESS_ERROR, "An addressing error occurred in the RPC server." },
	{ WERR_RPC_S_FP_DIV_ZERO, "A floating-point operation at the RPC server caused a division by zero." },
	{ WERR_RPC_S_FP_UNDERFLOW, "A floating-point underflow occurred at the RPC server." },
	{ WERR_RPC_S_FP_OVERFLOW, "A floating-point overflow occurred at the RPC server." },
	{ WERR_RPC_X_NO_MORE_ENTRIES, "The list of RPC servers available for the binding of auto handles has been exhausted." },
	{ WERR_RPC_X_SS_CHAR_TRANS_OPEN_FAIL, "Unable to open the character translation table file." },
	{ WERR_RPC_X_SS_CHAR_TRANS_SHORT_FILE, "The file containing the character translation table has fewer than 512 bytes." },
	{ WERR_RPC_X_SS_IN_NULL_CONTEXT, "A null context handle was passed from the client to the host during an RPC." },
	{ WERR_RPC_X_SS_CONTEXT_DAMAGED, "The context handle changed during an RPC." },
	{ WERR_RPC_X_SS_HANDLES_MISMATCH, "The binding handles passed to an RPC do not match." },
	{ WERR_RPC_X_SS_CANNOT_GET_CALL_HANDLE, "The stub is unable to get the RPC handle." },
	{ WERR_RPC_X_NULL_REF_POINTER, "A null reference pointer was passed to the stub." },
	{ WERR_RPC_X_ENUM_VALUE_OUT_OF_RANGE, "The enumeration value is out of range." },
	{ WERR_RPC_X_BYTE_COUNT_TOO_SMALL, "The byte count is too small." },
	{ WERR_RPC_X_BAD_STUB_DATA, "The stub received bad data." },
	{ WERR_INVALID_USER_BUFFER, "The supplied user buffer is not valid for the requested operation." },
	{ WERR_UNRECOGNIZED_MEDIA, "The disk media is not recognized. It may not be formatted." },
	{ WERR_NO_TRUST_LSA_SECRET, "The workstation does not have a trust secret." },
	{ WERR_NO_TRUST_SAM_ACCOUNT, "The security database on the server does not have a computer account for this workstation trust relationship." },
	{ WERR_TRUSTED_DOMAIN_FAILURE, "The trust relationship between the primary domain and the trusted domain failed." },
	{ WERR_TRUSTED_RELATIONSHIP_FAILURE, "The trust relationship between this workstation and the primary domain failed." },
	{ WERR_TRUST_FAILURE, "The network logon failed." },
	{ WERR_RPC_S_CALL_IN_PROGRESS, "An RPC is already in progress for this thread." },
	{ WERR_NETLOGON_NOT_STARTED, "An attempt was made to log on, but the network logon service was not started." },
	{ WERR_ACCOUNT_EXPIRED, "The user\'s account has expired." },
	{ WERR_REDIRECTOR_HAS_OPEN_HANDLES, "The redirector is in use and cannot be unloaded." },
	{ WERR_PRINTER_DRIVER_ALREADY_INSTALLED, "The specified printer driver is already installed." },
	{ WERR_UNKNOWN_PORT, "The specified port is unknown." },
	{ WERR_UNKNOWN_PRINTER_DRIVER, "The printer driver is unknown." },
	{ WERR_UNKNOWN_PRINTPROCESSOR, "The print processor is unknown." },
	{ WERR_INVALID_SEPARATOR_FILE, "The specified separator file is invalid." },
	{ WERR_INVALID_PRIORITY, "The specified priority is invalid." },
	{ WERR_INVALID_PRINTER_NAME, "The printer name is invalid." },
	{ WERR_PRINTER_ALREADY_EXISTS, "The printer already exists." },
	{ WERR_INVALID_PRINTER_COMMAND, "The printer command is invalid." },
	{ WERR_INVALID_DATATYPE, "The specified data type is invalid." },
	{ WERR_INVALID_ENVIRONMENT, "The environment specified is invalid." },
	{ WERR_RPC_S_NO_MORE_BINDINGS, "There are no more bindings." },
	{ WERR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT, "The account used is an interdomain trust account. Use your global user account or local user account to access this server." },
	{ WERR_NOLOGON_WORKSTATION_TRUST_ACCOUNT, "The account used is a computer account. Use your global user account or local user account to access this server." },
	{ WERR_NOLOGON_SERVER_TRUST_ACCOUNT, "The account used is a server trust account. Use your global user account or local user account to access this server." },
	{ WERR_DOMAIN_TRUST_INCONSISTENT, "The name or SID of the domain specified is inconsistent with the trust information for that domain." },
	{ WERR_SERVER_HAS_OPEN_HANDLES, "The server is in use and cannot be unloaded." },
	{ WERR_RESOURCE_DATA_NOT_FOUND, "The specified image file did not contain a resource section." },
	{ WERR_RESOURCE_TYPE_NOT_FOUND, "The specified resource type cannot be found in the image file." },
	{ WERR_RESOURCE_NAME_NOT_FOUND, "The specified resource name cannot be found in the image file." },
	{ WERR_RESOURCE_LANG_NOT_FOUND, "The specified resource language ID cannot be found in the image file." },
	{ WERR_NOT_ENOUGH_QUOTA, "Not enough quota is available to process this command." },
	{ WERR_RPC_S_NO_INTERFACES, "No interfaces have been registered." },
	{ WERR_RPC_S_CALL_CANCELLED, "The RPC was canceled." },
	{ WERR_RPC_S_BINDING_INCOMPLETE, "The binding handle does not contain all the required information." },
	{ WERR_RPC_S_COMM_FAILURE, "A communications failure occurred during an RPC." },
	{ WERR_RPC_S_UNSUPPORTED_AUTHN_LEVEL, "The requested authentication level is not supported." },
	{ WERR_RPC_S_NO_PRINC_NAME, "No principal name is registered." },
	{ WERR_RPC_S_NOT_RPC_ERROR, "The error specified is not a valid Windows RPC error code." },
	{ WERR_RPC_S_UUID_LOCAL_ONLY, "A UUID that is valid only on this computer has been allocated." },
	{ WERR_RPC_S_SEC_PKG_ERROR, "A security package-specific error occurred." },
	{ WERR_RPC_S_NOT_CANCELLED, "The thread is not canceled." },
	{ WERR_RPC_X_INVALID_ES_ACTION, "Invalid operation on the encoding/decoding handle." },
	{ WERR_RPC_X_WRONG_ES_VERSION, "Incompatible version of the serializing package." },
	{ WERR_RPC_X_WRONG_STUB_VERSION, "Incompatible version of the RPC stub." },
	{ WERR_RPC_X_INVALID_PIPE_OBJECT, "The RPC pipe object is invalid or corrupted." },
	{ WERR_RPC_X_WRONG_PIPE_ORDER, "An invalid operation was attempted on an RPC pipe object." },
	{ WERR_RPC_X_WRONG_PIPE_VERSION, "Unsupported RPC pipe version." },
	{ WERR_RPC_S_GROUP_MEMBER_NOT_FOUND, "The group member was not found." },
	{ WERR_EPT_S_CANT_CREATE, "The endpoint mapper database entry could not be created." },
	{ WERR_RPC_S_INVALID_OBJECT, "The object UUID is the nil UUID." },
	{ WERR_INVALID_TIME, "The specified time is invalid." },
	{ WERR_INVALID_FORM_NAME, "The specified form name is invalid." },
	{ WERR_INVALID_FORM_SIZE, "The specified form size is invalid." },
	{ WERR_ALREADY_WAITING, "The specified printer handle is already being waited on." },
	{ WERR_PRINTER_DELETED, "The specified printer has been deleted." },
	{ WERR_INVALID_PRINTER_STATE, "The state of the printer is invalid." },
	{ WERR_PASSWORD_MUST_CHANGE, "The user\'s password must be changed before logging on the first time." },
	{ WERR_DOMAIN_CONTROLLER_NOT_FOUND, "Could not find the domain controller for this domain." },
	{ WERR_ACCOUNT_LOCKED_OUT, "The referenced account is currently locked out and may not be logged on to." },
	{ WERR_OR_INVALID_OXID, "The object exporter specified was not found." },
	{ WERR_OR_INVALID_OID, "The object specified was not found." },
	{ WERR_OR_INVALID_SET, "The object set specified was not found." },
	{ WERR_RPC_S_SEND_INCOMPLETE, "Some data remains to be sent in the request buffer." },
	{ WERR_RPC_S_INVALID_ASYNC_HANDLE, "Invalid asynchronous RPC handle." },
	{ WERR_RPC_S_INVALID_ASYNC_CALL, "Invalid asynchronous RPC call handle for this operation." },
	{ WERR_RPC_X_PIPE_CLOSED, "The RPC pipe object has already been closed." },
	{ WERR_RPC_X_PIPE_DISCIPLINE_ERROR, "The RPC call completed before all pipes were processed." },
	{ WERR_RPC_X_PIPE_EMPTY, "No more data is available from the RPC pipe." },
	{ WERR_NO_SITENAME, "No site name is available for this machine." },
	{ WERR_CANT_ACCESS_FILE, "The file cannot be accessed by the system." },
	{ WERR_CANT_RESOLVE_FILENAME, "The name of the file cannot be resolved by the system." },
	{ WERR_RPC_S_ENTRY_TYPE_MISMATCH, "The entry is not of the expected type." },
	{ WERR_RPC_S_NOT_ALL_OBJS_EXPORTED, "Not all object UUIDs could be exported to the specified entry." },
	{ WERR_RPC_S_INTERFACE_NOT_EXPORTED, "The interface could not be exported to the specified entry." },
	{ WERR_RPC_S_PROFILE_NOT_ADDED, "The specified profile entry could not be added." },
	{ WERR_RPC_S_PRF_ELT_NOT_ADDED, "The specified profile element could not be added." },
	{ WERR_RPC_S_PRF_ELT_NOT_REMOVED, "The specified profile element could not be removed." },
	{ WERR_RPC_S_GRP_ELT_NOT_ADDED, "The group element could not be added." },
	{ WERR_RPC_S_GRP_ELT_NOT_REMOVED, "The group element could not be removed." },
	{ WERR_KM_DRIVER_BLOCKED, "The printer driver is not compatible with a policy enabled on your computer that blocks Windows NT 4.0 drivers." },
	{ WERR_CONTEXT_EXPIRED, "The context has expired and can no longer be used." },
	{ WERR_PER_USER_TRUST_QUOTA_EXCEEDED, "The current user\'s delegated trust creation quota has been exceeded." },
	{ WERR_ALL_USER_TRUST_QUOTA_EXCEEDED, "The total delegated trust creation quota has been exceeded." },
	{ WERR_USER_DELETE_TRUST_QUOTA_EXCEEDED, "The current user\'s delegated trust deletion quota has been exceeded." },
	{ WERR_AUTHENTICATION_FIREWALL_FAILED, "Logon failure: The machine you are logging on to is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine." },
	{ WERR_REMOTE_PRINT_CONNECTIONS_BLOCKED, "Remote connections to the Print Spooler are blocked by a policy set on your machine." },
	{ WERR_INVALID_PIXEL_FORMAT, "The pixel format is invalid." },
	{ WERR_BAD_DRIVER, "The specified driver is invalid." },
	{ WERR_INVALID_WINDOW_STYLE, "The window style or class attribute is invalid for this operation." },
	{ WERR_METAFILE_NOT_SUPPORTED, "The requested metafile operation is not supported." },
	{ WERR_TRANSFORM_NOT_SUPPORTED, "The requested transformation operation is not supported." },
	{ WERR_CLIPPING_NOT_SUPPORTED, "The requested clipping operation is not supported." },
	{ WERR_INVALID_CMM, "The specified color management module is invalid." },
	{ WERR_INVALID_PROFILE, "The specified color profile is invalid." },
	{ WERR_TAG_NOT_FOUND, "The specified tag was not found." },
	{ WERR_TAG_NOT_PRESENT, "A required tag is not present." },
	{ WERR_DUPLICATE_TAG, "The specified tag is already present." },
	{ WERR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE, "The specified color profile is not associated with any device." },
	{ WERR_PROFILE_NOT_FOUND, "The specified color profile was not found." },
	{ WERR_INVALID_COLORSPACE, "The specified color space is invalid." },
	{ WERR_ICM_NOT_ENABLED, "Image Color Management is not enabled." },
	{ WERR_DELETING_ICM_XFORM, "There was an error while deleting the color transform." },
	{ WERR_INVALID_TRANSFORM, "The specified color transform is invalid." },
	{ WERR_COLORSPACE_MISMATCH, "The specified transform does not match the bitmap\'s color space." },
	{ WERR_INVALID_COLORINDEX, "The specified named color index is not present in the profile." },
	{ WERR_PROFILE_DOES_NOT_MATCH_DEVICE, "The specified profile is intended for a device of a different type than the specified device." },
	{ WERR_NERR_NETNOTSTARTED, "The workstation driver is not installed." },
	{ WERR_NERR_UNKNOWNSERVER, "The server could not be located." },
	{ WERR_NERR_SHAREMEM, "An internal error occurred. The network cannot access a shared memory segment." },
	{ WERR_NERR_NONETWORKRESOURCE, "A network resource shortage occurred." },
	{ WERR_NERR_REMOTEONLY, "This operation is not supported on workstations." },
	{ WERR_NERR_DEVNOTREDIRECTED, "The device is not connected." },
	{ WERR_CONNECTED_OTHER_PASSWORD, "The network connection was made successfully, but the user had to be prompted for a password other than the one originally specified." },
	{ WERR_CONNECTED_OTHER_PASSWORD_DEFAULT, "The network connection was made successfully using default credentials." },
	{ WERR_NERR_SERVERNOTSTARTED, "The Server service is not started." },
	{ WERR_NERR_ITEMNOTFOUND, "The queue is empty." },
	{ WERR_NERR_UNKNOWNDEVDIR, "The device or directory does not exist." },
	{ WERR_NERR_REDIRECTEDPATH, "The operation is invalid on a redirected resource." },
	{ WERR_NERR_DUPLICATESHARE, "The name has already been shared." },
	{ WERR_NERR_NOROOM, "The server is currently out of the requested resource." },
	{ WERR_NERR_TOOMANYITEMS, "Requested addition of items exceeds the maximum allowed." },
	{ WERR_NERR_INVALIDMAXUSERS, "The Peer service supports only two simultaneous users." },
	{ WERR_NERR_BUFTOOSMALL, "The API return buffer is too small." },
	{ WERR_NERR_REMOTEERR, "A remote API error occurred." },
	{ WERR_NERR_LANMANINIERROR, "An error occurred when opening or reading the configuration file." },
	{ WERR_NERR_NETWORKERROR, "A general network error occurred." },
	{ WERR_NERR_WKSTAINCONSISTENTSTATE, "The Workstation service is in an inconsistent state. Restart the computer before restarting the Workstation service." },
	{ WERR_NERR_WKSTANOTSTARTED, "The Workstation service has not been started." },
	{ WERR_NERR_BROWSERNOTSTARTED, "The requested information is not available." },
	{ WERR_NERR_INTERNALERROR, "An internal error occurred." },
	{ WERR_NERR_BADTRANSACTCONFIG, "The server is not configured for transactions." },
	{ WERR_NERR_INVALIDAPI, "The requested API is not supported on the remote server." },
	{ WERR_NERR_BADEVENTNAME, "The event name is invalid." },
	{ WERR_NERR_DUPNAMEREBOOT, "The computer name already exists on the network. Change it and reboot the computer." },
	{ WERR_NERR_CFGCOMPNOTFOUND, "The specified component could not be found in the configuration information." },
	{ WERR_NERR_CFGPARAMNOTFOUND, "The specified parameter could not be found in the configuration information." },
	{ WERR_NERR_LINETOOLONG, "A line in the configuration file is too long." },
	{ WERR_NERR_QNOTFOUND, "The printer does not exist." },
	{ WERR_NERR_JOBNOTFOUND, "The print job does not exist." },
	{ WERR_NERR_DESTNOTFOUND, "The printer destination cannot be found." },
	{ WERR_NERR_DESTEXISTS, "The printer destination already exists." },
	{ WERR_NERR_QEXISTS, "The print queue already exists." },
	{ WERR_NERR_QNOROOM, "No more printers can be added." },
	{ WERR_NERR_JOBNOROOM, "No more print jobs can be added." },
	{ WERR_NERR_DESTNOROOM, "No more printer destinations can be added." },
	{ WERR_NERR_DESTIDLE, "This printer destination is idle and cannot accept control operations." },
	{ WERR_NERR_DESTINVALIDOP, "This printer destination request contains an invalid control function." },
	{ WERR_NERR_PROCNORESPOND, "The print processor is not responding." },
	{ WERR_NERR_SPOOLERNOTLOADED, "The spooler is not running." },
	{ WERR_NERR_DESTINVALIDSTATE, "This operation cannot be performed on the print destination in its current state." },
	{ WERR_NERR_QINVALIDSTATE, "This operation cannot be performed on the print queue in its current state." },
	{ WERR_NERR_JOBINVALIDSTATE, "This operation cannot be performed on the print job in its current state." },
	{ WERR_NERR_SPOOLNOMEMORY, "A spooler memory allocation failure occurred." },
	{ WERR_NERR_DRIVERNOTFOUND, "The device driver does not exist." },
	{ WERR_NERR_DATATYPEINVALID, "The data type is not supported by the print processor." },
	{ WERR_NERR_PROCNOTFOUND, "The print processor is not installed." },
	{ WERR_NERR_SERVICETABLELOCKED, "The service database is locked." },
	{ WERR_NERR_SERVICETABLEFULL, "The service table is full." },
	{ WERR_NERR_SERVICEINSTALLED, "The requested service has already been started." },
	{ WERR_NERR_SERVICEENTRYLOCKED, "The service does not respond to control actions." },
	{ WERR_NERR_SERVICENOTINSTALLED, "The service has not been started." },
	{ WERR_NERR_BADSERVICENAME, "The service name is invalid." },
	{ WERR_NERR_SERVICECTLTIMEOUT, "The service is not responding to the control function." },
	{ WERR_NERR_SERVICECTLBUSY, "The service control is busy." },
	{ WERR_NERR_BADSERVICEPROGNAME, "The configuration file contains an invalid service program name." },
	{ WERR_NERR_SERVICENOTCTRL, "The service could not be controlled in its present state." },
	{ WERR_NERR_SERVICEKILLPROC, "The service ended abnormally." },
	{ WERR_NERR_SERVICECTLNOTVALID, "The requested pause or stop is not valid for this service." },
	{ WERR_NERR_NOTINDISPATCHTBL, "The service control dispatcher could not find the service name in the dispatch table." },
	{ WERR_NERR_BADCONTROLRECV, "The service control dispatcher pipe read failed." },
	{ WERR_NERR_SERVICENOTSTARTING, "A thread for the new service could not be created." },
	{ WERR_NERR_ALREADYLOGGEDON, "This workstation is already logged on to the LAN." },
	{ WERR_NERR_NOTLOGGEDON, "The workstation is not logged on to the LAN." },
	{ WERR_NERR_BADUSERNAME, "The user name or group name parameter is invalid." },
	{ WERR_NERR_BADPASSWORD, "The password parameter is invalid." },
	{ WERR_NERR_UNABLETOADDNAME_W, "The logon processor did not add the message alias." },
	{ WERR_NERR_UNABLETOADDNAME_F, "The logon processor did not add the message alias." },
	{ WERR_NERR_UNABLETODELNAME_W, "@W The logoff processor did not delete the message alias." },
	{ WERR_NERR_UNABLETODELNAME_F, "The logoff processor did not delete the message alias." },
	{ WERR_NERR_LOGONSPAUSED, "Network logons are paused." },
	{ WERR_NERR_LOGONSERVERCONFLICT, "A centralized logon server conflict occurred." },
	{ WERR_NERR_LOGONNOUSERPATH, "The server is configured without a valid user path." },
	{ WERR_NERR_LOGONSCRIPTERROR, "An error occurred while loading or running the logon script." },
	{ WERR_NERR_STANDALONELOGON, "The logon server was not specified. The computer will be logged on as STANDALONE." },
	{ WERR_NERR_LOGONSERVERNOTFOUND, "The logon server could not be found." },
	{ WERR_NERR_LOGONDOMAINEXISTS, "There is already a logon domain for this computer." },
	{ WERR_NERR_NONVALIDATEDLOGON, "The logon server could not validate the logon." },
	{ WERR_NERR_ACFNOTFOUND, "The security database could not be found." },
	{ WERR_NERR_GROUPNOTFOUND, "The group name could not be found." },
	{ WERR_NERR_USERNOTFOUND, "The user name could not be found." },
	{ WERR_NERR_RESOURCENOTFOUND, "The resource name could not be found." },
	{ WERR_NERR_GROUPEXISTS, "The group already exists." },
	{ WERR_NERR_USEREXISTS, "The user account already exists." },
	{ WERR_NERR_RESOURCEEXISTS, "The resource permission list already exists." },
	{ WERR_NERR_NOTPRIMARY, "This operation is allowed only on the PDC of the domain." },
	{ WERR_NERR_ACFNOTLOADED, "The security database has not been started." },
	{ WERR_NERR_ACFNOROOM, "There are too many names in the user accounts database." },
	{ WERR_NERR_ACFFILEIOFAIL, "A disk I/O failure occurred." },
	{ WERR_NERR_ACFTOOMANYLISTS, "The limit of 64 entries per resource was exceeded." },
	{ WERR_NERR_USERLOGON, "Deleting a user with a session is not allowed." },
	{ WERR_NERR_ACFNOPARENT, "The parent directory could not be located." },
	{ WERR_NERR_CANNOTGROWSEGMENT, "Unable to add to the security database session cache segment." },
	{ WERR_NERR_SPEGROUPOP, "This operation is not allowed on this special group." },
	{ WERR_NERR_NOTINCACHE, "This user is not cached in the user accounts database session cache." },
	{ WERR_NERR_USERINGROUP, "The user already belongs to this group." },
	{ WERR_NERR_USERNOTINGROUP, "The user does not belong to this group." },
	{ WERR_NERR_ACCOUNTUNDEFINED, "This user account is undefined." },
	{ WERR_NERR_ACCOUNTEXPIRED, "This user account has expired." },
	{ WERR_NERR_INVALIDWORKSTATION, "The user is not allowed to log on from this workstation." },
	{ WERR_NERR_INVALIDLOGONHOURS, "The user is not allowed to log on at this time." },
	{ WERR_NERR_PASSWORDEXPIRED, "The password of this user has expired." },
	{ WERR_NERR_PASSWORDCANTCHANGE, "The password of this user cannot change." },
	{ WERR_NERR_PASSWORDHISTCONFLICT, "This password cannot be used now." },
	{ WERR_NERR_PASSWORDTOOSHORT, "The password does not meet the password policy requirements. Check the minimum password length, password complexity, and password history requirements." },
	{ WERR_NERR_PASSWORDTOORECENT, "The password of this user is too recent to change." },
	{ WERR_NERR_INVALIDDATABASE, "The security database is corrupted." },
	{ WERR_NERR_DATABASEUPTODATE, "No updates are necessary to this replicant network or local security database." },
	{ WERR_NERR_SYNCREQUIRED, "This replicant database is outdated; synchronization is required." },
	{ WERR_NERR_USENOTFOUND, "The network connection could not be found." },
	{ WERR_NERR_BADASGTYPE, "This asg_type is invalid." },
	{ WERR_NERR_DEVICEISSHARED, "This device is currently being shared." },
	{ WERR_NERR_NOCOMPUTERNAME, "The computer name could not be added as a message alias. The name may already exist on the network." },
	{ WERR_NERR_MSGALREADYSTARTED, "The Messenger service is already started." },
	{ WERR_NERR_MSGINITFAILED, "The Messenger service failed to start." },
	{ WERR_NERR_NAMENOTFOUND, "The message alias could not be found on the network." },
	{ WERR_NERR_ALREADYFORWARDED, "This message alias has already been forwarded." },
	{ WERR_NERR_ADDFORWARDED, "This message alias has been added but is still forwarded." },
	{ WERR_NERR_ALREADYEXISTS, "This message alias already exists locally." },
	{ WERR_NERR_TOOMANYNAMES, "The maximum number of added message aliases has been exceeded." },
	{ WERR_NERR_DELCOMPUTERNAME, "The computer name could not be deleted." },
	{ WERR_NERR_LOCALFORWARD, "Messages cannot be forwarded back to the same workstation." },
	{ WERR_NERR_GRPMSGPROCESSOR, "An error occurred in the domain message processor." },
	{ WERR_NERR_PAUSEDREMOTE, "The message was sent, but the recipient has paused the Messenger service." },
	{ WERR_NERR_BADRECEIVE, "The message was sent but not received." },
	{ WERR_NERR_NAMEINUSE, "The message alias is currently in use. Try again later." },
	{ WERR_NERR_MSGNOTSTARTED, "The Messenger service has not been started." },
	{ WERR_NERR_NOTLOCALNAME, "The name is not on the local computer." },
	{ WERR_NERR_NOFORWARDNAME, "The forwarded message alias could not be found on the network." },
	{ WERR_NERR_REMOTEFULL, "The message alias table on the remote station is full." },
	{ WERR_NERR_NAMENOTFORWARDED, "Messages for this alias are not currently being forwarded." },
	{ WERR_NERR_TRUNCATEDBROADCAST, "The broadcast message was truncated." },
	{ WERR_NERR_INVALIDDEVICE, "This is an invalid device name." },
	{ WERR_NERR_WRITEFAULT, "A write fault occurred." },
	{ WERR_NERR_DUPLICATENAME, "A duplicate message alias exists on the network." },
	{ WERR_NERR_DELETELATER, "This message alias will be deleted later." },
	{ WERR_NERR_INCOMPLETEDEL, "The message alias was not successfully deleted from all networks." },
	{ WERR_NERR_MULTIPLENETS, "This operation is not supported on computers with multiple networks." },
	{ WERR_NERR_NETNAMENOTFOUND, "This shared resource does not exist." },
	{ WERR_NERR_DEVICENOTSHARED, "This device is not shared." },
	{ WERR_NERR_CLIENTNAMENOTFOUND, "A session does not exist with that computer name." },
	{ WERR_NERR_FILEIDNOTFOUND, "There is not an open file with that identification number." },
	{ WERR_NERR_EXECFAILURE, "A failure occurred when executing a remote administration command." },
	{ WERR_NERR_TMPFILE, "A failure occurred when opening a remote temporary file." },
	{ WERR_NERR_TOOMUCHDATA, "The data returned from a remote administration command has been truncated to 64 KB." },
	{ WERR_NERR_DEVICESHARECONFLICT, "This device cannot be shared as both a spooled and a nonspooled resource." },
	{ WERR_NERR_BROWSERTABLEINCOMPLETE, "The information in the list of servers may be incorrect." },
	{ WERR_NERR_NOTLOCALDOMAIN, "The computer is not active in this domain." },
	{ WERR_NERR_ISDFSSHARE, "The share must be removed from the Distributed File System (DFS) before it can be deleted." },
	{ WERR_NERR_DEVINVALIDOPCODE, "The operation is invalid for this device." },
	{ WERR_NERR_DEVNOTFOUND, "This device cannot be shared." },
	{ WERR_NERR_DEVNOTOPEN, "This device was not open." },
	{ WERR_NERR_BADQUEUEDEVSTRING, "This device name list is invalid." },
	{ WERR_NERR_BADQUEUEPRIORITY, "The queue priority is invalid." },
	{ WERR_NERR_NOCOMMDEVS, "There are no shared communication devices." },
	{ WERR_NERR_QUEUENOTFOUND, "The queue you specified does not exist." },
	{ WERR_NERR_BADDEVSTRING, "This list of devices is invalid." },
	{ WERR_NERR_BADDEV, "The requested device is invalid." },
	{ WERR_NERR_INUSEBYSPOOLER, "This device is already in use by the spooler." },
	{ WERR_NERR_COMMDEVINUSE, "This device is already in use as a communication device." },
	{ WERR_NERR_INVALIDCOMPUTER, "This computer name is invalid." },
	{ WERR_NERR_MAXLENEXCEEDED, "The string and prefix specified are too long." },
	{ WERR_NERR_BADCOMPONENT, "This path component is invalid." },
	{ WERR_NERR_CANTTYPE, "Could not determine the type of input." },
	{ WERR_NERR_TOOMANYENTRIES, "The buffer for types is not big enough." },
	{ WERR_NERR_PROFILEFILETOOBIG, "Profile files cannot exceed 64 KB." },
	{ WERR_NERR_PROFILEOFFSET, "The start offset is out of range." },
	{ WERR_NERR_PROFILECLEANUP, "The system cannot delete current connections to network resources." },
	{ WERR_NERR_PROFILEUNKNOWNCMD, "The system was unable to parse the command line in this file." },
	{ WERR_NERR_PROFILELOADERR, "An error occurred while loading the profile file." },
	{ WERR_NERR_PROFILESAVEERR, "Errors occurred while saving the profile file. The profile was partially saved." },
	{ WERR_NERR_LOGOVERFLOW, "Log file %1 is full." },
	{ WERR_NERR_LOGFILECHANGED, "This log file has changed between reads." },
	{ WERR_NERR_LOGFILECORRUPT, "Log file %1 is corrupt." },
	{ WERR_NERR_SOURCEISDIR, "The source path cannot be a directory." },
	{ WERR_NERR_BADSOURCE, "The source path is illegal." },
	{ WERR_NERR_BADDEST, "The destination path is illegal." },
	{ WERR_NERR_DIFFERENTSERVERS, "The source and destination paths are on different servers." },
	{ WERR_NERR_RUNSRVPAUSED, "The Run server you requested is paused." },
	{ WERR_NERR_ERRCOMMRUNSRV, "An error occurred when communicating with a Run server." },
	{ WERR_NERR_ERROREXECINGGHOST, "An error occurred when starting a background process." },
	{ WERR_NERR_SHARENOTFOUND, "The shared resource you are connected to could not be found." },
	{ WERR_NERR_INVALIDLANA, "The LAN adapter number is invalid." },
	{ WERR_NERR_OPENFILES, "There are open files on the connection." },
	{ WERR_NERR_ACTIVECONNS, "Active connections still exist." },
	{ WERR_NERR_BADPASSWORDCORE, "This share name or password is invalid." },
	{ WERR_NERR_DEVINUSE, "The device is being accessed by an active process." },
	{ WERR_NERR_LOCALDRIVE, "The drive letter is in use locally." },
	{ WERR_NERR_ALERTEXISTS, "The specified client is already registered for the specified event." },
	{ WERR_NERR_TOOMANYALERTS, "The alert table is full." },
	{ WERR_NERR_NOSUCHALERT, "An invalid or nonexistent alert name was raised." },
	{ WERR_NERR_BADRECIPIENT, "The alert recipient is invalid." },
	{ WERR_NERR_ACCTLIMITEXCEEDED, "A user\'s session with this server has been deleted" },
	{ WERR_NERR_INVALIDLOGSEEK, "The log file does not contain the requested record number." },
	{ WERR_NERR_BADUASCONFIG, "The user accounts database is not configured correctly." },
	{ WERR_NERR_INVALIDUASOP, "This operation is not permitted when the Net Logon service is running." },
	{ WERR_NERR_LASTADMIN, "This operation is not allowed on the last administrative account." },
	{ WERR_NERR_DCNOTFOUND, "Could not find the domain controller for this domain." },
	{ WERR_NERR_LOGONTRACKINGERROR, "Could not set logon information for this user." },
	{ WERR_NERR_NETLOGONNOTSTARTED, "The Net Logon service has not been started." },
	{ WERR_NERR_CANNOTGROWUASFILE, "Unable to add to the user accounts database." },
	{ WERR_NERR_TIMEDIFFATDC, "This server\'s clock is not synchronized with the PDC\'s clock." },
	{ WERR_NERR_PASSWORDMISMATCH, "A password mismatch has been detected." },
	{ WERR_NERR_NOSUCHSERVER, "The server identification does not specify a valid server." },
	{ WERR_NERR_NOSUCHSESSION, "The session identification does not specify a valid session." },
	{ WERR_NERR_NOSUCHCONNECTION, "The connection identification does not specify a valid connection." },
	{ WERR_NERR_TOOMANYSERVERS, "There is no space for another entry in the table of available servers." },
	{ WERR_NERR_TOOMANYSESSIONS, "The server has reached the maximum number of sessions it supports." },
	{ WERR_NERR_TOOMANYCONNECTIONS, "The server has reached the maximum number of connections it supports." },
	{ WERR_NERR_TOOMANYFILES, "The server cannot open more files because it has reached its maximum number." },
	{ WERR_NERR_NOALTERNATESERVERS, "There are no alternate servers registered on this server." },
	{ WERR_NERR_TRYDOWNLEVEL, "Try the down-level (remote admin protocol) version of API instead." },
	{ WERR_NERR_UPSDRIVERNOTSTARTED, "The uninterruptible power supply (UPS) driver could not be accessed by the UPS service." },
	{ WERR_NERR_UPSINVALIDCONFIG, "The UPS service is not configured correctly." },
	{ WERR_NERR_UPSINVALIDCOMMPORT, "The UPS service could not access the specified Comm Port." },
	{ WERR_NERR_UPSSIGNALASSERTED, "The UPS indicated a line fail or low battery situation. Service not started." },
	{ WERR_NERR_UPSSHUTDOWNFAILED, "The UPS service failed to perform a system shut down." },
	{ WERR_NERR_BADDOSRETCODE, "The program below returned an MS-DOS error code." },
	{ WERR_NERR_PROGNEEDSEXTRAMEM, "The program below needs more memory." },
	{ WERR_NERR_BADDOSFUNCTION, "The program below called an unsupported MS-DOS function." },
	{ WERR_NERR_REMOTEBOOTFAILED, "The workstation failed to boot." },
	{ WERR_NERR_BADFILECHECKSUM, "The file below is corrupt." },
	{ WERR_NERR_NORPLBOOTSYSTEM, "No loader is specified in the boot-block definition file." },
	{ WERR_NERR_RPLLOADRNETBIOSERR, "NetBIOS returned an error: The network control blocks (NCBs) and Server Message Block (SMB) are dumped above." },
	{ WERR_NERR_RPLLOADRDISKERR, "A disk I/O error occurred." },
	{ WERR_NERR_IMAGEPARAMERR, "Image parameter substitution failed." },
	{ WERR_NERR_TOOMANYIMAGEPARAMS, "Too many image parameters cross disk sector boundaries." },
	{ WERR_NERR_NONDOSFLOPPYUSED, "The image was not generated from an MS-DOS disk formatted with /S." },
	{ WERR_NERR_RPLBOOTRESTART, "Remote boot will be restarted later." },
	{ WERR_NERR_RPLSRVRCALLFAILED, "The call to the Remoteboot server failed." },
	{ WERR_NERR_CANTCONNECTRPLSRVR, "Cannot connect to the Remoteboot server." },
	{ WERR_NERR_CANTOPENIMAGEFILE, "Cannot open image file on the Remoteboot server." },
	{ WERR_NERR_CALLINGRPLSRVR, "Connecting to the Remoteboot server." },
	{ WERR_NERR_STARTINGRPLBOOT, "Connecting to the Remoteboot server." },
	{ WERR_NERR_RPLBOOTSERVICETERM, "Remote boot service was stopped, check the error log for the cause of the problem." },
	{ WERR_NERR_RPLBOOTSTARTFAILED, "Remote boot startup failed; check the error log for the cause of the problem." },
	{ WERR_NERR_RPL_CONNECTED, "A second connection to a Remoteboot resource is not allowed." },
	{ WERR_NERR_BROWSERCONFIGUREDTONOTRUN, "The browser service was configured with MaintainServerList=No." },
	{ WERR_NERR_RPLNOADAPTERSSTARTED, "Service failed to start because none of the network adapters started with this service." },
	{ WERR_NERR_RPLBADREGISTRY, "Service failed to start due to bad startup information in the registry." },
	{ WERR_NERR_RPLBADDATABASE, "Service failed to start because its database is absent or corrupt." },
	{ WERR_NERR_RPLRPLFILESSHARE, "Service failed to start because the RPLFILES share is absent." },
	{ WERR_NERR_RPLNOTRPLSERVER, "Service failed to start because the RPLUSER group is absent." },
	{ WERR_NERR_RPLCANNOTENUM, "Cannot enumerate service records." },
	{ WERR_NERR_RPLWKSTAINFOCORRUPTED, "Workstation record information has been corrupted." },
	{ WERR_NERR_RPLWKSTANOTFOUND, "Workstation record was not found." },
	{ WERR_NERR_RPLWKSTANAMEUNAVAILABLE, "Workstation name is in use by some other workstation." },
	{ WERR_NERR_RPLPROFILEINFOCORRUPTED, "Profile record information has been corrupted." },
	{ WERR_NERR_RPLPROFILENOTFOUND, "Profile record was not found." },
	{ WERR_NERR_RPLPROFILENAMEUNAVAILABLE, "Profile name is in use by some other profile." },
	{ WERR_NERR_RPLPROFILENOTEMPTY, "There are workstations using this profile." },
	{ WERR_NERR_RPLCONFIGINFOCORRUPTED, "Configuration record information has been corrupted." },
	{ WERR_NERR_RPLCONFIGNOTFOUND, "Configuration record was not found." },
	{ WERR_NERR_RPLADAPTERINFOCORRUPTED, "Adapter ID record information has been corrupted." },
	{ WERR_NERR_RPLINTERNAL, "An internal service error has occurred." },
	{ WERR_NERR_RPLVENDORINFOCORRUPTED, "Vendor ID record information has been corrupted." },
	{ WERR_NERR_RPLBOOTINFOCORRUPTED, "Boot block record information has been corrupted." },
	{ WERR_NERR_RPLWKSTANEEDSUSERACCT, "The user account for this workstation record is missing." },
	{ WERR_NERR_RPLNEEDSRPLUSERACCT, "The RPLUSER local group could not be found." },
	{ WERR_NERR_RPLBOOTNOTFOUND, "Boot block record was not found." },
	{ WERR_NERR_RPLINCOMPATIBLEPROFILE, "Chosen profile is incompatible with this workstation." },
	{ WERR_NERR_RPLADAPTERNAMEUNAVAILABLE, "Chosen network adapter ID is in use by some other workstation." },
	{ WERR_NERR_RPLCONFIGNOTEMPTY, "There are profiles using this configuration." },
	{ WERR_NERR_RPLBOOTINUSE, "There are workstations, profiles, or configurations using this boot block." },
	{ WERR_NERR_RPLBACKUPDATABASE, "Service failed to back up the Remoteboot database." },
	{ WERR_NERR_RPLADAPTERNOTFOUND, "Adapter record was not found." },
	{ WERR_NERR_RPLVENDORNOTFOUND, "Vendor record was not found." },
	{ WERR_NERR_RPLVENDORNAMEUNAVAILABLE, "Vendor name is in use by some other vendor record." },
	{ WERR_NERR_RPLBOOTNAMEUNAVAILABLE, "The boot name or vendor ID is in use by some other boot block record." },
	{ WERR_NERR_RPLCONFIGNAMEUNAVAILABLE, "The configuration name is in use by some other configuration." },
	{ WERR_NERR_DFSINTERNALCORRUPTION, "The internal database maintained by the DFS service is corrupt." },
	{ WERR_NERR_DFSVOLUMEDATACORRUPT, "One of the records in the internal DFS database is corrupt." },
	{ WERR_NERR_DFSNOSUCHVOLUME, "There is no DFS name whose entry path matches the input entry path." },
	{ WERR_NERR_DFSVOLUMEALREADYEXISTS, "A root or link with the given name already exists." },
	{ WERR_NERR_DFSALREADYSHARED, "The server share specified is already shared in the DFS." },
	{ WERR_NERR_DFSNOSUCHSHARE, "The indicated server share does not support the indicated DFS namespace." },
	{ WERR_NERR_DFSNOTALEAFVOLUME, "The operation is not valid in this portion of the namespace." },
	{ WERR_NERR_DFSLEAFVOLUME, "The operation is not valid in this portion of the namespace." },
	{ WERR_NERR_DFSVOLUMEHASMULTIPLESERVERS, "The operation is ambiguous because the link has multiple servers." },
	{ WERR_NERR_DFSCANTCREATEJUNCTIONPOINT, "Unable to create a link." },
	{ WERR_NERR_DFSSERVERNOTDFSAWARE, "The server is not DFS-aware." },
	{ WERR_NERR_DFSBADRENAMEPATH, "The specified rename target path is invalid." },
	{ WERR_NERR_DFSVOLUMEISOFFLINE, "The specified DFS link is offline." },
	{ WERR_NERR_DFSNOSUCHSERVER, "The specified server is not a server for this link." },
	{ WERR_NERR_DFSCYCLICALNAME, "A cycle in the DFS name was detected." },
	{ WERR_NERR_DFSNOTSUPPORTEDINSERVERDFS, "The operation is not supported on a server-based DFS." },
	{ WERR_NERR_DFSDUPLICATESERVICE, "This link is already supported by the specified server share." },
	{ WERR_NERR_DFSCANTREMOVELASTSERVERSHARE, "Cannot remove the last server share supporting this root or link." },
	{ WERR_NERR_DFSVOLUMEISINTERDFS, "The operation is not supported for an inter-DFS link." },
	{ WERR_NERR_DFSINCONSISTENT, "The internal state of the DFS Service has become inconsistent." },
	{ WERR_NERR_DFSSERVERUPGRADED, "The DFS Service has been installed on the specified server." },
	{ WERR_NERR_DFSDATAISIDENTICAL, "The DFS data being reconciled is identical." },
	{ WERR_NERR_DFSCANTREMOVEDFSROOT, "The DFS root cannot be deleted. Uninstall DFS if required." },
	{ WERR_NERR_DFSCHILDORPARENTINDFS, "A child or parent directory of the share is already in a DFS." },
	{ WERR_NERR_DFSINTERNALERROR, "DFS internal error." },
	{ WERR_NERR_SETUPALREADYJOINED, "This machine is already joined to a domain." },
	{ WERR_NERR_SETUPNOTJOINED, "This machine is not currently joined to a domain." },
	{ WERR_NERR_SETUPDOMAINCONTROLLER, "This machine is a domain controller and cannot be unjoined from a domain." },
	{ WERR_NERR_DEFAULTJOINREQUIRED, "The destination domain controller does not support creating machine accounts in organizational units (OUs)." },
	{ WERR_NERR_INVALIDWORKGROUPNAME, "The specified workgroup name is invalid." },
	{ WERR_NERR_NAMEUSESINCOMPATIBLECODEPAGE, "The specified computer name is incompatible with the default language used on the domain controller." },
	{ WERR_NERR_COMPUTERACCOUNTNOTFOUND, "The specified computer account could not be found." },
	{ WERR_NERR_PERSONALSKU, "This version of Windows cannot be joined to a domain." },
	{ WERR_NERR_PASSWORDMUSTCHANGE, "The password must change at the next logon." },
	{ WERR_NERR_ACCOUNTLOCKEDOUT, "The account is locked out." },
	{ WERR_NERR_PASSWORDTOOLONG, "The password is too long." },
	{ WERR_NERR_PASSWORDNOTCOMPLEXENOUGH, "The password does not meet the complexity policy." },
	{ WERR_NERR_PASSWORDFILTERERROR, "The password does not meet the requirements of the password filter DLLs." },
	{ WERR_UNKNOWN_PRINT_MONITOR, "The specified print monitor is unknown." },
	{ WERR_PRINTER_DRIVER_IN_USE, "The specified printer driver is currently in use." },
	{ WERR_SPOOL_FILE_NOT_FOUND, "The spool file was not found." },
	{ WERR_SPL_NO_STARTDOC, "A StartDocPrinter call was not issued." },
	{ WERR_SPL_NO_ADDJOB, "An AddJob call was not issued." },
	{ WERR_PRINT_PROCESSOR_ALREADY_INSTALLED, "The specified print processor has already been installed." },
	{ WERR_PRINT_MONITOR_ALREADY_INSTALLED, "The specified print monitor has already been installed." },
	{ WERR_INVALID_PRINT_MONITOR, "The specified print monitor does not have the required functions." },
	{ WERR_PRINT_MONITOR_IN_USE, "The specified print monitor is currently in use." },
	{ WERR_PRINTER_HAS_JOBS_QUEUED, "The requested operation is not allowed when there are jobs queued to the printer." },
	{ WERR_SUCCESS_REBOOT_REQUIRED, "The requested operation is successful. Changes will not be effective until the system is rebooted." },
	{ WERR_SUCCESS_RESTART_REQUIRED, "The requested operation is successful. Changes will not be effective until the service is restarted." },
	{ WERR_PRINTER_NOT_FOUND, "No printers were found." },
	{ WERR_PRINTER_DRIVER_WARNED, "The printer driver is known to be unreliable." },
	{ WERR_PRINTER_DRIVER_BLOCKED, "The printer driver is known to harm the system." },
	{ WERR_PRINTER_DRIVER_PACKAGE_IN_USE, "The specified printer driver package is currently in use." },
	{ WERR_CORE_DRIVER_PACKAGE_NOT_FOUND, "Unable to find a core driver package that is required by the printer driver package." },
	{ WERR_FAIL_REBOOT_REQUIRED, "The requested operation failed. A system reboot is required to roll back changes made." },
	{ WERR_FAIL_REBOOT_INITIATED, "The requested operation failed. A system reboot has been initiated to roll back changes made." },
	{ WERR_IO_REISSUE_AS_CACHED, "Reissue the given operation as a cached I/O operation" },
	{ WERR_WINS_INTERNAL, "Windows Internet Name Service (WINS) encountered an error while processing the command." },
	{ WERR_CAN_NOT_DEL_LOCAL_WINS, "The local WINS cannot be deleted." },
	{ WERR_STATIC_INIT, "The importation from the file failed." },
	{ WERR_INC_BACKUP, "The backup failed. Was a full backup done before?" },
	{ WERR_FULL_BACKUP, "The backup failed. Check the directory to which you are backing the database." },
	{ WERR_REC_NON_EXISTENT, "The name does not exist in the WINS database." },
	{ WERR_RPL_NOT_ALLOWED, "Replication with a nonconfigured partner is not allowed." },
	{ WERR_DHCP_ADDRESS_CONFLICT, "The Dynamic Host Configuration Protocol (DHCP) client has obtained an IP address that is already in use on the network. The local interface will be disabled until the DHCP client can obtain a new address." },
	{ WERR_WMI_GUID_NOT_FOUND, "The GUID passed was not recognized as valid by a WMI data provider." },
	{ WERR_WMI_INSTANCE_NOT_FOUND, "The instance name passed was not recognized as valid by a WMI data provider." },
	{ WERR_WMI_ITEMID_NOT_FOUND, "The data item ID passed was not recognized as valid by a WMI data provider." },
	{ WERR_WMI_TRY_AGAIN, "The WMI request could not be completed and should be retried." },
	{ WERR_WMI_DP_NOT_FOUND, "The WMI data provider could not be located." },
	{ WERR_WMI_UNRESOLVED_INSTANCE_REF, "The WMI data provider references an instance set that has not been registered." },
	{ WERR_WMI_ALREADY_ENABLED, "The WMI data block or event notification has already been enabled." },
	{ WERR_WMI_GUID_DISCONNECTED, "The WMI data block is no longer available." },
	{ WERR_WMI_SERVER_UNAVAILABLE, "The WMI data service is not available." },
	{ WERR_WMI_DP_FAILED, "The WMI data provider failed to carry out the request." },
	{ WERR_WMI_INVALID_MOF, "The WMI Managed Object Format (MOF) information is not valid." },
	{ WERR_WMI_INVALID_REGINFO, "The WMI registration information is not valid." },
	{ WERR_WMI_ALREADY_DISABLED, "The WMI data block or event notification has already been disabled." },
	{ WERR_WMI_READ_ONLY, "The WMI data item or data block is read-only." },
	{ WERR_WMI_SET_FAILURE, "The WMI data item or data block could not be changed." },
	{ WERR_INVALID_MEDIA, "The media identifier does not represent a valid medium." },
	{ WERR_INVALID_LIBRARY, "The library identifier does not represent a valid library." },
	{ WERR_INVALID_MEDIA_POOL, "The media pool identifier does not represent a valid media pool." },
	{ WERR_DRIVE_MEDIA_MISMATCH, "The drive and medium are not compatible, or they exist in different libraries." },
	{ WERR_MEDIA_OFFLINE, "The medium currently exists in an offline library and must be online to perform this operation." },
	{ WERR_LIBRARY_OFFLINE, "The operation cannot be performed on an offline library." },
	{ WERR_EMPTY, "The library, drive, or media pool is empty." },
	{ WERR_NOT_EMPTY, "The library, drive, or media pool must be empty to perform this operation." },
	{ WERR_MEDIA_UNAVAILABLE, "No media is currently available in this media pool or library." },
	{ WERR_RESOURCE_DISABLED, "A resource required for this operation is disabled." },
	{ WERR_INVALID_CLEANER, "The media identifier does not represent a valid cleaner." },
	{ WERR_UNABLE_TO_CLEAN, "The drive cannot be cleaned or does not support cleaning." },
	{ WERR_OBJECT_NOT_FOUND, "The object identifier does not represent a valid object." },
	{ WERR_DATABASE_FAILURE, "Unable to read from or write to the database." },
	{ WERR_DATABASE_FULL, "The database is full." },
	{ WERR_MEDIA_INCOMPATIBLE, "The medium is not compatible with the device or media pool." },
	{ WERR_RESOURCE_NOT_PRESENT, "The resource required for this operation does not exist." },
	{ WERR_INVALID_OPERATION, "The operation identifier is not valid." },
	{ WERR_MEDIA_NOT_AVAILABLE, "The media is not mounted or ready for use." },
	{ WERR_DEVICE_NOT_AVAILABLE, "The device is not ready for use." },
	{ WERR_REQUEST_REFUSED, "The operator or administrator has refused the request." },
	{ WERR_INVALID_DRIVE_OBJECT, "The drive identifier does not represent a valid drive." },
	{ WERR_LIBRARY_FULL, "Library is full. No slot is available for use." },
	{ WERR_MEDIUM_NOT_ACCESSIBLE, "The transport cannot access the medium." },
	{ WERR_UNABLE_TO_LOAD_MEDIUM, "Unable to load the medium into the drive." },
	{ WERR_UNABLE_TO_INVENTORY_DRIVE, "Unable to retrieve the drive status." },
	{ WERR_UNABLE_TO_INVENTORY_SLOT, "Unable to retrieve the slot status." },
	{ WERR_UNABLE_TO_INVENTORY_TRANSPORT, "Unable to retrieve status about the transport." },
	{ WERR_TRANSPORT_FULL, "Cannot use the transport because it is already in use." },
	{ WERR_CONTROLLING_IEPORT, "Unable to open or close the inject/eject port." },
	{ WERR_UNABLE_TO_EJECT_MOUNTED_MEDIA, "Unable to eject the medium because it is in a drive." },
	{ WERR_CLEANER_SLOT_SET, "A cleaner slot is already reserved." },
	{ WERR_CLEANER_SLOT_NOT_SET, "A cleaner slot is not reserved." },
	{ WERR_CLEANER_CARTRIDGE_SPENT, "The cleaner cartridge has performed the maximum number of drive cleanings." },
	{ WERR_UNEXPECTED_OMID, "Unexpected on-medium identifier." },
	{ WERR_CANT_DELETE_LAST_ITEM, "The last remaining item in this group or resource cannot be deleted." },
	{ WERR_MESSAGE_EXCEEDS_MAX_SIZE, "The message provided exceeds the maximum size allowed for this parameter." },
	{ WERR_VOLUME_CONTAINS_SYS_FILES, "The volume contains system or paging files." },
	{ WERR_INDIGENOUS_TYPE, "The media type cannot be removed from this library because at least one drive in the library reports it can support this media type." },
	{ WERR_NO_SUPPORTING_DRIVES, "This offline media cannot be mounted on this system because no enabled drives are present that can be used." },
	{ WERR_CLEANER_CARTRIDGE_INSTALLED, "A cleaner cartridge is present in the tape library." },
	{ WERR_IEPORT_FULL, "Cannot use the IEport because it is not empty." },
	{ WERR_FILE_OFFLINE, "The remote storage service was not able to recall the file." },
	{ WERR_REMOTE_STORAGE_NOT_ACTIVE, "The remote storage service is not operational at this time." },
	{ WERR_REMOTE_STORAGE_MEDIA_ERROR, "The remote storage service encountered a media error." },
	{ WERR_NOT_A_REPARSE_POINT, "The file or directory is not a reparse point." },
	{ WERR_REPARSE_ATTRIBUTE_CONFLICT, "The reparse point attribute cannot be set because it conflicts with an existing attribute." },
	{ WERR_INVALID_REPARSE_DATA, "The data present in the reparse point buffer is invalid." },
	{ WERR_REPARSE_TAG_INVALID, "The tag present in the reparse point buffer is invalid." },
	{ WERR_REPARSE_TAG_MISMATCH, "There is a mismatch between the tag specified in the request and the tag present in the reparse point." },
	{ WERR_VOLUME_NOT_SIS_ENABLED, "Single Instance Storage (SIS) is not available on this volume." },
	{ WERR_DEPENDENT_RESOURCE_EXISTS, "The operation cannot be completed because other resources depend on this resource." },
	{ WERR_DEPENDENCY_NOT_FOUND, "The cluster resource dependency cannot be found." },
	{ WERR_DEPENDENCY_ALREADY_EXISTS, "The cluster resource cannot be made dependent on the specified resource because it is already dependent." },
	{ WERR_RESOURCE_NOT_ONLINE, "The cluster resource is not online." },
	{ WERR_HOST_NODE_NOT_AVAILABLE, "A cluster node is not available for this operation." },
	{ WERR_RESOURCE_NOT_AVAILABLE, "The cluster resource is not available." },
	{ WERR_RESOURCE_NOT_FOUND, "The cluster resource could not be found." },
	{ WERR_SHUTDOWN_CLUSTER, "The cluster is being shut down." },
	{ WERR_CANT_EVICT_ACTIVE_NODE, "A cluster node cannot be evicted from the cluster unless the node is down or it is the last node." },
	{ WERR_OBJECT_ALREADY_EXISTS, "The object already exists." },
	{ WERR_OBJECT_IN_LIST, "The object is already in the list." },
	{ WERR_GROUP_NOT_AVAILABLE, "The cluster group is not available for any new requests." },
	{ WERR_GROUP_NOT_FOUND, "The cluster group could not be found." },
	{ WERR_GROUP_NOT_ONLINE, "The operation could not be completed because the cluster group is not online." },
	{ WERR_HOST_NODE_NOT_RESOURCE_OWNER, "The operation failed because either the specified cluster node is not the owner of the resource, or the node is not a possible owner of the resource." },
	{ WERR_HOST_NODE_NOT_GROUP_OWNER, "The operation failed because either the specified cluster node is not the owner of the group, or the node is not a possible owner of the group." },
	{ WERR_RESMON_CREATE_FAILED, "The cluster resource could not be created in the specified resource monitor." },
	{ WERR_RESMON_ONLINE_FAILED, "The cluster resource could not be brought online by the resource monitor." },
	{ WERR_RESOURCE_ONLINE, "The operation could not be completed because the cluster resource is online." },
	{ WERR_QUORUM_RESOURCE, "The cluster resource could not be deleted or brought offline because it is the quorum resource." },
	{ WERR_NOT_QUORUM_CAPABLE, "The cluster could not make the specified resource a quorum resource because it is not capable of being a quorum resource." },
	{ WERR_CLUSTER_SHUTTING_DOWN, "The cluster software is shutting down." },
	{ WERR_INVALID_STATE, "The group or resource is not in the correct state to perform the requested operation." },
	{ WERR_RESOURCE_PROPERTIES_STORED, "The properties were stored but not all changes will take effect until the next time the resource is brought online." },
	{ WERR_NOT_QUORUM_CLASS, "The cluster could not make the specified resource a quorum resource because it does not belong to a shared storage class." },
	{ WERR_CORE_RESOURCE, "The cluster resource could not be deleted because it is a core resource." },
	{ WERR_QUORUM_RESOURCE_ONLINE_FAILED, "The quorum resource failed to come online." },
	{ WERR_QUORUMLOG_OPEN_FAILED, "The quorum log could not be created or mounted successfully." },
	{ WERR_CLUSTERLOG_CORRUPT, "The cluster log is corrupt." },
	{ WERR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE, "The record could not be written to the cluster log because it exceeds the maximum size." },
	{ WERR_CLUSTERLOG_EXCEEDS_MAXSIZE, "The cluster log exceeds its maximum size." },
	{ WERR_CLUSTERLOG_CHKPOINT_NOT_FOUND, "No checkpoint record was found in the cluster log." },
	{ WERR_CLUSTERLOG_NOT_ENOUGH_SPACE, "The minimum required disk space needed for logging is not available." },
	{ WERR_QUORUM_OWNER_ALIVE, "The cluster node failed to take control of the quorum resource because the resource is owned by another active node." },
	{ WERR_NETWORK_NOT_AVAILABLE, "A cluster network is not available for this operation." },
	{ WERR_NODE_NOT_AVAILABLE, "A cluster node is not available for this operation." },
	{ WERR_ALL_NODES_NOT_AVAILABLE, "All cluster nodes must be running to perform this operation." },
	{ WERR_RESOURCE_FAILED, "A cluster resource failed." },
	{ WERR_CLUSTER_INVALID_NODE, "The cluster node is not valid." },
	{ WERR_CLUSTER_NODE_EXISTS, "The cluster node already exists." },
	{ WERR_CLUSTER_JOIN_IN_PROGRESS, "A node is in the process of joining the cluster." },
	{ WERR_CLUSTER_NODE_NOT_FOUND, "The cluster node was not found." },
	{ WERR_CLUSTER_LOCAL_NODE_NOT_FOUND, "The cluster local node information was not found." },
	{ WERR_CLUSTER_NETWORK_EXISTS, "The cluster network already exists." },
	{ WERR_CLUSTER_NETWORK_NOT_FOUND, "The cluster network was not found." },
	{ WERR_CLUSTER_NETINTERFACE_EXISTS, "The cluster network interface already exists." },
	{ WERR_CLUSTER_NETINTERFACE_NOT_FOUND, "The cluster network interface was not found." },
	{ WERR_CLUSTER_INVALID_REQUEST, "The cluster request is not valid for this object." },
	{ WERR_CLUSTER_INVALID_NETWORK_PROVIDER, "The cluster network provider is not valid." },
	{ WERR_CLUSTER_NODE_DOWN, "The cluster node is down." },
	{ WERR_CLUSTER_NODE_UNREACHABLE, "The cluster node is not reachable." },
	{ WERR_CLUSTER_NODE_NOT_MEMBER, "The cluster node is not a member of the cluster." },
	{ WERR_CLUSTER_JOIN_NOT_IN_PROGRESS, "A cluster join operation is not in progress." },
	{ WERR_CLUSTER_INVALID_NETWORK, "The cluster network is not valid." },
	{ WERR_CLUSTER_NODE_UP, "The cluster node is up." },
	{ WERR_CLUSTER_IPADDR_IN_USE, "The cluster IP address is already in use." },
	{ WERR_CLUSTER_NODE_NOT_PAUSED, "The cluster node is not paused." },
	{ WERR_CLUSTER_NO_SECURITY_CONTEXT, "No cluster security context is available." },
	{ WERR_CLUSTER_NETWORK_NOT_INTERNAL, "The cluster network is not configured for internal cluster communication." },
	{ WERR_CLUSTER_NODE_ALREADY_UP, "The cluster node is already up." },
	{ WERR_CLUSTER_NODE_ALREADY_DOWN, "The cluster node is already down." },
	{ WERR_CLUSTER_NETWORK_ALREADY_ONLINE, "The cluster network is already online." },
	{ WERR_CLUSTER_NETWORK_ALREADY_OFFLINE, "The cluster network is already offline." },
	{ WERR_CLUSTER_NODE_ALREADY_MEMBER, "The cluster node is already a member of the cluster." },
	{ WERR_CLUSTER_LAST_INTERNAL_NETWORK, "The cluster network is the only one configured for internal cluster communication between two or more active cluster nodes. The internal communication capability cannot be removed from the network." },
	{ WERR_CLUSTER_NETWORK_HAS_DEPENDENTS, "One or more cluster resources depend on the network to provide service to clients. The client access capability cannot be removed from the network." },
	{ WERR_INVALID_OPERATION_ON_QUORUM, "This operation cannot be performed on the cluster resource because it is the quorum resource. You may not bring the quorum resource offline or modify its possible owners list." },
	{ WERR_DEPENDENCY_NOT_ALLOWED, "The cluster quorum resource is not allowed to have any dependencies." },
	{ WERR_CLUSTER_NODE_PAUSED, "The cluster node is paused." },
	{ WERR_NODE_CANT_HOST_RESOURCE, "The cluster resource cannot be brought online. The owner node cannot run this resource." },
	{ WERR_CLUSTER_NODE_NOT_READY, "The cluster node is not ready to perform the requested operation." },
	{ WERR_CLUSTER_NODE_SHUTTING_DOWN, "The cluster node is shutting down." },
	{ WERR_CLUSTER_JOIN_ABORTED, "The cluster join operation was aborted." },
	{ WERR_CLUSTER_INCOMPATIBLE_VERSIONS, "The cluster join operation failed due to incompatible software versions between the joining node and its sponsor." },
	{ WERR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED, "This resource cannot be created because the cluster has reached the limit on the number of resources it can monitor." },
	{ WERR_CLUSTER_SYSTEM_CONFIG_CHANGED, "The system configuration changed during the cluster join or form operation. The join or form operation was aborted." },
	{ WERR_CLUSTER_RESOURCE_TYPE_NOT_FOUND, "The specified resource type was not found." },
	{ WERR_CLUSTER_RESTYPE_NOT_SUPPORTED, "The specified node does not support a resource of this type. This may be due to version inconsistencies or due to the absence of the resource DLL on this node." },
	{ WERR_CLUSTER_RESNAME_NOT_FOUND, "The specified resource name is not supported by this resource DLL. This may be due to a bad (or changed) name supplied to the resource DLL." },
	{ WERR_CLUSTER_NO_RPC_PACKAGES_REGISTERED, "No authentication package could be registered with the RPC server." },
	{ WERR_CLUSTER_OWNER_NOT_IN_PREFLIST, "You cannot bring the group online because the owner of the group is not in the preferred list for the group. To change the owner node for the group, move the group." },
	{ WERR_CLUSTER_DATABASE_SEQMISMATCH, "The join operation failed because the cluster database sequence number has changed or is incompatible with the locker node. This may happen during a join operation if the cluster database was changing during the join." },
	{ WERR_RESMON_INVALID_STATE, "The resource monitor will not allow the fail operation to be performed while the resource is in its current state. This may happen if the resource is in a pending state." },
	{ WERR_CLUSTER_GUM_NOT_LOCKER, "A non-locker code received a request to reserve the lock for making global updates." },
	{ WERR_QUORUM_DISK_NOT_FOUND, "The quorum disk could not be located by the cluster service." },
	{ WERR_DATABASE_BACKUP_CORRUPT, "The backed-up cluster database is possibly corrupt." },
	{ WERR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT, "A DFS root already exists in this cluster node." },
	{ WERR_RESOURCE_PROPERTY_UNCHANGEABLE, "An attempt to modify a resource property failed because it conflicts with another existing property." },
	{ WERR_CLUSTER_MEMBERSHIP_INVALID_STATE, "An operation was attempted that is incompatible with the current membership state of the node." },
	{ WERR_CLUSTER_QUORUMLOG_NOT_FOUND, "The quorum resource does not contain the quorum log." },
	{ WERR_CLUSTER_MEMBERSHIP_HALT, "The membership engine requested shutdown of the cluster service on this node." },
	{ WERR_CLUSTER_INSTANCE_ID_MISMATCH, "The join operation failed because the cluster instance ID of the joining node does not match the cluster instance ID of the sponsor node." },
	{ WERR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP, "A matching cluster network for the specified IP address could not be found." },
	{ WERR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH, "The actual data type of the property did not match the expected data type of the property." },
	{ WERR_CLUSTER_EVICT_WITHOUT_CLEANUP, "The cluster node was evicted from the cluster successfully, but the node was not cleaned up. To determine what clean-up steps failed and how to recover, see the Failover Clustering application event log using Event Viewer." },
	{ WERR_CLUSTER_PARAMETER_MISMATCH, "Two or more parameter values specified for a resource\'s properties are in conflict." },
	{ WERR_NODE_CANNOT_BE_CLUSTERED, "This computer cannot be made a member of a cluster." },
	{ WERR_CLUSTER_WRONG_OS_VERSION, "This computer cannot be made a member of a cluster because it does not have the correct version of Windows installed." },
	{ WERR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME, "A cluster cannot be created with the specified cluster name because that cluster name is already in use. Specify a different name for the cluster." },
	{ WERR_CLUSCFG_ALREADY_COMMITTED, "The cluster configuration action has already been committed." },
	{ WERR_CLUSCFG_ROLLBACK_FAILED, "The cluster configuration action could not be rolled back." },
	{ WERR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT, "The drive letter assigned to a system disk on one node conflicted with the drive letter assigned to a disk on another node." },
	{ WERR_CLUSTER_OLD_VERSION, "One or more nodes in the cluster are running a version of Windows that does not support this operation." },
	{ WERR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME, "The name of the corresponding computer account does not match the network name for this resource." },
	{ WERR_CLUSTER_NO_NET_ADAPTERS, "No network adapters are available." },
	{ WERR_CLUSTER_POISONED, "The cluster node has been poisoned." },
	{ WERR_CLUSTER_GROUP_MOVING, "The group is unable to accept the request because it is moving to another node." },
	{ WERR_CLUSTER_RESOURCE_TYPE_BUSY, "The resource type cannot accept the request because it is too busy performing another operation." },
	{ WERR_RESOURCE_CALL_TIMED_OUT, "The call to the cluster resource DLL timed out." },
	{ WERR_INVALID_CLUSTER_IPV6_ADDRESS, "The address is not valid for an IPv6 Address resource. A global IPv6 address is required, and it must match a cluster network. Compatibility addresses are not permitted." },
	{ WERR_CLUSTER_INTERNAL_INVALID_FUNCTION, "An internal cluster error occurred. A call to an invalid function was attempted." },
	{ WERR_CLUSTER_PARAMETER_OUT_OF_BOUNDS, "A parameter value is out of acceptable range." },
	{ WERR_CLUSTER_PARTIAL_SEND, "A network error occurred while sending data to another node in the cluster. The number of bytes transmitted was less than required." },
	{ WERR_CLUSTER_REGISTRY_INVALID_FUNCTION, "An invalid cluster registry operation was attempted." },
	{ WERR_CLUSTER_INVALID_STRING_TERMINATION, "An input string of characters is not properly terminated." },
	{ WERR_CLUSTER_INVALID_STRING_FORMAT, "An input string of characters is not in a valid format for the data it represents." },
	{ WERR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS, "An internal cluster error occurred. A cluster database transaction was attempted while a transaction was already in progress." },
	{ WERR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS, "An internal cluster error occurred. There was an attempt to commit a cluster database transaction while no transaction was in progress." },
	{ WERR_CLUSTER_NULL_DATA, "An internal cluster error occurred. Data was not properly initialized." },
	{ WERR_CLUSTER_PARTIAL_READ, "An error occurred while reading from a stream of data. An unexpected number of bytes was returned." },
	{ WERR_CLUSTER_PARTIAL_WRITE, "An error occurred while writing to a stream of data. The required number of bytes could not be written." },
	{ WERR_CLUSTER_CANT_DESERIALIZE_DATA, "An error occurred while deserializing a stream of cluster data." },
	{ WERR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT, "One or more property values for this resource are in conflict with one or more property values associated with its dependent resources." },
	{ WERR_CLUSTER_NO_QUORUM, "A quorum of cluster nodes was not present to form a cluster." },
	{ WERR_CLUSTER_INVALID_IPV6_NETWORK, "The cluster network is not valid for an IPv6 address resource, or it does not match the configured address." },
	{ WERR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK, "The cluster network is not valid for an IPv6 tunnel resource. Check the configuration of the IP Address resource on which the IPv6 tunnel resource depends." },
	{ WERR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP, "Quorum resource cannot reside in the available storage group." },
	{ WERR_ENCRYPTION_FAILED, "The specified file could not be encrypted." },
	{ WERR_DECRYPTION_FAILED, "The specified file could not be decrypted." },
	{ WERR_FILE_ENCRYPTED, "The specified file is encrypted and the user does not have the ability to decrypt it." },
	{ WERR_NO_RECOVERY_POLICY, "There is no valid encryption recovery policy configured for this system." },
	{ WERR_NO_EFS, "The required encryption driver is not loaded for this system." },
	{ WERR_WRONG_EFS, "The file was encrypted with a different encryption driver than is currently loaded." },
	{ WERR_NO_USER_KEYS, "There are no Encrypting File System (EFS) keys defined for the user." },
	{ WERR_FILE_NOT_ENCRYPTED, "The specified file is not encrypted." },
	{ WERR_NOT_EXPORT_FORMAT, "The specified file is not in the defined EFS export format." },
	{ WERR_FILE_READ_ONLY, "The specified file is read-only." },
	{ WERR_DIR_EFS_DISALLOWED, "The directory has been disabled for encryption." },
	{ WERR_EFS_SERVER_NOT_TRUSTED, "The server is not trusted for remote encryption operation." },
	{ WERR_BAD_RECOVERY_POLICY, "Recovery policy configured for this system contains invalid recovery certificate." },
	{ WERR_EFS_ALG_BLOB_TOO_BIG, "The encryption algorithm used on the source file needs a bigger key buffer than the one on the destination file." },
	{ WERR_VOLUME_NOT_SUPPORT_EFS, "The disk partition does not support file encryption." },
	{ WERR_EFS_DISABLED, "This machine is disabled for file encryption." },
	{ WERR_EFS_VERSION_NOT_SUPPORT, "A newer system is required to decrypt this encrypted file." },
	{ WERR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE, "The remote server sent an invalid response for a file being opened with client-side encryption." },
	{ WERR_CS_ENCRYPTION_UNSUPPORTED_SERVER, "Client-side encryption is not supported by the remote server even though it claims to support it." },
	{ WERR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE, "File is encrypted and should be opened in client-side encryption mode." },
	{ WERR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE, "A new encrypted file is being created and a $EFS needs to be provided." },
	{ WERR_CS_ENCRYPTION_FILE_NOT_CSE, "The SMB client requested a client-side extension (CSE) file system control (FSCTL) on a non-CSE file." },
	{ WERR_NO_BROWSER_SERVERS_FOUND, "The list of servers for this workgroup is not currently available" },
	{ WERR_LOG_SECTOR_INVALID, "The log service encountered an invalid log sector." },
	{ WERR_LOG_SECTOR_PARITY_INVALID, "The log service encountered a log sector with invalid block parity." },
	{ WERR_LOG_SECTOR_REMAPPED, "The log service encountered a remapped log sector." },
	{ WERR_LOG_BLOCK_INCOMPLETE, "The log service encountered a partial or incomplete log block." },
	{ WERR_LOG_INVALID_RANGE, "The log service encountered an attempt to access data outside the active log range." },
	{ WERR_LOG_BLOCKS_EXHAUSTED, "The log service user marshaling buffers are exhausted." },
	{ WERR_LOG_READ_CONTEXT_INVALID, "The log service encountered an attempt to read from a marshaling area with an invalid read context." },
	{ WERR_LOG_RESTART_INVALID, "The log service encountered an invalid log restart area." },
	{ WERR_LOG_BLOCK_VERSION, "The log service encountered an invalid log block version." },
	{ WERR_LOG_BLOCK_INVALID, "The log service encountered an invalid log block." },
	{ WERR_LOG_READ_MODE_INVALID, "The log service encountered an attempt to read the log with an invalid read mode." },
	{ WERR_LOG_NO_RESTART, "The log service encountered a log stream with no restart area." },
	{ WERR_LOG_METADATA_CORRUPT, "The log service encountered a corrupted metadata file." },
	{ WERR_LOG_METADATA_INVALID, "The log service encountered a metadata file that could not be created by the log file system." },
	{ WERR_LOG_METADATA_INCONSISTENT, "The log service encountered a metadata file with inconsistent data." },
	{ WERR_LOG_RESERVATION_INVALID, "The log service encountered an attempt to erroneous allocate or dispose reservation space." },
	{ WERR_LOG_CANT_DELETE, "The log service cannot delete a log file or file system container." },
	{ WERR_LOG_CONTAINER_LIMIT_EXCEEDED, "The log service has reached the maximum allowable containers allocated to a log file." },
	{ WERR_LOG_START_OF_LOG, "The log service has attempted to read or write backward past the start of the log." },
	{ WERR_LOG_POLICY_ALREADY_INSTALLED, "The log policy could not be installed because a policy of the same type is already present." },
	{ WERR_LOG_POLICY_NOT_INSTALLED, "The log policy in question was not installed at the time of the request." },
	{ WERR_LOG_POLICY_INVALID, "The installed set of policies on the log is invalid." },
	{ WERR_LOG_POLICY_CONFLICT, "A policy on the log in question prevented the operation from completing." },
	{ WERR_LOG_PINNED_ARCHIVE_TAIL, "Log space cannot be reclaimed because the log is pinned by the archive tail." },
	{ WERR_LOG_RECORD_NONEXISTENT, "The log record is not a record in the log file." },
	{ WERR_LOG_RECORDS_RESERVED_INVALID, "The number of reserved log records or the adjustment of the number of reserved log records is invalid." },
	{ WERR_LOG_SPACE_RESERVED_INVALID, "The reserved log space or the adjustment of the log space is invalid." },
	{ WERR_LOG_TAIL_INVALID, "A new or existing archive tail or base of the active log is invalid." },
	{ WERR_LOG_FULL, "The log space is exhausted." },
	{ WERR_COULD_NOT_RESIZE_LOG, "The log could not be set to the requested size." },
	{ WERR_LOG_MULTIPLEXED, "The log is multiplexed; no direct writes to the physical log are allowed." },
	{ WERR_LOG_DEDICATED, "The operation failed because the log is a dedicated log." },
	{ WERR_LOG_ARCHIVE_NOT_IN_PROGRESS, "The operation requires an archive context." },
	{ WERR_LOG_ARCHIVE_IN_PROGRESS, "Log archival is in progress." },
	{ WERR_LOG_EPHEMERAL, "The operation requires a non-ephemeral log, but the log is ephemeral." },
	{ WERR_LOG_NOT_ENOUGH_CONTAINERS, "The log must have at least two containers before it can be read from or written to." },
	{ WERR_LOG_CLIENT_ALREADY_REGISTERED, "A log client has already registered on the stream." },
	{ WERR_LOG_CLIENT_NOT_REGISTERED, "A log client has not been registered on the stream." },
	{ WERR_LOG_FULL_HANDLER_IN_PROGRESS, "A request has already been made to handle the log full condition." },
	{ WERR_LOG_CONTAINER_READ_FAILED, "The log service encountered an error when attempting to read from a log container." },
	{ WERR_LOG_CONTAINER_WRITE_FAILED, "The log service encountered an error when attempting to write to a log container." },
	{ WERR_LOG_CONTAINER_OPEN_FAILED, "The log service encountered an error when attempting to open a log container." },
	{ WERR_LOG_CONTAINER_STATE_INVALID, "The log service encountered an invalid container state when attempting a requested action." },
	{ WERR_LOG_STATE_INVALID, "The log service is not in the correct state to perform a requested action." },
	{ WERR_LOG_PINNED, "The log space cannot be reclaimed because the log is pinned." },
	{ WERR_LOG_METADATA_FLUSH_FAILED, "The log metadata flush failed." },
	{ WERR_LOG_INCONSISTENT_SECURITY, "Security on the log and its containers is inconsistent." },
	{ WERR_LOG_APPENDED_FLUSH_FAILED, "Records were appended to the log or reservation changes were made, but the log could not be flushed." },
	{ WERR_LOG_PINNED_RESERVATION, "The log is pinned due to reservation consuming most of the log space. Free some reserved records to make space available." },
	{ WERR_INVALID_TRANSACTION, "The transaction handle associated with this operation is not valid." },
	{ WERR_TRANSACTION_NOT_ACTIVE, "The requested operation was made in the context of a transaction that is no longer active." },
	{ WERR_TRANSACTION_REQUEST_NOT_VALID, "The requested operation is not valid on the transaction object in its current state." },
	{ WERR_TRANSACTION_NOT_REQUESTED, "The caller has called a response API, but the response is not expected because the transaction manager did not issue the corresponding request to the caller." },
	{ WERR_TRANSACTION_ALREADY_ABORTED, "It is too late to perform the requested operation because the transaction has already been aborted." },
	{ WERR_TRANSACTION_ALREADY_COMMITTED, "It is too late to perform the requested operation because the transaction has already been committed." },
	{ WERR_TM_INITIALIZATION_FAILED, "The transaction manager was unable to be successfully initialized. Transacted operations are not supported." },
	{ WERR_RESOURCEMANAGER_READ_ONLY, "The specified resource manager made no changes or updates to the resource under this transaction." },
	{ WERR_TRANSACTION_NOT_JOINED, "The resource manager has attempted to prepare a transaction that it has not successfully joined." },
	{ WERR_TRANSACTION_SUPERIOR_EXISTS, "The transaction object already has a superior enlistment, and the caller attempted an operation that would have created a new superior. Only a single superior enlistment is allowed." },
	{ WERR_CRM_PROTOCOL_ALREADY_EXISTS, "The resource manager tried to register a protocol that already exists." },
	{ WERR_TRANSACTION_PROPAGATION_FAILED, "The attempt to propagate the transaction failed." },
	{ WERR_CRM_PROTOCOL_NOT_FOUND, "The requested propagation protocol was not registered as a CRM." },
	{ WERR_TRANSACTION_INVALID_MARSHALL_BUFFER, "The buffer passed in to PushTransaction or PullTransaction is not in a valid format." },
	{ WERR_CURRENT_TRANSACTION_NOT_VALID, "The current transaction context associated with the thread is not a valid handle to a transaction object." },
	{ WERR_TRANSACTION_NOT_FOUND, "The specified transaction object could not be opened because it was not found." },
	{ WERR_RESOURCEMANAGER_NOT_FOUND, "The specified resource manager object could not be opened because it was not found." },
	{ WERR_ENLISTMENT_NOT_FOUND, "The specified enlistment object could not be opened because it was not found." },
	{ WERR_TRANSACTIONMANAGER_NOT_FOUND, "The specified transaction manager object could not be opened because it was not found." },
	{ WERR_TRANSACTIONMANAGER_NOT_ONLINE, "The specified resource manager was unable to create an enlistment because its associated transaction manager is not online." },
	{ WERR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION, "The specified transaction manager was unable to create the objects contained in its log file in the ObjectB namespace. Therefore, the transaction manager was unable to recover." },
	{ WERR_TRANSACTIONAL_CONFLICT, "The function attempted to use a name that is reserved for use by another transaction." },
	{ WERR_RM_NOT_ACTIVE, "Transaction support within the specified file system resource manager is not started or was shut down due to an error." },
	{ WERR_RM_METADATA_CORRUPT, "The metadata of the resource manager has been corrupted. The resource manager will not function." },
	{ WERR_DIRECTORY_NOT_RM, "The specified directory does not contain a resource manager." },
	{ WERR_TRANSACTIONS_UNSUPPORTED_REMOTE, "The remote server or share does not support transacted file operations." },
	{ WERR_LOG_RESIZE_INVALID_SIZE, "The requested log size is invalid." },
	{ WERR_OBJECT_NO_LONGER_EXISTS, "The object (file, stream, link) corresponding to the handle has been deleted by a transaction savepoint rollback." },
	{ WERR_STREAM_MINIVERSION_NOT_FOUND, "The specified file miniversion was not found for this transacted file open." },
	{ WERR_STREAM_MINIVERSION_NOT_VALID, "The specified file miniversion was found but has been invalidated. The most likely cause is a transaction savepoint rollback." },
	{ WERR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION, "A miniversion may only be opened in the context of the transaction that created it." },
	{ WERR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT, "It is not possible to open a miniversion with modify access." },
	{ WERR_CANT_CREATE_MORE_STREAM_MINIVERSIONS, "It is not possible to create any more miniversions for this stream." },
	{ WERR_REMOTE_FILE_VERSION_MISMATCH, "The remote server sent mismatching version numbers or FID for a file opened with transactions." },
	{ WERR_HANDLE_NO_LONGER_VALID, "The handle has been invalidated by a transaction. The most likely cause is the presence of memory mapping on a file, or an open handle when the transaction ended or rolled back to savepoint." },
	{ WERR_NO_TXF_METADATA, "There is no transaction metadata on the file." },
	{ WERR_LOG_CORRUPTION_DETECTED, "The log data is corrupt." },
	{ WERR_CANT_RECOVER_WITH_HANDLE_OPEN, "The file cannot be recovered because a handle is still open on it." },
	{ WERR_RM_DISCONNECTED, "The transaction outcome is unavailable because the resource manager responsible for it is disconnected." },
	{ WERR_ENLISTMENT_NOT_SUPERIOR, "The request was rejected because the enlistment in question is not a superior enlistment." },
	{ WERR_RECOVERY_NOT_NEEDED, "The transactional resource manager is already consistent. Recovery is not needed." },
	{ WERR_RM_ALREADY_STARTED, "The transactional resource manager has already been started." },
	{ WERR_FILE_IDENTITY_NOT_PERSISTENT, "The file cannot be opened in a transaction because its identity depends on the outcome of an unresolved transaction." },
	{ WERR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY, "The operation cannot be performed because another transaction is depending on the fact that this property will not change." },
	{ WERR_CANT_CROSS_RM_BOUNDARY, "The operation would involve a single file with two transactional resource managers and is therefore not allowed." },
	{ WERR_TXF_DIR_NOT_EMPTY, "The $Txf directory must be empty for this operation to succeed." },
	{ WERR_INDOUBT_TRANSACTIONS_EXIST, "The operation would leave a transactional resource manager in an inconsistent state and is, therefore, not allowed." },
	{ WERR_TM_VOLATILE, "The operation could not be completed because the transaction manager does not have a log." },
	{ WERR_ROLLBACK_TIMER_EXPIRED, "A rollback could not be scheduled because a previously scheduled rollback has already been executed or is queued for execution." },
	{ WERR_TXF_ATTRIBUTE_CORRUPT, "The transactional metadata attribute on the file or directory is corrupt and unreadable." },
	{ WERR_EFS_NOT_ALLOWED_IN_TRANSACTION, "The encryption operation could not be completed because a transaction is active." },
	{ WERR_TRANSACTIONAL_OPEN_NOT_ALLOWED, "This object is not allowed to be opened in a transaction." },
	{ WERR_LOG_GROWTH_FAILED, "An attempt to create space in the transactional resource manager\'s log failed. The failure status has been recorded in the event log." },
	{ WERR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE, "Memory mapping (creating a mapped section) to a remote file under a transaction is not supported." },
	{ WERR_TXF_METADATA_ALREADY_PRESENT, "Transaction metadata is already present on this file and cannot be superseded." },
	{ WERR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET, "A transaction scope could not be entered because the scope handler has not been initialized." },
	{ WERR_TRANSACTION_REQUIRED_PROMOTION, "Promotion was required to allow the resource manager to enlist, but the transaction was set to disallow it." },
	{ WERR_CANNOT_EXECUTE_FILE_IN_TRANSACTION, "This file is open for modification in an unresolved transaction and may be opened for execution only by a transacted reader." },
	{ WERR_TRANSACTIONS_NOT_FROZEN, "The request to thaw frozen transactions was ignored because transactions were not previously frozen." },
	{ WERR_TRANSACTION_FREEZE_IN_PROGRESS, "Transactions cannot be frozen because a freeze is already in progress." },
	{ WERR_NOT_SNAPSHOT_VOLUME, "The target volume is not a snapshot volume. This operation is only valid on a volume mounted as a snapshot." },
	{ WERR_NO_SAVEPOINT_WITH_OPEN_FILES, "The savepoint operation failed because files are open on the transaction. This is not permitted." },
	{ WERR_DATA_LOST_REPAIR, "Windows has discovered corruption in a file, and that file has since been repaired. Data loss may have occurred." },
	{ WERR_SPARSE_NOT_ALLOWED_IN_TRANSACTION, "The sparse operation could not be completed because a transaction is active on the file." },
	{ WERR_TM_IDENTITY_MISMATCH, "The call to create a transaction manager object failed because the Tm Identity stored in the logfile does not match the Tm Identity that was passed in as an argument." },
	{ WERR_FLOATED_SECTION, "I/O was attempted on a section object that has been floated as a result of a transaction ending. There is no valid data." },
	{ WERR_CANNOT_ACCEPT_TRANSACTED_WORK, "The transactional resource manager cannot currently accept transacted work due to a transient condition, such as low resources." },
	{ WERR_CANNOT_ABORT_TRANSACTIONS, "The transactional resource manager had too many transactions outstanding that could not be aborted. The transactional resource manager has been shut down." },
	{ WERR_CTX_WINSTATION_NAME_INVALID, "The specified session name is invalid." },
	{ WERR_CTX_INVALID_PD, "The specified protocol driver is invalid." },
	{ WERR_CTX_PD_NOT_FOUND, "The specified protocol driver was not found in the system path." },
	{ WERR_CTX_WD_NOT_FOUND, "The specified terminal connection driver was not found in the system path." },
	{ WERR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY, "A registry key for event logging could not be created for this session." },
	{ WERR_CTX_SERVICE_NAME_COLLISION, "A service with the same name already exists on the system." },
	{ WERR_CTX_CLOSE_PENDING, "A close operation is pending on the session." },
	{ WERR_CTX_NO_OUTBUF, "There are no free output buffers available." },
	{ WERR_CTX_MODEM_INF_NOT_FOUND, "The MODEM.INF file was not found." },
	{ WERR_CTX_INVALID_MODEMNAME, "The modem name was not found in the MODEM.INF file." },
	{ WERR_CTX_MODEM_RESPONSE_ERROR, "The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem." },
	{ WERR_CTX_MODEM_RESPONSE_TIMEOUT, "The modem did not respond to the command sent to it. Verify that the modem is properly cabled and turned on." },
	{ WERR_CTX_MODEM_RESPONSE_NO_CARRIER, "Carrier detect has failed or carrier has been dropped due to disconnect." },
	{ WERR_CTX_MODEM_RESPONSE_NO_DIALTONE, "Dial tone not detected within the required time. Verify that the phone cable is properly attached and functional." },
	{ WERR_CTX_MODEM_RESPONSE_BUSY, "Busy signal detected at remote site on callback." },
	{ WERR_CTX_MODEM_RESPONSE_VOICE, "Voice detected at remote site on callback." },
	{ WERR_CTX_TD_ERROR, "Transport driver error" },
	{ WERR_CTX_WINSTATION_NOT_FOUND, "The specified session cannot be found." },
	{ WERR_CTX_WINSTATION_ALREADY_EXISTS, "The specified session name is already in use." },
	{ WERR_CTX_WINSTATION_BUSY, "The requested operation cannot be completed because the terminal connection is currently busy processing a connect, disconnect, reset, or delete operation." },
	{ WERR_CTX_BAD_VIDEO_MODE, "An attempt has been made to connect to a session whose video mode is not supported by the current client." },
	{ WERR_CTX_GRAPHICS_INVALID, "The application attempted to enable DOS graphics mode. DOS graphics mode is not supported." },
	{ WERR_CTX_LOGON_DISABLED, "Your interactive logon privilege has been disabled. Contact your administrator." },
	{ WERR_CTX_NOT_CONSOLE, "The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access." },
	{ WERR_CTX_CLIENT_QUERY_TIMEOUT, "The client failed to respond to the server connect message." },
	{ WERR_CTX_CONSOLE_DISCONNECT, "Disconnecting the console session is not supported." },
	{ WERR_CTX_CONSOLE_CONNECT, "Reconnecting a disconnected session to the console is not supported." },
	{ WERR_CTX_SHADOW_DENIED, "The request to control another session remotely was denied." },
	{ WERR_CTX_WINSTATION_ACCESS_DENIED, "The requested session access is denied." },
	{ WERR_CTX_INVALID_WD, "The specified terminal connection driver is invalid." },
	{ WERR_CTX_SHADOW_INVALID, "The requested session cannot be controlled remotely. This may be because the session is disconnected or does not currently have a user logged on." },
	{ WERR_CTX_SHADOW_DISABLED, "The requested session is not configured to allow remote control." },
	{ WERR_CTX_CLIENT_LICENSE_IN_USE, "Your request to connect to this terminal server has been rejected. Your terminal server client license number is currently being used by another user. Call your system administrator to obtain a unique license number." },
	{ WERR_CTX_CLIENT_LICENSE_NOT_SET, "Your request to connect to this terminal server has been rejected. Your terminal server client license number has not been entered for this copy of the terminal server client. Contact your system administrator." },
	{ WERR_CTX_LICENSE_NOT_AVAILABLE, "The number of connections to this computer is limited and all connections are in use right now. Try connecting later or contact your system administrator." },
	{ WERR_CTX_LICENSE_CLIENT_INVALID, "The client you are using is not licensed to use this system. Your logon request is denied." },
	{ WERR_CTX_LICENSE_EXPIRED, "The system license has expired. Your logon request is denied." },
	{ WERR_CTX_SHADOW_NOT_RUNNING, "Remote control could not be terminated because the specified session is not currently being remotely controlled." },
	{ WERR_CTX_SHADOW_ENDED_BY_MODE_CHANGE, "The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported." },
	{ WERR_ACTIVATION_COUNT_EXCEEDED, "Activation has already been reset the maximum number of times for this installation. Your activation timer will not be cleared." },
	{ WERR_CTX_WINSTATIONS_DISABLED, "Remote logons are currently disabled." },
	{ WERR_CTX_ENCRYPTION_LEVEL_REQUIRED, "You do not have the proper encryption level to access this session." },
	{ WERR_CTX_SESSION_IN_USE, "The user %s\\%s is currently logged on to this computer. Only the current user or an administrator can log on to this computer." },
	{ WERR_CTX_NO_FORCE_LOGOFF, "The user %s\\%s is already logged on to the console of this computer. You do not have permission to log in at this time. To resolve this issue, contact %s\\%s and have them log off." },
	{ WERR_CTX_ACCOUNT_RESTRICTION, "Unable to log you on because of an account restriction." },
	{ WERR_RDP_PROTOCOL_ERROR, "The RDP component %2 detected an error in the protocol stream and has disconnected the client." },
	{ WERR_CTX_CDM_CONNECT, "The Client Drive Mapping Service has connected on terminal connection." },
	{ WERR_CTX_CDM_DISCONNECT, "The Client Drive Mapping Service has disconnected on terminal connection." },
	{ WERR_CTX_SECURITY_LAYER_ERROR, "The terminal server security layer detected an error in the protocol stream and has disconnected the client." },
	{ WERR_TS_INCOMPATIBLE_SESSIONS, "The target session is incompatible with the current session." },
	{ WERR_FRS_ERR_INVALID_API_SEQUENCE, "The file replication service API was called incorrectly." },
	{ WERR_FRS_ERR_STARTING_SERVICE, "The file replication service cannot be started." },
	{ WERR_FRS_ERR_STOPPING_SERVICE, "The file replication service cannot be stopped." },
	{ WERR_FRS_ERR_INTERNAL_API, "The file replication service API terminated the request. The event log may have more information." },
	{ WERR_FRS_ERR_INTERNAL, "The file replication service terminated the request. The event log may have more information." },
	{ WERR_FRS_ERR_SERVICE_COMM, "The file replication service cannot be contacted. The event log may have more information." },
	{ WERR_FRS_ERR_INSUFFICIENT_PRIV, "The file replication service cannot satisfy the request because the user has insufficient privileges. The event log may have more information." },
	{ WERR_FRS_ERR_AUTHENTICATION, "The file replication service cannot satisfy the request because authenticated RPC is not available. The event log may have more information." },
	{ WERR_FRS_ERR_PARENT_INSUFFICIENT_PRIV, "The file replication service cannot satisfy the request because the user has insufficient privileges on the domain controller. The event log may have more information." },
	{ WERR_FRS_ERR_PARENT_AUTHENTICATION, "The file replication service cannot satisfy the request because authenticated RPC is not available on the domain controller. The event log may have more information." },
	{ WERR_FRS_ERR_CHILD_TO_PARENT_COMM, "The file replication service cannot communicate with the file replication service on the domain controller. The event log may have more information." },
	{ WERR_FRS_ERR_PARENT_TO_CHILD_COMM, "The file replication service on the domain controller cannot communicate with the file replication service on this computer. The event log may have more information." },
	{ WERR_FRS_ERR_SYSVOL_POPULATE, "The file replication service cannot populate the system volume because of an internal error. The event log may have more information." },
	{ WERR_FRS_ERR_SYSVOL_POPULATE_TIMEOUT, "The file replication service cannot populate the system volume because of an internal time-out. The event log may have more information." },
	{ WERR_FRS_ERR_SYSVOL_IS_BUSY, "The file replication service cannot process the request. The system volume is busy with a previous request." },
	{ WERR_FRS_ERR_SYSVOL_DEMOTE, "The file replication service cannot stop replicating the system volume because of an internal error. The event log may have more information." },
	{ WERR_FRS_ERR_INVALID_SERVICE_PARAMETER, "The file replication service detected an invalid parameter." },
	{ WERR_DS_NOT_INSTALLED, "An error occurred while installing the directory service. For more information, see the event log." },
	{ WERR_DS_MEMBERSHIP_EVALUATED_LOCALLY, "The directory service evaluated group memberships locally." },
	{ WERR_DS_NO_ATTRIBUTE_OR_VALUE, "The specified directory service attribute or value does not exist." },
	{ WERR_DS_INVALID_ATTRIBUTE_YNTAX, "The attribute syntax specified to the directory service is invalid." },
	{ WERR_DS_ATTRIBUTE_TYPE_UNDEFINED, "The attribute type specified to the directory service is not defined." },
	{ WERR_DS_ATTRIBUTE_OR_VALUE_EXISTS, "The specified directory service attribute or value already exists." },
	{ WERR_DS_BUSY, "The directory service is busy." },
	{ WERR_DS_UNAVAILABLE, "The directory service is unavailable." },
	{ WERR_DS_NO_RIDS_ALLOCATED, "The directory service was unable to allocate a relative identifier." },
	{ WERR_DS_NO_MORE_RIDS, "The directory service has exhausted the pool of relative identifiers." },
	{ WERR_DS_INCORRECT_ROLE_OWNER, "The requested operation could not be performed because the directory service is not the master for that type of operation." },
	{ WERR_DS_RIDMGR_INIT_ERROR, "The directory service was unable to initialize the subsystem that allocates relative identifiers." },
	{ WERR_DS_OBJ_CLASS_VIOLATION, "The requested operation did not satisfy one or more constraints associated with the class of the object." },
	{ WERR_DS_CANT_ON_NON_LEAF, "The directory service can perform the requested operation only on a leaf object." },
	{ WERR_DS_CANT_ON_RDN, "The directory service cannot perform the requested operation on the relative distinguished name (RDN) attribute of an object." },
	{ WERR_DS_CANT_MOD_OBJ_CLASS, "The directory service detected an attempt to modify the object class of an object." },
	{ WERR_DS_CROSS_DOM_MOVE_ERROR, "The requested cross-domain move operation could not be performed." },
	{ WERR_DS_GC_NOT_AVAILABLE, "Unable to contact the global catalog (GC) server." },
	{ WERR_SHARED_POLICY, "The policy object is shared and can only be modified at the root." },
	{ WERR_POLICY_OBJECT_NOT_FOUND, "The policy object does not exist." },
	{ WERR_POLICY_ONLY_IN_DS, "The requested policy information is only in the directory service." },
	{ WERR_PROMOTION_ACTIVE, "A domain controller promotion is currently active." },
	{ WERR_NO_PROMOTION_ACTIVE, "A domain controller promotion is not currently active." },
	{ WERR_DS_OPERATIONS_ERROR, "An operations error occurred." },
	{ WERR_DS_PROTOCOL_ERROR, "A protocol error occurred." },
	{ WERR_DS_TIMELIMIT_EXCEEDED, "The time limit for this request was exceeded." },
	{ WERR_DS_SIZELIMIT_EXCEEDED, "The size limit for this request was exceeded." },
	{ WERR_DS_ADMIN_LIMIT_EXCEEDED, "The administrative limit for this request was exceeded." },
	{ WERR_DS_COMPARE_FALSE, "The compare response was false." },
	{ WERR_DS_COMPARE_TRUE, "The compare response was true." },
	{ WERR_DS_AUTH_METHOD_NOT_SUPPORTED, "The requested authentication method is not supported by the server." },
	{ WERR_DS_STRONG_AUTH_REQUIRED, "A more secure authentication method is required for this server." },
	{ WERR_DS_INAPPROPRIATE_AUTH, "Inappropriate authentication." },
	{ WERR_DS_AUTH_UNKNOWN, "The authentication mechanism is unknown." },
	{ WERR_DS_REFERRAL, "A referral was returned from the server." },
	{ WERR_DS_UNAVAILABLE_CRIT_EXTENSION, "The server does not support the requested critical extension." },
	{ WERR_DS_CONFIDENTIALITY_REQUIRED, "This request requires a secure connection." },
	{ WERR_DS_INAPPROPRIATE_MATCHING, "Inappropriate matching." },
	{ WERR_DS_CONSTRAINT_VIOLATION, "A constraint violation occurred." },
	{ WERR_DS_NO_SUCH_OBJECT, "There is no such object on the server." },
	{ WERR_DS_ALIAS_PROBLEM, "There is an alias problem." },
	{ WERR_DS_INVALID_DN_SYNTAX, "An invalid dn syntax has been specified." },
	{ WERR_DS_IS_LEAF, "The object is a leaf object." },
	{ WERR_DS_ALIAS_DEREF_PROBLEM, "There is an alias dereferencing problem." },
	{ WERR_DS_UNWILLING_TO_PERFORM, "The server is unwilling to process the request." },
	{ WERR_DS_LOOP_DETECT, "A loop has been detected." },
	{ WERR_DS_NAMING_VIOLATION, "There is a naming violation." },
	{ WERR_DS_OBJECT_RESULTS_TOO_LARGE, "The result set is too large." },
	{ WERR_DS_AFFECTS_MULTIPLE_DSAS, "The operation affects multiple DSAs." },
	{ WERR_DS_SERVER_DOWN, "The server is not operational." },
	{ WERR_DS_LOCAL_ERROR, "A local error has occurred." },
	{ WERR_DS_ENCODING_ERROR, "An encoding error has occurred." },
	{ WERR_DS_DECODING_ERROR, "A decoding error has occurred." },
	{ WERR_DS_FILTER_UNKNOWN, "The search filter cannot be recognized." },
	{ WERR_DS_PARAM_ERROR, "One or more parameters are illegal." },
	{ WERR_DS_NOT_SUPPORTED, "The specified method is not supported." },
	{ WERR_DS_NO_RESULTS_RETURNED, "No results were returned." },
	{ WERR_DS_CONTROL_NOT_FOUND, "The specified control is not supported by the server." },
	{ WERR_DS_CLIENT_LOOP, "A referral loop was detected by the client." },
	{ WERR_DS_REFERRAL_LIMIT_EXCEEDED, "The preset referral limit was exceeded." },
	{ WERR_DS_SORT_CONTROL_MISSING, "The search requires a SORT control." },
	{ WERR_DS_OFFSET_RANGE_ERROR, "The search results exceed the offset range specified." },
	{ WERR_DS_ROOT_MUST_BE_NC, "The root object must be the head of a naming context. The root object cannot have an instantiated parent." },
	{ WERR_DS_ADD_REPLICA_INHIBITED, "The add replica operation cannot be performed. The naming context must be writable to create the replica." },
	{ WERR_DS_ATT_NOT_DEF_IN_SCHEMA, "A reference to an attribute that is not defined in the schema occurred." },
	{ WERR_DS_MAX_OBJ_SIZE_EXCEEDED, "The maximum size of an object has been exceeded." },
	{ WERR_DS_OBJ_STRING_NAME_EXISTS, "An attempt was made to add an object to the directory with a name that is already in use." },
	{ WERR_DS_NO_RDN_DEFINED_IN_SCHEMA, "An attempt was made to add an object of a class that does not have an RDN defined in the schema." },
	{ WERR_DS_RDN_DOESNT_MATCH_SCHEMA, "An attempt was made to add an object using an RDN that is not the RDN defined in the schema." },
	{ WERR_DS_NO_REQUESTED_ATTS_FOUND, "None of the requested attributes were found on the objects." },
	{ WERR_DS_USER_BUFFER_TO_SMALL, "The user buffer is too small." },
	{ WERR_DS_ATT_IS_NOT_ON_OBJ, "The attribute specified in the operation is not present on the object." },
	{ WERR_DS_ILLEGAL_MOD_OPERATION, "Illegal modify operation. Some aspect of the modification is not permitted." },
	{ WERR_DS_OBJ_TOO_LARGE, "The specified object is too large." },
	{ WERR_DS_BAD_INSTANCE_TYPE, "The specified instance type is not valid." },
	{ WERR_DS_MASTERDSA_REQUIRED, "The operation must be performed at a master DSA." },
	{ WERR_DS_OBJECT_CLASS_REQUIRED, "The object class attribute must be specified." },
	{ WERR_DS_MISSING_REQUIRED_ATT, "A required attribute is missing." },
	{ WERR_DS_ATT_NOT_DEF_FOR_CLASS, "An attempt was made to modify an object to include an attribute that is not legal for its class." },
	{ WERR_DS_ATT_ALREADY_EXISTS, "The specified attribute is already present on the object." },
	{ WERR_DS_CANT_ADD_ATT_VALUES, "The specified attribute is not present, or has no values." },
	{ WERR_DS_SINGLE_VALUE_CONSTRAINT, "Multiple values were specified for an attribute that can have only one value." },
	{ WERR_DS_RANGE_CONSTRAINT, "A value for the attribute was not in the acceptable range of values." },
	{ WERR_DS_ATT_VAL_ALREADY_EXISTS, "The specified value already exists." },
	{ WERR_DS_CANT_REM_MISSING_ATT, "The attribute cannot be removed because it is not present on the object." },
	{ WERR_DS_CANT_REM_MISSING_ATT_VAL, "The attribute value cannot be removed because it is not present on the object." },
	{ WERR_DS_ROOT_CANT_BE_SUBREF, "The specified root object cannot be a subreference." },
	{ WERR_DS_NO_CHAINING, "Chaining is not permitted." },
	{ WERR_DS_NO_CHAINED_EVAL, "Chained evaluation is not permitted." },
	{ WERR_DS_NO_PARENT_OBJECT, "The operation could not be performed because the object\'s parent is either uninstantiated or deleted." },
	{ WERR_DS_PARENT_IS_AN_ALIAS, "Having a parent that is an alias is not permitted. Aliases are leaf objects." },
	{ WERR_DS_CANT_MIX_MASTER_AND_REPS, "The object and parent must be of the same type, either both masters or both replicas." },
	{ WERR_DS_CHILDREN_EXIST, "The operation cannot be performed because child objects exist. This operation can only be performed on a leaf object." },
	{ WERR_DS_OBJ_NOT_FOUND, "Directory object not found." },
	{ WERR_DS_ALIASED_OBJ_MISSING, "The aliased object is missing." },
	{ WERR_DS_BAD_NAME_SYNTAX, "The object name has bad syntax." },
	{ WERR_DS_ALIAS_POINTS_TO_ALIAS, "An alias is not permitted to refer to another alias." },
	{ WERR_DS_CANT_DEREF_ALIAS, "The alias cannot be dereferenced." },
	{ WERR_DS_OUT_OF_SCOPE, "The operation is out of scope." },
	{ WERR_DS_OBJECT_BEING_REMOVED, "The operation cannot continue because the object is in the process of being removed." },
	{ WERR_DS_CANT_DELETE_DSA_OBJ, "The DSA object cannot be deleted." },
	{ WERR_DS_GENERIC_ERROR, "A directory service error has occurred." },
	{ WERR_DS_DSA_MUST_BE_INT_MASTER, "The operation can only be performed on an internal master DSA object." },
	{ WERR_DS_CLASS_NOT_DSA, "The object must be of class DSA." },
	{ WERR_DS_INSUFF_ACCESS_RIGHTS, "Insufficient access rights to perform the operation." },
	{ WERR_DS_ILLEGAL_SUPERIOR, "The object cannot be added because the parent is not on the list of possible superiors." },
	{ WERR_DS_ATTRIBUTE_OWNED_BY_SAM, "Access to the attribute is not permitted because the attribute is owned by the SAM." },
	{ WERR_DS_NAME_TOO_MANY_PARTS, "The name has too many parts." },
	{ WERR_DS_NAME_TOO_LONG, "The name is too long." },
	{ WERR_DS_NAME_VALUE_TOO_LONG, "The name value is too long." },
	{ WERR_DS_NAME_UNPARSEABLE, "The directory service encountered an error parsing a name." },
	{ WERR_DS_NAME_TYPE_UNKNOWN, "The directory service cannot get the attribute type for a name." },
	{ WERR_DS_NOT_AN_OBJECT, "The name does not identify an object; the name identifies a phantom." },
	{ WERR_DS_SEC_DESC_TOO_SHORT, "The security descriptor is too short." },
	{ WERR_DS_SEC_DESC_INVALID, "The security descriptor is invalid." },
	{ WERR_DS_NO_DELETED_NAME, "Failed to create name for deleted object." },
	{ WERR_DS_SUBREF_MUST_HAVE_PARENT, "The parent of a new subreference must exist." },
	{ WERR_DS_NCNAME_MUST_BE_NC, "The object must be a naming context." },
	{ WERR_DS_CANT_ADD_SYSTEM_ONLY, "It is not permitted to add an attribute that is owned by the system." },
	{ WERR_DS_CLASS_MUST_BE_CONCRETE, "The class of the object must be structural; you cannot instantiate an abstract class." },
	{ WERR_DS_INVALID_DMD, "The schema object could not be found." },
	{ WERR_DS_OBJ_GUID_EXISTS, "A local object with this GUID (dead or alive) already exists." },
	{ WERR_DS_NOT_ON_BACKLINK, "The operation cannot be performed on a back link." },
	{ WERR_DS_NO_CROSSREF_FOR_NC, "The cross-reference for the specified naming context could not be found." },
	{ WERR_DS_SHUTTING_DOWN, "The operation could not be performed because the directory service is shutting down." },
	{ WERR_DS_UNKNOWN_OPERATION, "The directory service request is invalid." },
	{ WERR_DS_INVALID_ROLE_OWNER, "The role owner attribute could not be read." },
	{ WERR_DS_COULDNT_CONTACT_FSMO, "The requested Flexible Single Master Operations (FSMO) operation failed. The current FSMO holder could not be contacted." },
	{ WERR_DS_CROSS_NC_DN_RENAME, "Modification of a distinguished name across a naming context is not permitted." },
	{ WERR_DS_CANT_MOD_SYSTEM_ONLY, "The attribute cannot be modified because it is owned by the system." },
	{ WERR_DS_REPLICATOR_ONLY, "Only the replicator can perform this function." },
	{ WERR_DS_OBJ_CLASS_NOT_DEFINED, "The specified class is not defined." },
	{ WERR_DS_OBJ_CLASS_NOT_SUBCLASS, "The specified class is not a subclass." },
	{ WERR_DS_NAME_REFERENCE_INVALID, "The name reference is invalid." },
	{ WERR_DS_CROSS_REF_EXISTS, "A cross-reference already exists." },
	{ WERR_DS_CANT_DEL_MASTER_CROSSREF, "It is not permitted to delete a master cross-reference." },
	{ WERR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD, "Subtree notifications are only supported on naming context (NC) heads." },
	{ WERR_DS_NOTIFY_FILTER_TOO_COMPLEX, "Notification filter is too complex." },
	{ WERR_DS_DUP_RDN, "Schema update failed: Duplicate RDN." },
	{ WERR_DS_DUP_OID, "Schema update failed: Duplicate OID." },
	{ WERR_DS_DUP_MAPI_ID, "Schema update failed: Duplicate Message Application Programming Interface (MAPI) identifier." },
	{ WERR_DS_DUP_SCHEMA_ID_GUID, "Schema update failed: Duplicate schema ID GUID." },
	{ WERR_DS_DUP_LDAP_DISPLAY_NAME, "Schema update failed: Duplicate LDAP display name." },
	{ WERR_DS_SEMANTIC_ATT_TEST, "Schema update failed: Range-Lower less than Range-Upper." },
	{ WERR_DS_SYNTAX_MISMATCH, "Schema update failed: Syntax mismatch." },
	{ WERR_DS_EXISTS_IN_MUST_HAVE, "Schema deletion failed: Attribute is used in the Must-Contain list." },
	{ WERR_DS_EXISTS_IN_MAY_HAVE, "Schema deletion failed: Attribute is used in the May-Contain list." },
	{ WERR_DS_NONEXISTENT_MAY_HAVE, "Schema update failed: Attribute in May-Contain list does not exist." },
	{ WERR_DS_NONEXISTENT_MUST_HAVE, "Schema update failed: Attribute in the Must-Contain list does not exist." },
	{ WERR_DS_AUX_CLS_TEST_FAIL, "Schema update failed: Class in the Aux Class list does not exist or is not an auxiliary class." },
	{ WERR_DS_NONEXISTENT_POSS_SUP, "Schema update failed: Class in the Poss-Superiors list does not exist." },
	{ WERR_DS_SUB_CLS_TEST_FAIL, "Schema update failed: Class in the subclass of the list does not exist or does not satisfy hierarchy rules." },
	{ WERR_DS_BAD_RDN_ATT_ID_SYNTAX, "Schema update failed: Rdn-Att-Id has wrong syntax." },
	{ WERR_DS_EXISTS_IN_AUX_CLS, "Schema deletion failed: Class is used as an auxiliary class." },
	{ WERR_DS_EXISTS_IN_SUB_CLS, "Schema deletion failed: Class is used as a subclass." },
	{ WERR_DS_EXISTS_IN_POSS_SUP, "Schema deletion failed: Class is used as a Poss-Superior." },
	{ WERR_DS_RECALCSCHEMA_FAILED, "Schema update failed in recalculating validation cache." },
	{ WERR_DS_TREE_DELETE_NOT_FINISHED, "The tree deletion is not finished. The request must be made again to continue deleting the tree." },
	{ WERR_DS_CANT_DELETE, "The requested delete operation could not be performed." },
	{ WERR_DS_ATT_SCHEMA_REQ_ID, "Cannot read the governs class identifier for the schema record." },
	{ WERR_DS_BAD_ATT_SCHEMA_SYNTAX, "The attribute schema has bad syntax." },
	{ WERR_DS_CANT_CACHE_ATT, "The attribute could not be cached." },
	{ WERR_DS_CANT_CACHE_CLASS, "The class could not be cached." },
	{ WERR_DS_CANT_REMOVE_ATT_CACHE, "The attribute could not be removed from the cache." },
	{ WERR_DS_CANT_REMOVE_CLASS_CACHE, "The class could not be removed from the cache." },
	{ WERR_DS_CANT_RETRIEVE_DN, "The distinguished name attribute could not be read." },
	{ WERR_DS_MISSING_SUPREF, "No superior reference has been configured for the directory service. The directory service is, therefore, unable to issue referrals to objects outside this forest." },
	{ WERR_DS_CANT_RETRIEVE_INSTANCE, "The instance type attribute could not be retrieved." },
	{ WERR_DS_CODE_INCONSISTENCY, "An internal error has occurred." },
	{ WERR_DS_DATABASE_ERROR, "A database error has occurred." },
	{ WERR_DS_MISSING_EXPECTED_ATT, "An expected attribute is missing." },
	{ WERR_DS_NCNAME_MISSING_CR_REF, "The specified naming context is missing a cross-reference." },
	{ WERR_DS_SECURITY_CHECKING_ERROR, "A security checking error has occurred." },
	{ WERR_DS_SCHEMA_NOT_LOADED, "The schema is not loaded." },
	{ WERR_DS_SCHEMA_ALLOC_FAILED, "Schema allocation failed. Check if the machine is running low on memory." },
	{ WERR_DS_ATT_SCHEMA_REQ_SYNTAX, "Failed to obtain the required syntax for the attribute schema." },
	{ WERR_DS_GCVERIFY_ERROR, "The GC verification failed. The GC is not available or does not support the operation. Some part of the directory is currently not available." },
	{ WERR_DS_DRA_SCHEMA_MISMATCH, "The replication operation failed because of a schema mismatch between the servers involved." },
	{ WERR_DS_CANT_FIND_DSA_OBJ, "The DSA object could not be found." },
	{ WERR_DS_CANT_FIND_EXPECTED_NC, "The naming context could not be found." },
	{ WERR_DS_CANT_FIND_NC_IN_CACHE, "The naming context could not be found in the cache." },
	{ WERR_DS_CANT_RETRIEVE_CHILD, "The child object could not be retrieved." },
	{ WERR_DS_SECURITY_ILLEGAL_MODIFY, "The modification was not permitted for security reasons." },
	{ WERR_DS_CANT_REPLACE_HIDDEN_REC, "The operation cannot replace the hidden record." },
	{ WERR_DS_BAD_HIERARCHY_FILE, "The hierarchy file is invalid." },
	{ WERR_DS_BUILD_HIERARCHY_TABLE_FAILED, "The attempt to build the hierarchy table failed." },
	{ WERR_DS_CONFIG_PARAM_MISSING, "The directory configuration parameter is missing from the registry." },
	{ WERR_DS_COUNTING_AB_INDICES_FAILED, "The attempt to count the address book indices failed." },
	{ WERR_DS_HIERARCHY_TABLE_MALLOC_FAILED, "The allocation of the hierarchy table failed." },
	{ WERR_DS_INTERNAL_FAILURE, "The directory service encountered an internal failure." },
	{ WERR_DS_UNKNOWN_ERROR, "The directory service encountered an unknown failure." },
	{ WERR_DS_ROOT_REQUIRES_CLASS_TOP, "A root object requires a class of \"top\"." },
	{ WERR_DS_REFUSING_FSMO_ROLES, "This directory server is shutting down, and cannot take ownership of new floating single-master operation roles." },
	{ WERR_DS_MISSING_FSMO_SETTINGS, "The directory service is missing mandatory configuration information and is unable to determine the ownership of floating single-master operation roles." },
	{ WERR_DS_UNABLE_TO_SURRENDER_ROLES, "The directory service was unable to transfer ownership of one or more floating single-master operation roles to other servers." },
	{ WERR_DS_DRA_GENERIC, "The replication operation failed." },
	{ WERR_DS_DRA_INVALID_PARAMETER, "An invalid parameter was specified for this replication operation." },
	{ WERR_DS_DRA_BUSY, "The directory service is too busy to complete the replication operation at this time." },
	{ WERR_DS_DRA_BAD_DN, "The DN specified for this replication operation is invalid." },
	{ WERR_DS_DRA_BAD_NC, "The naming context specified for this replication operation is invalid." },
	{ WERR_DS_DRA_DN_EXISTS, "The DN specified for this replication operation already exists." },
	{ WERR_DS_DRA_INTERNAL_ERROR, "The replication system encountered an internal error." },
	{ WERR_DS_DRA_INCONSISTENT_DIT, "The replication operation encountered a database inconsistency." },
	{ WERR_DS_DRA_CONNECTION_FAILED, "The server specified for this replication operation could not be contacted." },
	{ WERR_DS_DRA_BAD_INSTANCE_TYPE, "The replication operation encountered an object with an invalid instance type." },
	{ WERR_DS_DRA_OUT_OF_MEM, "The replication operation failed to allocate memory." },
	{ WERR_DS_DRA_MAIL_PROBLEM, "The replication operation encountered an error with the mail system." },
	{ WERR_DS_DRA_REF_ALREADY_EXISTS, "The replication reference information for the target server already exists." },
	{ WERR_DS_DRA_REF_NOT_FOUND, "The replication reference information for the target server does not exist." },
	{ WERR_DS_DRA_OBJ_IS_REP_SOURCE, "The naming context cannot be removed because it is replicated to another server." },
	{ WERR_DS_DRA_DB_ERROR, "The replication operation encountered a database error." },
	{ WERR_DS_DRA_NO_REPLICA, "The naming context is in the process of being removed or is not replicated from the specified server." },
	{ WERR_DS_DRA_ACCESS_DENIED, "Replication access was denied." },
	{ WERR_DS_DRA_NOT_SUPPORTED, "The requested operation is not supported by this version of the directory service." },
	{ WERR_DS_DRA_RPC_CANCELLED, "The replication RPC was canceled." },
	{ WERR_DS_DRA_SOURCE_DISABLED, "The source server is currently rejecting replication requests." },
	{ WERR_DS_DRA_SINK_DISABLED, "The destination server is currently rejecting replication requests." },
	{ WERR_DS_DRA_NAME_COLLISION, "The replication operation failed due to a collision of object names." },
	{ WERR_DS_DRA_SOURCE_REINSTALLED, "The replication source has been reinstalled." },
	{ WERR_DS_DRA_MISSING_PARENT, "The replication operation failed because a required parent object is missing." },
	{ WERR_DS_DRA_PREEMPTED, "The replication operation was preempted." },
	{ WERR_DS_DRA_ABANDON_SYNC, "The replication synchronization attempt was abandoned because of a lack of updates." },
	{ WERR_DS_DRA_SHUTDOWN, "The replication operation was terminated because the system is shutting down." },
	{ WERR_DS_DRA_INCOMPATIBLE_PARTIAL_SET, "A synchronization attempt failed because the destination DC is currently waiting to synchronize new partial attributes from the source. This condition is normal if a recent schema change modified the partial attribute set. The destination partial attribute set is not a subset of the source partial attribute set." },
	{ WERR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA, "The replication synchronization attempt failed because a master replica attempted to sync from a partial replica." },
	{ WERR_DS_DRA_EXTN_CONNECTION_FAILED, "The server specified for this replication operation was contacted, but that server was unable to contact an additional server needed to complete the operation." },
	{ WERR_DS_INSTALL_SCHEMA_MISMATCH, "The version of the directory service schema of the source forest is not compatible with the version of the directory service on this computer." },
	{ WERR_DS_DUP_LINK_ID, "Schema update failed: An attribute with the same link identifier already exists." },
	{ WERR_DS_NAME_ERROR_RESOLVING, "Name translation: Generic processing error." },
	{ WERR_DS_NAME_ERROR_NOT_FOUND, "Name translation: Could not find the name or insufficient right to see name." },
	{ WERR_DS_NAME_ERROR_NOT_UNIQUE, "Name translation: Input name mapped to more than one output name." },
	{ WERR_DS_NAME_ERROR_NO_MAPPING, "Name translation: The input name was found but not the associated output format." },
	{ WERR_DS_NAME_ERROR_DOMAIN_ONLY, "Name translation: Unable to resolve completely, only the domain was found." },
	{ WERR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING, "Name translation: Unable to perform purely syntactical mapping at the client without going out to the wire." },
	{ WERR_DS_CONSTRUCTED_ATT_MOD, "Modification of a constructed attribute is not allowed." },
	{ WERR_DS_WRONG_OM_OBJ_CLASS, "The OM-Object-Class specified is incorrect for an attribute with the specified syntax." },
	{ WERR_DS_DRA_REPL_PENDING, "The replication request has been posted; waiting for a reply." },
	{ WERR_DS_DS_REQUIRED, "The requested operation requires a directory service, and none was available." },
	{ WERR_DS_INVALID_LDAP_DISPLAY_NAME, "The LDAP display name of the class or attribute contains non-ASCII characters." },
	{ WERR_DS_NON_BASE_SEARCH, "The requested search operation is only supported for base searches." },
	{ WERR_DS_CANT_RETRIEVE_ATTS, "The search failed to retrieve attributes from the database." },
	{ WERR_DS_BACKLINK_WITHOUT_LINK, "The schema update operation tried to add a backward link attribute that has no corresponding forward link." },
	{ WERR_DS_EPOCH_MISMATCH, "The source and destination of a cross-domain move do not agree on the object\'s epoch number. Either the source or the destination does not have the latest version of the object." },
	{ WERR_DS_SRC_NAME_MISMATCH, "The source and destination of a cross-domain move do not agree on the object\'s current name. Either the source or the destination does not have the latest version of the object." },
	{ WERR_DS_SRC_AND_DST_NC_IDENTICAL, "The source and destination for the cross-domain move operation are identical. The caller should use a local move operation instead of a cross-domain move operation." },
	{ WERR_DS_DST_NC_MISMATCH, "The source and destination for a cross-domain move do not agree on the naming contexts in the forest. Either the source or the destination does not have the latest version of the Partitions container." },
	{ WERR_DS_NOT_AUTHORITIVE_FOR_DST_NC, "The destination of a cross-domain move is not authoritative for the destination naming context." },
	{ WERR_DS_SRC_GUID_MISMATCH, "The source and destination of a cross-domain move do not agree on the identity of the source object. Either the source or the destination does not have the latest version of the source object." },
	{ WERR_DS_CANT_MOVE_DELETED_OBJECT, "The object being moved across domains is already known to be deleted by the destination server. The source server does not have the latest version of the source object." },
	{ WERR_DS_PDC_OPERATION_IN_PROGRESS, "Another operation that requires exclusive access to the PDC FSMO is already in progress." },
	{ WERR_DS_CROSS_DOMAIN_CLEANUP_REQD, "A cross-domain move operation failed because two versions of the moved object exist—one each in the source and destination domains. The destination object needs to be removed to restore the system to a consistent state." },
	{ WERR_DS_ILLEGAL_XDOM_MOVE_OPERATION, "This object may not be moved across domain boundaries either because cross-domain moves for this class are not allowed, or the object has some special characteristics, for example, a trust account or a restricted relative identifier (RID), that prevent its move." },
	{ WERR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS, "Cannot move objects with memberships across domain boundaries because, once moved, this violates the membership conditions of the account group. Remove the object from any account group memberships and retry." },
	{ WERR_DS_NC_MUST_HAVE_NC_PARENT, "A naming context head must be the immediate child of another naming context head, not of an interior node." },
	{ WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE, "The directory cannot validate the proposed naming context name because it does not hold a replica of the naming context above the proposed naming context. Ensure that the domain naming master role is held by a server that is configured as a GC server, and that the server is up-to-date with its replication partners. (Applies only to Windows 2000 domain naming masters.)" },
	{ WERR_DS_DST_DOMAIN_NOT_NATIVE, "Destination domain must be in native mode." },
	{ WERR_DS_MISSING_INFRASTRUCTURE_CONTAINER, "The operation cannot be performed because the server does not have an infrastructure container in the domain of interest." },
	{ WERR_DS_CANT_MOVE_ACCOUNT_GROUP, "Cross-domain moves of nonempty account groups is not allowed." },
	{ WERR_DS_CANT_MOVE_RESOURCE_GROUP, "Cross-domain moves of nonempty resource groups is not allowed." },
	{ WERR_DS_INVALID_SEARCH_FLAG, "The search flags for the attribute are invalid. The ambiguous name resolution (ANR) bit is valid only on attributes of Unicode or Teletex strings." },
	{ WERR_DS_NO_TREE_DELETE_ABOVE_NC, "Tree deletions starting at an object that has an NC head as a descendant are not allowed." },
	{ WERR_DS_COULDNT_LOCK_TREE_FOR_DELETE, "The directory service failed to lock a tree in preparation for a tree deletion because the tree was in use." },
	{ WERR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE, "The directory service failed to identify the list of objects to delete while attempting a tree deletion." },
	{ WERR_DS_SAM_INIT_FAILURE, "SAM initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system and reboot into Directory Services Restore Mode. Check the event log for detailed information." },
	{ WERR_DS_SENSITIVE_GROUP_VIOLATION, "Only an administrator can modify the membership list of an administrative group." },
	{ WERR_DS_CANT_MOD_PRIMARYGROUPID, "Cannot change the primary group ID of a domain controller account." },
	{ WERR_DS_ILLEGAL_BASE_SCHEMA_MOD, "An attempt was made to modify the base schema." },
	{ WERR_DS_NONSAFE_SCHEMA_CHANGE, "Adding a new mandatory attribute to an existing class, deleting a mandatory attribute from an existing class, or adding an optional attribute to the special class Top that is not a backlink attribute (directly or through inheritance, for example, by adding or deleting an auxiliary class) is not allowed." },
	{ WERR_DS_SCHEMA_UPDATE_DISALLOWED, "Schema update is not allowed on this DC because the DC is not the schema FSMO role owner." },
	{ WERR_DS_CANT_CREATE_UNDER_SCHEMA, "An object of this class cannot be created under the schema container. You can only create Attribute-Schema and Class-Schema objects under the schema container." },
	{ WERR_DS_INVALID_GROUP_TYPE, "The specified group type is invalid." },
	{ WERR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN, "You cannot nest global groups in a mixed domain if the group is security-enabled." },
	{ WERR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN, "You cannot nest local groups in a mixed domain if the group is security-enabled." },
	{ WERR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER, "A global group cannot have a local group as a member." },
	{ WERR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER, "A global group cannot have a universal group as a member." },
	{ WERR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER, "A universal group cannot have a local group as a member." },
	{ WERR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER, "A global group cannot have a cross-domain member." },
	{ WERR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER, "A local group cannot have another cross domain local group as a member." },
	{ WERR_DS_HAVE_PRIMARY_MEMBERS, "A group with primary members cannot change to a security-disabled group." },
	{ WERR_DS_STRING_SD_CONVERSION_FAILED, "The schema cache load failed to convert the string default security descriptor (SD) on a class-schema object." },
	{ WERR_DS_NAMING_MASTER_GC, "Only DSAs configured to be GC servers should be allowed to hold the domain naming master FSMO role. (Applies only to Windows 2000 servers.)" },
	{ WERR_DS_DNS_LOOKUP_FAILURE, "The DSA operation is unable to proceed because of a DNS lookup failure." },
	{ WERR_DS_COULDNT_UPDATE_SPNS, "While processing a change to the DNS host name for an object, the SPN values could not be kept in sync." },
	{ WERR_DS_CANT_RETRIEVE_SD, "The Security Descriptor attribute could not be read." },
	{ WERR_DS_KEY_NOT_UNIQUE, "The object requested was not found, but an object with that key was found." },
	{ WERR_DS_WRONG_LINKED_ATT_SYNTAX, "The syntax of the linked attribute being added is incorrect. Forward links can only have syntax 2.5.5.1, 2.5.5.7, and 2.5.5.14, and backlinks can only have syntax 2.5.5.1." },
	{ WERR_DS_SAM_NEED_BOOTKEY_PASSWORD, "SAM needs to get the boot password." },
	{ WERR_DS_SAM_NEED_BOOTKEY_FLOPPY, "SAM needs to get the boot key from the floppy disk." },
	{ WERR_DS_CANT_START, "Directory Service cannot start." },
	{ WERR_DS_INIT_FAILURE, "Directory Services could not start." },
	{ WERR_DS_NO_PKT_PRIVACY_ON_CONNECTION, "The connection between client and server requires packet privacy or better." },
	{ WERR_DS_SOURCE_DOMAIN_IN_FOREST, "The source domain may not be in the same forest as the destination." },
	{ WERR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST, "The destination domain must be in the forest." },
	{ WERR_DS_DESTINATION_AUDITING_NOT_ENABLED, "The operation requires that destination domain auditing be enabled." },
	{ WERR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN, "The operation could not locate a DC for the source domain." },
	{ WERR_DS_SRC_OBJ_NOT_GROUP_OR_USER, "The source object must be a group or user." },
	{ WERR_DS_SRC_SID_EXISTS_IN_FOREST, "The source object\'s SID already exists in the destination forest." },
	{ WERR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH, "The source and destination object must be of the same type." },
	{ WERR_SAM_INIT_FAILURE, "SAM initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system and reboot into Safe Mode. Check the event log for detailed information." },
	{ WERR_DS_DRA_SCHEMA_INFO_SHIP, "Schema information could not be included in the replication request." },
	{ WERR_DS_DRA_SCHEMA_CONFLICT, "The replication operation could not be completed due to a schema incompatibility." },
	{ WERR_DS_DRA_EARLIER_SCHEMA_CONFLICT, "The replication operation could not be completed due to a previous schema incompatibility." },
	{ WERR_DS_DRA_OBJ_NC_MISMATCH, "The replication update could not be applied because either the source or the destination has not yet received information regarding a recent cross-domain move operation." },
	{ WERR_DS_NC_STILL_HAS_DSAS, "The requested domain could not be deleted because there exist domain controllers that still host this domain." },
	{ WERR_DS_GC_REQUIRED, "The requested operation can be performed only on a GC server." },
	{ WERR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY, "A local group can only be a member of other local groups in the same domain." },
	{ WERR_DS_NO_FPO_IN_UNIVERSAL_GROUPS, "Foreign security principals cannot be members of universal groups." },
	{ WERR_DS_CANT_ADD_TO_GC, "The attribute is not allowed to be replicated to the GC because of security reasons." },
	{ WERR_DS_NO_CHECKPOINT_WITH_PDC, "The checkpoint with the PDC could not be taken because too many modifications are currently being processed." },
	{ WERR_DS_SOURCE_AUDITING_NOT_ENABLED, "The operation requires that source domain auditing be enabled." },
	{ WERR_DS_CANT_CREATE_IN_NONDOMAIN_NC, "Security principal objects can only be created inside domain naming contexts." },
	{ WERR_DS_INVALID_NAME_FOR_SPN, "An SPN could not be constructed because the provided host name is not in the necessary format." },
	{ WERR_DS_FILTER_USES_CONTRUCTED_ATTRS, "A filter was passed that uses constructed attributes." },
	{ WERR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED, "Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased." },
	{ WERR_DS_MUST_BE_RUN_ON_DST_DC, "For security reasons, the operation must be run on the destination DC." },
	{ WERR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER, "For security reasons, the source DC must be Windows NT 4.0 SP4 and later." },
	{ WERR_DS_CANT_TREE_DELETE_CRITICAL_OBJ, "Critical directory service system objects cannot be deleted during tree deletion operations. The tree deletion may have been partially performed." },
	{ WERR_DS_INIT_FAILURE_CONSOLE, "Directory Services could not start because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system. You can use the Recovery Console to further diagnose the system." },
	{ WERR_DS_SAM_INIT_FAILURE_CONSOLE, "SAM initialization failed because of the following error: %1. Error Status: 0x%2. Click OK to shut down the system. You can use the Recovery Console to further diagnose the system." },
	{ WERR_DS_FOREST_VERSION_TOO_HIGH, "The version of the operating system installed is incompatible with the current forest functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this forest." },
	{ WERR_DS_DOMAIN_VERSION_TOO_HIGH, "The version of the operating system installed is incompatible with the current domain functional level. You must upgrade to a new version of the operating system before this server can become a domain controller in this domain." },
	{ WERR_DS_FOREST_VERSION_TOO_LOW, "The version of the operating system installed on this server no longer supports the current forest functional level. You must raise the forest functional level before this server can become a domain controller in this forest." },
	{ WERR_DS_DOMAIN_VERSION_TOO_LOW, "The version of the operating system installed on this server no longer supports the current domain functional level. You must raise the domain functional level before this server can become a domain controller in this domain." },
	{ WERR_DS_INCOMPATIBLE_VERSION, "The version of the operating system installed on this server is incompatible with the functional level of the domain or forest." },
	{ WERR_DS_LOW_DSA_VERSION, "The functional level of the domain (or forest) cannot be raised to the requested value because one or more domain controllers in the domain (or forest) are at a lower, incompatible functional level." },
	{ WERR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN, "The forest functional level cannot be raised to the requested value because one or more domains are still in mixed-domain mode. All domains in the forest must be in native mode for you to raise the forest functional level." },
	{ WERR_DS_NOT_SUPPORTED_SORT_ORDER, "The sort order requested is not supported." },
	{ WERR_DS_NAME_NOT_UNIQUE, "The requested name already exists as a unique identifier." },
	{ WERR_DS_MACHINE_ACCOUNT_CREATED_PRENT4, "The machine account was created before Windows NT 4.0. The account needs to be re-created." },
	{ WERR_DS_OUT_OF_VERSION_STORE, "The database is out of version store." },
	{ WERR_DS_INCOMPATIBLE_CONTROLS_USED, "Unable to continue operation because multiple conflicting controls were used." },
	{ WERR_DS_NO_REF_DOMAIN, "Unable to find a valid security descriptor reference domain for this partition." },
	{ WERR_DS_RESERVED_LINK_ID, "Schema update failed: The link identifier is reserved." },
	{ WERR_DS_LINK_ID_NOT_AVAILABLE, "Schema update failed: There are no link identifiers available." },
	{ WERR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER, "An account group cannot have a universal group as a member." },
	{ WERR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE, "Rename or move operations on naming context heads or read-only objects are not allowed." },
	{ WERR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC, "Move operations on objects in the schema naming context are not allowed." },
	{ WERR_DS_MODIFYDN_DISALLOWED_BY_FLAG, "A system flag has been set on the object that does not allow the object to be moved or renamed." },
	{ WERR_DS_MODIFYDN_WRONG_GRANDPARENT, "This object is not allowed to change its grandparent container. Moves are not forbidden on this object, but are restricted to sibling containers." },
	{ WERR_DS_NAME_ERROR_TRUST_REFERRAL, "Unable to resolve completely; a referral to another forest was generated." },
	{ WERR_NOT_SUPPORTED_ON_STANDARD_SERVER, "The requested action is not supported on a standard server." },
	{ WERR_DS_CANT_ACCESS_REMOTE_PART_OF_AD, "Could not access a partition of the directory service located on a remote server. Make sure at least one server is running for the partition in question." },
	{ WERR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2, "The directory cannot validate the proposed naming context (or partition) name because it does not hold a replica, nor can it contact a replica of the naming context above the proposed naming context. Ensure that the parent naming context is properly registered in the DNS, and at least one replica of this naming context is reachable by the domain naming master." },
	{ WERR_DS_THREAD_LIMIT_EXCEEDED, "The thread limit for this request was exceeded." },
	{ WERR_DS_NOT_CLOSEST, "The GC server is not in the closest site." },
	{ WERR_DS_SINGLE_USER_MODE_FAILED, "The directory service failed to enter single-user mode." },
	{ WERR_DS_NTDSCRIPT_SYNTAX_ERROR, "The directory service cannot parse the script because of a syntax error." },
	{ WERR_DS_NTDSCRIPT_PROCESS_ERROR, "The directory service cannot process the script because of an error." },
	{ WERR_DS_DIFFERENT_REPL_EPOCHS, "The directory service cannot perform the requested operation because the servers involved are of different replication epochs (which is usually related to a domain rename that is in progress)." },
	{ WERR_DS_DRS_EXTENSIONS_CHANGED, "The directory service binding must be renegotiated due to a change in the server extensions information." },
	{ WERR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR, "The operation is not allowed on a disabled cross-reference." },
	{ WERR_DS_NO_MSDS_INTID, "Schema update failed: No values for msDS-IntId are available." },
	{ WERR_DS_DUP_MSDS_INTID, "Schema update failed: Duplicate msDS-IntId. Retry the operation." },
	{ WERR_DS_EXISTS_IN_RDNATTID, "Schema deletion failed: Attribute is used in rDNAttID." },
	{ WERR_DS_AUTHORIZATION_FAILED, "The directory service failed to authorize the request." },
	{ WERR_DS_INVALID_SCRIPT, "The directory service cannot process the script because it is invalid." },
	{ WERR_DS_REMOTE_CROSSREF_OP_FAILED, "The remote create cross-reference operation failed on the domain naming master FSMO. The operation\'s error is in the extended data." },
	{ WERR_DS_CROSS_REF_BUSY, "A cross-reference is in use locally with the same name." },
	{ WERR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN, "The directory service cannot derive an SPN with which to mutually authenticate the target server because the server\'s domain has been deleted from the forest." },
	{ WERR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC, "Writable NCs prevent this DC from demoting." },
	{ WERR_DS_DUPLICATE_ID_FOUND, "The requested object has a nonunique identifier and cannot be retrieved." },
	{ WERR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT, "Insufficient attributes were given to create an object. This object may not exist because it may have been deleted and the garbage already collected." },
	{ WERR_DS_GROUP_CONVERSION_ERROR, "The group cannot be converted due to attribute restrictions on the requested group type." },
	{ WERR_DS_CANT_MOVE_APP_BASIC_GROUP, "Cross-domain moves of nonempty basic application groups is not allowed." },
	{ WERR_DS_CANT_MOVE_APP_QUERY_GROUP, "Cross-domain moves of nonempty query-based application groups is not allowed." },
	{ WERR_DS_ROLE_NOT_VERIFIED, "The FSMO role ownership could not be verified because its directory partition did not replicate successfully with at least one replication partner." },
	{ WERR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL, "The target container for a redirection of a well-known object container cannot already be a special container." },
	{ WERR_DS_DOMAIN_RENAME_IN_PROGRESS, "The directory service cannot perform the requested operation because a domain rename operation is in progress." },
	{ WERR_DS_EXISTING_AD_CHILD_NC, "The directory service detected a child partition below the requested partition name. The partition hierarchy must be created in a top down method." },
	{ WERR_DS_REPL_LIFETIME_EXCEEDED, "The directory service cannot replicate with this server because the time since the last replication with this server has exceeded the tombstone lifetime." },
	{ WERR_DS_DISALLOWED_IN_SYSTEM_CONTAINER, "The requested operation is not allowed on an object under the system container." },
	{ WERR_DS_LDAP_SEND_QUEUE_FULL, "The LDAP server\'s network send queue has filled up because the client is not processing the results of its requests fast enough. No more requests will be processed until the client catches up. If the client does not catch up then it will be disconnected." },
	{ WERR_DS_DRA_OUT_SCHEDULE_WINDOW, "The scheduled replication did not take place because the system was too busy to execute the request within the schedule window. The replication queue is overloaded. Consider reducing the number of partners or decreasing the scheduled replication frequency." },
	{ WERR_DS_POLICY_NOT_KNOWN, "At this time, it cannot be determined if the branch replication policy is available on the hub domain controller. Retry at a later time to account for replication latencies." },
	{ WERR_NO_SITE_SETTINGS_OBJECT, "The site settings object for the specified site does not exist." },
	{ WERR_NO_SECRETS, "The local account store does not contain secret material for the specified account." },
	{ WERR_NO_WRITABLE_DC_FOUND, "Could not find a writable domain controller in the domain." },
	{ WERR_DS_NO_SERVER_OBJECT, "The server object for the domain controller does not exist." },
	{ WERR_DS_NO_NTDSA_OBJECT, "The NTDS Settings object for the domain controller does not exist." },
	{ WERR_DS_NON_ASQ_SEARCH, "The requested search operation is not supported for attribute scoped query (ASQ) searches." },
	{ WERR_DS_AUDIT_FAILURE, "A required audit event could not be generated for the operation." },
	{ WERR_DS_INVALID_SEARCH_FLAG_SUBTREE, "The search flags for the attribute are invalid. The subtree index bit is valid only on single-valued attributes." },
	{ WERR_DS_INVALID_SEARCH_FLAG_TUPLE, "The search flags for the attribute are invalid. The tuple index bit is valid only on attributes of Unicode strings." },
	{ WERR_IPSEC_QM_POLICY_EXISTS, "The specified quick mode policy already exists." },
	{ WERR_IPSEC_QM_POLICY_NOT_FOUND, "The specified quick mode policy was not found." },
	{ WERR_IPSEC_QM_POLICY_IN_USE, "The specified quick mode policy is being used." },
	{ WERR_IPSEC_MM_POLICY_EXISTS, "The specified main mode policy already exists." },
	{ WERR_IPSEC_MM_POLICY_NOT_FOUND, "The specified main mode policy was not found." },
	{ WERR_IPSEC_MM_POLICY_IN_USE, "The specified main mode policy is being used." },
	{ WERR_IPSEC_MM_FILTER_EXISTS, "The specified main mode filter already exists." },
	{ WERR_IPSEC_MM_FILTER_NOT_FOUND, "The specified main mode filter was not found." },
	{ WERR_IPSEC_TRANSPORT_FILTER_EXISTS, "The specified transport mode filter already exists." },
	{ WERR_IPSEC_TRANSPORT_FILTER_NOT_FOUND, "The specified transport mode filter does not exist." },
	{ WERR_IPSEC_MM_AUTH_EXISTS, "The specified main mode authentication list exists." },
	{ WERR_IPSEC_MM_AUTH_NOT_FOUND, "The specified main mode authentication list was not found." },
	{ WERR_IPSEC_MM_AUTH_IN_USE, "The specified main mode authentication list is being used." },
	{ WERR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND, "The specified default main mode policy was not found." },
	{ WERR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND, "The specified default main mode authentication list was not found." },
	{ WERR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND, "The specified default quick mode policy was not found." },
	{ WERR_IPSEC_TUNNEL_FILTER_EXISTS, "The specified tunnel mode filter exists." },
	{ WERR_IPSEC_TUNNEL_FILTER_NOT_FOUND, "The specified tunnel mode filter was not found." },
	{ WERR_IPSEC_MM_FILTER_PENDING_DELETION, "The main mode filter is pending deletion." },
	{ WERR_IPSEC_TRANSPORT_FILTER_ENDING_DELETION, "The transport filter is pending deletion." },
	{ WERR_IPSEC_TUNNEL_FILTER_PENDING_DELETION, "The tunnel filter is pending deletion." },
	{ WERR_IPSEC_MM_POLICY_PENDING_ELETION, "The main mode policy is pending deletion." },
	{ WERR_IPSEC_MM_AUTH_PENDING_DELETION, "The main mode authentication bundle is pending deletion." },
	{ WERR_IPSEC_QM_POLICY_PENDING_DELETION, "The quick mode policy is pending deletion." },
	{ WERR_IPSEC_IKE_NEG_STATUS_BEGIN, "ERROR_IPSEC_IKE_NEG_STATUS_BEGIN" },
	{ WERR_IPSEC_IKE_AUTH_FAIL, "The IKE authentication credentials are unacceptable." },
	{ WERR_IPSEC_IKE_ATTRIB_FAIL, "The IKE security attributes are unacceptable." },
	{ WERR_IPSEC_IKE_NEGOTIATION_PENDING, "The IKE negotiation is in progress." },
	{ WERR_IPSEC_IKE_GENERAL_PROCESSING_ERROR, "General processing error." },
	{ WERR_IPSEC_IKE_TIMED_OUT, "Negotiation timed out." },
	{ WERR_IPSEC_IKE_NO_CERT, "The IKE failed to find a valid machine certificate. Contact your network security administrator about installing a valid certificate in the appropriate certificate store." },
	{ WERR_IPSEC_IKE_SA_DELETED, "The IKE security association (SA) was deleted by a peer before it was completely established." },
	{ WERR_IPSEC_IKE_SA_REAPED, "The IKE SA was deleted before it was completely established." },
	{ WERR_IPSEC_IKE_MM_ACQUIRE_DROP, "The negotiation request sat in the queue too long." },
	{ WERR_IPSEC_IKE_QM_ACQUIRE_DROP, "The negotiation request sat in the queue too long." },
	{ WERR_IPSEC_IKE_QUEUE_DROP_MM, "The negotiation request sat in the queue too long." },
	{ WERR_IPSEC_IKE_QUEUE_DROP_NO_MM, "The negotiation request sat in the queue too long." },
	{ WERR_IPSEC_IKE_DROP_NO_RESPONSE, "There was no response from a peer." },
	{ WERR_IPSEC_IKE_MM_DELAY_DROP, "The negotiation took too long." },
	{ WERR_IPSEC_IKE_QM_DELAY_DROP, "The negotiation took too long." },
	{ WERR_IPSEC_IKE_ERROR, "An unknown error occurred." },
	{ WERR_IPSEC_IKE_CRL_FAILED, "The certificate revocation check failed." },
	{ WERR_IPSEC_IKE_INVALID_KEY_USAGE, "Invalid certificate key usage." },
	{ WERR_IPSEC_IKE_INVALID_CERT_TYPE, "Invalid certificate type." },
	{ WERR_IPSEC_IKE_NO_PRIVATE_KEY, "The IKE negotiation failed because the machine certificate used does not have a private key. IPsec certificates require a private key. Contact your network security administrator about a certificate that has a private key." },
	{ WERR_IPSEC_IKE_DH_FAIL, "There was a failure in the Diffie-Hellman computation." },
	{ WERR_IPSEC_IKE_INVALID_HEADER, "Invalid header." },
	{ WERR_IPSEC_IKE_NO_POLICY, "No policy configured." },
	{ WERR_IPSEC_IKE_INVALID_SIGNATURE, "Failed to verify signature." },
	{ WERR_IPSEC_IKE_KERBEROS_ERROR, "Failed to authenticate using Kerberos." },
	{ WERR_IPSEC_IKE_NO_PUBLIC_KEY, "The peer\'s certificate did not have a public key." },
	{ WERR_IPSEC_IKE_PROCESS_ERR, "Error processing the error payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_SA, "Error processing the SA payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_PROP, "Error processing the proposal payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_TRANS, "Error processing the transform payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_KE, "Error processing the key exchange payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_ID, "Error processing the ID payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_CERT, "Error processing the certification payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_CERT_REQ, "Error processing the certificate request payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_HASH, "Error processing the hash payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_SIG, "Error processing the signature payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_NONCE, "Error processing the nonce payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_NOTIFY, "Error processing the notify payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_DELETE, "Error processing the delete payload." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_VENDOR, "Error processing the VendorId payload." },
	{ WERR_IPSEC_IKE_INVALID_PAYLOAD, "Invalid payload received." },
	{ WERR_IPSEC_IKE_LOAD_SOFT_SA, "Soft SA loaded." },
	{ WERR_IPSEC_IKE_SOFT_SA_TORN_DOWN, "Soft SA torn down." },
	{ WERR_IPSEC_IKE_INVALID_COOKIE, "Invalid cookie received." },
	{ WERR_IPSEC_IKE_NO_PEER_CERT, "Peer failed to send valid machine certificate." },
	{ WERR_IPSEC_IKE_PEER_CRL_FAILED, "Certification revocation check of peer\'s certificate failed." },
	{ WERR_IPSEC_IKE_POLICY_CHANGE, "New policy invalidated SAs formed with the old policy." },
	{ WERR_IPSEC_IKE_NO_MM_POLICY, "There is no available main mode IKE policy." },
	{ WERR_IPSEC_IKE_NOTCBPRIV, "Failed to enabled trusted computer base (TCB) privilege." },
	{ WERR_IPSEC_IKE_SECLOADFAIL, "Failed to load SECURITY.DLL." },
	{ WERR_IPSEC_IKE_FAILSSPINIT, "Failed to obtain the security function table dispatch address from the SSPI." },
	{ WERR_IPSEC_IKE_FAILQUERYSSP, "Failed to query the Kerberos package to obtain the max token size." },
	{ WERR_IPSEC_IKE_SRVACQFAIL, "Failed to obtain the Kerberos server credentials for the Internet Security Association and Key Management Protocol (ISAKMP)/ERROR_IPSEC_IKE service. Kerberos authentication will not function. The most likely reason for this is lack of domain membership. This is normal if your computer is a member of a workgroup." },
	{ WERR_IPSEC_IKE_SRVQUERYCRED, "Failed to determine the SSPI principal name for ISAKMP/ERROR_IPSEC_IKE service (QueryCredentialsAttributes)." },
	{ WERR_IPSEC_IKE_GETSPIFAIL, "Failed to obtain a new service provider interface (SPI) for the inbound SA from the IPsec driver. The most common cause for this is that the driver does not have the correct filter. Check your policy to verify the filters." },
	{ WERR_IPSEC_IKE_INVALID_FILTER, "Given filter is invalid" },
	{ WERR_IPSEC_IKE_OUT_OF_MEMORY, "Memory allocation failed." },
	{ WERR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED, "Failed to add an SA to the IPSec driver. The most common cause for this is if the IKE negotiation took too long to complete. If the problem persists, reduce the load on the faulting machine." },
	{ WERR_IPSEC_IKE_INVALID_POLICY, "Invalid policy." },
	{ WERR_IPSEC_IKE_UNKNOWN_DOI, "Invalid digital object identifier (DOI)." },
	{ WERR_IPSEC_IKE_INVALID_SITUATION, "Invalid situation." },
	{ WERR_IPSEC_IKE_DH_FAILURE, "Diffie-Hellman failure." },
	{ WERR_IPSEC_IKE_INVALID_GROUP, "Invalid Diffie-Hellman group." },
	{ WERR_IPSEC_IKE_ENCRYPT, "Error encrypting payload." },
	{ WERR_IPSEC_IKE_DECRYPT, "Error decrypting payload." },
	{ WERR_IPSEC_IKE_POLICY_MATCH, "Policy match error." },
	{ WERR_IPSEC_IKE_UNSUPPORTED_ID, "Unsupported ID." },
	{ WERR_IPSEC_IKE_INVALID_HASH, "Hash verification failed." },
	{ WERR_IPSEC_IKE_INVALID_HASH_ALG, "Invalid hash algorithm." },
	{ WERR_IPSEC_IKE_INVALID_HASH_SIZE, "Invalid hash size." },
	{ WERR_IPSEC_IKE_INVALID_ENCRYPT_ALG, "Invalid encryption algorithm." },
	{ WERR_IPSEC_IKE_INVALID_AUTH_ALG, "Invalid authentication algorithm." },
	{ WERR_IPSEC_IKE_INVALID_SIG, "Invalid certificate signature." },
	{ WERR_IPSEC_IKE_LOAD_FAILED, "Load failed." },
	{ WERR_IPSEC_IKE_RPC_DELETE, "Deleted by using an RPC call." },
	{ WERR_IPSEC_IKE_BENIGN_REINIT, "A temporary state was created to perform reinitialization. This is not a real failure." },
	{ WERR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY, "The lifetime value received in the Responder Lifetime Notify is below the Windows 2000 configured minimum value. Fix the policy on the peer machine." },
	{ WERR_IPSEC_IKE_INVALID_CERT_KEYLEN, "Key length in the certificate is too small for configured security requirements." },
	{ WERR_IPSEC_IKE_MM_LIMIT, "Maximum number of established MM SAs to peer exceeded." },
	{ WERR_IPSEC_IKE_NEGOTIATION_DISABLED, "The IKE received a policy that disables negotiation." },
	{ WERR_IPSEC_IKE_QM_LIMIT, "Reached maximum quick mode limit for the main mode. New main mode will be started." },
	{ WERR_IPSEC_IKE_MM_EXPIRED, "Main mode SA lifetime expired or the peer sent a main mode delete." },
	{ WERR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID, "Main mode SA assumed to be invalid because peer stopped responding." },
	{ WERR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH, "Certificate does not chain to a trusted root in IPsec policy." },
	{ WERR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID, "Received unexpected message ID." },
	{ WERR_IPSEC_IKE_INVALID_UMATTS, "Received invalid AuthIP user mode attributes." },
	{ WERR_IPSEC_IKE_DOS_COOKIE_SENT, "Sent DOS cookie notify to initiator." },
	{ WERR_IPSEC_IKE_SHUTTING_DOWN, "The IKE service is shutting down." },
	{ WERR_IPSEC_IKE_CGA_AUTH_FAILED, "Could not verify the binding between the color graphics adapter (CGA) address and the certificate." },
	{ WERR_IPSEC_IKE_PROCESS_ERR_NATOA, "Error processing the NatOA payload." },
	{ WERR_IPSEC_IKE_INVALID_MM_FOR_QM, "The parameters of the main mode are invalid for this quick mode." },
	{ WERR_IPSEC_IKE_QM_EXPIRED, "The quick mode SA was expired by the IPsec driver." },
	{ WERR_IPSEC_IKE_TOO_MANY_FILTERS, "Too many dynamically added IKEEXT filters were detected." },
	{ WERR_IPSEC_IKE_NEG_STATUS_END, "ERROR_IPSEC_IKE_NEG_STATUS_END" },
	{ WERR_SXS_SECTION_NOT_FOUND, "The requested section was not present in the activation context." },
	{ WERR_SXS_CANT_GEN_ACTCTX, "The application has failed to start because its side-by-side configuration is incorrect. See the application event log for more detail." },
	{ WERR_SXS_INVALID_ACTCTXDATA_FORMAT, "The application binding data format is invalid." },
	{ WERR_SXS_ASSEMBLY_NOT_FOUND, "The referenced assembly is not installed on your system." },
	{ WERR_SXS_MANIFEST_FORMAT_ERROR, "The manifest file does not begin with the required tag and format information." },
	{ WERR_SXS_MANIFEST_PARSE_ERROR, "The manifest file contains one or more syntax errors." },
	{ WERR_SXS_ACTIVATION_CONTEXT_DISABLED, "The application attempted to activate a disabled activation context." },
	{ WERR_SXS_KEY_NOT_FOUND, "The requested lookup key was not found in any active activation context." },
	{ WERR_SXS_VERSION_CONFLICT, "A component version required by the application conflicts with another active component version." },
	{ WERR_SXS_WRONG_SECTION_TYPE, "The type requested activation context section does not match the query API used." },
	{ WERR_SXS_THREAD_QUERIES_DISABLED, "Lack of system resources has required isolated activation to be disabled for the current thread of execution." },
	{ WERR_SXS_PROCESS_DEFAULT_ALREADY_SET, "An attempt to set the process default activation context failed because the process default activation context was already set." },
	{ WERR_SXS_UNKNOWN_ENCODING_GROUP, "The encoding group identifier specified is not recognized." },
	{ WERR_SXS_UNKNOWN_ENCODING, "The encoding requested is not recognized." },
	{ WERR_SXS_INVALID_XML_NAMESPACE_URI, "The manifest contains a reference to an invalid URI." },
	{ WERR_SXS_ROOT_MANIFEST_DEPENDENCY_OT_INSTALLED, "The application manifest contains a reference to a dependent assembly that is not installed." },
	{ WERR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED, "The manifest for an assembly used by the application has a reference to a dependent assembly that is not installed." },
	{ WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE, "The manifest contains an attribute for the assembly identity that is not valid." },
	{ WERR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE, "The manifest is missing the required default namespace specification on the assembly element." },
	{ WERR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE, "The manifest has a default namespace specified on the assembly element but its value is not urn:schemas-microsoft-com:asm.v1\".\"" },
	{ WERR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT, "The private manifest probed has crossed the reparse-point-associated path." },
	{ WERR_SXS_DUPLICATE_DLL_NAME, "Two or more components referenced directly or indirectly by the application manifest have files by the same name." },
	{ WERR_SXS_DUPLICATE_WINDOWCLASS_NAME, "Two or more components referenced directly or indirectly by the application manifest have window classes with the same name." },
	{ WERR_SXS_DUPLICATE_CLSID, "Two or more components referenced directly or indirectly by the application manifest have the same COM server CLSIDs." },
	{ WERR_SXS_DUPLICATE_IID, "Two or more components referenced directly or indirectly by the application manifest have proxies for the same COM interface IIDs." },
	{ WERR_SXS_DUPLICATE_TLBID, "Two or more components referenced directly or indirectly by the application manifest have the same COM type library TLBIDs." },
	{ WERR_SXS_DUPLICATE_PROGID, "Two or more components referenced directly or indirectly by the application manifest have the same COM ProgIDs." },
	{ WERR_SXS_DUPLICATE_ASSEMBLY_NAME, "Two or more components referenced directly or indirectly by the application manifest are different versions of the same component, which is not permitted." },
	{ WERR_SXS_FILE_HASH_MISMATCH, "A component\'s file does not match the verification information present in the component manifest." },
	{ WERR_SXS_POLICY_PARSE_ERROR, "The policy manifest contains one or more syntax errors." },
	{ WERR_SXS_XML_E_MISSINGQUOTE, "Manifest Parse Error: A string literal was expected, but no opening quotation mark was found." },
	{ WERR_SXS_XML_E_COMMENTSYNTAX, "Manifest Parse Error: Incorrect syntax was used in a comment." },
	{ WERR_SXS_XML_E_BADSTARTNAMECHAR, "Manifest Parse Error: A name started with an invalid character." },
	{ WERR_SXS_XML_E_BADNAMECHAR, "Manifest Parse Error: A name contained an invalid character." },
	{ WERR_SXS_XML_E_BADCHARINSTRING, "Manifest Parse Error: A string literal contained an invalid character." },
	{ WERR_SXS_XML_E_XMLDECLSYNTAX, "Manifest Parse Error: Invalid syntax for an XML declaration." },
	{ WERR_SXS_XML_E_BADCHARDATA, "Manifest Parse Error: An Invalid character was found in text content." },
	{ WERR_SXS_XML_E_MISSINGWHITESPACE, "Manifest Parse Error: Required white space was missing." },
	{ WERR_SXS_XML_E_EXPECTINGTAGEND, "Manifest Parse Error: The angle bracket (>) character was expected." },
	{ WERR_SXS_XML_E_MISSINGSEMICOLON, "Manifest Parse Error: A semicolon (;) was expected." },
	{ WERR_SXS_XML_E_UNBALANCEDPAREN, "Manifest Parse Error: Unbalanced parentheses." },
	{ WERR_SXS_XML_E_INTERNALERROR, "Manifest Parse Error: Internal error." },
	{ WERR_SXS_XML_E_UNEXPECTED_WHITESPACE, "Manifest Parse Error: Whitespace is not allowed at this location." },
	{ WERR_SXS_XML_E_INCOMPLETE_ENCODING, "Manifest Parse Error: End of file reached in invalid state for current encoding." },
	{ WERR_SXS_XML_E_MISSING_PAREN, "Manifest Parse Error: Missing parenthesis." },
	{ WERR_SXS_XML_E_EXPECTINGCLOSEQUOTE, "Manifest Parse Error: A single (\') or double (\") quotation mark is missing." },
	{ WERR_SXS_XML_E_MULTIPLE_COLONS, "Manifest Parse Error: Multiple colons are not allowed in a name." },
	{ WERR_SXS_XML_E_INVALID_DECIMAL, "Manifest Parse Error: Invalid character for decimal digit." },
	{ WERR_SXS_XML_E_INVALID_HEXIDECIMAL, "Manifest Parse Error: Invalid character for hexadecimal digit." },
	{ WERR_SXS_XML_E_INVALID_UNICODE, "Manifest Parse Error: Invalid Unicode character value for this platform." },
	{ WERR_SXS_XML_E_WHITESPACEORQUESTIONMARK, "Manifest Parse Error: Expecting whitespace or question mark (?)." },
	{ WERR_SXS_XML_E_UNEXPECTEDENDTAG, "Manifest Parse Error: End tag was not expected at this location." },
	{ WERR_SXS_XML_E_UNCLOSEDTAG, "Manifest Parse Error: The following tags were not closed: %1." },
	{ WERR_SXS_XML_E_DUPLICATEATTRIBUTE, "Manifest Parse Error: Duplicate attribute." },
	{ WERR_SXS_XML_E_MULTIPLEROOTS, "Manifest Parse Error: Only one top-level element is allowed in an XML document." },
	{ WERR_SXS_XML_E_INVALIDATROOTLEVEL, "Manifest Parse Error: Invalid at the top level of the document." },
	{ WERR_SXS_XML_E_BADXMLDECL, "Manifest Parse Error: Invalid XML declaration." },
	{ WERR_SXS_XML_E_MISSINGROOT, "Manifest Parse Error: XML document must have a top-level element." },
	{ WERR_SXS_XML_E_UNEXPECTEDEOF, "Manifest Parse Error: Unexpected end of file." },
	{ WERR_SXS_XML_E_BADPEREFINSUBSET, "Manifest Parse Error: Parameter entities cannot be used inside markup declarations in an internal subset." },
	{ WERR_SXS_XML_E_UNCLOSEDSTARTTAG, "Manifest Parse Error: Element was not closed." },
	{ WERR_SXS_XML_E_UNCLOSEDENDTAG, "Manifest Parse Error: End element was missing the angle bracket (>) character." },
	{ WERR_SXS_XML_E_UNCLOSEDSTRING, "Manifest Parse Error: A string literal was not closed." },
	{ WERR_SXS_XML_E_UNCLOSEDCOMMENT, "Manifest Parse Error: A comment was not closed." },
	{ WERR_SXS_XML_E_UNCLOSEDDECL, "Manifest Parse Error: A declaration was not closed." },
	{ WERR_SXS_XML_E_UNCLOSEDCDATA, "Manifest Parse Error: A CDATA section was not closed." },
	{ WERR_SXS_XML_E_RESERVEDNAMESPACE, "Manifest Parse Error: The namespace prefix is not allowed to start with the reserved string xml\".\"" },
	{ WERR_SXS_XML_E_INVALIDENCODING, "Manifest Parse Error: System does not support the specified encoding." },
	{ WERR_SXS_XML_E_INVALIDSWITCH, "Manifest Parse Error: Switch from current encoding to specified encoding not supported." },
	{ WERR_SXS_XML_E_BADXMLCASE, "Manifest Parse Error: The name \"xml\" is reserved and must be lowercase." },
	{ WERR_SXS_XML_E_INVALID_STANDALONE, "Manifest Parse Error: The stand-alone attribute must have the value \"yes\" or \"no\"." },
	{ WERR_SXS_XML_E_UNEXPECTED_STANDALONE, "Manifest Parse Error: The stand-alone attribute cannot be used in external entities." },
	{ WERR_SXS_XML_E_INVALID_VERSION, "Manifest Parse Error: Invalid version number." },
	{ WERR_SXS_XML_E_MISSINGEQUALS, "Manifest Parse Error: Missing equal sign (=) between the attribute and the attribute value." },
	{ WERR_SXS_PROTECTION_RECOVERY_FAILED, "Assembly Protection Error: Unable to recover the specified assembly." },
	{ WERR_SXS_PROTECTION_PUBLIC_KEY_OO_SHORT, "Assembly Protection Error: The public key for an assembly was too short to be allowed." },
	{ WERR_SXS_PROTECTION_CATALOG_NOT_VALID, "Assembly Protection Error: The catalog for an assembly is not valid, or does not match the assembly\'s manifest." },
	{ WERR_SXS_UNTRANSLATABLE_HRESULT, "An HRESULT could not be translated to a corresponding Win32 error code." },
	{ WERR_SXS_PROTECTION_CATALOG_FILE_MISSING, "Assembly Protection Error: The catalog for an assembly is missing." },
	{ WERR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE, "The supplied assembly identity is missing one or more attributes that must be present in this context." },
	{ WERR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME, "The supplied assembly identity has one or more attribute names that contain characters not permitted in XML names." },
	{ WERR_SXS_ASSEMBLY_MISSING, "The referenced assembly could not be found." },
	{ WERR_SXS_CORRUPT_ACTIVATION_STACK, "The activation context activation stack for the running thread of execution is corrupt." },
	{ WERR_SXS_CORRUPTION, "The application isolation metadata for this process or thread has become corrupt." },
	{ WERR_SXS_EARLY_DEACTIVATION, "The activation context being deactivated is not the most recently activated one." },
	{ WERR_SXS_INVALID_DEACTIVATION, "The activation context being deactivated is not active for the current thread of execution." },
	{ WERR_SXS_MULTIPLE_DEACTIVATION, "The activation context being deactivated has already been deactivated." },
	{ WERR_SXS_PROCESS_TERMINATION_REQUESTED, "A component used by the isolation facility has requested to terminate the process." },
	{ WERR_SXS_RELEASE_ACTIVATION_ONTEXT, "A kernel mode component is releasing a reference on an activation context." },
	{ WERR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY, "The activation context of the system default assembly could not be generated." },
	{ WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE, "The value of an attribute in an identity is not within the legal range." },
	{ WERR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME, "The name of an attribute in an identity is not within the legal range." },
	{ WERR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE, "An identity contains two definitions for the same attribute." },
	{ WERR_SXS_IDENTITY_PARSE_ERROR, "The identity string is malformed. This may be due to a trailing comma, more than two unnamed attributes, a missing attribute name, or a missing attribute value." },
	{ WERR_MALFORMED_SUBSTITUTION_STRING, "A string containing localized substitutable content was malformed. Either a dollar sign ($) was followed by something other than a left parenthesis or another dollar sign, or a substitution\'s right parenthesis was not found." },
	{ WERR_SXS_INCORRECT_PUBLIC_KEY_OKEN, "The public key token does not correspond to the public key specified." },
	{ WERR_UNMAPPED_SUBSTITUTION_STRING, "A substitution string had no mapping." },
	{ WERR_SXS_ASSEMBLY_NOT_LOCKED, "The component must be locked before making the request." },
	{ WERR_SXS_COMPONENT_STORE_CORRUPT, "The component store has been corrupted." },
	{ WERR_ADVANCED_INSTALLER_FAILED, "An advanced installer failed during setup or servicing." },
	{ WERR_XML_ENCODING_MISMATCH, "The character encoding in the XML declaration did not match the encoding used in the document." },
	{ WERR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT, "The identities of the manifests are identical, but the contents are different." },
	{ WERR_SXS_IDENTITIES_DIFFERENT, "The component identities are different." },
	{ WERR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT, "The assembly is not a deployment." },
	{ WERR_SXS_FILE_NOT_PART_OF_ASSEMBLY, "The file is not a part of the assembly." },
	{ WERR_SXS_MANIFEST_TOO_BIG, "The size of the manifest exceeds the maximum allowed." },
	{ WERR_SXS_SETTING_NOT_REGISTERED, "The setting is not registered." },
	{ WERR_SXS_TRANSACTION_CLOSURE_INCOMPLETE, "One or more required members of the transaction are not present." },
	{ WERR_EVT_INVALID_CHANNEL_PATH, "The specified channel path is invalid." },
	{ WERR_EVT_INVALID_QUERY, "The specified query is invalid." },
	{ WERR_EVT_PUBLISHER_METADATA_NOT_FOUND, "The publisher metadata cannot be found in the resource." },
	{ WERR_EVT_EVENT_TEMPLATE_NOT_FOUND, "The template for an event definition cannot be found in the resource (error = %1)." },
	{ WERR_EVT_INVALID_PUBLISHER_NAME, "The specified publisher name is invalid." },
	{ WERR_EVT_INVALID_EVENT_DATA, "The event data raised by the publisher is not compatible with the event template definition in the publisher\'s manifest." },
	{ WERR_EVT_CHANNEL_NOT_FOUND, "The specified channel could not be found. Check channel configuration." },
	{ WERR_EVT_MALFORMED_XML_TEXT, "The specified XML text was not well-formed. See extended error for more details." },
	{ WERR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL, "The caller is trying to subscribe to a direct channel which is not allowed. The events for a direct channel go directly to a log file and cannot be subscribed to." },
	{ WERR_EVT_CONFIGURATION_ERROR, "Configuration error." },
	{ WERR_EVT_QUERY_RESULT_STALE, "The query result is stale or invalid. This may be due to the log being cleared or rolling over after the query result was created. Users should handle this code by releasing the query result object and reissuing the query." },
	{ WERR_EVT_QUERY_RESULT_INVALID_POSITION, "Query result is currently at an invalid position." },
	{ WERR_EVT_NON_VALIDATING_MSXML, "Registered Microsoft XML (MSXML) does not support validation." },
	{ WERR_EVT_FILTER_ALREADYSCOPED, "An expression can only be followed by a change-of-scope operation if it itself evaluates to a node set and is not already part of some other change-of-scope operation." },
	{ WERR_EVT_FILTER_NOTELTSET, "Cannot perform a step operation from a term that does not represent an element set." },
	{ WERR_EVT_FILTER_INVARG, "Left side arguments to binary operators must be either attributes, nodes, or variables and right side arguments must be constants." },
	{ WERR_EVT_FILTER_INVTEST, "A step operation must involve either a node test or, in the case of a predicate, an algebraic expression against which to test each node in the node set identified by the preceding node set can be evaluated." },
	{ WERR_EVT_FILTER_INVTYPE, "This data type is currently unsupported." },
	{ WERR_EVT_FILTER_PARSEERR, "A syntax error occurred at position %1!d!" },
	{ WERR_EVT_FILTER_UNSUPPORTEDOP, "This operator is unsupported by this implementation of the filter." },
	{ WERR_EVT_FILTER_UNEXPECTEDTOKEN, "The token encountered was unexpected." },
	{ WERR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL, "The requested operation cannot be performed over an enabled direct channel. The channel must first be disabled before performing the requested operation." },
	{ WERR_EVT_INVALID_CHANNEL_PROPERTY_VALUE, "Channel property %1!s! contains an invalid value. The value has an invalid type, is outside the valid range, cannot be updated, or is not supported by this type of channel." },
	{ WERR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE, "Publisher property %1!s! contains an invalid value. The value has an invalid type, is outside the valid range, cannot be updated, or is not supported by this type of publisher." },
	{ WERR_EVT_CHANNEL_CANNOT_ACTIVATE, "The channel fails to activate." },
	{ WERR_EVT_FILTER_TOO_COMPLEX, "The xpath expression exceeded supported complexity. Simplify it or split it into two or more simple expressions." },
	{ WERR_EVT_MESSAGE_NOT_FOUND, "The message resource is present but the message is not found in the string or message table." },
	{ WERR_EVT_MESSAGE_ID_NOT_FOUND, "The message ID for the desired message could not be found." },
	{ WERR_EVT_UNRESOLVED_VALUE_INSERT, "The substitution string for the insert index (%1) could not be found." },
	{ WERR_EVT_UNRESOLVED_PARAMETER_INSERT, "The description string for the parameter reference (%1) could not be found." },
	{ WERR_EVT_MAX_INSERTS_REACHED, "The maximum number of replacements has been reached." },
	{ WERR_EVT_EVENT_DEFINITION_NOT_OUND, "The event definition could not be found for the event ID (%1)." },
	{ WERR_EVT_MESSAGE_LOCALE_NOT_FOUND, "The locale-specific resource for the desired message is not present." },
	{ WERR_EVT_VERSION_TOO_OLD, "The resource is too old to be compatible." },
	{ WERR_EVT_VERSION_TOO_NEW, "The resource is too new to be compatible." },
	{ WERR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY, "The channel at index %1 of the query cannot be opened." },
	{ WERR_EVT_PUBLISHER_DISABLED, "The publisher has been disabled and its resource is not available. This usually occurs when the publisher is in the process of being uninstalled or upgraded." },
	{ WERR_EC_SUBSCRIPTION_CANNOT_ACTIVATE, "The subscription fails to activate." },
	{ WERR_EC_LOG_DISABLED, "The log of the subscription is in a disabled state and events cannot be forwarded to it. The log must first be enabled before the subscription can be activated." },
	{ WERR_MUI_FILE_NOT_FOUND, "The resource loader failed to find the Multilingual User Interface (MUI) file." },
	{ WERR_MUI_INVALID_FILE, "The resource loader failed to load the MUI file because the file failed to pass validation." },
	{ WERR_MUI_INVALID_RC_CONFIG, "The release candidate (RC) manifest is corrupted with garbage data, is an unsupported version, or is missing a required item." },
	{ WERR_MUI_INVALID_LOCALE_NAME, "The RC manifest has an invalid culture name." },
	{ WERR_MUI_INVALID_ULTIMATEFALLBACK_NAME, "The RC Manifest has an invalid ultimate fallback name." },
	{ WERR_MUI_FILE_NOT_LOADED, "The resource loader cache does not have a loaded MUI entry." },
	{ WERR_RESOURCE_ENUM_USER_STOP, "The user stopped resource enumeration." },
	{ WERR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED, "User interface language installation failed." },
	{ WERR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME, "Locale installation failed." },
	{ WERR_MCA_INVALID_CAPABILITIES_STRING, "The monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1, or MCCS 2 Revision 1 specification." },
	{ WERR_MCA_INVALID_VCP_VERSION, "The monitor\'s VCP version (0xDF) VCP code returned an invalid version value." },
	{ WERR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION, "The monitor does not comply with the MCCS specification it claims to support." },
	{ WERR_MCA_MCCS_VERSION_MISMATCH, "The MCCS version in a monitor\'s mccs_ver capability does not match the MCCS version the monitor reports when the VCP version (0xDF) VCP code is used." },
	{ WERR_MCA_UNSUPPORTED_MCCS_VERSION, "The monitor configuration API works only with monitors that support the MCCS 1.0, MCCS 2.0, or MCCS 2.0 Revision 1 specifications." },
	{ WERR_MCA_INTERNAL_ERROR, "An internal monitor configuration API error occurred." },
	{ WERR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED, "The monitor returned an invalid monitor technology type. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification." },
	{ WERR_MCA_UNSUPPORTED_COLOR_TEMPERATURE, "The SetMonitorColorTemperature() caller passed a color temperature to it that the current monitor did not support. CRT, plasma, and LCD (TFT) are examples of monitor technology types. This error implies that the monitor violated the MCCS 2.0 or MCCS 2.0 Revision 1 specification." },
	{ WERR_AMBIGUOUS_SYSTEM_DEVICE, "The requested system device cannot be identified due to multiple indistinguishable devices potentially matching the identification criteria." },
	{ WERR_SYSTEM_DEVICE_NOT_FOUND, "The requested system device cannot be found." },
	/* END GENERATED-WIN32-ERROR-CODES-DESC */
};



/*****************************************************************************
 Get friendly error string for WERRORs
 *****************************************************************************/

const char *get_friendly_werror_msg(WERROR werror)
{
	int i = 0;

	for (i = 0; i < ARRAY_SIZE(dos_err_strs); i++) {
		if (W_ERROR_V(dos_err_strs[i].werror) ==
                    W_ERROR_V(werror)) {
			return dos_err_strs[i].friendly_errstr;
		}
	}

	return win_errstr(werror);
}
