/*
 * s51dude - A Downloader/Uploader for 8051 device programmers
 * Copyright (C) 2008 Lucas Chiesa.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "s51dude.h"
#include "parts.h"
//#include "usbtiny.h"

void load_dev (char *dest)
{
	if (!strcmp(dest,AT89S8252_text)) {
		options.mem_micro = AT89S8252_max_mem;
		options.micro = AT89S8252;
		options.val = TAMANIO_8252 + MICRO_8252;		
		options.ind_r_eeprom = AT89S8252_read_eeprom;
		options.ind_r_flash =  AT89S8252_read_flash;
		options.ind_w_eeprom = AT89S8252_write_eeprom + (AT89S8252_read_eeprom << 8);
		options.ind_w_flash =  AT89S8252_write_flash + (AT89S8252_read_flash << 8);	
				
		options.enable_programing[0] = AT89S8252_enable_code_b0;
		options.enable_programing[1] = AT89S8252_enable_code_b1;
		options.enable_programing[2] = AT89S8252_enable_code_b2;
		options.enable_programing[3] = AT89S8252_enable_code_b3;
		
		options.erase[0] = AT89S8252_erase_code_b0;
		options.erase[1] = AT89S8252_erase_code_b1;
		options.erase[2] = AT89S8252_erase_code_b2;
		options.erase[3] = AT89S8252_erase_code_b3;
		
		options.delay	=  AT89S8252_delay;
		
		options.text_micro=(char *) malloc ((strlen(AT89S8252_text)+1)*sizeof(char));
	   	strcpy(options.text_micro,AT89S8252_text);
	}
	if (!strcmp(dest,AT89S8253_text)) {
		options.mem_micro = AT89S8253_max_mem;
		options.micro = AT89S8253;
		options.val = TAMANIO_8253 + MICRO_8253 + INVERTED_SCK_MASK;
		options.ind_r_eeprom = AT89S8253_read_eeprom;
		options.ind_r_flash =  AT89S8253_read_flash;
		options.ind_w_eeprom = AT89S8253_write_eeprom + (AT89S8253_read_eeprom << 8);
		options.ind_w_flash =  AT89S8253_write_flash + (AT89S8253_read_flash << 8);		
		
		options.enable_programing[0] = AT89S8253_enable_code_b0;
		options.enable_programing[1] = AT89S8253_enable_code_b1;
		options.enable_programing[2] = AT89S8253_enable_code_b2;
		options.enable_programing[3] = AT89S8253_enable_code_b3;

		options.erase[0] = AT89S8253_erase_code_b0;
		options.erase[1] = AT89S8253_erase_code_b1;
		options.erase[2] = AT89S8253_erase_code_b2;
		options.erase[3] = AT89S8253_erase_code_b3;

		options.delay	=  AT89S8253_delay;
				
		options.text_micro=(char *) malloc ((strlen(AT89S8253_text)+1)*sizeof(char));
		strcpy(options.text_micro,AT89S8253_text);
	}
	if (!strcmp(dest,AT89S53_text)) {
		options.mem_micro = AT89S53_max_mem;
		options.micro = AT89S53;
		options.val = TAMANIO_8252 + MICRO_8252;
		options.ind_r_eeprom = AT89S53_read_eeprom;
		options.ind_r_flash =  AT89S53_read_flash;
		options.ind_w_eeprom = AT89S53_write_eeprom + (AT89S53_read_eeprom << 8);
		options.ind_w_flash =  AT89S53_write_flash + (AT89S53_read_flash << 8);	
		
		options.enable_programing[0] = AT89S53_enable_code_b0;
		options.enable_programing[1] = AT89S53_enable_code_b1;
		options.enable_programing[2] = AT89S53_enable_code_b2;
		options.enable_programing[3] = AT89S53_enable_code_b3;		
		
		options.erase[0] = AT89S53_erase_code_b0;
		options.erase[1] = AT89S53_erase_code_b1;
		options.erase[2] = AT89S53_erase_code_b2;
		options.erase[3] = AT89S53_erase_code_b3;		
		
		options.delay	=  AT89S53_delay;
		
		options.text_micro=(char *) malloc ((strlen(AT89S53_text)+1)*sizeof(char));
	   	strcpy(options.text_micro,AT89S53_text);
	}
	if (!strcmp(dest,AT89S52_text)) {
		options.mem_micro = AT89S52_max_mem;
		options.micro = AT89S52;
		options.val = TAMANIO_8253 + MICRO_8253;
		options.ind_r_eeprom = AT89S52_read_eeprom;
		options.ind_r_flash =  AT89S52_read_flash;
		options.ind_w_eeprom = AT89S52_write_eeprom + (AT89S52_read_eeprom << 8);
		options.ind_w_flash =  AT89S52_write_flash + (AT89S52_read_flash << 8);		
		
		options.enable_programing[0] = AT89S52_enable_code_b0;
		options.enable_programing[1] = AT89S52_enable_code_b1;
		options.enable_programing[2] = AT89S52_enable_code_b2;
		options.enable_programing[3] = AT89S52_enable_code_b3;		
		
		options.erase[0] = AT89S52_erase_code_b0;
		options.erase[1] = AT89S52_erase_code_b1;
		options.erase[2] = AT89S52_erase_code_b2;
		options.erase[3] = AT89S52_erase_code_b3;				
		
		options.delay	=  AT89S52_delay;
		
		options.text_micro=(char *) malloc ((strlen(AT89S52_text)+1)*sizeof(char));
		strcpy(options.text_micro,AT89S52_text);
	}
}

