ifndef $(COMMON_INCLUDED)
COMMON_INCLUDED = true

# Global definitions
VERSION            = 1
RELEASE            = 6
PATCHLEVEL         = 2
S390_TOOLS_RELEASE = $(VERSION).$(RELEASE).$(PATCHLEVEL)
SYSFS              = true
export S390_TOOLS_RELEASE SYSFS 

# Cross Compiling Support
CROSS_COMPILE   =
AS              = $(CROSS_COMPILE)as
LD              = $(CROSS_COMPILE)ld
CC              = $(CROSS_COMPILE)gcc
CXX             = $(CROSS_COMPILE)g++ 
CPP             = $(CC) -E
AR              = $(CROSS_COMPILE)ar
NM              = $(CROSS_COMPILE)nm
STRIP           = $(CROSS_COMPILE)strip
OBJCOPY         = $(CROSS_COMPILE)objcopy
OBJDUMP         = $(CROSS_COMPILE)objdump
INSTALL         = install # FIXME: We need s390-install (strip)
CFLAGS		= $(OPT_FLAGS) -Wall -O3 -DS390_TOOLS_RELEASE=$(S390_TOOLS_RELEASE)
export AS LD CC CPP AR NM STRIP OBJCOPY OBJDUMP INSTALL CFLAGS

# Support alternate install root
INSTROOT        =
USRSBINDIR      = $(INSTROOT)/usr/sbin
USRBINDIR       = $(INSTROOT)/usr/bin
BINDIR          = $(INSTROOT)/sbin
LIBDIR          = $(INSTROOT)/lib
MANDIR          = $(INSTROOT)/usr/share/man
OWNER           = $(shell id -un)
GROUP		= $(shell id -gn)
export INSTROOT BINDIR LIBDIR MANDIR OWNER GROUP

# Special defines for zfcpdump
ZFCPDUMP_DIR    = /usr/local/share/zfcpdump
ZFCPDUMP_IMAGE  = zfcpdump.image
ZFCPDUMP_RD     = zfcpdump.rd
export ZFCPDUMP_DIR ZFCPDUMP_IMAGE ZFCPDUMP_RD
endif

