/* rygel-thumbnailer.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-thumbnailer.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_THUMBNAILER (rygel_thumbnailer_get_type ())
#define RYGEL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailer))
#define RYGEL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))
#define RYGEL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_IS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAILER))
#define RYGEL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerClass))

typedef struct _RygelThumbnailer RygelThumbnailer;
typedef struct _RygelThumbnailerClass RygelThumbnailerClass;
typedef struct _RygelThumbnailerPrivate RygelThumbnailerPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_DBUS_THUMBNAILER (rygel_dbus_thumbnailer_get_type ())
#define RYGEL_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailer))
#define RYGEL_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))
#define RYGEL_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_THUMBNAILER))
#define RYGEL_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_THUMBNAILER, RygelDbusThumbnailerClass))

typedef struct _RygelDbusThumbnailer RygelDbusThumbnailer;
typedef struct _RygelDbusThumbnailerClass RygelDbusThumbnailerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	THUMBNAILER_ERROR_NO_DIR,
	THUMBNAILER_ERROR_NO_THUMBNAIL
} ThumbnailerError;
#define THUMBNAILER_ERROR thumbnailer_error_quark ()
struct _RygelThumbnailer {
	GObject parent_instance;
	RygelThumbnailerPrivate * priv;
	gchar* directory;
};

struct _RygelThumbnailerClass {
	GObjectClass parent_class;
};

struct _RygelThumbnailerPrivate {
	RygelThumbnail* template;
	gchar* extension;
	RygelDbusThumbnailer* thumbler;
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelThumbnail {
	RygelIconInfo parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* dlna_profile;
};

struct _RygelThumbnailClass {
	RygelIconInfoClass parent_class;
	GUPnPDIDLLiteResource* (*add_resource) (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const gchar* protocol);
};


static gpointer rygel_thumbnailer_parent_class = NULL;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer;
static RygelThumbnailer* rygel_thumbnailer_thumbnailer = NULL;
static gboolean rygel_thumbnailer_first_time;
static gboolean rygel_thumbnailer_first_time = TRUE;

GQuark thumbnailer_error_quark (void);
GType rygel_thumbnailer_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_dbus_thumbnailer_get_type (void) G_GNUC_CONST;
#define RYGEL_THUMBNAILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_THUMBNAILER, RygelThumbnailerPrivate))
enum  {
	RYGEL_THUMBNAILER_DUMMY_PROPERTY
};
static RygelThumbnailer* rygel_thumbnailer_new (GError** error);
static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_new (const gchar* flavor, GError** error);
RygelDbusThumbnailer* rygel_dbus_thumbnailer_construct (GType object_type, const gchar* flavor, GError** error);
RygelThumbnailer* rygel_thumbnailer_get_default (void);
RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error);
void rygel_dbus_thumbnailer_queue_thumbnail_task (RygelDbusThumbnailer* self, const gchar* file_path, const gchar* mime);
static void rygel_thumbnailer_finalize (GObject* obj);


GQuark thumbnailer_error_quark (void) {
	return g_quark_from_static_string ("thumbnailer_error-quark");
}


static RygelThumbnailer* rygel_thumbnailer_construct (GType object_type, GError** error) {
	RygelThumbnailer * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* dir;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	RygelThumbnail* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GError * _inner_error_ = NULL;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self = (RygelThumbnailer*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp0_ = g_get_home_dir ();
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp1_ = g_build_filename (_tmp0_, ".thumbnails", "cropped", NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	dir = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp2_ = dir;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	file = _tmp3_;
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp4_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self->priv->template = _tmp4_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp5_ = file;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (!_tmp6_) {
#line 212 "rygel-thumbnailer.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_;
		gboolean _tmp12_ = FALSE;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp7_ = g_get_home_dir ();
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp8_ = g_build_filename (_tmp7_, ".thumbnails", "normal", NULL);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (dir);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		dir = _tmp8_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp9_ = dir;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp10_ = g_file_new_for_path (_tmp9_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		file = _tmp10_;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp11_ = file;
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp12_ = g_file_query_exists (_tmp11_, NULL);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		if (!_tmp12_) {
#line 241 "rygel-thumbnailer.c"
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* message;
			const gchar* _tmp15_;
			GError* _tmp16_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp13_ = _ ("Failed to find thumbnails folder.");
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			message = _tmp14_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp15_ = message;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp16_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_DIR, _tmp15_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_inner_error_ = _tmp16_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_free0 (message);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_object_unref0 (file);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_free0 (dir);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_object_unref0 (self);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				return NULL;
#line 273 "rygel-thumbnailer.c"
			} else {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_free0 (message);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_object_unref0 (file);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				_g_free0 (dir);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				return NULL;
#line 287 "rygel-thumbnailer.c"
			}
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (message);
#line 291 "rygel-thumbnailer.c"
		} else {
			RygelThumbnail* _tmp17_;
			gchar* _tmp18_;
			RygelThumbnail* _tmp19_;
			gchar* _tmp20_;
			RygelThumbnail* _tmp21_;
			RygelThumbnail* _tmp22_;
			RygelThumbnail* _tmp23_;
			gchar* _tmp24_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp17_ = self->priv->template;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp18_ = g_strdup ("image/png");
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (((RygelIconInfo*) _tmp17_)->mime_type);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			((RygelIconInfo*) _tmp17_)->mime_type = _tmp18_;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp19_ = self->priv->template;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp20_ = g_strdup ("PNG_TN");
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (_tmp19_->dlna_profile);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp19_->dlna_profile = _tmp20_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp21_ = self->priv->template;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			((RygelIconInfo*) _tmp21_)->width = 128;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp22_ = self->priv->template;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			((RygelIconInfo*) _tmp22_)->height = 128;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp23_ = self->priv->template;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			((RygelIconInfo*) _tmp23_)->depth = 32;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp24_ = g_strdup (".png");
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (self->priv->extension);
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			self->priv->extension = _tmp24_;
#line 335 "rygel-thumbnailer.c"
		}
	} else {
		RygelThumbnail* _tmp25_;
		RygelThumbnail* _tmp26_;
		RygelThumbnail* _tmp27_;
		gchar* _tmp28_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp25_ = self->priv->template;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		((RygelIconInfo*) _tmp25_)->width = 124;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp26_ = self->priv->template;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		((RygelIconInfo*) _tmp26_)->height = 124;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp27_ = self->priv->template;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		((RygelIconInfo*) _tmp27_)->depth = 24;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp28_ = g_strdup (".jpeg");
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (self->priv->extension);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		self->priv->extension = _tmp28_;
#line 360 "rygel-thumbnailer.c"
	}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp29_ = dir;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp30_ = g_strdup (_tmp29_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (self->directory);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self->directory = _tmp30_;
#line 370 "rygel-thumbnailer.c"
	{
		RygelDbusThumbnailer* _tmp31_;
		RygelDbusThumbnailer* _tmp32_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp31_ = rygel_dbus_thumbnailer_new ("normal", &_inner_error_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp32_ = _tmp31_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 380 "rygel-thumbnailer.c"
			goto __catch56_g_error;
		}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (self->priv->thumbler);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		self->priv->thumbler = _tmp32_;
#line 387 "rygel-thumbnailer.c"
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* _error_ = NULL;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_error_ = _inner_error_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_inner_error_ = NULL;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_error_free0 (_error_);
#line 399 "rygel-thumbnailer.c"
	}
	__finally56:
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_object_unref0 (file);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (dir);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_object_unref0 (self);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			return NULL;
#line 416 "rygel-thumbnailer.c"
		} else {
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_object_unref0 (file);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_free0 (dir);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			return NULL;
#line 428 "rygel-thumbnailer.c"
		}
	}
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (dir);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	return self;
#line 437 "rygel-thumbnailer.c"
}


static RygelThumbnailer* rygel_thumbnailer_new (GError** error) {
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	return rygel_thumbnailer_construct (RYGEL_TYPE_THUMBNAILER, error);
#line 444 "rygel-thumbnailer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	return self ? g_object_ref (self) : NULL;
#line 451 "rygel-thumbnailer.c"
}


RygelThumbnailer* rygel_thumbnailer_get_default (void) {
	RygelThumbnailer* result = NULL;
	gboolean _tmp0_;
	RygelThumbnailer* _tmp6_;
	RygelThumbnailer* _tmp7_;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp0_ = rygel_thumbnailer_first_time;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_tmp0_) {
#line 465 "rygel-thumbnailer.c"
		{
			RygelThumbnailer* _tmp1_;
			RygelThumbnailer* _tmp2_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp1_ = rygel_thumbnailer_new (&_inner_error_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp2_ = _tmp1_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			if (_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				if (_inner_error_->domain == THUMBNAILER_ERROR) {
#line 477 "rygel-thumbnailer.c"
					goto __catch57_thumbnailer_error;
				}
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				g_clear_error (&_inner_error_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
				return NULL;
#line 486 "rygel-thumbnailer.c"
			}
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_object_unref0 (rygel_thumbnailer_thumbnailer);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			rygel_thumbnailer_thumbnailer = _tmp2_;
#line 492 "rygel-thumbnailer.c"
		}
		goto __finally57;
		__catch57_thumbnailer_error:
		{
			GError* err = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			err = _inner_error_;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_inner_error_ = NULL;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp3_ = _ ("No thumbnailer available: %s");
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp4_ = err;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_tmp5_ = _tmp4_->message;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_warning (_tmp3_, _tmp5_);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			_g_error_free0 (err);
#line 515 "rygel-thumbnailer.c"
		}
		__finally57:
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		if (_inner_error_ != NULL) {
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			g_clear_error (&_inner_error_);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
			return NULL;
#line 526 "rygel-thumbnailer.c"
		}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		rygel_thumbnailer_first_time = FALSE;
#line 530 "rygel-thumbnailer.c"
	}
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp6_ = rygel_thumbnailer_thumbnailer;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	result = _tmp7_;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	return result;
#line 540 "rygel-thumbnailer.c"
}


RygelThumbnail* rygel_thumbnailer_get_thumbnail (RygelThumbnailer* self, const gchar* uri, const gchar* mime_type, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* thumbnail;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* path;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* full_path;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	gboolean _tmp11_ = FALSE;
	RygelDbusThumbnailer* _tmp12_;
	gboolean _tmp15_;
	GFile* _tmp19_;
	GFileInfo* _tmp20_ = NULL;
	GFileInfo* info;
	GFileInfo* _tmp21_;
	gboolean _tmp22_ = FALSE;
	RygelThumbnail* _tmp25_;
	const gchar* _tmp26_;
	RygelThumbnail* _tmp27_;
	const gchar* _tmp28_;
	RygelThumbnail* _tmp29_;
	const gchar* _tmp30_;
	RygelThumbnail* _tmp31_;
	RygelThumbnail* _tmp32_;
	RygelThumbnail* _tmp33_;
	gint _tmp34_;
	RygelThumbnail* _tmp35_;
	RygelThumbnail* _tmp36_;
	gint _tmp37_;
	RygelThumbnail* _tmp38_;
	RygelThumbnail* _tmp39_;
	gint _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	RygelThumbnail* _tmp44_;
	RygelThumbnail* _tmp45_;
	GFileInfo* _tmp46_;
	guint64 _tmp47_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	thumbnail = NULL;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp0_ = uri;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp1_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp0_, (gsize) (-1));
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp3_ = self->priv->extension;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp5_ = _tmp4_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (_tmp2_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	path = _tmp5_;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp6_ = self->directory;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp7_ = path;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	full_path = _tmp8_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp9_ = full_path;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp10_ = g_file_new_for_path (_tmp9_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	file = _tmp10_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp12_ = self->priv->thumbler;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_tmp12_ != NULL) {
#line 635 "rygel-thumbnailer.c"
		GFile* _tmp13_;
		gboolean _tmp14_ = FALSE;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp13_ = file;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp14_ = g_file_query_exists (_tmp13_, NULL);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp11_ = !_tmp14_;
#line 644 "rygel-thumbnailer.c"
	} else {
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp11_ = FALSE;
#line 648 "rygel-thumbnailer.c"
	}
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp15_ = _tmp11_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_tmp15_) {
#line 654 "rygel-thumbnailer.c"
		RygelDbusThumbnailer* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp16_ = self->priv->thumbler;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp17_ = uri;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp18_ = mime_type;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		rygel_dbus_thumbnailer_queue_thumbnail_task (_tmp16_, _tmp17_, _tmp18_);
#line 666 "rygel-thumbnailer.c"
	}
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp19_ = file;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp20_ = g_file_query_info (_tmp19_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	info = _tmp20_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (full_path);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_rygel_icon_info_unref0 (thumbnail);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		return NULL;
#line 688 "rygel-thumbnailer.c"
	}
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp21_ = info;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp22_ = g_file_info_get_attribute_boolean (_tmp21_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (!_tmp22_) {
#line 696 "rygel-thumbnailer.c"
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp23_ = _ ("No thumbnail available");
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_tmp24_ = g_error_new_literal (THUMBNAILER_ERROR, THUMBNAILER_ERROR_NO_THUMBNAIL, _tmp23_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_inner_error_ = _tmp24_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (full_path);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_rygel_icon_info_unref0 (thumbnail);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		return NULL;
#line 719 "rygel-thumbnailer.c"
	}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp25_ = self->priv->template;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp26_ = ((RygelIconInfo*) _tmp25_)->mime_type;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp27_ = self->priv->template;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp28_ = _tmp27_->dlna_profile;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp29_ = self->priv->template;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp30_ = ((RygelIconInfo*) _tmp29_)->file_extension;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp31_ = rygel_thumbnail_new (_tmp26_, _tmp28_, _tmp30_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (thumbnail);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	thumbnail = _tmp31_;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp32_ = thumbnail;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp33_ = self->priv->template;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp34_ = ((RygelIconInfo*) _tmp33_)->width;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp32_)->width = _tmp34_;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp35_ = thumbnail;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp36_ = self->priv->template;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp37_ = ((RygelIconInfo*) _tmp36_)->height;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp35_)->height = _tmp37_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp38_ = thumbnail;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp39_ = self->priv->template;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp40_ = ((RygelIconInfo*) _tmp39_)->depth;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp38_)->depth = _tmp40_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp41_ = full_path;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp42_ = g_filename_to_uri (_tmp41_, NULL, &_inner_error_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp43_ = _tmp42_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	if (_inner_error_ != NULL) {
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (info);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_object_unref0 (file);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (full_path);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_g_free0 (path);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		_rygel_icon_info_unref0 (thumbnail);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
		return NULL;
#line 785 "rygel-thumbnailer.c"
	}
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp44_ = thumbnail;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (((RygelIconInfo*) _tmp44_)->uri);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp44_)->uri = _tmp43_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp45_ = thumbnail;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp46_ = info;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_tmp47_ = g_file_info_get_attribute_uint64 (_tmp46_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	((RygelIconInfo*) _tmp45_)->size = (gint64) _tmp47_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	result = thumbnail;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_object_unref0 (info);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_object_unref0 (file);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (full_path);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (path);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	return result;
#line 813 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_class_init (RygelThumbnailerClass * klass) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	rygel_thumbnailer_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	g_type_class_add_private (klass, sizeof (RygelThumbnailerPrivate));
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnailer_finalize;
#line 824 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_instance_init (RygelThumbnailer * self) {
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self->priv = RYGEL_THUMBNAILER_GET_PRIVATE (self);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self->priv->thumbler = NULL;
#line 833 "rygel-thumbnailer.c"
}


static void rygel_thumbnailer_finalize (GObject* obj) {
	RygelThumbnailer * self;
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	self = RYGEL_THUMBNAILER (obj);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (self->directory);
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_rygel_icon_info_unref0 (self->priv->template);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_free0 (self->priv->extension);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	_g_object_unref0 (self->priv->thumbler);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-thumbnailer.vala"
	G_OBJECT_CLASS (rygel_thumbnailer_parent_class)->finalize (obj);
#line 851 "rygel-thumbnailer.c"
}


/**
 * Provides thumbnails for images and vidoes.
 */
GType rygel_thumbnailer_get_type (void) {
	static volatile gsize rygel_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnailer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnailer), 0, (GInstanceInitFunc) rygel_thumbnailer_instance_init, NULL };
		GType rygel_thumbnailer_type_id;
		rygel_thumbnailer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnailer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnailer_type_id__volatile, rygel_thumbnailer_type_id);
	}
	return rygel_thumbnailer_type_id__volatile;
}



