/* rygel-main.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gio/gio.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;

#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_root_device_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_root_device_factory_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelRootDeviceFactoryPrivate RygelRootDeviceFactoryPrivate;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelRootDeviceFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelRootDeviceFactoryPrivate * priv;
	GUPnPContext* context;
};

struct _RygelRootDeviceFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelRootDeviceFactory *self);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDeviceFactory* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDevice* _tmp2_;
	RygelRootDevice* device;
	gboolean _tmp3_;
	RygelPlugin* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelConfiguration* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	RygelRootDevice* _tmp10_;
	gboolean _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	RygelRootDevice* _tmp14_;
	RygelPlugin* _tmp15_;
	GError* _error_;
	const gchar* _tmp16_;
	RygelPlugin* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
gpointer rygel_root_device_factory_ref (gpointer instance);
void rygel_root_device_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_root_device_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_root_device_factory (GValue* value, gpointer v_object);
void rygel_value_take_root_device_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_root_device_factory (const GValue* value);
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
RygelLogHandler* rygel_log_handler_get_default (void);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
void rygel_signal_handler_setup (RygelMain* _main);
void rygel_main_exit (RygelMain* self, gint exit_code);
void rygel_signal_handler_cleanup (void);
void rygel_main_restart (RygelMain* self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
static gboolean __lambda14_ (RygelMain* self);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static gboolean ___lambda14__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self);
gchar* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
gboolean rygel_plugin_get_active (RygelPlugin* self);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_loaded (self, _sender, plugin);
#line 364 "rygel-main.c"
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GMainLoop* _tmp6_;
	RygelPluginLoader* _tmp7_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = (RygelMain*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _ (PACKAGE_NAME);
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_set_application_name (_tmp0_);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_log_handler_get_default ();
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->log_handler = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_meta_config_get_default ();
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->config = (RygelConfiguration*) _tmp2_;
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = rygel_plugin_loader_new ();
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->plugin_loader = _tmp3_;
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 50 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = _tmp4_;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) rygel_root_device_factory_ref, rygel_root_device_factory_unref, NULL);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->factories = _tmp5_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = g_main_loop_new (NULL, FALSE);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->main_loop = _tmp6_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = 0;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = self->priv->plugin_loader;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_signal_handler_setup (self);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self;
#line 430 "rygel-main.c"
}


static RygelMain* rygel_main_new (GError** error) {
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
#line 437 "rygel-main.c"
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
#line 61 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = exit_code;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = NULL;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->main_loop;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_quit (_tmp1_);
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_signal_handler_cleanup ();
#line 460 "rygel-main.c"
}


void rygel_main_restart (RygelMain* self) {
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->need_restart = TRUE;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 471 "rygel-main.c"
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	GMainLoop* _tmp0_;
	gint _tmp1_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->main_loop;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_run (_tmp0_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->exit_code;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = _tmp1_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 491 "rygel-main.c"
}


static gboolean __lambda14_ (RygelMain* self) {
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->plugin_loader;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = gee_collection_get_size (_tmp2_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _tmp3_;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_ == 0;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_tmp2_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp5_) {
#line 519 "rygel-main.c"
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = rygel_main_PLUGIN_TIMEOUT;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = ngettext ("No plugins found in %d second; giving up..", "No plugins found in %d seconds; giving up..", (gulong) _tmp6_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = rygel_main_PLUGIN_TIMEOUT;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_tmp7_, _tmp8_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_exit (self, -82);
#line 533 "rygel-main.c"
	}
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 539 "rygel-main.c"
}


static gboolean ___lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda14_ (self);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 548 "rygel-main.c"
}


void rygel_main_dbus_available (RygelMain* self) {
	GUPnPContextManager* _tmp0_ = NULL;
	RygelPluginLoader* _tmp1_;
	gint _tmp2_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = rygel_main_create_context_manager (self);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->context_manager = _tmp0_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->plugin_loader;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_plugin_loader_load_plugins (_tmp1_);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_main_PLUGIN_TIMEOUT;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp2_, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
#line 572 "rygel-main.c"
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	GeeIterator* iterator;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin_loader != NULL);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin != NULL);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->factories;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	iterator = _tmp1_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 594 "rygel-main.c"
		GeeIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		RygelPlugin* _tmp4_;
		GeeIterator* _tmp5_;
		gpointer _tmp6_ = NULL;
		RygelRootDeviceFactory* _tmp7_;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = iterator;
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp3_) {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 609 "rygel-main.c"
		}
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = plugin;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = iterator;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = gee_iterator_get (_tmp5_);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = (RygelRootDeviceFactory*) _tmp6_;
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_create_device (self, _tmp4_, _tmp7_, NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_rygel_root_device_factory_unref0 (_tmp7_);
#line 623 "rygel-main.c"
	}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (iterator);
#line 627 "rygel-main.c"
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_available (self, _sender, p0);
#line 634 "rygel-main.c"
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* p0, gpointer self) {
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_unavailable (self, _sender, p0);
#line 641 "rygel-main.c"
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port;
	gint _tmp3_;
	GUPnPContextManager* _tmp4_;
	GUPnPContextManager* manager;
	GError * _inner_error_ = NULL;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	port = 0;
#line 656 "rygel-main.c"
	{
		RygelConfiguration* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = self->priv->config;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp1_ = rygel_configuration_get_port (_tmp0_, &_inner_error_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = _tmp1_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 669 "rygel-main.c"
			goto __catch83_g_error;
		}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		port = _tmp2_;
#line 674 "rygel-main.c"
	}
	goto __finally83;
	__catch83_g_error:
	{
		GError* err = NULL;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 686 "rygel-main.c"
	}
	__finally83:
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 112 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return NULL;
#line 697 "rygel-main.c"
	}
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = port;
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gupnp_context_manager_new (NULL, (guint) _tmp3_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	manager = _tmp4_;
#line 118 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = manager;
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 713 "rygel-main.c"
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar* iface;
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp19_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	iface = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:128: New network %s (%s) context available. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 762 "rygel-main.c"
	{
		RygelConfiguration* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9_ = self->priv->config;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp10_ = rygel_configuration_get_interface (_tmp9_, &_inner_error_);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = _tmp10_;
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 775 "rygel-main.c"
			goto __catch84_g_error;
		}
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_free0 (iface);
#line 134 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		iface = _tmp11_;
#line 782 "rygel-main.c"
	}
	goto __finally84;
	__catch84_g_error:
	{
		GError* err = NULL;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 794 "rygel-main.c"
	}
	__finally84:
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_free0 (iface);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 807 "rygel-main.c"
	}
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp14_ = iface;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp14_ == NULL) {
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = TRUE;
#line 815 "rygel-main.c"
	} else {
		const gchar* _tmp15_;
		GUPnPContext* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = iface;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = context;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = _tmp17_;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = g_strcmp0 (_tmp15_, _tmp18_) == 0;
#line 831 "rygel-main.c"
	}
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp19_ = _tmp13_;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp19_) {
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = TRUE;
#line 839 "rygel-main.c"
	} else {
		const gchar* _tmp20_;
		GUPnPContext* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp20_ = iface;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp21_ = context;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp22_ = gssdp_client_get_network ((GSSDPClient*) _tmp21_);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = _tmp22_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = g_strcmp0 (_tmp20_, _tmp23_) == 0;
#line 855 "rygel-main.c"
	}
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp24_ = _tmp12_;
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp24_) {
#line 861 "rygel-main.c"
		{
			GUPnPContext* _tmp25_;
			RygelRootDeviceFactory* _tmp26_;
			RygelRootDeviceFactory* factory;
			GeeArrayList* _tmp27_;
			RygelRootDeviceFactory* _tmp28_;
			RygelPluginLoader* _tmp29_;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_;
			GeeIterator* iterator;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp25_ = context;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp26_ = rygel_root_device_factory_new (_tmp25_, &_inner_error_);
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			factory = _tmp26_;
#line 141 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_inner_error_ != NULL) {
#line 882 "rygel-main.c"
				goto __catch85_g_error;
			}
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp27_ = self->priv->factories;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp28_ = factory;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp29_ = self->priv->plugin_loader;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp30_ = rygel_plugin_loader_list_plugins (_tmp29_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp31_ = _tmp30_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp33_ = _tmp32_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (_tmp31_);
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			iterator = _tmp33_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			while (TRUE) {
#line 907 "rygel-main.c"
				GeeIterator* _tmp34_;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_;
				gpointer _tmp37_ = NULL;
				RygelPlugin* _tmp38_;
				RygelRootDeviceFactory* _tmp39_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp34_ = iterator;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp35_ = gee_iterator_next (_tmp34_);
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				if (!_tmp35_) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
					break;
#line 922 "rygel-main.c"
				}
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp36_ = iterator;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp37_ = gee_iterator_get (_tmp36_);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp38_ = (RygelPlugin*) _tmp37_;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp39_ = factory;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_tmp38_);
#line 936 "rygel-main.c"
			}
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (iterator);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_rygel_root_device_factory_unref0 (factory);
#line 942 "rygel-main.c"
		}
		goto __finally85;
		__catch85_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp40_ = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			err = _inner_error_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_inner_error_ = NULL;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp40_ = _ ("Failed to create root device factory: %s");
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp41_ = err;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp42_ = _tmp41_->message;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_warning (_tmp40_, _tmp42_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (err);
#line 965 "rygel-main.c"
		}
		__finally85:
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_free0 (iface);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_clear_error (&_inner_error_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			return;
#line 978 "rygel-main.c"
		}
	} else {
		GUPnPContext* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		GUPnPContext* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp43_ = context;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp44_ = gssdp_client_get_network ((GSSDPClient*) _tmp43_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp45_ = _tmp44_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp46_ = context;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp47_ = gssdp_client_get_interface ((GSSDPClient*) _tmp46_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp48_ = _tmp47_;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_debug ("rygel-main.vala:153: Ignoring network %s (%s) context.", _tmp45_, _tmp48_);
#line 1001 "rygel-main.c"
	}
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_free0 (iface);
#line 1005 "rygel-main.c"
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GUPnPContext* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GUPnPContext* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* factory_iter;
	GeeArrayList* _tmp20_;
	GeeIterator* _tmp21_ = NULL;
	GeeIterator* device_iter;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:161: Network %s (%s) context now unavailable. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = self->priv->factories;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	factory_iter = _tmp10_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1059 "rygel-main.c"
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GUPnPContext* _tmp13_;
		GeeIterator* _tmp14_;
		gpointer _tmp15_ = NULL;
		RygelRootDeviceFactory* _tmp16_;
		GUPnPContext* _tmp17_;
		gboolean _tmp18_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = factory_iter;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = gee_iterator_next (_tmp11_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp12_) {
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1076 "rygel-main.c"
		}
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = context;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = factory_iter;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = gee_iterator_get (_tmp14_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = (RygelRootDeviceFactory*) _tmp15_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = _tmp16_->context;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = _tmp13_ == _tmp17_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_rygel_root_device_factory_unref0 (_tmp16_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp18_) {
#line 1094 "rygel-main.c"
			GeeIterator* _tmp19_;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp19_ = factory_iter;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp19_);
#line 1100 "rygel-main.c"
		}
	}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp20_ = self->priv->root_devices;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp21_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp20_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	device_iter = _tmp21_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1111 "rygel-main.c"
		GeeIterator* _tmp22_;
		gboolean _tmp23_ = FALSE;
		GUPnPContext* _tmp24_;
		GeeIterator* _tmp25_;
		gpointer _tmp26_ = NULL;
		RygelRootDevice* _tmp27_;
		GUPnPContext* _tmp28_;
		GUPnPContext* _tmp29_;
		gboolean _tmp30_;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp22_ = device_iter;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = gee_iterator_next (_tmp22_);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp23_) {
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1129 "rygel-main.c"
		}
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp24_ = context;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp25_ = device_iter;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp26_ = gee_iterator_get (_tmp25_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp27_ = (RygelRootDevice*) _tmp26_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp28_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp27_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp29_ = _tmp28_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp30_ = _tmp24_ == _tmp29_;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp27_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp30_) {
#line 1149 "rygel-main.c"
			GeeIterator* _tmp31_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp31_ = device_iter;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp31_);
#line 1155 "rygel-main.c"
		}
	}
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (device_iter);
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (factory_iter);
#line 1162 "rygel-main.c"
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->plugin);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_rygel_root_device_factory_unref0 (_data_->factory);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->self);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_slice_free (RygelMainCreateDeviceData, _data_);
#line 1177 "rygel-main.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self ? g_object_ref (self) : NULL;
#line 1184 "rygel-main.c"
}


static gpointer _rygel_root_device_factory_ref0 (gpointer self) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self ? rygel_root_device_factory_ref (self) : NULL;
#line 1191 "rygel-main.c"
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelPlugin* _tmp2_;
	RygelRootDeviceFactory* _tmp3_;
	RygelRootDeviceFactory* _tmp4_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->self = _tmp0_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = plugin;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->plugin = _tmp2_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = factory;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _rygel_root_device_factory_ref0 (_tmp3_);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->factory = _tmp4_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_create_device_co (_data_);
#line 1226 "rygel-main.c"
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1234 "rygel-main.c"
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1243 "rygel-main.c"
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_active_notify (self, _sender, pspec);
#line 1250 "rygel-main.c"
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	switch (_data_->_state_) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 0:
#line 1259 "rygel-main.c"
		goto _state_0;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 1:
#line 1263 "rygel-main.c"
		goto _state_1;
		default:
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_assert_not_reached ();
#line 1268 "rygel-main.c"
	}
	_state_0:
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_state_ = 1;
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1277 "rygel-main.c"
	_state_1:
	;
	{
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp0_ = _data_->factory;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp1_ = _data_->plugin;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = NULL;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = rygel_root_device_factory_create (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->device = _data_->_tmp2_;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1293 "rygel-main.c"
			goto __catch86_g_error;
		}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp4_ = _data_->plugin;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp5_ = rygel_plugin_get_active (_data_->_tmp4_);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp6_) {
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp7_ = _data_->self->priv->config;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = FALSE;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = rygel_configuration_get_upnp_enabled (_data_->_tmp7_, &_data_->_inner_error_);
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_data_->_inner_error_ != NULL) {
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_data_->device);
#line 1316 "rygel-main.c"
				goto __catch86_g_error;
			}
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = _data_->_tmp9_;
#line 1321 "rygel-main.c"
		} else {
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = FALSE;
#line 1325 "rygel-main.c"
		}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp10_ = _data_->device;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp11_ = _data_->_tmp3_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->_tmp10_, _data_->_tmp11_);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp12_ = _data_->self->priv->root_devices;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp12_ != NULL) {
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp13_ = _data_->self->priv->root_devices;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp14_ = _data_->device;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp13_, _data_->_tmp14_);
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp15_ = _data_->plugin;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_signal_connect_object ((GObject*) _data_->_tmp15_, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
#line 1347 "rygel-main.c"
		}
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_data_->device);
#line 1351 "rygel-main.c"
	}
	goto __finally86;
	__catch86_g_error:
	{
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_inner_error_ = NULL;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = NULL;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = _ ("Failed to create RootDevice for %s. Reason: %s");
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp17_ = _data_->plugin;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp18_ = _data_->_tmp17_->name;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp19_ = _data_->_error_;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 207 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_data_->_tmp16_, _data_->_tmp18_, _data_->_tmp20_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_data_->_error_);
#line 1376 "rygel-main.c"
	}
	__finally86:
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_data_->_inner_error_ != NULL) {
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_data_->_inner_error_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return FALSE;
#line 1387 "rygel-main.c"
	}
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1393 "rygel-main.c"
	} else {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1397 "rygel-main.c"
	}
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1403 "rygel-main.c"
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp2_;
	RygelPlugin* _tmp3_;
	RygelPlugin* plugin;
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (obj != NULL);
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (spec != NULL);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->root_devices;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp1_) {
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 1427 "rygel-main.c"
	}
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = obj;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = _g_object_ref0 (RYGEL_IS_PLUGIN (_tmp2_) ? ((RygelPlugin*) _tmp2_) : NULL);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	plugin = _tmp3_;
#line 1435 "rygel-main.c"
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _device_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _device_size;
		gint _device_index;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = self->priv->root_devices;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_list = _tmp5_;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = _device_list;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = _tmp7_;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_size = _tmp8_;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_index = -1;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		while (TRUE) {
#line 1463 "rygel-main.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			RygelRootDevice* device;
			RygelRootDevice* _tmp15_;
			GUPnPResourceFactory* _tmp16_;
			GUPnPResourceFactory* _tmp17_;
			RygelPlugin* _tmp18_;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp9_ = _device_index;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_device_index = _tmp9_ + 1;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp10_ = _device_index;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp11_ = _device_size;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				break;
#line 1487 "rygel-main.c"
			}
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp12_ = _device_list;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp13_ = _device_index;
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			device = (RygelRootDevice*) _tmp14_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp15_ = device;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp16_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp15_);
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp17_ = _tmp16_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp18_ = plugin;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_tmp17_ == GUPNP_RESOURCE_FACTORY (_tmp18_)) {
#line 1507 "rygel-main.c"
				RygelRootDevice* _tmp19_;
				RygelPlugin* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp19_ = device;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp20_ = plugin;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp21_ = rygel_plugin_get_active (_tmp20_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp22_ = _tmp21_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp19_, _tmp22_);
#line 1522 "rygel-main.c"
			}
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (device);
#line 1526 "rygel-main.c"
		}
#line 221 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_device_list);
#line 1530 "rygel-main.c"
	}
#line 213 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (plugin);
#line 1534 "rygel-main.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = g_new0 (gchar*, length + 1);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	for (i = 0; i < length; i++) {
#line 1545 "rygel-main.c"
		gchar* _tmp0_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = g_strdup (self[i]);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result[i] = _tmp0_;
#line 1551 "rygel-main.c"
	}
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1555 "rygel-main.c"
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main;
	RygelDBusService* service;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** original_args;
	gint original_args_length1;
	gint _original_args_size_;
	RygelMain* _tmp8_;
	gint _tmp9_ = 0;
	gint exit_code;
	RygelDBusService* _tmp10_;
	RygelMain* _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	main = NULL;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	service = NULL;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = args;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0__length1 = args_length1;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1__length1 = _tmp0__length1;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = _tmp1_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args_length1 = _tmp1__length1;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_original_args_size_ = original_args_length1;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	setlocale (LC_ALL, "");
#line 235 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 237 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 238 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1603 "rygel-main.c"
	{
		RygelMain* _tmp2_;
		RygelMain* _tmp3_;
		RygelMain* _tmp4_;
		RygelDBusService* _tmp5_;
		RygelDBusService* _tmp6_;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1616 "rygel-main.c"
				goto __catch87_rygel_cmdline_config_error_version_only;
			}
			goto __catch87_g_error;
		}
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = rygel_main_new (&_inner_error_);
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = _tmp2_;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_inner_error_ != NULL) {
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1629 "rygel-main.c"
				goto __catch87_rygel_cmdline_config_error_version_only;
			}
			goto __catch87_g_error;
		}
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		main = _tmp3_;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = main;
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = rygel_dbus_service_new (_tmp4_);
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 245 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		service = _tmp5_;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = service;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_publish (_tmp6_);
#line 1650 "rygel-main.c"
	}
	goto __finally87;
	__catch87_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result = 0;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return result;
#line 1672 "rygel-main.c"
	}
	goto __finally87;
	__catch87_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = err->message;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_error ("rygel-main.vala:250: %s", _tmp7_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 1689 "rygel-main.c"
	}
	__finally87:
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_inner_error_ != NULL) {
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return 0;
#line 1706 "rygel-main.c"
	}
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = main;
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = rygel_main_run (_tmp8_);
#line 253 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	exit_code = _tmp9_;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = service;
#line 254 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp10_ != NULL) {
#line 1718 "rygel-main.c"
		RygelDBusService* _tmp11_;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = service;
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_unpublish (_tmp11_);
#line 1724 "rygel-main.c"
	}
#line 258 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp12_ = main;
#line 258 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp13_ = _tmp12_->need_restart;
#line 258 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp13_) {
#line 1732 "rygel-main.c"
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = original_args;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14__length1 = original_args_length1;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = _tmp14_[0];
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = original_args;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16__length1 = original_args_length1;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		execvp (_tmp15_, _tmp16_);
#line 1750 "rygel-main.c"
	}
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = exit_code;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (service);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (main);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1762 "rygel-main.c"
}


int main (int argc, char ** argv) {
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_type_init ();
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_main (argv, argc);
#line 1771 "rygel-main.c"
}


static void rygel_main_class_init (RygelMainClass * klass) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
#line 1782 "rygel-main.c"
}


static void rygel_main_instance_init (RygelMain * self) {
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
#line 1789 "rygel-main.c"
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = RYGEL_MAIN (obj);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 32 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 33 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 27 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
#line 1813 "rygel-main.c"
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



