/* rygel-media-export-harvester.c generated by valac 0.14.1, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block3Data Block3Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	GCancellable* cancellable;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
struct _Block3Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GQuark rygel_media_export_media_cache_error_quark (void);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean __lambda0_ (Block3Data* _data3_);
static gboolean ___lambda0__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self ? g_object_ref (self) : NULL;
#line 192 "rygel-media-export-harvester.c"
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
#line 199 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaExportMetadataExtractor* _tmp2_;
	GCancellable* _tmp3_;
	RygelMediaExportRecursiveFileMonitor* _tmp4_;
	RygelMediaExportRecursiveFileMonitor* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GeeHashMap* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GeeHashMap* _tmp11_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = cancellable;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->cancellable = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = rygel_media_export_metadata_extractor_new ();
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extractor);
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extractor = _tmp2_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = cancellable;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = rygel_media_export_recursive_file_monitor_new (_tmp3_);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->monitor = _tmp4_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = self->priv->monitor;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = g_file_hash;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_equal;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp6_, _tmp7_, NULL);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->tasks = _tmp8_;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = g_file_hash;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = g_file_equal;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, _tmp9_, _tmp10_, NULL);
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extraction_grace_timers = _tmp11_;
#line 51 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_create_file_filter (self);
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self;
#line 271 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable) {
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable);
#line 278 "rygel-media-export-harvester.c"
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     * @param flag optional flag for the container to set in the database
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_harvested (self, _sender);
#line 292 "rygel-media-export-harvester.c"
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	RygelMediaExportMetadataExtractor* _tmp2_;
	GFile* _tmp4_;
	RygelMediaExportMetadataExtractor* _tmp5_;
	RygelMediaExportRecursiveFileMonitor* _tmp6_;
	GRegex* _tmp7_;
	GFile* _tmp8_;
	RygelMediaContainer* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaExportHarvestingTask* _tmp11_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp12_;
	GCancellable* _tmp13_;
	RygelMediaExportHarvestingTask* _tmp14_;
	GeeHashMap* _tmp15_;
	GFile* _tmp16_;
	RygelMediaExportHarvestingTask* _tmp17_;
	RygelMediaExportHarvestingTask* _tmp18_;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->extraction_grace_timers;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 64 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = self->priv->extractor;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_ == NULL) {
#line 332 "rygel-media-export-harvester.c"
		const gchar* _tmp3_ = NULL;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = _ ("No metadata extractor available. Will not crawl.");
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning ("rygel-media-export-harvester.vala:66: %s", _tmp3_);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 340 "rygel-media-export-harvester.c"
	}
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = file;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp4_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = self->priv->extractor;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = self->priv->monitor;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = self->priv->file_filter;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = file;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = parent;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = flag;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = rygel_media_export_harvesting_task_new (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp11_;
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = task;
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = self->priv->cancellable;
#line 80 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _tmp12_, _tmp13_);
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp14_ = task;
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object ((RygelStateMachine*) _tmp14_, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp15_ = self->priv->tasks;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16_ = file;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp17_ = task;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, _tmp17_);
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp18_ = task;
#line 83 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp18_, NULL, NULL);
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 386 "rygel-media-export-harvester.c"
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->tasks;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_) {
#line 411 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp3_;
		GFile* _tmp4_;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* task;
		RygelMediaExportHarvestingTask* _tmp6_;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_;
		GFile* _tmp9_;
		RygelMediaExportHarvestingTask* _tmp10_;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = self->priv->tasks;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 93 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = task;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = self->priv->tasks;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = file;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = task;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvesting_task_cancel (_tmp10_);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (task);
#line 447 "rygel-media-export-harvester.c"
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* _tmp1_;
	RygelMediaExportHarvestingTask* task;
	RygelMediaExportHarvestingTask* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GeeHashMap* _tmp9_;
	GFile* _tmp10_;
	GeeHashMap* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (state_machine != NULL);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = state_machine;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK (_tmp0_) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp1_;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = task;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_->origin;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	file = _tmp4_;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = _ ("'%s' harvested");
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = file;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_get_uri (_tmp6_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = _tmp7_;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_message (_tmp5_, _tmp8_);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp8_);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = self->priv->tasks;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = file;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = self->priv->tasks;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = gee_abstract_map_get_is_empty ((GeeAbstractMap*) _tmp11_);
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = _tmp12_;
#line 112 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp13_) {
#line 113 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_emit_by_name (self, "done");
#line 521 "rygel-media-export-harvester.c"
	}
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (file);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 527 "rygel-media-export-harvester.c"
}


/**
     * Construct positive filter from config
     *
     * Takes a list of file extensions from config, escapes them and builds a
     * regular expression to match against the files encountered.
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if ((*length) == (*size)) {
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 544 "rygel-media-export-harvester.c"
	}
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(*array)[(*length)++] = value;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(*array)[*length] = NULL;
#line 550 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_create_file_filter (RygelMediaExportHarvester* self) {
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 558 "rygel-media-export-harvester.c"
	{
		RygelMetaConfig* _tmp0_ = NULL;
		RygelMetaConfig* config;
		RygelMetaConfig* _tmp1_;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* extensions;
		gchar** _tmp3_ = NULL;
		gchar** escaped_extensions;
		gint escaped_extensions_length1;
		gint _escaped_extensions_size_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_ = NULL;
		gchar* list;
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GRegex* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = rygel_meta_config_get_default ();
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		config = _tmp0_;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = config;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp1_, "MediaExport", "include-filter", &_inner_error_);
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		extensions = _tmp2_;
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 126 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (config);
#line 593 "rygel-media-export-harvester.c"
			goto __catch42_g_error;
		}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = g_new0 (gchar*, 0 + 1);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		escaped_extensions = _tmp3_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		escaped_extensions_length1 = 0;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_escaped_extensions_size_ = escaped_extensions_length1;
#line 604 "rygel-media-export-harvester.c"
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			GeeArrayList* _extension_list;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _extension_size;
			gint _extension_index;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp4_ = extensions;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_extension_list = _tmp5_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp6_ = _extension_list;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = _tmp7_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_extension_size = _tmp8_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_extension_index = -1;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			while (TRUE) {
#line 632 "rygel-media-export-harvester.c"
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				gchar* extension;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp9_ = _extension_index;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_extension_index = _tmp9_ + 1;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp10_ = _extension_index;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp11_ = _extension_size;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (!(_tmp10_ < _tmp11_)) {
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					break;
#line 656 "rygel-media-export-harvester.c"
				}
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp12_ = _extension_list;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp13_ = _extension_index;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				extension = (gchar*) _tmp14_;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp15_ = escaped_extensions;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp15__length1 = escaped_extensions_length1;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp16_ = extension;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = g_regex_escape_string (_tmp16_, -1);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_vala_array_add1 (&escaped_extensions, &escaped_extensions_length1, &_escaped_extensions_size_, _tmp17_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (extension);
#line 678 "rygel-media-export-harvester.c"
			}
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (_extension_list);
#line 682 "rygel-media-export-harvester.c"
		}
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp18_ = escaped_extensions;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp18__length1 = escaped_extensions_length1;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp19_ = g_strjoinv ("|", _tmp18_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		list = _tmp19_;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp20_ = list;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp21_ = g_strdup_printf ("(%s)$", _tmp20_);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp22_ = _tmp21_;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp23_ = g_regex_new (_tmp22_, G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp24_ = _tmp23_;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp22_);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp25_ = _tmp24_;
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (list);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (extensions);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (config);
#line 716 "rygel-media-export-harvester.c"
			goto __catch42_g_error;
		}
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_regex_unref0 (self->priv->file_filter);
#line 136 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		self->priv->file_filter = _tmp25_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (list);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		escaped_extensions = (_vala_array_free (escaped_extensions, escaped_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (extensions);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (config);
#line 731 "rygel-media-export-harvester.c"
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* _error_ = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_regex_unref0 (self->priv->file_filter);
#line 141 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		self->priv->file_filter = NULL;
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 747 "rygel-media-export-harvester.c"
	}
	__finally42:
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 124 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 758 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 769 "rygel-media-export-harvester.c"
	{
		GFileMonitorEvent _tmp0_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = event;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		switch (_tmp0_) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CREATED:
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 780 "rygel-media-export-harvester.c"
			{
				GFile* _tmp1_;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp1_ = file;
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_changes_done (self, _tmp1_, &_inner_error_);
#line 152 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 789 "rygel-media-export-harvester.c"
					goto __catch43_g_error;
				}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 794 "rygel-media-export-harvester.c"
			}
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_DELETED:
#line 798 "rygel-media-export-harvester.c"
			{
				GFile* _tmp2_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp2_ = file;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_file_removed (self, _tmp2_, &_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 807 "rygel-media-export-harvester.c"
					goto __catch43_g_error;
				}
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 812 "rygel-media-export-harvester.c"
			}
			default:
			{
#line 158 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 818 "rygel-media-export-harvester.c"
			}
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* _error_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 832 "rygel-media-export-harvester.c"
	}
	__finally43:
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 843 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _tmp1_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_debug ("rygel-media-export-harvester.vala:164: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp2_);
#line 867 "rygel-media-export-harvester.c"
	{
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		RygelMediaExportMediaCache* cache;
		GFile* _tmp4_;
		GCancellable* _tmp5_;
		GFileType _tmp6_ = 0;
		GFileType type;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GFileType _tmp9_;
		gboolean _tmp11_;
		gboolean _tmp17_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		cache = _tmp3_;
#line 167 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 886 "rygel-media-export-harvester.c"
			goto __catch44_g_error;
		}
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->cancellable;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = g_file_query_file_type (_tmp4_, G_FILE_QUERY_INFO_NONE, _tmp5_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		type = _tmp6_;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = type;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp9_ == G_FILE_TYPE_DIRECTORY) {
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = TRUE;
#line 903 "rygel-media-export-harvester.c"
		} else {
			GRegex* _tmp10_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = self->priv->file_filter;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = _tmp10_ == NULL;
#line 910 "rygel-media-export-harvester.c"
		}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = _tmp8_;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp11_) {
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = TRUE;
#line 918 "rygel-media-export-harvester.c"
		} else {
			GRegex* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gboolean _tmp16_ = FALSE;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = self->priv->file_filter;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = file;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = g_file_get_uri (_tmp13_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = _tmp14_;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = g_regex_match (_tmp12_, _tmp15_, 0, NULL);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = _tmp16_;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (_tmp15_);
#line 939 "rygel-media-export-harvester.c"
		}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp17_ = _tmp7_;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp17_) {
#line 945 "rygel-media-export-harvester.c"
			gchar* id = NULL;
			{
				RygelMediaContainer* parent_container;
				GFile* _tmp18_;
				GFile* _tmp19_;
				GFile* current;
				GFile* _tmp34_;
				RygelMediaContainer* _tmp35_;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				parent_container = NULL;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = file;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				current = _tmp19_;
#line 962 "rygel-media-export-harvester.c"
				{
					gboolean _tmp20_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp20_ = TRUE;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					while (TRUE) {
#line 969 "rygel-media-export-harvester.c"
						gboolean _tmp21_;
						GFile* _tmp23_;
						GFile* _tmp24_ = NULL;
						GFile* parent;
						GFile* _tmp25_;
						gchar* _tmp26_ = NULL;
						RygelMediaExportMediaCache* _tmp27_;
						const gchar* _tmp28_;
						RygelMediaObject* _tmp29_ = NULL;
						RygelMediaObject* _tmp30_;
						RygelMediaContainer* _tmp31_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp21_ = _tmp20_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (!_tmp21_) {
#line 985 "rygel-media-export-harvester.c"
							RygelMediaContainer* _tmp22_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp22_ = parent_container;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							if (!(_tmp22_ == NULL)) {
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
								break;
#line 993 "rygel-media-export-harvester.c"
							}
						}
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp20_ = FALSE;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp23_ = current;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp24_ = g_file_get_parent (_tmp23_);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						parent = _tmp24_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp25_ = parent;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp26_ = rygel_media_export_media_cache_get_id (_tmp25_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_free0 (id);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						id = _tmp26_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp27_ = cache;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp28_ = id;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp29_ = rygel_media_export_media_cache_get_object (_tmp27_, _tmp28_, &_inner_error_);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp30_ = _tmp29_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (_inner_error_ != NULL) {
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent_container);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1030 "rygel-media-export-harvester.c"
								goto __catch45_rygel_media_export_database_error;
							}
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (parent_container);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_free0 (id);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (cache);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							g_clear_error (&_inner_error_);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							return;
#line 1049 "rygel-media-export-harvester.c"
						}
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_object_unref0 (parent_container);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						parent_container = RYGEL_IS_MEDIA_CONTAINER (_tmp30_) ? ((RygelMediaContainer*) _tmp30_) : NULL;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp31_ = parent_container;
#line 182 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (_tmp31_ == NULL) {
#line 1059 "rygel-media-export-harvester.c"
							GFile* _tmp32_;
							GFile* _tmp33_;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp32_ = parent;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_tmp33_ = _g_object_ref0 (_tmp32_);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (current);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							current = _tmp33_;
#line 1070 "rygel-media-export-harvester.c"
						}
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_g_object_unref0 (parent);
#line 1074 "rygel-media-export-harvester.c"
					}
				}
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp34_ = current;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp35_ = parent_container;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_schedule (self, _tmp34_, _tmp35_, NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (current);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent_container);
#line 1087 "rygel-media-export-harvester.c"
			}
			goto __finally45;
			__catch45_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_;
				GError* _tmp38_;
				const gchar* _tmp39_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_error_ = _inner_error_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_inner_error_ = NULL;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp36_ = _ ("Error fetching object '%s' from database: %s");
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp37_ = id;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp38_ = _error_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp39_ = _tmp38_->message;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				g_warning (_tmp36_, _tmp37_, _tmp39_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_error_free0 (_error_);
#line 1113 "rygel-media-export-harvester.c"
			}
			__finally45:
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (cache);
#line 1122 "rygel-media-export-harvester.c"
				goto __catch44_g_error;
			}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1127 "rygel-media-export-harvester.c"
		}
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 1131 "rygel-media-export-harvester.c"
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp40_ = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp40_ = _ ("Failed to access media cache: %s");
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp41_ = _error_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp42_ = _tmp41_->message;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp40_, _tmp42_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1154 "rygel-media-export-harvester.c"
	}
	__finally44:
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1165 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* cache;
	GeeHashMap* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	cache = _tmp0_;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1192 "rygel-media-export-harvester.c"
	}
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = self->priv->extraction_grace_timers;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp3_) {
#line 1202 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp4_;
		GFile* _tmp5_;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_;
		GFile* _tmp8_;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = self->priv->extraction_grace_timers;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = file;
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 202 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove (GPOINTER_TO_UINT (_tmp6_));
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = self->priv->extraction_grace_timers;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = file;
#line 203 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
#line 1222 "rygel-media-export-harvester.c"
	}
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp9_);
#line 1228 "rygel-media-export-harvester.c"
	{
		GFile* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* id;
		const gchar* _tmp12_;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaObject* object;
		RygelMediaContainer* _tmp14_;
		RygelMediaContainer* parent;
		RygelMediaContainer* _tmp27_;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = file;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		id = _tmp11_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = id;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = rygel_media_export_media_cache_get_object (cache, _tmp12_, &_inner_error_);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		object = _tmp13_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1255 "rygel-media-export-harvester.c"
			goto __catch46_g_error;
		}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (NULL) ? ((RygelMediaContainer*) NULL) : NULL);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		parent = _tmp14_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 1264 "rygel-media-export-harvester.c"
			RygelMediaObject* _tmp15_;
			RygelMediaObject* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaContainer* _tmp18_;
			RygelMediaObject* _tmp19_;
			RygelMediaContainer* _tmp20_;
			RygelMediaContainer* _tmp21_;
			gint _tmp22_;
			RygelMediaContainer* _tmp23_;
			gint _tmp24_;
			RygelMediaContainer* _tmp25_;
			RygelMediaObject* _tmp26_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = object;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp15_ != NULL)) {
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1283 "rygel-media-export-harvester.c"
			}
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = object;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp17_ = _tmp16_->parent;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (parent);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			parent = _tmp18_;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = object;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_export_media_cache_remove_object (cache, _tmp19_, &_inner_error_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_inner_error_ != NULL) {
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (object);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 1307 "rygel-media-export-harvester.c"
				goto __catch46_g_error;
			}
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp20_ = parent;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp20_ == NULL) {
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1316 "rygel-media-export-harvester.c"
			}
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_ = parent;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp22_ = _tmp21_->child_count;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_->child_count = _tmp22_ - 1;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp23_ = parent;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp24_ = _tmp23_->child_count;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp24_ != 0) {
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 1332 "rygel-media-export-harvester.c"
			}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp25_ = parent;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp26_ = _g_object_ref0 ((RygelMediaObject*) _tmp25_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (object);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			object = _tmp26_;
#line 1342 "rygel-media-export-harvester.c"
		}
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27_ = parent;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp27_ != NULL) {
#line 1348 "rygel-media-export-harvester.c"
			RygelMediaContainer* _tmp28_;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp28_ = parent;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_container_updated (_tmp28_);
#line 1354 "rygel-media-export-harvester.c"
		}
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (parent);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (object);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (id);
#line 1362 "rygel-media-export-harvester.c"
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp29_ = _ ("Error removing object from database: %s");
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp30_ = _error_;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp31_ = _tmp30_->message;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp29_, _tmp31_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1385 "rygel-media-export-harvester.c"
	}
	__finally46:
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_propagate_error (error, _inner_error_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1396 "rygel-media-export-harvester.c"
	}
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (cache);
#line 1400 "rygel-media-export-harvester.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return _data3_;
#line 1409 "rygel-media-export-harvester.c"
}


static void block3_data_unref (Block3Data* _data3_) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_data3_->self);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_data3_->file);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_slice_free (Block3Data, _data3_);
#line 1422 "rygel-media-export-harvester.c"
	}
}


static gboolean __lambda0_ (Block3Data* _data3_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	GFile* _tmp0_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = _data3_->self;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = _data3_->file;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = FALSE;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1441 "rygel-media-export-harvester.c"
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1450 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block3Data* _data3_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GeeHashMap* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GSourceFunc callback;
	void* callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GSourceFunc _tmp11_;
	void* _tmp11__target;
	GDestroyNotify _tmp11__target_destroy_notify;
	guint _tmp12_ = 0U;
	guint timeout;
	GeeHashMap* _tmp13_;
	GFile* _tmp14_;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->_ref_count_ = 1;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->self = g_object_ref (self);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_->file = _tmp1_;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = self->priv->extraction_grace_timers;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _data3_->file;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp4_) {
#line 1495 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp5_;
		GFile* _tmp6_;
		gpointer _tmp7_ = NULL;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->extraction_grace_timers;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = _data3_->file;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove (GPOINTER_TO_UINT (_tmp7_));
#line 1507 "rygel-media-export-harvester.c"
	} else {
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _data3_->file;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = g_file_get_uri (_tmp8_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = _tmp9_;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_debug ("rygel-media-export-harvester.vala:243: Starting grace timer for harves" \
"ting %s…", _tmp10_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp10_);
#line 1522 "rygel-media-export-harvester.c"
	}
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = ___lambda0__gsource_func;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = block3_data_ref (_data3_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = block3_data_unref;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = callback;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11__target = callback_target;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11__target_destroy_notify = callback_target_destroy_notify;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	timeout = _tmp12_;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = self->priv->extraction_grace_timers;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp14_ = _data3_->file;
#line 255 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, GUINT_TO_POINTER (timeout));
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	block3_data_unref (_data3_);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data3_ = NULL;
#line 1560 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1573 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
#line 1580 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = RYGEL_MEDIA_EXPORT_HARVESTER (obj);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extractor);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_regex_unref0 (self->priv->file_filter);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
#line 1602 "rygel-media-export-harvester.c"
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



