//proto_mpd.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft      - 2010
 *      Copyright (C) Warren Dukes <warren.dukes@gmail.com - 2003-2006
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_PROTO_MPD_H_
#define _RPLD_PROTO_MPD_H_

#define RPLD_PROTO_MPD_VERSION                    "0.12.1"

#define RPLD_PROTO_MPD_ACK_ERROR_DISCONNECT            -1
#define RPLD_PROTO_MPD_ACK_ERROR_NOT_LIST               1
#define RPLD_PROTO_MPD_ACK_ERROR_ARG                    2
#define RPLD_PROTO_MPD_ACK_ERROR_PASSWORD               3
#define RPLD_PROTO_MPD_ACK_ERROR_PERMISSION             4
#define RPLD_PROTO_MPD_ACK_ERROR_UNKNOWN                5

#define RPLD_PROTO_MPD_ACK_ERROR_NO_EXIST               50
#define RPLD_PROTO_MPD_ACK_ERROR_PLAYLIST_MAX           51
#define RPLD_PROTO_MPD_ACK_ERROR_SYSTEM                 52
#define RPLD_PROTO_MPD_ACK_ERROR_PLAYLIST_LOAD          53
#define RPLD_PROTO_MPD_ACK_ERROR_UPDATE_ALREADY         54
#define RPLD_PROTO_MPD_ACK_ERROR_PLAYER_SYNC            55
#define RPLD_PROTO_MPD_ACK_ERROR_EXIST                  56

struct rpld_proto_mpd_error {
 int error;
 int offset;
 char * cmd;
 char * msg;
};

int proto_mpd_client_set_proto(int id);
int proto_mpd_client_handle(int id);
int proto_mpd_pcmd(int id, struct roar_vio_calls * vio, struct rpld_proto_mpd_error * error, char * cmd, char * args);

#endif

//ll
