//plugincontainer.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2008-2012
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROARPLUGINCONTAINER_H_
#define _LIBROARPLUGINCONTAINER_H_

#include "libroar.h"

struct roar_plugincontainer;

#if 0
struct roar_plugincontainer * roar_plugincontainer_new(struct roar_dl_librarypara * default_para);
#endif
struct roar_plugincontainer * roar_plugincontainer_new_simple(const char * appname, const char * abiversion);

int roar_plugincontainer_ref(struct roar_plugincontainer * cont);
int roar_plugincontainer_unref(struct roar_plugincontainer * cont);

/*
 * stuff we still need:
 * object creation, load plugin, get plugin handle, setting search path.
 */

// plugin loading and unloading:
int roar_plugincontainer_load(struct roar_plugincontainer * cont, const char * name, struct roar_dl_librarypara * para);
#if 0
int roar_plugincontainer_unload(struct roar_plugincontainer * cont, const char * name);
int roar_plugincontainer_unload_lhandle(struct roar_plugincontainer * cont, struct roar_dl_lhandle * lhandle);
#endif

// appsched:
int                      roar_plugincontainer_appsched_trigger(struct roar_plugincontainer * cont, enum roar_dl_appsched_trigger trigger);

#endif

//ll
