///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
# include "rheolef/distributed.h"
# include "rheolef/array.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
    environment distributed(argc, argv);
    size_t n = 101;
    array<Float> x(n,0.0);
    size_t first = x.ownership().first_index();
    size_t last  = x.ownership().last_index();
    for (size_t i_global = 0; i_global < n; i_global++) {
    	if (i_global >= first && i_global < last) {
	    x.dis_entry (i_global) = 1000+i_global+0.5;
        }
    }
    dcout << x.dis_size() << endl
          << x            << endl;
}
