#ifndef _RHEOLEF_SCATTER_MESSAGE_H
#define _RHEOLEF_SCATTER_MESSAGE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// create distributed to sequential scatter context
// inspirated from petsc-2.0/vpscat.c: VecScatterCreate_PtoS(...)
//
#include "rheolef/compiler.h"
#ifdef _RHEOLEF_HAVE_MPI
namespace rheolef {


template<class Container>
class scatter_message {
public:
  typedef typename Container::size_type size_type;

// data:

  std::vector<size_type>         		starts;	  // n_proc+1
  std::vector<size_type>         		procs;	  // n_proc
  std::list<std::pair<size_type,mpi::request> > requests; // n_proc
  std::vector<size_type>         		indices;  // n_data
  
  Container             	values;                   // n_data
  std::vector<mpi::status>  	sstatus;                  // n_status
    
  std::vector<size_type>       	local_slots;              // n_local
  std::vector<size_type>       	local_slots_nonmatching;
  bool 		       	    	local_nonmatching_computed;// n_local_nonmatching
  size_type 		        local_n_nonmatching;
  bool                 	    	local_is_copy;
  size_type 		       	local_copy_start;
  size_type                 	local_copy_length;

// allocator:

  scatter_message() 
  : starts(),
    procs(), 
    requests(), 
    indices(), 
    values(), 
    sstatus(),
    local_slots(),
    local_slots_nonmatching(),
    local_nonmatching_computed(false),
    local_n_nonmatching(0),
    local_is_copy(false),
    local_copy_start(0),
    local_copy_length(0)
  {}
  void resize (size_type n_data, size_type nproc) {
	values.resize  (n_data);
	indices.resize (n_data);
	starts.resize  (nproc+1);
	procs.resize   (nproc);
  }
// accessors:

  size_type n_proc() const { return procs.size(); }
  size_type n_data() const { return indices.size(); }
  size_type n_status() const { return sstatus.size(); }
  size_type n_local() const { return local_slots.size(); }
  size_type n_local_nonmatching() const { return local_slots_nonmatching.size(); }
};

} // namespace rheolef
#endif // _RHEOLEF_HAVE_MPI
#endif // _RHEOLEF_SCATTER_MESSAGE_H
