#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
NPROC_MAX=${NPROC_MAX-"8"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

#
# check boundary mass forms
#
#TODO: for coord_sys in cartesian rz; do
for coord_sys in cartesian; do
  case $coord_sys in
    cartesian)  LD="2 3";;
    rz)         LD="2";;
  esac
  #TODO: LP="P1 P2"
  LP="P1"
  for d in $LD; do
    #echo "dimension $d"
    case $d in
      2) LG="left right top bottom"
         LW1="1 x y"
         LW2="1 x y x2 xy y2"
         input="carre-bamg-v2"
         ;;
      3) LG="left right top bottom front back"
         LW1="1 x y z"
         LW2="1 x y x2 xy y2 xz yz z2"
         input="cube-gmsh-v2"
         ;;
    esac
    for p in $LP; do
        #echo " polynom $p"
        case $p in
        "P1") LW=$LW1;;
        "P2") LW=$LW2;;
        esac
        for w in $LW; do
            #echo "  poid $w"
            for g in $LG; do
                #echo "   domaine $g"
	        if test $coord_sys = "rz"; then
		  opt="-rz"
		else
		  opt=""
		fi
                loop_mpirun "./form_mass_bdr_tst -app $p -weight $w $opt -I${GEODIR} $input $g >/dev/null 2>/dev/null"
                if test $? -ne 0; then status=1; fi
            done
        done
    done
  done
done

exit $status

