#ifndef _RHEO_NUMBERING_REP_H
#define _RHEO_NUMBERING_REP_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/reference_element.h"
#include "rheolef/geo_element.h"
#include "rheolef/point.h"

namespace rheolef { 
class numbering_rep {
public:
    typedef size_t size_type;
    virtual ~numbering_rep() { }
    virtual std::string name() const = 0;
    virtual size_type ndof (
              size_type  mesh_map_dimension,
        const size_type* mesh_n_geo,
        const size_type* mesh_n_element) const = 0;
    virtual size_type idof (
	const size_type*      mesh_n_geo,
	const size_type*      mesh_n_element,
	const geo_element&    K, 
	size_type             i_dof_local) const = 0;
    virtual void idof (
	const size_type*        mesh_n_geo,
	const size_type*        mesh_n_element,
	const geo_element&      K, 
	std::vector<size_type>& i_dof) const = 0;
    virtual bool is_continuous() const = 0;
    static numbering_rep* make_ptr (std::string name);
};
}// namespace rheolef
#endif // _RHEO_NUMBERING_REP_H

