#include "rheolef.h"
using namespace rheolef;
using namespace std;
size_t N;
Float f (const point& x) { return 1+(0.5/N)*(x[0]*(1-x[0])+x[1]*(1-x[1])+x[2]*(1-x[2])); }
Float g (const point& x) { return -0.5/N; }
int main(int argc, char**argv) {
  environment distributed(argc, argv);
  geo omega (argv[1]);
  N = omega.dimension();
  space Vh (omega, "P1");
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "grad_grad");
  a = a+m;
  field fh = interpolate(Vh, f);
  space Wh (omega["boundary"], "P1");
  field gh = interpolate(Wh, g);
  form mb (Wh, Vh, "mass");
  field uh(Vh);
  solver sa (a.uu);
  uh.u = sa.solve (m.uu*fh.u + m.ub*fh.b + mb.uu*gh.u + mb.ub*gh.b - a.ub*uh.b);
  dcout << uh;
}
