template <class T>
csr<T,sequential> neumann_laplace_assembly (const distributor& ext_ownership, const csr<T,sequential>& a, const vec<T,sequential>& b) {
  asr<T,sequential> A (ext_ownership, ext_ownership);
  typename csr<T,sequential>::const_iterator aptr = a.begin();
  size_t n = a.row_ownership().dis_size();
  for (size_t i = 0, n = a.nrow(); i < n; i++) {
    for (typename csr<T,sequential>::const_data_iterator ap = aptr[i]; ap < aptr[i+1]; ap++) {
      size_t   j   = (*ap).first;
      const T& val = (*ap).second;
      A.dis_entry (i, j) = val;
    }
    A.dis_entry (i, n) = b[i];
    A.dis_entry (n, i) = b[i];
  }
  A.dis_entry (n, n) = 0;
  csr<T,sequential> Abis (A);
  Abis.set_symmetry (true); // TODO: set also pattern_dim
  odiststream ods; ods.open ("A", "mm"); ods << Abis;
  return Abis;
}
#ifdef _RHEOLEF_HAVE_MPI
template <class T>
csr<T,distributed> neumann_laplace_assembly (const distributor& ext_ownership, const csr<T,distributed>& a, const vec<T,distributed>& b) {
  asr<T,distributed> A (ext_ownership, ext_ownership);
  size_t my_proc   = ext_ownership.comm().rank();
  size_t last_proc = ext_ownership.comm().size() - 1;
  warning_macro ("my_proc = " << my_proc << ", last="<<last_proc);
  typename csr<T,distributed>::const_iterator aptr = a.begin();
  size_t       dis_n = a.row_ownership().dis_size();
  size_t first_dis_i = a.row_ownership().first_index();
  size_t first_dis_j = a.col_ownership().first_index();
  for (size_t i = 0, n = a.nrow(); i < n; i++) {
    size_t dis_i = first_dis_i + i;
    for (typename csr<T,distributed>::const_data_iterator ap = aptr[i]; ap < aptr[i+1]; ap++) {
      size_t   j   = (*ap).first;
      const T& val = (*ap).second;
      size_t dis_j = first_dis_j + j;
      A.dis_entry (dis_i, dis_j) = val;
    }
    typename csr<T,distributed>::const_iterator ext_ia = a.ext_begin();
    for (typename csr<T,distributed>::const_data_iterator ap = ext_ia[i]; ap < ext_ia[i+1]; ap++) {
      size_t  jext = (*ap).first;
      const T& val = (*ap).second;
      size_t dis_j =  a.jext2dis_j (jext);
      A.dis_entry (dis_i, dis_j) = val;
    }
    A.dis_entry (dis_i, dis_n) = b[i];
    A.dis_entry (dis_n, dis_i) = b[i];
  }
  if (my_proc == last_proc) A.dis_entry (dis_n, dis_n) = 0;
  A.dis_entry_assembly();
  csr<T,distributed> Abis (A);
  Abis.set_symmetry (true); // TODO: set also pattern_dim
  odiststream ods; ods.open ("A", "mm"); ods << Abis;
  return Abis;
}
#endif // _RHEOLEF_HAVE_MPI
