//
//  Copyright (C) 2001-2006 Greg Landrum and Rational Discovery LLC
//
//   @@ All Rights Reserved @@
//  This file is part of the RDKit.
//  The contents are covered by the terms of the BSD license
//  which is included in the file license.txt, found at the root
//  of the RDKit source tree.
//

//  Automatically generated from elements.txt
#include "atomic_data.h"
#include <boost/tokenizer.hpp>
typedef boost::tokenizer<boost::char_separator<char> > tokenizer;

namespace RDKit {

const std::string periodicTableAtomData = 
"0	*	0	0	0	0	0	0	0	1	2	3	4	5	6	-1 \n \
1	H 	0.23	0.33	1.2	1.008	1	1	1.007825032	1 \n \
2	He	0.93	0.7	1.4	4.003	2	4	4.002603254	0  \n \
3	Li	0.68	1.23	1.82	6.941	1	7	7.01600455	1  \n \
4	Be	0.35	0.9	1.7	9.012	2	9	9.0121822	2  \n \
5	B	0.830	0.82	2.08	10.812	3	11	11.0093054	3  \n \
6	C	0.68	0.77	1.95	12.011	4	12	12	4 \n \
7	N	0.68	0.7	1.85	14.007	5	14	14.003074	3 \n \
8	O	0.68	0.66	1.7	15.999	6	16	15.99491462	2 \n \
9	F	0.64	0.611	1.73	18.998	7	19	18.99840322	1 \n \
10	Ne	1.12	0.7	1.54	20.18	8	20	19.99244018	0 \n \
11	Na	0.97	1.54	2.27	22.99	1	23	22.98976928	1 \n \
12	Mg	1.1	1.36	1.73	24.305	2	24	23.9850417	2 \n \
13	Al	1.35	1.18	2.05	26.982	3	27	26.98153863	6 \n \
14	Si	1.2	0.937	2.1	28.086	4	28	27.97692653	4	6 \n \
15	P	0.75	0.89	2.08	30.974	5	31	30.97376163	3	5 \n \
16	S	1.02	1.04	2	32.067	6	32	31.972071	2	4	6 \n \
17	Cl	0.99	0.997	1.97	35.453	7	35	34.96885268	1 \n \
18	Ar	1.57	1.74	1.88	39.948	8	40	39.96238312	0 \n \
19	K	1.33	2.03	2.75	39.098	1	39	38.96370668	1 \n \
20	Ca	0.99	1.74	1.973	40.078	2	40	39.96259098	2 \n"
"21	Sc	1.44	1.44	1.7	44.956	3	45	44.9559119	6	-1 \n \
22	Ti	1.47	1.32	1.7	47.867	4	48	47.9479463	6	-1 \n \
23	V	1.33	1.22	1.7	50.942	5	50	49.9471585	6	-1 \n \
24	Cr	1.35	1.18	1.7	51.996	6	52	51.9405075	6	-1 \n \
25	Mn	1.35	1.17	1.7	54.938	7	55	54.9380451	6	-1 \n \
26	Fe	1.34	1.17	1.7	55.845	8	56	55.9349375	6	-1 \n \
27	Co	1.33	1.16	1.7	58.933	9	59	58.933195	6	-1 \n \
28	Ni	1.5	1.15	1.63	58.693	10	58	57.9353429	6	-1 \n \
29	Cu	1.52	1.17	1.4	63.546	11	63	62.9295975	6	-1 \n \
30	Zn	1.45	1.25	1.39	65.39	2	64	63.9291422	6	-1 \n \
31	Ga	1.22	1.26	1.87	69.723	3	69	68.9255736	3	   \n \
32	Ge	1.17	1.188	1.7	72.61	4	74	73.9211778	4	   \n \
33	As	1.21	1.2	1.85	74.922	5	75	74.9215965	3	5 \n \
34	Se	1.22	1.17	1.9	78.96	6	80	79.9165213	2	4	6 \n \
35	Br	1.21	1.167	2.1	79.904	7	79	78.9183371	1 \n \
36	Kr	1.91	1.91	2.02	83.8	8	84	83.911507	0 \n \
37	Rb	1.47	2.16	1.7	85.468	1	85	84.91178974	1 \n \
38	Sr	1.12	1.91	1.7	87.62	2	88	87.9056121	2 \n \
39	Y	1.78	1.62	1.7	88.906	3	89	88.9058483	6	-1 \n \
40	Zr	1.56	1.45	1.7	91.224	4	90	89.9047044	6	-1 \n"
"41	Nb	1.48	1.34	1.7	92.906	5	93	92.9063781	6	-1 \n \
42	Mo	1.47	1.3	1.7	95.94	6	98	97.9054082	6	-1 \n \
43	Tc	1.35	1.27	1.7	98	7	97	96.906365	6	-1 \n \
44	Ru	1.4	1.25	1.7	101.07	8	102	101.9043493	6	-1 \n \
45	Rh	1.45	1.25	1.7	102.906	9	103	102.905504	6	-1 \n \
46	Pd	1.5	1.28	1.63	106.42	10	106	105.903486	6	-1 \n \
47	Ag	1.59	1.34	1.72	107.868	11	107	106.905097	6	-1 \n \
48	Cd	1.69	1.48	1.58	112.412	2	114	113.9033585	6	-1 \n \
49	In	1.63	1.44	1.93	114.818	3	115	114.903878	3 \n \
50	Sn	1.46	1.385	2.17	118.711	4	120	119.9021947	4 \n \
51	Sb	1.46	1.4	2.2	121.76	5	121	120.9038157	3	5 \n \
52	Te	1.47	1.378	2.06	127.6	6	130	129.9062244	2 \n \
53	I	1.4	1.387	2.15	126.904	7	127	126.904473	1	2	5 \n \
54	Xe	1.98	1.98	2.16	131.29	8	132	131.9041535	0 \n \
55	Cs	1.67	2.35	1.7	132.905	1	133	132.9054519	1 \n \
56	Ba	1.34	1.98	1.7	137.328	2	138	137.9052472	2 \n \
57	La	1.87	1.69	1.7	138.906	3	139	138.9063533	12	-1 \n \
58	Ce	1.83	1.83	1.7	140.116	4	140	139.9054387	6	-1 \n \
59	Pr	1.82	1.82	1.7	140.908	3	141	140.9076528	6	-1 \n \
60	Nd	1.81	1.81	1.7	144.24	4	142	141.9077233	6	-1 \n"
"61	Pm	1.8	1.8	1.7	145	5	145	144.912749	6	-1 \n \
62	Sm	1.8	1.8	1.7	150.36	6	152	151.9197324	6	-1 \n \
63	Eu	1.99	1.99	1.7	151.964	7	153	152.9212303	6	-1 \n \
64	Gd	1.79	1.79	1.7	157.25	8	158	157.9241039	6	-1 \n \
65	Tb	1.76	1.76	1.7	158.925	9	159	158.9253468	6	-1 \n \
66	Dy	1.75	1.75	1.7	162.5	10	164	163.9291748	6	-1 \n \
67	Ho	1.74	1.74	1.7	164.93	11	165	164.9303221	6	-1 \n \
68	Er	1.73	1.73	1.7	167.26	12	166	165.9302931	6	-1 \n \
69	Tm	1.72	1.72	1.7	168.934	13	169	168.9342133	6	-1 \n \
70	Yb	1.94	1.94	1.7	173.04	14	174	173.9388621	6	-1 \n \
71	Lu	1.72	1.72	1.7	174.967	15	175	174.9407718	6	-1 \n \
72	Hf	1.57	1.44	1.7	178.49	4	180	179.94655	6	-1 \n \
73	Ta	1.43	1.34	1.7	180.948	5	181	180.9479958	6	-1 \n \
74	W	1.37	1.3	1.7	183.84	6	184	183.9509312	6	-1 \n \
75	Re	1.35	1.28	1.7	186.207	7	187	186.9557531	6	-1 \n \
76	Os	1.37	1.26	1.7	190.23	8	192	191.9614807	6	-1 \n \
77	Ir	1.32	1.27	1.7	192.217	9	193	192.9629264	6	-1 \n \
78	Pt	1.5	1.3	1.72	195.078	10	195	194.9647911	6	-1 \n \
79	Au	1.5	1.34	1.66	196.967	11	197	196.9665687	6	-1 \n \
80	Hg	1.7	1.49	1.55	200.59	2	202	201.970643	6	-1 \n"
"81	Tl	1.55	1.48	1.96	204.383	3	205	204.9744275	3 \n \
82	Pb	1.54	1.48	2.02	207.2	4	208	207.9766521	4 \n \
83	Bi	1.54	1.45	1.7	208.98	5	209	208.9803987	3 \n \
84	Po	1.68	1.46	1.7	209	6	209	208.9824304	2 \n \
85	At	1.7	1.45	1.7	210	7	210	209.987148	1 \n \
86	Rn	2.4	2.4	1.7	222	8	211	210.990601	0 \n \
87	Fr	2	2	1.7	223	1	223	223.0197359	1 \n \
88	Ra	1.9	1.9	1.7	226	2	223	223.0185022	2 \n \
89	Ac	1.88	1.88	1.7	227	3	227	227.0277521	6	-1 \n \
90	Th	1.79	1.79	1.7	232.038	4	232	232.0380553	6	-1 \n \
91	Pa	1.61	1.61	1.7	231.036	3	231	231.035884	6	-1 \n \
92	U	1.58	1.58	1.86	238.029	4	238	238.0507882	6	-1 \n \
93	Np	1.55	1.55	1.7	237	5	236	236.04657	6	-1 \n \
94	Pu	1.53	1.53	1.7	244	6	238	238.0495599	6	-1 \n \
95	Am	1.51	1.07	1.7	243	7	241	241.0568291	6	-1 \n \
96	Cm	1.5	0	1.7	247	8	243	243.0613891	6	-1 \n \
97	Bk	1.5	0	1.7	247	9	247	247.070307	6	-1 \n \
98	Cf	1.5	0	1.7	251	10	249	249.0748535	6	-1 \n \
99	Es	1.5	0	1.7	252	11	252	252.08298	6	-1 \n \
100	Fm	1.5	0	1.7	257	12	257	257.095105	6	-1 \n"
"101	Md	1.5	0	1.7	258	13	258	258.098431	6	-1 \n \
102	No	1.5	0	1.7	259	14	259	259.10103	6	-1 \n \
103	Lr	1.5	0	1.7	262	15	262	262.10963	6	-1 \n \
104	Rf	1.5	0	1.7	261	4	265	265.1167	6	-1";

  atomicData::atomicData(const std::string &dataLine) {
    boost::char_separator<char> spaceSep(" \t");
    tokenizer tokens(dataLine,spaceSep);
    tokenizer::iterator token=tokens.begin();
    
    // atomic number first
    anum = atoi(token->c_str());
    ++token;
    
    // element symbol
    symb = *token;
    ++token;

    // covalent radius
    rCov = atof(token->c_str());
    ++token;
    
    // rB0
    rB0 = atof(token->c_str());
    ++token;
    
    //  Van derWaal radius
    rVdw = atof(token->c_str());
    ++token;
    
    // atomic mass
    mass = atof(token->c_str());
    ++token;

    // number of outshell electrons
    nVal = atoi(token->c_str());
    ++token;

    // most common isotope
    commonIsotope = atoi(token->c_str());
    ++token;

    // most common isotopic mass
    commonIsotopeMass = atof(token->c_str());
    ++token;
    
    // now the valences
    valence.clear();
    while (token != tokens.end()) {
      valence.push_back(atoi(token->c_str()));
      ++token;
    }
  }
}
      
