/*
    ras - Redundant Archive System
    Copyright (C) 1999  Nick Cleaton

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    Nick Cleaton <nick@cleaton.net>
*/

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "common.h"
#include "utils.h"
#include "segfname.h"


/****************************************************************************/

/* 
   Filenames for segment files: a static array initialised to default 
   values, some or all of which may be overwritten by command line
   options. 
 */
#define FILENAME_COUNT (26*10)
static char *segment_filenames[FILENAME_COUNT] = 
{
 "xaa","xab","xac","xad","xae","xaf","xag","xah","xai","xaj","xak","xal","xam",
 "xan","xao","xap","xaq","xar","xas","xat","xau","xav","xaw","xax","xay","xaz",
 "xba","xbb","xbc","xbd","xbe","xbf","xbg","xbh","xbi","xbj","xbk","xbl","xbm",
 "xbn","xbo","xbp","xbq","xbr","xbs","xbt","xbu","xbv","xbw","xbx","xby","xbz",
 "xca","xcb","xcc","xcd","xce","xcf","xcg","xch","xci","xcj","xck","xcl","xcm",
 "xcn","xco","xcp","xcq","xcr","xcs","xct","xcu","xcv","xcw","xcx","xcy","xcz",
 "xda","xdb","xdc","xdd","xde","xdf","xdg","xdh","xdi","xdj","xdk","xdl","xdm",
 "xdn","xdo","xdp","xdq","xdr","xds","xdt","xdu","xdv","xdw","xdx","xdy","xdz",
 "xea","xeb","xec","xed","xee","xef","xeg","xeh","xei","xej","xek","xel","xem",
 "xen","xeo","xep","xeq","xer","xes","xet","xeu","xev","xew","xex","xey","xez",
 "xfa","xfb","xfc","xfd","xfe","xff","xfg","xfh","xfi","xfj","xfk","xfl","xfm",
 "xfn","xfo","xfp","xfq","xfr","xfs","xft","xfu","xfv","xfw","xfx","xfy","xfz",
 "xga","xgb","xgc","xgd","xge","xgf","xgg","xgh","xgi","xgj","xgk","xgl","xgm",
 "xgn","xgo","xgp","xgq","xgr","xgs","xgt","xgu","xgv","xgw","xgx","xgy","xgz",
 "xha","xhb","xhc","xhd","xhe","xhf","xhg","xhh","xhi","xhj","xhk","xhl","xhm",
 "xhn","xho","xhp","xhq","xhr","xhs","xht","xhu","xhv","xhw","xhx","xhy","xhz",
 "xia","xib","xic","xid","xie","xif","xig","xih","xii","xij","xik","xil","xim",
 "xin","xio","xip","xiq","xir","xis","xit","xiu","xiv","xiw","xix","xiy","xiz",
 "xja","xjb","xjc","xjd","xje","xjf","xjg","xjh","xji","xjj","xjk","xjl","xjm",
 "xjn","xjo","xjp","xjq","xjr","xjs","xjt","xju","xjv","xjw","xjx","xjy","xjz",
};

static int segment_filename_offset =0;

/****************************************************************************/

char *get_segment_filename(int n)
{
   myassert(n>=0 && n<FILENAME_COUNT, "get_segment_filename: n out of bounds");
   
   return segment_filenames[n];
}

/****************************************************************************/

void change_segment_filenames(char *arg)
/*  called from options.c to handle -f option  */
{
   if( segment_filename_offset >= FILENAME_COUNT )
   {  fprintf(stderr,PROGNAME ": too many segment filenames specified\n");
      exit_because_of_error(INVALID_INPUT);
   }

   if( !arg || strlen(arg) == 0 )
   {  fprintf(stderr,PROGNAME ": null segment filename specified\n");
      exit_because_of_error(INVALID_INPUT);
   }

   segment_filenames[segment_filename_offset++] = arg;
}

/**************************************************************************/   

