/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_time.c,v 1.17.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_time) = {
	"m_time",
	"/TIME command",
	6, "$Revision: 1.17.2.2 $"
};

int MOD_LOAD(m_time)()
{
	if (register_command(&MOD_HEADER(m_time), &CMD_TIME, m_time) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_time)()
{
	return MOD_SUCCESS;
}

/*
 * m_time
 *	parv[0] = sender prefix
 *	parv[1] = server mask to query
 */
int m_time(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (use_or_deliver(cptr, sptr, &CMD_TIME, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	send_me_numeric(sptr, RPL_TIME, me.name, date((long)0));
	return 0;
}
