/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_svshold.c,v 1.3.2.2 2005/01/15 23:53:29 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_svshold) = {
	"m_svshold",
	"/SVSHOLD command",
	6, "$Revision: 1.3.2.2 $"
};

int MOD_LOAD(m_svshold)()
{
	if (register_command(&MOD_HEADER(m_svshold), &CMD_SVSHOLD, m_svshold) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_svshold)()
{
	return MOD_SUCCESS;
}

/*
 * m_svshold
 *	parv[0] = sender prefix
 *	parv[1] = nick
 *	parv[2] = duration (or 0 to remove)
 *	parv[3] = optional reason
 */
int m_svshold(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	simBan *myban, *sban;
	char *mask, *reason;
	int duration;

        if (!IsULine(sptr) || (parc < 3)) {
                return 0;
        }

	mask = parv[1];
	duration = strtol(parv[2], NULL, 0);
	reason = (parc > 3 && !BadPtr(parv[3])) ? parv[3] : "Nickname is reserved, please try later";

	if ((myban = make_simban(mask, reason, duration, SBAN_NICK|BAN_LOCAL|BAN_TEMPORARY)) == NULL) {
		ircdlog(LOG_ERROR, "make_simban(%s,%s,%d,0) failed in SVSHOLD", mask, reason, duration);
		return 0;
	}

	if ((sban = find_simban_exact(myban)) != NULL) {
		simban_free(myban);
		myban = NULL;

		if (duration <= 0) {
			del_simban(sban);
			simban_free(sban);
		}
		else {
			if (!BadPtr(sban->reason)) {
				MyFree(sban->reason);
			}
			DupString(sban->reason, reason);

			sban->timeset = timeofday;
			sban->duration = duration;
		}
	}
	else if (duration > 0) {
		add_simban(myban);
	}
	else {
		simban_free(myban);
	}

	if (parc > 3) {
		sendto_serv_msg_butone(cptr, sptr, &CMD_SVSHOLD, "%s %s :%s", parv[1], parv[2], parv[3]);
	}
	else {
		sendto_serv_msg_butone(cptr, sptr, &CMD_SVSHOLD, "%s %s", parv[1], parv[2]);
	}

	return 0;
}
