/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_sajoin.c,v 1.34.2.2 2005/01/15 23:53:30 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "hook.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

extern chanMember *add_user_to_channel(aChannel *, aClient *, int);

Hook *hp_post_join;

Module MOD_HEADER(m_sajoin) = {
	"m_sajoin",
	"/SAJOIN command",
	6, "$Revision: 1.34.2.2 $"
};

int MOD_LOAD(m_sajoin)()
{
	if ((hp_post_join = hook_find("h_post_join")) == NULL) {
		ircdlog(LOG_ERROR, "m_sajoin.so: couldn't find hook h_post_join");
		return MOD_FAILURE;
	}

	if (register_command(&MOD_HEADER(m_sajoin), &CMD_SAJOIN, m_sajoin) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_sajoin)()
{
	return MOD_SUCCESS;
}

/*
 * m_sajoin
 *	parv[0] = sender prefix
 *	parv[1] = channel
 */
int m_sajoin(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;
	char *p;

	if (!HasMode(sptr, UMODE_SADMIN)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SAJOIN");
		return 0;
	}
	if ((p = strchr(parv[1], ',')) != NULL) {
		*p = '\0';
	}
	if ((chptr = find_channel(parv[1], NULL)) == NULL) {
		if (!MyClient(sptr)) {
			sendto_realops_lev(DEBUG_LEV, "DESYNCH: client %s!%s@%s has SAJOIN'ed nonexistant "
				"channel %s", sptr->name, sptr->username, MaskedHost(sptr), parv[1]);
			ircdlog(LOG_ERROR, "DESYNCH: client %s has SAJOIN'ed nonexistant channel %s",
				get_client_name(sptr, FALSE), parv[1]);
		}
		else {
			send_me_numeric(sptr, ERR_NOSUCHCHANNEL, parv[1]);
		}
		return 0;
	}
	if (IsMember(sptr, chptr)) {
		return 0;
	}

	sendto_realops("%s used SAJOIN %s", sptr->name, chptr->chname);
	sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":%s used SAJOIN %s", sptr->name,
		chptr->chname);
	ircdlog(LOG_OVERRIDE, "%s used SAJOIN %s", get_client_name(sptr, FALSE), chptr->chname);

	add_user_to_channel(chptr, sptr, 0);
	sendto_serv_msg_butone(cptr, sptr, &CMD_SJOIN, "%ld %s", chptr->channelts, chptr->chname);
	sendto_channel_local_msg_butone(NULL, sptr, chptr, ALL_MEMBERS, &CMD_JOIN,
		"%s", chptr->chname);

	if (MyClient(sptr)) {
		HookData hdata = HOOKDATA_INIT;

		if (*chptr->topic != '\0') {
			send_me_numeric(sptr, RPL_TOPIC, chptr->chname, chptr->topic);
			send_me_numeric(sptr, RPL_TOPICWHOTIME, chptr->chname, chptr->topic_nick,
				chptr->topic_time);
		}

		hdata.cptr = cptr;
		hdata.sptr = sptr;
		hdata.chptr = chptr;
		hook_run(hp_post_join, &hdata);
	}
	return 0;
}
