/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_names.c,v 1.33.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "hook.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

static int send_channel_names(HookData *);

Module MOD_HEADER(m_names) = {
	"m_names",
	"/NAMES command",
	6, "$Revision: 1.33.2.2 $"
};

int MOD_LOAD(m_names)()
{
	Hook *hook;

	if ((hook = hook_find("h_post_join")) == NULL) {
		ircdlog(LOG_ERROR, "m_names.so: couldn't find hook h_post_join");
		return MOD_FAILURE;
	}

	if (register_hook_event(&MOD_HEADER(m_names), hook, send_channel_names) == NULL) {
		return MOD_FAILURE;
	}
	if (register_command(&MOD_HEADER(m_names), &CMD_NAMES, m_names) == NULL) {
		return MOD_FAILURE;
	}

	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_names)()
{
	return MOD_SUCCESS;
}

static void send_names(aClient *cptr, aChannel *chptr)
{
	int len = 0, mlen = (strlen(me.name) + NICKLEN + 7);
	int prefix_len, member = (IsMember(cptr, chptr) ? 1 : 0);
	chanMember *cm;
	aClient *acptr;
	char *s, buf[BUFSIZE];

	if (PubChannel(chptr)) {
		buf[len++] = '=';
	}
	else if (SecretChannel(chptr)) {
		buf[len++] = '@';
	}
	else {
		buf[len++] = '*';
	}
	buf[len++] = ' ';

	s = chptr->chname;
	while (*s != '\0') {
		buf[len++] = *s++;
	}

	buf[len++] = ' ';
	buf[len++] = ':';
	buf[len] = '\0';

	prefix_len = len;

	for (cm = chptr->members; cm != NULL; cm = cm->nextuser) {
		acptr = cm->cptr;

		if (HasMode(acptr, UMODE_INVISIBLE) && !member) {
			continue;
		}

		if (cm->flags & CMODE_CHANOP) {
			buf[len++] = '@';
		}
		else if (cm->flags & CMODE_HALFOP) {
			buf[len++] = '%';
		}
		else if (cm->flags & CMODE_VOICE) {
			buf[len++] = '+';
		}

		s = acptr->name;

		while (*s != '\0') {
			buf[len++] = *s++;
		}
		buf[len++] = ' ';
		buf[len] = '\0';

		if (mlen + len + NICKLEN > BUFSIZE - 3) {
			if (buf[len - 1] == ' ') {
				buf[--len] = '\0';
			}
			send_me_numeric(cptr, RPL_NAMREPLY, buf);
			len = prefix_len;
		}
	}

	if (len > prefix_len) {
		if (buf[len - 1] == ' ') {
			buf[--len] = '\0';
		}
		send_me_numeric(cptr, RPL_NAMREPLY, buf);
	}

	send_me_numeric(cptr, RPL_ENDOFNAMES, chptr->chname);
}

static int send_channel_names(HookData *hdata)
{
	send_names(hdata->sptr, hdata->chptr);
	return 0;
}

/*
 * m_names
 *	parv[0] = sender prefix
 *	parv[1] = channel
 */
int m_names(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;
	char *p;

	if (parc < 2 || BadPtr(parv[1]) || !MyConnect(sptr)) {
		send_me_numeric(sptr, RPL_ENDOFNAMES, "*");
		return 0;
	}

	if ((p = strchr(parv[1], ',')) != NULL) {
		*p = '\0';
	}

	if (!check_channel_name(sptr, parv[1])) {
		send_me_numeric(sptr, ERR_BADCHANNAME, parv[1]);
		return 0;
	}
	if ((chptr = find_channel(parv[1], NULL)) == NULL || !ShowChannel(sptr, chptr)) {
		send_me_numeric(sptr, RPL_ENDOFNAMES, parv[1]);
		return 0;
	}

	send_names(sptr, chptr);
	return 0;
}
