/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_error.c,v 1.18.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_error) = {
	"m_error",
	"ERROR protocol",
	6, "$Revision: 1.18.2.2 $"
};

int MOD_LOAD(m_error)()
{
	if (register_command(&MOD_HEADER(m_error), &CMD_ERROR, m_error) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_error)()
{
	return MOD_SUCCESS;
}

/*
 * m_error
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_error(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *para = NULL, *path = get_client_name(cptr, HIDE_IP);

	if (IsPerson(cptr) || IsUnknown(cptr)) {
		return 0;
	}

	para = (parc > 1 && *parv[1] != '\0') ? parv[1] : "<>";
	Debug((DEBUG_ERROR, "Received ERROR message from %s: %s", sptr->name, para));

	if (cptr == sptr) {
		send_gnotice("ERROR from %s: %s", path, para);
		sendto_serv_msg_butone(cptr, &me, &CMD_GNOTICE, ":ERROR from %s: %s", path, para);
	}
	else {
		send_gnotice("ERROR from %s via %s: %s", sptr->name, path, para);
		sendto_serv_msg_butone(cptr, &me, &CMD_GNOTICE, ":ERROR from %s via %s: %s",
			sptr->name, path, para);
	}

	return 0;
}
