/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_chatops.c,v 1.22.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_chatops) = {
	"m_chatops",
	"/CHATOPS command",
	6, "$Revision: 1.22.2.2 $"
};

int MOD_LOAD(m_chatops)()
{
	if (register_command(&MOD_HEADER(m_chatops), &CMD_CHATOPS, m_chatops) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_chatops)()
{
	return MOD_SUCCESS;
}

/*
 * m_chatops
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_chatops(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (MyClient(sptr) && !HasMode(sptr, UMODE_CHATOPS) && !IsULine(sptr)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2 || *parv[1] == '\0') {
		if (MyClient(sptr)) {
			send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "CHATOPS");
		}
		return 0;
	}
	if (strlen(parv[1]) > TOPICLEN) {
		parv[1][TOPICLEN] = '\0';
	}
	sendto_serv_msg_butone(cptr, sptr, &CMD_CHATOPS, ":%s", parv[1]);
	send_chatops("from %s: %s", parv[0], parv[1]);
	return 0;
}
