/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: antidrone.c,v 1.19.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "hook.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

static int anti_drone(HookData *);

Module MOD_HEADER(antidrone) = {
	"antidrone",
	"drone protection",
	6, "$Revision: 1.19.2.2 $"
};

int MOD_LOAD(antidrone)()
{
	if (register_hook_event(&MOD_HEADER(antidrone), h_register_user_local, anti_drone) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(antidrone)()
{
	return MOD_SUCCESS;
}

static void block_drone(aClient *cptr, aClient *sptr, char *type)
{
	ircstp->is_ref++;
	sendto_realops_lev(REJ_LEV, "Rejecting possible %s drone: %s!%s@%s (%s)", type, sptr->name,
		sptr->username, sptr->host, sptr->info);
#ifdef USE_THROTTLE
	if (FloodConfig.throttle_rejected_clients) {
		throttle_force(sptr->host);
	}
#endif
	exit_client(cptr, sptr, sptr, "You match the pattern of a known trojan");
}

static int detect_fizzer(aClient *sptr, char *username)
{
	char tmp[USERLEN + 1], buf[USERLEN + 1];
	char *s1, *s2, *p;

	strncpyzt(tmp, sptr->info, USERLEN + 1);

	if ((s1 = strtoken(&p, tmp, " ")) == NULL) {
		return 0;
	}
	if ((s2 = strtoken(&p, NULL, " ")) == NULL) {
		return 0;
	}

	ircsnprintf(buf, USERLEN + 1, "%s%s", s2, s1);

	if (!irccmp(username, buf)) {
		return 1;
	}
	return 0;
}

static int detect_acebot(aClient *sptr, char *username)
{
	unsigned char *s;

	if (strlen(username) <= 2) {
		return 0;
	}
	for (s = (unsigned char *)sptr->username; *s != '\0'; s++) {
		if (*s < 'A' || *s > 'Z') {
			return 0;
		}
	}
	if (!irccmp(sptr->username, sptr->info)) {
		return 1;
	}
	return 0;
}

static int anti_drone(HookData *hdata)
{
	aClient *cptr = hdata->cptr;
	aClient *sptr = hdata->sptr;
	char *username = (*sptr->username == '~') ? &sptr->username[1] : sptr->username;

	if (detect_fizzer(sptr, username)) {
		block_drone(cptr, sptr, "fizzer");
		return FLUSH_BUFFER;
	}
	if (detect_acebot(sptr, username)) {
		block_drone(cptr, sptr, "acebot");
		return FLUSH_BUFFER;
	}

	return 0;
}
