/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: msgptr.h,v 1.20.2.2 2005/05/02 00:53:18 amcwilliam Exp $
 */

#ifndef	__msgptr_include__
#define	__msgptr_include__

#ifdef INCLUDE_MSG_PTR

msg_ptr CMD_CHANSERV	= { MSG_CHANSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_NICKSERV	= { MSG_NICKSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_MEMOSERV	= { MSG_MEMOSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_OPERSERV	= { MSG_OPERSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_STATSERV	= { MSG_STATSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_HOSTSERV	= { MSG_HOSTSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_BOTSERV	= { MSG_BOTSERV,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_CS		= { MSG_CS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_NS		= { MSG_NS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_MS		= { MSG_MS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_OS		= { MSG_OS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_SS		= { MSG_SS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_HS		= { MSG_HS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_BS		= { MSG_BS,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_SERVICES	= { MSG_SERVICES,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_IDENTIFY	= { MSG_IDENTIFY,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_ACCEPT	= { MSG_ACCEPT,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_ADMIN	= { MSG_ADMIN,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_AKILL	= { MSG_AKILL,		TOK1_AKILL,	CMDFLAG_NONE };
msg_ptr CMD_AWAY	= { MSG_AWAY,		TOK1_AWAY,	CMDFLAG_NONE };
msg_ptr CMD_BURST	= { MSG_BURST,		TOK1_BURST,	CMDFLAG_NONE };
msg_ptr CMD_CAPAB	= { MSG_CAPAB,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_CHATOPS	= { MSG_CHATOPS,	TOK1_CHATOPS,	CMDFLAG_NONE };
msg_ptr CMD_CLOSE	= { MSG_CLOSE,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_CONNECT	= { MSG_CONNECT,	TOK1_CONNECT,	CMDFLAG_NONE };
msg_ptr CMD_DALINFO	= { MSG_DALINFO,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_DCCALLOW	= { MSG_DCCALLOW,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_DIE		= { MSG_DIE,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_DKEY	= { MSG_DKEY,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_ERROR	= { MSG_ERROR,		TOK1_ERROR,	CMDFLAG_UNREGUSE };
msg_ptr CMD_GLOBOPS	= { MSG_GLOBOPS,	TOK1_GLOBOPS,	CMDFLAG_NONE };
msg_ptr CMD_GNOTICE	= { MSG_GNOTICE,	TOK1_GNOTICE,	CMDFLAG_NONE };
msg_ptr CMD_INFO	= { MSG_INFO,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_INVITE	= { MSG_INVITE,		TOK1_INVITE,	CMDFLAG_NONE };
msg_ptr CMD_ISON	= { MSG_ISON,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_JOIN	= { MSG_JOIN,		TOK1_JOIN,	CMDFLAG_NONE };
msg_ptr CMD_KICK	= { MSG_KICK,		TOK1_KICK,	CMDFLAG_NONE };
msg_ptr CMD_KILL	= { MSG_KILL,		TOK1_KILL,	CMDFLAG_NONE };
msg_ptr CMD_KLINE	= { MSG_KLINE,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_KNOCK	= { MSG_KNOCK,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_LINKS	= { MSG_LINKS,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_LIST	= { MSG_LIST,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_LOCOPS	= { MSG_LOCOPS,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_LUSERS	= { MSG_LUSERS,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_MAP		= { MSG_MAP,		NULL,		CMDFLAG_NONE };
#ifndef STATIC_MODULES
msg_ptr CMD_MODULE	= { MSG_MODULE,		NULL,		CMDFLAG_NONE };
#endif
msg_ptr CMD_MKPASSWD	= { MSG_MKPASSWD,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_MODE	= { MSG_MODE,		TOK1_MODE,	CMDFLAG_NONE };
msg_ptr CMD_MOTD	= { MSG_MOTD,		TOK1_MOTD,	CMDFLAG_NONE };
msg_ptr CMD_MYID	= { MSG_MYID,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_NAMES	= { MSG_NAMES,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_NBURST	= { MSG_NBURST,		TOK1_NBURST,	CMDFLAG_NONE };
msg_ptr CMD_NICK	= { MSG_NICK,		TOK1_NICK,	CMDFLAG_UNREGUSE };
msg_ptr CMD_NOTICE	= { MSG_NOTICE,		TOK1_NOTICE,	CMDFLAG_NONE };
msg_ptr CMD_NOTICE_D	= { MSG_NOTICE_D,	TOK1_NOTICE_D,	CMDFLAG_TOK1ONLY };
msg_ptr CMD_OPER	= { MSG_OPER,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_OPERMOTD	= { MSG_OPERMOTD,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_PART	= { MSG_PART,		TOK1_PART,	CMDFLAG_NONE };
msg_ptr CMD_PASS	= { MSG_PASS,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_PING	= { MSG_PING,		TOK1_PING,	CMDFLAG_NONE };
msg_ptr CMD_PONG	= { MSG_PONG,		TOK1_PONG,	CMDFLAG_NONE };
msg_ptr CMD_PRIVMSG	= { MSG_PRIVMSG,	TOK1_PRIVMSG,	CMDFLAG_RESETIDLE };
msg_ptr CMD_PRIVMSG_D	= { MSG_PRIVMSG_D,	TOK1_PRIVMSG_D,	CMDFLAG_RESETIDLE|CMDFLAG_TOK1ONLY };
msg_ptr CMD_QUIT	= { MSG_QUIT,		TOK1_QUIT,	CMDFLAG_NONE };
msg_ptr CMD_RAKILL	= { MSG_RAKILL,		TOK1_RAKILL,	CMDFLAG_NONE };
msg_ptr CMD_REHASH	= { MSG_REHASH,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_RESTART	= { MSG_RESTART,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_RESYNCH	= { MSG_RESYNCH,	TOK1_RESYNCH,	CMDFLAG_NONE };
msg_ptr CMD_RULES	= { MSG_RULES,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_SAJOIN	= { MSG_SAJOIN,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_SAKICK	= { MSG_SAKICK,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_SAMODE	= { MSG_SAMODE,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_SATOPIC	= { MSG_SATOPIC,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_SERVER	= { MSG_SERVER,		TOK1_SERVER,	CMDFLAG_UNREGUSE };
msg_ptr CMD_SGLINE	= { MSG_SGLINE,		TOK1_SGLINE,	CMDFLAG_NONE };
msg_ptr CMD_SILENCE	= { MSG_SILENCE,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_SJOIN	= { MSG_SJOIN,		TOK1_SJOIN,	CMDFLAG_NONE };
msg_ptr CMD_SNICK	= { MSG_SNICK,		TOK1_SNICK,	CMDFLAG_NONE };
msg_ptr CMD_SQLINE	= { MSG_SQLINE,		TOK1_SQLINE,	CMDFLAG_NONE };
msg_ptr CMD_SQUIT	= { MSG_SQUIT,		TOK1_SQUIT,	CMDFLAG_NONE };
msg_ptr CMD_STATS	= { MSG_STATS,		TOK1_STATS,	CMDFLAG_NONE };
msg_ptr CMD_SVINFO	= { MSG_SVINFO,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_SVSHOLD	= { MSG_SVSHOLD,	TOK1_SVSHOLD,	CMDFLAG_NONE };
msg_ptr CMD_SVSKILL	= { MSG_SVSKILL,	TOK1_SVSKILL,	CMDFLAG_NONE };
msg_ptr CMD_SVSMODE	= { MSG_SVSMODE,	TOK1_SVSMODE,	CMDFLAG_NONE };
msg_ptr CMD_SVSNICK	= { MSG_SVSNICK,	TOK1_SVSNICK,	CMDFLAG_NONE };
msg_ptr CMD_SVSNOOP	= { MSG_SVSNOOP,	TOK1_SVSNOOP,	CMDFLAG_NONE };
msg_ptr CMD_SZLINE	= { MSG_SZLINE,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_TIME	= { MSG_TIME,		TOK1_TIME,	CMDFLAG_NONE };
msg_ptr CMD_TOPIC	= { MSG_TOPIC,		TOK1_TOPIC,	CMDFLAG_NONE };
msg_ptr CMD_TRACE	= { MSG_TRACE,		TOK1_TRACE,	CMDFLAG_NONE };
msg_ptr CMD_UNKLINE	= { MSG_UNKLINE,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_UNSGLINE	= { MSG_UNSGLINE,	TOK1_UNSGLINE,	CMDFLAG_NONE };
msg_ptr CMD_UNSQLINE	= { MSG_UNSQLINE,	TOK1_UNSQLINE,	CMDFLAG_NONE };
msg_ptr CMD_UNSZLINE	= { MSG_UNSZLINE,	NULL,		CMDFLAG_NONE };
msg_ptr CMD_USER	= { MSG_USER,		NULL,		CMDFLAG_UNREGUSE };
msg_ptr CMD_USERHOST	= { MSG_USERHOST,	NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_VERSION	= { MSG_VERSION,	TOK1_VERSION,	CMDFLAG_UNREGUSE };
msg_ptr CMD_VHOST	= { MSG_VHOST,		TOK1_VHOST,	CMDFLAG_NONE };
msg_ptr CMD_WALLOPS	= { MSG_WALLOPS,	TOK1_WALLOPS,	CMDFLAG_NONE };
msg_ptr CMD_WATCH	= { MSG_WATCH,		NULL,		CMDFLAG_SINGLEPARA };
msg_ptr CMD_WHO		= { MSG_WHO,		NULL,		CMDFLAG_NONE };
msg_ptr CMD_WHOIS	= { MSG_WHOIS,		TOK1_WHOIS,	CMDFLAG_NONE };
msg_ptr CMD_WHOWAS	= { MSG_WHOWAS,		TOK1_WHOWAS,	CMDFLAG_NONE };

#else

extern msg_ptr CMD_CHANSERV, CMD_CS;
extern msg_ptr CMD_NICKSERV, CMD_NS;
extern msg_ptr CMD_OPERSERV, CMD_OS;
extern msg_ptr CMD_MEMOSERV, CMD_MS;
extern msg_ptr CMD_STATSERV, CMD_SS;
extern msg_ptr CMD_HOSTSERV, CMD_HS;
extern msg_ptr CMD_BOTSERV, CMD_BS;
extern msg_ptr CMD_SERVICES;
extern msg_ptr CMD_IDENTIFY;
extern msg_ptr CMD_ACCEPT;
extern msg_ptr CMD_ADMIN;
extern msg_ptr CMD_AKILL;
extern msg_ptr CMD_AWAY;
extern msg_ptr CMD_BURST;
extern msg_ptr CMD_CAPAB;
extern msg_ptr CMD_CHATOPS;
extern msg_ptr CMD_CLOSE;
extern msg_ptr CMD_CONNECT;
extern msg_ptr CMD_DALINFO;
extern msg_ptr CMD_DCCALLOW;
extern msg_ptr CMD_DIE;
extern msg_ptr CMD_DKEY;
extern msg_ptr CMD_ERROR;
extern msg_ptr CMD_GLOBOPS;
extern msg_ptr CMD_GNOTICE;
extern msg_ptr CMD_INFO;
extern msg_ptr CMD_INVITE;
extern msg_ptr CMD_ISON;
extern msg_ptr CMD_JOIN;
extern msg_ptr CMD_KICK;
extern msg_ptr CMD_KILL;
extern msg_ptr CMD_KLINE;
extern msg_ptr CMD_KNOCK;
extern msg_ptr CMD_LINKS;
extern msg_ptr CMD_LIST;
extern msg_ptr CMD_LOCOPS;
extern msg_ptr CMD_LUSERS;
extern msg_ptr CMD_MAP;
#ifndef STATIC_MODULES
extern msg_ptr CMD_MODULE;
#endif
extern msg_ptr CMD_MKPASSWD;
extern msg_ptr CMD_MODE;
extern msg_ptr CMD_MOTD;
extern msg_ptr CMD_MYID;
extern msg_ptr CMD_NAMES;
extern msg_ptr CMD_NBURST;
extern msg_ptr CMD_NICK;
extern msg_ptr CMD_NOTICE, CMD_NOTICE_D;
extern msg_ptr CMD_OPER;
extern msg_ptr CMD_OPERMOTD;
extern msg_ptr CMD_PART;
extern msg_ptr CMD_PASS;
extern msg_ptr CMD_PING;
extern msg_ptr CMD_PONG;
extern msg_ptr CMD_PRIVMSG, CMD_PRIVMSG_D;
extern msg_ptr CMD_QUIT;
extern msg_ptr CMD_RAKILL;
extern msg_ptr CMD_REHASH;
extern msg_ptr CMD_RESTART;
extern msg_ptr CMD_RESYNCH;
extern msg_ptr CMD_RULES;
extern msg_ptr CMD_SAJOIN;
extern msg_ptr CMD_SAKICK;
extern msg_ptr CMD_SAMODE;
extern msg_ptr CMD_SATOPIC;
extern msg_ptr CMD_SERVER;
extern msg_ptr CMD_SGLINE;
extern msg_ptr CMD_SILENCE;
extern msg_ptr CMD_SJOIN;
extern msg_ptr CMD_SNICK;
extern msg_ptr CMD_SQLINE;
extern msg_ptr CMD_SQUIT;
extern msg_ptr CMD_STATS;
extern msg_ptr CMD_SVINFO;
extern msg_ptr CMD_SVSHOLD;
extern msg_ptr CMD_SVSKILL;
extern msg_ptr CMD_SVSMODE;
extern msg_ptr CMD_SVSNICK;
extern msg_ptr CMD_SVSNOOP;
extern msg_ptr CMD_SZLINE;
extern msg_ptr CMD_TIME;
extern msg_ptr CMD_TOPIC;
extern msg_ptr CMD_TRACE;
extern msg_ptr CMD_UNKLINE;
extern msg_ptr CMD_UNSGLINE;
extern msg_ptr CMD_UNSQLINE;
extern msg_ptr CMD_UNSZLINE;
extern msg_ptr CMD_USER;
extern msg_ptr CMD_USERHOST;
extern msg_ptr CMD_VERSION;
extern msg_ptr CMD_VHOST;
extern msg_ptr CMD_WALLOPS;
extern msg_ptr CMD_WATCH;
extern msg_ptr CMD_WHO;
extern msg_ptr CMD_WHOIS;
extern msg_ptr CMD_WHOWAS;

#endif

#endif /* __msgptr_include__ */
