/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: memory.h,v 1.14.2.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef __memory_include__
#define __memory_include__

#include "setup.h"
#include "config.h"
#include "blalloc.h"
#include <stdlib.h>
#include <string.h>

extern void outofmemory();

extern void *_MyMalloc(size_t, char *, int);
extern void *_MyRealloc(void *, size_t, char *, int);
extern void _MyFree(void *, char *, int);
extern void _DupString(char **, const char *, char *, int);
extern void *_BlockHeapAlloc(BlockHeap *, char *, int);
extern void _BlockHeapFree(BlockHeap *, void *, char *, int);

#define MyMalloc(x) _MyMalloc(x, __FILE__, __LINE__)
#define MyRealloc(x, y) _MyRealloc(x, y, __FILE__, __LINE__)
#define MyFree(x) _MyFree(x, __FILE__, __LINE__)
#define DupString(x, y) _DupString(&x, y, __FILE__, __LINE__)
#define BlockHeapAlloc(x) _BlockHeapAlloc(x, __FILE__, __LINE__)
#define BlockHeapFree(x, y) _BlockHeapFree(x, y, __FILE__, __LINE__)

#endif /* __memory_include__ */
