/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: hook.h,v 1.33.2.1 2004/12/07 03:04:37 pneumatus Exp $
 */

#ifndef	__hook_include__
#define	__hook_include__

#include "setup.h"

typedef struct _hook Hook;
typedef struct _hook_event HookEvent;
typedef struct _hook_data HookData;

struct _hook {
	char *name;
	dlink_list events;
	Module *owner;
};

struct _hook_event {
	Hook *hook;
	int (*event)();
	Module *owner;
};

struct _hook_data {
	aClient *cptr;
	aClient *sptr;
	aClient *acptr;
	aChannel *chptr;

	void *v;
	int i;
	time_t t;
	char *c;
};

#define HOOKDATA_INIT { NULL, NULL, NULL, NULL, NULL, 0, 0, NULL }

extern dlink_list hook_list;

extern Hook *h_post_accept;
extern Hook *h_user_access;
extern Hook *h_register_user_local;
extern Hook *h_register_user_remote;
extern Hook *h_post_register_user;
extern Hook *h_conf_parse;
extern Hook *h_conf_test;
extern Hook *h_conf_verify;
extern Hook *h_conf_complete;
extern Hook *h_conf_rehash;
extern Hook *h_pre_netio;
extern Hook *h_post_netio;
extern Hook *h_exit_user_local;
extern Hook *h_exit_user_remote;
extern Hook *h_exit_server;
extern Hook *h_exit_unknown;
extern Hook *h_pre_connauth;

extern void hook_init();
extern Hook *hook_find(char *);
extern Hook *hook_add(char *);
extern void hook_del(Hook *);
extern HookEvent *hook_add_event(Hook *, int (*)());
extern void hook_del_event(HookEvent *);
extern void hook_del_events(Hook *);
extern void hook_report(aClient *);

static inline void hook_run(Hook *hook_p, HookData *data_p)
{
	dlink_node *node_p;
	int (*event_p)();

	ASSERT(hook_p != NULL);

	DLINK_FOREACH(hook_p->events.head, node_p) {
		event_p = ((HookEvent *)node_p->data)->event;
		(*event_p)(data_p);
	}
}

static inline int hook_run_until(Hook *hook_p, HookData *data_p, int until)
{
	dlink_node *node_p;
	int (*event_p)(), ret = 0;

	ASSERT(hook_p != NULL);

	DLINK_FOREACH(hook_p->events.head, node_p) {
		event_p = ((HookEvent *)node_p->data)->event;
		if ((ret = (*event_p)(data_p)) == until) {
			break;
		}
	}

	return ret;
}

static inline int hook_run_untilnot(Hook *hook_p, HookData *data_p, int untilnot)
{
	dlink_node *node_p;
	int (*event_p)(), ret = 0;

	ASSERT(hook_p != NULL);

	DLINK_FOREACH(hook_p->events.head, node_p) {
		event_p = ((HookEvent *)node_p->data)->event;
		if ((ret = (*event_p)(data_p)) != untilnot) {
			break;
		}
	}

	return ret;
}

#endif /* __hook_include__ */
