/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSTiming.h"

#include "Timing.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTiming);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTimingTableValues[16] =
{
    { "navigationStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingNavigationStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "unloadEventEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingUnloadEventEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "redirectStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingRedirectStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "redirectEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingRedirectEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "fetchStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingFetchStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "domainLookupStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingDomainLookupStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "domainLookupEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingDomainLookupEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "connectStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingConnectStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "connectEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingConnectEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "requestStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingRequestStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "requestEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingRequestEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "responseStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingResponseStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "responseEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingResponseEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { "loadEventStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingLoadEventStart), (intptr_t)0 THUNK_GENERATOR(0) },
    { "loadEventEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTimingLoadEventEnd), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTimingTable = { 35, 31, JSTimingTableValues, 0 };
/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTimingPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTimingPrototypeTable = { 1, 0, JSTimingPrototypeTableValues, 0 };
const ClassInfo JSTimingPrototype::s_info = { "TimingPrototype", 0, &JSTimingPrototypeTable, 0 };

JSObject* JSTimingPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTiming>(exec, globalObject);
}

const ClassInfo JSTiming::s_info = { "Timing", 0, &JSTimingTable, 0 };

JSTiming::JSTiming(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Timing> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSTiming::~JSTiming()
{
    forgetDOMObject(this, impl());
}

JSObject* JSTiming::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSTimingPrototype(globalObject, JSTimingPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSTiming::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTiming, Base>(exec, &JSTimingTable, this, propertyName, slot);
}

bool JSTiming::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTiming, Base>(exec, &JSTimingTable, this, propertyName, descriptor);
}

JSValue jsTimingNavigationStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->navigationStart());
    return result;
}

JSValue jsTimingUnloadEventEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->unloadEventEnd());
    return result;
}

JSValue jsTimingRedirectStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->redirectStart());
    return result;
}

JSValue jsTimingRedirectEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->redirectEnd());
    return result;
}

JSValue jsTimingFetchStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->fetchStart());
    return result;
}

JSValue jsTimingDomainLookupStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->domainLookupStart());
    return result;
}

JSValue jsTimingDomainLookupEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->domainLookupEnd());
    return result;
}

JSValue jsTimingConnectStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->connectStart());
    return result;
}

JSValue jsTimingConnectEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->connectEnd());
    return result;
}

JSValue jsTimingRequestStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->requestStart());
    return result;
}

JSValue jsTimingRequestEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->requestEnd());
    return result;
}

JSValue jsTimingResponseStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->responseStart());
    return result;
}

JSValue jsTimingResponseEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->responseEnd());
    return result;
}

JSValue jsTimingLoadEventStart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->loadEventStart());
    return result;
}

JSValue jsTimingLoadEventEnd(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTiming* castedThis = static_cast<JSTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Timing* imp = static_cast<Timing*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->loadEventEnd());
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Timing* object)
{
    return getDOMObjectWrapper<JSTiming>(exec, globalObject, object);
}
Timing* toTiming(JSC::JSValue value)
{
    return value.inherits(&JSTiming::s_info) ? static_cast<JSTiming*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
