/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSNode_h
#define JSNode_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObjectWithGlobalObject.h>
#include <runtime/Lookup.h>
#include <runtime/ObjectPrototype.h>
#include <wtf/AlwaysInline.h>

namespace WebCore {

class Node;

class JSNode : public DOMObjectWithGlobalPointer {
    typedef DOMObjectWithGlobalPointer Base;
public:
    JSNode(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<Node>);
    virtual ~JSNode();
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    virtual void markChildren(JSC::MarkStack&);

    virtual void pushEventHandlerScope(JSC::ExecState*, JSC::ScopeChain&) const;

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue insertBefore(JSC::ExecState*);
    JSC::JSValue replaceChild(JSC::ExecState*);
    JSC::JSValue removeChild(JSC::ExecState*);
    JSC::JSValue appendChild(JSC::ExecState*);
    Node* impl() const { return m_impl.get(); }

private:
    RefPtr<Node> m_impl;
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

ALWAYS_INLINE bool JSNode::getOwnPropertySlot(JSC::ExecState* exec, const JSC::Identifier& propertyName, JSC::PropertySlot& slot)
{
    return JSC::getStaticValueSlot<JSNode, Base>(exec, s_info.staticPropHashTable, this, propertyName, slot);
}

ALWAYS_INLINE bool JSNode::getOwnPropertyDescriptor(JSC::ExecState* exec, const JSC::Identifier& propertyName, JSC::PropertyDescriptor& descriptor)
{
    return JSC::getStaticValueDescriptor<JSNode, Base>(exec, s_info.staticPropHashTable, this, propertyName, descriptor);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, Node*);
Node* toNode(JSC::JSValue);
JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject*, Node*);

class JSNodePrototype : public JSC::JSObjectWithGlobalObject {
    typedef JSC::JSObjectWithGlobalObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSNodePrototype(JSC::JSGlobalObject* globalObject, NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObjectWithGlobalObject(globalObject, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionInsertBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionReplaceChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAppendChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionHasChildNodes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCloneNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionNormalize(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSupported(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionHasAttributes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSameNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsEqualNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupPrefix(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsDefaultNamespace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupNamespaceURI(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCompareDocumentPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsNodeNodeName(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeNodeValue(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSNodeNodeValue(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeNodeType(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeParentNode(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeChildNodes(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeFirstChild(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeLastChild(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodePreviousSibling(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeNextSibling(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeAttributes(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeOwnerDocument(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeNamespaceURI(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodePrefix(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSNodePrefix(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeLocalName(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeBaseURI(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeTextContent(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
void setJSNodeTextContent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeParentElement(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
// Constants

JSC::JSValue jsNodeELEMENT_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeATTRIBUTE_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeTEXT_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeCDATA_SECTION_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeENTITY_REFERENCE_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeENTITY_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodePROCESSING_INSTRUCTION_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeCOMMENT_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_TYPE_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_FRAGMENT_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeNOTATION_NODE(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_DISCONNECTED(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_PRECEDING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_FOLLOWING(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_CONTAINS(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_CONTAINED_BY(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);
JSC::JSValue jsNodeDOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif
#include "JSNodeCustom.h"
