/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INSPECTOR)

#include "JSInjectedScriptHost.h"

#include "InjectedScriptHost.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSInjectedScriptHost);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInjectedScriptHostTableValues[2] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInjectedScriptHostConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInjectedScriptHostTable = { 2, 1, JSInjectedScriptHostTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInjectedScriptHostConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInjectedScriptHostConstructorTable = { 1, 0, JSInjectedScriptHostConstructorTableValues, 0 };
class JSInjectedScriptHostConstructor : public DOMConstructorObject {
public:
    JSInjectedScriptHostConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSInjectedScriptHostConstructor::s_info = { "InjectedScriptHostConstructor", 0, &JSInjectedScriptHostConstructorTable, 0 };

JSInjectedScriptHostConstructor::JSInjectedScriptHostConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSInjectedScriptHostConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSInjectedScriptHostPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSInjectedScriptHostConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInjectedScriptHostConstructor, DOMObject>(exec, &JSInjectedScriptHostConstructorTable, this, propertyName, slot);
}

bool JSInjectedScriptHostConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInjectedScriptHostConstructor, DOMObject>(exec, &JSInjectedScriptHostConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInjectedScriptHostPrototypeTableValues[14] =
{
    { "clearConsoleMessages", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionClearConsoleMessages), (intptr_t)0 THUNK_GENERATOR(0) },
    { "copyText", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionCopyText), (intptr_t)1 THUNK_GENERATOR(0) },
    { "nodeForId", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionNodeForId), (intptr_t)1 THUNK_GENERATOR(0) },
    { "pushNodePathToFrontend", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionPushNodePathToFrontend), (intptr_t)3 THUNK_GENERATOR(0) },
    { "inspectedNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionInspectedNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "currentCallFrame", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionCurrentCallFrame), (intptr_t)0 THUNK_GENERATOR(0) },
    { "databaseForId", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionDatabaseForId), (intptr_t)1 THUNK_GENERATOR(0) },
    { "selectDatabase", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionSelectDatabase), (intptr_t)1 THUNK_GENERATOR(0) },
    { "selectDOMStorage", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionSelectDOMStorage), (intptr_t)1 THUNK_GENERATOR(0) },
    { "didCreateWorker", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionDidCreateWorker), (intptr_t)3 THUNK_GENERATOR(0) },
    { "didDestroyWorker", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionDidDestroyWorker), (intptr_t)1 THUNK_GENERATOR(0) },
    { "nextWorkerId", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionNextWorkerId), (intptr_t)0 THUNK_GENERATOR(0) },
    { "reportDidDispatchOnInjectedScript", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInjectedScriptHostPrototypeFunctionReportDidDispatchOnInjectedScript), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInjectedScriptHostPrototypeTable = { 33, 31, JSInjectedScriptHostPrototypeTableValues, 0 };
const ClassInfo JSInjectedScriptHostPrototype::s_info = { "InjectedScriptHostPrototype", 0, &JSInjectedScriptHostPrototypeTable, 0 };

JSObject* JSInjectedScriptHostPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInjectedScriptHost>(exec, globalObject);
}

bool JSInjectedScriptHostPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSInjectedScriptHostPrototypeTable, this, propertyName, slot);
}

bool JSInjectedScriptHostPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInjectedScriptHostPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSInjectedScriptHost::s_info = { "InjectedScriptHost", 0, &JSInjectedScriptHostTable, 0 };

JSInjectedScriptHost::JSInjectedScriptHost(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<InjectedScriptHost> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSInjectedScriptHost::~JSInjectedScriptHost()
{
    forgetDOMObject(this, impl());
}

JSObject* JSInjectedScriptHost::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSInjectedScriptHostPrototype(globalObject, JSInjectedScriptHostPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSInjectedScriptHost::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInjectedScriptHost, Base>(exec, &JSInjectedScriptHostTable, this, propertyName, slot);
}

bool JSInjectedScriptHost::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInjectedScriptHost, Base>(exec, &JSInjectedScriptHostTable, this, propertyName, descriptor);
}

JSValue jsInjectedScriptHostConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSInjectedScriptHost* domObject = static_cast<JSInjectedScriptHost*>(asObject(slotBase));
    return JSInjectedScriptHost::getConstructor(exec, domObject->globalObject());
}
JSValue JSInjectedScriptHost::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInjectedScriptHostConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionClearConsoleMessages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());

    imp->clearConsoleMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionCopyText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());
    const String& text = ustringToString(exec->argument(0).toString(exec));

    imp->copyText(text);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionNodeForId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->nodeForId(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionPushNodePathToFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->pushNodePathToFrontend(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspectedNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());
    unsigned num = exec->argument(0).toInt32(exec);


    JSC::JSValue result = jsNumber(exec, imp->inspectedNode(num));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionCurrentCallFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->currentCallFrame(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDatabaseForId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->databaseForId(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionSelectDatabase(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->selectDatabase(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionSelectDOMStorage(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->selectDOMStorage(exec));
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDidCreateWorker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());
    int id = exec->argument(0).toInt32(exec);
    const String& url = ustringToString(exec->argument(1).toString(exec));
    bool isFakeWorker = exec->argument(2).toBoolean(exec);

    imp->didCreateWorker(id, url, isFakeWorker);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDidDestroyWorker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());
    int id = exec->argument(0).toInt32(exec);

    imp->didDestroyWorker(id);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionNextWorkerId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    InjectedScriptHost* imp = static_cast<InjectedScriptHost*>(castedThis->impl());


    JSC::JSValue result = jsNumber(exec, imp->nextWorkerId());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionReportDidDispatchOnInjectedScript(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInjectedScriptHost::s_info))
        return throwVMTypeError(exec);
    JSInjectedScriptHost* castedThis = static_cast<JSInjectedScriptHost*>(asObject(thisValue));
    return JSValue::encode(castedThis->reportDidDispatchOnInjectedScript(exec));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InjectedScriptHost* object)
{
    return getDOMObjectWrapper<JSInjectedScriptHost>(exec, globalObject, object);
}
InjectedScriptHost* toInjectedScriptHost(JSC::JSValue value)
{
    return value.inherits(&JSInjectedScriptHost::s_info) ? static_cast<JSInjectedScriptHost*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(INSPECTOR)
