/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "Attr.h"
#include "CDATASection.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "EventListener.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLHeadElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "PlatformString.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDocument);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDocumentTableValues[75] =
{
    { "doctype", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDoctype), (intptr_t)0 THUNK_GENERATOR(0) },
    { "implementation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImplementation), (intptr_t)0 THUNK_GENERATOR(0) },
    { "documentElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentElement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "inputEncoding", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentInputEncoding), (intptr_t)0 THUNK_GENERATOR(0) },
    { "xmlEncoding", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLEncoding), (intptr_t)0 THUNK_GENERATOR(0) },
    { "xmlVersion", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLVersion), (intptr_t)setJSDocumentXMLVersion THUNK_GENERATOR(0) },
    { "xmlStandalone", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLStandalone), (intptr_t)setJSDocumentXMLStandalone THUNK_GENERATOR(0) },
    { "documentURI", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentURI), (intptr_t)setJSDocumentDocumentURI THUNK_GENERATOR(0) },
    { "defaultView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultView), (intptr_t)0 THUNK_GENERATOR(0) },
    { "styleSheets", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentStyleSheets), (intptr_t)0 THUNK_GENERATOR(0) },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTitle), (intptr_t)setJSDocumentTitle THUNK_GENERATOR(0) },
    { "referrer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReferrer), (intptr_t)0 THUNK_GENERATOR(0) },
    { "domain", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDomain), (intptr_t)setJSDocumentDomain THUNK_GENERATOR(0) },
    { "URL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentURL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "cookie", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCookie), (intptr_t)setJSDocumentCookie THUNK_GENERATOR(0) },
    { "body", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentBody), (intptr_t)setJSDocumentBody THUNK_GENERATOR(0) },
    { "head", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHead), (intptr_t)0 THUNK_GENERATOR(0) },
    { "images", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImages), (intptr_t)0 THUNK_GENERATOR(0) },
    { "applets", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentApplets), (intptr_t)0 THUNK_GENERATOR(0) },
    { "links", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinks), (intptr_t)0 THUNK_GENERATOR(0) },
    { "forms", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentForms), (intptr_t)0 THUNK_GENERATOR(0) },
    { "anchors", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAnchors), (intptr_t)0 THUNK_GENERATOR(0) },
    { "lastModified", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastModified), (intptr_t)0 THUNK_GENERATOR(0) },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLocation), (intptr_t)setJSDocumentLocation THUNK_GENERATOR(0) },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharset), (intptr_t)setJSDocumentCharset THUNK_GENERATOR(0) },
    { "defaultCharset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultCharset), (intptr_t)0 THUNK_GENERATOR(0) },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReadyState), (intptr_t)0 THUNK_GENERATOR(0) },
    { "characterSet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharacterSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { "preferredStylesheetSet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPreferredStylesheetSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { "selectedStylesheetSet", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentSelectedStylesheetSet), (intptr_t)setJSDocumentSelectedStylesheetSet THUNK_GENERATOR(0) },
    { "onabort", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnabort), (intptr_t)setJSDocumentOnabort THUNK_GENERATOR(0) },
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnblur), (intptr_t)setJSDocumentOnblur THUNK_GENERATOR(0) },
    { "onchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnchange), (intptr_t)setJSDocumentOnchange THUNK_GENERATOR(0) },
    { "onclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnclick), (intptr_t)setJSDocumentOnclick THUNK_GENERATOR(0) },
    { "oncontextmenu", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncontextmenu), (intptr_t)setJSDocumentOncontextmenu THUNK_GENERATOR(0) },
    { "ondblclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndblclick), (intptr_t)setJSDocumentOndblclick THUNK_GENERATOR(0) },
    { "ondrag", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrag), (intptr_t)setJSDocumentOndrag THUNK_GENERATOR(0) },
    { "ondragend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragend), (intptr_t)setJSDocumentOndragend THUNK_GENERATOR(0) },
    { "ondragenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragenter), (intptr_t)setJSDocumentOndragenter THUNK_GENERATOR(0) },
    { "ondragleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragleave), (intptr_t)setJSDocumentOndragleave THUNK_GENERATOR(0) },
    { "ondragover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragover), (intptr_t)setJSDocumentOndragover THUNK_GENERATOR(0) },
    { "ondragstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragstart), (intptr_t)setJSDocumentOndragstart THUNK_GENERATOR(0) },
    { "ondrop", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrop), (intptr_t)setJSDocumentOndrop THUNK_GENERATOR(0) },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnerror), (intptr_t)setJSDocumentOnerror THUNK_GENERATOR(0) },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnfocus), (intptr_t)setJSDocumentOnfocus THUNK_GENERATOR(0) },
    { "oninput", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninput), (intptr_t)setJSDocumentOninput THUNK_GENERATOR(0) },
    { "oninvalid", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninvalid), (intptr_t)setJSDocumentOninvalid THUNK_GENERATOR(0) },
    { "onkeydown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeydown), (intptr_t)setJSDocumentOnkeydown THUNK_GENERATOR(0) },
    { "onkeypress", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeypress), (intptr_t)setJSDocumentOnkeypress THUNK_GENERATOR(0) },
    { "onkeyup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeyup), (intptr_t)setJSDocumentOnkeyup THUNK_GENERATOR(0) },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnload), (intptr_t)setJSDocumentOnload THUNK_GENERATOR(0) },
    { "onmousedown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousedown), (intptr_t)setJSDocumentOnmousedown THUNK_GENERATOR(0) },
    { "onmousemove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousemove), (intptr_t)setJSDocumentOnmousemove THUNK_GENERATOR(0) },
    { "onmouseout", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseout), (intptr_t)setJSDocumentOnmouseout THUNK_GENERATOR(0) },
    { "onmouseover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseover), (intptr_t)setJSDocumentOnmouseover THUNK_GENERATOR(0) },
    { "onmouseup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseup), (intptr_t)setJSDocumentOnmouseup THUNK_GENERATOR(0) },
    { "onmousewheel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousewheel), (intptr_t)setJSDocumentOnmousewheel THUNK_GENERATOR(0) },
    { "onscroll", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnscroll), (intptr_t)setJSDocumentOnscroll THUNK_GENERATOR(0) },
    { "onselect", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselect), (intptr_t)setJSDocumentOnselect THUNK_GENERATOR(0) },
    { "onsubmit", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsubmit), (intptr_t)setJSDocumentOnsubmit THUNK_GENERATOR(0) },
    { "onbeforecut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecut), (intptr_t)setJSDocumentOnbeforecut THUNK_GENERATOR(0) },
    { "oncut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncut), (intptr_t)setJSDocumentOncut THUNK_GENERATOR(0) },
    { "onbeforecopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecopy), (intptr_t)setJSDocumentOnbeforecopy THUNK_GENERATOR(0) },
    { "oncopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncopy), (intptr_t)setJSDocumentOncopy THUNK_GENERATOR(0) },
    { "onbeforepaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforepaste), (intptr_t)setJSDocumentOnbeforepaste THUNK_GENERATOR(0) },
    { "onpaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpaste), (intptr_t)setJSDocumentOnpaste THUNK_GENERATOR(0) },
    { "onreset", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreset), (intptr_t)setJSDocumentOnreset THUNK_GENERATOR(0) },
    { "onsearch", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsearch), (intptr_t)setJSDocumentOnsearch THUNK_GENERATOR(0) },
    { "onselectstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectstart), (intptr_t)setJSDocumentOnselectstart THUNK_GENERATOR(0) },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchstart), (intptr_t)setJSDocumentOntouchstart THUNK_GENERATOR(0) },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchmove), (intptr_t)setJSDocumentOntouchmove THUNK_GENERATOR(0) },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchend), (intptr_t)setJSDocumentOntouchend THUNK_GENERATOR(0) },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchcancel), (intptr_t)setJSDocumentOntouchcancel THUNK_GENERATOR(0) },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDocumentTable = { 262, 255, JSDocumentTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDocumentConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDocumentConstructorTable = { 1, 0, JSDocumentConstructorTableValues, 0 };
class JSDocumentConstructor : public DOMConstructorObject {
public:
    JSDocumentConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDocumentConstructor::s_info = { "DocumentConstructor", 0, &JSDocumentConstructorTable, 0 };

JSDocumentConstructor::JSDocumentConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSDocumentConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSDocumentPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, slot);
}

bool JSDocumentConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDocumentConstructor, DOMObject>(exec, &JSDocumentConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDocumentPrototypeTableValues[38] =
{
    { "createElement", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElement), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createDocumentFragment", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateDocumentFragment), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createTextNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTextNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createComment", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateComment), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createCDATASection", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateCDATASection), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createProcessingInstruction", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateProcessingInstruction), (intptr_t)2 THUNK_GENERATOR(0) },
    { "createAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createEntityReference", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEntityReference), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getElementsByTagName", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagName), (intptr_t)1 THUNK_GENERATOR(0) },
    { "importNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionImportNode), (intptr_t)2 THUNK_GENERATOR(0) },
    { "createElementNS", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElementNS), (intptr_t)2 THUNK_GENERATOR(0) },
    { "createAttributeNS", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttributeNS), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getElementsByTagNameNS", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagNameNS), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getElementById", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementById), (intptr_t)1 THUNK_GENERATOR(0) },
    { "adoptNode", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionAdoptNode), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEvent), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createRange", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateRange), (intptr_t)0 THUNK_GENERATOR(0) },
    { "createNodeIterator", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNodeIterator), (intptr_t)4 THUNK_GENERATOR(0) },
    { "createTreeWalker", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTreeWalker), (intptr_t)4 THUNK_GENERATOR(0) },
    { "getOverrideStyle", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetOverrideStyle), (intptr_t)2 THUNK_GENERATOR(0) },
    { "createExpression", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateExpression), (intptr_t)2 THUNK_GENERATOR(0) },
    { "createNSResolver", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNSResolver), (intptr_t)1 THUNK_GENERATOR(0) },
    { "evaluate", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionEvaluate), (intptr_t)5 THUNK_GENERATOR(0) },
    { "execCommand", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionExecCommand), (intptr_t)3 THUNK_GENERATOR(0) },
    { "queryCommandEnabled", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandEnabled), (intptr_t)1 THUNK_GENERATOR(0) },
    { "queryCommandIndeterm", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandIndeterm), (intptr_t)1 THUNK_GENERATOR(0) },
    { "queryCommandState", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandState), (intptr_t)1 THUNK_GENERATOR(0) },
    { "queryCommandSupported", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandSupported), (intptr_t)1 THUNK_GENERATOR(0) },
    { "queryCommandValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getElementsByName", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByName), (intptr_t)1 THUNK_GENERATOR(0) },
    { "elementFromPoint", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionElementFromPoint), (intptr_t)2 THUNK_GENERATOR(0) },
    { "caretRangeFromPoint", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCaretRangeFromPoint), (intptr_t)2 THUNK_GENERATOR(0) },
    { "getSelection", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetSelection), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getCSSCanvasContext", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetCSSCanvasContext), (intptr_t)4 THUNK_GENERATOR(0) },
    { "getElementsByClassName", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByClassName), (intptr_t)1 THUNK_GENERATOR(0) },
    { "querySelector", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelector), (intptr_t)1 THUNK_GENERATOR(0) },
    { "querySelectorAll", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelectorAll), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDocumentPrototypeTable = { 135, 127, JSDocumentPrototypeTableValues, 0 };
const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", 0, &JSDocumentPrototypeTable, 0 };

JSObject* JSDocumentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocument>(exec, globalObject);
}

bool JSDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, slot);
}

bool JSDocumentPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDocumentPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDocument::s_info = { "Document", &JSNode::s_info, &JSDocumentTable, 0 };

JSDocument::JSDocument(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Document> impl)
    : JSNode(structure, globalObject, impl)
{
}

JSObject* JSDocument::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDocumentPrototype(globalObject, JSDocumentPrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

JSValue jsDocumentDoctype(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->doctype()));
    return result;
}

JSValue jsDocumentImplementation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->implementation()));
    return result;
}

JSValue jsDocumentDocumentElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->documentElement()));
    return result;
}

JSValue jsDocumentInputEncoding(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->inputEncoding());
    return result;
}

JSValue jsDocumentXMLEncoding(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->xmlEncoding());
    return result;
}

JSValue jsDocumentXMLVersion(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->xmlVersion());
    return result;
}

JSValue jsDocumentXMLStandalone(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsBoolean(imp->xmlStandalone());
    return result;
}

JSValue jsDocumentDocumentURI(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->documentURI());
    return result;
}

JSValue jsDocumentDefaultView(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->defaultView()));
    return result;
}

JSValue jsDocumentStyleSheets(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->styleSheets()));
    return result;
}

JSValue jsDocumentTitle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->title());
    return result;
}

JSValue jsDocumentReferrer(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->referrer());
    return result;
}

JSValue jsDocumentDomain(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->domain());
    return result;
}

JSValue jsDocumentURL(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->url());
    return result;
}

JSValue jsDocumentCookie(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSC::JSValue result = jsString(exec, imp->cookie(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue jsDocumentBody(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->body()));
    return result;
}

JSValue jsDocumentHead(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->head()));
    return result;
}

JSValue jsDocumentImages(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->images()));
    return result;
}

JSValue jsDocumentApplets(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->applets()));
    return result;
}

JSValue jsDocumentLinks(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->links()));
    return result;
}

JSValue jsDocumentForms(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->forms()));
    return result;
}

JSValue jsDocumentAnchors(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->anchors()));
    return result;
}

JSValue jsDocumentLastModified(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lastModified());
    return result;
}

JSValue jsDocumentLocation(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    return castedThis->location(exec);
}

JSValue jsDocumentCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->charset());
    return result;
}

JSValue jsDocumentDefaultCharset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->defaultCharset());
    return result;
}

JSValue jsDocumentReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, imp->readyState());
    return result;
}

JSValue jsDocumentCharacterSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->characterSet());
    return result;
}

JSValue jsDocumentPreferredStylesheetSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->preferredStylesheetSet());
    return result;
}

JSValue jsDocumentSelectedStylesheetSet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->selectedStylesheetSet());
    return result;
}

JSValue jsDocumentOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnblur(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnchange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncontextmenu(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndblclick(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndrag(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragenter(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragleave(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndragstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOndrop(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnfocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOninput(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOninvalid(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oninvalid()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeydown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeypress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnkeyup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousedown(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousemove(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseout(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseover(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmouseup(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnmousewheel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnscroll(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnselect(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnsubmit(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforecut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncut(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforecopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOncopy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnbeforepaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnpaste(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnreset(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnsearch(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsDocumentOnselectstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchmove(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchmove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchend(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchcancel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = imp->ontouchcancel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp))
                return jsFunction;
        }
    }
    return jsNull();
}
#endif

JSValue jsDocumentConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDocument* domObject = static_cast<JSDocument*>(asObject(slotBase));
    return JSDocument::getConstructor(exec, domObject->globalObject());
}
void JSDocument::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSDocument, Base>(exec, propertyName, value, &JSDocumentTable, this, slot);
}

void setJSDocumentXMLVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentXMLStandalone(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setXMLStandalone(value.toBoolean(exec), ec);
    setDOMException(exec, ec);
}

void setJSDocumentDocumentURI(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    imp->setDocumentURI(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    imp->setTitle(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentDomain(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setDomain(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentCookie(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setCookie(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentBody(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setBody(toHTMLElement(value), ec);
    setDOMException(exec, ec);
}

void setJSDocumentLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSDocument*>(thisObject)->setLocation(exec, value);
}

void setJSDocumentCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    imp->setCharset(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentSelectedStylesheetSet(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSDocument* castedThis = static_cast<JSDocument*>(thisObject);
    Document* imp = static_cast<Document*>(castedThis->impl());
    imp->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
}

void setJSDocumentOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOninvalid(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOninvalid(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSDocumentOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchstart(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchmove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchmove(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchend(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchcancel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Document* imp = static_cast<Document*>(static_cast<JSDocument*>(thisObject)->impl());
    imp->setOntouchcancel(createJSAttributeEventListener(exec, value, thisObject));
}
#endif

JSValue JSDocument::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& tagName = valueToStringWithNullCheck(exec, exec->argument(0));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createElement(tagName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createDocumentFragment()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& data = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createTextNode(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& data = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createComment(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& data = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createCDATASection(data, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& target = ustringToString(exec->argument(0).toString(exec));
    const String& data = ustringToString(exec->argument(1).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createProcessingInstruction(target, data, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createAttribute(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEntityReference(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createEntityReference(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& tagname = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementsByTagName(tagname)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* importedNode = toNode(exec->argument(0));
    bool deep = exec->argument(1).toBoolean(exec);


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->importNode(importedNode, deep, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI = valueToStringWithNullCheck(exec, exec->argument(0));
    const String& qualifiedName = valueToStringWithNullCheck(exec, exec->argument(1));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createElementNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI = valueToStringWithNullCheck(exec, exec->argument(0));
    const String& qualifiedName = valueToStringWithNullCheck(exec, exec->argument(1));


    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(imp->createAttributeNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& namespaceURI = valueToStringWithNullCheck(exec, exec->argument(0));
    const String& localName = ustringToString(exec->argument(1).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& elementId = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementById(elementId)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* source = toNode(exec->argument(0));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->adoptNode(source, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& eventType = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createEvent(eventType, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createRange()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(exec->argument(0));
    unsigned whatToShow = exec->argument(1).toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(exec->argument(2));
    bool expandEntityReferences = exec->argument(3).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createNodeIterator(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* root = toNode(exec->argument(0));
    unsigned whatToShow = exec->argument(1).toInt32(exec);
    RefPtr<NodeFilter> filter = toNodeFilter(exec->argument(2));
    bool expandEntityReferences = exec->argument(3).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createTreeWalker(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    Element* element = toElement(exec->argument(0));
    const String& pseudoElement = ustringToString(exec->argument(1).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getOverrideStyle(element, pseudoElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression = ustringToString(exec->argument(0).toString(exec));
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(1));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    Node* nodeResolver = toNode(exec->argument(0));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createNSResolver(nodeResolver)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression = ustringToString(exec->argument(0).toString(exec));
    Node* contextNode = toNode(exec->argument(1));
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(2));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    unsigned short type = exec->argument(3).toInt32(exec);
    XPathResult* inResult = toXPathResult(exec->argument(4));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));
    bool userInterface = exec->argument(1).toBoolean(exec);
    const String& value = valueToStringWithUndefinedOrNullCheck(exec, exec->argument(2));


    JSC::JSValue result = jsBoolean(imp->execCommand(command, userInterface, value));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->queryCommandEnabled(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->queryCommandIndeterm(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->queryCommandState(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsBoolean(imp->queryCommandSupported(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& command = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = jsStringOrFalse(exec, imp->queryCommandValue(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& elementName = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementsByName(elementName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    int x = exec->argument(0).toInt32(exec);
    int y = exec->argument(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->elementFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    int x = exec->argument(0).toInt32(exec);
    int y = exec->argument(1).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->caretRangeFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getSelection()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& contextId = ustringToString(exec->argument(0).toString(exec));
    const String& name = ustringToString(exec->argument(1).toString(exec));
    int width = exec->argument(2).toInt32(exec);
    int height = exec->argument(3).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getCSSCanvasContext(contextId, name, width, height)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    const String& tagname = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getElementsByClassName(tagname)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& selectors = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = static_cast<JSDocument*>(asObject(thisValue));
    Document* imp = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& selectors = ustringToString(exec->argument(0).toString(exec));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

Document* toDocument(JSC::JSValue value)
{
    return value.inherits(&JSDocument::s_info) ? static_cast<JSDocument*>(asObject(value))->impl() : 0;
}

}
