/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBeforeProcessEvent.h"

#include "BeforeProcessEvent.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSBeforeProcessEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeProcessEventTableValues[3] =
{
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeProcessEventText), (intptr_t)setJSBeforeProcessEventText THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeProcessEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeProcessEventTable = { 4, 3, JSBeforeProcessEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeProcessEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeProcessEventConstructorTable = { 1, 0, JSBeforeProcessEventConstructorTableValues, 0 };
class JSBeforeProcessEventConstructor : public DOMConstructorObject {
public:
    JSBeforeProcessEventConstructor(JSC::ExecState*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSBeforeProcessEventConstructor::s_info = { "BeforeProcessEventConstructor", 0, &JSBeforeProcessEventConstructorTable, 0 };

JSBeforeProcessEventConstructor::JSBeforeProcessEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(JSBeforeProcessEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
{
    putDirect(exec->propertyNames().prototype, JSBeforeProcessEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSBeforeProcessEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBeforeProcessEventConstructor, DOMObject>(exec, &JSBeforeProcessEventConstructorTable, this, propertyName, slot);
}

bool JSBeforeProcessEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBeforeProcessEventConstructor, DOMObject>(exec, &JSBeforeProcessEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeProcessEventPrototypeTableValues[2] =
{
    { "initBeforeProcessEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsBeforeProcessEventPrototypeFunctionInitBeforeProcessEvent), (intptr_t)3 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeProcessEventPrototypeTable = { 2, 1, JSBeforeProcessEventPrototypeTableValues, 0 };
const ClassInfo JSBeforeProcessEventPrototype::s_info = { "BeforeProcessEventPrototype", 0, &JSBeforeProcessEventPrototypeTable, 0 };

JSObject* JSBeforeProcessEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBeforeProcessEvent>(exec, globalObject);
}

bool JSBeforeProcessEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSBeforeProcessEventPrototypeTable, this, propertyName, slot);
}

bool JSBeforeProcessEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSBeforeProcessEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSBeforeProcessEvent::s_info = { "BeforeProcessEvent", &JSEvent::s_info, &JSBeforeProcessEventTable, 0 };

JSBeforeProcessEvent::JSBeforeProcessEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<BeforeProcessEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSBeforeProcessEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSBeforeProcessEventPrototype(globalObject, JSBeforeProcessEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSBeforeProcessEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBeforeProcessEvent, Base>(exec, &JSBeforeProcessEventTable, this, propertyName, slot);
}

bool JSBeforeProcessEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBeforeProcessEvent, Base>(exec, &JSBeforeProcessEventTable, this, propertyName, descriptor);
}

JSValue jsBeforeProcessEventText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSBeforeProcessEvent* castedThis = static_cast<JSBeforeProcessEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    BeforeProcessEvent* imp = static_cast<BeforeProcessEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->text());
    return result;
}

JSValue jsBeforeProcessEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSBeforeProcessEvent* domObject = static_cast<JSBeforeProcessEvent*>(asObject(slotBase));
    return JSBeforeProcessEvent::getConstructor(exec, domObject->globalObject());
}
void JSBeforeProcessEvent::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSBeforeProcessEvent, Base>(exec, propertyName, value, &JSBeforeProcessEventTable, this, slot);
}

void setJSBeforeProcessEventText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSBeforeProcessEvent* castedThis = static_cast<JSBeforeProcessEvent*>(thisObject);
    BeforeProcessEvent* imp = static_cast<BeforeProcessEvent*>(castedThis->impl());
    imp->setText(ustringToString(value.toString(exec)));
}

JSValue JSBeforeProcessEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBeforeProcessEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsBeforeProcessEventPrototypeFunctionInitBeforeProcessEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSBeforeProcessEvent::s_info))
        return throwVMTypeError(exec);
    JSBeforeProcessEvent* castedThis = static_cast<JSBeforeProcessEvent*>(asObject(thisValue));
    BeforeProcessEvent* imp = static_cast<BeforeProcessEvent*>(castedThis->impl());
    const String& type = ustringToString(exec->argument(0).toString(exec));
    bool canBubble = exec->argument(1).toBoolean(exec);
    bool cancelable = exec->argument(2).toBoolean(exec);

    imp->initBeforeProcessEvent(type, canBubble, cancelable);
    return JSValue::encode(jsUndefined());
}


}
