/* Copyright (C) 2007 Alejandro Álvarez
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA. 
 */

#ifndef __CODEEDIT_H__
#define __CODEEDIT_H__

#include <QTextEdit>
#include <QMenu>
#include <QTextCursor>
#include "syntax.h"
#include <QCompleter>
#include <QStringListModel>
#include <QTimer>
#include "config.h"

/**TextEdit that supports highlited syntax and autocompletion.*/
class CodeEdit: public QTextEdit
{
  Q_OBJECT;
  bool auto_indent;
  QCompleter completion;
  QStringListModel *completion_model;
  QTimer braketsTimer;

  bool context_changed_ok;
  
  //Editor properties
  
  /**Automatic indention for while, if, for, switch, do and try statements.*/
  bool automatic_indention_statement_ok;
  /**Auto completion*/
  bool autocompletion_ok;
   /**Brackets Macth*/
  bool brakets_match_ok;

 protected:
  Syntax *syntax;
  QMenu  contextMenu;

  void contextMenuEvent(QContextMenuEvent *e);
  bool event( QEvent * e );

 public slots:
  void undo();
  void redo();
  void deleteSelection();
  void toggleBreakpoint();
  void braketsMatch();
  void cursorChanged_cb();
  void buildAutoCompletionList(int pos, int charsRemoved, int charsAdded );
  void doCompletion(const QModelIndex &index);

 public:
  CodeEdit(QWidget *parent = 0, QString syntaxF = QString());
  ~CodeEdit();
  void setAutoindent(bool ai_ok);
  bool getAutoindent();
  
  bool getbraketsMatchOk();

 signals:
  void toggleBreakpoint(int lineno);
  
  /**Dinamic help required.*/
  void dynamic_help_required(const QString &text);
};

#endif
