#ifndef SSTVPARAM_H
#define SSTVPARAM_H

#include "debugger.h"

#define NUMBEROFRXMODES 11
#define NUMBEROFTXMODES 11


#define NUMBEROFSTATES 18

#define REDLINE 0
#define GREENLINE 1
#define BLUELINE 2
#define VIDEOBW 800 

#define MAXLINES 500




enum ecolorScheme{RGB,GBR,GBR2,XYZOE,XYZOE2};

extern const char *RXModesText[NUMBEROFRXMODES];
extern const char *TXModesText[NUMBEROFTXMODES];
extern const char *stateString[NUMSTATES];
extern const char *faxStateString[NUMFAXSTATES];
struct sSSTVParam;
extern sSSTVParam SSTVTable[NUMBEROFRXMODES];
extern sSSTVParam sstvparam;
extern double lineTimeTable[MAXLINES+1];
void setupLineTimeTable(unsigned short int t);


int initializeParamString(const char *s);
int initializeParamCode(unsigned int viscode);
int initializeTable(unsigned int t);
unsigned int lookupModeString(const char *s);
unsigned int lookupModeCode(unsigned int x);
const char* getMode(unsigned int t);
int modeLookup(float lineLength);
eTxRxState getNextState(eTxRxState OldState);



struct sTimeFreq
{
  double t;            // time in sec
  double dt;           // minimum duration in sec
  unsigned int f;     // frequency to detect (freq=0 if any freq)
};


struct sSSTVParam
{
  char name[20];
  char shortName[10];
  sTimeFreq hs;     // horz. sync used by PHASET1
  sTimeFreq bp;     // backporch          PHASET2  
  sTimeFreq f1;     // f1 or blanking 1   PHASET9
  sTimeFreq f2;     // f2 or blanking 2   PHASETA
  sTimeFreq f3;     // f3                 PHASETB
  sTimeFreq f4;     // f4                 PHASETC
  sTimeFreq f5;      // f5                PHASETD
  sTimeFreq fp;     //frontporch          PHASETE
  double imageTime;
  unsigned short int numberOfPixels; // NumberOfPixels per Line
  unsigned short int numberOfLines;
  unsigned short int VISCode;
  ecolorScheme colorScheme;
  enum eTxRxState  a[NUMBEROFSTATES];
};

inline eTxRxState getNextState(eTxRxState OldState)
{
  return sstvparam.a[OldState];
}

#endif





