#ifndef _ACAP_COMMANDS
#define _ACAP_COMMANDS

#include "acap_options.h"

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

#define MAX_VALUE_LEN 65535
#define MAX_PATH_LEN 255
#define MAX_ATTRIB_LEN 255
#define MAX_AUTHTYPE_LEN 20
#define MAX_AUTHPARAM_LEN 255

typedef enum {NonAuth, Auth, Logout} AcapState;
AcapState acap_state;

typedef struct {
  char entrypath[MAX_PATH_LEN+1];
  char attribute[MAX_ATTRIB_LEN+1];
  char value[MAX_VALUE_LEN+1];
} StoreStruct;

typedef struct {
  char entrypath[MAX_PATH_LEN+1];
  char attribute[MAX_ATTRIB_LEN+1];
} SearchStruct;

typedef struct {
  char type[MAX_AUTHTYPE_LEN+1];
  char param[MAX_AUTHPARAM_LEN+1];
} AuthStruct;

typedef enum {CommandDone, CommandMore, CommandContinue} CommandResult;

char command_result[MAX_VALUE_LEN+1];

void
acapCommandsInit();

CommandResult
acapStore(char *tag, StoreStruct *data);

CommandResult
acapSearch(char *tag, SearchStruct *data);

CommandResult
acapAuth(char *tag, AuthStruct *data);

CommandResult
acapAuthCont(char *tag, AuthStruct *data);

CommandResult
commandMore(char *tag);

#endif
