/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.r3.Transform;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import king.KMessage;
import king.KingMain;
import king.ParaPoint;
import king.ToolBox;
import king.ToolServices;
import king.core.Engine;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KList;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.Kinemage;
import king.core.Transformable;
import king.points.LabelPoint;
import king.points.MarkerPoint;
import king.points.TrianglePoint;
import king.points.VectorPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaParams
implements KMessage.Subscriber,
Transformable {
    KingMain kMain;
    Kinemage kin;
    int numDim;
    double[] min;
    double[] max;
    double[] range;
    KView normalView;
    KView parallelView;
    boolean inParallelMode = false;
    boolean isUpdating = false;
    KGroup axisGroup = null;
    Map<KList, ArrayList<KPoint>> normalChildren;
    Map<KList, ArrayList<KPoint>> parallelChildren;

    public ParaParams(KingMain kingMain, Kinemage kinemage) {
        this.kMain = kingMain;
        this.kin = kinemage;
        this.numDim = Math.max(2, kinemage.dimensionNames.size());
        this.min = new double[this.numDim];
        this.max = new double[this.numDim];
        this.range = new double[this.numDim];
        List<Number> list = kinemage.dimensionMinMax;
        for (int i = 0; i < this.numDim; ++i) {
            this.min[i] = list.size() > 2 * i ? list.get(2 * i).doubleValue() : 0.0;
            this.max[i] = list.size() > 2 * i + 1 ? list.get(2 * i + 1).doubleValue() : 360.0;
            this.range[i] = this.max[i] - this.min[i];
        }
        this.normalChildren = new HashMap<KList, ArrayList<KPoint>>();
        this.parallelChildren = new HashMap<KList, ArrayList<KPoint>>();
        this.normalView = new KView(kinemage);
        this.parallelView = new KView(kinemage);
        this.parallelView.setCenter(0.5f, 0.5f, 0.0f);
        this.parallelView.setSpan(1.2f);
        this.parallelView.setName("PC Overview");
        kinemage.addView(this.parallelView.clone());
        kingMain.subscribe(new KMessage.WeakSubscriber(kingMain, this));
        ToolBox toolBox = kingMain.getCanvas().getToolBox();
        toolBox.transformables.add(new WeakTransformable(toolBox, this));
    }

    public double getMin(int n) {
        return this.min[n];
    }

    public double getMax(int n) {
        return this.max[n];
    }

    public double getRange(int n) {
        return this.range[n];
    }

    public int getNumDim() {
        return this.numDim;
    }

    public void swap() {
        if (this.inParallelMode) {
            this.fromParallelCoords();
        } else {
            this.toParallelCoords();
        }
    }

    public void toParallelCoords() {
        if (this.inParallelMode) {
            return;
        }
        this.isUpdating = true;
        this.normalChildren.clear();
        for (KList kList : KIterator.allLists(this.kin)) {
            ArrayList<KPoint> arrayList = this.parallelChildren.get(kList);
            if (arrayList == null) {
                arrayList = this.makeParallelPlot(kList);
                this.parallelChildren.put(kList, arrayList);
            }
            this.normalChildren.put(kList, kList.getChildren());
            kList.setChildren(arrayList);
        }
        this.makeParallelAxes();
        this.normalView = this.kMain.getCanvas().getCurrentView(this.kin);
        this.parallelView.setViewingAxes(this.normalView.getViewingAxes());
        this.kMain.getCanvas().setCurrentView(this.parallelView);
        this.inParallelMode = true;
        this.isUpdating = false;
    }

    public void fromParallelCoords() {
        Cloneable cloneable2;
        if (!this.inParallelMode) {
            return;
        }
        this.isUpdating = true;
        this.parallelChildren.clear();
        for (Cloneable cloneable2 : KIterator.allLists(this.kin)) {
            ArrayList<KPoint> arrayList = this.normalChildren.get(cloneable2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.normalChildren.put((KList)cloneable2, arrayList);
            }
            this.parallelChildren.put((KList)cloneable2, cloneable2.getChildren());
            cloneable2.setChildren(arrayList);
        }
        this.parallelView = this.kMain.getCanvas().getCurrentView(this.kin);
        this.normalView.setViewingAxes(this.parallelView.getViewingAxes());
        this.kMain.getCanvas().setCurrentView(this.kin, this.normalView);
        this.inParallelMode = false;
        ToolServices toolServices = this.kMain.getCanvas().getToolBox().services;
        cloneable2 = toolServices.getLastPicked(0);
        if (cloneable2 != null && cloneable2 instanceof ParaPoint) {
            toolServices.pick(((ParaPoint)cloneable2).proxyFor);
        }
        this.isUpdating = false;
    }

    ArrayList<KPoint> makeParallelPlot(KList kList) {
        ArrayList<KPoint> arrayList = new ArrayList<KPoint>();
        for (KPoint kPoint : kList) {
            float[] fArray = kPoint.getAllCoords();
            if (fArray == null || kPoint instanceof MarkerPoint || kPoint instanceof VectorPoint || kPoint instanceof TrianglePoint) continue;
            ParaPoint paraPoint = null;
            for (int i = 0; i < fArray.length; ++i) {
                ParaPoint paraPoint2 = new ParaPoint(kPoint, i, paraPoint, this);
                arrayList.add(paraPoint2);
                paraPoint = paraPoint2;
            }
        }
        return arrayList;
    }

    void makeParallelAxes() {
        boolean bl;
        boolean bl2 = bl = this.axisGroup == null || this.axisGroup.getKinemage() == null;
        if (bl) {
            this.axisGroup = new KGroup("PC axes");
            this.kin.add(this.axisGroup);
        } else {
            this.axisGroup.clear();
        }
        KGroup kGroup = new KGroup("");
        kGroup.setHasButton(false);
        this.axisGroup.add(kGroup);
        KList kList = new KList("vector", "axes");
        kList.setColor(KPalette.white);
        kGroup.add(kList);
        KList kList2 = new KList("label", "labels");
        kList2.setColor(KPalette.white);
        kGroup.add(kList2);
        String[] stringArray = this.kin.dimensionNames.toArray(new String[this.numDim]);
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        for (int i = 0; i < this.numDim; ++i) {
            VectorPoint vectorPoint = new VectorPoint("", null);
            vectorPoint.setXYZ((double)i / (double)(this.numDim - 1), 0.0, 0.0);
            vectorPoint.setUnpickable(true);
            kList.add(vectorPoint);
            VectorPoint vectorPoint2 = new VectorPoint("", vectorPoint);
            vectorPoint2.setXYZ((double)i / (double)(this.numDim - 1), 1.0, 0.0);
            vectorPoint2.setUnpickable(true);
            kList.add(vectorPoint2);
            LabelPoint labelPoint = new LabelPoint(stringArray[i]);
            labelPoint.setXYZ((double)i / (double)(this.numDim - 1), 1.05, 0.0);
            labelPoint.setUnpickable(true);
            labelPoint.setHorizontalAlignment(0x800000);
            kList2.add(labelPoint);
            labelPoint = new LabelPoint(decimalFormat.format(this.max[i]));
            labelPoint.setXYZ((double)i / (double)(this.numDim - 1), 1.02, 0.0);
            labelPoint.setUnpickable(true);
            labelPoint.setHorizontalAlignment(0x800000);
            kList2.add(labelPoint);
            labelPoint = new LabelPoint(decimalFormat.format(this.min[i]));
            labelPoint.setXYZ((double)i / (double)(this.numDim - 1), -0.03, 0.0);
            labelPoint.setUnpickable(true);
            labelPoint.setHorizontalAlignment(0x800000);
            kList2.add(labelPoint);
        }
    }

    @Override
    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(32L)) {
            this.fromParallelCoords();
        }
        if (kMessage.testKin(256) && !this.isUpdating && !this.inParallelMode) {
            this.parallelChildren.clear();
        }
    }

    @Override
    public void doTransform(Engine engine, Transform transform) {
        if (this.kMain.getKinemage() != this.kin) {
            return;
        }
        if (!this.inParallelMode) {
            return;
        }
        ToolServices toolServices = this.kMain.getCanvas().getToolBox().services;
        if (!toolServices.doMarkers.isSelected()) {
            return;
        }
        KPoint kPoint = toolServices.getLastPicked(0);
        if (kPoint == null) {
            return;
        }
        if (kPoint instanceof ParaPoint) {
            kPoint = ((ParaPoint)kPoint).proxyFor;
        }
        KList kList = new KList("vector");
        kList.setWidth(4);
        if (engine.whiteBackground) {
            kList.setColor(KPalette.deadblack);
        } else {
            kList.setColor(KPalette.deadwhite);
        }
        VectorPoint vectorPoint = null;
        for (KPoint kPoint2 : this.parallelChildren.get(kPoint.getParent())) {
            if (((ParaPoint)kPoint2).proxyFor != kPoint) continue;
            VectorPoint vectorPoint2 = new VectorPoint(kPoint2.getName(), vectorPoint);
            vectorPoint2.setXYZ(kPoint2.getX(), kPoint2.getY(), kPoint2.getZ());
            kList.add(vectorPoint2);
            vectorPoint = vectorPoint2;
        }
        kList.doTransform(engine, transform);
    }

    static class WeakTransformable
    implements Transformable {
        WeakReference<Transformable> ref;
        ToolBox toolbox;

        public WeakTransformable(ToolBox toolBox, Transformable transformable) {
            this.toolbox = toolBox;
            this.ref = new WeakReference<Transformable>(transformable);
        }

        public void doTransform(Engine engine, Transform transform) {
            Transformable transformable = (Transformable)this.ref.get();
            if (transformable == null) {
                this.toolbox.transformables.remove(this);
            } else {
                transformable.doTransform(engine, transform);
            }
        }
    }
}

