/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.data.CheapSet;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.Residue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import molikin.Bond;

public class Util {
    static String mcPattern = ".N[ T].|.C[A ].|.O .|.OXT|[^2][HDQ][A ] |.[HDQ].['*]|.P  |.O[123]P|.[CO][1-5]['*]| CM2|.OP[123]|H.''";
    static Matcher mcMatcher = null;
    static String waterPattern = "HOH|DOD|H20|D20|WAT|SOL|TIP|TP3|MTO|HOD|DOH";
    static Matcher waterMatcher = null;
    static String protPattern = "GLY|ALA|VAL|PHE|PRO|MET|ILE|LEU|ASP|GLU|LYS|ARG|SER|THR|TYR|HIS|CYS|ASN|GLN|TRP|ASX|GLX|ACE|FOR|NH2|NME|MSE|AIB|ABU|PCA|MLY|CYO|M31";
    static Matcher protMatcher = null;
    static String nucacidPattern = "  C|  G|  A|  T|  U|CYT|GUA|ADE|THY|URA|URI|CTP|CDP|CMP|GTP|GDP|GMP|ATP|ADP|AMP|TTP|TDP|TMP|UTP|UDP|UMP|GSP|H2U|PSU|1MG|2MG|M2G|5MC|5MU|T6A|1MA|RIA|OMC|OMG| YG|  I|7MG|C  |G  |A  |T  |U  |YG |I  | DG| DC| DA| DT|DG|DC|DA|DT|C|G|A|T|U|YG|I";
    static Matcher nucacidMatcher = null;
    static String ionPattern = " *(?:HE|LI|BE|F|NE|NA|MG|P|S|CL|AR|K|CA|CR|MN|FE|CO|NI|CU|ZN|GA|AS|SE|BR|KR|RB|SR|MO|RU|RH|PD|AG|CD|SN|I|XE|CS|BA|W|RE|OS|IR|PT|AU|HG|TL|PB|BI|RN|FR|RA|U|PU) *";
    static Matcher ionMatcher = null;
    static Map elementColors = null;
    static Map exVdwRadii = null;

    private Util() {
    }

    public static Collection extractOrderedStatesByName(Model model) {
        return Model.extractOrderedStatesByName(model);
    }

    public static Collection extractOrderedStatesByName(Collection collection, Collection collection2) {
        return Model.extractOrderedStatesByName(collection, collection2);
    }

    public static boolean altsAreCompatible(AtomState atomState, AtomState atomState2) {
        String string;
        String string2 = atomState.getAltConf();
        return string2.equals(string = atomState2.getAltConf()) || string2.equals(" ") || string.equals(" ");
    }

    public static boolean isMainchain(AtomState atomState) {
        if (mcMatcher == null) {
            mcMatcher = Pattern.compile(mcPattern).matcher("");
        }
        mcMatcher.reset(atomState.getName());
        return mcMatcher.matches();
    }

    public static boolean isWater(AtomState atomState) {
        return Util.isWater(atomState.getResidue());
    }

    public static boolean isWater(Residue residue) {
        if (waterMatcher == null) {
            waterMatcher = Pattern.compile(waterPattern).matcher("");
        }
        waterMatcher.reset(residue.getName());
        return waterMatcher.matches();
    }

    public static boolean isProtein(Residue residue) {
        if (protMatcher == null) {
            protMatcher = Pattern.compile(protPattern).matcher("");
        }
        protMatcher.reset(residue.getName());
        return protMatcher.matches() || residue.getAtom(" CA ") != null;
    }

    public static boolean isNucleicAcid(Residue residue) {
        if (nucacidMatcher == null) {
            nucacidMatcher = Pattern.compile(nucacidPattern).matcher("");
        }
        nucacidMatcher.reset(residue.getName());
        return nucacidMatcher.matches();
    }

    public static boolean isIon(Residue residue) {
        if (ionMatcher == null) {
            ionMatcher = Pattern.compile(ionPattern).matcher("");
        }
        ionMatcher.reset(residue.getName());
        return ionMatcher.matches();
    }

    public static String getElementColor(String string) {
        String string2;
        if (elementColors == null) {
            elementColors = new HashMap();
            elementColors.put("H", "gray");
            elementColors.put("C", "white");
            elementColors.put("N", "sky");
            elementColors.put("O", "red");
            elementColors.put("S", "yellow");
            elementColors.put("P", "gold");
            elementColors.put("HE", "pinktint");
            elementColors.put("LI", "brown");
            elementColors.put("B", "green");
            elementColors.put("F", "orange");
            elementColors.put("NA", "blue");
            elementColors.put("MG", "greentint");
            elementColors.put("AL", "gray");
            elementColors.put("SI", "gold");
            elementColors.put("CL", "green");
            elementColors.put("CA", "gray");
            elementColors.put("TI", "gray");
            elementColors.put("CR", "gray");
            elementColors.put("MN", "gray");
            elementColors.put("FE", "orange");
            elementColors.put("NI", "brown");
            elementColors.put("CU", "brown");
            elementColors.put("ZN", "brown");
            elementColors.put("BR", "brown");
            elementColors.put("AG", "gray");
            elementColors.put("I", "bluetint");
            elementColors.put("BA", "orange");
            elementColors.put("AU", "gold");
        }
        if ((string2 = (String)elementColors.get(string)) == null) {
            return "hotpink";
        }
        return string2;
    }

    public static double getVdwRadius(String string) {
        Double d;
        if (exVdwRadii == null) {
            exVdwRadii = new HashMap();
            exVdwRadii.put("H".toUpperCase(), new Double(1.17));
            exVdwRadii.put("C".toUpperCase(), new Double(1.75));
            exVdwRadii.put("N".toUpperCase(), new Double(1.55));
            exVdwRadii.put("O".toUpperCase(), new Double(1.4));
            exVdwRadii.put("P".toUpperCase(), new Double(1.8));
            exVdwRadii.put("S".toUpperCase(), new Double(1.8));
            exVdwRadii.put("As".toUpperCase(), new Double(2.0));
            exVdwRadii.put("Se".toUpperCase(), new Double(1.9));
            exVdwRadii.put("F".toUpperCase(), new Double(1.3));
            exVdwRadii.put("Cl".toUpperCase(), new Double(1.77));
            exVdwRadii.put("Br".toUpperCase(), new Double(1.95));
            exVdwRadii.put("I".toUpperCase(), new Double(2.1));
            exVdwRadii.put("Li".toUpperCase(), new Double(0.6));
            exVdwRadii.put("Na".toUpperCase(), new Double(0.95));
            exVdwRadii.put("Al".toUpperCase(), new Double(0.5));
            exVdwRadii.put("K".toUpperCase(), new Double(1.33));
            exVdwRadii.put("Mg".toUpperCase(), new Double(0.65));
            exVdwRadii.put("Ca".toUpperCase(), new Double(0.99));
            exVdwRadii.put("Mn".toUpperCase(), new Double(0.8));
            exVdwRadii.put("Fe".toUpperCase(), new Double(0.74));
            exVdwRadii.put("Co".toUpperCase(), new Double(0.7));
            exVdwRadii.put("Ni".toUpperCase(), new Double(0.66));
            exVdwRadii.put("Cu".toUpperCase(), new Double(0.72));
            exVdwRadii.put("Zn".toUpperCase(), new Double(0.71));
            exVdwRadii.put("Rb".toUpperCase(), new Double(1.48));
            exVdwRadii.put("Sr".toUpperCase(), new Double(1.1));
            exVdwRadii.put("Mo".toUpperCase(), new Double(0.93));
            exVdwRadii.put("Ag".toUpperCase(), new Double(1.26));
            exVdwRadii.put("Cd".toUpperCase(), new Double(0.91));
            exVdwRadii.put("In".toUpperCase(), new Double(0.81));
            exVdwRadii.put("Cs".toUpperCase(), new Double(1.69));
            exVdwRadii.put("Ba".toUpperCase(), new Double(1.29));
            exVdwRadii.put("Au".toUpperCase(), new Double(1.1));
            exVdwRadii.put("Hg".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Tl".toUpperCase(), new Double(1.44));
            exVdwRadii.put("Pb".toUpperCase(), new Double(0.84));
            exVdwRadii.put("V".toUpperCase(), new Double(0.79));
            exVdwRadii.put("Cr".toUpperCase(), new Double(0.73));
            exVdwRadii.put("Te".toUpperCase(), new Double(0.97));
            exVdwRadii.put("Sm".toUpperCase(), new Double(1.08));
            exVdwRadii.put("Gd".toUpperCase(), new Double(1.05));
            exVdwRadii.put("Yb".toUpperCase(), new Double(1.14));
            exVdwRadii.put("W".toUpperCase(), new Double(0.66));
            exVdwRadii.put("Pt".toUpperCase(), new Double(0.63));
            exVdwRadii.put("U".toUpperCase(), new Double(1.03));
            exVdwRadii.put("He".toUpperCase(), new Double(1.6));
            exVdwRadii.put("Be".toUpperCase(), new Double(0.31));
            exVdwRadii.put("B".toUpperCase(), new Double(0.2));
            exVdwRadii.put("Ne".toUpperCase(), new Double(1.6));
            exVdwRadii.put("Si".toUpperCase(), new Double(2.1));
            exVdwRadii.put("Ar".toUpperCase(), new Double(1.89));
            exVdwRadii.put("Sc".toUpperCase(), new Double(0.68));
            exVdwRadii.put("Ti".toUpperCase(), new Double(0.75));
            exVdwRadii.put("Ga".toUpperCase(), new Double(0.53));
            exVdwRadii.put("Ge".toUpperCase(), new Double(0.6));
            exVdwRadii.put("Kr".toUpperCase(), new Double(2.01));
            exVdwRadii.put("Y".toUpperCase(), new Double(0.9));
            exVdwRadii.put("Zr".toUpperCase(), new Double(0.77));
            exVdwRadii.put("Sn".toUpperCase(), new Double(0.71));
            exVdwRadii.put("Sb".toUpperCase(), new Double(2.2));
            exVdwRadii.put("Xe".toUpperCase(), new Double(2.18));
            exVdwRadii.put("La".toUpperCase(), new Double(1.03));
            exVdwRadii.put("Ce".toUpperCase(), new Double(0.87));
            exVdwRadii.put("Fr".toUpperCase(), new Double(1.94));
            exVdwRadii.put("Ra".toUpperCase(), new Double(1.62));
            exVdwRadii.put("Th".toUpperCase(), new Double(1.08));
            exVdwRadii.put("Nb".toUpperCase(), new Double(0.86));
            exVdwRadii.put("Tc".toUpperCase(), new Double(0.71));
            exVdwRadii.put("Ru".toUpperCase(), new Double(0.82));
            exVdwRadii.put("Rh".toUpperCase(), new Double(0.76));
            exVdwRadii.put("Pd".toUpperCase(), new Double(1.05));
            exVdwRadii.put("Pr".toUpperCase(), new Double(1.11));
            exVdwRadii.put("Nd".toUpperCase(), new Double(1.1));
            exVdwRadii.put("Pm".toUpperCase(), new Double(1.15));
            exVdwRadii.put("Eu".toUpperCase(), new Double(1.31));
            exVdwRadii.put("Tb".toUpperCase(), new Double(1.05));
            exVdwRadii.put("Dy".toUpperCase(), new Double(1.05));
            exVdwRadii.put("Ho".toUpperCase(), new Double(1.04));
            exVdwRadii.put("Er".toUpperCase(), new Double(1.03));
            exVdwRadii.put("Tm".toUpperCase(), new Double(1.02));
            exVdwRadii.put("Lu".toUpperCase(), new Double(1.02));
            exVdwRadii.put("Hf".toUpperCase(), new Double(0.85));
            exVdwRadii.put("Ta".toUpperCase(), new Double(0.86));
            exVdwRadii.put("Re".toUpperCase(), new Double(0.77));
            exVdwRadii.put("Os".toUpperCase(), new Double(0.78));
            exVdwRadii.put("Ir".toUpperCase(), new Double(0.8));
            exVdwRadii.put("Bi".toUpperCase(), new Double(1.17));
            exVdwRadii.put("Po".toUpperCase(), new Double(0.99));
            exVdwRadii.put("At".toUpperCase(), new Double(0.91));
            exVdwRadii.put("Rn".toUpperCase(), new Double(2.5));
            exVdwRadii.put("Ac".toUpperCase(), new Double(1.3));
            exVdwRadii.put("Pa".toUpperCase(), new Double(1.1));
            exVdwRadii.put("Np".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Pu".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Am".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Cm".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Bk".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Cf".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Es".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Fm".toUpperCase(), new Double(1.0));
            exVdwRadii.put("Md".toUpperCase(), new Double(1.0));
            exVdwRadii.put("No".toUpperCase(), new Double(1.0));
        }
        if ((d = (Double)exVdwRadii.get(string)) == null) {
            return 2.0;
        }
        return d;
    }

    public static Collection selectBondsBetween(Collection collection, Set set, Set set2, Set set3, Set set4, Collection arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<Bond>();
        }
        for (Bond bond : collection) {
            boolean bl;
            boolean bl2 = !((set3 != null && !set3.contains(bond.lower.getResidue()) || set4 != null && !set4.contains(bond.higher.getResidue())) && (set4 != null && !set4.contains(bond.lower.getResidue()) || set3 != null && !set3.contains(bond.higher.getResidue())));
            if (!bl2) continue;
            boolean bl3 = bl = !((set != null && !set.contains(bond.lower) || set2 != null && !set2.contains(bond.higher)) && (set2 != null && !set2.contains(bond.lower) || set != null && !set.contains(bond.higher)));
            if (!bl) continue;
            arrayList.add(bond);
        }
        return arrayList;
    }

    public static Set selectDisulfideResidues(Collection collection) {
        CheapSet cheapSet = new CheapSet();
        for (Bond bond : collection) {
            if (!bond.lower.getElement().equals("S") || !bond.higher.getElement().equals("S")) continue;
            cheapSet.add(bond.lower.getResidue());
            cheapSet.add(bond.higher.getResidue());
        }
        return cheapSet;
    }
}

