/*
 * Decompiled with CFR 0.152.
 */
package king.io;

import driftwood.util.ReflectiveRunnable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.zip.GZIPInputStream;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import king.io.KinfileParser;

public class KinfileLoader
implements ActionListener {
    InputStream input;
    Listener listener;
    Thread thread;
    Timer timer;
    KinfileParser parser;
    Throwable thrown = null;

    public KinfileLoader(InputStream inputStream, Listener listener) {
        this.input = inputStream;
        this.listener = listener;
        this.parser = new KinfileParser();
        this.timer = new Timer(1000, this);
        this.thread = new Thread(new ReflectiveRunnable(this, "backgroundWorker"));
        this.thread.setDaemon(true);
        this.timer.start();
        this.thread.start();
    }

    public void backgroundWorker() {
        try {
            this.input = new BufferedInputStream(this.input);
            this.input.mark(10);
            if (this.input.read() == 31 && this.input.read() == 139) {
                this.input.reset();
                this.input = new GZIPInputStream(this.input);
            } else {
                this.input.reset();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.input));
            this.parser.parse(lineNumberReader);
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "successCallback"));
            lineNumberReader.close();
        }
        catch (Throwable throwable) {
            this.thrown = throwable;
            SwingUtilities.invokeLater(new ReflectiveRunnable(this, "errorCallback"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.listener.updateProgress(this.parser.getCharsRead());
    }

    public void successCallback() {
        this.timer.stop();
        this.listener.loadingComplete(this.parser);
        this.parser = null;
    }

    public void errorCallback() {
        this.timer.stop();
        this.listener.loadingException(this.thrown);
        this.parser = null;
        this.thrown = null;
    }

    public static interface Listener {
        public void updateProgress(long var1);

        public void loadingException(Throwable var1);

        public void loadingComplete(KinfileParser var1);
    }
}

