/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.r3.Transform;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import king.KingMain;
import king.ToolBox;
import king.core.Engine;
import king.core.Engine2D;
import king.core.KView;
import king.core.Kinemage;
import king.core.Transformable;
import king.painters.JoglPainter;

public class JoglCanvas
extends JPanel
implements GLEventListener,
Transformable,
MouseListener {
    KingMain kMain;
    Engine2D engine;
    ToolBox toolbox;
    GLCanvas canvas;
    Dimension glSize = new Dimension();
    WritableRaster raster = null;
    BufferedImage overlayImg = null;
    ByteBuffer overlayData = null;
    Image logo = null;

    public JoglCanvas(KingMain kingMain, Engine2D engine2D, ToolBox toolBox) {
        super(new BorderLayout());
        this.kMain = kingMain;
        this.engine = engine2D;
        this.toolbox = toolBox;
        this.logo = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/king-logo.gif"));
        this.logo = new ImageIcon(this.getClass().getResource("images/king-logo.gif")).getImage();
        kingMain.getFileDropHandler().handleDropsFor(this);
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(true);
        int n = kingMain.getPrefs().getInt("joglNumSamples");
        gLCapabilities.setSampleBuffers(n > 1);
        gLCapabilities.setNumSamples(n);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        toolBox.listenTo((Component)this.canvas);
        this.add((Component)this.canvas, "Center");
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            Graphics2D graphics2D = this.setupOverlay();
            Dimension dimension = this.glSize;
            gL.glRasterPos2d(0.0, (double)(-dimension.height));
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            if (this.logo != null) {
                graphics2D.drawImage(this.logo, (dimension.width - this.logo.getWidth(this)) / 2, (dimension.height - this.logo.getHeight(this)) / 2, this);
            }
            if (this.kMain.getPrefs().newerVersionAvailable()) {
                this.announceNewVersion(graphics2D);
            }
            graphics2D.dispose();
            gL.glDrawPixels(dimension.width, dimension.height, 6408, 5121, (Buffer)this.getOverlayBytes());
        } else {
            JoglPainter joglPainter = new JoglPainter(gLAutoDrawable);
            long l = System.currentTimeMillis();
            KView kView = this.kMain.getView();
            Rectangle rectangle = new Rectangle(this.glSize);
            this.kMain.getCanvas().syncToKin(this.engine, kinemage);
            this.engine.render(this, kView, rectangle, joglPainter);
            if (this.toolbox != null) {
                this.toolbox.overpaintCanvas(joglPainter);
            }
            l = System.currentTimeMillis() - l;
            if (this.kMain.getCanvas().writeFPS) {
                SoftLog.err.println(l + " ms (" + (l > 0L ? Long.toString(1000L / l) : ">1000") + " FPS) - " + this.engine.getNumberPainted() + " objects painted");
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        GLU gLU = new GLU();
        this.glSize.setSize(n3, n4);
        gL.glViewport(0, 0, n3, n4);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gLU.gluOrtho2D(0.0, (double)n3, (double)(-n4), 0.0);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public Dimension getPreferredSize() {
        return this.kMain.getCanvas().getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.kMain.getCanvas().getMinimumSize();
    }

    public void requestRepaint(ActionEvent actionEvent) {
        this.canvas.repaint();
    }

    public void doTransform(Engine engine, Transform transform) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            return;
        }
        kinemage.doTransform(engine, transform);
        if (this.toolbox != null) {
            this.toolbox.doTransform(engine, transform);
        }
    }

    Graphics2D setupOverlay() {
        Object object;
        if (this.overlayImg == null || this.overlayImg.getWidth() != this.glSize.width || this.overlayImg.getHeight() != this.glSize.height) {
            this.overlayImg = new BufferedImage(this.glSize.width, this.glSize.height, 2);
            object = ((DataBufferInt)this.overlayImg.getRaster().getDataBuffer()).getData();
            this.overlayData = ByteBuffer.allocate(4 * ((Object)object).length);
        }
        object = this.overlayImg.createGraphics();
        int[] nArray = ((DataBufferInt)this.overlayImg.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(0.0, this.glSize.height);
        affineTransform.scale(1.0, -1.0);
        ((Graphics2D)object).transform(affineTransform);
        return object;
    }

    ByteBuffer getOverlayBytes() {
        this.overlayData.clear();
        int[] nArray = ((DataBufferInt)this.overlayImg.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            this.overlayData.put((byte)(n >> 16 & 0xFF));
            this.overlayData.put((byte)(n >> 8 & 0xFF));
            this.overlayData.put((byte)(n & 0xFF));
            this.overlayData.put((byte)(n >> 24 & 0xFF));
        }
        this.overlayData.rewind();
        return this.overlayData;
    }

    void announceNewVersion(Graphics2D graphics2D) {
        String string = "A new version of KiNG is now available";
        Dimension dimension = this.glSize;
        Font font = new Font("SansSerif", 1, 16);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.white);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        graphics2D.drawString(string, (dimension.width - (int)rectangle2D.getWidth()) / 2, (dimension.height - (int)rectangle2D.getHeight()) / 2 + 170);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

