//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_sliders_pad_proxies_column_hpp__
#define __INC_sliders_pad_proxies_column_hpp__

#include <QObject>

#include <wdg/sliders_pad_proxy.hpp>


// Forward declaration
namespace Wdg {
	class Sliders_Pad_Proxies_Group;
	class Sliders_Pad_Proxy_Slider;
	class Sliders_Pad_Proxy_Switch;
}

namespace Wdg
{


class Sliders_Pad_Proxies_Column :
	public QObject
{
	Q_OBJECT

	// Public methods
	public:

	Sliders_Pad_Proxies_Column (
		unsigned int col_idx_n = 0 );

	virtual
	~Sliders_Pad_Proxies_Column ( );


	Sliders_Pad_Proxies_Group *
	group ( ) const;


	// Column index

	unsigned int
	column_index ( ) const;

	void
	set_column_index (
		unsigned int idx_n );


	void
	clear_proxies ( );


	// Slider proxy

	Sliders_Pad_Proxy_Slider *
	slider_proxy ( ) const;

	void
	set_slider_proxy (
		Sliders_Pad_Proxy_Slider * proxy_n );


	// Switch proxy

	Sliders_Pad_Proxy_Switch *
	switch_proxy ( ) const;

	void
	set_switch_proxy (
		Sliders_Pad_Proxy_Switch * proxy_n );


	// Show value string

	void
	set_show_value_string (
		bool flag_n );

	bool
	show_value_string ( ) const;


	// State info

	bool
	has_slider ( ) const;

	bool
	has_switch ( ) const;

	bool
	has_focus ( ) const;


	// Value string

	virtual
	QString
	value_string ( ) const;

	virtual
	QString
	value_min_string ( ) const;

	virtual
	QString
	value_max_string ( ) const;


	// Event handling

	bool
	event (
		QEvent * event_n );


	// Signals
	signals:

	void
	sig_value_string_changed ( );


	// Protected methods
	protected:

	virtual
	void
	slider_proxy_changed ( );

	virtual
	void
	switch_proxy_changed ( );

	virtual
	void
	show_value_string_changed ( );


	// Private attributes
	private:

	unsigned int _column_index;
	::Wdg::Sliders_Pad_Proxy_Slider * _proxy_slider;
	::Wdg::Sliders_Pad_Proxy_Switch * _proxy_switch;
	bool _has_focus;
	bool _show_value_string;
};


inline
unsigned int
Sliders_Pad_Proxies_Column::column_index ( ) const
{
	return _column_index;
}


inline
::Wdg::Sliders_Pad_Proxy_Slider *
Sliders_Pad_Proxies_Column::slider_proxy ( ) const
{
	return _proxy_slider;
}


inline
::Wdg::Sliders_Pad_Proxy_Switch *
Sliders_Pad_Proxies_Column::switch_proxy ( ) const
{
	return _proxy_switch;
}


inline
bool
Sliders_Pad_Proxies_Column::has_slider ( ) const
{
	return ( _proxy_slider != 0 );
}


inline
bool
Sliders_Pad_Proxies_Column::has_switch ( ) const
{
	return ( _proxy_switch != 0 );
}


inline
bool
Sliders_Pad_Proxies_Column::show_value_string ( ) const
{
	return _show_value_string;
}


} // End of namespace


#endif
