//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_qsnd_control_address_hpp__
#define __INC_qsnd_control_address_hpp__

#include <qsnd/control_address_arg.hpp>
#include <QString>
#include <QList>


namespace QSnd
{


/// @brief Control_Address
///
class Control_Address
{
	// Public methods
	public:

	Control_Address (
		const char * ctl_str_n = 0 );

	Control_Address (
		const QString & ctl_str_n );


	void
	clear ( );

	bool
	is_clear ( ) const;


	// Control name

	const QString &
	ctl_name ( ) const;

	void
	set_ctl_name (
		const QString & name_n );


	// Control id string

	const QString &
	ctl_str ( ) const;

	void
	set_ctl_str (
		const QString & id_n );


	// Control arguments

	int
	num_args ( ) const;

	const Control_Address_Arg &
	arg (
		int idx_n ) const;

	void
	append_arg (
		const Control_Address_Arg & arg_n );

	void
	set_arg_value (
		int idx_n,
		const QString & value_n );

	void
	set_arg_value (
		const QString & arg_name_n,
		const QString & value_n );


	// Operators

	Control_Address &
	operator = (
		const Control_Address & cinfo_n );

	bool
	operator == (
		const Control_Address & cinfo_n ) const;

	bool
	operator != (
		const Control_Address & cinfo_n ) const;


	// Protected methods
	protected:

	void
	update_ctl_str ( );


	// Private attributes
	private:

	QString _ctl_name;
	QList < Control_Address_Arg > _arguments;
	QString _ctl_str;
};


inline
bool
Control_Address::is_clear ( ) const
{
	return _ctl_name.isEmpty();
}


inline
const QString &
Control_Address::ctl_name ( ) const
{
	return _ctl_name;
}


inline
int
Control_Address::num_args ( ) const
{
	return _arguments.size();
}


inline
const Control_Address_Arg &
Control_Address::arg (
	int idx_n ) const
{
	return _arguments[idx_n];
}


inline
const QString &
Control_Address::ctl_str ( ) const
{
	return _ctl_str;
}


} // End of namespace


#endif


