//
// C++ Implementation:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "control_address.hpp"


namespace QSnd
{


Control_Address::Control_Address (
	const char * ctl_str_n )
{
	if ( ctl_str_n != 0 ) {
		set_ctl_str ( QString ( ctl_str_n ) );
	}
}


Control_Address::Control_Address (
	const QString & ctl_str_n )
{
	if ( !ctl_str_n.isEmpty() ) {
		set_ctl_str ( ctl_str_n );
	}
}


void
Control_Address::clear ( )
{
	_ctl_name.clear();
	_arguments.clear();
	_ctl_str.clear();
}


void
Control_Address::set_ctl_name (
	const QString & name_n )
{
	_ctl_name = name_n;
	update_ctl_str();
}


void
Control_Address::set_ctl_str (
	const QString & id_n )
{
	clear();

	QString pstr ( id_n );

	int idx;
	idx = pstr.indexOf ( ':' );
	if ( idx < 0 ) {
		_ctl_name = id_n;
	} else if ( idx > 1 ) {
		_ctl_name = pstr.left ( idx );
		pstr = pstr.mid ( idx + 1 );

		QString arg_str;
		while ( !pstr.isEmpty() ) {
			idx = pstr.indexOf ( ',' );
			if ( idx < 0 ) {
				arg_str = pstr;
				pstr.clear();
			} else {
				arg_str = pstr.left ( idx );
				pstr = pstr.mid ( idx + 1 );
			}

			Control_Address_Arg argm;

			idx = arg_str.indexOf ( '=' );
			if ( idx < 0 ) {
				argm.arg_value = arg_str;
			} else {
				argm.arg_name = arg_str.left ( idx );
				argm.arg_value = arg_str.mid ( idx + 1 );
			}

			if ( !argm.arg_value.isEmpty() ) {
				_arguments.append ( argm );
			}
		}
	}

	update_ctl_str();
}


void
Control_Address::append_arg (
	const Control_Address_Arg & arg_n )
{
	_arguments.append ( arg_n );
	update_ctl_str();
}


void
Control_Address::set_arg_value (
	int idx_n,
	const QString & value_n )
{
	_arguments[idx_n].arg_value = value_n;
}


void
Control_Address::set_arg_value (
	const QString & arg_name_n,
	const QString & value_n )
{
	for ( int ii=0; ii < _arguments.size(); ++ii ) {
		Control_Address_Arg & argm ( _arguments[ii] );
		if ( argm.arg_name == arg_name_n ) {
			argm.arg_value = value_n;
			break;
		}
	}
}


void
Control_Address::update_ctl_str ( )
{
	_ctl_str = _ctl_name;
	if ( _arguments.size() > 0 ) {
		_ctl_str += ":";
		for ( int ii=0; ii < _arguments.size(); ++ii ) {
			const Control_Address_Arg & argm ( arg ( ii ) );
			if ( ii > 0 ) {
				_ctl_str += ",";
			}

			if ( !argm.arg_name.isEmpty() ) {
				_ctl_str += argm.arg_name;
				_ctl_str += "=";
			}
			_ctl_str += argm.arg_value;
		}
	}
}


Control_Address &
Control_Address::operator = (
	const Control_Address & cinfo_n )
{
	_ctl_name = cinfo_n.ctl_name();
	_arguments.clear();
	for ( int ii=0; ii < cinfo_n.num_args(); ++ii ) {
		_arguments.append ( cinfo_n.arg ( ii ) );
	}
	update_ctl_str();
	return *this;
}


bool
Control_Address::operator == (
	const Control_Address & cinfo_n ) const
{
	bool res = ( _ctl_name == cinfo_n.ctl_name() );
	res = res && ( num_args() == cinfo_n.num_args() );
	if ( res ) {
		for ( int ii=0; ii < cinfo_n.num_args(); ++ii ) {
			Control_Address_Arg arg1 ( arg ( ii ) );
			Control_Address_Arg arg2 ( cinfo_n.arg ( ii ) );
			if ( arg1.arg_value == arg2.arg_value ) {
				if ( ( !arg1.arg_name.isEmpty() ) &&
				     ( !arg2.arg_name.isEmpty() ) )
				{
					if ( arg1.arg_name != arg2.arg_name ) {
						res = false;
						break;
					}
				}
			} else {
				res = false;
				break;
			}
		}
	}
	return res;
}


bool
Control_Address::operator != (
	const Control_Address & cinfo_n ) const
{
	return !operator== ( cinfo_n );
}


} // End of namespace

