//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mixer_ctl_editor_hpp__
#define __INC_mixer_ctl_editor_hpp__

#include <QWidget>
#include <QLabel>
#include <QAbstractButton>
#include <QGridLayout>
#include <QLocale>
#include <QPalette>


// Forward declaration
namespace QSnd {
	class Mixer_CTL_Elem;
	class Mixer_CTL_Elem_Group;
}
namespace MWdg {
	class Mixer_CTL_Editor_Data;
	class Mixer_CTL_Proxies_Group;
	class Inputs_Setup;
}


namespace MWdg
{


/// @brief Mixer_CTL_Editor
///
class Mixer_CTL_Editor :
	public QWidget
{
	Q_OBJECT

	// Public typedefs
	public:


	// Public methods
	public:

	Mixer_CTL_Editor (
		Mixer_CTL_Editor_Data * data_n,
		QWidget * parent_n = 0 );

	~Mixer_CTL_Editor ( );


	// Editor data

	const Mixer_CTL_Editor_Data *
	editor_data ( ) const;

	Mixer_CTL_Editor_Data *
	editor_data ( );


	// Inputs setup

	const ::MWdg::Inputs_Setup *
	inputs_setup ( ) const;

	virtual
	void
	set_inputs_setup (
		const ::MWdg::Inputs_Setup * setup_n );


	virtual
	void
	update_proxies_values ( );


	QWidget *
	create_small_joined_switch (
		::MWdg::Mixer_CTL_Proxies_Group * pgroup_n,
		::QSnd::Mixer_CTL_Elem * elem_n );


	// Protected methods
	protected:

	unsigned int
	elem_style_id (
		const ::QSnd::Mixer_CTL_Elem * elem_n ) const;

	QGridLayout *
	create_channel_grid (
		const QList < QWidget * > & items_n,
		bool bold_labels_n = false );


	// Private attributes
	private:

	Mixer_CTL_Editor_Data * _editor_data;
	const ::MWdg::Inputs_Setup * _inputs_setup;
};


inline
const Mixer_CTL_Editor_Data *
Mixer_CTL_Editor::editor_data ( ) const
{
	return _editor_data;
}


inline
Mixer_CTL_Editor_Data *
Mixer_CTL_Editor::editor_data ( )
{
	return _editor_data;
}


inline
const ::MWdg::Inputs_Setup *
Mixer_CTL_Editor::inputs_setup ( ) const
{
	return _inputs_setup;
}


} // End of namespace


#endif
