//
// C++ Interface:
//
// Description:
//
//
// Author: Sebastian Holtermann <sebholt@xwmw.org>, (C) 2011
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __INC_mv_switcher_hpp__
#define __INC_mv_switcher_hpp__

#include <QWidget>
#include <QString>


// Forward declaration
class QTabBar;
namespace QSnd {
	class Control_Address;
}
namespace MView {
	class MV_Base;
	class MV_Base_Setup;
	class Switcher_Setup;
}


namespace MView
{


/// @brief A widget that switches betweeen MV_Base child widgets
///
class Switcher :
	public QWidget
{
	Q_OBJECT

	// Public methods
	public:

	Switcher (
		QWidget * parent_n = 0 );

	~Switcher ( );


	static
	unsigned int
	num_view_types ( );

	const QString &
	view_type_name (
		unsigned int type_n ) const;


	// Mixer setup

	void
	set_mixer_setup (
		::MView::Switcher_Setup * setup_n );

	void
	select_snd_ctl (
		const ::QSnd::Control_Address & ctl_n );


	bool
	eventFilter (
		QObject * obj_n,
		QEvent * event_n );


	// Signals
	signals:

	void
	sig_view_type_changed ( );

	void
	sig_show_vtype_select (
		bool flag_n );


	// Public slots
	public slots:

	// View type selection

	void
	select_view_simple_mixer ( );

	void
	select_view_element_mixer ( );

	void
	select_view_control_info ( );

	void
	select_view_type (
		unsigned int type_n );

	void
	select_view_type_int (
		int type_n );


	void
	reload_mdev_setup ( );

	void
	reload_inputs_setup ( );

	void
	reload_view_setup ( );


	void
	show_vtype_select (
		bool flag_n );

	void
	toggle_vtype_select ( );


	// Private methods
	private:

	void
	clear_view ( );

	void
	create_view ( );

	void
	update_tab_bar_vis ( );


	// Private attributes
	private:

	QTabBar * _tab_bar;
	::MView::Switcher_Setup * _mixer_setup;
	::MView::MV_Base * _view;
	::MView::MV_Base_Setup * _view_setup;

	// Strings
	static const unsigned int _num_view_types = 3;
	QString _vtype_names[_num_view_types];
};


inline
unsigned int
Switcher::num_view_types ( )
{
	return _num_view_types;
}


inline
const QString &
Switcher::view_type_name (
	unsigned int type_n ) const
{
	return _vtype_names[type_n];
}


} // End of namespace

#endif
